/*
 * Hotel Content API
 * # APItude Hotel Content API  Hotel Content API has been designed to retrieve **all the details** of the hotels available in our [Hotel Booking API](/documentation/hotels/booking-api/api-reference/).   Hotel Content API contains several methods that allow you to obtain the details of the hotels as well as list of destinations, countries and the master types that complement the hotels informatoin (like room type descriptions, accommodation type descriptions, categories descriptions...).  Note that the Languages operation is connected to all the operations in which a description is returned, since we return the language code in which that description has been returned. 
 *
 * The version of the OpenAPI document: 1.0
 * Contact: apitude@hotelbeds.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.hotelbeds.content.sdk.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.math.BigDecimal;
import travel.wink.hotelbeds.content.sdk.model.ApiContent;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Information on a hotel facility.
 */
@JsonPropertyOrder({
  ApiHotelFacility.JSON_PROPERTY_AGE_FROM,
  ApiHotelFacility.JSON_PROPERTY_AGE_TO,
  ApiHotelFacility.JSON_PROPERTY_AMOUNT,
  ApiHotelFacility.JSON_PROPERTY_APPLICATION_TYPE,
  ApiHotelFacility.JSON_PROPERTY_CURRENCY,
  ApiHotelFacility.JSON_PROPERTY_DATE_FROM,
  ApiHotelFacility.JSON_PROPERTY_DATE_TO,
  ApiHotelFacility.JSON_PROPERTY_DESCRIPTION,
  ApiHotelFacility.JSON_PROPERTY_DISTANCE,
  ApiHotelFacility.JSON_PROPERTY_FACILITY_CODE,
  ApiHotelFacility.JSON_PROPERTY_FACILITY_GROUP_CODE,
  ApiHotelFacility.JSON_PROPERTY_FACILITY_NAME,
  ApiHotelFacility.JSON_PROPERTY_IND_FEE,
  ApiHotelFacility.JSON_PROPERTY_IND_LOGIC,
  ApiHotelFacility.JSON_PROPERTY_IND_YES_OR_NO,
  ApiHotelFacility.JSON_PROPERTY_NUMBER,
  ApiHotelFacility.JSON_PROPERTY_ORDER,
  ApiHotelFacility.JSON_PROPERTY_TIME_FROM,
  ApiHotelFacility.JSON_PROPERTY_TIME_TO,
  ApiHotelFacility.JSON_PROPERTY_VOUCHER
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-10-04T11:28:31.756188010+07:00[Asia/Bangkok]")
public class ApiHotelFacility {
  public static final String JSON_PROPERTY_AGE_FROM = "ageFrom";
  private Integer ageFrom;

  public static final String JSON_PROPERTY_AGE_TO = "ageTo";
  private Integer ageTo;

  public static final String JSON_PROPERTY_AMOUNT = "amount";
  private BigDecimal amount;

  public static final String JSON_PROPERTY_APPLICATION_TYPE = "applicationType";
  private String applicationType;

  public static final String JSON_PROPERTY_CURRENCY = "currency";
  private String currency;

  public static final String JSON_PROPERTY_DATE_FROM = "dateFrom";
  private String dateFrom;

  public static final String JSON_PROPERTY_DATE_TO = "dateTo";
  private String dateTo;

  public static final String JSON_PROPERTY_DESCRIPTION = "description";
  private ApiContent description;

  public static final String JSON_PROPERTY_DISTANCE = "distance";
  private Integer distance;

  public static final String JSON_PROPERTY_FACILITY_CODE = "facilityCode";
  private Integer facilityCode;

  public static final String JSON_PROPERTY_FACILITY_GROUP_CODE = "facilityGroupCode";
  private Integer facilityGroupCode;

  public static final String JSON_PROPERTY_FACILITY_NAME = "facilityName";
  private String facilityName;

  public static final String JSON_PROPERTY_IND_FEE = "indFee";
  private Boolean indFee;

  public static final String JSON_PROPERTY_IND_LOGIC = "indLogic";
  private Boolean indLogic;

  public static final String JSON_PROPERTY_IND_YES_OR_NO = "indYesOrNo";
  private Boolean indYesOrNo;

  public static final String JSON_PROPERTY_NUMBER = "number";
  private Integer number;

  public static final String JSON_PROPERTY_ORDER = "order";
  private Integer order;

  public static final String JSON_PROPERTY_TIME_FROM = "timeFrom";
  private String timeFrom;

  public static final String JSON_PROPERTY_TIME_TO = "timeTo";
  private String timeTo;

  public static final String JSON_PROPERTY_VOUCHER = "voucher";
  private Boolean voucher;

  public ApiHotelFacility() {
  }

  public ApiHotelFacility ageFrom(Integer ageFrom) {
    
    this.ageFrom = ageFrom;
    return this;
  }

   /**
   * Minimum age to access the facility.
   * @return ageFrom
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_AGE_FROM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getAgeFrom() {
    return ageFrom;
  }


  @JsonProperty(JSON_PROPERTY_AGE_FROM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAgeFrom(Integer ageFrom) {
    this.ageFrom = ageFrom;
  }


  public ApiHotelFacility ageTo(Integer ageTo) {
    
    this.ageTo = ageTo;
    return this;
  }

   /**
   * Maximum age to access the facility.
   * @return ageTo
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_AGE_TO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getAgeTo() {
    return ageTo;
  }


  @JsonProperty(JSON_PROPERTY_AGE_TO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAgeTo(Integer ageTo) {
    this.ageTo = ageTo;
  }


  public ApiHotelFacility amount(BigDecimal amount) {
    
    this.amount = amount;
    return this;
  }

   /**
   * Amount of the facility fee.
   * @return amount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getAmount() {
    return amount;
  }


  @JsonProperty(JSON_PROPERTY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAmount(BigDecimal amount) {
    this.amount = amount;
  }


  public ApiHotelFacility applicationType(String applicationType) {
    
    this.applicationType = applicationType;
    return this;
  }

   /**
   * Application type of the facility fee.
   * @return applicationType
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_APPLICATION_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getApplicationType() {
    return applicationType;
  }


  @JsonProperty(JSON_PROPERTY_APPLICATION_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setApplicationType(String applicationType) {
    this.applicationType = applicationType;
  }


  public ApiHotelFacility currency(String currency) {
    
    this.currency = currency;
    return this;
  }

   /**
   * Currency of the facility fee.
   * @return currency
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCurrency() {
    return currency;
  }


  @JsonProperty(JSON_PROPERTY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCurrency(String currency) {
    this.currency = currency;
  }


  public ApiHotelFacility dateFrom(String dateFrom) {
    
    this.dateFrom = dateFrom;
    return this;
  }

   /**
   * Date from which the facility is available.
   * @return dateFrom
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_DATE_FROM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDateFrom() {
    return dateFrom;
  }


  @JsonProperty(JSON_PROPERTY_DATE_FROM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDateFrom(String dateFrom) {
    this.dateFrom = dateFrom;
  }


  public ApiHotelFacility dateTo(String dateTo) {
    
    this.dateTo = dateTo;
    return this;
  }

   /**
   * Date until which the installation is available.
   * @return dateTo
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_DATE_TO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDateTo() {
    return dateTo;
  }


  @JsonProperty(JSON_PROPERTY_DATE_TO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDateTo(String dateTo) {
    this.dateTo = dateTo;
  }


  public ApiHotelFacility description(ApiContent description) {
    
    this.description = description;
    return this;
  }

   /**
   * Get description
   * @return description
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ApiContent getDescription() {
    return description;
  }


  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDescription(ApiContent description) {
    this.description = description;
  }


  public ApiHotelFacility distance(Integer distance) {
    
    this.distance = distance;
    return this;
  }

   /**
   * Distance in meters to the facility.
   * @return distance
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_DISTANCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getDistance() {
    return distance;
  }


  @JsonProperty(JSON_PROPERTY_DISTANCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDistance(Integer distance) {
    this.distance = distance;
  }


  public ApiHotelFacility facilityCode(Integer facilityCode) {
    
    this.facilityCode = facilityCode;
    return this;
  }

   /**
   * Code of the facility.
   * @return facilityCode
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_FACILITY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getFacilityCode() {
    return facilityCode;
  }


  @JsonProperty(JSON_PROPERTY_FACILITY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFacilityCode(Integer facilityCode) {
    this.facilityCode = facilityCode;
  }


  public ApiHotelFacility facilityGroupCode(Integer facilityGroupCode) {
    
    this.facilityGroupCode = facilityGroupCode;
    return this;
  }

   /**
   * Group to which the facility belongs.
   * @return facilityGroupCode
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_FACILITY_GROUP_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getFacilityGroupCode() {
    return facilityGroupCode;
  }


  @JsonProperty(JSON_PROPERTY_FACILITY_GROUP_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFacilityGroupCode(Integer facilityGroupCode) {
    this.facilityGroupCode = facilityGroupCode;
  }


  public ApiHotelFacility facilityName(String facilityName) {
    
    this.facilityName = facilityName;
    return this;
  }

   /**
   * Name of the facility.
   * @return facilityName
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_FACILITY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFacilityName() {
    return facilityName;
  }


  @JsonProperty(JSON_PROPERTY_FACILITY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFacilityName(String facilityName) {
    this.facilityName = facilityName;
  }


  public ApiHotelFacility indFee(Boolean indFee) {
    
    this.indFee = indFee;
    return this;
  }

   /**
   * Defines if the facility has cost or not at the establishment.
   * @return indFee
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_IND_FEE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIndFee() {
    return indFee;
  }


  @JsonProperty(JSON_PROPERTY_IND_FEE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIndFee(Boolean indFee) {
    this.indFee = indFee;
  }


  public ApiHotelFacility indLogic(Boolean indLogic) {
    
    this.indLogic = indLogic;
    return this;
  }

   /**
   * Indicates if the facility exists at the hotel. This field will be returned __only__ when the facility is at the hotel.
   * @return indLogic
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_IND_LOGIC)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIndLogic() {
    return indLogic;
  }


  @JsonProperty(JSON_PROPERTY_IND_LOGIC)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIndLogic(Boolean indLogic) {
    this.indLogic = indLogic;
  }


  public ApiHotelFacility indYesOrNo(Boolean indYesOrNo) {
    
    this.indYesOrNo = indYesOrNo;
    return this;
  }

   /**
   * Indicates in the mandatory facility exists at the hotel or not.
   * @return indYesOrNo
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_IND_YES_OR_NO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIndYesOrNo() {
    return indYesOrNo;
  }


  @JsonProperty(JSON_PROPERTY_IND_YES_OR_NO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIndYesOrNo(Boolean indYesOrNo) {
    this.indYesOrNo = indYesOrNo;
  }


  public ApiHotelFacility number(Integer number) {
    
    this.number = number;
    return this;
  }

   /**
   * Numeric value of the facility.
   * @return number
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getNumber() {
    return number;
  }


  @JsonProperty(JSON_PROPERTY_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNumber(Integer number) {
    this.number = number;
  }


  public ApiHotelFacility order(Integer order) {
    
    this.order = order;
    return this;
  }

   /**
   * Order of facility in case there is more than one facility at the hotel.
   * @return order
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ORDER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getOrder() {
    return order;
  }


  @JsonProperty(JSON_PROPERTY_ORDER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOrder(Integer order) {
    this.order = order;
  }


  public ApiHotelFacility timeFrom(String timeFrom) {
    
    this.timeFrom = timeFrom;
    return this;
  }

   /**
   * Time from which the facility is available.
   * @return timeFrom
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TIME_FROM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTimeFrom() {
    return timeFrom;
  }


  @JsonProperty(JSON_PROPERTY_TIME_FROM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTimeFrom(String timeFrom) {
    this.timeFrom = timeFrom;
  }


  public ApiHotelFacility timeTo(String timeTo) {
    
    this.timeTo = timeTo;
    return this;
  }

   /**
   * Time until which the facility is available.
   * @return timeTo
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TIME_TO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTimeTo() {
    return timeTo;
  }


  @JsonProperty(JSON_PROPERTY_TIME_TO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTimeTo(String timeTo) {
    this.timeTo = timeTo;
  }


  public ApiHotelFacility voucher(Boolean voucher) {
    
    this.voucher = voucher;
    return this;
  }

   /**
   * Indicates if the use of the facility will issue a voucher.
   * @return voucher
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_VOUCHER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getVoucher() {
    return voucher;
  }


  @JsonProperty(JSON_PROPERTY_VOUCHER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVoucher(Boolean voucher) {
    this.voucher = voucher;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ApiHotelFacility apiHotelFacility = (ApiHotelFacility) o;
    return Objects.equals(this.ageFrom, apiHotelFacility.ageFrom) &&
        Objects.equals(this.ageTo, apiHotelFacility.ageTo) &&
        Objects.equals(this.amount, apiHotelFacility.amount) &&
        Objects.equals(this.applicationType, apiHotelFacility.applicationType) &&
        Objects.equals(this.currency, apiHotelFacility.currency) &&
        Objects.equals(this.dateFrom, apiHotelFacility.dateFrom) &&
        Objects.equals(this.dateTo, apiHotelFacility.dateTo) &&
        Objects.equals(this.description, apiHotelFacility.description) &&
        Objects.equals(this.distance, apiHotelFacility.distance) &&
        Objects.equals(this.facilityCode, apiHotelFacility.facilityCode) &&
        Objects.equals(this.facilityGroupCode, apiHotelFacility.facilityGroupCode) &&
        Objects.equals(this.facilityName, apiHotelFacility.facilityName) &&
        Objects.equals(this.indFee, apiHotelFacility.indFee) &&
        Objects.equals(this.indLogic, apiHotelFacility.indLogic) &&
        Objects.equals(this.indYesOrNo, apiHotelFacility.indYesOrNo) &&
        Objects.equals(this.number, apiHotelFacility.number) &&
        Objects.equals(this.order, apiHotelFacility.order) &&
        Objects.equals(this.timeFrom, apiHotelFacility.timeFrom) &&
        Objects.equals(this.timeTo, apiHotelFacility.timeTo) &&
        Objects.equals(this.voucher, apiHotelFacility.voucher);
  }

  @Override
  public int hashCode() {
    return Objects.hash(ageFrom, ageTo, amount, applicationType, currency, dateFrom, dateTo, description, distance, facilityCode, facilityGroupCode, facilityName, indFee, indLogic, indYesOrNo, number, order, timeFrom, timeTo, voucher);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ApiHotelFacility {\n");
    sb.append("    ageFrom: ").append(toIndentedString(ageFrom)).append("\n");
    sb.append("    ageTo: ").append(toIndentedString(ageTo)).append("\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    applicationType: ").append(toIndentedString(applicationType)).append("\n");
    sb.append("    currency: ").append(toIndentedString(currency)).append("\n");
    sb.append("    dateFrom: ").append(toIndentedString(dateFrom)).append("\n");
    sb.append("    dateTo: ").append(toIndentedString(dateTo)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    distance: ").append(toIndentedString(distance)).append("\n");
    sb.append("    facilityCode: ").append(toIndentedString(facilityCode)).append("\n");
    sb.append("    facilityGroupCode: ").append(toIndentedString(facilityGroupCode)).append("\n");
    sb.append("    facilityName: ").append(toIndentedString(facilityName)).append("\n");
    sb.append("    indFee: ").append(toIndentedString(indFee)).append("\n");
    sb.append("    indLogic: ").append(toIndentedString(indLogic)).append("\n");
    sb.append("    indYesOrNo: ").append(toIndentedString(indYesOrNo)).append("\n");
    sb.append("    number: ").append(toIndentedString(number)).append("\n");
    sb.append("    order: ").append(toIndentedString(order)).append("\n");
    sb.append("    timeFrom: ").append(toIndentedString(timeFrom)).append("\n");
    sb.append("    timeTo: ").append(toIndentedString(timeTo)).append("\n");
    sb.append("    voucher: ").append(toIndentedString(voucher)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

