/*
 * Hotel Content API
 * # APItude Hotel Content API  Hotel Content API has been designed to retrieve **all the details** of the hotels available in our [Hotel Booking API](/documentation/hotels/booking-api/api-reference/).   Hotel Content API contains several methods that allow you to obtain the details of the hotels as well as list of destinations, countries and the master types that complement the hotels informatoin (like room type descriptions, accommodation type descriptions, categories descriptions...).  Note that the Languages operation is connected to all the operations in which a description is returned, since we return the language code in which that description has been returned. 
 *
 * The version of the OpenAPI document: 1.0
 * Contact: apitude@hotelbeds.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.hotelbeds.content.sdk.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import travel.wink.hotelbeds.content.sdk.model.ApiContent;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Information on an hotel issue (repair works, facilities closed,...).
 */
@JsonPropertyOrder({
  ApiHotelIssue.JSON_PROPERTY_ALTERNATIVE,
  ApiHotelIssue.JSON_PROPERTY_DATE_FROM,
  ApiHotelIssue.JSON_PROPERTY_DATE_TO,
  ApiHotelIssue.JSON_PROPERTY_DESCRIPTION,
  ApiHotelIssue.JSON_PROPERTY_ISSUE_CODE,
  ApiHotelIssue.JSON_PROPERTY_ISSUE_TYPE,
  ApiHotelIssue.JSON_PROPERTY_ORDER
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-10-04T11:28:31.756188010+07:00[Asia/Bangkok]")
public class ApiHotelIssue {
  public static final String JSON_PROPERTY_ALTERNATIVE = "alternative";
  private Boolean alternative;

  public static final String JSON_PROPERTY_DATE_FROM = "dateFrom";
  private String dateFrom;

  public static final String JSON_PROPERTY_DATE_TO = "dateTo";
  private String dateTo;

  public static final String JSON_PROPERTY_DESCRIPTION = "description";
  private ApiContent description;

  public static final String JSON_PROPERTY_ISSUE_CODE = "issueCode";
  private String issueCode;

  public static final String JSON_PROPERTY_ISSUE_TYPE = "issueType";
  private String issueType;

  public static final String JSON_PROPERTY_ORDER = "order";
  private Integer order;

  public ApiHotelIssue() {
  }

  public ApiHotelIssue alternative(Boolean alternative) {
    
    this.alternative = alternative;
    return this;
  }

   /**
   * Indicator if there will be an alternative due to the issue.
   * @return alternative
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ALTERNATIVE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getAlternative() {
    return alternative;
  }


  @JsonProperty(JSON_PROPERTY_ALTERNATIVE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAlternative(Boolean alternative) {
    this.alternative = alternative;
  }


  public ApiHotelIssue dateFrom(String dateFrom) {
    
    this.dateFrom = dateFrom;
    return this;
  }

   /**
   * Date from when the issue will start.
   * @return dateFrom
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_DATE_FROM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDateFrom() {
    return dateFrom;
  }


  @JsonProperty(JSON_PROPERTY_DATE_FROM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDateFrom(String dateFrom) {
    this.dateFrom = dateFrom;
  }


  public ApiHotelIssue dateTo(String dateTo) {
    
    this.dateTo = dateTo;
    return this;
  }

   /**
   * Date when the issue will end.
   * @return dateTo
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_DATE_TO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDateTo() {
    return dateTo;
  }


  @JsonProperty(JSON_PROPERTY_DATE_TO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDateTo(String dateTo) {
    this.dateTo = dateTo;
  }


  public ApiHotelIssue description(ApiContent description) {
    
    this.description = description;
    return this;
  }

   /**
   * Get description
   * @return description
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ApiContent getDescription() {
    return description;
  }


  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDescription(ApiContent description) {
    this.description = description;
  }


  public ApiHotelIssue issueCode(String issueCode) {
    
    this.issueCode = issueCode;
    return this;
  }

   /**
   * Code of the issue.
   * @return issueCode
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ISSUE_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getIssueCode() {
    return issueCode;
  }


  @JsonProperty(JSON_PROPERTY_ISSUE_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIssueCode(String issueCode) {
    this.issueCode = issueCode;
  }


  public ApiHotelIssue issueType(String issueType) {
    
    this.issueType = issueType;
    return this;
  }

   /**
   * Code of the type of incidence.
   * @return issueType
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ISSUE_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getIssueType() {
    return issueType;
  }


  @JsonProperty(JSON_PROPERTY_ISSUE_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIssueType(String issueType) {
    this.issueType = issueType;
  }


  public ApiHotelIssue order(Integer order) {
    
    this.order = order;
    return this;
  }

   /**
   * Issue order, in case there is more than one.
   * @return order
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ORDER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getOrder() {
    return order;
  }


  @JsonProperty(JSON_PROPERTY_ORDER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOrder(Integer order) {
    this.order = order;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ApiHotelIssue apiHotelIssue = (ApiHotelIssue) o;
    return Objects.equals(this.alternative, apiHotelIssue.alternative) &&
        Objects.equals(this.dateFrom, apiHotelIssue.dateFrom) &&
        Objects.equals(this.dateTo, apiHotelIssue.dateTo) &&
        Objects.equals(this.description, apiHotelIssue.description) &&
        Objects.equals(this.issueCode, apiHotelIssue.issueCode) &&
        Objects.equals(this.issueType, apiHotelIssue.issueType) &&
        Objects.equals(this.order, apiHotelIssue.order);
  }

  @Override
  public int hashCode() {
    return Objects.hash(alternative, dateFrom, dateTo, description, issueCode, issueType, order);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ApiHotelIssue {\n");
    sb.append("    alternative: ").append(toIndentedString(alternative)).append("\n");
    sb.append("    dateFrom: ").append(toIndentedString(dateFrom)).append("\n");
    sb.append("    dateTo: ").append(toIndentedString(dateTo)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    issueCode: ").append(toIndentedString(issueCode)).append("\n");
    sb.append("    issueType: ").append(toIndentedString(issueType)).append("\n");
    sb.append("    order: ").append(toIndentedString(order)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

