/*
 * Hotel Content API
 * # APItude Hotel Content API  Hotel Content API has been designed to retrieve **all the details** of the hotels available in our [Hotel Booking API](/documentation/hotels/booking-api/api-reference/).   Hotel Content API contains several methods that allow you to obtain the details of the hotels as well as list of destinations, countries and the master types that complement the hotels informatoin (like room type descriptions, accommodation type descriptions, categories descriptions...).  Note that the Languages operation is connected to all the operations in which a description is returned, since we return the language code in which that description has been returned. 
 *
 * The version of the OpenAPI document: 1.0
 * Contact: apitude@hotelbeds.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.hotelbeds.content.sdk.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Information on a point of interest near a hotel.
 */
@JsonPropertyOrder({
  ApiHotelPointOfInterest.JSON_PROPERTY_DISTANCE,
  ApiHotelPointOfInterest.JSON_PROPERTY_FACILITY_CODE,
  ApiHotelPointOfInterest.JSON_PROPERTY_FACILITY_GROUP_CODE,
  ApiHotelPointOfInterest.JSON_PROPERTY_FEE,
  ApiHotelPointOfInterest.JSON_PROPERTY_ORDER,
  ApiHotelPointOfInterest.JSON_PROPERTY_POI_NAME
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-10-04T11:28:31.756188010+07:00[Asia/Bangkok]")
public class ApiHotelPointOfInterest {
  public static final String JSON_PROPERTY_DISTANCE = "distance";
  private String distance;

  public static final String JSON_PROPERTY_FACILITY_CODE = "facilityCode";
  private Integer facilityCode;

  public static final String JSON_PROPERTY_FACILITY_GROUP_CODE = "facilityGroupCode";
  private Integer facilityGroupCode;

  public static final String JSON_PROPERTY_FEE = "fee";
  private Boolean fee;

  public static final String JSON_PROPERTY_ORDER = "order";
  private Integer order;

  public static final String JSON_PROPERTY_POI_NAME = "poiName";
  private String poiName;

  public ApiHotelPointOfInterest() {
  }

  public ApiHotelPointOfInterest distance(String distance) {
    
    this.distance = distance;
    return this;
  }

   /**
   * Distance in meters to the point of interest.
   * @return distance
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_DISTANCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDistance() {
    return distance;
  }


  @JsonProperty(JSON_PROPERTY_DISTANCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDistance(String distance) {
    this.distance = distance;
  }


  public ApiHotelPointOfInterest facilityCode(Integer facilityCode) {
    
    this.facilityCode = facilityCode;
    return this;
  }

   /**
   * Code of the point of interest as a facility.
   * @return facilityCode
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_FACILITY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getFacilityCode() {
    return facilityCode;
  }


  @JsonProperty(JSON_PROPERTY_FACILITY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFacilityCode(Integer facilityCode) {
    this.facilityCode = facilityCode;
  }


  public ApiHotelPointOfInterest facilityGroupCode(Integer facilityGroupCode) {
    
    this.facilityGroupCode = facilityGroupCode;
    return this;
  }

   /**
   * Group to which the point of interest belongs as a facility.
   * @return facilityGroupCode
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_FACILITY_GROUP_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getFacilityGroupCode() {
    return facilityGroupCode;
  }


  @JsonProperty(JSON_PROPERTY_FACILITY_GROUP_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFacilityGroupCode(Integer facilityGroupCode) {
    this.facilityGroupCode = facilityGroupCode;
  }


  public ApiHotelPointOfInterest fee(Boolean fee) {
    
    this.fee = fee;
    return this;
  }

   /**
   * Defines if there is a fee to access the point of interest.
   * @return fee
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_FEE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getFee() {
    return fee;
  }


  @JsonProperty(JSON_PROPERTY_FEE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFee(Boolean fee) {
    this.fee = fee;
  }


  public ApiHotelPointOfInterest order(Integer order) {
    
    this.order = order;
    return this;
  }

   /**
   * Order of the point of interest.
   * @return order
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ORDER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getOrder() {
    return order;
  }


  @JsonProperty(JSON_PROPERTY_ORDER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOrder(Integer order) {
    this.order = order;
  }


  public ApiHotelPointOfInterest poiName(String poiName) {
    
    this.poiName = poiName;
    return this;
  }

   /**
   * Name of the point of interest.
   * @return poiName
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_POI_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPoiName() {
    return poiName;
  }


  @JsonProperty(JSON_PROPERTY_POI_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPoiName(String poiName) {
    this.poiName = poiName;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ApiHotelPointOfInterest apiHotelPointOfInterest = (ApiHotelPointOfInterest) o;
    return Objects.equals(this.distance, apiHotelPointOfInterest.distance) &&
        Objects.equals(this.facilityCode, apiHotelPointOfInterest.facilityCode) &&
        Objects.equals(this.facilityGroupCode, apiHotelPointOfInterest.facilityGroupCode) &&
        Objects.equals(this.fee, apiHotelPointOfInterest.fee) &&
        Objects.equals(this.order, apiHotelPointOfInterest.order) &&
        Objects.equals(this.poiName, apiHotelPointOfInterest.poiName);
  }

  @Override
  public int hashCode() {
    return Objects.hash(distance, facilityCode, facilityGroupCode, fee, order, poiName);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ApiHotelPointOfInterest {\n");
    sb.append("    distance: ").append(toIndentedString(distance)).append("\n");
    sb.append("    facilityCode: ").append(toIndentedString(facilityCode)).append("\n");
    sb.append("    facilityGroupCode: ").append(toIndentedString(facilityGroupCode)).append("\n");
    sb.append("    fee: ").append(toIndentedString(fee)).append("\n");
    sb.append("    order: ").append(toIndentedString(order)).append("\n");
    sb.append("    poiName: ").append(toIndentedString(poiName)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

