/*
 * Hotel Content API
 * # APItude Hotel Content API  Hotel Content API has been designed to retrieve **all the details** of the hotels available in our [Hotel Booking API](/documentation/hotels/booking-api/api-reference/).   Hotel Content API contains several methods that allow you to obtain the details of the hotels as well as list of destinations, countries and the master types that complement the hotels informatoin (like room type descriptions, accommodation type descriptions, categories descriptions...).  Note that the Languages operation is connected to all the operations in which a description is returned, since we return the language code in which that description has been returned. 
 *
 * The version of the OpenAPI document: 1.0
 * Contact: apitude@hotelbeds.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.hotelbeds.content.sdk.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import travel.wink.hotelbeds.content.sdk.model.ApiHotelRoomFacility;
import travel.wink.hotelbeds.content.sdk.model.ApiHotelRoomStay;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Information of the hotel room.
 */
@JsonPropertyOrder({
  ApiHotelRoom.JSON_PROPERTY_CHARACTERISTIC_CODE,
  ApiHotelRoom.JSON_PROPERTY_DESCRIPTION,
  ApiHotelRoom.JSON_PROPERTY_ROOM_CODE,
  ApiHotelRoom.JSON_PROPERTY_ROOM_FACILITIES,
  ApiHotelRoom.JSON_PROPERTY_ROOM_STAYS,
  ApiHotelRoom.JSON_PROPERTY_ROOM_TYPE
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-10-04T11:28:31.756188010+07:00[Asia/Bangkok]")
public class ApiHotelRoom {
  public static final String JSON_PROPERTY_CHARACTERISTIC_CODE = "characteristicCode";
  private String characteristicCode;

  public static final String JSON_PROPERTY_DESCRIPTION = "description";
  private String description;

  public static final String JSON_PROPERTY_ROOM_CODE = "roomCode";
  private String roomCode;

  public static final String JSON_PROPERTY_ROOM_FACILITIES = "roomFacilities";
  private List<ApiHotelRoomFacility> roomFacilities;

  public static final String JSON_PROPERTY_ROOM_STAYS = "roomStays";
  private List<ApiHotelRoomStay> roomStays;

  public static final String JSON_PROPERTY_ROOM_TYPE = "roomType";
  private String roomType;

  public ApiHotelRoom() {
  }

  public ApiHotelRoom characteristicCode(String characteristicCode) {
    
    this.characteristicCode = characteristicCode;
    return this;
  }

   /**
   * Characteristic code/s of the room.
   * @return characteristicCode
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CHARACTERISTIC_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCharacteristicCode() {
    return characteristicCode;
  }


  @JsonProperty(JSON_PROPERTY_CHARACTERISTIC_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCharacteristicCode(String characteristicCode) {
    this.characteristicCode = characteristicCode;
  }


  public ApiHotelRoom description(String description) {
    
    this.description = description;
    return this;
  }

   /**
   * Description of the room.
   * @return description
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDescription() {
    return description;
  }


  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDescription(String description) {
    this.description = description;
  }


  public ApiHotelRoom roomCode(String roomCode) {
    
    this.roomCode = roomCode;
    return this;
  }

   /**
   * Identifier of the room type.
   * @return roomCode
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ROOM_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRoomCode() {
    return roomCode;
  }


  @JsonProperty(JSON_PROPERTY_ROOM_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRoomCode(String roomCode) {
    this.roomCode = roomCode;
  }


  public ApiHotelRoom roomFacilities(List<ApiHotelRoomFacility> roomFacilities) {
    
    this.roomFacilities = roomFacilities;
    return this;
  }

  public ApiHotelRoom addRoomFacilitiesItem(ApiHotelRoomFacility roomFacilitiesItem) {
    if (this.roomFacilities == null) {
      this.roomFacilities = new ArrayList<>();
    }
    this.roomFacilities.add(roomFacilitiesItem);
    return this;
  }

   /**
   * List of facilities, amenities and installations in the room of the hotel.
   * @return roomFacilities
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_ROOM_FACILITIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<ApiHotelRoomFacility> getRoomFacilities() {
    return roomFacilities;
  }


  @JsonProperty(JSON_PROPERTY_ROOM_FACILITIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRoomFacilities(List<ApiHotelRoomFacility> roomFacilities) {
    this.roomFacilities = roomFacilities;
  }


  public ApiHotelRoom roomStays(List<ApiHotelRoomStay> roomStays) {
    
    this.roomStays = roomStays;
    return this;
  }

  public ApiHotelRoom addRoomStaysItem(ApiHotelRoomStay roomStaysItem) {
    if (this.roomStays == null) {
      this.roomStays = new ArrayList<>();
    }
    this.roomStays.add(roomStaysItem);
    return this;
  }

   /**
   * List of the different departments in which the room is divided.
   * @return roomStays
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_ROOM_STAYS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<ApiHotelRoomStay> getRoomStays() {
    return roomStays;
  }


  @JsonProperty(JSON_PROPERTY_ROOM_STAYS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRoomStays(List<ApiHotelRoomStay> roomStays) {
    this.roomStays = roomStays;
  }


  public ApiHotelRoom roomType(String roomType) {
    
    this.roomType = roomType;
    return this;
  }

   /**
   * Internal room type code. Returned only for Unified clients.
   * @return roomType
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ROOM_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRoomType() {
    return roomType;
  }


  @JsonProperty(JSON_PROPERTY_ROOM_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRoomType(String roomType) {
    this.roomType = roomType;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ApiHotelRoom apiHotelRoom = (ApiHotelRoom) o;
    return Objects.equals(this.characteristicCode, apiHotelRoom.characteristicCode) &&
        Objects.equals(this.description, apiHotelRoom.description) &&
        Objects.equals(this.roomCode, apiHotelRoom.roomCode) &&
        Objects.equals(this.roomFacilities, apiHotelRoom.roomFacilities) &&
        Objects.equals(this.roomStays, apiHotelRoom.roomStays) &&
        Objects.equals(this.roomType, apiHotelRoom.roomType);
  }

  @Override
  public int hashCode() {
    return Objects.hash(characteristicCode, description, roomCode, roomFacilities, roomStays, roomType);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ApiHotelRoom {\n");
    sb.append("    characteristicCode: ").append(toIndentedString(characteristicCode)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    roomCode: ").append(toIndentedString(roomCode)).append("\n");
    sb.append("    roomFacilities: ").append(toIndentedString(roomFacilities)).append("\n");
    sb.append("    roomStays: ").append(toIndentedString(roomStays)).append("\n");
    sb.append("    roomType: ").append(toIndentedString(roomType)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

