/*
 * Hotel Content API
 * # APItude Hotel Content API  Hotel Content API has been designed to retrieve **all the details** of the hotels available in our [Hotel Booking API](/documentation/hotels/booking-api/api-reference/).   Hotel Content API contains several methods that allow you to obtain the details of the hotels as well as list of destinations, countries and the master types that complement the hotels informatoin (like room type descriptions, accommodation type descriptions, categories descriptions...).  Note that the Languages operation is connected to all the operations in which a description is returned, since we return the language code in which that description has been returned. 
 *
 * The version of the OpenAPI document: 1.0
 * Contact: apitude@hotelbeds.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.hotelbeds.content.sdk.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import travel.wink.hotelbeds.content.sdk.model.ApiContent;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Information on facilities and features associated to a hotel room.
 */
@JsonPropertyOrder({
  ApiHotelRoomFacility.JSON_PROPERTY_DESCRIPTION,
  ApiHotelRoomFacility.JSON_PROPERTY_FACILITY_CODE,
  ApiHotelRoomFacility.JSON_PROPERTY_FACILITY_GROUP_CODE,
  ApiHotelRoomFacility.JSON_PROPERTY_IND_FEE,
  ApiHotelRoomFacility.JSON_PROPERTY_IND_LOGIC,
  ApiHotelRoomFacility.JSON_PROPERTY_IND_YES_OR_NO,
  ApiHotelRoomFacility.JSON_PROPERTY_NUMBER,
  ApiHotelRoomFacility.JSON_PROPERTY_ORDER,
  ApiHotelRoomFacility.JSON_PROPERTY_VOUCHER
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-10-04T11:28:31.756188010+07:00[Asia/Bangkok]")
public class ApiHotelRoomFacility {
  public static final String JSON_PROPERTY_DESCRIPTION = "description";
  private ApiContent description;

  public static final String JSON_PROPERTY_FACILITY_CODE = "facilityCode";
  private Integer facilityCode;

  public static final String JSON_PROPERTY_FACILITY_GROUP_CODE = "facilityGroupCode";
  private Integer facilityGroupCode;

  public static final String JSON_PROPERTY_IND_FEE = "indFee";
  private Boolean indFee;

  public static final String JSON_PROPERTY_IND_LOGIC = "indLogic";
  private Boolean indLogic;

  public static final String JSON_PROPERTY_IND_YES_OR_NO = "indYesOrNo";
  private Boolean indYesOrNo;

  public static final String JSON_PROPERTY_NUMBER = "number";
  private Integer number;

  public static final String JSON_PROPERTY_ORDER = "order";
  private Integer order;

  public static final String JSON_PROPERTY_VOUCHER = "voucher";
  private Boolean voucher;

  public ApiHotelRoomFacility() {
  }

  public ApiHotelRoomFacility description(ApiContent description) {
    
    this.description = description;
    return this;
  }

   /**
   * Get description
   * @return description
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ApiContent getDescription() {
    return description;
  }


  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDescription(ApiContent description) {
    this.description = description;
  }


  public ApiHotelRoomFacility facilityCode(Integer facilityCode) {
    
    this.facilityCode = facilityCode;
    return this;
  }

   /**
   * Code of the facility.
   * @return facilityCode
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_FACILITY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getFacilityCode() {
    return facilityCode;
  }


  @JsonProperty(JSON_PROPERTY_FACILITY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFacilityCode(Integer facilityCode) {
    this.facilityCode = facilityCode;
  }


  public ApiHotelRoomFacility facilityGroupCode(Integer facilityGroupCode) {
    
    this.facilityGroupCode = facilityGroupCode;
    return this;
  }

   /**
   * Code of the group to which the facility belongs.
   * @return facilityGroupCode
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_FACILITY_GROUP_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getFacilityGroupCode() {
    return facilityGroupCode;
  }


  @JsonProperty(JSON_PROPERTY_FACILITY_GROUP_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFacilityGroupCode(Integer facilityGroupCode) {
    this.facilityGroupCode = facilityGroupCode;
  }


  public ApiHotelRoomFacility indFee(Boolean indFee) {
    
    this.indFee = indFee;
    return this;
  }

   /**
   * Indicator if the facility has cost or not at the establishment.
   * @return indFee
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_IND_FEE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIndFee() {
    return indFee;
  }


  @JsonProperty(JSON_PROPERTY_IND_FEE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIndFee(Boolean indFee) {
    this.indFee = indFee;
  }


  public ApiHotelRoomFacility indLogic(Boolean indLogic) {
    
    this.indLogic = indLogic;
    return this;
  }

   /**
   * Indicator if the facility exists at the hotel or not.
   * @return indLogic
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_IND_LOGIC)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIndLogic() {
    return indLogic;
  }


  @JsonProperty(JSON_PROPERTY_IND_LOGIC)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIndLogic(Boolean indLogic) {
    this.indLogic = indLogic;
  }


  public ApiHotelRoomFacility indYesOrNo(Boolean indYesOrNo) {
    
    this.indYesOrNo = indYesOrNo;
    return this;
  }

   /**
   * Indicator if the mandatory facility exists at the hotel or not.
   * @return indYesOrNo
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_IND_YES_OR_NO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIndYesOrNo() {
    return indYesOrNo;
  }


  @JsonProperty(JSON_PROPERTY_IND_YES_OR_NO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIndYesOrNo(Boolean indYesOrNo) {
    this.indYesOrNo = indYesOrNo;
  }


  public ApiHotelRoomFacility number(Integer number) {
    
    this.number = number;
    return this;
  }

   /**
   * Numeric value of the facility.
   * @return number
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getNumber() {
    return number;
  }


  @JsonProperty(JSON_PROPERTY_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNumber(Integer number) {
    this.number = number;
  }


  public ApiHotelRoomFacility order(Integer order) {
    
    this.order = order;
    return this;
  }

   /**
   * Order of facility in case there is more than one facility at the hotel.
   * @return order
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ORDER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getOrder() {
    return order;
  }


  @JsonProperty(JSON_PROPERTY_ORDER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOrder(Integer order) {
    this.order = order;
  }


  public ApiHotelRoomFacility voucher(Boolean voucher) {
    
    this.voucher = voucher;
    return this;
  }

   /**
   * Indicates if the use of the facility will issue a voucher.
   * @return voucher
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_VOUCHER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getVoucher() {
    return voucher;
  }


  @JsonProperty(JSON_PROPERTY_VOUCHER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVoucher(Boolean voucher) {
    this.voucher = voucher;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ApiHotelRoomFacility apiHotelRoomFacility = (ApiHotelRoomFacility) o;
    return Objects.equals(this.description, apiHotelRoomFacility.description) &&
        Objects.equals(this.facilityCode, apiHotelRoomFacility.facilityCode) &&
        Objects.equals(this.facilityGroupCode, apiHotelRoomFacility.facilityGroupCode) &&
        Objects.equals(this.indFee, apiHotelRoomFacility.indFee) &&
        Objects.equals(this.indLogic, apiHotelRoomFacility.indLogic) &&
        Objects.equals(this.indYesOrNo, apiHotelRoomFacility.indYesOrNo) &&
        Objects.equals(this.number, apiHotelRoomFacility.number) &&
        Objects.equals(this.order, apiHotelRoomFacility.order) &&
        Objects.equals(this.voucher, apiHotelRoomFacility.voucher);
  }

  @Override
  public int hashCode() {
    return Objects.hash(description, facilityCode, facilityGroupCode, indFee, indLogic, indYesOrNo, number, order, voucher);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ApiHotelRoomFacility {\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    facilityCode: ").append(toIndentedString(facilityCode)).append("\n");
    sb.append("    facilityGroupCode: ").append(toIndentedString(facilityGroupCode)).append("\n");
    sb.append("    indFee: ").append(toIndentedString(indFee)).append("\n");
    sb.append("    indLogic: ").append(toIndentedString(indLogic)).append("\n");
    sb.append("    indYesOrNo: ").append(toIndentedString(indYesOrNo)).append("\n");
    sb.append("    number: ").append(toIndentedString(number)).append("\n");
    sb.append("    order: ").append(toIndentedString(order)).append("\n");
    sb.append("    voucher: ").append(toIndentedString(voucher)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

