/*
 * Hotel Content API
 * # APItude Hotel Content API  Hotel Content API has been designed to retrieve **all the details** of the hotels available in our [Hotel Booking API](/documentation/hotels/booking-api/api-reference/).   Hotel Content API contains several methods that allow you to obtain the details of the hotels as well as list of destinations, countries and the master types that complement the hotels informatoin (like room type descriptions, accommodation type descriptions, categories descriptions...).  Note that the Languages operation is connected to all the operations in which a description is returned, since we return the language code in which that description has been returned. 
 *
 * The version of the OpenAPI document: 1.0
 * Contact: apitude@hotelbeds.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.hotelbeds.content.sdk.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import travel.wink.hotelbeds.content.sdk.model.ApiImageType;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Describes an hotel picture.
 */
@JsonPropertyOrder({
  ApiImage.JSON_PROPERTY_CHARACTERISTIC_CODE,
  ApiImage.JSON_PROPERTY_IMAGE_TYPE_CODE,
  ApiImage.JSON_PROPERTY_ORDER,
  ApiImage.JSON_PROPERTY_PATH,
  ApiImage.JSON_PROPERTY_ROOM_CODE,
  ApiImage.JSON_PROPERTY_ROOM_TYPE,
  ApiImage.JSON_PROPERTY_TYPE,
  ApiImage.JSON_PROPERTY_VISUAL_ORDER,
  ApiImage.JSON_PROPERTY_PM_S_ROOM_CODE
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-10-04T11:28:31.756188010+07:00[Asia/Bangkok]")
public class ApiImage {
  public static final String JSON_PROPERTY_CHARACTERISTIC_CODE = "characteristicCode";
  private String characteristicCode;

  public static final String JSON_PROPERTY_IMAGE_TYPE_CODE = "imageTypeCode";
  private String imageTypeCode;

  public static final String JSON_PROPERTY_ORDER = "order";
  private Integer order;

  public static final String JSON_PROPERTY_PATH = "path";
  private String path;

  public static final String JSON_PROPERTY_ROOM_CODE = "roomCode";
  private String roomCode;

  public static final String JSON_PROPERTY_ROOM_TYPE = "roomType";
  private String roomType;

  public static final String JSON_PROPERTY_TYPE = "type";
  private ApiImageType type;

  public static final String JSON_PROPERTY_VISUAL_ORDER = "visualOrder";
  private Integer visualOrder;

  public static final String JSON_PROPERTY_PM_S_ROOM_CODE = "PMSRoomCode";
  private String pmSRoomCode;

  public ApiImage() {
  }

  public ApiImage characteristicCode(String characteristicCode) {
    
    this.characteristicCode = characteristicCode;
    return this;
  }

   /**
   * Characteristic code/s of the room.
   * @return characteristicCode
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CHARACTERISTIC_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCharacteristicCode() {
    return characteristicCode;
  }


  @JsonProperty(JSON_PROPERTY_CHARACTERISTIC_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCharacteristicCode(String characteristicCode) {
    this.characteristicCode = characteristicCode;
  }


  public ApiImage imageTypeCode(String imageTypeCode) {
    
    this.imageTypeCode = imageTypeCode;
    return this;
  }

   /**
   * Specifies where has the picture been taken (you can see the possible values in the response of types/imagetypes operation).
   * @return imageTypeCode
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_IMAGE_TYPE_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getImageTypeCode() {
    return imageTypeCode;
  }


  @JsonProperty(JSON_PROPERTY_IMAGE_TYPE_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setImageTypeCode(String imageTypeCode) {
    this.imageTypeCode = imageTypeCode;
  }


  public ApiImage order(Integer order) {
    
    this.order = order;
    return this;
  }

   /**
   * Order in which the images are shown in the web page.
   * @return order
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ORDER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getOrder() {
    return order;
  }


  @JsonProperty(JSON_PROPERTY_ORDER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOrder(Integer order) {
    this.order = order;
  }


  public ApiImage path(String path) {
    
    this.path = path;
    return this;
  }

   /**
   * URL of the image. For hotel images, we do not return the full path. Note that one of the following paths must be added by the client.
   * @return path
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PATH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPath() {
    return path;
  }


  @JsonProperty(JSON_PROPERTY_PATH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPath(String path) {
    this.path = path;
  }


  public ApiImage roomCode(String roomCode) {
    
    this.roomCode = roomCode;
    return this;
  }

   /**
   * Identifier of the room type.
   * @return roomCode
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ROOM_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRoomCode() {
    return roomCode;
  }


  @JsonProperty(JSON_PROPERTY_ROOM_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRoomCode(String roomCode) {
    this.roomCode = roomCode;
  }


  public ApiImage roomType(String roomType) {
    
    this.roomType = roomType;
    return this;
  }

   /**
   * Internal Room type code, returned only for Unified clients.
   * @return roomType
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ROOM_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRoomType() {
    return roomType;
  }


  @JsonProperty(JSON_PROPERTY_ROOM_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRoomType(String roomType) {
    this.roomType = roomType;
  }


  public ApiImage type(ApiImageType type) {
    
    this.type = type;
    return this;
  }

   /**
   * Get type
   * @return type
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ApiImageType getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(ApiImageType type) {
    this.type = type;
  }


  public ApiImage visualOrder(Integer visualOrder) {
    
    this.visualOrder = visualOrder;
    return this;
  }

   /**
   * Ordinal value at which the image should be presented.
   * @return visualOrder
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_VISUAL_ORDER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getVisualOrder() {
    return visualOrder;
  }


  @JsonProperty(JSON_PROPERTY_VISUAL_ORDER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVisualOrder(Integer visualOrder) {
    this.visualOrder = visualOrder;
  }


  public ApiImage pmSRoomCode(String pmSRoomCode) {
    
    this.pmSRoomCode = pmSRoomCode;
    return this;
  }

   /**
   * Original hotel room code, directly sourced from the property
   * @return pmSRoomCode
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PM_S_ROOM_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPmSRoomCode() {
    return pmSRoomCode;
  }


  @JsonProperty(JSON_PROPERTY_PM_S_ROOM_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPmSRoomCode(String pmSRoomCode) {
    this.pmSRoomCode = pmSRoomCode;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ApiImage apiImage = (ApiImage) o;
    return Objects.equals(this.characteristicCode, apiImage.characteristicCode) &&
        Objects.equals(this.imageTypeCode, apiImage.imageTypeCode) &&
        Objects.equals(this.order, apiImage.order) &&
        Objects.equals(this.path, apiImage.path) &&
        Objects.equals(this.roomCode, apiImage.roomCode) &&
        Objects.equals(this.roomType, apiImage.roomType) &&
        Objects.equals(this.type, apiImage.type) &&
        Objects.equals(this.visualOrder, apiImage.visualOrder) &&
        Objects.equals(this.pmSRoomCode, apiImage.pmSRoomCode);
  }

  @Override
  public int hashCode() {
    return Objects.hash(characteristicCode, imageTypeCode, order, path, roomCode, roomType, type, visualOrder, pmSRoomCode);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ApiImage {\n");
    sb.append("    characteristicCode: ").append(toIndentedString(characteristicCode)).append("\n");
    sb.append("    imageTypeCode: ").append(toIndentedString(imageTypeCode)).append("\n");
    sb.append("    order: ").append(toIndentedString(order)).append("\n");
    sb.append("    path: ").append(toIndentedString(path)).append("\n");
    sb.append("    roomCode: ").append(toIndentedString(roomCode)).append("\n");
    sb.append("    roomType: ").append(toIndentedString(roomType)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    visualOrder: ").append(toIndentedString(visualOrder)).append("\n");
    sb.append("    pmSRoomCode: ").append(toIndentedString(pmSRoomCode)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

