/*
 * Hotel Content API
 * # APItude Hotel Content API  Hotel Content API has been designed to retrieve **all the details** of the hotels available in our [Hotel Booking API](/documentation/hotels/booking-api/api-reference/).   Hotel Content API contains several methods that allow you to obtain the details of the hotels as well as list of destinations, countries and the master types that complement the hotels informatoin (like room type descriptions, accommodation type descriptions, categories descriptions...).  Note that the Languages operation is connected to all the operations in which a description is returned, since we return the language code in which that description has been returned. 
 *
 * The version of the OpenAPI document: 1.0
 * Contact: apitude@hotelbeds.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.hotelbeds.content.sdk.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import travel.wink.hotelbeds.content.sdk.model.ApiContent;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Information describing a room.
 */
@JsonPropertyOrder({
  ApiRoom.JSON_PROPERTY_CHARACTERISTIC,
  ApiRoom.JSON_PROPERTY_CHARACTERISTIC_DESCRIPTION,
  ApiRoom.JSON_PROPERTY_CODE,
  ApiRoom.JSON_PROPERTY_DESCRIPTION,
  ApiRoom.JSON_PROPERTY_MAX_ADULTS,
  ApiRoom.JSON_PROPERTY_MAX_CHILDREN,
  ApiRoom.JSON_PROPERTY_MAX_PAX,
  ApiRoom.JSON_PROPERTY_MIN_ADULTS,
  ApiRoom.JSON_PROPERTY_MIN_PAX,
  ApiRoom.JSON_PROPERTY_TYPE,
  ApiRoom.JSON_PROPERTY_TYPE_DESCRIPTION
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-10-04T11:28:31.756188010+07:00[Asia/Bangkok]")
public class ApiRoom {
  public static final String JSON_PROPERTY_CHARACTERISTIC = "characteristic";
  private String characteristic;

  public static final String JSON_PROPERTY_CHARACTERISTIC_DESCRIPTION = "characteristicDescription";
  private ApiContent characteristicDescription;

  public static final String JSON_PROPERTY_CODE = "code";
  private String code;

  public static final String JSON_PROPERTY_DESCRIPTION = "description";
  private String description;

  public static final String JSON_PROPERTY_MAX_ADULTS = "maxAdults";
  private Integer maxAdults;

  public static final String JSON_PROPERTY_MAX_CHILDREN = "maxChildren";
  private Integer maxChildren;

  public static final String JSON_PROPERTY_MAX_PAX = "maxPax";
  private Integer maxPax;

  public static final String JSON_PROPERTY_MIN_ADULTS = "minAdults";
  private Integer minAdults;

  public static final String JSON_PROPERTY_MIN_PAX = "minPax";
  private Integer minPax;

  public static final String JSON_PROPERTY_TYPE = "type";
  private String type;

  public static final String JSON_PROPERTY_TYPE_DESCRIPTION = "typeDescription";
  private ApiContent typeDescription;

  public ApiRoom() {
  }

  public ApiRoom characteristic(String characteristic) {
    
    this.characteristic = characteristic;
    return this;
  }

   /**
   * Code of the room characteristic.
   * @return characteristic
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CHARACTERISTIC)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCharacteristic() {
    return characteristic;
  }


  @JsonProperty(JSON_PROPERTY_CHARACTERISTIC)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCharacteristic(String characteristic) {
    this.characteristic = characteristic;
  }


  public ApiRoom characteristicDescription(ApiContent characteristicDescription) {
    
    this.characteristicDescription = characteristicDescription;
    return this;
  }

   /**
   * Get characteristicDescription
   * @return characteristicDescription
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_CHARACTERISTIC_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ApiContent getCharacteristicDescription() {
    return characteristicDescription;
  }


  @JsonProperty(JSON_PROPERTY_CHARACTERISTIC_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCharacteristicDescription(ApiContent characteristicDescription) {
    this.characteristicDescription = characteristicDescription;
  }


  public ApiRoom code(String code) {
    
    this.code = code;
    return this;
  }

   /**
   * Code of the room.
   * @return code
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCode() {
    return code;
  }


  @JsonProperty(JSON_PROPERTY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCode(String code) {
    this.code = code;
  }


  public ApiRoom description(String description) {
    
    this.description = description;
    return this;
  }

   /**
   * Description of the room.
   * @return description
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDescription() {
    return description;
  }


  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDescription(String description) {
    this.description = description;
  }


  public ApiRoom maxAdults(Integer maxAdults) {
    
    this.maxAdults = maxAdults;
    return this;
  }

   /**
   * Maximum number of adults allowed in the room.
   * @return maxAdults
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_MAX_ADULTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getMaxAdults() {
    return maxAdults;
  }


  @JsonProperty(JSON_PROPERTY_MAX_ADULTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMaxAdults(Integer maxAdults) {
    this.maxAdults = maxAdults;
  }


  public ApiRoom maxChildren(Integer maxChildren) {
    
    this.maxChildren = maxChildren;
    return this;
  }

   /**
   * Maximum number of children allowed in the room.
   * @return maxChildren
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_MAX_CHILDREN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getMaxChildren() {
    return maxChildren;
  }


  @JsonProperty(JSON_PROPERTY_MAX_CHILDREN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMaxChildren(Integer maxChildren) {
    this.maxChildren = maxChildren;
  }


  public ApiRoom maxPax(Integer maxPax) {
    
    this.maxPax = maxPax;
    return this;
  }

   /**
   * Maximum number of paxes allowed in the room.
   * @return maxPax
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_MAX_PAX)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getMaxPax() {
    return maxPax;
  }


  @JsonProperty(JSON_PROPERTY_MAX_PAX)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMaxPax(Integer maxPax) {
    this.maxPax = maxPax;
  }


  public ApiRoom minAdults(Integer minAdults) {
    
    this.minAdults = minAdults;
    return this;
  }

   /**
   * Minimum number of adults allowed in the room.
   * @return minAdults
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_MIN_ADULTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getMinAdults() {
    return minAdults;
  }


  @JsonProperty(JSON_PROPERTY_MIN_ADULTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMinAdults(Integer minAdults) {
    this.minAdults = minAdults;
  }


  public ApiRoom minPax(Integer minPax) {
    
    this.minPax = minPax;
    return this;
  }

   /**
   * Minimum number of adults allowed in the room.
   * @return minPax
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_MIN_PAX)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getMinPax() {
    return minPax;
  }


  @JsonProperty(JSON_PROPERTY_MIN_PAX)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMinPax(Integer minPax) {
    this.minPax = minPax;
  }


  public ApiRoom type(String type) {
    
    this.type = type;
    return this;
  }

   /**
   * Code of the room type. Returned only for Unified clients.
   * @return type
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(String type) {
    this.type = type;
  }


  public ApiRoom typeDescription(ApiContent typeDescription) {
    
    this.typeDescription = typeDescription;
    return this;
  }

   /**
   * Get typeDescription
   * @return typeDescription
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TYPE_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ApiContent getTypeDescription() {
    return typeDescription;
  }


  @JsonProperty(JSON_PROPERTY_TYPE_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTypeDescription(ApiContent typeDescription) {
    this.typeDescription = typeDescription;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ApiRoom apiRoom = (ApiRoom) o;
    return Objects.equals(this.characteristic, apiRoom.characteristic) &&
        Objects.equals(this.characteristicDescription, apiRoom.characteristicDescription) &&
        Objects.equals(this.code, apiRoom.code) &&
        Objects.equals(this.description, apiRoom.description) &&
        Objects.equals(this.maxAdults, apiRoom.maxAdults) &&
        Objects.equals(this.maxChildren, apiRoom.maxChildren) &&
        Objects.equals(this.maxPax, apiRoom.maxPax) &&
        Objects.equals(this.minAdults, apiRoom.minAdults) &&
        Objects.equals(this.minPax, apiRoom.minPax) &&
        Objects.equals(this.type, apiRoom.type) &&
        Objects.equals(this.typeDescription, apiRoom.typeDescription);
  }

  @Override
  public int hashCode() {
    return Objects.hash(characteristic, characteristicDescription, code, description, maxAdults, maxChildren, maxPax, minAdults, minPax, type, typeDescription);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ApiRoom {\n");
    sb.append("    characteristic: ").append(toIndentedString(characteristic)).append("\n");
    sb.append("    characteristicDescription: ").append(toIndentedString(characteristicDescription)).append("\n");
    sb.append("    code: ").append(toIndentedString(code)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    maxAdults: ").append(toIndentedString(maxAdults)).append("\n");
    sb.append("    maxChildren: ").append(toIndentedString(maxChildren)).append("\n");
    sb.append("    maxPax: ").append(toIndentedString(maxPax)).append("\n");
    sb.append("    minAdults: ").append(toIndentedString(minAdults)).append("\n");
    sb.append("    minPax: ").append(toIndentedString(minPax)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    typeDescription: ").append(toIndentedString(typeDescription)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

