/*
 * Wink API
 *  # Introduction  Welcome to the Wink API - A programmer-friendly way to manage, sell and book travel inventory on the Wink platform. The API gives you all the tools you need to ready your properties and inventory for sale across 1000s of our native sales channels.  Integrators, affiliates, travel agents and content creators have the ability search for your travel inventory and promote / sell it in a wide variety of ways.   # Integrations  We have already integrated with the most well-known channel managers so you don't have to. To see our current integrations, please go to https://extranet.wink.travel and scroll to Connectivity section. Once your properties are set up, you can finish the setup by mapping your property to Wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API.   # Intended Audience  Programmers are [most likely] a requirement to start integrating with Wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible.  - Hotel chains  - Hotel brands  - Travel tech companies  - Destination sites  - Integrators  - Aggregators  - Destination management companies  - Travel agencies  - OTAs   ## APIs  Not every integrator needs every API. For that reason, we have separated APIs into context.  ### Test API   - [Ping](/ping): The Ping API is a quick test endpoint to verify that your credentials work Wink.  ### Common APIs  - [Notifications](/notifications): The Notifications API is a way for us to stay in touch with your user, property or affiliate account. - [User Settings](/user-settings): The User Settings API exposes endpoints to allow 3rd party integrators to communicate with Wink.  ### Consume APIs Consume endpoints are for developers who want to find existing travel inventory and either book it or use it to advertise through one of their Wink affiliate accounts.   - [Configuration](/engine-client): A single endpoint to retrieve whitelabel + customization information for the booking engine.  - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags.  - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API..  - [Booking](/booking): All APIs related to creating bookings on the platform.  - [Travel Agent](/travel-agent): The Travel Agent API exposes endpoints to manage agent-facilitated bookings.   ### Produce APIs  Produce endpoints are for developers who want to create and manage travel inventory.   #### Property  - [Property registration](/extranet/property/register): As a producer, this is, oftentimes, where you start your journey. These endpoints let you create properties on Wink.  - [Property](/extranet/property): This collection of property endpoints are mostly management endpoints that let you display, change status and similar for your existing properties.  - [Facilities](/extranet/facilities): This collection of endpoints let you manage facilities; such as room types.  - [Experiences](/extranet/experiences): This collection of endpoints let you manage experiences, such as activities.  - [Monetize](/extranet/monetize): The Monetize API exposes endpoints for managing cancellation polies, rate plans, promotions and more on Wink.  - [Distribution](/extranet/distribution): The Distribution API exposes endpoints for sales channels, connecting with affiliates, managing rates and inventory calendars and more on Wink.  - [Property Booking](/extranet/booking): The Property Booking API exposes endpoints for managing bookings and reviews at the property-level.   #### Affiliate  - [Affiliate](/affiliate): This collection of affiliate endpoints are mostly management endpoints that let you display, change status and similar for your existing accounts.  - [Browse](/affiliate/browse): The Browse API exposes endpoints for affiliates to find suppliers and inventory to sell.  - [Inventory](/affiliate/inventory): The Inventory API exposes endpoints for affiliates to manage the inventory they want to sell and how they want to sell it.  - [Sales Channel](/affiliate/sales-channel): The Sales Channel API exposes endpoints for affiliates to manage existing sales channels as well as find new ones.  - [WinkLinks](/affiliate/winklinks): The WinkLinks API exposes endpoints for affiliates to manage their WinkLinks page.   #### Rate provider  - [Channel manager](/channel-manager): The Channel Manager API enables external channel manager partners to map, exchange rate / availability information with us as well as be informed of bookings that occur on the Wink platform for one of their properties.   ### Taxonomy APIs  Taxonomy endpoints are for developers who want to consume and produce travel inventory and need taxonomies of standard and non-standard codes for inventory types, classes, statuses etc.   - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies.   ### Insight APIs  Insight endpoints do exactly what the name implies - They offer platform-level insight into the activities of producers and consumers.   - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics.   ### Payment APIs  Payment endpoints are for developers who want to purchase travel inventory. This can be done via the API as a registered Travel Agent or using our API in conjunction with our PCI compliant payment widget for all other entities.   - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.   ## SDKs  We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).   - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)   ## Usage  These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.   ## Versioning  We chose to version our endpoints in a way that we hope affects your integration minimally. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.   ## Release history  - Follow updates on Github: https://github.com/wink-travel/wink-sdk-java/blob/master/CHANGELOG.md    # Inventory API The Inventory API exposes endpoints to retrieve inventory you already know about. This API lets you:  1. Consume shareable links. 2. Load up a known property with availability. 3. Load up all inventories that were created by our affiliates such as grids, maps, and individual items.  Browse the endpoints in the left navigation bar to get started.  
 *
 * The version of the OpenAPI document: 30.3.1
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.inventory.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import travel.wink.sdk.inventory.model.AddressNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.ContactNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.DowPatternGroupNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.GeoJsonPointNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.RatePlanNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.SimpleDescriptionNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.SimpleMultimediaNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.SocialNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.TravelInventoryRecognitionNonAuthenticatedEntity;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * The original add-on record created by the property.
 */
@JsonPropertyOrder({
  AddOnNonAuthenticatedEntity.JSON_PROPERTY_IDENTIFIER,
  AddOnNonAuthenticatedEntity.JSON_PROPERTY_HOTEL_IDENTIFIER,
  AddOnNonAuthenticatedEntity.JSON_PROPERTY_FEATURED_IND,
  AddOnNonAuthenticatedEntity.JSON_PROPERTY_LIFESTYLE_TYPE,
  AddOnNonAuthenticatedEntity.JSON_PROPERTY_LOCATION,
  AddOnNonAuthenticatedEntity.JSON_PROPERTY_DESCRIPTIONS,
  AddOnNonAuthenticatedEntity.JSON_PROPERTY_MULTIMEDIAS,
  AddOnNonAuthenticatedEntity.JSON_PROPERTY_CONTACT,
  AddOnNonAuthenticatedEntity.JSON_PROPERTY_ADDRESS,
  AddOnNonAuthenticatedEntity.JSON_PROPERTY_COMMISSIONABLE,
  AddOnNonAuthenticatedEntity.JSON_PROPERTY_NAME,
  AddOnNonAuthenticatedEntity.JSON_PROPERTY_PROXIMITY_CODE,
  AddOnNonAuthenticatedEntity.JSON_PROPERTY_SORT,
  AddOnNonAuthenticatedEntity.JSON_PROPERTY_MIN_AGE_APPROPRIATE_CODE,
  AddOnNonAuthenticatedEntity.JSON_PROPERTY_BOOKABLE,
  AddOnNonAuthenticatedEntity.JSON_PROPERTY_ACTIVE,
  AddOnNonAuthenticatedEntity.JSON_PROPERTY_DISABILITY_FEATURES,
  AddOnNonAuthenticatedEntity.JSON_PROPERTY_SECURITY_FEATURES,
  AddOnNonAuthenticatedEntity.JSON_PROPERTY_SOCIALS,
  AddOnNonAuthenticatedEntity.JSON_PROPERTY_PRICE_POINT,
  AddOnNonAuthenticatedEntity.JSON_PROPERTY_RECOGNITION_LIST,
  AddOnNonAuthenticatedEntity.JSON_PROPERTY_APPLICABLE_START,
  AddOnNonAuthenticatedEntity.JSON_PROPERTY_APPLICABLE_END,
  AddOnNonAuthenticatedEntity.JSON_PROPERTY_RESERVATION_REQUIRED_IND,
  AddOnNonAuthenticatedEntity.JSON_PROPERTY_OPENS,
  AddOnNonAuthenticatedEntity.JSON_PROPERTY_CLOSES,
  AddOnNonAuthenticatedEntity.JSON_PROPERTY_DAYS_OF_WEEK,
  AddOnNonAuthenticatedEntity.JSON_PROPERTY_NUMBER_OF_UNITS,
  AddOnNonAuthenticatedEntity.JSON_PROPERTY_RATE_PLAN_IDENTIFIER,
  AddOnNonAuthenticatedEntity.JSON_PROPERTY_RATE_PLAN,
  AddOnNonAuthenticatedEntity.JSON_PROPERTY_MANDATORY
})
@JsonTypeName("AddOn_Non_Authenticated_Entity")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-08-12T10:04:27.328233927+07:00[Asia/Bangkok]")
public class AddOnNonAuthenticatedEntity {
  public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
  private UUID identifier;

  public static final String JSON_PROPERTY_HOTEL_IDENTIFIER = "hotelIdentifier";
  private UUID hotelIdentifier;

  public static final String JSON_PROPERTY_FEATURED_IND = "featuredInd";
  private Boolean featuredInd;

  /**
   * Indicate the type of lifestyle this inventory should be associated with.
   */
  public enum LifestyleTypeEnum {
    HEALTH_FITNESS("LIFESTYLE_HEALTH_FITNESS"),
    
    RELAX("LIFESTYLE_RELAX"),
    
    ADULT_ONLY("LIFESTYLE_ADULT_ONLY"),
    
    ADVENTURE("LIFESTYLE_ADVENTURE"),
    
    BUSINESS("LIFESTYLE_BUSINESS"),
    
    LGBT("LIFESTYLE_LGBT"),
    
    SINGLE_PARENT("LIFESTYLE_SINGLE_PARENT"),
    
    SOLO_FEMALE("LIFESTYLE_SOLO_FEMALE"),
    
    BEAUTY("LIFESTYLE_BEAUTY"),
    
    FOODIE("LIFESTYLE_FOODIE"),
    
    FAMILY("LIFESTYLE_FAMILY"),
    
    ROMANCE("LIFESTYLE_ROMANCE"),
    
    COUPLE("LIFESTYLE_COUPLE"),
    
    SOLO("LIFESTYLE_SOLO"),
    
    BACKPACKER("LIFESTYLE_BACKPACKER"),
    
    SHOPPING("LIFESTYLE_SHOPPING"),
    
    SPORTS("LIFESTYLE_SPORTS"),
    
    MOUNTAIN("LIFESTYLE_MOUNTAIN"),
    
    BEACH("LIFESTYLE_BEACH"),
    
    CITY("LIFESTYLE_CITY"),
    
    COUNTRY("LIFESTYLE_COUNTRY"),
    
    CULTURE("LIFESTYLE_CULTURE"),
    
    ECO("LIFESTYLE_ECO");

    private String value;

    LifestyleTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static LifestyleTypeEnum fromValue(String value) {
      for (LifestyleTypeEnum b : LifestyleTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_LIFESTYLE_TYPE = "lifestyleType";
  private LifestyleTypeEnum lifestyleType;

  public static final String JSON_PROPERTY_LOCATION = "location";
  private GeoJsonPointNonAuthenticatedEntity location;

  public static final String JSON_PROPERTY_DESCRIPTIONS = "descriptions";
  private List<SimpleDescriptionNonAuthenticatedEntity> descriptions = new ArrayList<>();

  public static final String JSON_PROPERTY_MULTIMEDIAS = "multimedias";
  private List<SimpleMultimediaNonAuthenticatedEntity> multimedias = new ArrayList<>();

  public static final String JSON_PROPERTY_CONTACT = "contact";
  private ContactNonAuthenticatedEntity contact;

  public static final String JSON_PROPERTY_ADDRESS = "address";
  private AddressNonAuthenticatedEntity address;

  public static final String JSON_PROPERTY_COMMISSIONABLE = "commissionable";
  private Boolean commissionable = true;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_PROXIMITY_CODE = "proximityCode";
  private String proximityCode;

  public static final String JSON_PROPERTY_SORT = "sort";
  private Integer sort;

  public static final String JSON_PROPERTY_MIN_AGE_APPROPRIATE_CODE = "minAgeAppropriateCode";
  private String minAgeAppropriateCode;

  public static final String JSON_PROPERTY_BOOKABLE = "bookable";
  private Boolean bookable = true;

  public static final String JSON_PROPERTY_ACTIVE = "active";
  private Boolean active = true;

  public static final String JSON_PROPERTY_DISABILITY_FEATURES = "disabilityFeatures";
  private List<String> disabilityFeatures;

  public static final String JSON_PROPERTY_SECURITY_FEATURES = "securityFeatures";
  private List<String> securityFeatures;

  public static final String JSON_PROPERTY_SOCIALS = "socials";
  private List<SocialNonAuthenticatedEntity> socials;

  /**
   * Level of expensiveness.
   */
  public enum PricePointEnum {
    HALF("HALF"),
    
    ONE("ONE"),
    
    ONE_HALF("ONE_HALF"),
    
    TWO("TWO"),
    
    TWO_HALF("TWO_HALF"),
    
    THREE("THREE"),
    
    THREE_HALF("THREE_HALF"),
    
    FOUR("FOUR"),
    
    FOUR_HALF("FOUR_HALF"),
    
    FIVE("FIVE");

    private String value;

    PricePointEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static PricePointEnum fromValue(String value) {
      for (PricePointEnum b : PricePointEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_PRICE_POINT = "pricePoint";
  private PricePointEnum pricePoint = PricePointEnum.THREE;

  public static final String JSON_PROPERTY_RECOGNITION_LIST = "recognitionList";
  private List<TravelInventoryRecognitionNonAuthenticatedEntity> recognitionList;

  public static final String JSON_PROPERTY_APPLICABLE_START = "applicableStart";
  private LocalDate applicableStart;

  public static final String JSON_PROPERTY_APPLICABLE_END = "applicableEnd";
  private LocalDate applicableEnd;

  public static final String JSON_PROPERTY_RESERVATION_REQUIRED_IND = "reservationRequiredInd";
  private Boolean reservationRequiredInd;

  public static final String JSON_PROPERTY_OPENS = "opens";
  private String opens;

  public static final String JSON_PROPERTY_CLOSES = "closes";
  private String closes;

  public static final String JSON_PROPERTY_DAYS_OF_WEEK = "daysOfWeek";
  private DowPatternGroupNonAuthenticatedEntity daysOfWeek;

  public static final String JSON_PROPERTY_NUMBER_OF_UNITS = "numberOfUnits";
  private Integer numberOfUnits = 0;

  public static final String JSON_PROPERTY_RATE_PLAN_IDENTIFIER = "ratePlanIdentifier";
  private UUID ratePlanIdentifier;

  public static final String JSON_PROPERTY_RATE_PLAN = "ratePlan";
  private RatePlanNonAuthenticatedEntity ratePlan;

  public static final String JSON_PROPERTY_MANDATORY = "mandatory";
  private Boolean mandatory = false;

  public AddOnNonAuthenticatedEntity() {
  }

  public AddOnNonAuthenticatedEntity identifier(UUID identifier) {
    
    this.identifier = identifier;
    return this;
  }

   /**
   * Unique record identifier
   * @return identifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getIdentifier() {
    return identifier;
  }


  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setIdentifier(UUID identifier) {
    this.identifier = identifier;
  }


  public AddOnNonAuthenticatedEntity hotelIdentifier(UUID hotelIdentifier) {
    
    this.hotelIdentifier = hotelIdentifier;
    return this;
  }

   /**
   * Hotel identifier.
   * @return hotelIdentifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_HOTEL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getHotelIdentifier() {
    return hotelIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_HOTEL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setHotelIdentifier(UUID hotelIdentifier) {
    this.hotelIdentifier = hotelIdentifier;
  }


  public AddOnNonAuthenticatedEntity featuredInd(Boolean featuredInd) {
    
    this.featuredInd = featuredInd;
    return this;
  }

   /**
   * Indicates whether this inventory is featured. Use this flag as a way to signify that this inventory is special.
   * @return featuredInd
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_FEATURED_IND)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getFeaturedInd() {
    return featuredInd;
  }


  @JsonProperty(JSON_PROPERTY_FEATURED_IND)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setFeaturedInd(Boolean featuredInd) {
    this.featuredInd = featuredInd;
  }


  public AddOnNonAuthenticatedEntity lifestyleType(LifestyleTypeEnum lifestyleType) {
    
    this.lifestyleType = lifestyleType;
    return this;
  }

   /**
   * Indicate the type of lifestyle this inventory should be associated with.
   * @return lifestyleType
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_LIFESTYLE_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LifestyleTypeEnum getLifestyleType() {
    return lifestyleType;
  }


  @JsonProperty(JSON_PROPERTY_LIFESTYLE_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLifestyleType(LifestyleTypeEnum lifestyleType) {
    this.lifestyleType = lifestyleType;
  }


  public AddOnNonAuthenticatedEntity location(GeoJsonPointNonAuthenticatedEntity location) {
    
    this.location = location;
    return this;
  }

   /**
   * Get location
   * @return location
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_LOCATION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public GeoJsonPointNonAuthenticatedEntity getLocation() {
    return location;
  }


  @JsonProperty(JSON_PROPERTY_LOCATION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setLocation(GeoJsonPointNonAuthenticatedEntity location) {
    this.location = location;
  }


  public AddOnNonAuthenticatedEntity descriptions(List<SimpleDescriptionNonAuthenticatedEntity> descriptions) {
    
    this.descriptions = descriptions;
    return this;
  }

  public AddOnNonAuthenticatedEntity addDescriptionsItem(SimpleDescriptionNonAuthenticatedEntity descriptionsItem) {
    if (this.descriptions == null) {
      this.descriptions = new ArrayList<>();
    }
    this.descriptions.add(descriptionsItem);
    return this;
  }

   /**
   * Localized descriptions describing inventory.
   * @return descriptions
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_DESCRIPTIONS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<SimpleDescriptionNonAuthenticatedEntity> getDescriptions() {
    return descriptions;
  }


  @JsonProperty(JSON_PROPERTY_DESCRIPTIONS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDescriptions(List<SimpleDescriptionNonAuthenticatedEntity> descriptions) {
    this.descriptions = descriptions;
  }


  public AddOnNonAuthenticatedEntity multimedias(List<SimpleMultimediaNonAuthenticatedEntity> multimedias) {
    
    this.multimedias = multimedias;
    return this;
  }

  public AddOnNonAuthenticatedEntity addMultimediasItem(SimpleMultimediaNonAuthenticatedEntity multimediasItem) {
    if (this.multimedias == null) {
      this.multimedias = new ArrayList<>();
    }
    this.multimedias.add(multimediasItem);
    return this;
  }

   /**
   * List of images / videos of inventory.
   * @return multimedias
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_MULTIMEDIAS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<SimpleMultimediaNonAuthenticatedEntity> getMultimedias() {
    return multimedias;
  }


  @JsonProperty(JSON_PROPERTY_MULTIMEDIAS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setMultimedias(List<SimpleMultimediaNonAuthenticatedEntity> multimedias) {
    this.multimedias = multimedias;
  }


  public AddOnNonAuthenticatedEntity contact(ContactNonAuthenticatedEntity contact) {
    
    this.contact = contact;
    return this;
  }

   /**
   * Get contact
   * @return contact
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_CONTACT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public ContactNonAuthenticatedEntity getContact() {
    return contact;
  }


  @JsonProperty(JSON_PROPERTY_CONTACT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setContact(ContactNonAuthenticatedEntity contact) {
    this.contact = contact;
  }


  public AddOnNonAuthenticatedEntity address(AddressNonAuthenticatedEntity address) {
    
    this.address = address;
    return this;
  }

   /**
   * Get address
   * @return address
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public AddressNonAuthenticatedEntity getAddress() {
    return address;
  }


  @JsonProperty(JSON_PROPERTY_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAddress(AddressNonAuthenticatedEntity address) {
    this.address = address;
  }


  public AddOnNonAuthenticatedEntity commissionable(Boolean commissionable) {
    
    this.commissionable = commissionable;
    return this;
  }

   /**
   * Indicate whether sales channels receive commission for selling this inventory.
   * @return commissionable
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_COMMISSIONABLE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getCommissionable() {
    return commissionable;
  }


  @JsonProperty(JSON_PROPERTY_COMMISSIONABLE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCommissionable(Boolean commissionable) {
    this.commissionable = commissionable;
  }


  public AddOnNonAuthenticatedEntity name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * Internal name of inventory.
   * @return name
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setName(String name) {
    this.name = name;
  }


  public AddOnNonAuthenticatedEntity proximityCode(String proximityCode) {
    
    this.proximityCode = proximityCode;
    return this;
  }

   /**
   * Supported OTA specification &#x60;PRX&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory)
   * @return proximityCode
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_PROXIMITY_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getProximityCode() {
    return proximityCode;
  }


  @JsonProperty(JSON_PROPERTY_PROXIMITY_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setProximityCode(String proximityCode) {
    this.proximityCode = proximityCode;
  }


  public AddOnNonAuthenticatedEntity sort(Integer sort) {
    
    this.sort = sort;
    return this;
  }

   /**
   * Use this property to sort an inventory in a list of activities.
   * @return sort
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getSort() {
    return sort;
  }


  @JsonProperty(JSON_PROPERTY_SORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSort(Integer sort) {
    this.sort = sort;
  }


  public AddOnNonAuthenticatedEntity minAgeAppropriateCode(String minAgeAppropriateCode) {
    
    this.minAgeAppropriateCode = minAgeAppropriateCode;
    return this;
  }

   /**
   * Supported OTA specification &#x60;AQC&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory)
   * @return minAgeAppropriateCode
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_MIN_AGE_APPROPRIATE_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getMinAgeAppropriateCode() {
    return minAgeAppropriateCode;
  }


  @JsonProperty(JSON_PROPERTY_MIN_AGE_APPROPRIATE_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMinAgeAppropriateCode(String minAgeAppropriateCode) {
    this.minAgeAppropriateCode = minAgeAppropriateCode;
  }


  public AddOnNonAuthenticatedEntity bookable(Boolean bookable) {
    
    this.bookable = bookable;
    return this;
  }

   /**
   * Indicates if this inventory can be added to a booking or if it is read-only marketing material only.
   * @return bookable
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_BOOKABLE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getBookable() {
    return bookable;
  }


  @JsonProperty(JSON_PROPERTY_BOOKABLE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setBookable(Boolean bookable) {
    this.bookable = bookable;
  }


  public AddOnNonAuthenticatedEntity active(Boolean active) {
    
    this.active = active;
    return this;
  }

   /**
   * Modify inventory availability with this flag.
   * @return active
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_ACTIVE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getActive() {
    return active;
  }


  @JsonProperty(JSON_PROPERTY_ACTIVE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setActive(Boolean active) {
    this.active = active;
  }


  public AddOnNonAuthenticatedEntity disabilityFeatures(List<String> disabilityFeatures) {
    
    this.disabilityFeatures = disabilityFeatures;
    return this;
  }

  public AddOnNonAuthenticatedEntity addDisabilityFeaturesItem(String disabilityFeaturesItem) {
    if (this.disabilityFeatures == null) {
      this.disabilityFeatures = new ArrayList<>();
    }
    this.disabilityFeatures.add(disabilityFeaturesItem);
    return this;
  }

   /**
   * Supported OTA specification &#x60;PHY&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory)
   * @return disabilityFeatures
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_DISABILITY_FEATURES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getDisabilityFeatures() {
    return disabilityFeatures;
  }


  @JsonProperty(JSON_PROPERTY_DISABILITY_FEATURES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDisabilityFeatures(List<String> disabilityFeatures) {
    this.disabilityFeatures = disabilityFeatures;
  }


  public AddOnNonAuthenticatedEntity securityFeatures(List<String> securityFeatures) {
    
    this.securityFeatures = securityFeatures;
    return this;
  }

  public AddOnNonAuthenticatedEntity addSecurityFeaturesItem(String securityFeaturesItem) {
    if (this.securityFeatures == null) {
      this.securityFeatures = new ArrayList<>();
    }
    this.securityFeatures.add(securityFeaturesItem);
    return this;
  }

   /**
   * Supported OTA specification &#x60;SEC&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory)
   * @return securityFeatures
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SECURITY_FEATURES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getSecurityFeatures() {
    return securityFeatures;
  }


  @JsonProperty(JSON_PROPERTY_SECURITY_FEATURES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSecurityFeatures(List<String> securityFeatures) {
    this.securityFeatures = securityFeatures;
  }


  public AddOnNonAuthenticatedEntity socials(List<SocialNonAuthenticatedEntity> socials) {
    
    this.socials = socials;
    return this;
  }

  public AddOnNonAuthenticatedEntity addSocialsItem(SocialNonAuthenticatedEntity socialsItem) {
    if (this.socials == null) {
      this.socials = new ArrayList<>();
    }
    this.socials.add(socialsItem);
    return this;
  }

   /**
   * Social network accounts for inventory (if applicable).
   * @return socials
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SOCIALS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<SocialNonAuthenticatedEntity> getSocials() {
    return socials;
  }


  @JsonProperty(JSON_PROPERTY_SOCIALS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSocials(List<SocialNonAuthenticatedEntity> socials) {
    this.socials = socials;
  }


  public AddOnNonAuthenticatedEntity pricePoint(PricePointEnum pricePoint) {
    
    this.pricePoint = pricePoint;
    return this;
  }

   /**
   * Level of expensiveness.
   * @return pricePoint
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_PRICE_POINT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public PricePointEnum getPricePoint() {
    return pricePoint;
  }


  @JsonProperty(JSON_PROPERTY_PRICE_POINT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPricePoint(PricePointEnum pricePoint) {
    this.pricePoint = pricePoint;
  }


  public AddOnNonAuthenticatedEntity recognitionList(List<TravelInventoryRecognitionNonAuthenticatedEntity> recognitionList) {
    
    this.recognitionList = recognitionList;
    return this;
  }

  public AddOnNonAuthenticatedEntity addRecognitionListItem(TravelInventoryRecognitionNonAuthenticatedEntity recognitionListItem) {
    if (this.recognitionList == null) {
      this.recognitionList = new ArrayList<>();
    }
    this.recognitionList.add(recognitionListItem);
    return this;
  }

   /**
   * Inventory-level recognition.
   * @return recognitionList
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_RECOGNITION_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<TravelInventoryRecognitionNonAuthenticatedEntity> getRecognitionList() {
    return recognitionList;
  }


  @JsonProperty(JSON_PROPERTY_RECOGNITION_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRecognitionList(List<TravelInventoryRecognitionNonAuthenticatedEntity> recognitionList) {
    this.recognitionList = recognitionList;
  }


  public AddOnNonAuthenticatedEntity applicableStart(LocalDate applicableStart) {
    
    this.applicableStart = applicableStart;
    return this;
  }

   /**
   * Start month and day or date for which the attraction (e.g. the start of a season) is available. This date property signifies that the inventory is recurring and / or seasonal. If the date is in the past, only day and month will be used to infer seasonality. If the date is a future date, it will be interpreted as a starting date.
   * @return applicableStart
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_APPLICABLE_START)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LocalDate getApplicableStart() {
    return applicableStart;
  }


  @JsonProperty(JSON_PROPERTY_APPLICABLE_START)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setApplicableStart(LocalDate applicableStart) {
    this.applicableStart = applicableStart;
  }


  public AddOnNonAuthenticatedEntity applicableEnd(LocalDate applicableEnd) {
    
    this.applicableEnd = applicableEnd;
    return this;
  }

   /**
   * End month and day or date for which the attraction (e.g. the start of a season) is available. This date property signifies that the inventory is recurring and / or seasonal. If the date is in the past, only day and month will be used to infer seasonality. If the date is a future date, it will be interpreted as a ending date.
   * @return applicableEnd
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_APPLICABLE_END)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LocalDate getApplicableEnd() {
    return applicableEnd;
  }


  @JsonProperty(JSON_PROPERTY_APPLICABLE_END)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setApplicableEnd(LocalDate applicableEnd) {
    this.applicableEnd = applicableEnd;
  }


  public AddOnNonAuthenticatedEntity reservationRequiredInd(Boolean reservationRequiredInd) {
    
    this.reservationRequiredInd = reservationRequiredInd;
    return this;
  }

   /**
   * Indicates whether a reservation is required to participate in this inventory.
   * @return reservationRequiredInd
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_RESERVATION_REQUIRED_IND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getReservationRequiredInd() {
    return reservationRequiredInd;
  }


  @JsonProperty(JSON_PROPERTY_RESERVATION_REQUIRED_IND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReservationRequiredInd(Boolean reservationRequiredInd) {
    this.reservationRequiredInd = reservationRequiredInd;
  }


  public AddOnNonAuthenticatedEntity opens(String opens) {
    
    this.opens = opens;
    return this;
  }

   /**
   * Opening time of inventory (if applicable). Leave empty if inventory is always available.
   * @return opens
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_OPENS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getOpens() {
    return opens;
  }


  @JsonProperty(JSON_PROPERTY_OPENS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOpens(String opens) {
    this.opens = opens;
  }


  public AddOnNonAuthenticatedEntity closes(String closes) {
    
    this.closes = closes;
    return this;
  }

   /**
   * Closing time of inventory (if applicable). Leave empty if inventory is always available.
   * @return closes
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CLOSES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCloses() {
    return closes;
  }


  @JsonProperty(JSON_PROPERTY_CLOSES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCloses(String closes) {
    this.closes = closes;
  }


  public AddOnNonAuthenticatedEntity daysOfWeek(DowPatternGroupNonAuthenticatedEntity daysOfWeek) {
    
    this.daysOfWeek = daysOfWeek;
    return this;
  }

   /**
   * Get daysOfWeek
   * @return daysOfWeek
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_DAYS_OF_WEEK)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public DowPatternGroupNonAuthenticatedEntity getDaysOfWeek() {
    return daysOfWeek;
  }


  @JsonProperty(JSON_PROPERTY_DAYS_OF_WEEK)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDaysOfWeek(DowPatternGroupNonAuthenticatedEntity daysOfWeek) {
    this.daysOfWeek = daysOfWeek;
  }


  public AddOnNonAuthenticatedEntity numberOfUnits(Integer numberOfUnits) {
    
    this.numberOfUnits = numberOfUnits;
    return this;
  }

   /**
   * Total number of add-ons available to purchase.
   * minimum: 0
   * @return numberOfUnits
  **/
  @jakarta.annotation.Nonnull
  @NotNull
 @Min(0)
  @JsonProperty(JSON_PROPERTY_NUMBER_OF_UNITS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getNumberOfUnits() {
    return numberOfUnits;
  }


  @JsonProperty(JSON_PROPERTY_NUMBER_OF_UNITS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setNumberOfUnits(Integer numberOfUnits) {
    this.numberOfUnits = numberOfUnits;
  }


  public AddOnNonAuthenticatedEntity ratePlanIdentifier(UUID ratePlanIdentifier) {
    
    this.ratePlanIdentifier = ratePlanIdentifier;
    return this;
  }

   /**
   * Pass an optional rate plan identifier if you want to add more complex restrictions to this add-on. Example: You want the add-on to only be available when a specific room is available.
   * @return ratePlanIdentifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_RATE_PLAN_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public UUID getRatePlanIdentifier() {
    return ratePlanIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_RATE_PLAN_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRatePlanIdentifier(UUID ratePlanIdentifier) {
    this.ratePlanIdentifier = ratePlanIdentifier;
  }


  public AddOnNonAuthenticatedEntity ratePlan(RatePlanNonAuthenticatedEntity ratePlan) {
    
    this.ratePlan = ratePlan;
    return this;
  }

   /**
   * Get ratePlan
   * @return ratePlan
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_RATE_PLAN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public RatePlanNonAuthenticatedEntity getRatePlan() {
    return ratePlan;
  }


  @JsonProperty(JSON_PROPERTY_RATE_PLAN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRatePlan(RatePlanNonAuthenticatedEntity ratePlan) {
    this.ratePlan = ratePlan;
  }


  public AddOnNonAuthenticatedEntity mandatory(Boolean mandatory) {
    
    this.mandatory = mandatory;
    return this;
  }

   /**
   * Make this add-on mandatory for all guests by enabling this flag.
   * @return mandatory
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_MANDATORY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getMandatory() {
    return mandatory;
  }


  @JsonProperty(JSON_PROPERTY_MANDATORY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setMandatory(Boolean mandatory) {
    this.mandatory = mandatory;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AddOnNonAuthenticatedEntity addOnNonAuthenticatedEntity = (AddOnNonAuthenticatedEntity) o;
    return Objects.equals(this.identifier, addOnNonAuthenticatedEntity.identifier) &&
        Objects.equals(this.hotelIdentifier, addOnNonAuthenticatedEntity.hotelIdentifier) &&
        Objects.equals(this.featuredInd, addOnNonAuthenticatedEntity.featuredInd) &&
        Objects.equals(this.lifestyleType, addOnNonAuthenticatedEntity.lifestyleType) &&
        Objects.equals(this.location, addOnNonAuthenticatedEntity.location) &&
        Objects.equals(this.descriptions, addOnNonAuthenticatedEntity.descriptions) &&
        Objects.equals(this.multimedias, addOnNonAuthenticatedEntity.multimedias) &&
        Objects.equals(this.contact, addOnNonAuthenticatedEntity.contact) &&
        Objects.equals(this.address, addOnNonAuthenticatedEntity.address) &&
        Objects.equals(this.commissionable, addOnNonAuthenticatedEntity.commissionable) &&
        Objects.equals(this.name, addOnNonAuthenticatedEntity.name) &&
        Objects.equals(this.proximityCode, addOnNonAuthenticatedEntity.proximityCode) &&
        Objects.equals(this.sort, addOnNonAuthenticatedEntity.sort) &&
        Objects.equals(this.minAgeAppropriateCode, addOnNonAuthenticatedEntity.minAgeAppropriateCode) &&
        Objects.equals(this.bookable, addOnNonAuthenticatedEntity.bookable) &&
        Objects.equals(this.active, addOnNonAuthenticatedEntity.active) &&
        Objects.equals(this.disabilityFeatures, addOnNonAuthenticatedEntity.disabilityFeatures) &&
        Objects.equals(this.securityFeatures, addOnNonAuthenticatedEntity.securityFeatures) &&
        Objects.equals(this.socials, addOnNonAuthenticatedEntity.socials) &&
        Objects.equals(this.pricePoint, addOnNonAuthenticatedEntity.pricePoint) &&
        Objects.equals(this.recognitionList, addOnNonAuthenticatedEntity.recognitionList) &&
        Objects.equals(this.applicableStart, addOnNonAuthenticatedEntity.applicableStart) &&
        Objects.equals(this.applicableEnd, addOnNonAuthenticatedEntity.applicableEnd) &&
        Objects.equals(this.reservationRequiredInd, addOnNonAuthenticatedEntity.reservationRequiredInd) &&
        Objects.equals(this.opens, addOnNonAuthenticatedEntity.opens) &&
        Objects.equals(this.closes, addOnNonAuthenticatedEntity.closes) &&
        Objects.equals(this.daysOfWeek, addOnNonAuthenticatedEntity.daysOfWeek) &&
        Objects.equals(this.numberOfUnits, addOnNonAuthenticatedEntity.numberOfUnits) &&
        Objects.equals(this.ratePlanIdentifier, addOnNonAuthenticatedEntity.ratePlanIdentifier) &&
        Objects.equals(this.ratePlan, addOnNonAuthenticatedEntity.ratePlan) &&
        Objects.equals(this.mandatory, addOnNonAuthenticatedEntity.mandatory);
  }

  @Override
  public int hashCode() {
    return Objects.hash(identifier, hotelIdentifier, featuredInd, lifestyleType, location, descriptions, multimedias, contact, address, commissionable, name, proximityCode, sort, minAgeAppropriateCode, bookable, active, disabilityFeatures, securityFeatures, socials, pricePoint, recognitionList, applicableStart, applicableEnd, reservationRequiredInd, opens, closes, daysOfWeek, numberOfUnits, ratePlanIdentifier, ratePlan, mandatory);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AddOnNonAuthenticatedEntity {\n");
    sb.append("    identifier: ").append(toIndentedString(identifier)).append("\n");
    sb.append("    hotelIdentifier: ").append(toIndentedString(hotelIdentifier)).append("\n");
    sb.append("    featuredInd: ").append(toIndentedString(featuredInd)).append("\n");
    sb.append("    lifestyleType: ").append(toIndentedString(lifestyleType)).append("\n");
    sb.append("    location: ").append(toIndentedString(location)).append("\n");
    sb.append("    descriptions: ").append(toIndentedString(descriptions)).append("\n");
    sb.append("    multimedias: ").append(toIndentedString(multimedias)).append("\n");
    sb.append("    contact: ").append(toIndentedString(contact)).append("\n");
    sb.append("    address: ").append(toIndentedString(address)).append("\n");
    sb.append("    commissionable: ").append(toIndentedString(commissionable)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    proximityCode: ").append(toIndentedString(proximityCode)).append("\n");
    sb.append("    sort: ").append(toIndentedString(sort)).append("\n");
    sb.append("    minAgeAppropriateCode: ").append(toIndentedString(minAgeAppropriateCode)).append("\n");
    sb.append("    bookable: ").append(toIndentedString(bookable)).append("\n");
    sb.append("    active: ").append(toIndentedString(active)).append("\n");
    sb.append("    disabilityFeatures: ").append(toIndentedString(disabilityFeatures)).append("\n");
    sb.append("    securityFeatures: ").append(toIndentedString(securityFeatures)).append("\n");
    sb.append("    socials: ").append(toIndentedString(socials)).append("\n");
    sb.append("    pricePoint: ").append(toIndentedString(pricePoint)).append("\n");
    sb.append("    recognitionList: ").append(toIndentedString(recognitionList)).append("\n");
    sb.append("    applicableStart: ").append(toIndentedString(applicableStart)).append("\n");
    sb.append("    applicableEnd: ").append(toIndentedString(applicableEnd)).append("\n");
    sb.append("    reservationRequiredInd: ").append(toIndentedString(reservationRequiredInd)).append("\n");
    sb.append("    opens: ").append(toIndentedString(opens)).append("\n");
    sb.append("    closes: ").append(toIndentedString(closes)).append("\n");
    sb.append("    daysOfWeek: ").append(toIndentedString(daysOfWeek)).append("\n");
    sb.append("    numberOfUnits: ").append(toIndentedString(numberOfUnits)).append("\n");
    sb.append("    ratePlanIdentifier: ").append(toIndentedString(ratePlanIdentifier)).append("\n");
    sb.append("    ratePlan: ").append(toIndentedString(ratePlan)).append("\n");
    sb.append("    mandatory: ").append(toIndentedString(mandatory)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

