/*
 * Wink API
 *  # Introduction  Welcome to the Wink API - A programmer-friendly way to manage, sell and book travel inventory on the Wink platform. The API gives you all the tools you need to ready your properties and inventory for sale across 1000s of our native sales channels.  Integrators, affiliates, travel agents and content creators have the ability search for your travel inventory and promote / sell it in a wide variety of ways.   # Integrations  We have already integrated with the most well-known channel managers so you don't have to. To see our current integrations, please go to https://extranet.wink.travel and scroll to Connectivity section. Once your properties are set up, you can finish the setup by mapping your property to Wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API.   # Intended Audience  Programmers are [most likely] a requirement to start integrating with Wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible.  - Hotel chains  - Hotel brands  - Travel tech companies  - Destination sites  - Integrators  - Aggregators  - Destination management companies  - Travel agencies  - OTAs   ## APIs  Not every integrator needs every API. For that reason, we have separated APIs into context.  ### Test API   - [Ping](/ping): The Ping API is a quick test endpoint to verify that your credentials work Wink.  ### Common APIs  - [Notifications](/notifications): The Notifications API is a way for us to stay in touch with your user, property or affiliate account. - [User Settings](/user-settings): The User Settings API exposes endpoints to allow 3rd party integrators to communicate with Wink.  ### Consume APIs Consume endpoints are for developers who want to find existing travel inventory and either book it or use it to advertise through one of their Wink affiliate accounts.   - [Configuration](/engine-client): A single endpoint to retrieve whitelabel + customization information for the booking engine.  - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags.  - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API..  - [Booking](/booking): All APIs related to creating bookings on the platform.  - [Travel Agent](/travel-agent): The Travel Agent API exposes endpoints to manage agent-facilitated bookings.   ### Produce APIs  Produce endpoints are for developers who want to create and manage travel inventory.   #### Property  - [Property registration](/extranet/property/register): As a producer, this is, oftentimes, where you start your journey. These endpoints let you create properties on Wink.  - [Property](/extranet/property): This collection of property endpoints are mostly management endpoints that let you display, change status and similar for your existing properties.  - [Facilities](/extranet/facilities): This collection of endpoints let you manage facilities; such as room types.  - [Experiences](/extranet/experiences): This collection of endpoints let you manage experiences, such as activities.  - [Monetize](/extranet/monetize): The Monetize API exposes endpoints for managing cancellation polies, rate plans, promotions and more on Wink.  - [Distribution](/extranet/distribution): The Distribution API exposes endpoints for sales channels, connecting with affiliates, managing rates and inventory calendars and more on Wink.  - [Property Booking](/extranet/booking): The Property Booking API exposes endpoints for managing bookings and reviews at the property-level.   #### Affiliate  - [Affiliate](/affiliate): This collection of affiliate endpoints are mostly management endpoints that let you display, change status and similar for your existing accounts.  - [Browse](/affiliate/browse): The Browse API exposes endpoints for affiliates to find suppliers and inventory to sell.  - [Inventory](/affiliate/inventory): The Inventory API exposes endpoints for affiliates to manage the inventory they want to sell and how they want to sell it.  - [Sales Channel](/affiliate/sales-channel): The Sales Channel API exposes endpoints for affiliates to manage existing sales channels as well as find new ones.  - [WinkLinks](/affiliate/winklinks): The WinkLinks API exposes endpoints for affiliates to manage their WinkLinks page.   #### Rate provider  - [Channel manager](/channel-manager): The Channel Manager API enables external channel manager partners to map, exchange rate / availability information with us as well as be informed of bookings that occur on the Wink platform for one of their properties.   ### Taxonomy APIs  Taxonomy endpoints are for developers who want to consume and produce travel inventory and need taxonomies of standard and non-standard codes for inventory types, classes, statuses etc.   - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies.   ### Insight APIs  Insight endpoints do exactly what the name implies - They offer platform-level insight into the activities of producers and consumers.   - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics.   ### Payment APIs  Payment endpoints are for developers who want to purchase travel inventory. This can be done via the API as a registered Travel Agent or using our API in conjunction with our PCI compliant payment widget for all other entities.   - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.   ## SDKs  We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).   - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)   ## Usage  These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.   ## Versioning  We chose to version our endpoints in a way that we hope affects your integration minimally. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.   ## Release history  - Follow updates on Github: https://github.com/wink-travel/wink-sdk-java/blob/master/CHANGELOG.md    # Inventory API The Inventory API exposes endpoints to retrieve inventory you already know about. This API lets you:  1. Consume shareable links. 2. Load up a known property with availability. 3. Load up all inventories that were created by our affiliates such as grids, maps, and individual items.  Browse the endpoints in the left navigation bar to get started.  
 *
 * The version of the OpenAPI document: 30.3.1
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.inventory.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.UUID;
import travel.wink.sdk.inventory.model.UserSessionNonAuthenticatedEntity;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * HotelInventoryRequestNonAuthenticatedEntity
 */
@JsonPropertyOrder({
  HotelInventoryRequestNonAuthenticatedEntity.JSON_PROPERTY_HOTEL_IDENTIFIER,
  HotelInventoryRequestNonAuthenticatedEntity.JSON_PROPERTY_URL_NAME,
  HotelInventoryRequestNonAuthenticatedEntity.JSON_PROPERTY_SHOW_HOTEL,
  HotelInventoryRequestNonAuthenticatedEntity.JSON_PROPERTY_SHOW_ROOM_TYPES,
  HotelInventoryRequestNonAuthenticatedEntity.JSON_PROPERTY_SHOW_METADATA,
  HotelInventoryRequestNonAuthenticatedEntity.JSON_PROPERTY_SHOW_VIDEOS,
  HotelInventoryRequestNonAuthenticatedEntity.JSON_PROPERTY_SHOW_IMAGES,
  HotelInventoryRequestNonAuthenticatedEntity.JSON_PROPERTY_SHOW_ADD_ON_OFFERS,
  HotelInventoryRequestNonAuthenticatedEntity.JSON_PROPERTY_SHOW_RESTAURANTS,
  HotelInventoryRequestNonAuthenticatedEntity.JSON_PROPERTY_SHOW_MEETING_ROOMS,
  HotelInventoryRequestNonAuthenticatedEntity.JSON_PROPERTY_SHOW_SPAS,
  HotelInventoryRequestNonAuthenticatedEntity.JSON_PROPERTY_SHOW_ATTRACTIONS,
  HotelInventoryRequestNonAuthenticatedEntity.JSON_PROPERTY_SHOW_ACTIVITIES,
  HotelInventoryRequestNonAuthenticatedEntity.JSON_PROPERTY_SHOW_PLACES,
  HotelInventoryRequestNonAuthenticatedEntity.JSON_PROPERTY_SHOW_RECOGNITION,
  HotelInventoryRequestNonAuthenticatedEntity.JSON_PROPERTY_SHOW_AGGREGATE_GREEN_INDEX_SCORES,
  HotelInventoryRequestNonAuthenticatedEntity.JSON_PROPERTY_SHOW_ANNOUNCEMENTS,
  HotelInventoryRequestNonAuthenticatedEntity.JSON_PROPERTY_SHOW_REVIEWS,
  HotelInventoryRequestNonAuthenticatedEntity.JSON_PROPERTY_USER_SESSION
})
@JsonTypeName("HotelInventoryRequest_Non_Authenticated_Entity")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-08-12T10:04:27.328233927+07:00[Asia/Bangkok]")
public class HotelInventoryRequestNonAuthenticatedEntity {
  public static final String JSON_PROPERTY_HOTEL_IDENTIFIER = "hotelIdentifier";
  private UUID hotelIdentifier;

  public static final String JSON_PROPERTY_URL_NAME = "urlName";
  private String urlName;

  public static final String JSON_PROPERTY_SHOW_HOTEL = "showHotel";
  private Boolean showHotel = true;

  public static final String JSON_PROPERTY_SHOW_ROOM_TYPES = "showRoomTypes";
  private Boolean showRoomTypes = true;

  public static final String JSON_PROPERTY_SHOW_METADATA = "showMetadata";
  private Boolean showMetadata = true;

  public static final String JSON_PROPERTY_SHOW_VIDEOS = "showVideos";
  private Boolean showVideos = false;

  public static final String JSON_PROPERTY_SHOW_IMAGES = "showImages";
  private Boolean showImages = false;

  public static final String JSON_PROPERTY_SHOW_ADD_ON_OFFERS = "showAddOnOffers";
  private Boolean showAddOnOffers = false;

  public static final String JSON_PROPERTY_SHOW_RESTAURANTS = "showRestaurants";
  private Boolean showRestaurants = false;

  public static final String JSON_PROPERTY_SHOW_MEETING_ROOMS = "showMeetingRooms";
  private Boolean showMeetingRooms = false;

  public static final String JSON_PROPERTY_SHOW_SPAS = "showSpas";
  private Boolean showSpas = false;

  public static final String JSON_PROPERTY_SHOW_ATTRACTIONS = "showAttractions";
  private Boolean showAttractions = false;

  public static final String JSON_PROPERTY_SHOW_ACTIVITIES = "showActivities";
  private Boolean showActivities = false;

  public static final String JSON_PROPERTY_SHOW_PLACES = "showPlaces";
  private Boolean showPlaces = false;

  public static final String JSON_PROPERTY_SHOW_RECOGNITION = "showRecognition";
  private Boolean showRecognition = false;

  public static final String JSON_PROPERTY_SHOW_AGGREGATE_GREEN_INDEX_SCORES = "showAggregateGreenIndexScores";
  private Boolean showAggregateGreenIndexScores = false;

  public static final String JSON_PROPERTY_SHOW_ANNOUNCEMENTS = "showAnnouncements";
  private Boolean showAnnouncements = false;

  public static final String JSON_PROPERTY_SHOW_REVIEWS = "showReviews";
  private Boolean showReviews = false;

  public static final String JSON_PROPERTY_USER_SESSION = "userSession";
  private UserSessionNonAuthenticatedEntity userSession;

  public HotelInventoryRequestNonAuthenticatedEntity() {
  }

  public HotelInventoryRequestNonAuthenticatedEntity hotelIdentifier(UUID hotelIdentifier) {
    
    this.hotelIdentifier = hotelIdentifier;
    return this;
  }

   /**
   * Unique property identifier to retrieve inventory for. Either the hotelIdentifier or urlName property is required.
   * @return hotelIdentifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_HOTEL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public UUID getHotelIdentifier() {
    return hotelIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_HOTEL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHotelIdentifier(UUID hotelIdentifier) {
    this.hotelIdentifier = hotelIdentifier;
  }


  public HotelInventoryRequestNonAuthenticatedEntity urlName(String urlName) {
    
    this.urlName = urlName;
    return this;
  }

   /**
   * Unique url-friendly record identifier of property. Either the hotelIdentifier or urlName property is required.
   * @return urlName
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_URL_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getUrlName() {
    return urlName;
  }


  @JsonProperty(JSON_PROPERTY_URL_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUrlName(String urlName) {
    this.urlName = urlName;
  }


  public HotelInventoryRequestNonAuthenticatedEntity showHotel(Boolean showHotel) {
    
    this.showHotel = showHotel;
    return this;
  }

   /**
   * Flag to indicate whether to return basic property data. If you are loading up property for the first time, this data would be good to include. But there is no need to load that a second time if you are only going for availability data. This field populates &#x60;hotel&#x60; data in response.
   * @return showHotel
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SHOW_HOTEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getShowHotel() {
    return showHotel;
  }


  @JsonProperty(JSON_PROPERTY_SHOW_HOTEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShowHotel(Boolean showHotel) {
    this.showHotel = showHotel;
  }


  public HotelInventoryRequestNonAuthenticatedEntity showRoomTypes(Boolean showRoomTypes) {
    
    this.showRoomTypes = showRoomTypes;
    return this;
  }

   /**
   * Flag to indicate whether to return property room type data. This field populates &#x60;roomType&#x60;, &#x60;cheapesRoomTypes&#x60; and &#x60;available&#x60; data in response.
   * @return showRoomTypes
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SHOW_ROOM_TYPES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getShowRoomTypes() {
    return showRoomTypes;
  }


  @JsonProperty(JSON_PROPERTY_SHOW_ROOM_TYPES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShowRoomTypes(Boolean showRoomTypes) {
    this.showRoomTypes = showRoomTypes;
  }


  public HotelInventoryRequestNonAuthenticatedEntity showMetadata(Boolean showMetadata) {
    
    this.showMetadata = showMetadata;
    return this;
  }

   /**
   * Flag to indicate whether to return property meta data. This field populates &#x60;metadata&#x60; data in response.
   * @return showMetadata
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SHOW_METADATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getShowMetadata() {
    return showMetadata;
  }


  @JsonProperty(JSON_PROPERTY_SHOW_METADATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShowMetadata(Boolean showMetadata) {
    this.showMetadata = showMetadata;
  }


  public HotelInventoryRequestNonAuthenticatedEntity showVideos(Boolean showVideos) {
    
    this.showVideos = showVideos;
    return this;
  }

   /**
   * Flag to indicate whether to return property video data. This field populates &#x60;videos&#x60; data in response.
   * @return showVideos
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SHOW_VIDEOS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getShowVideos() {
    return showVideos;
  }


  @JsonProperty(JSON_PROPERTY_SHOW_VIDEOS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShowVideos(Boolean showVideos) {
    this.showVideos = showVideos;
  }


  public HotelInventoryRequestNonAuthenticatedEntity showImages(Boolean showImages) {
    
    this.showImages = showImages;
    return this;
  }

   /**
   * Flag to indicate whether to return property image data. This field populates &#x60;images&#x60; data in response.
   * @return showImages
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SHOW_IMAGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getShowImages() {
    return showImages;
  }


  @JsonProperty(JSON_PROPERTY_SHOW_IMAGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShowImages(Boolean showImages) {
    this.showImages = showImages;
  }


  public HotelInventoryRequestNonAuthenticatedEntity showAddOnOffers(Boolean showAddOnOffers) {
    
    this.showAddOnOffers = showAddOnOffers;
    return this;
  }

   /**
   * Flag to indicate whether to return property add-on data. This field populates &#x60;roomTypes.priceConfigurations.addOnOffers&#x60; data in response.
   * @return showAddOnOffers
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SHOW_ADD_ON_OFFERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getShowAddOnOffers() {
    return showAddOnOffers;
  }


  @JsonProperty(JSON_PROPERTY_SHOW_ADD_ON_OFFERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShowAddOnOffers(Boolean showAddOnOffers) {
    this.showAddOnOffers = showAddOnOffers;
  }


  public HotelInventoryRequestNonAuthenticatedEntity showRestaurants(Boolean showRestaurants) {
    
    this.showRestaurants = showRestaurants;
    return this;
  }

   /**
   * Flag to indicate whether to return property restaurant data. This field populates &#x60;restaurants&#x60; data in response.
   * @return showRestaurants
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SHOW_RESTAURANTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getShowRestaurants() {
    return showRestaurants;
  }


  @JsonProperty(JSON_PROPERTY_SHOW_RESTAURANTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShowRestaurants(Boolean showRestaurants) {
    this.showRestaurants = showRestaurants;
  }


  public HotelInventoryRequestNonAuthenticatedEntity showMeetingRooms(Boolean showMeetingRooms) {
    
    this.showMeetingRooms = showMeetingRooms;
    return this;
  }

   /**
   * Flag to indicate whether to return property meeting room data. This field populates &#x60;meetingRooms&#x60; data in response.
   * @return showMeetingRooms
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SHOW_MEETING_ROOMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getShowMeetingRooms() {
    return showMeetingRooms;
  }


  @JsonProperty(JSON_PROPERTY_SHOW_MEETING_ROOMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShowMeetingRooms(Boolean showMeetingRooms) {
    this.showMeetingRooms = showMeetingRooms;
  }


  public HotelInventoryRequestNonAuthenticatedEntity showSpas(Boolean showSpas) {
    
    this.showSpas = showSpas;
    return this;
  }

   /**
   * Flag to indicate whether to return property spa data. This field populates &#x60;spas&#x60; data in response.
   * @return showSpas
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SHOW_SPAS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getShowSpas() {
    return showSpas;
  }


  @JsonProperty(JSON_PROPERTY_SHOW_SPAS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShowSpas(Boolean showSpas) {
    this.showSpas = showSpas;
  }


  public HotelInventoryRequestNonAuthenticatedEntity showAttractions(Boolean showAttractions) {
    
    this.showAttractions = showAttractions;
    return this;
  }

   /**
   * Flag to indicate whether to return property attraction data. This field populates &#x60;attractions&#x60; data in response.
   * @return showAttractions
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SHOW_ATTRACTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getShowAttractions() {
    return showAttractions;
  }


  @JsonProperty(JSON_PROPERTY_SHOW_ATTRACTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShowAttractions(Boolean showAttractions) {
    this.showAttractions = showAttractions;
  }


  public HotelInventoryRequestNonAuthenticatedEntity showActivities(Boolean showActivities) {
    
    this.showActivities = showActivities;
    return this;
  }

   /**
   * Flag to indicate whether to return property activity data. This field populates &#x60;activities&#x60; data in response.
   * @return showActivities
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SHOW_ACTIVITIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getShowActivities() {
    return showActivities;
  }


  @JsonProperty(JSON_PROPERTY_SHOW_ACTIVITIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShowActivities(Boolean showActivities) {
    this.showActivities = showActivities;
  }


  public HotelInventoryRequestNonAuthenticatedEntity showPlaces(Boolean showPlaces) {
    
    this.showPlaces = showPlaces;
    return this;
  }

   /**
   * Flag to indicate whether to return property place data. This field populates &#x60;places&#x60; data in response.
   * @return showPlaces
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SHOW_PLACES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getShowPlaces() {
    return showPlaces;
  }


  @JsonProperty(JSON_PROPERTY_SHOW_PLACES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShowPlaces(Boolean showPlaces) {
    this.showPlaces = showPlaces;
  }


  public HotelInventoryRequestNonAuthenticatedEntity showRecognition(Boolean showRecognition) {
    
    this.showRecognition = showRecognition;
    return this;
  }

   /**
   * Flag to indicate whether to return property recognition data. This field populates &#x60;recognitions&#x60; data in response.
   * @return showRecognition
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SHOW_RECOGNITION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getShowRecognition() {
    return showRecognition;
  }


  @JsonProperty(JSON_PROPERTY_SHOW_RECOGNITION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShowRecognition(Boolean showRecognition) {
    this.showRecognition = showRecognition;
  }


  public HotelInventoryRequestNonAuthenticatedEntity showAggregateGreenIndexScores(Boolean showAggregateGreenIndexScores) {
    
    this.showAggregateGreenIndexScores = showAggregateGreenIndexScores;
    return this;
  }

   /**
   * Flag to indicate whether to return property green index score data. This field populates &#x60;greenIndexScores&#x60; data in response. Note: You only need to return hotel data to get the overall aggregate Green Index score and not detailed category scores.
   * @return showAggregateGreenIndexScores
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SHOW_AGGREGATE_GREEN_INDEX_SCORES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getShowAggregateGreenIndexScores() {
    return showAggregateGreenIndexScores;
  }


  @JsonProperty(JSON_PROPERTY_SHOW_AGGREGATE_GREEN_INDEX_SCORES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShowAggregateGreenIndexScores(Boolean showAggregateGreenIndexScores) {
    this.showAggregateGreenIndexScores = showAggregateGreenIndexScores;
  }


  public HotelInventoryRequestNonAuthenticatedEntity showAnnouncements(Boolean showAnnouncements) {
    
    this.showAnnouncements = showAnnouncements;
    return this;
  }

   /**
   * Flag to indicate whether to return property announcement data. Announcements are messages the property wishes to convey to travelers for certain dates. This field populates &#x60;announcements&#x60; data in response.
   * @return showAnnouncements
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SHOW_ANNOUNCEMENTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getShowAnnouncements() {
    return showAnnouncements;
  }


  @JsonProperty(JSON_PROPERTY_SHOW_ANNOUNCEMENTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShowAnnouncements(Boolean showAnnouncements) {
    this.showAnnouncements = showAnnouncements;
  }


  public HotelInventoryRequestNonAuthenticatedEntity showReviews(Boolean showReviews) {
    
    this.showReviews = showReviews;
    return this;
  }

   /**
   * Flag to indicate whether to return property review data. Note: You only need to return hotel data to get the overall aggregate review score and not the entire list of reviews. This field populates &#x60;reviews&#x60; data in response.
   * @return showReviews
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SHOW_REVIEWS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getShowReviews() {
    return showReviews;
  }


  @JsonProperty(JSON_PROPERTY_SHOW_REVIEWS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShowReviews(Boolean showReviews) {
    this.showReviews = showReviews;
  }


  public HotelInventoryRequestNonAuthenticatedEntity userSession(UserSessionNonAuthenticatedEntity userSession) {
    
    this.userSession = userSession;
    return this;
  }

   /**
   * Get userSession
   * @return userSession
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_USER_SESSION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UserSessionNonAuthenticatedEntity getUserSession() {
    return userSession;
  }


  @JsonProperty(JSON_PROPERTY_USER_SESSION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setUserSession(UserSessionNonAuthenticatedEntity userSession) {
    this.userSession = userSession;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    HotelInventoryRequestNonAuthenticatedEntity hotelInventoryRequestNonAuthenticatedEntity = (HotelInventoryRequestNonAuthenticatedEntity) o;
    return Objects.equals(this.hotelIdentifier, hotelInventoryRequestNonAuthenticatedEntity.hotelIdentifier) &&
        Objects.equals(this.urlName, hotelInventoryRequestNonAuthenticatedEntity.urlName) &&
        Objects.equals(this.showHotel, hotelInventoryRequestNonAuthenticatedEntity.showHotel) &&
        Objects.equals(this.showRoomTypes, hotelInventoryRequestNonAuthenticatedEntity.showRoomTypes) &&
        Objects.equals(this.showMetadata, hotelInventoryRequestNonAuthenticatedEntity.showMetadata) &&
        Objects.equals(this.showVideos, hotelInventoryRequestNonAuthenticatedEntity.showVideos) &&
        Objects.equals(this.showImages, hotelInventoryRequestNonAuthenticatedEntity.showImages) &&
        Objects.equals(this.showAddOnOffers, hotelInventoryRequestNonAuthenticatedEntity.showAddOnOffers) &&
        Objects.equals(this.showRestaurants, hotelInventoryRequestNonAuthenticatedEntity.showRestaurants) &&
        Objects.equals(this.showMeetingRooms, hotelInventoryRequestNonAuthenticatedEntity.showMeetingRooms) &&
        Objects.equals(this.showSpas, hotelInventoryRequestNonAuthenticatedEntity.showSpas) &&
        Objects.equals(this.showAttractions, hotelInventoryRequestNonAuthenticatedEntity.showAttractions) &&
        Objects.equals(this.showActivities, hotelInventoryRequestNonAuthenticatedEntity.showActivities) &&
        Objects.equals(this.showPlaces, hotelInventoryRequestNonAuthenticatedEntity.showPlaces) &&
        Objects.equals(this.showRecognition, hotelInventoryRequestNonAuthenticatedEntity.showRecognition) &&
        Objects.equals(this.showAggregateGreenIndexScores, hotelInventoryRequestNonAuthenticatedEntity.showAggregateGreenIndexScores) &&
        Objects.equals(this.showAnnouncements, hotelInventoryRequestNonAuthenticatedEntity.showAnnouncements) &&
        Objects.equals(this.showReviews, hotelInventoryRequestNonAuthenticatedEntity.showReviews) &&
        Objects.equals(this.userSession, hotelInventoryRequestNonAuthenticatedEntity.userSession);
  }

  @Override
  public int hashCode() {
    return Objects.hash(hotelIdentifier, urlName, showHotel, showRoomTypes, showMetadata, showVideos, showImages, showAddOnOffers, showRestaurants, showMeetingRooms, showSpas, showAttractions, showActivities, showPlaces, showRecognition, showAggregateGreenIndexScores, showAnnouncements, showReviews, userSession);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class HotelInventoryRequestNonAuthenticatedEntity {\n");
    sb.append("    hotelIdentifier: ").append(toIndentedString(hotelIdentifier)).append("\n");
    sb.append("    urlName: ").append(toIndentedString(urlName)).append("\n");
    sb.append("    showHotel: ").append(toIndentedString(showHotel)).append("\n");
    sb.append("    showRoomTypes: ").append(toIndentedString(showRoomTypes)).append("\n");
    sb.append("    showMetadata: ").append(toIndentedString(showMetadata)).append("\n");
    sb.append("    showVideos: ").append(toIndentedString(showVideos)).append("\n");
    sb.append("    showImages: ").append(toIndentedString(showImages)).append("\n");
    sb.append("    showAddOnOffers: ").append(toIndentedString(showAddOnOffers)).append("\n");
    sb.append("    showRestaurants: ").append(toIndentedString(showRestaurants)).append("\n");
    sb.append("    showMeetingRooms: ").append(toIndentedString(showMeetingRooms)).append("\n");
    sb.append("    showSpas: ").append(toIndentedString(showSpas)).append("\n");
    sb.append("    showAttractions: ").append(toIndentedString(showAttractions)).append("\n");
    sb.append("    showActivities: ").append(toIndentedString(showActivities)).append("\n");
    sb.append("    showPlaces: ").append(toIndentedString(showPlaces)).append("\n");
    sb.append("    showRecognition: ").append(toIndentedString(showRecognition)).append("\n");
    sb.append("    showAggregateGreenIndexScores: ").append(toIndentedString(showAggregateGreenIndexScores)).append("\n");
    sb.append("    showAnnouncements: ").append(toIndentedString(showAnnouncements)).append("\n");
    sb.append("    showReviews: ").append(toIndentedString(showReviews)).append("\n");
    sb.append("    userSession: ").append(toIndentedString(userSession)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

