/*
 * Wink API
 *  # Introduction  Welcome to the Wink API - A programmer-friendly way to manage, sell and book travel inventory on the Wink platform. The API gives you all the tools you need to ready your properties and inventory for sale across 1000s of our native sales channels.  Integrators, affiliates, travel agents and content creators have the ability search for your travel inventory and promote / sell it in a wide variety of ways.   # Integrations  We have already integrated with the most well-known channel managers so you don't have to. To see our current integrations, please go to https://extranet.wink.travel and scroll to Connectivity section. Once your properties are set up, you can finish the setup by mapping your property to Wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API.   # Intended Audience  Programmers are [most likely] a requirement to start integrating with Wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible.  - Hotel chains  - Hotel brands  - Travel tech companies  - Destination sites  - Integrators  - Aggregators  - Destination management companies  - Travel agencies  - OTAs   ## APIs  Not every integrator needs every API. For that reason, we have separated APIs into context.  ### Test API   - [Ping](/ping): The Ping API is a quick test endpoint to verify that your credentials work Wink.  ### Common APIs  - [Notifications](/notifications): The Notifications API is a way for us to stay in touch with your user, property or affiliate account. - [User Settings](/user-settings): The User Settings API exposes endpoints to allow 3rd party integrators to communicate with Wink.  ### Consume APIs Consume endpoints are for developers who want to find existing travel inventory and either book it or use it to advertise through one of their Wink affiliate accounts.   - [Configuration](/engine-client): A single endpoint to retrieve whitelabel + customization information for the booking engine.  - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags.  - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API..  - [Booking](/booking): All APIs related to creating bookings on the platform.  - [Travel Agent](/travel-agent): The Travel Agent API exposes endpoints to manage agent-facilitated bookings.   ### Produce APIs  Produce endpoints are for developers who want to create and manage travel inventory.   #### Property  - [Property registration](/extranet/property/register): As a producer, this is, oftentimes, where you start your journey. These endpoints let you create properties on Wink.  - [Property](/extranet/property): This collection of property endpoints are mostly management endpoints that let you display, change status and similar for your existing properties.  - [Facilities](/extranet/facilities): This collection of endpoints let you manage facilities; such as room types.  - [Experiences](/extranet/experiences): This collection of endpoints let you manage experiences, such as activities.  - [Monetize](/extranet/monetize): The Monetize API exposes endpoints for managing cancellation polies, rate plans, promotions and more on Wink.  - [Distribution](/extranet/distribution): The Distribution API exposes endpoints for sales channels, connecting with affiliates, managing rates and inventory calendars and more on Wink.  - [Property Booking](/extranet/booking): The Property Booking API exposes endpoints for managing bookings and reviews at the property-level.   #### Affiliate  - [Affiliate](/affiliate): This collection of affiliate endpoints are mostly management endpoints that let you display, change status and similar for your existing accounts.  - [Browse](/affiliate/browse): The Browse API exposes endpoints for affiliates to find suppliers and inventory to sell.  - [Inventory](/affiliate/inventory): The Inventory API exposes endpoints for affiliates to manage the inventory they want to sell and how they want to sell it.  - [Sales Channel](/affiliate/sales-channel): The Sales Channel API exposes endpoints for affiliates to manage existing sales channels as well as find new ones.  - [WinkLinks](/affiliate/winklinks): The WinkLinks API exposes endpoints for affiliates to manage their WinkLinks page.   #### Rate provider  - [Channel manager](/channel-manager): The Channel Manager API enables external channel manager partners to map, exchange rate / availability information with us as well as be informed of bookings that occur on the Wink platform for one of their properties.   ### Taxonomy APIs  Taxonomy endpoints are for developers who want to consume and produce travel inventory and need taxonomies of standard and non-standard codes for inventory types, classes, statuses etc.   - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies.   ### Insight APIs  Insight endpoints do exactly what the name implies - They offer platform-level insight into the activities of producers and consumers.   - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics.   ### Payment APIs  Payment endpoints are for developers who want to purchase travel inventory. This can be done via the API as a registered Travel Agent or using our API in conjunction with our PCI compliant payment widget for all other entities.   - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.   ## SDKs  We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).   - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)   ## Usage  These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.   ## Versioning  We chose to version our endpoints in a way that we hope affects your integration minimally. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.   ## Release history  - Follow updates on Github: https://github.com/wink-travel/wink-sdk-java/blob/master/CHANGELOG.md    # Inventory API The Inventory API exposes endpoints to retrieve inventory you already know about. This API lets you:  1. Consume shareable links. 2. Load up a known property with availability. 3. Load up all inventories that were created by our affiliates such as grids, maps, and individual items.  Browse the endpoints in the left navigation bar to get started.  
 *
 * The version of the OpenAPI document: 30.4.1
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.inventory.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.UUID;
import travel.wink.sdk.inventory.model.ActivityLocalizedInventoryWithHotelBestPriceNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.AddOnLocalizedInventoryWithHotelBestPriceNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.AttractionLocalizedInventoryWithHotelBestPriceNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.HotelWithBestPriceNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.MeetingRoomLocalizedInventoryWithHotelBestPriceNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.PlaceLocalizedInventoryWithHotelBestPriceNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.RestaurantLocalizedInventoryWithHotelBestPriceNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.SpaLocalizedInventoryWithHotelBestPriceNonAuthenticatedEntity;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * InventoryGridItemNonAuthenticatedEntity
 */
@JsonPropertyOrder({
  InventoryGridItemNonAuthenticatedEntity.JSON_PROPERTY_SORT,
  InventoryGridItemNonAuthenticatedEntity.JSON_PROPERTY_TYPE,
  InventoryGridItemNonAuthenticatedEntity.JSON_PROPERTY_IDENTIFIER,
  InventoryGridItemNonAuthenticatedEntity.JSON_PROPERTY_SUPPLIER_IDENTIFIER,
  InventoryGridItemNonAuthenticatedEntity.JSON_PROPERTY_ACTIVITY,
  InventoryGridItemNonAuthenticatedEntity.JSON_PROPERTY_ATTRACTION,
  InventoryGridItemNonAuthenticatedEntity.JSON_PROPERTY_PLACE,
  InventoryGridItemNonAuthenticatedEntity.JSON_PROPERTY_ROOM_TYPE,
  InventoryGridItemNonAuthenticatedEntity.JSON_PROPERTY_MEETING_ROOM,
  InventoryGridItemNonAuthenticatedEntity.JSON_PROPERTY_RESTAURANT,
  InventoryGridItemNonAuthenticatedEntity.JSON_PROPERTY_SPA,
  InventoryGridItemNonAuthenticatedEntity.JSON_PROPERTY_ADD_ON,
  InventoryGridItemNonAuthenticatedEntity.JSON_PROPERTY_AVAILABLE
})
@JsonTypeName("InventoryGridItem_Non_Authenticated_Entity")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-08-12T22:12:16.596367916+07:00[Asia/Bangkok]")
public class InventoryGridItemNonAuthenticatedEntity {
  public static final String JSON_PROPERTY_SORT = "sort";
  private Integer sort;

  /**
   * The type of inventory this item represents.
   */
  public enum TypeEnum {
    HOTEL("HOTEL"),
    
    GUEST_ROOM("GUEST_ROOM"),
    
    MEETING_ROOM("MEETING_ROOM"),
    
    RESTAURANT("RESTAURANT"),
    
    SPA("SPA"),
    
    ADD_ON("ADD_ON"),
    
    ATTRACTION("ATTRACTION"),
    
    ACTIVITY("ACTIVITY"),
    
    PLACE("PLACE");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
  private UUID identifier;

  public static final String JSON_PROPERTY_SUPPLIER_IDENTIFIER = "supplierIdentifier";
  private UUID supplierIdentifier;

  public static final String JSON_PROPERTY_ACTIVITY = "activity";
  private ActivityLocalizedInventoryWithHotelBestPriceNonAuthenticatedEntity activity;

  public static final String JSON_PROPERTY_ATTRACTION = "attraction";
  private AttractionLocalizedInventoryWithHotelBestPriceNonAuthenticatedEntity attraction;

  public static final String JSON_PROPERTY_PLACE = "place";
  private PlaceLocalizedInventoryWithHotelBestPriceNonAuthenticatedEntity place;

  public static final String JSON_PROPERTY_ROOM_TYPE = "roomType";
  private HotelWithBestPriceNonAuthenticatedEntity roomType;

  public static final String JSON_PROPERTY_MEETING_ROOM = "meetingRoom";
  private MeetingRoomLocalizedInventoryWithHotelBestPriceNonAuthenticatedEntity meetingRoom;

  public static final String JSON_PROPERTY_RESTAURANT = "restaurant";
  private RestaurantLocalizedInventoryWithHotelBestPriceNonAuthenticatedEntity restaurant;

  public static final String JSON_PROPERTY_SPA = "spa";
  private SpaLocalizedInventoryWithHotelBestPriceNonAuthenticatedEntity spa;

  public static final String JSON_PROPERTY_ADD_ON = "addOn";
  private AddOnLocalizedInventoryWithHotelBestPriceNonAuthenticatedEntity addOn;

  public static final String JSON_PROPERTY_AVAILABLE = "available";
  private Boolean available;

  public InventoryGridItemNonAuthenticatedEntity() {
  }

  public InventoryGridItemNonAuthenticatedEntity sort(Integer sort) {
    
    this.sort = sort;
    return this;
  }

   /**
   * Sort property indicates how this grid item fits in with the rest of the items in the list.
   * @return sort
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_SORT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getSort() {
    return sort;
  }


  @JsonProperty(JSON_PROPERTY_SORT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSort(Integer sort) {
    this.sort = sort;
  }


  public InventoryGridItemNonAuthenticatedEntity type(TypeEnum type) {
    
    this.type = type;
    return this;
  }

   /**
   * The type of inventory this item represents.
   * @return type
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public TypeEnum getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setType(TypeEnum type) {
    this.type = type;
  }


  public InventoryGridItemNonAuthenticatedEntity identifier(UUID identifier) {
    
    this.identifier = identifier;
    return this;
  }

   /**
   * Unique inventory identifier
   * @return identifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getIdentifier() {
    return identifier;
  }


  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setIdentifier(UUID identifier) {
    this.identifier = identifier;
  }


  public InventoryGridItemNonAuthenticatedEntity supplierIdentifier(UUID supplierIdentifier) {
    
    this.supplierIdentifier = supplierIdentifier;
    return this;
  }

   /**
   * Supplier identifier referencing inventory owner
   * @return supplierIdentifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_SUPPLIER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getSupplierIdentifier() {
    return supplierIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_SUPPLIER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSupplierIdentifier(UUID supplierIdentifier) {
    this.supplierIdentifier = supplierIdentifier;
  }


  public InventoryGridItemNonAuthenticatedEntity activity(ActivityLocalizedInventoryWithHotelBestPriceNonAuthenticatedEntity activity) {
    
    this.activity = activity;
    return this;
  }

   /**
   * Get activity
   * @return activity
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_ACTIVITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ActivityLocalizedInventoryWithHotelBestPriceNonAuthenticatedEntity getActivity() {
    return activity;
  }


  @JsonProperty(JSON_PROPERTY_ACTIVITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setActivity(ActivityLocalizedInventoryWithHotelBestPriceNonAuthenticatedEntity activity) {
    this.activity = activity;
  }


  public InventoryGridItemNonAuthenticatedEntity attraction(AttractionLocalizedInventoryWithHotelBestPriceNonAuthenticatedEntity attraction) {
    
    this.attraction = attraction;
    return this;
  }

   /**
   * Get attraction
   * @return attraction
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_ATTRACTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public AttractionLocalizedInventoryWithHotelBestPriceNonAuthenticatedEntity getAttraction() {
    return attraction;
  }


  @JsonProperty(JSON_PROPERTY_ATTRACTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAttraction(AttractionLocalizedInventoryWithHotelBestPriceNonAuthenticatedEntity attraction) {
    this.attraction = attraction;
  }


  public InventoryGridItemNonAuthenticatedEntity place(PlaceLocalizedInventoryWithHotelBestPriceNonAuthenticatedEntity place) {
    
    this.place = place;
    return this;
  }

   /**
   * Get place
   * @return place
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_PLACE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public PlaceLocalizedInventoryWithHotelBestPriceNonAuthenticatedEntity getPlace() {
    return place;
  }


  @JsonProperty(JSON_PROPERTY_PLACE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPlace(PlaceLocalizedInventoryWithHotelBestPriceNonAuthenticatedEntity place) {
    this.place = place;
  }


  public InventoryGridItemNonAuthenticatedEntity roomType(HotelWithBestPriceNonAuthenticatedEntity roomType) {
    
    this.roomType = roomType;
    return this;
  }

   /**
   * Get roomType
   * @return roomType
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_ROOM_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public HotelWithBestPriceNonAuthenticatedEntity getRoomType() {
    return roomType;
  }


  @JsonProperty(JSON_PROPERTY_ROOM_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRoomType(HotelWithBestPriceNonAuthenticatedEntity roomType) {
    this.roomType = roomType;
  }


  public InventoryGridItemNonAuthenticatedEntity meetingRoom(MeetingRoomLocalizedInventoryWithHotelBestPriceNonAuthenticatedEntity meetingRoom) {
    
    this.meetingRoom = meetingRoom;
    return this;
  }

   /**
   * Get meetingRoom
   * @return meetingRoom
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_MEETING_ROOM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public MeetingRoomLocalizedInventoryWithHotelBestPriceNonAuthenticatedEntity getMeetingRoom() {
    return meetingRoom;
  }


  @JsonProperty(JSON_PROPERTY_MEETING_ROOM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMeetingRoom(MeetingRoomLocalizedInventoryWithHotelBestPriceNonAuthenticatedEntity meetingRoom) {
    this.meetingRoom = meetingRoom;
  }


  public InventoryGridItemNonAuthenticatedEntity restaurant(RestaurantLocalizedInventoryWithHotelBestPriceNonAuthenticatedEntity restaurant) {
    
    this.restaurant = restaurant;
    return this;
  }

   /**
   * Get restaurant
   * @return restaurant
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_RESTAURANT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public RestaurantLocalizedInventoryWithHotelBestPriceNonAuthenticatedEntity getRestaurant() {
    return restaurant;
  }


  @JsonProperty(JSON_PROPERTY_RESTAURANT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRestaurant(RestaurantLocalizedInventoryWithHotelBestPriceNonAuthenticatedEntity restaurant) {
    this.restaurant = restaurant;
  }


  public InventoryGridItemNonAuthenticatedEntity spa(SpaLocalizedInventoryWithHotelBestPriceNonAuthenticatedEntity spa) {
    
    this.spa = spa;
    return this;
  }

   /**
   * Get spa
   * @return spa
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SPA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public SpaLocalizedInventoryWithHotelBestPriceNonAuthenticatedEntity getSpa() {
    return spa;
  }


  @JsonProperty(JSON_PROPERTY_SPA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSpa(SpaLocalizedInventoryWithHotelBestPriceNonAuthenticatedEntity spa) {
    this.spa = spa;
  }


  public InventoryGridItemNonAuthenticatedEntity addOn(AddOnLocalizedInventoryWithHotelBestPriceNonAuthenticatedEntity addOn) {
    
    this.addOn = addOn;
    return this;
  }

   /**
   * Get addOn
   * @return addOn
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_ADD_ON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public AddOnLocalizedInventoryWithHotelBestPriceNonAuthenticatedEntity getAddOn() {
    return addOn;
  }


  @JsonProperty(JSON_PROPERTY_ADD_ON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAddOn(AddOnLocalizedInventoryWithHotelBestPriceNonAuthenticatedEntity addOn) {
    this.addOn = addOn;
  }


  public InventoryGridItemNonAuthenticatedEntity available(Boolean available) {
    
    this.available = available;
    return this;
  }

   /**
   * Whether this inventory is available
   * @return available
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_AVAILABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getAvailable() {
    return available;
  }


  @JsonProperty(JSON_PROPERTY_AVAILABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAvailable(Boolean available) {
    this.available = available;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    InventoryGridItemNonAuthenticatedEntity inventoryGridItemNonAuthenticatedEntity = (InventoryGridItemNonAuthenticatedEntity) o;
    return Objects.equals(this.sort, inventoryGridItemNonAuthenticatedEntity.sort) &&
        Objects.equals(this.type, inventoryGridItemNonAuthenticatedEntity.type) &&
        Objects.equals(this.identifier, inventoryGridItemNonAuthenticatedEntity.identifier) &&
        Objects.equals(this.supplierIdentifier, inventoryGridItemNonAuthenticatedEntity.supplierIdentifier) &&
        Objects.equals(this.activity, inventoryGridItemNonAuthenticatedEntity.activity) &&
        Objects.equals(this.attraction, inventoryGridItemNonAuthenticatedEntity.attraction) &&
        Objects.equals(this.place, inventoryGridItemNonAuthenticatedEntity.place) &&
        Objects.equals(this.roomType, inventoryGridItemNonAuthenticatedEntity.roomType) &&
        Objects.equals(this.meetingRoom, inventoryGridItemNonAuthenticatedEntity.meetingRoom) &&
        Objects.equals(this.restaurant, inventoryGridItemNonAuthenticatedEntity.restaurant) &&
        Objects.equals(this.spa, inventoryGridItemNonAuthenticatedEntity.spa) &&
        Objects.equals(this.addOn, inventoryGridItemNonAuthenticatedEntity.addOn) &&
        Objects.equals(this.available, inventoryGridItemNonAuthenticatedEntity.available);
  }

  @Override
  public int hashCode() {
    return Objects.hash(sort, type, identifier, supplierIdentifier, activity, attraction, place, roomType, meetingRoom, restaurant, spa, addOn, available);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class InventoryGridItemNonAuthenticatedEntity {\n");
    sb.append("    sort: ").append(toIndentedString(sort)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    identifier: ").append(toIndentedString(identifier)).append("\n");
    sb.append("    supplierIdentifier: ").append(toIndentedString(supplierIdentifier)).append("\n");
    sb.append("    activity: ").append(toIndentedString(activity)).append("\n");
    sb.append("    attraction: ").append(toIndentedString(attraction)).append("\n");
    sb.append("    place: ").append(toIndentedString(place)).append("\n");
    sb.append("    roomType: ").append(toIndentedString(roomType)).append("\n");
    sb.append("    meetingRoom: ").append(toIndentedString(meetingRoom)).append("\n");
    sb.append("    restaurant: ").append(toIndentedString(restaurant)).append("\n");
    sb.append("    spa: ").append(toIndentedString(spa)).append("\n");
    sb.append("    addOn: ").append(toIndentedString(addOn)).append("\n");
    sb.append("    available: ").append(toIndentedString(available)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

