/*
 * Wink API
 *  # Introduction  Welcome to the Wink API - A programmer-friendly way to manage, sell and book travel inventory on the Wink platform. The API gives you all the tools you need to ready your properties and inventory for sale across 1000s of our native sales channels.  Integrators, affiliates, travel agents and content creators have the ability search for your travel inventory and promote / sell it in a wide variety of ways.   # Integrations  We have already integrated with the most well-known channel managers so you don't have to. To see our current integrations, please go to https://extranet.wink.travel and scroll to Connectivity section. Once your properties are set up, you can finish the setup by mapping your property to Wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API.   # Intended Audience  Programmers are [most likely] a requirement to start integrating with Wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible.  - Hotel chains  - Hotel brands  - Travel tech companies  - Destination sites  - Integrators  - Aggregators  - Destination management companies  - Travel agencies  - OTAs   ## APIs  Not every integrator needs every API. For that reason, we have separated APIs into context.  ### Test API   - [Ping](/ping): The Ping API is a quick test endpoint to verify that your credentials work Wink.  ### Common APIs  - [Notifications](/notifications): The Notifications API is a way for us to stay in touch with your user, property or affiliate account. - [User Settings](/user-settings): The User Settings API exposes endpoints to allow 3rd party integrators to communicate with Wink.  ### Consume APIs Consume endpoints are for developers who want to find existing travel inventory and either book it or use it to advertise through one of their Wink affiliate accounts.   - [Configuration](/engine-client): A single endpoint to retrieve whitelabel + customization information for the booking engine.  - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags.  - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API..  - [Booking](/booking): All APIs related to creating bookings on the platform.  - [Travel Agent](/travel-agent): The Travel Agent API exposes endpoints to manage agent-facilitated bookings.   ### Produce APIs  Produce endpoints are for developers who want to create and manage travel inventory.   #### Property  - [Property registration](/extranet/property/register): As a producer, this is, oftentimes, where you start your journey. These endpoints let you create properties on Wink.  - [Property](/extranet/property): This collection of property endpoints are mostly management endpoints that let you display, change status and similar for your existing properties.  - [Facilities](/extranet/facilities): This collection of endpoints let you manage facilities; such as room types.  - [Experiences](/extranet/experiences): This collection of endpoints let you manage experiences, such as activities.  - [Monetize](/extranet/monetize): The Monetize API exposes endpoints for managing cancellation polies, rate plans, promotions and more on Wink.  - [Distribution](/extranet/distribution): The Distribution API exposes endpoints for sales channels, connecting with affiliates, managing rates and inventory calendars and more on Wink.  - [Property Booking](/extranet/booking): The Property Booking API exposes endpoints for managing bookings and reviews at the property-level.   #### Affiliate  - [Affiliate](/affiliate): This collection of affiliate endpoints are mostly management endpoints that let you display, change status and similar for your existing accounts.  - [Browse](/affiliate/browse): The Browse API exposes endpoints for affiliates to find suppliers and inventory to sell.  - [Inventory](/affiliate/inventory): The Inventory API exposes endpoints for affiliates to manage the inventory they want to sell and how they want to sell it.  - [Sales Channel](/affiliate/sales-channel): The Sales Channel API exposes endpoints for affiliates to manage existing sales channels as well as find new ones.  - [WinkLinks](/affiliate/winklinks): The WinkLinks API exposes endpoints for affiliates to manage their WinkLinks page.   #### Rate provider  - [Channel manager](/channel-manager): The Channel Manager API enables external channel manager partners to map, exchange rate / availability information with us as well as be informed of bookings that occur on the Wink platform for one of their properties.   ### Taxonomy APIs  Taxonomy endpoints are for developers who want to consume and produce travel inventory and need taxonomies of standard and non-standard codes for inventory types, classes, statuses etc.   - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies.   ### Insight APIs  Insight endpoints do exactly what the name implies - They offer platform-level insight into the activities of producers and consumers.   - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics.   ### Payment APIs  Payment endpoints are for developers who want to purchase travel inventory. This can be done via the API as a registered Travel Agent or using our API in conjunction with our PCI compliant payment widget for all other entities.   - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.   ## SDKs  We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).   - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)   ## Usage  These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.   ## Versioning  We chose to version our endpoints in a way that we hope affects your integration minimally. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.   ## Release history  - Follow updates on Github: https://github.com/wink-travel/wink-sdk-java/blob/master/CHANGELOG.md    # Inventory API The Inventory API exposes endpoints to retrieve inventory you already know about. This API lets you:  1. Consume shareable links. 2. Load up a known property with availability. 3. Load up all inventories that were created by our affiliates such as grids, maps, and individual items.  Browse the endpoints in the left navigation bar to get started.  
 *
 * The version of the OpenAPI document: 30.5.13
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.inventory.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.OffsetDateTime;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import travel.wink.sdk.inventory.model.UserReviewAnswerNonAuthenticatedEntity;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * List of property reviews
 */
@JsonPropertyOrder({
  UserReviewNonAuthenticatedEntity.JSON_PROPERTY_REVIEW_BY,
  UserReviewNonAuthenticatedEntity.JSON_PROPERTY_REVIEWED_ON,
  UserReviewNonAuthenticatedEntity.JSON_PROPERTY_AVERAGE_SCORE,
  UserReviewNonAuthenticatedEntity.JSON_PROPERTY_ANSWERS,
  UserReviewNonAuthenticatedEntity.JSON_PROPERTY_RESPONSE_FROM_HOTEL,
  UserReviewNonAuthenticatedEntity.JSON_PROPERTY_IMAGE_IDENTIFIER,
  UserReviewNonAuthenticatedEntity.JSON_PROPERTY_REVIEW,
  UserReviewNonAuthenticatedEntity.JSON_PROPERTY_LIKES
})
@JsonTypeName("UserReview_Non_Authenticated_Entity")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-04T20:24:11.596242871+07:00[Asia/Bangkok]")
public class UserReviewNonAuthenticatedEntity {
  public static final String JSON_PROPERTY_REVIEW_BY = "reviewBy";
  private String reviewBy;

  public static final String JSON_PROPERTY_REVIEWED_ON = "reviewedOn";
  private java.time.LocalDateTime reviewedOn;

  public static final String JSON_PROPERTY_AVERAGE_SCORE = "averageScore";
  private java.math.BigDecimal averageScore;

  public static final String JSON_PROPERTY_ANSWERS = "answers";
  private List<UserReviewAnswerNonAuthenticatedEntity> answers;

  public static final String JSON_PROPERTY_RESPONSE_FROM_HOTEL = "responseFromHotel";
  private String responseFromHotel;

  public static final String JSON_PROPERTY_IMAGE_IDENTIFIER = "imageIdentifier";
  private String imageIdentifier;

  public static final String JSON_PROPERTY_REVIEW = "review";
  private String review;

  public static final String JSON_PROPERTY_LIKES = "likes";
  private List<Integer> likes;

  public UserReviewNonAuthenticatedEntity() {
  }

  public UserReviewNonAuthenticatedEntity reviewBy(String reviewBy) {
    
    this.reviewBy = reviewBy;
    return this;
  }

   /**
   * User details of creator of booking.
   * @return reviewBy
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_REVIEW_BY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getReviewBy() {
    return reviewBy;
  }


  @JsonProperty(JSON_PROPERTY_REVIEW_BY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReviewBy(String reviewBy) {
    this.reviewBy = reviewBy;
  }


  public UserReviewNonAuthenticatedEntity reviewedOn(java.time.LocalDateTime reviewedOn) {
    
    this.reviewedOn = reviewedOn;
    return this;
  }

   /**
   * Date of review.
   * @return reviewedOn
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_REVIEWED_ON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public java.time.LocalDateTime getReviewedOn() {
    return reviewedOn;
  }


  @JsonProperty(JSON_PROPERTY_REVIEWED_ON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReviewedOn(java.time.LocalDateTime reviewedOn) {
    this.reviewedOn = reviewedOn;
  }


  public UserReviewNonAuthenticatedEntity averageScore(java.math.BigDecimal averageScore) {
    
    this.averageScore = averageScore;
    return this;
  }

   /**
   * Total points divided by number of questions.
   * @return averageScore
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_AVERAGE_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public java.math.BigDecimal getAverageScore() {
    return averageScore;
  }


  @JsonProperty(JSON_PROPERTY_AVERAGE_SCORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAverageScore(java.math.BigDecimal averageScore) {
    this.averageScore = averageScore;
  }


  public UserReviewNonAuthenticatedEntity answers(List<UserReviewAnswerNonAuthenticatedEntity> answers) {
    
    this.answers = answers;
    return this;
  }

  public UserReviewNonAuthenticatedEntity addAnswersItem(UserReviewAnswerNonAuthenticatedEntity answersItem) {
    if (this.answers == null) {
      this.answers = new ArrayList<>();
    }
    this.answers.add(answersItem);
    return this;
  }

   /**
   * List of reviewBy review answers.
   * @return answers
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_ANSWERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<UserReviewAnswerNonAuthenticatedEntity> getAnswers() {
    return answers;
  }


  @JsonProperty(JSON_PROPERTY_ANSWERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAnswers(List<UserReviewAnswerNonAuthenticatedEntity> answers) {
    this.answers = answers;
  }


  public UserReviewNonAuthenticatedEntity responseFromHotel(String responseFromHotel) {
    
    this.responseFromHotel = responseFromHotel;
    return this;
  }

   /**
   * Property can response to traveler review. Response goes on public review profile and can be seen by others.
   * @return responseFromHotel
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_RESPONSE_FROM_HOTEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getResponseFromHotel() {
    return responseFromHotel;
  }


  @JsonProperty(JSON_PROPERTY_RESPONSE_FROM_HOTEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setResponseFromHotel(String responseFromHotel) {
    this.responseFromHotel = responseFromHotel;
  }


  public UserReviewNonAuthenticatedEntity imageIdentifier(String imageIdentifier) {
    
    this.imageIdentifier = imageIdentifier;
    return this;
  }

   /**
   * Reviewer can upload her best picture from the property. Cloudinary image identifier.
   * @return imageIdentifier
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_IMAGE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getImageIdentifier() {
    return imageIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_IMAGE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setImageIdentifier(String imageIdentifier) {
    this.imageIdentifier = imageIdentifier;
  }


  public UserReviewNonAuthenticatedEntity review(String review) {
    
    this.review = review;
    return this;
  }

   /**
   * Free text record created by traveler
   * @return review
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_REVIEW)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getReview() {
    return review;
  }


  @JsonProperty(JSON_PROPERTY_REVIEW)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReview(String review) {
    this.review = review;
  }


  public UserReviewNonAuthenticatedEntity likes(List<Integer> likes) {
    
    this.likes = likes;
    return this;
  }

  public UserReviewNonAuthenticatedEntity addLikesItem(Integer likesItem) {
    if (this.likes == null) {
      this.likes = new ArrayList<>();
    }
    this.likes.add(likesItem);
    return this;
  }

   /**
   * List of member identifiers who liked the reviewual review
   * @return likes
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_LIKES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Integer> getLikes() {
    return likes;
  }


  @JsonProperty(JSON_PROPERTY_LIKES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLikes(List<Integer> likes) {
    this.likes = likes;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    UserReviewNonAuthenticatedEntity userReviewNonAuthenticatedEntity = (UserReviewNonAuthenticatedEntity) o;
    return Objects.equals(this.reviewBy, userReviewNonAuthenticatedEntity.reviewBy) &&
        Objects.equals(this.reviewedOn, userReviewNonAuthenticatedEntity.reviewedOn) &&
        Objects.equals(this.averageScore, userReviewNonAuthenticatedEntity.averageScore) &&
        Objects.equals(this.answers, userReviewNonAuthenticatedEntity.answers) &&
        Objects.equals(this.responseFromHotel, userReviewNonAuthenticatedEntity.responseFromHotel) &&
        Objects.equals(this.imageIdentifier, userReviewNonAuthenticatedEntity.imageIdentifier) &&
        Objects.equals(this.review, userReviewNonAuthenticatedEntity.review) &&
        Objects.equals(this.likes, userReviewNonAuthenticatedEntity.likes);
  }

  @Override
  public int hashCode() {
    return Objects.hash(reviewBy, reviewedOn, averageScore, answers, responseFromHotel, imageIdentifier, review, likes);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class UserReviewNonAuthenticatedEntity {\n");
    sb.append("    reviewBy: ").append(toIndentedString(reviewBy)).append("\n");
    sb.append("    reviewedOn: ").append(toIndentedString(reviewedOn)).append("\n");
    sb.append("    averageScore: ").append(toIndentedString(averageScore)).append("\n");
    sb.append("    answers: ").append(toIndentedString(answers)).append("\n");
    sb.append("    responseFromHotel: ").append(toIndentedString(responseFromHotel)).append("\n");
    sb.append("    imageIdentifier: ").append(toIndentedString(imageIdentifier)).append("\n");
    sb.append("    review: ").append(toIndentedString(review)).append("\n");
    sb.append("    likes: ").append(toIndentedString(likes)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

