/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.inventory.api;

import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Mono;
import travel.wink.sdk.inventory.invoker.ApiClient;
import travel.wink.sdk.inventory.model.ConsumableSellerUrlNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.UserSessionNonAuthenticatedEntity;

public class ShareableLinkApi {
    private ApiClient apiClient;

    public ShareableLinkApi() {
        this(new ApiClient());
    }

    @Autowired
    public ShareableLinkApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec oauth2ShowConsumableUrlRequestCreation(String code, UserSessionNonAuthenticatedEntity userSessionNonAuthenticatedEntity, String cid, String gl, String winkVersion) throws WebClientResponseException {
        UserSessionNonAuthenticatedEntity postBody = userSessionNonAuthenticatedEntity;
        if (code == null) {
            throw new WebClientResponseException("Missing the required parameter 'code' when calling oauth2ShowConsumableUrl", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (userSessionNonAuthenticatedEntity == null) {
            throw new WebClientResponseException("Missing the required parameter 'userSessionNonAuthenticatedEntity' when calling oauth2ShowConsumableUrl", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("code", code);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "cid", cid));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "_gl", gl));
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<ConsumableSellerUrlNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<ConsumableSellerUrlNonAuthenticatedEntity>(this){};
        return this.apiClient.invokeAPI("/api/shareable-link/{code}", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<ConsumableSellerUrlNonAuthenticatedEntity> oauth2ShowConsumableUrl(String code, UserSessionNonAuthenticatedEntity userSessionNonAuthenticatedEntity, String cid, String gl, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<ConsumableSellerUrlNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<ConsumableSellerUrlNonAuthenticatedEntity>(this){};
        return this.oauth2ShowConsumableUrlRequestCreation(code, userSessionNonAuthenticatedEntity, cid, gl, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<ConsumableSellerUrlNonAuthenticatedEntity>> oauth2ShowConsumableUrlWithHttpInfo(String code, UserSessionNonAuthenticatedEntity userSessionNonAuthenticatedEntity, String cid, String gl, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<ConsumableSellerUrlNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<ConsumableSellerUrlNonAuthenticatedEntity>(this){};
        return this.oauth2ShowConsumableUrlRequestCreation(code, userSessionNonAuthenticatedEntity, cid, gl, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec oauth2ShowConsumableUrlWithResponseSpec(String code, UserSessionNonAuthenticatedEntity userSessionNonAuthenticatedEntity, String cid, String gl, String winkVersion) throws WebClientResponseException {
        return this.oauth2ShowConsumableUrlRequestCreation(code, userSessionNonAuthenticatedEntity, cid, gl, winkVersion);
    }

    private WebClient.ResponseSpec showConsumableUrlRequestCreation(String companyIdentifier, String code, UserSessionNonAuthenticatedEntity userSessionNonAuthenticatedEntity, String cid, String gl, String winkVersion) throws WebClientResponseException {
        UserSessionNonAuthenticatedEntity postBody = userSessionNonAuthenticatedEntity;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showConsumableUrl", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (code == null) {
            throw new WebClientResponseException("Missing the required parameter 'code' when calling showConsumableUrl", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (userSessionNonAuthenticatedEntity == null) {
            throw new WebClientResponseException("Missing the required parameter 'userSessionNonAuthenticatedEntity' when calling showConsumableUrl", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("code", code);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "cid", cid));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "_gl", gl));
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<ConsumableSellerUrlNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<ConsumableSellerUrlNonAuthenticatedEntity>(this){};
        return this.apiClient.invokeAPI("/api/sell/{companyIdentifier}/shareable-link/{code}", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<ConsumableSellerUrlNonAuthenticatedEntity> showConsumableUrl(String companyIdentifier, String code, UserSessionNonAuthenticatedEntity userSessionNonAuthenticatedEntity, String cid, String gl, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<ConsumableSellerUrlNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<ConsumableSellerUrlNonAuthenticatedEntity>(this){};
        return this.showConsumableUrlRequestCreation(companyIdentifier, code, userSessionNonAuthenticatedEntity, cid, gl, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<ConsumableSellerUrlNonAuthenticatedEntity>> showConsumableUrlWithHttpInfo(String companyIdentifier, String code, UserSessionNonAuthenticatedEntity userSessionNonAuthenticatedEntity, String cid, String gl, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<ConsumableSellerUrlNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<ConsumableSellerUrlNonAuthenticatedEntity>(this){};
        return this.showConsumableUrlRequestCreation(companyIdentifier, code, userSessionNonAuthenticatedEntity, cid, gl, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showConsumableUrlWithResponseSpec(String companyIdentifier, String code, UserSessionNonAuthenticatedEntity userSessionNonAuthenticatedEntity, String cid, String gl, String winkVersion) throws WebClientResponseException {
        return this.showConsumableUrlRequestCreation(companyIdentifier, code, userSessionNonAuthenticatedEntity, cid, gl, winkVersion);
    }
}

