/*
 * Wink API
 *  # Introduction  Welcome to the Wink API - A programmer-friendly way to manage, sell and book travel inventory on the Wink platform. The API gives you all the tools you need to ready your properties and inventory for sale across 1000s of our native sales channels.  Integrators, affiliates, travel agents and content creators have the ability search for your travel inventory and promote / sell it in a wide variety of ways.   # Integrations  We have already integrated with the most well-known channel managers so you don't have to. To see our current integrations, please go to https://extranet.wink.travel and scroll to Connectivity section. Once your properties are set up, you can finish the setup by mapping your property to Wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API.   # Intended Audience  Programmers are [most likely] a requirement to start integrating with Wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible.  - Hotel chains  - Hotel brands  - Travel tech companies  - Destination sites  - Integrators  - Aggregators  - Destination management companies  - Travel agencies  - OTAs   ## APIs  Not every integrator needs every API. For that reason, we have separated APIs into context.  ### Test API   - [Ping](/ping): The Ping API is a quick test endpoint to verify that your credentials work Wink.  ### Common APIs  - [Notifications](/notifications): The Notifications API is a way for us to stay in touch with your user, property or affiliate account. - [User Settings](/user-settings): The User Settings API exposes endpoints to allow 3rd party integrators to communicate with Wink.  ### Consume APIs Consume endpoints are for developers who want to find existing travel inventory and either book it or use it to advertise through one of their Wink affiliate accounts.   - [Configuration](/engine-client): A single endpoint to retrieve whitelabel + customization information for the booking engine.  - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags.  - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API..  - [Booking](/booking): All APIs related to creating bookings on the platform.  - [Travel Agent](/travel-agent): The Travel Agent API exposes endpoints to manage agent-facilitated bookings.   ### Produce APIs  Produce endpoints are for developers who want to create and manage travel inventory.   #### Property  - [Property registration](/extranet/property/register): As a producer, this is, oftentimes, where you start your journey. These endpoints let you create properties on Wink.  - [Property](/extranet/property): This collection of property endpoints are mostly management endpoints that let you display, change status and similar for your existing properties.  - [Facilities](/extranet/facilities): This collection of endpoints let you manage facilities; such as room types.  - [Experiences](/extranet/experiences): This collection of endpoints let you manage experiences, such as activities.  - [Monetize](/extranet/monetize): The Monetize API exposes endpoints for managing cancellation polies, rate plans, promotions and more on Wink.  - [Distribution](/extranet/distribution): The Distribution API exposes endpoints for sales channels, connecting with affiliates, managing rates and inventory calendars and more on Wink.  - [Property Booking](/extranet/booking): The Property Booking API exposes endpoints for managing bookings and reviews at the property-level.   #### Affiliate  - [Affiliate](/affiliate): This collection of affiliate endpoints are mostly management endpoints that let you display, change status and similar for your existing accounts.  - [Browse](/affiliate/browse): The Browse API exposes endpoints for affiliates to find suppliers and inventory to sell.  - [Inventory](/affiliate/inventory): The Inventory API exposes endpoints for affiliates to manage the inventory they want to sell and how they want to sell it.  - [Sales Channel](/affiliate/sales-channel): The Sales Channel API exposes endpoints for affiliates to manage existing sales channels as well as find new ones.  - [WinkLinks](/affiliate/winklinks): The WinkLinks API exposes endpoints for affiliates to manage their WinkLinks page.   #### Rate provider  - [Channel manager](/channel-manager): The Channel Manager API enables external channel manager partners to map, exchange rate / availability information with us as well as be informed of bookings that occur on the Wink platform for one of their properties.   ### Taxonomy APIs  Taxonomy endpoints are for developers who want to consume and produce travel inventory and need taxonomies of standard and non-standard codes for inventory types, classes, statuses etc.   - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies.   ### Insight APIs  Insight endpoints do exactly what the name implies - They offer platform-level insight into the activities of producers and consumers.   - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics.   ### Payment APIs  Payment endpoints are for developers who want to purchase travel inventory. This can be done via the API as a registered Travel Agent or using our API in conjunction with our PCI compliant payment widget for all other entities.   - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.   ## SDKs  We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).   - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)   ## Usage  These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.   ## Versioning  We chose to version our endpoints in a way that we hope affects your integration minimally. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.   ## Release history  - Follow updates on Github: https://github.com/wink-travel/wink-sdk-java/blob/master/CHANGELOG.md    # Inventory API The Inventory API exposes endpoints to retrieve inventory you already know about. This API lets you:  1. Consume shareable links. 2. Load up a known property with availability. 3. Load up all inventories that were created by our affiliates such as grids, maps, and individual items.  Browse the endpoints in the left navigation bar to get started.  
 *
 * The version of the OpenAPI document: 30.5.2
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.inventory.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import travel.wink.sdk.inventory.model.ConfigurableGeoJsonCircleNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.ConfigurableGeoJsonPointNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.ConfigurableGeoJsonPolygonNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.ConfigurableGeoJsonRectangleNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.GeoJsonPointNonAuthenticatedEntity;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Advanced map configuration
 */
@JsonPropertyOrder({
  AdvancedMapConfigurationNonAuthenticatedEntity.JSON_PROPERTY_IDENTIFIER,
  AdvancedMapConfigurationNonAuthenticatedEntity.JSON_PROPERTY_OWNER_IDENTIFIER,
  AdvancedMapConfigurationNonAuthenticatedEntity.JSON_PROPERTY_ENGINE_CONFIGURATION_IDENTIFIER,
  AdvancedMapConfigurationNonAuthenticatedEntity.JSON_PROPERTY_NAME,
  AdvancedMapConfigurationNonAuthenticatedEntity.JSON_PROPERTY_TYPE_IDENTIFIER,
  AdvancedMapConfigurationNonAuthenticatedEntity.JSON_PROPERTY_TYPE,
  AdvancedMapConfigurationNonAuthenticatedEntity.JSON_PROPERTY_CENTER,
  AdvancedMapConfigurationNonAuthenticatedEntity.JSON_PROPERTY_DRAGGABLE,
  AdvancedMapConfigurationNonAuthenticatedEntity.JSON_PROPERTY_ZOOMABLE,
  AdvancedMapConfigurationNonAuthenticatedEntity.JSON_PROPERTY_INITIAL_ZOOM_LEVEL,
  AdvancedMapConfigurationNonAuthenticatedEntity.JSON_PROPERTY_MAP_STYLE,
  AdvancedMapConfigurationNonAuthenticatedEntity.JSON_PROPERTY_MAP_MARKER_COLOR,
  AdvancedMapConfigurationNonAuthenticatedEntity.JSON_PROPERTY_MAP_HEIGHT,
  AdvancedMapConfigurationNonAuthenticatedEntity.JSON_PROPERTY_DISPLAY_TYPE,
  AdvancedMapConfigurationNonAuthenticatedEntity.JSON_PROPERTY_CIRCLES,
  AdvancedMapConfigurationNonAuthenticatedEntity.JSON_PROPERTY_RECTANGLES,
  AdvancedMapConfigurationNonAuthenticatedEntity.JSON_PROPERTY_MARKERS,
  AdvancedMapConfigurationNonAuthenticatedEntity.JSON_PROPERTY_POLYGONS
})
@JsonTypeName("AdvancedMapConfiguration_Non_Authenticated_Entity")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-09-15T11:59:38.583609063+07:00[Asia/Bangkok]")
public class AdvancedMapConfigurationNonAuthenticatedEntity {
  public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
  private UUID identifier;

  public static final String JSON_PROPERTY_OWNER_IDENTIFIER = "ownerIdentifier";
  private UUID ownerIdentifier;

  public static final String JSON_PROPERTY_ENGINE_CONFIGURATION_IDENTIFIER = "engineConfigurationIdentifier";
  private UUID engineConfigurationIdentifier;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_TYPE_IDENTIFIER = "typeIdentifier";
  private UUID typeIdentifier;

  /**
   * Type of inventory
   */
  public enum TypeEnum {
    SINGLE("SINGLE"),
    
    LIST("LIST"),
    
    SEARCH("SEARCH");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public static final String JSON_PROPERTY_CENTER = "center";
  private GeoJsonPointNonAuthenticatedEntity center;

  public static final String JSON_PROPERTY_DRAGGABLE = "draggable";
  private Boolean draggable = true;

  public static final String JSON_PROPERTY_ZOOMABLE = "zoomable";
  private Boolean zoomable = true;

  public static final String JSON_PROPERTY_INITIAL_ZOOM_LEVEL = "initialZoomLevel";
  private Integer initialZoomLevel;

  /**
   * Map style
   */
  public enum MapStyleEnum {
    NORMAL("normal"),
    
    CLEAN("clean"),
    
    BLUISH("bluish");

    private String value;

    MapStyleEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static MapStyleEnum fromValue(String value) {
      for (MapStyleEnum b : MapStyleEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_MAP_STYLE = "mapStyle";
  private MapStyleEnum mapStyle;

  /**
   * Map marker color
   */
  public enum MapMarkerColorEnum {
    CC2138("cc2138");

    private String value;

    MapMarkerColorEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static MapMarkerColorEnum fromValue(String value) {
      for (MapMarkerColorEnum b : MapMarkerColorEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_MAP_MARKER_COLOR = "mapMarkerColor";
  private MapMarkerColorEnum mapMarkerColor;

  public static final String JSON_PROPERTY_MAP_HEIGHT = "mapHeight";
  private Integer mapHeight;

  /**
   * Indicate which initial values to display first on the front-facing card
   */
  public enum DisplayTypeEnum {
    NATIVE("NATIVE"),
    
    HOTEL("HOTEL"),
    
    ROOM("ROOM");

    private String value;

    DisplayTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static DisplayTypeEnum fromValue(String value) {
      for (DisplayTypeEnum b : DisplayTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_DISPLAY_TYPE = "displayType";
  private DisplayTypeEnum displayType = DisplayTypeEnum.NATIVE;

  public static final String JSON_PROPERTY_CIRCLES = "circles";
  private List<ConfigurableGeoJsonCircleNonAuthenticatedEntity> circles;

  public static final String JSON_PROPERTY_RECTANGLES = "rectangles";
  private List<ConfigurableGeoJsonRectangleNonAuthenticatedEntity> rectangles;

  public static final String JSON_PROPERTY_MARKERS = "markers";
  private List<ConfigurableGeoJsonPointNonAuthenticatedEntity> markers;

  public static final String JSON_PROPERTY_POLYGONS = "polygons";
  private List<ConfigurableGeoJsonPolygonNonAuthenticatedEntity> polygons;

  public AdvancedMapConfigurationNonAuthenticatedEntity() {
  }

  public AdvancedMapConfigurationNonAuthenticatedEntity identifier(UUID identifier) {
    
    this.identifier = identifier;
    return this;
  }

   /**
   * Unique map identifier
   * @return identifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getIdentifier() {
    return identifier;
  }


  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setIdentifier(UUID identifier) {
    this.identifier = identifier;
  }


  public AdvancedMapConfigurationNonAuthenticatedEntity ownerIdentifier(UUID ownerIdentifier) {
    
    this.ownerIdentifier = ownerIdentifier;
    return this;
  }

   /**
   * Map owner identifier
   * @return ownerIdentifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_OWNER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getOwnerIdentifier() {
    return ownerIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_OWNER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setOwnerIdentifier(UUID ownerIdentifier) {
    this.ownerIdentifier = ownerIdentifier;
  }


  public AdvancedMapConfigurationNonAuthenticatedEntity engineConfigurationIdentifier(UUID engineConfigurationIdentifier) {
    
    this.engineConfigurationIdentifier = engineConfigurationIdentifier;
    return this;
  }

   /**
   * Customization identifier
   * @return engineConfigurationIdentifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_ENGINE_CONFIGURATION_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getEngineConfigurationIdentifier() {
    return engineConfigurationIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_ENGINE_CONFIGURATION_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setEngineConfigurationIdentifier(UUID engineConfigurationIdentifier) {
    this.engineConfigurationIdentifier = engineConfigurationIdentifier;
  }


  public AdvancedMapConfigurationNonAuthenticatedEntity name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * Name of map
   * @return name
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setName(String name) {
    this.name = name;
  }


  public AdvancedMapConfigurationNonAuthenticatedEntity typeIdentifier(UUID typeIdentifier) {
    
    this.typeIdentifier = typeIdentifier;
    return this;
  }

   /**
   * Inventory type identifier. Either a single channel inventory identifier, a list identifier or a dynamic search identifier.
   * @return typeIdentifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_TYPE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getTypeIdentifier() {
    return typeIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_TYPE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setTypeIdentifier(UUID typeIdentifier) {
    this.typeIdentifier = typeIdentifier;
  }


  public AdvancedMapConfigurationNonAuthenticatedEntity type(TypeEnum type) {
    
    this.type = type;
    return this;
  }

   /**
   * Type of inventory
   * @return type
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public TypeEnum getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setType(TypeEnum type) {
    this.type = type;
  }


  public AdvancedMapConfigurationNonAuthenticatedEntity center(GeoJsonPointNonAuthenticatedEntity center) {
    
    this.center = center;
    return this;
  }

   /**
   * Get center
   * @return center
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_CENTER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public GeoJsonPointNonAuthenticatedEntity getCenter() {
    return center;
  }


  @JsonProperty(JSON_PROPERTY_CENTER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCenter(GeoJsonPointNonAuthenticatedEntity center) {
    this.center = center;
  }


  public AdvancedMapConfigurationNonAuthenticatedEntity draggable(Boolean draggable) {
    
    this.draggable = draggable;
    return this;
  }

   /**
   * User can move around / pan the map
   * @return draggable
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_DRAGGABLE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getDraggable() {
    return draggable;
  }


  @JsonProperty(JSON_PROPERTY_DRAGGABLE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDraggable(Boolean draggable) {
    this.draggable = draggable;
  }


  public AdvancedMapConfigurationNonAuthenticatedEntity zoomable(Boolean zoomable) {
    
    this.zoomable = zoomable;
    return this;
  }

   /**
   * User can zoom in/out of the map
   * @return zoomable
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_ZOOMABLE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getZoomable() {
    return zoomable;
  }


  @JsonProperty(JSON_PROPERTY_ZOOMABLE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setZoomable(Boolean zoomable) {
    this.zoomable = zoomable;
  }


  public AdvancedMapConfigurationNonAuthenticatedEntity initialZoomLevel(Integer initialZoomLevel) {
    
    this.initialZoomLevel = initialZoomLevel;
    return this;
  }

   /**
   * Valid Google maps zoom level
   * minimum: 0
   * maximum: 21
   * @return initialZoomLevel
  **/
  @jakarta.annotation.Nonnull
  @NotNull
 @Min(0) @Max(21)
  @JsonProperty(JSON_PROPERTY_INITIAL_ZOOM_LEVEL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getInitialZoomLevel() {
    return initialZoomLevel;
  }


  @JsonProperty(JSON_PROPERTY_INITIAL_ZOOM_LEVEL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setInitialZoomLevel(Integer initialZoomLevel) {
    this.initialZoomLevel = initialZoomLevel;
  }


  public AdvancedMapConfigurationNonAuthenticatedEntity mapStyle(MapStyleEnum mapStyle) {
    
    this.mapStyle = mapStyle;
    return this;
  }

   /**
   * Map style
   * @return mapStyle
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_MAP_STYLE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public MapStyleEnum getMapStyle() {
    return mapStyle;
  }


  @JsonProperty(JSON_PROPERTY_MAP_STYLE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setMapStyle(MapStyleEnum mapStyle) {
    this.mapStyle = mapStyle;
  }


  public AdvancedMapConfigurationNonAuthenticatedEntity mapMarkerColor(MapMarkerColorEnum mapMarkerColor) {
    
    this.mapMarkerColor = mapMarkerColor;
    return this;
  }

   /**
   * Map marker color
   * @return mapMarkerColor
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_MAP_MARKER_COLOR)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public MapMarkerColorEnum getMapMarkerColor() {
    return mapMarkerColor;
  }


  @JsonProperty(JSON_PROPERTY_MAP_MARKER_COLOR)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setMapMarkerColor(MapMarkerColorEnum mapMarkerColor) {
    this.mapMarkerColor = mapMarkerColor;
  }


  public AdvancedMapConfigurationNonAuthenticatedEntity mapHeight(Integer mapHeight) {
    
    this.mapHeight = mapHeight;
    return this;
  }

   /**
   * Map height in pixels
   * minimum: 1
   * @return mapHeight
  **/
  @jakarta.annotation.Nonnull
  @NotNull
 @Min(1)
  @JsonProperty(JSON_PROPERTY_MAP_HEIGHT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getMapHeight() {
    return mapHeight;
  }


  @JsonProperty(JSON_PROPERTY_MAP_HEIGHT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setMapHeight(Integer mapHeight) {
    this.mapHeight = mapHeight;
  }


  public AdvancedMapConfigurationNonAuthenticatedEntity displayType(DisplayTypeEnum displayType) {
    
    this.displayType = displayType;
    return this;
  }

   /**
   * Indicate which initial values to display first on the front-facing card
   * @return displayType
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_DISPLAY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public DisplayTypeEnum getDisplayType() {
    return displayType;
  }


  @JsonProperty(JSON_PROPERTY_DISPLAY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDisplayType(DisplayTypeEnum displayType) {
    this.displayType = displayType;
  }


  public AdvancedMapConfigurationNonAuthenticatedEntity circles(List<ConfigurableGeoJsonCircleNonAuthenticatedEntity> circles) {
    
    this.circles = circles;
    return this;
  }

  public AdvancedMapConfigurationNonAuthenticatedEntity addCirclesItem(ConfigurableGeoJsonCircleNonAuthenticatedEntity circlesItem) {
    if (this.circles == null) {
      this.circles = new ArrayList<>();
    }
    this.circles.add(circlesItem);
    return this;
  }

   /**
   * Get circles
   * @return circles
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_CIRCLES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<ConfigurableGeoJsonCircleNonAuthenticatedEntity> getCircles() {
    return circles;
  }


  @JsonProperty(JSON_PROPERTY_CIRCLES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCircles(List<ConfigurableGeoJsonCircleNonAuthenticatedEntity> circles) {
    this.circles = circles;
  }


  public AdvancedMapConfigurationNonAuthenticatedEntity rectangles(List<ConfigurableGeoJsonRectangleNonAuthenticatedEntity> rectangles) {
    
    this.rectangles = rectangles;
    return this;
  }

  public AdvancedMapConfigurationNonAuthenticatedEntity addRectanglesItem(ConfigurableGeoJsonRectangleNonAuthenticatedEntity rectanglesItem) {
    if (this.rectangles == null) {
      this.rectangles = new ArrayList<>();
    }
    this.rectangles.add(rectanglesItem);
    return this;
  }

   /**
   * Get rectangles
   * @return rectangles
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_RECTANGLES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<ConfigurableGeoJsonRectangleNonAuthenticatedEntity> getRectangles() {
    return rectangles;
  }


  @JsonProperty(JSON_PROPERTY_RECTANGLES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRectangles(List<ConfigurableGeoJsonRectangleNonAuthenticatedEntity> rectangles) {
    this.rectangles = rectangles;
  }


  public AdvancedMapConfigurationNonAuthenticatedEntity markers(List<ConfigurableGeoJsonPointNonAuthenticatedEntity> markers) {
    
    this.markers = markers;
    return this;
  }

  public AdvancedMapConfigurationNonAuthenticatedEntity addMarkersItem(ConfigurableGeoJsonPointNonAuthenticatedEntity markersItem) {
    if (this.markers == null) {
      this.markers = new ArrayList<>();
    }
    this.markers.add(markersItem);
    return this;
  }

   /**
   * Get markers
   * @return markers
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_MARKERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<ConfigurableGeoJsonPointNonAuthenticatedEntity> getMarkers() {
    return markers;
  }


  @JsonProperty(JSON_PROPERTY_MARKERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMarkers(List<ConfigurableGeoJsonPointNonAuthenticatedEntity> markers) {
    this.markers = markers;
  }


  public AdvancedMapConfigurationNonAuthenticatedEntity polygons(List<ConfigurableGeoJsonPolygonNonAuthenticatedEntity> polygons) {
    
    this.polygons = polygons;
    return this;
  }

  public AdvancedMapConfigurationNonAuthenticatedEntity addPolygonsItem(ConfigurableGeoJsonPolygonNonAuthenticatedEntity polygonsItem) {
    if (this.polygons == null) {
      this.polygons = new ArrayList<>();
    }
    this.polygons.add(polygonsItem);
    return this;
  }

   /**
   * Get polygons
   * @return polygons
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_POLYGONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<ConfigurableGeoJsonPolygonNonAuthenticatedEntity> getPolygons() {
    return polygons;
  }


  @JsonProperty(JSON_PROPERTY_POLYGONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPolygons(List<ConfigurableGeoJsonPolygonNonAuthenticatedEntity> polygons) {
    this.polygons = polygons;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AdvancedMapConfigurationNonAuthenticatedEntity advancedMapConfigurationNonAuthenticatedEntity = (AdvancedMapConfigurationNonAuthenticatedEntity) o;
    return Objects.equals(this.identifier, advancedMapConfigurationNonAuthenticatedEntity.identifier) &&
        Objects.equals(this.ownerIdentifier, advancedMapConfigurationNonAuthenticatedEntity.ownerIdentifier) &&
        Objects.equals(this.engineConfigurationIdentifier, advancedMapConfigurationNonAuthenticatedEntity.engineConfigurationIdentifier) &&
        Objects.equals(this.name, advancedMapConfigurationNonAuthenticatedEntity.name) &&
        Objects.equals(this.typeIdentifier, advancedMapConfigurationNonAuthenticatedEntity.typeIdentifier) &&
        Objects.equals(this.type, advancedMapConfigurationNonAuthenticatedEntity.type) &&
        Objects.equals(this.center, advancedMapConfigurationNonAuthenticatedEntity.center) &&
        Objects.equals(this.draggable, advancedMapConfigurationNonAuthenticatedEntity.draggable) &&
        Objects.equals(this.zoomable, advancedMapConfigurationNonAuthenticatedEntity.zoomable) &&
        Objects.equals(this.initialZoomLevel, advancedMapConfigurationNonAuthenticatedEntity.initialZoomLevel) &&
        Objects.equals(this.mapStyle, advancedMapConfigurationNonAuthenticatedEntity.mapStyle) &&
        Objects.equals(this.mapMarkerColor, advancedMapConfigurationNonAuthenticatedEntity.mapMarkerColor) &&
        Objects.equals(this.mapHeight, advancedMapConfigurationNonAuthenticatedEntity.mapHeight) &&
        Objects.equals(this.displayType, advancedMapConfigurationNonAuthenticatedEntity.displayType) &&
        Objects.equals(this.circles, advancedMapConfigurationNonAuthenticatedEntity.circles) &&
        Objects.equals(this.rectangles, advancedMapConfigurationNonAuthenticatedEntity.rectangles) &&
        Objects.equals(this.markers, advancedMapConfigurationNonAuthenticatedEntity.markers) &&
        Objects.equals(this.polygons, advancedMapConfigurationNonAuthenticatedEntity.polygons);
  }

  @Override
  public int hashCode() {
    return Objects.hash(identifier, ownerIdentifier, engineConfigurationIdentifier, name, typeIdentifier, type, center, draggable, zoomable, initialZoomLevel, mapStyle, mapMarkerColor, mapHeight, displayType, circles, rectangles, markers, polygons);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AdvancedMapConfigurationNonAuthenticatedEntity {\n");
    sb.append("    identifier: ").append(toIndentedString(identifier)).append("\n");
    sb.append("    ownerIdentifier: ").append(toIndentedString(ownerIdentifier)).append("\n");
    sb.append("    engineConfigurationIdentifier: ").append(toIndentedString(engineConfigurationIdentifier)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    typeIdentifier: ").append(toIndentedString(typeIdentifier)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    center: ").append(toIndentedString(center)).append("\n");
    sb.append("    draggable: ").append(toIndentedString(draggable)).append("\n");
    sb.append("    zoomable: ").append(toIndentedString(zoomable)).append("\n");
    sb.append("    initialZoomLevel: ").append(toIndentedString(initialZoomLevel)).append("\n");
    sb.append("    mapStyle: ").append(toIndentedString(mapStyle)).append("\n");
    sb.append("    mapMarkerColor: ").append(toIndentedString(mapMarkerColor)).append("\n");
    sb.append("    mapHeight: ").append(toIndentedString(mapHeight)).append("\n");
    sb.append("    displayType: ").append(toIndentedString(displayType)).append("\n");
    sb.append("    circles: ").append(toIndentedString(circles)).append("\n");
    sb.append("    rectangles: ").append(toIndentedString(rectangles)).append("\n");
    sb.append("    markers: ").append(toIndentedString(markers)).append("\n");
    sb.append("    polygons: ").append(toIndentedString(polygons)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

