/*
 * Wink API
 *  # Introduction  Welcome to the Wink API - A programmer-friendly way to manage, sell and book travel inventory on the Wink platform. The API gives you all the tools you need to ready your properties and inventory for sale across 1000s of our native sales channels.  Integrators, affiliates, travel agents and content creators have the ability search for your travel inventory and promote / sell it in a wide variety of ways.   # Integrations  We have already integrated with the most well-known channel managers so you don't have to. To see our current integrations, please go to https://extranet.wink.travel and scroll to Connectivity section. Once your properties are set up, you can finish the setup by mapping your property to Wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API.   # Intended Audience  Programmers are [most likely] a requirement to start integrating with Wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible.  - Hotel chains  - Hotel brands  - Travel tech companies  - Destination sites  - Integrators  - Aggregators  - Destination management companies  - Travel agencies  - OTAs   ## APIs  Not every integrator needs every API. For that reason, we have separated APIs into context.  ### Test API   - [Ping](/ping): The Ping API is a quick test endpoint to verify that your credentials work Wink.  ### Common APIs  - [Notifications](/notifications): The Notifications API is a way for us to stay in touch with your user, property or affiliate account. - [User Settings](/user-settings): The User Settings API exposes endpoints to allow 3rd party integrators to communicate with Wink.  ### Consume APIs Consume endpoints are for developers who want to find existing travel inventory and either book it or use it to advertise through one of their Wink affiliate accounts.   - [Configuration](/engine-client): A single endpoint to retrieve whitelabel + customization information for the booking engine.  - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags.  - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API..  - [Booking](/booking): All APIs related to creating bookings on the platform.  - [Travel Agent](/travel-agent): The Travel Agent API exposes endpoints to manage agent-facilitated bookings.   ### Produce APIs  Produce endpoints are for developers who want to create and manage travel inventory.   #### Property  - [Property registration](/extranet/property/register): As a producer, this is, oftentimes, where you start your journey. These endpoints let you create properties on Wink.  - [Property](/extranet/property): This collection of property endpoints are mostly management endpoints that let you display, change status and similar for your existing properties.  - [Facilities](/extranet/facilities): This collection of endpoints let you manage facilities; such as room types.  - [Experiences](/extranet/experiences): This collection of endpoints let you manage experiences, such as activities.  - [Monetize](/extranet/monetize): The Monetize API exposes endpoints for managing cancellation polies, rate plans, promotions and more on Wink.  - [Distribution](/extranet/distribution): The Distribution API exposes endpoints for sales channels, connecting with affiliates, managing rates and inventory calendars and more on Wink.  - [Property Booking](/extranet/booking): The Property Booking API exposes endpoints for managing bookings and reviews at the property-level.   #### Affiliate  - [Affiliate](/affiliate): This collection of affiliate endpoints are mostly management endpoints that let you display, change status and similar for your existing accounts.  - [Browse](/affiliate/browse): The Browse API exposes endpoints for affiliates to find suppliers and inventory to sell.  - [Inventory](/affiliate/inventory): The Inventory API exposes endpoints for affiliates to manage the inventory they want to sell and how they want to sell it.  - [Sales Channel](/affiliate/sales-channel): The Sales Channel API exposes endpoints for affiliates to manage existing sales channels as well as find new ones.  - [WinkLinks](/affiliate/winklinks): The WinkLinks API exposes endpoints for affiliates to manage their WinkLinks page.   #### Rate provider  - [Channel manager](/channel-manager): The Channel Manager API enables external channel manager partners to map, exchange rate / availability information with us as well as be informed of bookings that occur on the Wink platform for one of their properties.   ### Taxonomy APIs  Taxonomy endpoints are for developers who want to consume and produce travel inventory and need taxonomies of standard and non-standard codes for inventory types, classes, statuses etc.   - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies.   ### Insight APIs  Insight endpoints do exactly what the name implies - They offer platform-level insight into the activities of producers and consumers.   - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics.   ### Payment APIs  Payment endpoints are for developers who want to purchase travel inventory. This can be done via the API as a registered Travel Agent or using our API in conjunction with our PCI compliant payment widget for all other entities.   - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.   ## SDKs  We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).   - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)   ## Usage  These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.   ## Versioning  We chose to version our endpoints in a way that we hope affects your integration minimally. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.   ## Release history  - Follow updates on Github: https://github.com/wink-travel/wink-sdk-java/blob/master/CHANGELOG.md    # Inventory API The Inventory API exposes endpoints to retrieve inventory you already know about. This API lets you:  1. Consume shareable links. 2. Load up a known property with availability. 3. Load up all inventories that were created by our affiliates such as grids, maps, and individual items.  Browse the endpoints in the left navigation bar to get started.  
 *
 * The version of the OpenAPI document: 30.5.2
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.inventory.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import travel.wink.sdk.inventory.model.SimpleDescriptionNonAuthenticatedEntity;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Identifier inventory record
 */
@JsonPropertyOrder({
  SellerInventoryItemNonAuthenticatedEntity.JSON_PROPERTY_IDENTIFIER,
  SellerInventoryItemNonAuthenticatedEntity.JSON_PROPERTY_SELLER_IDENTIFIER,
  SellerInventoryItemNonAuthenticatedEntity.JSON_PROPERTY_SELLER_INVENTORY_ITEM_NAME,
  SellerInventoryItemNonAuthenticatedEntity.JSON_PROPERTY_ENGINE_CONFIGURATION_IDENTIFIER,
  SellerInventoryItemNonAuthenticatedEntity.JSON_PROPERTY_DESCRIPTIONS,
  SellerInventoryItemNonAuthenticatedEntity.JSON_PROPERTY_KEYWORDS,
  SellerInventoryItemNonAuthenticatedEntity.JSON_PROPERTY_STATUS,
  SellerInventoryItemNonAuthenticatedEntity.JSON_PROPERTY_INVENTORY_STATUS,
  SellerInventoryItemNonAuthenticatedEntity.JSON_PROPERTY_INVENTORY_TYPE,
  SellerInventoryItemNonAuthenticatedEntity.JSON_PROPERTY_CHANNEL_INVENTORY_TYPE,
  SellerInventoryItemNonAuthenticatedEntity.JSON_PROPERTY_SUPPLIER_IDENTIFIER,
  SellerInventoryItemNonAuthenticatedEntity.JSON_PROPERTY_CHANNEL_INVENTORY_IDENTIFIER,
  SellerInventoryItemNonAuthenticatedEntity.JSON_PROPERTY_MULTIMEDIA_IDENTIFIERS,
  SellerInventoryItemNonAuthenticatedEntity.JSON_PROPERTY_ANIMATE,
  SellerInventoryItemNonAuthenticatedEntity.JSON_PROPERTY_ANIMATE_DELAY,
  SellerInventoryItemNonAuthenticatedEntity.JSON_PROPERTY_SORT,
  SellerInventoryItemNonAuthenticatedEntity.JSON_PROPERTY_DISPLAY_TYPE
})
@JsonTypeName("SellerInventoryItem_Non_Authenticated_Entity")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-09-15T11:59:38.583609063+07:00[Asia/Bangkok]")
public class SellerInventoryItemNonAuthenticatedEntity {
  public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
  private UUID identifier;

  public static final String JSON_PROPERTY_SELLER_IDENTIFIER = "sellerIdentifier";
  private UUID sellerIdentifier;

  public static final String JSON_PROPERTY_SELLER_INVENTORY_ITEM_NAME = "sellerInventoryItemName";
  private String sellerInventoryItemName;

  public static final String JSON_PROPERTY_ENGINE_CONFIGURATION_IDENTIFIER = "engineConfigurationIdentifier";
  private UUID engineConfigurationIdentifier;

  public static final String JSON_PROPERTY_DESCRIPTIONS = "descriptions";
  private List<SimpleDescriptionNonAuthenticatedEntity> descriptions = new ArrayList<>();

  public static final String JSON_PROPERTY_KEYWORDS = "keywords";
  private List<String> keywords = new ArrayList<>();

  /**
   * Availability status
   */
  public enum StatusEnum {
    ACTIVE("ACTIVE"),
    
    INACTIVE("INACTIVE"),
    
    REMOVED("REMOVED");

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static StatusEnum fromValue(String value) {
      for (StatusEnum b : StatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_STATUS = "status";
  private StatusEnum status = StatusEnum.ACTIVE;

  /**
   * Url sell status
   */
  public enum InventoryStatusEnum {
    ACTIVE("ACTIVE"),
    
    INACTIVE("INACTIVE"),
    
    REMOVED("REMOVED");

    private String value;

    InventoryStatusEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static InventoryStatusEnum fromValue(String value) {
      for (InventoryStatusEnum b : InventoryStatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_INVENTORY_STATUS = "inventoryStatus";
  private InventoryStatusEnum inventoryStatus;

  /**
   * The type of inventory being offer up for sale
   */
  public enum InventoryTypeEnum {
    HOTEL("HOTEL"),
    
    GUEST_ROOM("GUEST_ROOM"),
    
    MEETING_ROOM("MEETING_ROOM"),
    
    RESTAURANT("RESTAURANT"),
    
    SPA("SPA"),
    
    ADD_ON("ADD_ON"),
    
    ATTRACTION("ATTRACTION"),
    
    ACTIVITY("ACTIVITY"),
    
    PLACE("PLACE");

    private String value;

    InventoryTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static InventoryTypeEnum fromValue(String value) {
      for (InventoryTypeEnum b : InventoryTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_INVENTORY_TYPE = "inventoryType";
  private InventoryTypeEnum inventoryType;

  /**
   * Channel inventory type is a subset of inventory type in that it does not include the &#x60;HOTEL&#x60; type. THe way it works is, as a seller you might want to sell a guest room but instead of showing the price of that guest room, you would like to display the best room type price for the property.
   */
  public enum ChannelInventoryTypeEnum {
    GUEST_ROOM("GUEST_ROOM"),
    
    ADD_ON("ADD_ON"),
    
    MEETING_ROOM("MEETING_ROOM"),
    
    RESTAURANT("RESTAURANT"),
    
    SPA("SPA"),
    
    ATTRACTION("ATTRACTION"),
    
    PLACE("PLACE"),
    
    ACTIVITY("ACTIVITY");

    private String value;

    ChannelInventoryTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ChannelInventoryTypeEnum fromValue(String value) {
      for (ChannelInventoryTypeEnum b : ChannelInventoryTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_CHANNEL_INVENTORY_TYPE = "channelInventoryType";
  private ChannelInventoryTypeEnum channelInventoryType;

  public static final String JSON_PROPERTY_SUPPLIER_IDENTIFIER = "supplierIdentifier";
  private UUID supplierIdentifier;

  public static final String JSON_PROPERTY_CHANNEL_INVENTORY_IDENTIFIER = "channelInventoryIdentifier";
  private UUID channelInventoryIdentifier;

  public static final String JSON_PROPERTY_MULTIMEDIA_IDENTIFIERS = "multimediaIdentifiers";
  private List<String> multimediaIdentifiers = new ArrayList<>();

  public static final String JSON_PROPERTY_ANIMATE = "animate";
  private Boolean animate = false;

  public static final String JSON_PROPERTY_ANIMATE_DELAY = "animateDelay";
  private Integer animateDelay;

  /**
   * The specific badge to display over the image on the Web Component.
   */
  public enum SortEnum {
    MEMBER("MEMBER"),
    
    PRICE_LOW_TO_HIGH("PRICE_LOW_TO_HIGH"),
    
    PRICE_HIGH_TO_LOW("PRICE_HIGH_TO_LOW"),
    
    PRICE("PRICE"),
    
    POPULARITY("POPULARITY"),
    
    ECO("ECO"),
    
    EXPERIENCE("EXPERIENCE"),
    
    PERK("PERK"),
    
    LOYALTY("LOYALTY"),
    
    PACKAGE("PACKAGE");

    private String value;

    SortEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static SortEnum fromValue(String value) {
      for (SortEnum b : SortEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_SORT = "sort";
  private SortEnum sort;

  /**
   * Indicate which initial values to display first on the front-facing card
   */
  public enum DisplayTypeEnum {
    NATIVE("NATIVE"),
    
    HOTEL("HOTEL"),
    
    ROOM("ROOM");

    private String value;

    DisplayTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static DisplayTypeEnum fromValue(String value) {
      for (DisplayTypeEnum b : DisplayTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_DISPLAY_TYPE = "displayType";
  private DisplayTypeEnum displayType = DisplayTypeEnum.NATIVE;

  public SellerInventoryItemNonAuthenticatedEntity() {
  }

  public SellerInventoryItemNonAuthenticatedEntity identifier(UUID identifier) {
    
    this.identifier = identifier;
    return this;
  }

   /**
   * Unique identifier
   * @return identifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getIdentifier() {
    return identifier;
  }


  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setIdentifier(UUID identifier) {
    this.identifier = identifier;
  }


  public SellerInventoryItemNonAuthenticatedEntity sellerIdentifier(UUID sellerIdentifier) {
    
    this.sellerIdentifier = sellerIdentifier;
    return this;
  }

   /**
   * Company / Owner identifier
   * @return sellerIdentifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_SELLER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getSellerIdentifier() {
    return sellerIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_SELLER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSellerIdentifier(UUID sellerIdentifier) {
    this.sellerIdentifier = sellerIdentifier;
  }


  public SellerInventoryItemNonAuthenticatedEntity sellerInventoryItemName(String sellerInventoryItemName) {
    
    this.sellerInventoryItemName = sellerInventoryItemName;
    return this;
  }

   /**
   * Descriptive name of this item for seller use
   * @return sellerInventoryItemName
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_SELLER_INVENTORY_ITEM_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getSellerInventoryItemName() {
    return sellerInventoryItemName;
  }


  @JsonProperty(JSON_PROPERTY_SELLER_INVENTORY_ITEM_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSellerInventoryItemName(String sellerInventoryItemName) {
    this.sellerInventoryItemName = sellerInventoryItemName;
  }


  public SellerInventoryItemNonAuthenticatedEntity engineConfigurationIdentifier(UUID engineConfigurationIdentifier) {
    
    this.engineConfigurationIdentifier = engineConfigurationIdentifier;
    return this;
  }

   /**
   * Which configuration to use with this item
   * @return engineConfigurationIdentifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_ENGINE_CONFIGURATION_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getEngineConfigurationIdentifier() {
    return engineConfigurationIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_ENGINE_CONFIGURATION_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setEngineConfigurationIdentifier(UUID engineConfigurationIdentifier) {
    this.engineConfigurationIdentifier = engineConfigurationIdentifier;
  }


  public SellerInventoryItemNonAuthenticatedEntity descriptions(List<SimpleDescriptionNonAuthenticatedEntity> descriptions) {
    
    this.descriptions = descriptions;
    return this;
  }

  public SellerInventoryItemNonAuthenticatedEntity addDescriptionsItem(SimpleDescriptionNonAuthenticatedEntity descriptionsItem) {
    if (this.descriptions == null) {
      this.descriptions = new ArrayList<>();
    }
    this.descriptions.add(descriptionsItem);
    return this;
  }

   /**
   * Title and description of inventory.
   * @return descriptions
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid
 @Size(min=1,max=2147483647)
  @JsonProperty(JSON_PROPERTY_DESCRIPTIONS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<SimpleDescriptionNonAuthenticatedEntity> getDescriptions() {
    return descriptions;
  }


  @JsonProperty(JSON_PROPERTY_DESCRIPTIONS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDescriptions(List<SimpleDescriptionNonAuthenticatedEntity> descriptions) {
    this.descriptions = descriptions;
  }


  public SellerInventoryItemNonAuthenticatedEntity keywords(List<String> keywords) {
    
    this.keywords = keywords;
    return this;
  }

  public SellerInventoryItemNonAuthenticatedEntity addKeywordsItem(String keywordsItem) {
    if (this.keywords == null) {
      this.keywords = new ArrayList<>();
    }
    this.keywords.add(keywordsItem);
    return this;
  }

   /**
   * Get keywords
   * @return keywords
  **/
  @jakarta.annotation.Nonnull
  @NotNull
 @Size(min=1,max=2147483647)
  @JsonProperty(JSON_PROPERTY_KEYWORDS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<String> getKeywords() {
    return keywords;
  }


  @JsonProperty(JSON_PROPERTY_KEYWORDS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setKeywords(List<String> keywords) {
    this.keywords = keywords;
  }


  public SellerInventoryItemNonAuthenticatedEntity status(StatusEnum status) {
    
    this.status = status;
    return this;
  }

   /**
   * Availability status
   * @return status
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public StatusEnum getStatus() {
    return status;
  }


  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setStatus(StatusEnum status) {
    this.status = status;
  }


  public SellerInventoryItemNonAuthenticatedEntity inventoryStatus(InventoryStatusEnum inventoryStatus) {
    
    this.inventoryStatus = inventoryStatus;
    return this;
  }

   /**
   * Url sell status
   * @return inventoryStatus
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_INVENTORY_STATUS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public InventoryStatusEnum getInventoryStatus() {
    return inventoryStatus;
  }


  @JsonProperty(JSON_PROPERTY_INVENTORY_STATUS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setInventoryStatus(InventoryStatusEnum inventoryStatus) {
    this.inventoryStatus = inventoryStatus;
  }


  public SellerInventoryItemNonAuthenticatedEntity inventoryType(InventoryTypeEnum inventoryType) {
    
    this.inventoryType = inventoryType;
    return this;
  }

   /**
   * The type of inventory being offer up for sale
   * @return inventoryType
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_INVENTORY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public InventoryTypeEnum getInventoryType() {
    return inventoryType;
  }


  @JsonProperty(JSON_PROPERTY_INVENTORY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setInventoryType(InventoryTypeEnum inventoryType) {
    this.inventoryType = inventoryType;
  }


  public SellerInventoryItemNonAuthenticatedEntity channelInventoryType(ChannelInventoryTypeEnum channelInventoryType) {
    
    this.channelInventoryType = channelInventoryType;
    return this;
  }

   /**
   * Channel inventory type is a subset of inventory type in that it does not include the &#x60;HOTEL&#x60; type. THe way it works is, as a seller you might want to sell a guest room but instead of showing the price of that guest room, you would like to display the best room type price for the property.
   * @return channelInventoryType
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_CHANNEL_INVENTORY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public ChannelInventoryTypeEnum getChannelInventoryType() {
    return channelInventoryType;
  }


  @JsonProperty(JSON_PROPERTY_CHANNEL_INVENTORY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setChannelInventoryType(ChannelInventoryTypeEnum channelInventoryType) {
    this.channelInventoryType = channelInventoryType;
  }


  public SellerInventoryItemNonAuthenticatedEntity supplierIdentifier(UUID supplierIdentifier) {
    
    this.supplierIdentifier = supplierIdentifier;
    return this;
  }

   /**
   * Supplier / Hotel identifier that owns this inventory.
   * @return supplierIdentifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_SUPPLIER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getSupplierIdentifier() {
    return supplierIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_SUPPLIER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSupplierIdentifier(UUID supplierIdentifier) {
    this.supplierIdentifier = supplierIdentifier;
  }


  public SellerInventoryItemNonAuthenticatedEntity channelInventoryIdentifier(UUID channelInventoryIdentifier) {
    
    this.channelInventoryIdentifier = channelInventoryIdentifier;
    return this;
  }

   /**
   * The channel inventory record identifier describing the relationship between supplier and seller.
   * @return channelInventoryIdentifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_CHANNEL_INVENTORY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getChannelInventoryIdentifier() {
    return channelInventoryIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_CHANNEL_INVENTORY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setChannelInventoryIdentifier(UUID channelInventoryIdentifier) {
    this.channelInventoryIdentifier = channelInventoryIdentifier;
  }


  public SellerInventoryItemNonAuthenticatedEntity multimediaIdentifiers(List<String> multimediaIdentifiers) {
    
    this.multimediaIdentifiers = multimediaIdentifiers;
    return this;
  }

  public SellerInventoryItemNonAuthenticatedEntity addMultimediaIdentifiersItem(String multimediaIdentifiersItem) {
    if (this.multimediaIdentifiers == null) {
      this.multimediaIdentifiers = new ArrayList<>();
    }
    this.multimediaIdentifiers.add(multimediaIdentifiersItem);
    return this;
  }

   /**
   * Reference identifiers to Cloudinary media assets
   * @return multimediaIdentifiers
  **/
  @jakarta.annotation.Nonnull
  @NotNull
 @Size(min=1,max=2147483647)
  @JsonProperty(JSON_PROPERTY_MULTIMEDIA_IDENTIFIERS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<String> getMultimediaIdentifiers() {
    return multimediaIdentifiers;
  }


  @JsonProperty(JSON_PROPERTY_MULTIMEDIA_IDENTIFIERS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setMultimediaIdentifiers(List<String> multimediaIdentifiers) {
    this.multimediaIdentifiers = multimediaIdentifiers;
  }


  public SellerInventoryItemNonAuthenticatedEntity animate(Boolean animate) {
    
    this.animate = animate;
    return this;
  }

   /**
   * Create an animated gif instead of a list of images. Feature currently not available. Feel free to enable and it will become available at a later date.
   * @return animate
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ANIMATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getAnimate() {
    return animate;
  }


  @JsonProperty(JSON_PROPERTY_ANIMATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAnimate(Boolean animate) {
    this.animate = animate;
  }


  public SellerInventoryItemNonAuthenticatedEntity animateDelay(Integer animateDelay) {
    
    this.animateDelay = animateDelay;
    return this;
  }

   /**
   * Controls animation delay in milliseconds.
   * @return animateDelay
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ANIMATE_DELAY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getAnimateDelay() {
    return animateDelay;
  }


  @JsonProperty(JSON_PROPERTY_ANIMATE_DELAY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAnimateDelay(Integer animateDelay) {
    this.animateDelay = animateDelay;
  }


  public SellerInventoryItemNonAuthenticatedEntity sort(SortEnum sort) {
    
    this.sort = sort;
    return this;
  }

   /**
   * The specific badge to display over the image on the Web Component.
   * @return sort
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public SortEnum getSort() {
    return sort;
  }


  @JsonProperty(JSON_PROPERTY_SORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSort(SortEnum sort) {
    this.sort = sort;
  }


  public SellerInventoryItemNonAuthenticatedEntity displayType(DisplayTypeEnum displayType) {
    
    this.displayType = displayType;
    return this;
  }

   /**
   * Indicate which initial values to display first on the front-facing card
   * @return displayType
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_DISPLAY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public DisplayTypeEnum getDisplayType() {
    return displayType;
  }


  @JsonProperty(JSON_PROPERTY_DISPLAY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDisplayType(DisplayTypeEnum displayType) {
    this.displayType = displayType;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SellerInventoryItemNonAuthenticatedEntity sellerInventoryItemNonAuthenticatedEntity = (SellerInventoryItemNonAuthenticatedEntity) o;
    return Objects.equals(this.identifier, sellerInventoryItemNonAuthenticatedEntity.identifier) &&
        Objects.equals(this.sellerIdentifier, sellerInventoryItemNonAuthenticatedEntity.sellerIdentifier) &&
        Objects.equals(this.sellerInventoryItemName, sellerInventoryItemNonAuthenticatedEntity.sellerInventoryItemName) &&
        Objects.equals(this.engineConfigurationIdentifier, sellerInventoryItemNonAuthenticatedEntity.engineConfigurationIdentifier) &&
        Objects.equals(this.descriptions, sellerInventoryItemNonAuthenticatedEntity.descriptions) &&
        Objects.equals(this.keywords, sellerInventoryItemNonAuthenticatedEntity.keywords) &&
        Objects.equals(this.status, sellerInventoryItemNonAuthenticatedEntity.status) &&
        Objects.equals(this.inventoryStatus, sellerInventoryItemNonAuthenticatedEntity.inventoryStatus) &&
        Objects.equals(this.inventoryType, sellerInventoryItemNonAuthenticatedEntity.inventoryType) &&
        Objects.equals(this.channelInventoryType, sellerInventoryItemNonAuthenticatedEntity.channelInventoryType) &&
        Objects.equals(this.supplierIdentifier, sellerInventoryItemNonAuthenticatedEntity.supplierIdentifier) &&
        Objects.equals(this.channelInventoryIdentifier, sellerInventoryItemNonAuthenticatedEntity.channelInventoryIdentifier) &&
        Objects.equals(this.multimediaIdentifiers, sellerInventoryItemNonAuthenticatedEntity.multimediaIdentifiers) &&
        Objects.equals(this.animate, sellerInventoryItemNonAuthenticatedEntity.animate) &&
        Objects.equals(this.animateDelay, sellerInventoryItemNonAuthenticatedEntity.animateDelay) &&
        Objects.equals(this.sort, sellerInventoryItemNonAuthenticatedEntity.sort) &&
        Objects.equals(this.displayType, sellerInventoryItemNonAuthenticatedEntity.displayType);
  }

  @Override
  public int hashCode() {
    return Objects.hash(identifier, sellerIdentifier, sellerInventoryItemName, engineConfigurationIdentifier, descriptions, keywords, status, inventoryStatus, inventoryType, channelInventoryType, supplierIdentifier, channelInventoryIdentifier, multimediaIdentifiers, animate, animateDelay, sort, displayType);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SellerInventoryItemNonAuthenticatedEntity {\n");
    sb.append("    identifier: ").append(toIndentedString(identifier)).append("\n");
    sb.append("    sellerIdentifier: ").append(toIndentedString(sellerIdentifier)).append("\n");
    sb.append("    sellerInventoryItemName: ").append(toIndentedString(sellerInventoryItemName)).append("\n");
    sb.append("    engineConfigurationIdentifier: ").append(toIndentedString(engineConfigurationIdentifier)).append("\n");
    sb.append("    descriptions: ").append(toIndentedString(descriptions)).append("\n");
    sb.append("    keywords: ").append(toIndentedString(keywords)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    inventoryStatus: ").append(toIndentedString(inventoryStatus)).append("\n");
    sb.append("    inventoryType: ").append(toIndentedString(inventoryType)).append("\n");
    sb.append("    channelInventoryType: ").append(toIndentedString(channelInventoryType)).append("\n");
    sb.append("    supplierIdentifier: ").append(toIndentedString(supplierIdentifier)).append("\n");
    sb.append("    channelInventoryIdentifier: ").append(toIndentedString(channelInventoryIdentifier)).append("\n");
    sb.append("    multimediaIdentifiers: ").append(toIndentedString(multimediaIdentifiers)).append("\n");
    sb.append("    animate: ").append(toIndentedString(animate)).append("\n");
    sb.append("    animateDelay: ").append(toIndentedString(animateDelay)).append("\n");
    sb.append("    sort: ").append(toIndentedString(sort)).append("\n");
    sb.append("    displayType: ").append(toIndentedString(displayType)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

