package travel.wink.sdk.inventory.api;

import travel.wink.sdk.inventory.invoker.ApiClient;

import travel.wink.sdk.inventory.model.AggregateActivityRequestNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.AggregateAddOnRequestNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.AggregateAttractionRequestNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.AggregateGuestRoomRequestNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.AggregateHotelRequestNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.AggregateInventoryGridItemRequestNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.AggregateMeetingRoomRequestNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.AggregatePlaceRequestNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.AggregateRestaurantRequestNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.AggregateSellerInventoryListRequestNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.AggregateSpaRequestNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.ConsumerDataMapNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.GenericErrorMessage;
import travel.wink.sdk.inventory.model.HotelInventoryListRequestNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.HotelInventoryListResponseNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.HotelInventoryRequestNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.HotelInventoryResponseNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.InventoryGridItemNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.InventoryUnavailableNotificationNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.SellerInventoryActivityNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.SellerInventoryAddOnNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.SellerInventoryAttractionNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.SellerInventoryGuestRoomNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.SellerInventoryHotelNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.SellerInventoryListResponseNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.SellerInventoryMeetingRoomNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.SellerInventoryPlaceNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.SellerInventoryRankedListResponseNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.SellerInventoryRestaurantNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.SellerInventorySpaNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.ShowConsumableUrl400Response;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-02-05T14:55:49.781103366+07:00[Asia/Bangkok]")
public class InventoryApi {
    private ApiClient apiClient;

    public InventoryApi() {
        this(new ApiClient());
    }

    @Autowired
    public InventoryApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Lacks Inventory
     * Notify property that there is a demand but no supply for a specified blocking.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param inventoryUnavailableNotificationNonAuthenticatedEntity The inventoryUnavailableNotificationNonAuthenticatedEntity parameter
     * @param winkVersion The winkVersion parameter
     * @return InventoryUnavailableNotificationNonAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec notifyPropertyRequestCreation(InventoryUnavailableNotificationNonAuthenticatedEntity inventoryUnavailableNotificationNonAuthenticatedEntity, String winkVersion) throws WebClientResponseException {
        Object postBody = inventoryUnavailableNotificationNonAuthenticatedEntity;
        // verify the required parameter 'inventoryUnavailableNotificationNonAuthenticatedEntity' is set
        if (inventoryUnavailableNotificationNonAuthenticatedEntity == null) {
            throw new WebClientResponseException("Missing the required parameter 'inventoryUnavailableNotificationNonAuthenticatedEntity' when calling notifyProperty", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<InventoryUnavailableNotificationNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<InventoryUnavailableNotificationNonAuthenticatedEntity>() {};
        return apiClient.invokeAPI("/api/inventory/unavailable", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Lacks Inventory
     * Notify property that there is a demand but no supply for a specified blocking.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param inventoryUnavailableNotificationNonAuthenticatedEntity The inventoryUnavailableNotificationNonAuthenticatedEntity parameter
     * @param winkVersion The winkVersion parameter
     * @return InventoryUnavailableNotificationNonAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<InventoryUnavailableNotificationNonAuthenticatedEntity> notifyProperty(InventoryUnavailableNotificationNonAuthenticatedEntity inventoryUnavailableNotificationNonAuthenticatedEntity, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<InventoryUnavailableNotificationNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<InventoryUnavailableNotificationNonAuthenticatedEntity>() {};
        return notifyPropertyRequestCreation(inventoryUnavailableNotificationNonAuthenticatedEntity, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Lacks Inventory
     * Notify property that there is a demand but no supply for a specified blocking.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param inventoryUnavailableNotificationNonAuthenticatedEntity The inventoryUnavailableNotificationNonAuthenticatedEntity parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;InventoryUnavailableNotificationNonAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<InventoryUnavailableNotificationNonAuthenticatedEntity>> notifyPropertyWithHttpInfo(InventoryUnavailableNotificationNonAuthenticatedEntity inventoryUnavailableNotificationNonAuthenticatedEntity, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<InventoryUnavailableNotificationNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<InventoryUnavailableNotificationNonAuthenticatedEntity>() {};
        return notifyPropertyRequestCreation(inventoryUnavailableNotificationNonAuthenticatedEntity, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Lacks Inventory
     * Notify property that there is a demand but no supply for a specified blocking.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param inventoryUnavailableNotificationNonAuthenticatedEntity The inventoryUnavailableNotificationNonAuthenticatedEntity parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec notifyPropertyWithResponseSpec(InventoryUnavailableNotificationNonAuthenticatedEntity inventoryUnavailableNotificationNonAuthenticatedEntity, String winkVersion) throws WebClientResponseException {
        return notifyPropertyRequestCreation(inventoryUnavailableNotificationNonAuthenticatedEntity, winkVersion);
    }
    /**
     * Map + Markers
     * Load map and map markers for a configurable map.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param advancedMapConfigurationIdentifier The advancedMapConfigurationIdentifier parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ConsumerDataMapNonAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showConsumerMapRequestCreation(String advancedMapConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'advancedMapConfigurationIdentifier' is set
        if (advancedMapConfigurationIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'advancedMapConfigurationIdentifier' when calling showConsumerMap", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("advancedMapConfigurationIdentifier", advancedMapConfigurationIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<ConsumerDataMapNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<ConsumerDataMapNonAuthenticatedEntity>() {};
        return apiClient.invokeAPI("/api/sell/map/{advancedMapConfigurationIdentifier}/markers", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Map + Markers
     * Load map and map markers for a configurable map.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param advancedMapConfigurationIdentifier The advancedMapConfigurationIdentifier parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ConsumerDataMapNonAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ConsumerDataMapNonAuthenticatedEntity> showConsumerMap(String advancedMapConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<ConsumerDataMapNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<ConsumerDataMapNonAuthenticatedEntity>() {};
        return showConsumerMapRequestCreation(advancedMapConfigurationIdentifier, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Map + Markers
     * Load map and map markers for a configurable map.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param advancedMapConfigurationIdentifier The advancedMapConfigurationIdentifier parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;ConsumerDataMapNonAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<ConsumerDataMapNonAuthenticatedEntity>> showConsumerMapWithHttpInfo(String advancedMapConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<ConsumerDataMapNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<ConsumerDataMapNonAuthenticatedEntity>() {};
        return showConsumerMapRequestCreation(advancedMapConfigurationIdentifier, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Map + Markers
     * Load map and map markers for a configurable map.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param advancedMapConfigurationIdentifier The advancedMapConfigurationIdentifier parameter
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showConsumerMapWithResponseSpec(String advancedMapConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return showConsumerMapRequestCreation(advancedMapConfigurationIdentifier, winkVersion, accept);
    }
    /**
     * Show Inventory Grid Item
     * Shows single grid based on channel inventory identifier 
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param aggregateInventoryGridItemRequestNonAuthenticatedEntity The aggregateInventoryGridItemRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return InventoryGridItemNonAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showInventoryGridItemRequestCreation(AggregateInventoryGridItemRequestNonAuthenticatedEntity aggregateInventoryGridItemRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = aggregateInventoryGridItemRequestNonAuthenticatedEntity;
        // verify the required parameter 'aggregateInventoryGridItemRequestNonAuthenticatedEntity' is set
        if (aggregateInventoryGridItemRequestNonAuthenticatedEntity == null) {
            throw new WebClientResponseException("Missing the required parameter 'aggregateInventoryGridItemRequestNonAuthenticatedEntity' when calling showInventoryGridItem", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "engineConfigurationIdentifier", engineConfigurationIdentifier));

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<InventoryGridItemNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<InventoryGridItemNonAuthenticatedEntity>() {};
        return apiClient.invokeAPI("/api/inventory/grid/item", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Inventory Grid Item
     * Shows single grid based on channel inventory identifier 
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param aggregateInventoryGridItemRequestNonAuthenticatedEntity The aggregateInventoryGridItemRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return InventoryGridItemNonAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<InventoryGridItemNonAuthenticatedEntity> showInventoryGridItem(AggregateInventoryGridItemRequestNonAuthenticatedEntity aggregateInventoryGridItemRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<InventoryGridItemNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<InventoryGridItemNonAuthenticatedEntity>() {};
        return showInventoryGridItemRequestCreation(aggregateInventoryGridItemRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Show Inventory Grid Item
     * Shows single grid based on channel inventory identifier 
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param aggregateInventoryGridItemRequestNonAuthenticatedEntity The aggregateInventoryGridItemRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;InventoryGridItemNonAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<InventoryGridItemNonAuthenticatedEntity>> showInventoryGridItemWithHttpInfo(AggregateInventoryGridItemRequestNonAuthenticatedEntity aggregateInventoryGridItemRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<InventoryGridItemNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<InventoryGridItemNonAuthenticatedEntity>() {};
        return showInventoryGridItemRequestCreation(aggregateInventoryGridItemRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Show Inventory Grid Item
     * Shows single grid based on channel inventory identifier 
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param aggregateInventoryGridItemRequestNonAuthenticatedEntity The aggregateInventoryGridItemRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showInventoryGridItemWithResponseSpec(AggregateInventoryGridItemRequestNonAuthenticatedEntity aggregateInventoryGridItemRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return showInventoryGridItemRequestCreation(aggregateInventoryGridItemRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion, accept);
    }
    /**
     * Show Add-On Inventory
     * Show single add-on based on a channel inventory identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param aggregateAddOnRequestNonAuthenticatedEntity The aggregateAddOnRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return SellerInventoryAddOnNonAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showPropertyAddOnRequestCreation(AggregateAddOnRequestNonAuthenticatedEntity aggregateAddOnRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = aggregateAddOnRequestNonAuthenticatedEntity;
        // verify the required parameter 'aggregateAddOnRequestNonAuthenticatedEntity' is set
        if (aggregateAddOnRequestNonAuthenticatedEntity == null) {
            throw new WebClientResponseException("Missing the required parameter 'aggregateAddOnRequestNonAuthenticatedEntity' when calling showPropertyAddOn", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "engineConfigurationIdentifier", engineConfigurationIdentifier));

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<SellerInventoryAddOnNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<SellerInventoryAddOnNonAuthenticatedEntity>() {};
        return apiClient.invokeAPI("/api/add-on", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Add-On Inventory
     * Show single add-on based on a channel inventory identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param aggregateAddOnRequestNonAuthenticatedEntity The aggregateAddOnRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return SellerInventoryAddOnNonAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<SellerInventoryAddOnNonAuthenticatedEntity> showPropertyAddOn(AggregateAddOnRequestNonAuthenticatedEntity aggregateAddOnRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryAddOnNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<SellerInventoryAddOnNonAuthenticatedEntity>() {};
        return showPropertyAddOnRequestCreation(aggregateAddOnRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Show Add-On Inventory
     * Show single add-on based on a channel inventory identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param aggregateAddOnRequestNonAuthenticatedEntity The aggregateAddOnRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;SellerInventoryAddOnNonAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<SellerInventoryAddOnNonAuthenticatedEntity>> showPropertyAddOnWithHttpInfo(AggregateAddOnRequestNonAuthenticatedEntity aggregateAddOnRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryAddOnNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<SellerInventoryAddOnNonAuthenticatedEntity>() {};
        return showPropertyAddOnRequestCreation(aggregateAddOnRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Show Add-On Inventory
     * Show single add-on based on a channel inventory identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param aggregateAddOnRequestNonAuthenticatedEntity The aggregateAddOnRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showPropertyAddOnWithResponseSpec(AggregateAddOnRequestNonAuthenticatedEntity aggregateAddOnRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return showPropertyAddOnRequestCreation(aggregateAddOnRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion, accept);
    }
    /**
     * Show Property Inventory
     * Show single hotel card with price based on a given record identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param aggregateHotelRequestNonAuthenticatedEntity The aggregateHotelRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return SellerInventoryHotelNonAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showPropertyAggregateRequestCreation(AggregateHotelRequestNonAuthenticatedEntity aggregateHotelRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = aggregateHotelRequestNonAuthenticatedEntity;
        // verify the required parameter 'aggregateHotelRequestNonAuthenticatedEntity' is set
        if (aggregateHotelRequestNonAuthenticatedEntity == null) {
            throw new WebClientResponseException("Missing the required parameter 'aggregateHotelRequestNonAuthenticatedEntity' when calling showPropertyAggregate", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "engineConfigurationIdentifier", engineConfigurationIdentifier));

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<SellerInventoryHotelNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<SellerInventoryHotelNonAuthenticatedEntity>() {};
        return apiClient.invokeAPI("/api/inventory/property", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Property Inventory
     * Show single hotel card with price based on a given record identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param aggregateHotelRequestNonAuthenticatedEntity The aggregateHotelRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return SellerInventoryHotelNonAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<SellerInventoryHotelNonAuthenticatedEntity> showPropertyAggregate(AggregateHotelRequestNonAuthenticatedEntity aggregateHotelRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryHotelNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<SellerInventoryHotelNonAuthenticatedEntity>() {};
        return showPropertyAggregateRequestCreation(aggregateHotelRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Show Property Inventory
     * Show single hotel card with price based on a given record identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param aggregateHotelRequestNonAuthenticatedEntity The aggregateHotelRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;SellerInventoryHotelNonAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<SellerInventoryHotelNonAuthenticatedEntity>> showPropertyAggregateWithHttpInfo(AggregateHotelRequestNonAuthenticatedEntity aggregateHotelRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryHotelNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<SellerInventoryHotelNonAuthenticatedEntity>() {};
        return showPropertyAggregateRequestCreation(aggregateHotelRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Show Property Inventory
     * Show single hotel card with price based on a given record identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param aggregateHotelRequestNonAuthenticatedEntity The aggregateHotelRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showPropertyAggregateWithResponseSpec(AggregateHotelRequestNonAuthenticatedEntity aggregateHotelRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return showPropertyAggregateRequestCreation(aggregateHotelRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion, accept);
    }
    /**
     * Show Attraction Inventory
     * Show single attraction based on a channel inventory identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param aggregateAttractionRequestNonAuthenticatedEntity The aggregateAttractionRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return SellerInventoryAttractionNonAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showPropertyAttractionRequestCreation(AggregateAttractionRequestNonAuthenticatedEntity aggregateAttractionRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = aggregateAttractionRequestNonAuthenticatedEntity;
        // verify the required parameter 'aggregateAttractionRequestNonAuthenticatedEntity' is set
        if (aggregateAttractionRequestNonAuthenticatedEntity == null) {
            throw new WebClientResponseException("Missing the required parameter 'aggregateAttractionRequestNonAuthenticatedEntity' when calling showPropertyAttraction", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "engineConfigurationIdentifier", engineConfigurationIdentifier));

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<SellerInventoryAttractionNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<SellerInventoryAttractionNonAuthenticatedEntity>() {};
        return apiClient.invokeAPI("/api/experience/attraction", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Attraction Inventory
     * Show single attraction based on a channel inventory identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param aggregateAttractionRequestNonAuthenticatedEntity The aggregateAttractionRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return SellerInventoryAttractionNonAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<SellerInventoryAttractionNonAuthenticatedEntity> showPropertyAttraction(AggregateAttractionRequestNonAuthenticatedEntity aggregateAttractionRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryAttractionNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<SellerInventoryAttractionNonAuthenticatedEntity>() {};
        return showPropertyAttractionRequestCreation(aggregateAttractionRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Show Attraction Inventory
     * Show single attraction based on a channel inventory identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param aggregateAttractionRequestNonAuthenticatedEntity The aggregateAttractionRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;SellerInventoryAttractionNonAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<SellerInventoryAttractionNonAuthenticatedEntity>> showPropertyAttractionWithHttpInfo(AggregateAttractionRequestNonAuthenticatedEntity aggregateAttractionRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryAttractionNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<SellerInventoryAttractionNonAuthenticatedEntity>() {};
        return showPropertyAttractionRequestCreation(aggregateAttractionRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Show Attraction Inventory
     * Show single attraction based on a channel inventory identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param aggregateAttractionRequestNonAuthenticatedEntity The aggregateAttractionRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showPropertyAttractionWithResponseSpec(AggregateAttractionRequestNonAuthenticatedEntity aggregateAttractionRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return showPropertyAttractionRequestCreation(aggregateAttractionRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion, accept);
    }
    /**
     * Show Property
     * Show property content / availability / rate details.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param hotelInventoryRequestNonAuthenticatedEntity The hotelInventoryRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return HotelInventoryResponseNonAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showPropertyInventoryRequestCreation(HotelInventoryRequestNonAuthenticatedEntity hotelInventoryRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = hotelInventoryRequestNonAuthenticatedEntity;
        // verify the required parameter 'hotelInventoryRequestNonAuthenticatedEntity' is set
        if (hotelInventoryRequestNonAuthenticatedEntity == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelInventoryRequestNonAuthenticatedEntity' when calling showPropertyInventory", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "engineConfigurationIdentifier", engineConfigurationIdentifier));

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<HotelInventoryResponseNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<HotelInventoryResponseNonAuthenticatedEntity>() {};
        return apiClient.invokeAPI("/api/inventory", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Property
     * Show property content / availability / rate details.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param hotelInventoryRequestNonAuthenticatedEntity The hotelInventoryRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return HotelInventoryResponseNonAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<HotelInventoryResponseNonAuthenticatedEntity> showPropertyInventory(HotelInventoryRequestNonAuthenticatedEntity hotelInventoryRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<HotelInventoryResponseNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<HotelInventoryResponseNonAuthenticatedEntity>() {};
        return showPropertyInventoryRequestCreation(hotelInventoryRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Show Property
     * Show property content / availability / rate details.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param hotelInventoryRequestNonAuthenticatedEntity The hotelInventoryRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;HotelInventoryResponseNonAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<HotelInventoryResponseNonAuthenticatedEntity>> showPropertyInventoryWithHttpInfo(HotelInventoryRequestNonAuthenticatedEntity hotelInventoryRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<HotelInventoryResponseNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<HotelInventoryResponseNonAuthenticatedEntity>() {};
        return showPropertyInventoryRequestCreation(hotelInventoryRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Show Property
     * Show property content / availability / rate details.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param hotelInventoryRequestNonAuthenticatedEntity The hotelInventoryRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showPropertyInventoryWithResponseSpec(HotelInventoryRequestNonAuthenticatedEntity hotelInventoryRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        return showPropertyInventoryRequestCreation(hotelInventoryRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion);
    }
    /**
     * Show Property List
     * Show property content / availability / rate details.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param hotelInventoryListRequestNonAuthenticatedEntity The hotelInventoryListRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return HotelInventoryListResponseNonAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showPropertyListRequestCreation(HotelInventoryListRequestNonAuthenticatedEntity hotelInventoryListRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = hotelInventoryListRequestNonAuthenticatedEntity;
        // verify the required parameter 'hotelInventoryListRequestNonAuthenticatedEntity' is set
        if (hotelInventoryListRequestNonAuthenticatedEntity == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelInventoryListRequestNonAuthenticatedEntity' when calling showPropertyList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "engineConfigurationIdentifier", engineConfigurationIdentifier));

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<HotelInventoryListResponseNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<HotelInventoryListResponseNonAuthenticatedEntity>() {};
        return apiClient.invokeAPI("/api/inventory/list", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Property List
     * Show property content / availability / rate details.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param hotelInventoryListRequestNonAuthenticatedEntity The hotelInventoryListRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return HotelInventoryListResponseNonAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<HotelInventoryListResponseNonAuthenticatedEntity> showPropertyList(HotelInventoryListRequestNonAuthenticatedEntity hotelInventoryListRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<HotelInventoryListResponseNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<HotelInventoryListResponseNonAuthenticatedEntity>() {};
        return showPropertyListRequestCreation(hotelInventoryListRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Show Property List
     * Show property content / availability / rate details.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param hotelInventoryListRequestNonAuthenticatedEntity The hotelInventoryListRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;HotelInventoryListResponseNonAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<HotelInventoryListResponseNonAuthenticatedEntity>> showPropertyListWithHttpInfo(HotelInventoryListRequestNonAuthenticatedEntity hotelInventoryListRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<HotelInventoryListResponseNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<HotelInventoryListResponseNonAuthenticatedEntity>() {};
        return showPropertyListRequestCreation(hotelInventoryListRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Show Property List
     * Show property content / availability / rate details.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param hotelInventoryListRequestNonAuthenticatedEntity The hotelInventoryListRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showPropertyListWithResponseSpec(HotelInventoryListRequestNonAuthenticatedEntity hotelInventoryListRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        return showPropertyListRequestCreation(hotelInventoryListRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion);
    }
    /**
     * Show Meeting Room Inventory
     * Show single meeting room based on a channel inventory identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param aggregateMeetingRoomRequestNonAuthenticatedEntity The aggregateMeetingRoomRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return SellerInventoryMeetingRoomNonAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showPropertyMeetingRoomRequestCreation(AggregateMeetingRoomRequestNonAuthenticatedEntity aggregateMeetingRoomRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = aggregateMeetingRoomRequestNonAuthenticatedEntity;
        // verify the required parameter 'aggregateMeetingRoomRequestNonAuthenticatedEntity' is set
        if (aggregateMeetingRoomRequestNonAuthenticatedEntity == null) {
            throw new WebClientResponseException("Missing the required parameter 'aggregateMeetingRoomRequestNonAuthenticatedEntity' when calling showPropertyMeetingRoom", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "engineConfigurationIdentifier", engineConfigurationIdentifier));

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<SellerInventoryMeetingRoomNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<SellerInventoryMeetingRoomNonAuthenticatedEntity>() {};
        return apiClient.invokeAPI("/api/facility/meeting-room", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Meeting Room Inventory
     * Show single meeting room based on a channel inventory identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param aggregateMeetingRoomRequestNonAuthenticatedEntity The aggregateMeetingRoomRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return SellerInventoryMeetingRoomNonAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<SellerInventoryMeetingRoomNonAuthenticatedEntity> showPropertyMeetingRoom(AggregateMeetingRoomRequestNonAuthenticatedEntity aggregateMeetingRoomRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryMeetingRoomNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<SellerInventoryMeetingRoomNonAuthenticatedEntity>() {};
        return showPropertyMeetingRoomRequestCreation(aggregateMeetingRoomRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Show Meeting Room Inventory
     * Show single meeting room based on a channel inventory identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param aggregateMeetingRoomRequestNonAuthenticatedEntity The aggregateMeetingRoomRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;SellerInventoryMeetingRoomNonAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<SellerInventoryMeetingRoomNonAuthenticatedEntity>> showPropertyMeetingRoomWithHttpInfo(AggregateMeetingRoomRequestNonAuthenticatedEntity aggregateMeetingRoomRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryMeetingRoomNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<SellerInventoryMeetingRoomNonAuthenticatedEntity>() {};
        return showPropertyMeetingRoomRequestCreation(aggregateMeetingRoomRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Show Meeting Room Inventory
     * Show single meeting room based on a channel inventory identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param aggregateMeetingRoomRequestNonAuthenticatedEntity The aggregateMeetingRoomRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showPropertyMeetingRoomWithResponseSpec(AggregateMeetingRoomRequestNonAuthenticatedEntity aggregateMeetingRoomRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return showPropertyMeetingRoomRequestCreation(aggregateMeetingRoomRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion, accept);
    }
    /**
     * Show Place Inventory
     * Show single place based on a channel inventory identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param aggregatePlaceRequestNonAuthenticatedEntity The aggregatePlaceRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return SellerInventoryPlaceNonAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showPropertyPlaceRequestCreation(AggregatePlaceRequestNonAuthenticatedEntity aggregatePlaceRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = aggregatePlaceRequestNonAuthenticatedEntity;
        // verify the required parameter 'aggregatePlaceRequestNonAuthenticatedEntity' is set
        if (aggregatePlaceRequestNonAuthenticatedEntity == null) {
            throw new WebClientResponseException("Missing the required parameter 'aggregatePlaceRequestNonAuthenticatedEntity' when calling showPropertyPlace", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "engineConfigurationIdentifier", engineConfigurationIdentifier));

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<SellerInventoryPlaceNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<SellerInventoryPlaceNonAuthenticatedEntity>() {};
        return apiClient.invokeAPI("/api/experience/place", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Place Inventory
     * Show single place based on a channel inventory identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param aggregatePlaceRequestNonAuthenticatedEntity The aggregatePlaceRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return SellerInventoryPlaceNonAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<SellerInventoryPlaceNonAuthenticatedEntity> showPropertyPlace(AggregatePlaceRequestNonAuthenticatedEntity aggregatePlaceRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryPlaceNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<SellerInventoryPlaceNonAuthenticatedEntity>() {};
        return showPropertyPlaceRequestCreation(aggregatePlaceRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Show Place Inventory
     * Show single place based on a channel inventory identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param aggregatePlaceRequestNonAuthenticatedEntity The aggregatePlaceRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;SellerInventoryPlaceNonAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<SellerInventoryPlaceNonAuthenticatedEntity>> showPropertyPlaceWithHttpInfo(AggregatePlaceRequestNonAuthenticatedEntity aggregatePlaceRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryPlaceNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<SellerInventoryPlaceNonAuthenticatedEntity>() {};
        return showPropertyPlaceRequestCreation(aggregatePlaceRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Show Place Inventory
     * Show single place based on a channel inventory identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param aggregatePlaceRequestNonAuthenticatedEntity The aggregatePlaceRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showPropertyPlaceWithResponseSpec(AggregatePlaceRequestNonAuthenticatedEntity aggregatePlaceRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return showPropertyPlaceRequestCreation(aggregatePlaceRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion, accept);
    }
    /**
     * Show Activity Inventory
     * Show single activity based on a channel inventory identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param aggregateActivityRequestNonAuthenticatedEntity The aggregateActivityRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return SellerInventoryActivityNonAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showPropertyRecreationRequestCreation(AggregateActivityRequestNonAuthenticatedEntity aggregateActivityRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = aggregateActivityRequestNonAuthenticatedEntity;
        // verify the required parameter 'aggregateActivityRequestNonAuthenticatedEntity' is set
        if (aggregateActivityRequestNonAuthenticatedEntity == null) {
            throw new WebClientResponseException("Missing the required parameter 'aggregateActivityRequestNonAuthenticatedEntity' when calling showPropertyRecreation", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "engineConfigurationIdentifier", engineConfigurationIdentifier));

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<SellerInventoryActivityNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<SellerInventoryActivityNonAuthenticatedEntity>() {};
        return apiClient.invokeAPI("/api/experience/activity", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Activity Inventory
     * Show single activity based on a channel inventory identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param aggregateActivityRequestNonAuthenticatedEntity The aggregateActivityRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return SellerInventoryActivityNonAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<SellerInventoryActivityNonAuthenticatedEntity> showPropertyRecreation(AggregateActivityRequestNonAuthenticatedEntity aggregateActivityRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryActivityNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<SellerInventoryActivityNonAuthenticatedEntity>() {};
        return showPropertyRecreationRequestCreation(aggregateActivityRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Show Activity Inventory
     * Show single activity based on a channel inventory identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param aggregateActivityRequestNonAuthenticatedEntity The aggregateActivityRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;SellerInventoryActivityNonAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<SellerInventoryActivityNonAuthenticatedEntity>> showPropertyRecreationWithHttpInfo(AggregateActivityRequestNonAuthenticatedEntity aggregateActivityRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryActivityNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<SellerInventoryActivityNonAuthenticatedEntity>() {};
        return showPropertyRecreationRequestCreation(aggregateActivityRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Show Activity Inventory
     * Show single activity based on a channel inventory identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param aggregateActivityRequestNonAuthenticatedEntity The aggregateActivityRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showPropertyRecreationWithResponseSpec(AggregateActivityRequestNonAuthenticatedEntity aggregateActivityRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return showPropertyRecreationRequestCreation(aggregateActivityRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion, accept);
    }
    /**
     * Show Restaurant Inventory
     * Show single restaurant based on a channel inventory identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param aggregateRestaurantRequestNonAuthenticatedEntity The aggregateRestaurantRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return SellerInventoryRestaurantNonAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showPropertyRestaurantRequestCreation(AggregateRestaurantRequestNonAuthenticatedEntity aggregateRestaurantRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = aggregateRestaurantRequestNonAuthenticatedEntity;
        // verify the required parameter 'aggregateRestaurantRequestNonAuthenticatedEntity' is set
        if (aggregateRestaurantRequestNonAuthenticatedEntity == null) {
            throw new WebClientResponseException("Missing the required parameter 'aggregateRestaurantRequestNonAuthenticatedEntity' when calling showPropertyRestaurant", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "engineConfigurationIdentifier", engineConfigurationIdentifier));

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<SellerInventoryRestaurantNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<SellerInventoryRestaurantNonAuthenticatedEntity>() {};
        return apiClient.invokeAPI("/api/facility/restaurant", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Restaurant Inventory
     * Show single restaurant based on a channel inventory identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param aggregateRestaurantRequestNonAuthenticatedEntity The aggregateRestaurantRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return SellerInventoryRestaurantNonAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<SellerInventoryRestaurantNonAuthenticatedEntity> showPropertyRestaurant(AggregateRestaurantRequestNonAuthenticatedEntity aggregateRestaurantRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryRestaurantNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<SellerInventoryRestaurantNonAuthenticatedEntity>() {};
        return showPropertyRestaurantRequestCreation(aggregateRestaurantRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Show Restaurant Inventory
     * Show single restaurant based on a channel inventory identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param aggregateRestaurantRequestNonAuthenticatedEntity The aggregateRestaurantRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;SellerInventoryRestaurantNonAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<SellerInventoryRestaurantNonAuthenticatedEntity>> showPropertyRestaurantWithHttpInfo(AggregateRestaurantRequestNonAuthenticatedEntity aggregateRestaurantRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryRestaurantNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<SellerInventoryRestaurantNonAuthenticatedEntity>() {};
        return showPropertyRestaurantRequestCreation(aggregateRestaurantRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Show Restaurant Inventory
     * Show single restaurant based on a channel inventory identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param aggregateRestaurantRequestNonAuthenticatedEntity The aggregateRestaurantRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showPropertyRestaurantWithResponseSpec(AggregateRestaurantRequestNonAuthenticatedEntity aggregateRestaurantRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return showPropertyRestaurantRequestCreation(aggregateRestaurantRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion, accept);
    }
    /**
     * Show Guest Room Inventory
     * Show single guest room based on a channel inventory identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param aggregateGuestRoomRequestNonAuthenticatedEntity The aggregateGuestRoomRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return SellerInventoryGuestRoomNonAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showPropertyRoomTypeRequestCreation(AggregateGuestRoomRequestNonAuthenticatedEntity aggregateGuestRoomRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = aggregateGuestRoomRequestNonAuthenticatedEntity;
        // verify the required parameter 'aggregateGuestRoomRequestNonAuthenticatedEntity' is set
        if (aggregateGuestRoomRequestNonAuthenticatedEntity == null) {
            throw new WebClientResponseException("Missing the required parameter 'aggregateGuestRoomRequestNonAuthenticatedEntity' when calling showPropertyRoomType", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "engineConfigurationIdentifier", engineConfigurationIdentifier));

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<SellerInventoryGuestRoomNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<SellerInventoryGuestRoomNonAuthenticatedEntity>() {};
        return apiClient.invokeAPI("/api/inventory/guest-room", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Guest Room Inventory
     * Show single guest room based on a channel inventory identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param aggregateGuestRoomRequestNonAuthenticatedEntity The aggregateGuestRoomRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return SellerInventoryGuestRoomNonAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<SellerInventoryGuestRoomNonAuthenticatedEntity> showPropertyRoomType(AggregateGuestRoomRequestNonAuthenticatedEntity aggregateGuestRoomRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryGuestRoomNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<SellerInventoryGuestRoomNonAuthenticatedEntity>() {};
        return showPropertyRoomTypeRequestCreation(aggregateGuestRoomRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Show Guest Room Inventory
     * Show single guest room based on a channel inventory identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param aggregateGuestRoomRequestNonAuthenticatedEntity The aggregateGuestRoomRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;SellerInventoryGuestRoomNonAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<SellerInventoryGuestRoomNonAuthenticatedEntity>> showPropertyRoomTypeWithHttpInfo(AggregateGuestRoomRequestNonAuthenticatedEntity aggregateGuestRoomRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryGuestRoomNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<SellerInventoryGuestRoomNonAuthenticatedEntity>() {};
        return showPropertyRoomTypeRequestCreation(aggregateGuestRoomRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Show Guest Room Inventory
     * Show single guest room based on a channel inventory identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param aggregateGuestRoomRequestNonAuthenticatedEntity The aggregateGuestRoomRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showPropertyRoomTypeWithResponseSpec(AggregateGuestRoomRequestNonAuthenticatedEntity aggregateGuestRoomRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return showPropertyRoomTypeRequestCreation(aggregateGuestRoomRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion, accept);
    }
    /**
     * Show Spa Inventory
     * Show single spa based on a channel inventory identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param aggregateSpaRequestNonAuthenticatedEntity The aggregateSpaRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return SellerInventorySpaNonAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showPropertySpaRequestCreation(AggregateSpaRequestNonAuthenticatedEntity aggregateSpaRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = aggregateSpaRequestNonAuthenticatedEntity;
        // verify the required parameter 'aggregateSpaRequestNonAuthenticatedEntity' is set
        if (aggregateSpaRequestNonAuthenticatedEntity == null) {
            throw new WebClientResponseException("Missing the required parameter 'aggregateSpaRequestNonAuthenticatedEntity' when calling showPropertySpa", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "engineConfigurationIdentifier", engineConfigurationIdentifier));

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<SellerInventorySpaNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<SellerInventorySpaNonAuthenticatedEntity>() {};
        return apiClient.invokeAPI("/api/facility/spa", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Spa Inventory
     * Show single spa based on a channel inventory identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param aggregateSpaRequestNonAuthenticatedEntity The aggregateSpaRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return SellerInventorySpaNonAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<SellerInventorySpaNonAuthenticatedEntity> showPropertySpa(AggregateSpaRequestNonAuthenticatedEntity aggregateSpaRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventorySpaNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<SellerInventorySpaNonAuthenticatedEntity>() {};
        return showPropertySpaRequestCreation(aggregateSpaRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Show Spa Inventory
     * Show single spa based on a channel inventory identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param aggregateSpaRequestNonAuthenticatedEntity The aggregateSpaRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;SellerInventorySpaNonAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<SellerInventorySpaNonAuthenticatedEntity>> showPropertySpaWithHttpInfo(AggregateSpaRequestNonAuthenticatedEntity aggregateSpaRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventorySpaNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<SellerInventorySpaNonAuthenticatedEntity>() {};
        return showPropertySpaRequestCreation(aggregateSpaRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Show Spa Inventory
     * Show single spa based on a channel inventory identifier
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param aggregateSpaRequestNonAuthenticatedEntity The aggregateSpaRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showPropertySpaWithResponseSpec(AggregateSpaRequestNonAuthenticatedEntity aggregateSpaRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return showPropertySpaRequestCreation(aggregateSpaRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion, accept);
    }
    /**
     * Search Inventory
     * Shows page of blocking items
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param aggregateSellerInventoryListRequestNonAuthenticatedEntity The aggregateSellerInventoryListRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return SellerInventoryListResponseNonAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showSellerInventoryListRequestCreation(AggregateSellerInventoryListRequestNonAuthenticatedEntity aggregateSellerInventoryListRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = aggregateSellerInventoryListRequestNonAuthenticatedEntity;
        // verify the required parameter 'aggregateSellerInventoryListRequestNonAuthenticatedEntity' is set
        if (aggregateSellerInventoryListRequestNonAuthenticatedEntity == null) {
            throw new WebClientResponseException("Missing the required parameter 'aggregateSellerInventoryListRequestNonAuthenticatedEntity' when calling showSellerInventoryList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "engineConfigurationIdentifier", engineConfigurationIdentifier));

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<SellerInventoryListResponseNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<SellerInventoryListResponseNonAuthenticatedEntity>() {};
        return apiClient.invokeAPI("/api/inventory/grid", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Search Inventory
     * Shows page of blocking items
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param aggregateSellerInventoryListRequestNonAuthenticatedEntity The aggregateSellerInventoryListRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return SellerInventoryListResponseNonAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<SellerInventoryListResponseNonAuthenticatedEntity> showSellerInventoryList(AggregateSellerInventoryListRequestNonAuthenticatedEntity aggregateSellerInventoryListRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryListResponseNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<SellerInventoryListResponseNonAuthenticatedEntity>() {};
        return showSellerInventoryListRequestCreation(aggregateSellerInventoryListRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Search Inventory
     * Shows page of blocking items
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param aggregateSellerInventoryListRequestNonAuthenticatedEntity The aggregateSellerInventoryListRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;SellerInventoryListResponseNonAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<SellerInventoryListResponseNonAuthenticatedEntity>> showSellerInventoryListWithHttpInfo(AggregateSellerInventoryListRequestNonAuthenticatedEntity aggregateSellerInventoryListRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryListResponseNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<SellerInventoryListResponseNonAuthenticatedEntity>() {};
        return showSellerInventoryListRequestCreation(aggregateSellerInventoryListRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Search Inventory
     * Shows page of blocking items
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param aggregateSellerInventoryListRequestNonAuthenticatedEntity The aggregateSellerInventoryListRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showSellerInventoryListWithResponseSpec(AggregateSellerInventoryListRequestNonAuthenticatedEntity aggregateSellerInventoryListRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return showSellerInventoryListRequestCreation(aggregateSellerInventoryListRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion, accept);
    }
    /**
     * Show Ranked Inventories
     * Shows a paginated list of ranked blocking.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param aggregateSellerInventoryListRequestNonAuthenticatedEntity The aggregateSellerInventoryListRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return SellerInventoryRankedListResponseNonAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showSellerInventoryRankedListRequestCreation(AggregateSellerInventoryListRequestNonAuthenticatedEntity aggregateSellerInventoryListRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = aggregateSellerInventoryListRequestNonAuthenticatedEntity;
        // verify the required parameter 'aggregateSellerInventoryListRequestNonAuthenticatedEntity' is set
        if (aggregateSellerInventoryListRequestNonAuthenticatedEntity == null) {
            throw new WebClientResponseException("Missing the required parameter 'aggregateSellerInventoryListRequestNonAuthenticatedEntity' when calling showSellerInventoryRankedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "engineConfigurationIdentifier", engineConfigurationIdentifier));

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<SellerInventoryRankedListResponseNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<SellerInventoryRankedListResponseNonAuthenticatedEntity>() {};
        return apiClient.invokeAPI("/api/inventory/ranked/grid", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Ranked Inventories
     * Shows a paginated list of ranked blocking.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param aggregateSellerInventoryListRequestNonAuthenticatedEntity The aggregateSellerInventoryListRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return SellerInventoryRankedListResponseNonAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<SellerInventoryRankedListResponseNonAuthenticatedEntity> showSellerInventoryRankedList(AggregateSellerInventoryListRequestNonAuthenticatedEntity aggregateSellerInventoryListRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryRankedListResponseNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<SellerInventoryRankedListResponseNonAuthenticatedEntity>() {};
        return showSellerInventoryRankedListRequestCreation(aggregateSellerInventoryListRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Show Ranked Inventories
     * Shows a paginated list of ranked blocking.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param aggregateSellerInventoryListRequestNonAuthenticatedEntity The aggregateSellerInventoryListRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;SellerInventoryRankedListResponseNonAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<SellerInventoryRankedListResponseNonAuthenticatedEntity>> showSellerInventoryRankedListWithHttpInfo(AggregateSellerInventoryListRequestNonAuthenticatedEntity aggregateSellerInventoryListRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryRankedListResponseNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<SellerInventoryRankedListResponseNonAuthenticatedEntity>() {};
        return showSellerInventoryRankedListRequestCreation(aggregateSellerInventoryListRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Show Ranked Inventories
     * Shows a paginated list of ranked blocking.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param aggregateSellerInventoryListRequestNonAuthenticatedEntity The aggregateSellerInventoryListRequestNonAuthenticatedEntity parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showSellerInventoryRankedListWithResponseSpec(AggregateSellerInventoryListRequestNonAuthenticatedEntity aggregateSellerInventoryListRequestNonAuthenticatedEntity, String engineConfigurationIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return showSellerInventoryRankedListRequestCreation(aggregateSellerInventoryListRequestNonAuthenticatedEntity, engineConfigurationIdentifier, winkVersion, accept);
    }
}
