/*
 * Wink API
 *  # Introduction  Welcome to the Wink API - A programmer-friendly way to manage, sell and book travel inventory on the Wink platform. The API gives you all the tools you need to ready your properties and inventory for sale across 1000s of our native sales channels.  Integrators, affiliates, travel agents and content creators have the ability search for your travel inventory and promote / sell it in a wide variety of ways.   # Integrations  We have already integrated with the most well-known channel managers so you don't have to. To see our current integrations, please go to https://extranet.wink.travel and scroll to Connectivity section. Once your properties are set up, you can finish the setup by mapping your property to Wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API.   # Intended Audience  Programmers are [most likely] a requirement to start integrating with Wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible.  - Hotel chains  - Hotel brands  - Travel tech companies  - Destination sites  - Integrators  - Aggregators  - Destination management companies  - Travel agencies  - OTAs   ## APIs  Not every integrator needs every API. For that reason, we have separated APIs into context.  ### Test API   - [Ping](/ping): The Ping API is a quick test endpoint to verify that your credentials work Wink.  ### Common APIs  - [Notifications](/notifications): The Notifications API is a way for us to stay in touch with your user, property or affiliate account. - [User Settings](/user-settings): The User Settings API exposes endpoints to allow 3rd party integrators to communicate with Wink.  ### Consume APIs Consume endpoints are for developers who want to find existing travel inventory and either book it or use it to advertise through one of their Wink affiliate accounts.   - [Configuration](/engine-client): A single endpoint to retrieve whitelabel + customization information for the booking engine.  - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags.  - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API..  - [Booking](/booking): All APIs related to creating bookings on the platform.  - [Travel Agent](/travel-agent): The Travel Agent API exposes endpoints to manage agent-facilitated bookings.   ### Produce APIs  Produce endpoints are for developers who want to create and manage travel inventory.   #### Property  - [Property registration](/extranet/property/register): As a producer, this is, oftentimes, where you start your journey. These endpoints let you create properties on Wink.  - [Property](/extranet/property): This collection of property endpoints are mostly management endpoints that let you display, change status and similar for your existing properties.  - [Facilities](/extranet/facilities): This collection of endpoints let you manage facilities; such as room types.  - [Experiences](/extranet/experiences): This collection of endpoints let you manage experiences, such as activities.  - [Monetize](/extranet/monetize): The Monetize API exposes endpoints for managing cancellation polies, rate plans, promotions and more on Wink.  - [Distribution](/extranet/distribution): The Distribution API exposes endpoints for sales channels, connecting with affiliates, managing rates and inventory calendars and more on Wink.  - [Property Booking](/extranet/booking): The Property Booking API exposes endpoints for managing bookings and reviews at the property-level.   #### Affiliate  - [Affiliate](/affiliate): This collection of affiliate endpoints are mostly management endpoints that let you display, change status and similar for your existing accounts.  - [Browse](/affiliate/browse): The Browse API exposes endpoints for affiliates to find suppliers and inventory to sell.  - [Inventory](/affiliate/inventory): The Inventory API exposes endpoints for affiliates to manage the inventory they want to sell and how they want to sell it.  - [Sales Channel](/affiliate/sales-channel): The Sales Channel API exposes endpoints for affiliates to manage existing sales channels as well as find new ones.  - [WinkLinks](/affiliate/winklinks): The WinkLinks API exposes endpoints for affiliates to manage their WinkLinks page.   #### Rate provider  - [Channel manager](/channel-manager): The Channel Manager API enables external channel manager partners to map, exchange rate / availability information with us as well as be informed of bookings that occur on the Wink platform for one of their properties.   ### Taxonomy APIs  Taxonomy endpoints are for developers who want to consume and produce travel inventory and need taxonomies of standard and non-standard codes for inventory types, classes, statuses etc.   - [Reference](/reactive): All APIs related to retrieving platform-supported taxonomies.   ### Insight APIs  Insight endpoints do exactly what the name implies - They offer platform-level insight into the activities of producers and consumers.   - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics.   ### Payment APIs  Payment endpoints are for developers who want to purchase travel inventory. This can be done via the API as a registered Travel Agent or using our API in conjunction with our PCI compliant reactive widget for all other entities.   - [TripPay](/reactive): All APIs related to TripPay account management, booking, mapping and integration features.   ## SDKs  We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).   - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)   ## Usage  These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.   ## Versioning  We chose to version our endpoints in a way that we hope affects your integration minimally. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.   ## Release history  - Follow updates on Github: https://github.com/wink-travel/wink-sdk-java/blob/master/CHANGELOG.md    # Inventory API The Inventory API exposes endpoints to retrieve inventory you already know about. This API lets you:  1. Consume shareable links. 2. Load up a known property with availability. 3. Load up all inventories that were created by our affiliates such as grids, maps, and individual items.  Browse the endpoints in the left navigation bar to get started.  
 *
 * The version of the OpenAPI document: 30.14.5
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.inventory.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import travel.wink.sdk.inventory.model.GuestRoomLightweightNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.HotelOnMapLightweightNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.QuoteNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.RoomTypeBestPriceNonAuthenticatedEntity;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Populated only when the type of grid item is &#x60;GUEST_ROOM&#x60;
 */
@JsonPropertyOrder({
  HotelWithBestPriceNonAuthenticatedEntity.JSON_PROPERTY_HOTEL,
  HotelWithBestPriceNonAuthenticatedEntity.JSON_PROPERTY_LOWEST_PRICE,
  HotelWithBestPriceNonAuthenticatedEntity.JSON_PROPERTY_ROOM_TYPE_LIST,
  HotelWithBestPriceNonAuthenticatedEntity.JSON_PROPERTY_PRICE_LIST,
  HotelWithBestPriceNonAuthenticatedEntity.JSON_PROPERTY_POTENTIAL_CHANNEL_DISCOUNT_PERCENT,
  HotelWithBestPriceNonAuthenticatedEntity.JSON_PROPERTY_SOURCE_TO_USER_CURRENCY_QUOTE,
  HotelWithBestPriceNonAuthenticatedEntity.JSON_PROPERTY_SOURCE_TO_INTERNAL_CURRENCY_QUOTE,
  HotelWithBestPriceNonAuthenticatedEntity.JSON_PROPERTY_AVAILABLE
})
@JsonTypeName("HotelWithBestPrice_Non_Authenticated_Entity")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-03-04T20:49:48.547246839+07:00[Asia/Bangkok]")
public class HotelWithBestPriceNonAuthenticatedEntity {
  public static final String JSON_PROPERTY_HOTEL = "hotel";
  private HotelOnMapLightweightNonAuthenticatedEntity hotel;

  public static final String JSON_PROPERTY_LOWEST_PRICE = "lowestPrice";
  private RoomTypeBestPriceNonAuthenticatedEntity lowestPrice;

  public static final String JSON_PROPERTY_ROOM_TYPE_LIST = "roomTypeList";
  private List<GuestRoomLightweightNonAuthenticatedEntity> roomTypeList = new ArrayList<>();

  public static final String JSON_PROPERTY_PRICE_LIST = "priceList";
  private List<RoomTypeBestPriceNonAuthenticatedEntity> priceList = new ArrayList<>();

  public static final String JSON_PROPERTY_POTENTIAL_CHANNEL_DISCOUNT_PERCENT = "potentialChannelDiscountPercent";
  private Float potentialChannelDiscountPercent;

  public static final String JSON_PROPERTY_SOURCE_TO_USER_CURRENCY_QUOTE = "sourceToUserCurrencyQuote";
  private QuoteNonAuthenticatedEntity sourceToUserCurrencyQuote;

  public static final String JSON_PROPERTY_SOURCE_TO_INTERNAL_CURRENCY_QUOTE = "sourceToInternalCurrencyQuote";
  private QuoteNonAuthenticatedEntity sourceToInternalCurrencyQuote;

  public static final String JSON_PROPERTY_AVAILABLE = "available";
  private Boolean available;

  public HotelWithBestPriceNonAuthenticatedEntity() {
  }

  public HotelWithBestPriceNonAuthenticatedEntity hotel(HotelOnMapLightweightNonAuthenticatedEntity hotel) {
    
    this.hotel = hotel;
    return this;
  }

   /**
   * Get hotel
   * @return hotel
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_HOTEL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public HotelOnMapLightweightNonAuthenticatedEntity getHotel() {
    return hotel;
  }


  @JsonProperty(JSON_PROPERTY_HOTEL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setHotel(HotelOnMapLightweightNonAuthenticatedEntity hotel) {
    this.hotel = hotel;
  }


  public HotelWithBestPriceNonAuthenticatedEntity lowestPrice(RoomTypeBestPriceNonAuthenticatedEntity lowestPrice) {
    
    this.lowestPrice = lowestPrice;
    return this;
  }

   /**
   * Get lowestPrice
   * @return lowestPrice
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_LOWEST_PRICE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public RoomTypeBestPriceNonAuthenticatedEntity getLowestPrice() {
    return lowestPrice;
  }


  @JsonProperty(JSON_PROPERTY_LOWEST_PRICE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setLowestPrice(RoomTypeBestPriceNonAuthenticatedEntity lowestPrice) {
    this.lowestPrice = lowestPrice;
  }


  public HotelWithBestPriceNonAuthenticatedEntity roomTypeList(List<GuestRoomLightweightNonAuthenticatedEntity> roomTypeList) {
    
    this.roomTypeList = roomTypeList;
    return this;
  }

  public HotelWithBestPriceNonAuthenticatedEntity addRoomTypeListItem(GuestRoomLightweightNonAuthenticatedEntity roomTypeListItem) {
    if (this.roomTypeList == null) {
      this.roomTypeList = new ArrayList<>();
    }
    this.roomTypeList.add(roomTypeListItem);
    return this;
  }

   /**
   * Unique property room types
   * @return roomTypeList
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_ROOM_TYPE_LIST)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<GuestRoomLightweightNonAuthenticatedEntity> getRoomTypeList() {
    return roomTypeList;
  }


  @JsonProperty(JSON_PROPERTY_ROOM_TYPE_LIST)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRoomTypeList(List<GuestRoomLightweightNonAuthenticatedEntity> roomTypeList) {
    this.roomTypeList = roomTypeList;
  }


  public HotelWithBestPriceNonAuthenticatedEntity priceList(List<RoomTypeBestPriceNonAuthenticatedEntity> priceList) {
    
    this.priceList = priceList;
    return this;
  }

  public HotelWithBestPriceNonAuthenticatedEntity addPriceListItem(RoomTypeBestPriceNonAuthenticatedEntity priceListItem) {
    if (this.priceList == null) {
      this.priceList = new ArrayList<>();
    }
    this.priceList.add(priceListItem);
    return this;
  }

   /**
   * Best-priced room types
   * @return priceList
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_PRICE_LIST)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<RoomTypeBestPriceNonAuthenticatedEntity> getPriceList() {
    return priceList;
  }


  @JsonProperty(JSON_PROPERTY_PRICE_LIST)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPriceList(List<RoomTypeBestPriceNonAuthenticatedEntity> priceList) {
    this.priceList = priceList;
  }


  public HotelWithBestPriceNonAuthenticatedEntity potentialChannelDiscountPercent(Float potentialChannelDiscountPercent) {
    
    this.potentialChannelDiscountPercent = potentialChannelDiscountPercent;
    return this;
  }

   /**
   * The potential discount the user is entitled to if user is a member / authenticated.
   * @return potentialChannelDiscountPercent
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_POTENTIAL_CHANNEL_DISCOUNT_PERCENT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Float getPotentialChannelDiscountPercent() {
    return potentialChannelDiscountPercent;
  }


  @JsonProperty(JSON_PROPERTY_POTENTIAL_CHANNEL_DISCOUNT_PERCENT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPotentialChannelDiscountPercent(Float potentialChannelDiscountPercent) {
    this.potentialChannelDiscountPercent = potentialChannelDiscountPercent;
  }


  public HotelWithBestPriceNonAuthenticatedEntity sourceToUserCurrencyQuote(QuoteNonAuthenticatedEntity sourceToUserCurrencyQuote) {
    
    this.sourceToUserCurrencyQuote = sourceToUserCurrencyQuote;
    return this;
  }

   /**
   * Get sourceToUserCurrencyQuote
   * @return sourceToUserCurrencyQuote
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_SOURCE_TO_USER_CURRENCY_QUOTE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public QuoteNonAuthenticatedEntity getSourceToUserCurrencyQuote() {
    return sourceToUserCurrencyQuote;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_TO_USER_CURRENCY_QUOTE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSourceToUserCurrencyQuote(QuoteNonAuthenticatedEntity sourceToUserCurrencyQuote) {
    this.sourceToUserCurrencyQuote = sourceToUserCurrencyQuote;
  }


  public HotelWithBestPriceNonAuthenticatedEntity sourceToInternalCurrencyQuote(QuoteNonAuthenticatedEntity sourceToInternalCurrencyQuote) {
    
    this.sourceToInternalCurrencyQuote = sourceToInternalCurrencyQuote;
    return this;
  }

   /**
   * Get sourceToInternalCurrencyQuote
   * @return sourceToInternalCurrencyQuote
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_SOURCE_TO_INTERNAL_CURRENCY_QUOTE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public QuoteNonAuthenticatedEntity getSourceToInternalCurrencyQuote() {
    return sourceToInternalCurrencyQuote;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_TO_INTERNAL_CURRENCY_QUOTE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSourceToInternalCurrencyQuote(QuoteNonAuthenticatedEntity sourceToInternalCurrencyQuote) {
    this.sourceToInternalCurrencyQuote = sourceToInternalCurrencyQuote;
  }


  public HotelWithBestPriceNonAuthenticatedEntity available(Boolean available) {
    
    this.available = available;
    return this;
  }

   /**
   * Flag to indicate whether this blocking is available or not. This data point is identifier to the available flag on the &#x60;price&#x60; child data point.
   * @return available
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_AVAILABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getAvailable() {
    return available;
  }


  @JsonProperty(JSON_PROPERTY_AVAILABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAvailable(Boolean available) {
    this.available = available;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    HotelWithBestPriceNonAuthenticatedEntity hotelWithBestPriceNonAuthenticatedEntity = (HotelWithBestPriceNonAuthenticatedEntity) o;
    return Objects.equals(this.hotel, hotelWithBestPriceNonAuthenticatedEntity.hotel) &&
        Objects.equals(this.lowestPrice, hotelWithBestPriceNonAuthenticatedEntity.lowestPrice) &&
        Objects.equals(this.roomTypeList, hotelWithBestPriceNonAuthenticatedEntity.roomTypeList) &&
        Objects.equals(this.priceList, hotelWithBestPriceNonAuthenticatedEntity.priceList) &&
        Objects.equals(this.potentialChannelDiscountPercent, hotelWithBestPriceNonAuthenticatedEntity.potentialChannelDiscountPercent) &&
        Objects.equals(this.sourceToUserCurrencyQuote, hotelWithBestPriceNonAuthenticatedEntity.sourceToUserCurrencyQuote) &&
        Objects.equals(this.sourceToInternalCurrencyQuote, hotelWithBestPriceNonAuthenticatedEntity.sourceToInternalCurrencyQuote) &&
        Objects.equals(this.available, hotelWithBestPriceNonAuthenticatedEntity.available);
  }

  @Override
  public int hashCode() {
    return Objects.hash(hotel, lowestPrice, roomTypeList, priceList, potentialChannelDiscountPercent, sourceToUserCurrencyQuote, sourceToInternalCurrencyQuote, available);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class HotelWithBestPriceNonAuthenticatedEntity {\n");
    sb.append("    hotel: ").append(toIndentedString(hotel)).append("\n");
    sb.append("    lowestPrice: ").append(toIndentedString(lowestPrice)).append("\n");
    sb.append("    roomTypeList: ").append(toIndentedString(roomTypeList)).append("\n");
    sb.append("    priceList: ").append(toIndentedString(priceList)).append("\n");
    sb.append("    potentialChannelDiscountPercent: ").append(toIndentedString(potentialChannelDiscountPercent)).append("\n");
    sb.append("    sourceToUserCurrencyQuote: ").append(toIndentedString(sourceToUserCurrencyQuote)).append("\n");
    sb.append("    sourceToInternalCurrencyQuote: ").append(toIndentedString(sourceToInternalCurrencyQuote)).append("\n");
    sb.append("    available: ").append(toIndentedString(available)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

