/*
 * Wink API
 *  # Introduction  Welcome to the Wink API - A programmer-friendly way to manage, sell and book travel inventory on the Wink platform. The API gives you all the tools you need to ready your properties and inventory for sale across 1000s of our native sales channels.  Integrators, affiliates, travel agents and content creators have the ability search for your travel inventory and promote / sell it in a wide variety of ways.   # Integrations  We have already integrated with the most well-known channel managers so you don't have to. To see our current integrations, please go to https://extranet.wink.travel and scroll to Connectivity section. Once your properties are set up, you can finish the setup by mapping your property to Wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API.   # Intended Audience  Programmers are [most likely] a requirement to start integrating with Wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible.  - Hotel chains  - Hotel brands  - Travel tech companies  - Destination sites  - Integrators  - Aggregators  - Destination management companies  - Travel agencies  - OTAs   ## APIs  Not every integrator needs every API. For that reason, we have separated APIs into context.  ### Test API   - [Ping](/ping): The Ping API is a quick test endpoint to verify that your credentials work Wink.  ### Common APIs  - [Notifications](/notifications): The Notifications API is a way for us to stay in touch with your user, property or affiliate account. - [User Settings](/user-settings): The User Settings API exposes endpoints to allow 3rd party integrators to communicate with Wink.  ### Consume APIs Consume endpoints are for developers who want to find existing travel inventory and either book it or use it to advertise through one of their Wink affiliate accounts.   - [Configuration](/engine-client): A single endpoint to retrieve whitelabel + customization information for the booking engine.  - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags.  - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API..  - [Booking](/booking): All APIs related to creating bookings on the platform.  - [Travel Agent](/travel-agent): The Travel Agent API exposes endpoints to manage agent-facilitated bookings.   ### Produce APIs  Produce endpoints are for developers who want to create and manage travel inventory.   #### Property  - [Property registration](/extranet/property/register): As a producer, this is, oftentimes, where you start your journey. These endpoints let you create properties on Wink.  - [Property](/extranet/property): This collection of property endpoints are mostly management endpoints that let you display, change status and similar for your existing properties.  - [Facilities](/extranet/facilities): This collection of endpoints let you manage facilities; such as room types.  - [Experiences](/extranet/experiences): This collection of endpoints let you manage experiences, such as activities.  - [Monetize](/extranet/monetize): The Monetize API exposes endpoints for managing cancellation polies, rate plans, promotions and more on Wink.  - [Distribution](/extranet/distribution): The Distribution API exposes endpoints for sales channels, connecting with affiliates, managing rates and inventory calendars and more on Wink.  - [Property Booking](/extranet/booking): The Property Booking API exposes endpoints for managing bookings and reviews at the property-level.   #### Affiliate  - [Affiliate](/affiliate): This collection of affiliate endpoints are mostly management endpoints that let you display, change status and similar for your existing accounts.  - [Browse](/affiliate/browse): The Browse API exposes endpoints for affiliates to find suppliers and inventory to sell.  - [Inventory](/affiliate/inventory): The Inventory API exposes endpoints for affiliates to manage the inventory they want to sell and how they want to sell it.  - [Sales Channel](/affiliate/sales-channel): The Sales Channel API exposes endpoints for affiliates to manage existing sales channels as well as find new ones.  - [WinkLinks](/affiliate/winklinks): The WinkLinks API exposes endpoints for affiliates to manage their WinkLinks page.   #### Rate provider  - [Channel manager](/channel-manager): The Channel Manager API enables external channel manager partners to map, exchange rate / availability information with us as well as be informed of bookings that occur on the Wink platform for one of their properties.   ### Taxonomy APIs  Taxonomy endpoints are for developers who want to consume and produce travel inventory and need taxonomies of standard and non-standard codes for inventory types, classes, statuses etc.   - [Reference](/reactive): All APIs related to retrieving platform-supported taxonomies.   ### Insight APIs  Insight endpoints do exactly what the name implies - They offer platform-level insight into the activities of producers and consumers.   - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics.   ### Payment APIs  Payment endpoints are for developers who want to purchase travel inventory. This can be done via the API as a registered Travel Agent or using our API in conjunction with our PCI compliant reactive widget for all other entities.   - [TripPay](/reactive): All APIs related to TripPay account management, booking, mapping and integration features.   ## SDKs  We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).   - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)   ## Usage  These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.   ## Versioning  We chose to version our endpoints in a way that we hope affects your integration minimally. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.   ## Release history  - Follow updates on Github: https://github.com/wink-travel/wink-sdk-java/blob/master/CHANGELOG.md    # Inventory API The Inventory API exposes endpoints to retrieve inventory you already know about. This API lets you:  1. Consume shareable links. 2. Load up a known property with availability. 3. Load up all inventories that were created by our affiliates such as grids, maps, and individual items.  Browse the endpoints in the left navigation bar to get started.  
 *
 * The version of the OpenAPI document: 30.14.5
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.inventory.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import travel.wink.sdk.inventory.model.ContactNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.DowPatternGroupNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.GeoJsonPointNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.SimpleAddressNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.SimpleDescriptionNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.SimpleMultimediaNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.SocialNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.TravelInventoryRecognitionNonAuthenticatedEntity;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Inventory data object
 */
@JsonPropertyOrder({
  MeetingRoomLightweightNonAuthenticatedEntity.JSON_PROPERTY_IDENTIFIER,
  MeetingRoomLightweightNonAuthenticatedEntity.JSON_PROPERTY_HOTEL_IDENTIFIER,
  MeetingRoomLightweightNonAuthenticatedEntity.JSON_PROPERTY_FEATURED_IND,
  MeetingRoomLightweightNonAuthenticatedEntity.JSON_PROPERTY_LIFESTYLE_TYPE,
  MeetingRoomLightweightNonAuthenticatedEntity.JSON_PROPERTY_LOCATION,
  MeetingRoomLightweightNonAuthenticatedEntity.JSON_PROPERTY_DESCRIPTIONS,
  MeetingRoomLightweightNonAuthenticatedEntity.JSON_PROPERTY_MULTIMEDIAS,
  MeetingRoomLightweightNonAuthenticatedEntity.JSON_PROPERTY_CONTACT,
  MeetingRoomLightweightNonAuthenticatedEntity.JSON_PROPERTY_ADDRESS,
  MeetingRoomLightweightNonAuthenticatedEntity.JSON_PROPERTY_COMMISSIONABLE,
  MeetingRoomLightweightNonAuthenticatedEntity.JSON_PROPERTY_NAME,
  MeetingRoomLightweightNonAuthenticatedEntity.JSON_PROPERTY_PROXIMITY_CODE,
  MeetingRoomLightweightNonAuthenticatedEntity.JSON_PROPERTY_SORT,
  MeetingRoomLightweightNonAuthenticatedEntity.JSON_PROPERTY_MIN_AGE_APPROPRIATE_CODE,
  MeetingRoomLightweightNonAuthenticatedEntity.JSON_PROPERTY_BOOKABLE,
  MeetingRoomLightweightNonAuthenticatedEntity.JSON_PROPERTY_ACTIVE,
  MeetingRoomLightweightNonAuthenticatedEntity.JSON_PROPERTY_DISABILITY_FEATURES,
  MeetingRoomLightweightNonAuthenticatedEntity.JSON_PROPERTY_SECURITY_FEATURES,
  MeetingRoomLightweightNonAuthenticatedEntity.JSON_PROPERTY_SOCIALS,
  MeetingRoomLightweightNonAuthenticatedEntity.JSON_PROPERTY_PRICE_POINT,
  MeetingRoomLightweightNonAuthenticatedEntity.JSON_PROPERTY_RECOGNITION_LIST,
  MeetingRoomLightweightNonAuthenticatedEntity.JSON_PROPERTY_APPLICABLE_START,
  MeetingRoomLightweightNonAuthenticatedEntity.JSON_PROPERTY_APPLICABLE_END,
  MeetingRoomLightweightNonAuthenticatedEntity.JSON_PROPERTY_RESERVATION_REQUIRED_IND,
  MeetingRoomLightweightNonAuthenticatedEntity.JSON_PROPERTY_OPENS,
  MeetingRoomLightweightNonAuthenticatedEntity.JSON_PROPERTY_CLOSES,
  MeetingRoomLightweightNonAuthenticatedEntity.JSON_PROPERTY_DAYS_OF_WEEK,
  MeetingRoomLightweightNonAuthenticatedEntity.JSON_PROPERTY_IRREGULAR,
  MeetingRoomLightweightNonAuthenticatedEntity.JSON_PROPERTY_MEETING_ROOM_CAPACITY,
  MeetingRoomLightweightNonAuthenticatedEntity.JSON_PROPERTY_ACCESS,
  MeetingRoomLightweightNonAuthenticatedEntity.JSON_PROPERTY_MEETING_ROOM_TYPE_CODE,
  MeetingRoomLightweightNonAuthenticatedEntity.JSON_PROPERTY_MEETING_ROOM_LEVEL,
  MeetingRoomLightweightNonAuthenticatedEntity.JSON_PROPERTY_DEDICATED_IND,
  MeetingRoomLightweightNonAuthenticatedEntity.JSON_PROPERTY_AREA,
  MeetingRoomLightweightNonAuthenticatedEntity.JSON_PROPERTY_HEIGHT,
  MeetingRoomLightweightNonAuthenticatedEntity.JSON_PROPERTY_WIDTH,
  MeetingRoomLightweightNonAuthenticatedEntity.JSON_PROPERTY_LENGTH,
  MeetingRoomLightweightNonAuthenticatedEntity.JSON_PROPERTY_AMENITIES
})
@JsonTypeName("MeetingRoomLightweight_Non_Authenticated_Entity")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-03-04T20:49:48.547246839+07:00[Asia/Bangkok]")
public class MeetingRoomLightweightNonAuthenticatedEntity {
  public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
  private UUID identifier;

  public static final String JSON_PROPERTY_HOTEL_IDENTIFIER = "hotelIdentifier";
  private UUID hotelIdentifier;

  public static final String JSON_PROPERTY_FEATURED_IND = "featuredInd";
  private Boolean featuredInd;

  /**
   * Indicate the type of lifestyle this blocking should be associated with.
   */
  public enum LifestyleTypeEnum {
    HEALTH_FITNESS("LIFESTYLE_HEALTH_FITNESS"),
    
    RELAX("LIFESTYLE_RELAX"),
    
    ADULT_ONLY("LIFESTYLE_ADULT_ONLY"),
    
    ADVENTURE("LIFESTYLE_ADVENTURE"),
    
    BUSINESS("LIFESTYLE_BUSINESS"),
    
    LGBT("LIFESTYLE_LGBT"),
    
    SINGLE_PARENT("LIFESTYLE_SINGLE_PARENT"),
    
    SOLO_FEMALE("LIFESTYLE_SOLO_FEMALE"),
    
    BEAUTY("LIFESTYLE_BEAUTY"),
    
    FOODIE("LIFESTYLE_FOODIE"),
    
    FAMILY("LIFESTYLE_FAMILY"),
    
    ROMANCE("LIFESTYLE_ROMANCE"),
    
    COUPLE("LIFESTYLE_COUPLE"),
    
    SOLO("LIFESTYLE_SOLO"),
    
    BACKPACKER("LIFESTYLE_BACKPACKER"),
    
    SHOPPING("LIFESTYLE_SHOPPING"),
    
    SPORTS("LIFESTYLE_SPORTS"),
    
    MOUNTAIN("LIFESTYLE_MOUNTAIN"),
    
    BEACH("LIFESTYLE_BEACH"),
    
    CITY("LIFESTYLE_CITY"),
    
    COUNTRY("LIFESTYLE_COUNTRY"),
    
    CULTURE("LIFESTYLE_CULTURE"),
    
    ECO("LIFESTYLE_ECO");

    private String value;

    LifestyleTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static LifestyleTypeEnum fromValue(String value) {
      for (LifestyleTypeEnum b : LifestyleTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_LIFESTYLE_TYPE = "lifestyleType";
  private LifestyleTypeEnum lifestyleType;

  public static final String JSON_PROPERTY_LOCATION = "location";
  private GeoJsonPointNonAuthenticatedEntity location;

  public static final String JSON_PROPERTY_DESCRIPTIONS = "descriptions";
  private List<SimpleDescriptionNonAuthenticatedEntity> descriptions = new ArrayList<>();

  public static final String JSON_PROPERTY_MULTIMEDIAS = "multimedias";
  private List<SimpleMultimediaNonAuthenticatedEntity> multimedias = new ArrayList<>();

  public static final String JSON_PROPERTY_CONTACT = "contact";
  private ContactNonAuthenticatedEntity contact;

  public static final String JSON_PROPERTY_ADDRESS = "address";
  private SimpleAddressNonAuthenticatedEntity address;

  public static final String JSON_PROPERTY_COMMISSIONABLE = "commissionable";
  private Boolean commissionable = true;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_PROXIMITY_CODE = "proximityCode";
  private String proximityCode;

  public static final String JSON_PROPERTY_SORT = "sort";
  private Integer sort;

  public static final String JSON_PROPERTY_MIN_AGE_APPROPRIATE_CODE = "minAgeAppropriateCode";
  private String minAgeAppropriateCode;

  public static final String JSON_PROPERTY_BOOKABLE = "bookable";
  private Boolean bookable = true;

  public static final String JSON_PROPERTY_ACTIVE = "active";
  private Boolean active = true;

  public static final String JSON_PROPERTY_DISABILITY_FEATURES = "disabilityFeatures";
  private List<String> disabilityFeatures;

  public static final String JSON_PROPERTY_SECURITY_FEATURES = "securityFeatures";
  private List<String> securityFeatures;

  public static final String JSON_PROPERTY_SOCIALS = "socials";
  private List<SocialNonAuthenticatedEntity> socials;

  /**
   * Level of expensiveness.
   */
  public enum PricePointEnum {
    HALF("HALF"),
    
    ONE("ONE"),
    
    ONE_HALF("ONE_HALF"),
    
    TWO("TWO"),
    
    TWO_HALF("TWO_HALF"),
    
    THREE("THREE"),
    
    THREE_HALF("THREE_HALF"),
    
    FOUR("FOUR"),
    
    FOUR_HALF("FOUR_HALF"),
    
    FIVE("FIVE");

    private String value;

    PricePointEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static PricePointEnum fromValue(String value) {
      for (PricePointEnum b : PricePointEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_PRICE_POINT = "pricePoint";
  private PricePointEnum pricePoint = PricePointEnum.THREE;

  public static final String JSON_PROPERTY_RECOGNITION_LIST = "recognitionList";
  private List<TravelInventoryRecognitionNonAuthenticatedEntity> recognitionList;

  public static final String JSON_PROPERTY_APPLICABLE_START = "applicableStart";
  private LocalDate applicableStart;

  public static final String JSON_PROPERTY_APPLICABLE_END = "applicableEnd";
  private LocalDate applicableEnd;

  public static final String JSON_PROPERTY_RESERVATION_REQUIRED_IND = "reservationRequiredInd";
  private Boolean reservationRequiredInd;

  public static final String JSON_PROPERTY_OPENS = "opens";
  private String opens;

  public static final String JSON_PROPERTY_CLOSES = "closes";
  private String closes;

  public static final String JSON_PROPERTY_DAYS_OF_WEEK = "daysOfWeek";
  private DowPatternGroupNonAuthenticatedEntity daysOfWeek;

  public static final String JSON_PROPERTY_IRREGULAR = "irregular";
  private Boolean irregular = false;

  public static final String JSON_PROPERTY_MEETING_ROOM_CAPACITY = "meetingRoomCapacity";
  private Integer meetingRoomCapacity = 0;

  public static final String JSON_PROPERTY_ACCESS = "access";
  private String access = "MEETING_ROOM_ACCESS_PRIVATE";

  public static final String JSON_PROPERTY_MEETING_ROOM_TYPE_CODE = "meetingRoomTypeCode";
  private String meetingRoomTypeCode;

  public static final String JSON_PROPERTY_MEETING_ROOM_LEVEL = "meetingRoomLevel";
  private String meetingRoomLevel;

  public static final String JSON_PROPERTY_DEDICATED_IND = "dedicatedInd";
  private Boolean dedicatedInd;

  public static final String JSON_PROPERTY_AREA = "area";
  private Float area;

  public static final String JSON_PROPERTY_HEIGHT = "height";
  private Float height;

  public static final String JSON_PROPERTY_WIDTH = "width";
  private Float width;

  public static final String JSON_PROPERTY_LENGTH = "length";
  private Float length;

  public static final String JSON_PROPERTY_AMENITIES = "amenities";
  private List<String> amenities;

  public MeetingRoomLightweightNonAuthenticatedEntity() {
  }

  public MeetingRoomLightweightNonAuthenticatedEntity identifier(UUID identifier) {
    
    this.identifier = identifier;
    return this;
  }

   /**
   * Unique record identifier
   * @return identifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getIdentifier() {
    return identifier;
  }


  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setIdentifier(UUID identifier) {
    this.identifier = identifier;
  }


  public MeetingRoomLightweightNonAuthenticatedEntity hotelIdentifier(UUID hotelIdentifier) {
    
    this.hotelIdentifier = hotelIdentifier;
    return this;
  }

   /**
   * Hotel identifier.
   * @return hotelIdentifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_HOTEL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getHotelIdentifier() {
    return hotelIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_HOTEL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setHotelIdentifier(UUID hotelIdentifier) {
    this.hotelIdentifier = hotelIdentifier;
  }


  public MeetingRoomLightweightNonAuthenticatedEntity featuredInd(Boolean featuredInd) {
    
    this.featuredInd = featuredInd;
    return this;
  }

   /**
   * Indicates whether this inventory is featured. Use this flag as a way to signify that this inventory is special.
   * @return featuredInd
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_FEATURED_IND)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getFeaturedInd() {
    return featuredInd;
  }


  @JsonProperty(JSON_PROPERTY_FEATURED_IND)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setFeaturedInd(Boolean featuredInd) {
    this.featuredInd = featuredInd;
  }


  public MeetingRoomLightweightNonAuthenticatedEntity lifestyleType(LifestyleTypeEnum lifestyleType) {
    
    this.lifestyleType = lifestyleType;
    return this;
  }

   /**
   * Indicate the type of lifestyle this blocking should be associated with.
   * @return lifestyleType
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_LIFESTYLE_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LifestyleTypeEnum getLifestyleType() {
    return lifestyleType;
  }


  @JsonProperty(JSON_PROPERTY_LIFESTYLE_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLifestyleType(LifestyleTypeEnum lifestyleType) {
    this.lifestyleType = lifestyleType;
  }


  public MeetingRoomLightweightNonAuthenticatedEntity location(GeoJsonPointNonAuthenticatedEntity location) {
    
    this.location = location;
    return this;
  }

   /**
   * Get location
   * @return location
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_LOCATION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public GeoJsonPointNonAuthenticatedEntity getLocation() {
    return location;
  }


  @JsonProperty(JSON_PROPERTY_LOCATION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setLocation(GeoJsonPointNonAuthenticatedEntity location) {
    this.location = location;
  }


  public MeetingRoomLightweightNonAuthenticatedEntity descriptions(List<SimpleDescriptionNonAuthenticatedEntity> descriptions) {
    
    this.descriptions = descriptions;
    return this;
  }

  public MeetingRoomLightweightNonAuthenticatedEntity addDescriptionsItem(SimpleDescriptionNonAuthenticatedEntity descriptionsItem) {
    if (this.descriptions == null) {
      this.descriptions = new ArrayList<>();
    }
    this.descriptions.add(descriptionsItem);
    return this;
  }

   /**
   * Localized descriptions describing blocking.
   * @return descriptions
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_DESCRIPTIONS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<SimpleDescriptionNonAuthenticatedEntity> getDescriptions() {
    return descriptions;
  }


  @JsonProperty(JSON_PROPERTY_DESCRIPTIONS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDescriptions(List<SimpleDescriptionNonAuthenticatedEntity> descriptions) {
    this.descriptions = descriptions;
  }


  public MeetingRoomLightweightNonAuthenticatedEntity multimedias(List<SimpleMultimediaNonAuthenticatedEntity> multimedias) {
    
    this.multimedias = multimedias;
    return this;
  }

  public MeetingRoomLightweightNonAuthenticatedEntity addMultimediasItem(SimpleMultimediaNonAuthenticatedEntity multimediasItem) {
    if (this.multimedias == null) {
      this.multimedias = new ArrayList<>();
    }
    this.multimedias.add(multimediasItem);
    return this;
  }

   /**
   * List of images / videos of blocking.
   * @return multimedias
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_MULTIMEDIAS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<SimpleMultimediaNonAuthenticatedEntity> getMultimedias() {
    return multimedias;
  }


  @JsonProperty(JSON_PROPERTY_MULTIMEDIAS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setMultimedias(List<SimpleMultimediaNonAuthenticatedEntity> multimedias) {
    this.multimedias = multimedias;
  }


  public MeetingRoomLightweightNonAuthenticatedEntity contact(ContactNonAuthenticatedEntity contact) {
    
    this.contact = contact;
    return this;
  }

   /**
   * Get contact
   * @return contact
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_CONTACT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public ContactNonAuthenticatedEntity getContact() {
    return contact;
  }


  @JsonProperty(JSON_PROPERTY_CONTACT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setContact(ContactNonAuthenticatedEntity contact) {
    this.contact = contact;
  }


  public MeetingRoomLightweightNonAuthenticatedEntity address(SimpleAddressNonAuthenticatedEntity address) {
    
    this.address = address;
    return this;
  }

   /**
   * Get address
   * @return address
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public SimpleAddressNonAuthenticatedEntity getAddress() {
    return address;
  }


  @JsonProperty(JSON_PROPERTY_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAddress(SimpleAddressNonAuthenticatedEntity address) {
    this.address = address;
  }


  public MeetingRoomLightweightNonAuthenticatedEntity commissionable(Boolean commissionable) {
    
    this.commissionable = commissionable;
    return this;
  }

   /**
   * Indicate whether sales channels receive commission for selling this blocking.
   * @return commissionable
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_COMMISSIONABLE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getCommissionable() {
    return commissionable;
  }


  @JsonProperty(JSON_PROPERTY_COMMISSIONABLE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCommissionable(Boolean commissionable) {
    this.commissionable = commissionable;
  }


  public MeetingRoomLightweightNonAuthenticatedEntity name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * Internal name of blocking.
   * @return name
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setName(String name) {
    this.name = name;
  }


  public MeetingRoomLightweightNonAuthenticatedEntity proximityCode(String proximityCode) {
    
    this.proximityCode = proximityCode;
    return this;
  }

   /**
   * Supported OTA specification &#x60;PRX&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory)
   * @return proximityCode
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_PROXIMITY_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getProximityCode() {
    return proximityCode;
  }


  @JsonProperty(JSON_PROPERTY_PROXIMITY_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setProximityCode(String proximityCode) {
    this.proximityCode = proximityCode;
  }


  public MeetingRoomLightweightNonAuthenticatedEntity sort(Integer sort) {
    
    this.sort = sort;
    return this;
  }

   /**
   * Use this property to sort an blocking in a list of activities.
   * @return sort
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getSort() {
    return sort;
  }


  @JsonProperty(JSON_PROPERTY_SORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSort(Integer sort) {
    this.sort = sort;
  }


  public MeetingRoomLightweightNonAuthenticatedEntity minAgeAppropriateCode(String minAgeAppropriateCode) {
    
    this.minAgeAppropriateCode = minAgeAppropriateCode;
    return this;
  }

   /**
   * Supported OTA specification &#x60;AQC&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory)
   * @return minAgeAppropriateCode
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_MIN_AGE_APPROPRIATE_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getMinAgeAppropriateCode() {
    return minAgeAppropriateCode;
  }


  @JsonProperty(JSON_PROPERTY_MIN_AGE_APPROPRIATE_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMinAgeAppropriateCode(String minAgeAppropriateCode) {
    this.minAgeAppropriateCode = minAgeAppropriateCode;
  }


  public MeetingRoomLightweightNonAuthenticatedEntity bookable(Boolean bookable) {
    
    this.bookable = bookable;
    return this;
  }

   /**
   * Indicates if this blocking can be added to a booking or if it is read-only marketing material only.
   * @return bookable
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_BOOKABLE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getBookable() {
    return bookable;
  }


  @JsonProperty(JSON_PROPERTY_BOOKABLE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setBookable(Boolean bookable) {
    this.bookable = bookable;
  }


  public MeetingRoomLightweightNonAuthenticatedEntity active(Boolean active) {
    
    this.active = active;
    return this;
  }

   /**
   * Modify blocking availability with this flag.
   * @return active
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_ACTIVE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getActive() {
    return active;
  }


  @JsonProperty(JSON_PROPERTY_ACTIVE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setActive(Boolean active) {
    this.active = active;
  }


  public MeetingRoomLightweightNonAuthenticatedEntity disabilityFeatures(List<String> disabilityFeatures) {
    
    this.disabilityFeatures = disabilityFeatures;
    return this;
  }

  public MeetingRoomLightweightNonAuthenticatedEntity addDisabilityFeaturesItem(String disabilityFeaturesItem) {
    if (this.disabilityFeatures == null) {
      this.disabilityFeatures = new ArrayList<>();
    }
    this.disabilityFeatures.add(disabilityFeaturesItem);
    return this;
  }

   /**
   * Supported OTA specification &#x60;PHY&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory)
   * @return disabilityFeatures
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_DISABILITY_FEATURES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getDisabilityFeatures() {
    return disabilityFeatures;
  }


  @JsonProperty(JSON_PROPERTY_DISABILITY_FEATURES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDisabilityFeatures(List<String> disabilityFeatures) {
    this.disabilityFeatures = disabilityFeatures;
  }


  public MeetingRoomLightweightNonAuthenticatedEntity securityFeatures(List<String> securityFeatures) {
    
    this.securityFeatures = securityFeatures;
    return this;
  }

  public MeetingRoomLightweightNonAuthenticatedEntity addSecurityFeaturesItem(String securityFeaturesItem) {
    if (this.securityFeatures == null) {
      this.securityFeatures = new ArrayList<>();
    }
    this.securityFeatures.add(securityFeaturesItem);
    return this;
  }

   /**
   * Supported OTA specification &#x60;SEC&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory)
   * @return securityFeatures
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SECURITY_FEATURES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getSecurityFeatures() {
    return securityFeatures;
  }


  @JsonProperty(JSON_PROPERTY_SECURITY_FEATURES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSecurityFeatures(List<String> securityFeatures) {
    this.securityFeatures = securityFeatures;
  }


  public MeetingRoomLightweightNonAuthenticatedEntity socials(List<SocialNonAuthenticatedEntity> socials) {
    
    this.socials = socials;
    return this;
  }

  public MeetingRoomLightweightNonAuthenticatedEntity addSocialsItem(SocialNonAuthenticatedEntity socialsItem) {
    if (this.socials == null) {
      this.socials = new ArrayList<>();
    }
    this.socials.add(socialsItem);
    return this;
  }

   /**
   * Social network accounts for blocking (if applicable).
   * @return socials
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SOCIALS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<SocialNonAuthenticatedEntity> getSocials() {
    return socials;
  }


  @JsonProperty(JSON_PROPERTY_SOCIALS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSocials(List<SocialNonAuthenticatedEntity> socials) {
    this.socials = socials;
  }


  public MeetingRoomLightweightNonAuthenticatedEntity pricePoint(PricePointEnum pricePoint) {
    
    this.pricePoint = pricePoint;
    return this;
  }

   /**
   * Level of expensiveness.
   * @return pricePoint
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_PRICE_POINT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public PricePointEnum getPricePoint() {
    return pricePoint;
  }


  @JsonProperty(JSON_PROPERTY_PRICE_POINT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPricePoint(PricePointEnum pricePoint) {
    this.pricePoint = pricePoint;
  }


  public MeetingRoomLightweightNonAuthenticatedEntity recognitionList(List<TravelInventoryRecognitionNonAuthenticatedEntity> recognitionList) {
    
    this.recognitionList = recognitionList;
    return this;
  }

  public MeetingRoomLightweightNonAuthenticatedEntity addRecognitionListItem(TravelInventoryRecognitionNonAuthenticatedEntity recognitionListItem) {
    if (this.recognitionList == null) {
      this.recognitionList = new ArrayList<>();
    }
    this.recognitionList.add(recognitionListItem);
    return this;
  }

   /**
   * Inventory-level recognition.
   * @return recognitionList
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_RECOGNITION_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<TravelInventoryRecognitionNonAuthenticatedEntity> getRecognitionList() {
    return recognitionList;
  }


  @JsonProperty(JSON_PROPERTY_RECOGNITION_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRecognitionList(List<TravelInventoryRecognitionNonAuthenticatedEntity> recognitionList) {
    this.recognitionList = recognitionList;
  }


  public MeetingRoomLightweightNonAuthenticatedEntity applicableStart(LocalDate applicableStart) {
    
    this.applicableStart = applicableStart;
    return this;
  }

   /**
   * Start month and day or date for which the attraction (e.g. the start of a season) is available. This date property signifies that the blocking is recurring and / or seasonal. If the date is in the past, only day and month will be used to infer seasonality. If the date is a future date, it will be interpreted as a starting date.
   * @return applicableStart
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_APPLICABLE_START)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LocalDate getApplicableStart() {
    return applicableStart;
  }


  @JsonProperty(JSON_PROPERTY_APPLICABLE_START)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setApplicableStart(LocalDate applicableStart) {
    this.applicableStart = applicableStart;
  }


  public MeetingRoomLightweightNonAuthenticatedEntity applicableEnd(LocalDate applicableEnd) {
    
    this.applicableEnd = applicableEnd;
    return this;
  }

   /**
   * End month and day or date for which the attraction (e.g. the start of a season) is available. This date property signifies that the blocking is recurring and / or seasonal. If the date is in the past, only day and month will be used to infer seasonality. If the date is a future date, it will be interpreted as a ending date.
   * @return applicableEnd
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_APPLICABLE_END)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LocalDate getApplicableEnd() {
    return applicableEnd;
  }


  @JsonProperty(JSON_PROPERTY_APPLICABLE_END)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setApplicableEnd(LocalDate applicableEnd) {
    this.applicableEnd = applicableEnd;
  }


  public MeetingRoomLightweightNonAuthenticatedEntity reservationRequiredInd(Boolean reservationRequiredInd) {
    
    this.reservationRequiredInd = reservationRequiredInd;
    return this;
  }

   /**
   * Indicates whether a reservation is required to participate in this blocking.
   * @return reservationRequiredInd
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_RESERVATION_REQUIRED_IND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getReservationRequiredInd() {
    return reservationRequiredInd;
  }


  @JsonProperty(JSON_PROPERTY_RESERVATION_REQUIRED_IND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReservationRequiredInd(Boolean reservationRequiredInd) {
    this.reservationRequiredInd = reservationRequiredInd;
  }


  public MeetingRoomLightweightNonAuthenticatedEntity opens(String opens) {
    
    this.opens = opens;
    return this;
  }

   /**
   * Opening time of blocking (if applicable). Leave empty if blocking is always available.
   * @return opens
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_OPENS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getOpens() {
    return opens;
  }


  @JsonProperty(JSON_PROPERTY_OPENS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOpens(String opens) {
    this.opens = opens;
  }


  public MeetingRoomLightweightNonAuthenticatedEntity closes(String closes) {
    
    this.closes = closes;
    return this;
  }

   /**
   * Closing time of blocking (if applicable). Leave empty if blocking is always available.
   * @return closes
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CLOSES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCloses() {
    return closes;
  }


  @JsonProperty(JSON_PROPERTY_CLOSES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCloses(String closes) {
    this.closes = closes;
  }


  public MeetingRoomLightweightNonAuthenticatedEntity daysOfWeek(DowPatternGroupNonAuthenticatedEntity daysOfWeek) {
    
    this.daysOfWeek = daysOfWeek;
    return this;
  }

   /**
   * Get daysOfWeek
   * @return daysOfWeek
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_DAYS_OF_WEEK)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public DowPatternGroupNonAuthenticatedEntity getDaysOfWeek() {
    return daysOfWeek;
  }


  @JsonProperty(JSON_PROPERTY_DAYS_OF_WEEK)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDaysOfWeek(DowPatternGroupNonAuthenticatedEntity daysOfWeek) {
    this.daysOfWeek = daysOfWeek;
  }


  public MeetingRoomLightweightNonAuthenticatedEntity irregular(Boolean irregular) {
    
    this.irregular = irregular;
    return this;
  }

   /**
   * Room has an irregular shape. If true, the room would be of a traditional square or rectangular shape.
   * @return irregular
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_IRREGULAR)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getIrregular() {
    return irregular;
  }


  @JsonProperty(JSON_PROPERTY_IRREGULAR)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setIrregular(Boolean irregular) {
    this.irregular = irregular;
  }


  public MeetingRoomLightweightNonAuthenticatedEntity meetingRoomCapacity(Integer meetingRoomCapacity) {
    
    this.meetingRoomCapacity = meetingRoomCapacity;
    return this;
  }

   /**
   * The total number of people permitted in the meeting room.
   * minimum: 0
   * @return meetingRoomCapacity
  **/
  @jakarta.annotation.Nonnull
  @NotNull
 @Min(0)
  @JsonProperty(JSON_PROPERTY_MEETING_ROOM_CAPACITY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getMeetingRoomCapacity() {
    return meetingRoomCapacity;
  }


  @JsonProperty(JSON_PROPERTY_MEETING_ROOM_CAPACITY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setMeetingRoomCapacity(Integer meetingRoomCapacity) {
    this.meetingRoomCapacity = meetingRoomCapacity;
  }


  public MeetingRoomLightweightNonAuthenticatedEntity access(String access) {
    
    this.access = access;
    return this;
  }

   /**
   * The type of access to the meeting space.
   * @return access
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ACCESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAccess() {
    return access;
  }


  @JsonProperty(JSON_PROPERTY_ACCESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAccess(String access) {
    this.access = access;
  }


  public MeetingRoomLightweightNonAuthenticatedEntity meetingRoomTypeCode(String meetingRoomTypeCode) {
    
    this.meetingRoomTypeCode = meetingRoomTypeCode;
    return this;
  }

   /**
   * Supported OTA specification &#x60;MRF&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory).
   * @return meetingRoomTypeCode
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_MEETING_ROOM_TYPE_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getMeetingRoomTypeCode() {
    return meetingRoomTypeCode;
  }


  @JsonProperty(JSON_PROPERTY_MEETING_ROOM_TYPE_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setMeetingRoomTypeCode(String meetingRoomTypeCode) {
    this.meetingRoomTypeCode = meetingRoomTypeCode;
  }


  public MeetingRoomLightweightNonAuthenticatedEntity meetingRoomLevel(String meetingRoomLevel) {
    
    this.meetingRoomLevel = meetingRoomLevel;
    return this;
  }

   /**
   * Defines the level in the facility where the meeting room is located.
   * @return meetingRoomLevel
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_MEETING_ROOM_LEVEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getMeetingRoomLevel() {
    return meetingRoomLevel;
  }


  @JsonProperty(JSON_PROPERTY_MEETING_ROOM_LEVEL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMeetingRoomLevel(String meetingRoomLevel) {
    this.meetingRoomLevel = meetingRoomLevel;
  }


  public MeetingRoomLightweightNonAuthenticatedEntity dedicatedInd(Boolean dedicatedInd) {
    
    this.dedicatedInd = dedicatedInd;
    return this;
  }

   /**
   * When true, the room is used for a single purpose as indicated by the MeetingRoomTypeCode attribute.
   * @return dedicatedInd
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_DEDICATED_IND)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getDedicatedInd() {
    return dedicatedInd;
  }


  @JsonProperty(JSON_PROPERTY_DEDICATED_IND)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDedicatedInd(Boolean dedicatedInd) {
    this.dedicatedInd = dedicatedInd;
  }


  public MeetingRoomLightweightNonAuthenticatedEntity area(Float area) {
    
    this.area = area;
    return this;
  }

   /**
   * Area (in square meters) of this meeting room.
   * minimum: 1.0
   * @return area
  **/
  @jakarta.annotation.Nonnull
  @NotNull
 @DecimalMin("1.0")
  @JsonProperty(JSON_PROPERTY_AREA)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Float getArea() {
    return area;
  }


  @JsonProperty(JSON_PROPERTY_AREA)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setArea(Float area) {
    this.area = area;
  }


  public MeetingRoomLightweightNonAuthenticatedEntity height(Float height) {
    
    this.height = height;
    return this;
  }

   /**
   * Height (in meters) of this meeting room.
   * minimum: 1.0
   * @return height
  **/
  @jakarta.annotation.Nonnull
  @NotNull
 @DecimalMin("1.0")
  @JsonProperty(JSON_PROPERTY_HEIGHT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Float getHeight() {
    return height;
  }


  @JsonProperty(JSON_PROPERTY_HEIGHT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setHeight(Float height) {
    this.height = height;
  }


  public MeetingRoomLightweightNonAuthenticatedEntity width(Float width) {
    
    this.width = width;
    return this;
  }

   /**
   * Width (in meters) of this meeting room.
   * minimum: 1.0
   * @return width
  **/
  @jakarta.annotation.Nonnull
  @NotNull
 @DecimalMin("1.0")
  @JsonProperty(JSON_PROPERTY_WIDTH)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Float getWidth() {
    return width;
  }


  @JsonProperty(JSON_PROPERTY_WIDTH)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setWidth(Float width) {
    this.width = width;
  }


  public MeetingRoomLightweightNonAuthenticatedEntity length(Float length) {
    
    this.length = length;
    return this;
  }

   /**
   * Length (in meters) of this meeting room.
   * minimum: 1.0
   * @return length
  **/
  @jakarta.annotation.Nonnull
  @NotNull
 @DecimalMin("1.0")
  @JsonProperty(JSON_PROPERTY_LENGTH)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Float getLength() {
    return length;
  }


  @JsonProperty(JSON_PROPERTY_LENGTH)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setLength(Float length) {
    this.length = length;
  }


  public MeetingRoomLightweightNonAuthenticatedEntity amenities(List<String> amenities) {
    
    this.amenities = amenities;
    return this;
  }

  public MeetingRoomLightweightNonAuthenticatedEntity addAmenitiesItem(String amenitiesItem) {
    if (this.amenities == null) {
      this.amenities = new ArrayList<>();
    }
    this.amenities.add(amenitiesItem);
    return this;
  }

   /**
   * Supported OTA specification &#x60;MRC&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory).
   * @return amenities
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_AMENITIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getAmenities() {
    return amenities;
  }


  @JsonProperty(JSON_PROPERTY_AMENITIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAmenities(List<String> amenities) {
    this.amenities = amenities;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MeetingRoomLightweightNonAuthenticatedEntity meetingRoomLightweightNonAuthenticatedEntity = (MeetingRoomLightweightNonAuthenticatedEntity) o;
    return Objects.equals(this.identifier, meetingRoomLightweightNonAuthenticatedEntity.identifier) &&
        Objects.equals(this.hotelIdentifier, meetingRoomLightweightNonAuthenticatedEntity.hotelIdentifier) &&
        Objects.equals(this.featuredInd, meetingRoomLightweightNonAuthenticatedEntity.featuredInd) &&
        Objects.equals(this.lifestyleType, meetingRoomLightweightNonAuthenticatedEntity.lifestyleType) &&
        Objects.equals(this.location, meetingRoomLightweightNonAuthenticatedEntity.location) &&
        Objects.equals(this.descriptions, meetingRoomLightweightNonAuthenticatedEntity.descriptions) &&
        Objects.equals(this.multimedias, meetingRoomLightweightNonAuthenticatedEntity.multimedias) &&
        Objects.equals(this.contact, meetingRoomLightweightNonAuthenticatedEntity.contact) &&
        Objects.equals(this.address, meetingRoomLightweightNonAuthenticatedEntity.address) &&
        Objects.equals(this.commissionable, meetingRoomLightweightNonAuthenticatedEntity.commissionable) &&
        Objects.equals(this.name, meetingRoomLightweightNonAuthenticatedEntity.name) &&
        Objects.equals(this.proximityCode, meetingRoomLightweightNonAuthenticatedEntity.proximityCode) &&
        Objects.equals(this.sort, meetingRoomLightweightNonAuthenticatedEntity.sort) &&
        Objects.equals(this.minAgeAppropriateCode, meetingRoomLightweightNonAuthenticatedEntity.minAgeAppropriateCode) &&
        Objects.equals(this.bookable, meetingRoomLightweightNonAuthenticatedEntity.bookable) &&
        Objects.equals(this.active, meetingRoomLightweightNonAuthenticatedEntity.active) &&
        Objects.equals(this.disabilityFeatures, meetingRoomLightweightNonAuthenticatedEntity.disabilityFeatures) &&
        Objects.equals(this.securityFeatures, meetingRoomLightweightNonAuthenticatedEntity.securityFeatures) &&
        Objects.equals(this.socials, meetingRoomLightweightNonAuthenticatedEntity.socials) &&
        Objects.equals(this.pricePoint, meetingRoomLightweightNonAuthenticatedEntity.pricePoint) &&
        Objects.equals(this.recognitionList, meetingRoomLightweightNonAuthenticatedEntity.recognitionList) &&
        Objects.equals(this.applicableStart, meetingRoomLightweightNonAuthenticatedEntity.applicableStart) &&
        Objects.equals(this.applicableEnd, meetingRoomLightweightNonAuthenticatedEntity.applicableEnd) &&
        Objects.equals(this.reservationRequiredInd, meetingRoomLightweightNonAuthenticatedEntity.reservationRequiredInd) &&
        Objects.equals(this.opens, meetingRoomLightweightNonAuthenticatedEntity.opens) &&
        Objects.equals(this.closes, meetingRoomLightweightNonAuthenticatedEntity.closes) &&
        Objects.equals(this.daysOfWeek, meetingRoomLightweightNonAuthenticatedEntity.daysOfWeek) &&
        Objects.equals(this.irregular, meetingRoomLightweightNonAuthenticatedEntity.irregular) &&
        Objects.equals(this.meetingRoomCapacity, meetingRoomLightweightNonAuthenticatedEntity.meetingRoomCapacity) &&
        Objects.equals(this.access, meetingRoomLightweightNonAuthenticatedEntity.access) &&
        Objects.equals(this.meetingRoomTypeCode, meetingRoomLightweightNonAuthenticatedEntity.meetingRoomTypeCode) &&
        Objects.equals(this.meetingRoomLevel, meetingRoomLightweightNonAuthenticatedEntity.meetingRoomLevel) &&
        Objects.equals(this.dedicatedInd, meetingRoomLightweightNonAuthenticatedEntity.dedicatedInd) &&
        Objects.equals(this.area, meetingRoomLightweightNonAuthenticatedEntity.area) &&
        Objects.equals(this.height, meetingRoomLightweightNonAuthenticatedEntity.height) &&
        Objects.equals(this.width, meetingRoomLightweightNonAuthenticatedEntity.width) &&
        Objects.equals(this.length, meetingRoomLightweightNonAuthenticatedEntity.length) &&
        Objects.equals(this.amenities, meetingRoomLightweightNonAuthenticatedEntity.amenities);
  }

  @Override
  public int hashCode() {
    return Objects.hash(identifier, hotelIdentifier, featuredInd, lifestyleType, location, descriptions, multimedias, contact, address, commissionable, name, proximityCode, sort, minAgeAppropriateCode, bookable, active, disabilityFeatures, securityFeatures, socials, pricePoint, recognitionList, applicableStart, applicableEnd, reservationRequiredInd, opens, closes, daysOfWeek, irregular, meetingRoomCapacity, access, meetingRoomTypeCode, meetingRoomLevel, dedicatedInd, area, height, width, length, amenities);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MeetingRoomLightweightNonAuthenticatedEntity {\n");
    sb.append("    identifier: ").append(toIndentedString(identifier)).append("\n");
    sb.append("    hotelIdentifier: ").append(toIndentedString(hotelIdentifier)).append("\n");
    sb.append("    featuredInd: ").append(toIndentedString(featuredInd)).append("\n");
    sb.append("    lifestyleType: ").append(toIndentedString(lifestyleType)).append("\n");
    sb.append("    location: ").append(toIndentedString(location)).append("\n");
    sb.append("    descriptions: ").append(toIndentedString(descriptions)).append("\n");
    sb.append("    multimedias: ").append(toIndentedString(multimedias)).append("\n");
    sb.append("    contact: ").append(toIndentedString(contact)).append("\n");
    sb.append("    address: ").append(toIndentedString(address)).append("\n");
    sb.append("    commissionable: ").append(toIndentedString(commissionable)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    proximityCode: ").append(toIndentedString(proximityCode)).append("\n");
    sb.append("    sort: ").append(toIndentedString(sort)).append("\n");
    sb.append("    minAgeAppropriateCode: ").append(toIndentedString(minAgeAppropriateCode)).append("\n");
    sb.append("    bookable: ").append(toIndentedString(bookable)).append("\n");
    sb.append("    active: ").append(toIndentedString(active)).append("\n");
    sb.append("    disabilityFeatures: ").append(toIndentedString(disabilityFeatures)).append("\n");
    sb.append("    securityFeatures: ").append(toIndentedString(securityFeatures)).append("\n");
    sb.append("    socials: ").append(toIndentedString(socials)).append("\n");
    sb.append("    pricePoint: ").append(toIndentedString(pricePoint)).append("\n");
    sb.append("    recognitionList: ").append(toIndentedString(recognitionList)).append("\n");
    sb.append("    applicableStart: ").append(toIndentedString(applicableStart)).append("\n");
    sb.append("    applicableEnd: ").append(toIndentedString(applicableEnd)).append("\n");
    sb.append("    reservationRequiredInd: ").append(toIndentedString(reservationRequiredInd)).append("\n");
    sb.append("    opens: ").append(toIndentedString(opens)).append("\n");
    sb.append("    closes: ").append(toIndentedString(closes)).append("\n");
    sb.append("    daysOfWeek: ").append(toIndentedString(daysOfWeek)).append("\n");
    sb.append("    irregular: ").append(toIndentedString(irregular)).append("\n");
    sb.append("    meetingRoomCapacity: ").append(toIndentedString(meetingRoomCapacity)).append("\n");
    sb.append("    access: ").append(toIndentedString(access)).append("\n");
    sb.append("    meetingRoomTypeCode: ").append(toIndentedString(meetingRoomTypeCode)).append("\n");
    sb.append("    meetingRoomLevel: ").append(toIndentedString(meetingRoomLevel)).append("\n");
    sb.append("    dedicatedInd: ").append(toIndentedString(dedicatedInd)).append("\n");
    sb.append("    area: ").append(toIndentedString(area)).append("\n");
    sb.append("    height: ").append(toIndentedString(height)).append("\n");
    sb.append("    width: ").append(toIndentedString(width)).append("\n");
    sb.append("    length: ").append(toIndentedString(length)).append("\n");
    sb.append("    amenities: ").append(toIndentedString(amenities)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

