package travel.wink.sdk.inventory.api;

import travel.wink.sdk.inventory.invoker.ApiClient;

import travel.wink.sdk.inventory.model.ConsumableSellerUrlNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.GenericErrorMessage;
import travel.wink.sdk.inventory.model.ShowConsumableUrl400Response;
import travel.wink.sdk.inventory.model.UserSessionNonAuthenticatedEntity;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-06-03T15:00:39.254575718+07:00[Asia/Bangkok]")
public class ShareableLinkApi {
    private ApiClient apiClient;

    public ShareableLinkApi() {
        this(new ApiClient());
    }

    @Autowired
    public ShareableLinkApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Show Shareable Link
     * Retrieve a shareable link by its unique code
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param code Unique link code
     * @param userSessionNonAuthenticatedEntity The userSessionNonAuthenticatedEntity parameter
     * @param cid Optional campaign id
     * @param gl Optional GA4 cross-site link id
     * @param winkVersion The winkVersion parameter
     * @return ConsumableSellerUrlNonAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showConsumableUrlRequestCreation(String code, UserSessionNonAuthenticatedEntity userSessionNonAuthenticatedEntity, String cid, String gl, String winkVersion) throws WebClientResponseException {
        Object postBody = userSessionNonAuthenticatedEntity;
        // verify the required parameter 'code' is set
        if (code == null) {
            throw new WebClientResponseException("Missing the required parameter 'code' when calling showConsumableUrl", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'userSessionNonAuthenticatedEntity' is set
        if (userSessionNonAuthenticatedEntity == null) {
            throw new WebClientResponseException("Missing the required parameter 'userSessionNonAuthenticatedEntity' when calling showConsumableUrl", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("code", code);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "cid", cid));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "_gl", gl));

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<ConsumableSellerUrlNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<ConsumableSellerUrlNonAuthenticatedEntity>() {};
        return apiClient.invokeAPI("/api/shareable-link/{code}", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Shareable Link
     * Retrieve a shareable link by its unique code
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param code Unique link code
     * @param userSessionNonAuthenticatedEntity The userSessionNonAuthenticatedEntity parameter
     * @param cid Optional campaign id
     * @param gl Optional GA4 cross-site link id
     * @param winkVersion The winkVersion parameter
     * @return ConsumableSellerUrlNonAuthenticatedEntity
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ConsumableSellerUrlNonAuthenticatedEntity> showConsumableUrl(String code, UserSessionNonAuthenticatedEntity userSessionNonAuthenticatedEntity, String cid, String gl, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<ConsumableSellerUrlNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<ConsumableSellerUrlNonAuthenticatedEntity>() {};
        return showConsumableUrlRequestCreation(code, userSessionNonAuthenticatedEntity, cid, gl, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Show Shareable Link
     * Retrieve a shareable link by its unique code
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param code Unique link code
     * @param userSessionNonAuthenticatedEntity The userSessionNonAuthenticatedEntity parameter
     * @param cid Optional campaign id
     * @param gl Optional GA4 cross-site link id
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;ConsumableSellerUrlNonAuthenticatedEntity&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<ConsumableSellerUrlNonAuthenticatedEntity>> showConsumableUrlWithHttpInfo(String code, UserSessionNonAuthenticatedEntity userSessionNonAuthenticatedEntity, String cid, String gl, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<ConsumableSellerUrlNonAuthenticatedEntity> localVarReturnType = new ParameterizedTypeReference<ConsumableSellerUrlNonAuthenticatedEntity>() {};
        return showConsumableUrlRequestCreation(code, userSessionNonAuthenticatedEntity, cid, gl, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Show Shareable Link
     * Retrieve a shareable link by its unique code
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param code Unique link code
     * @param userSessionNonAuthenticatedEntity The userSessionNonAuthenticatedEntity parameter
     * @param cid Optional campaign id
     * @param gl Optional GA4 cross-site link id
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showConsumableUrlWithResponseSpec(String code, UserSessionNonAuthenticatedEntity userSessionNonAuthenticatedEntity, String cid, String gl, String winkVersion) throws WebClientResponseException {
        return showConsumableUrlRequestCreation(code, userSessionNonAuthenticatedEntity, cid, gl, winkVersion);
    }
}
