/*
 * Wink API
 *  # Introduction  Welcome to the Wink API - A programmer-friendly way to manage, sell and book travel inventory on the Wink platform. The API gives you all the tools you need to ready your properties and inventory for sale across 1000s of our native sales channels.  Integrators, affiliates, travel agents and content creators have the ability search for your travel inventory and promote / sell it in a wide variety of ways.   # Integrations  We have already integrated with the most well-known channel managers so you don't have to. To see our current integrations, please go to https://extranet.wink.travel and scroll to Connectivity section. Once your properties are set up, you can finish the setup by mapping your property to Wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API.   # Intended Audience  Programmers are [most likely] a requirement to start integrating with Wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible.  - Hotel chains  - Hotel brands  - Travel tech companies  - Destination sites  - Integrators  - Aggregators  - Destination management companies  - Travel agencies  - OTAs   ## APIs  Not every integrator needs every API. For that reason, we have separated APIs into context.  ### Test API   - [Ping](/ping): The Ping API is a quick test endpoint to verify that your credentials work Wink.  ### Common APIs  - [Notifications](/notifications): The Notifications API is a way for us to stay in touch with your user, property or affiliate account. - [User Settings](/user-settings): The User Settings API exposes endpoints to allow 3rd party integrators to communicate with Wink.  ### Consume APIs Consume endpoints are for developers who want to find existing travel inventory and either book it or use it to advertise through one of their Wink affiliate accounts.   - [Configuration](/customization-client): A single endpoint to retrieve whitelabel + customization information for the booking customization.  - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags.  - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API..  - [Booking](/booking): All APIs related to creating bookings on the platform.  - [Travel Agent](/travel-agent): The Travel Agent API exposes endpoints to manage agent-facilitated bookings.   ### Produce APIs  Produce endpoints are for developers who want to create and manage travel inventory.   #### Property  - [Property registration](/extranet/property/register): As a producer, this is, oftentimes, where you start your journey. These endpoints let you create properties on Wink.  - [Property](/extranet/property): This collection of property endpoints are mostly management endpoints that let you display, change status and similar for your existing properties.  - [Facilities](/extranet/facilities): This collection of endpoints let you manage facilities; such as room types.  - [Experiences](/extranet/experiences): This collection of endpoints let you manage experiences, such as activities.  - [Monetize](/extranet/monetize): The Monetize API exposes endpoints for managing cancellation polies, rate plans, promotions and more on Wink.  - [Distribution](/extranet/distribution): The Distribution API exposes endpoints for sales channels, connecting with affiliates, managing rates and inventory calendars and more on Wink.  - [Property Booking](/extranet/booking): The Property Booking API exposes endpoints for managing bookings and reviews at the property-level.   #### Affiliate  - [Affiliate](/affiliate): This collection of affiliate endpoints are mostly management endpoints that let you display, change status and similar for your existing accounts.  - [Browse](/affiliate/browse): The Browse API exposes endpoints for affiliates to find suppliers and inventory to sell.  - [Inventory](/affiliate/inventory): The Inventory API exposes endpoints for affiliates to manage the inventory they want to sell and how they want to sell it.  - [Sales Channel](/affiliate/sales-channel): The Sales Channel API exposes endpoints for affiliates to manage existing sales channels as well as find new ones.  - [WinkLinks](/affiliate/winklinks): The WinkLinks API exposes endpoints for affiliates to manage their WinkLinks page.   #### Rate provider  - [Channel manager](/channel-manager): The Channel Manager API enables external channel manager partners to map, exchange rate / availability information with us as well as be informed of bookings that occur on the Wink platform for one of their properties.   ### Taxonomy APIs  Taxonomy endpoints are for developers who want to consume and produce travel inventory and need taxonomies of standard and non-standard codes for inventory types, classes, statuses etc.   - [Reference](/reactive): All APIs related to retrieving platform-supported taxonomies.   ### Insight APIs  Insight endpoints do exactly what the name implies - They offer platform-level insight into the activities of producers and consumers.   - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics.   ### Payment APIs  Payment endpoints are for developers who want to purchase travel inventory. This can be done via the API as a registered Travel Agent or using our API in conjunction with our PCI compliant reactive widget for all other entities.   - [TripPay](/reactive): All APIs related to TripPay account management, booking, mapping and integration features.   ## SDKs  We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).   - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)   ## Usage  These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.   ## Versioning  We chose to version our endpoints in a way that we hope affects your integration minimally. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.   ## Release history  - Follow updates on Github: https://github.com/wink-travel/wink-sdk-java/blob/master/CHANGELOG.md    # Inventory API The Inventory API exposes endpoints to retrieve inventory you already know about. This API lets you:  1. Consume shareable links. 2. Load up a known property with availability. 3. Load up all inventories that were created by our affiliates such as grids, maps, and individual items.  Browse the endpoints in the left navigation bar to get started.  
 *
 * The version of the OpenAPI document: 30.17.8
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.inventory.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.UUID;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * CancellationPolicyLightweightNonAuthenticatedEntity
 */
@JsonPropertyOrder({
  CancellationPolicyLightweightNonAuthenticatedEntity.JSON_PROPERTY_IDENTIFIER,
  CancellationPolicyLightweightNonAuthenticatedEntity.JSON_PROPERTY_HOTEL_IDENTIFIER,
  CancellationPolicyLightweightNonAuthenticatedEntity.JSON_PROPERTY_REFUNDABLE,
  CancellationPolicyLightweightNonAuthenticatedEntity.JSON_PROPERTY_ADVANCE_CANCELLATION_FREE_OF_CHARGE,
  CancellationPolicyLightweightNonAuthenticatedEntity.JSON_PROPERTY_REFUNDABLE_CANCELLATION_CHARGE,
  CancellationPolicyLightweightNonAuthenticatedEntity.JSON_PROPERTY_NO_SHOW_CHARGE,
  CancellationPolicyLightweightNonAuthenticatedEntity.JSON_PROPERTY_NON_REFUNDABLE_CANCELLATION_CHARGE,
  CancellationPolicyLightweightNonAuthenticatedEntity.JSON_PROPERTY_NON_REFUNDABLE_DEADLINE,
  CancellationPolicyLightweightNonAuthenticatedEntity.JSON_PROPERTY_NON_REFUNDABLE_AFTER_DEADLINE_CANCELLATION_CHARGE,
  CancellationPolicyLightweightNonAuthenticatedEntity.JSON_PROPERTY_POLICY_CODE
})
@JsonTypeName("CancellationPolicyLightweight_Non_Authenticated_Entity")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-06-26T20:20:31.141212618+07:00[Asia/Bangkok]", comments = "Generator version: 7.13.0")
public class CancellationPolicyLightweightNonAuthenticatedEntity {
  public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
  @jakarta.annotation.Nonnull
  private UUID identifier;

  public static final String JSON_PROPERTY_HOTEL_IDENTIFIER = "hotelIdentifier";
  @jakarta.annotation.Nonnull
  private UUID hotelIdentifier;

  public static final String JSON_PROPERTY_REFUNDABLE = "refundable";
  @jakarta.annotation.Nonnull
  private Boolean refundable = false;

  /**
   * When the cancellation policy is refundable, this flag can be set and indicates there is more rules involved than just a no-questions-asked refundable.
   */
  public enum AdvanceCancellationFreeOfChargeEnum {
    UNTIL_EIGHTEEN_HUNDRED_HOURS_ON_DAY_OF_ARRIVAL(String.valueOf("UNTIL_EIGHTEEN_HUNDRED_HOURS_ON_DAY_OF_ARRIVAL")),
    
    UNTIL_FOURTEEN_HUNDRED_HOURS_ON_DAY_OF_ARRIVAL(String.valueOf("UNTIL_FOURTEEN_HUNDRED_HOURS_ON_DAY_OF_ARRIVAL")),
    
    ONE_DAY_BEFORE_ARRIVAL(String.valueOf("ONE_DAY_BEFORE_ARRIVAL")),
    
    TWO_DAYS_BEFORE_ARRIVAL(String.valueOf("TWO_DAYS_BEFORE_ARRIVAL")),
    
    THREE_DAYS_BEFORE_ARRIVAL(String.valueOf("THREE_DAYS_BEFORE_ARRIVAL")),
    
    FIVE_DAYS_BEFORE_ARRIVAL(String.valueOf("FIVE_DAYS_BEFORE_ARRIVAL")),
    
    SEVEN_DAYS_BEFORE_ARRIVAL(String.valueOf("SEVEN_DAYS_BEFORE_ARRIVAL")),
    
    FOURTEEN_DAYS_BEFORE_ARRIVAL(String.valueOf("FOURTEEN_DAYS_BEFORE_ARRIVAL")),
    
    TWENTYONE_DAYS_BEFORE_ARRIVAL(String.valueOf("TWENTYONE_DAYS_BEFORE_ARRIVAL")),
    
    THIRTY_DAYS_BEFORE_ARRIVAL(String.valueOf("THIRTY_DAYS_BEFORE_ARRIVAL")),
    
    FOURTY_TWO_DAYS_BEFORE_ARRIVAL(String.valueOf("FOURTY_TWO_DAYS_BEFORE_ARRIVAL")),
    
    SIXTY_DAYS_BEFORE_ARRIVAL(String.valueOf("SIXTY_DAYS_BEFORE_ARRIVAL"));

    private String value;

    AdvanceCancellationFreeOfChargeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static AdvanceCancellationFreeOfChargeEnum fromValue(String value) {
      for (AdvanceCancellationFreeOfChargeEnum b : AdvanceCancellationFreeOfChargeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_ADVANCE_CANCELLATION_FREE_OF_CHARGE = "advanceCancellationFreeOfCharge";
  @jakarta.annotation.Nullable
  private AdvanceCancellationFreeOfChargeEnum advanceCancellationFreeOfCharge;

  /**
   * If advanceCancellationFreeOfCharge rules is not honored, this property explains what the guest will be charged.
   */
  public enum RefundableCancellationChargeEnum {
    FIRST_NIGHT(String.valueOf("FIRST_NIGHT")),
    
    THIRTY_PERCENT(String.valueOf("THIRTY_PERCENT")),
    
    FIFTY_PERCENT(String.valueOf("FIFTY_PERCENT")),
    
    SIXTY_PERCENT(String.valueOf("SIXTY_PERCENT")),
    
    SEVENTY_PERCENT(String.valueOf("SEVENTY_PERCENT")),
    
    NINENTY_PERCENT(String.valueOf("NINENTY_PERCENT")),
    
    ONE_HUNDRED_PERCENT(String.valueOf("ONE_HUNDRED_PERCENT"));

    private String value;

    RefundableCancellationChargeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static RefundableCancellationChargeEnum fromValue(String value) {
      for (RefundableCancellationChargeEnum b : RefundableCancellationChargeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_REFUNDABLE_CANCELLATION_CHARGE = "refundableCancellationCharge";
  @jakarta.annotation.Nullable
  private RefundableCancellationChargeEnum refundableCancellationCharge;

  /**
   * In case the &#39;Refundable cancellation charge&#39; is set, a different no show charge can be applied.
   */
  public enum NoShowChargeEnum {
    SAME_AS_CANCELLATION_FEE(String.valueOf("SAME_AS_CANCELLATION_FEE")),
    
    ONE_HUNDRED_PERCENT_OF_TOTAL_CHARGE(String.valueOf("ONE_HUNDRED_PERCENT_OF_TOTAL_CHARGE"));

    private String value;

    NoShowChargeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static NoShowChargeEnum fromValue(String value) {
      for (NoShowChargeEnum b : NoShowChargeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_NO_SHOW_CHARGE = "noShowCharge";
  @jakarta.annotation.Nullable
  private NoShowChargeEnum noShowCharge;

  /**
   * When the cancellation policy is non-refundable, this flag can be set and indicates there is more rules involved to calculate what the guest will owe in case of a cancellation.
   */
  public enum NonRefundableCancellationChargeEnum {
    FIRST_NIGHT(String.valueOf("FIRST_NIGHT")),
    
    TEN_PERCENT(String.valueOf("TEN_PERCENT")),
    
    THIRTY_PERCENT(String.valueOf("THIRTY_PERCENT")),
    
    FIFTY_PERCENT(String.valueOf("FIFTY_PERCENT")),
    
    SEVENTY_PERCENT(String.valueOf("SEVENTY_PERCENT"));

    private String value;

    NonRefundableCancellationChargeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static NonRefundableCancellationChargeEnum fromValue(String value) {
      for (NonRefundableCancellationChargeEnum b : NonRefundableCancellationChargeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_NON_REFUNDABLE_CANCELLATION_CHARGE = "nonRefundableCancellationCharge";
  @jakarta.annotation.Nullable
  private NonRefundableCancellationChargeEnum nonRefundableCancellationCharge;

  /**
   * The non-refundable charge might can have a deadline. If that deadline passes, the guest might be charged more.
   */
  public enum NonRefundableDeadlineEnum {
    ONE_DAY_BEFORE_ARRIVAL(String.valueOf("ONE_DAY_BEFORE_ARRIVAL")),
    
    TWO_DAYS_BEFORE_ARRIVAL(String.valueOf("TWO_DAYS_BEFORE_ARRIVAL")),
    
    THREE_DAYS_BEFORE_ARRIVAL(String.valueOf("THREE_DAYS_BEFORE_ARRIVAL")),
    
    FIVE_DAYS_BEFORE_ARRIVAL(String.valueOf("FIVE_DAYS_BEFORE_ARRIVAL")),
    
    SEVEN_DAYS_BEFORE_ARRIVAL(String.valueOf("SEVEN_DAYS_BEFORE_ARRIVAL")),
    
    FOURTEEN_DAYS_BEFORE_ARRIVAL(String.valueOf("FOURTEEN_DAYS_BEFORE_ARRIVAL")),
    
    TWENTYONE_DAYS_BEFORE_ARRIVAL(String.valueOf("TWENTYONE_DAYS_BEFORE_ARRIVAL")),
    
    THIRTY_DAYS_BEFORE_ARRIVAL(String.valueOf("THIRTY_DAYS_BEFORE_ARRIVAL")),
    
    FOURTY_TWO_DAYS_BEFORE_ARRIVAL(String.valueOf("FOURTY_TWO_DAYS_BEFORE_ARRIVAL")),
    
    SIXTY_DAYS_BEFORE_ARRIVAL(String.valueOf("SIXTY_DAYS_BEFORE_ARRIVAL"));

    private String value;

    NonRefundableDeadlineEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static NonRefundableDeadlineEnum fromValue(String value) {
      for (NonRefundableDeadlineEnum b : NonRefundableDeadlineEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_NON_REFUNDABLE_DEADLINE = "nonRefundableDeadline";
  @jakarta.annotation.Nullable
  private NonRefundableDeadlineEnum nonRefundableDeadline;

  /**
   * If the guest does not honor the non-refundable deadline rule, this charge dictates what she owes after the deadline passes.
   */
  public enum NonRefundableAfterDeadlineCancellationChargeEnum {
    FIRST_NIGHT(String.valueOf("FIRST_NIGHT")),
    
    TEN_PERCENT(String.valueOf("TEN_PERCENT")),
    
    THIRTY_PERCENT(String.valueOf("THIRTY_PERCENT")),
    
    FIFTY_PERCENT(String.valueOf("FIFTY_PERCENT")),
    
    SEVENTY_PERCENT(String.valueOf("SEVENTY_PERCENT")),
    
    ONE_HUNDRED_PERCENT(String.valueOf("ONE_HUNDRED_PERCENT"));

    private String value;

    NonRefundableAfterDeadlineCancellationChargeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static NonRefundableAfterDeadlineCancellationChargeEnum fromValue(String value) {
      for (NonRefundableAfterDeadlineCancellationChargeEnum b : NonRefundableAfterDeadlineCancellationChargeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_NON_REFUNDABLE_AFTER_DEADLINE_CANCELLATION_CHARGE = "nonRefundableAfterDeadlineCancellationCharge";
  @jakarta.annotation.Nullable
  private NonRefundableAfterDeadlineCancellationChargeEnum nonRefundableAfterDeadlineCancellationCharge;

  public static final String JSON_PROPERTY_POLICY_CODE = "policyCode";
  @jakarta.annotation.Nullable
  private String policyCode;

  public CancellationPolicyLightweightNonAuthenticatedEntity() {
  }

  public CancellationPolicyLightweightNonAuthenticatedEntity identifier(@jakarta.annotation.Nonnull UUID identifier) {
    
    this.identifier = identifier;
    return this;
  }

  /**
   * Unique cancellation policy identifier
   * @return identifier
   */
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getIdentifier() {
    return identifier;
  }


  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setIdentifier(@jakarta.annotation.Nonnull UUID identifier) {
    this.identifier = identifier;
  }

  public CancellationPolicyLightweightNonAuthenticatedEntity hotelIdentifier(@jakarta.annotation.Nonnull UUID hotelIdentifier) {
    
    this.hotelIdentifier = hotelIdentifier;
    return this;
  }

  /**
   * Property this cancellation is associated with
   * @return hotelIdentifier
   */
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_HOTEL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getHotelIdentifier() {
    return hotelIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_HOTEL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setHotelIdentifier(@jakarta.annotation.Nonnull UUID hotelIdentifier) {
    this.hotelIdentifier = hotelIdentifier;
  }

  public CancellationPolicyLightweightNonAuthenticatedEntity refundable(@jakarta.annotation.Nonnull Boolean refundable) {
    
    this.refundable = refundable;
    return this;
  }

  /**
   * Whether this cancellation policy is refundable or not
   * @return refundable
   */
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_REFUNDABLE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getRefundable() {
    return refundable;
  }


  @JsonProperty(JSON_PROPERTY_REFUNDABLE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRefundable(@jakarta.annotation.Nonnull Boolean refundable) {
    this.refundable = refundable;
  }

  public CancellationPolicyLightweightNonAuthenticatedEntity advanceCancellationFreeOfCharge(@jakarta.annotation.Nullable AdvanceCancellationFreeOfChargeEnum advanceCancellationFreeOfCharge) {
    
    this.advanceCancellationFreeOfCharge = advanceCancellationFreeOfCharge;
    return this;
  }

  /**
   * When the cancellation policy is refundable, this flag can be set and indicates there is more rules involved than just a no-questions-asked refundable.
   * @return advanceCancellationFreeOfCharge
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ADVANCE_CANCELLATION_FREE_OF_CHARGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public AdvanceCancellationFreeOfChargeEnum getAdvanceCancellationFreeOfCharge() {
    return advanceCancellationFreeOfCharge;
  }


  @JsonProperty(JSON_PROPERTY_ADVANCE_CANCELLATION_FREE_OF_CHARGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAdvanceCancellationFreeOfCharge(@jakarta.annotation.Nullable AdvanceCancellationFreeOfChargeEnum advanceCancellationFreeOfCharge) {
    this.advanceCancellationFreeOfCharge = advanceCancellationFreeOfCharge;
  }

  public CancellationPolicyLightweightNonAuthenticatedEntity refundableCancellationCharge(@jakarta.annotation.Nullable RefundableCancellationChargeEnum refundableCancellationCharge) {
    
    this.refundableCancellationCharge = refundableCancellationCharge;
    return this;
  }

  /**
   * If advanceCancellationFreeOfCharge rules is not honored, this property explains what the guest will be charged.
   * @return refundableCancellationCharge
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_REFUNDABLE_CANCELLATION_CHARGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public RefundableCancellationChargeEnum getRefundableCancellationCharge() {
    return refundableCancellationCharge;
  }


  @JsonProperty(JSON_PROPERTY_REFUNDABLE_CANCELLATION_CHARGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRefundableCancellationCharge(@jakarta.annotation.Nullable RefundableCancellationChargeEnum refundableCancellationCharge) {
    this.refundableCancellationCharge = refundableCancellationCharge;
  }

  public CancellationPolicyLightweightNonAuthenticatedEntity noShowCharge(@jakarta.annotation.Nullable NoShowChargeEnum noShowCharge) {
    
    this.noShowCharge = noShowCharge;
    return this;
  }

  /**
   * In case the &#39;Refundable cancellation charge&#39; is set, a different no show charge can be applied.
   * @return noShowCharge
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_NO_SHOW_CHARGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public NoShowChargeEnum getNoShowCharge() {
    return noShowCharge;
  }


  @JsonProperty(JSON_PROPERTY_NO_SHOW_CHARGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNoShowCharge(@jakarta.annotation.Nullable NoShowChargeEnum noShowCharge) {
    this.noShowCharge = noShowCharge;
  }

  public CancellationPolicyLightweightNonAuthenticatedEntity nonRefundableCancellationCharge(@jakarta.annotation.Nullable NonRefundableCancellationChargeEnum nonRefundableCancellationCharge) {
    
    this.nonRefundableCancellationCharge = nonRefundableCancellationCharge;
    return this;
  }

  /**
   * When the cancellation policy is non-refundable, this flag can be set and indicates there is more rules involved to calculate what the guest will owe in case of a cancellation.
   * @return nonRefundableCancellationCharge
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_NON_REFUNDABLE_CANCELLATION_CHARGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public NonRefundableCancellationChargeEnum getNonRefundableCancellationCharge() {
    return nonRefundableCancellationCharge;
  }


  @JsonProperty(JSON_PROPERTY_NON_REFUNDABLE_CANCELLATION_CHARGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNonRefundableCancellationCharge(@jakarta.annotation.Nullable NonRefundableCancellationChargeEnum nonRefundableCancellationCharge) {
    this.nonRefundableCancellationCharge = nonRefundableCancellationCharge;
  }

  public CancellationPolicyLightweightNonAuthenticatedEntity nonRefundableDeadline(@jakarta.annotation.Nullable NonRefundableDeadlineEnum nonRefundableDeadline) {
    
    this.nonRefundableDeadline = nonRefundableDeadline;
    return this;
  }

  /**
   * The non-refundable charge might can have a deadline. If that deadline passes, the guest might be charged more.
   * @return nonRefundableDeadline
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_NON_REFUNDABLE_DEADLINE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public NonRefundableDeadlineEnum getNonRefundableDeadline() {
    return nonRefundableDeadline;
  }


  @JsonProperty(JSON_PROPERTY_NON_REFUNDABLE_DEADLINE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNonRefundableDeadline(@jakarta.annotation.Nullable NonRefundableDeadlineEnum nonRefundableDeadline) {
    this.nonRefundableDeadline = nonRefundableDeadline;
  }

  public CancellationPolicyLightweightNonAuthenticatedEntity nonRefundableAfterDeadlineCancellationCharge(@jakarta.annotation.Nullable NonRefundableAfterDeadlineCancellationChargeEnum nonRefundableAfterDeadlineCancellationCharge) {
    
    this.nonRefundableAfterDeadlineCancellationCharge = nonRefundableAfterDeadlineCancellationCharge;
    return this;
  }

  /**
   * If the guest does not honor the non-refundable deadline rule, this charge dictates what she owes after the deadline passes.
   * @return nonRefundableAfterDeadlineCancellationCharge
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_NON_REFUNDABLE_AFTER_DEADLINE_CANCELLATION_CHARGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public NonRefundableAfterDeadlineCancellationChargeEnum getNonRefundableAfterDeadlineCancellationCharge() {
    return nonRefundableAfterDeadlineCancellationCharge;
  }


  @JsonProperty(JSON_PROPERTY_NON_REFUNDABLE_AFTER_DEADLINE_CANCELLATION_CHARGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNonRefundableAfterDeadlineCancellationCharge(@jakarta.annotation.Nullable NonRefundableAfterDeadlineCancellationChargeEnum nonRefundableAfterDeadlineCancellationCharge) {
    this.nonRefundableAfterDeadlineCancellationCharge = nonRefundableAfterDeadlineCancellationCharge;
  }

  public CancellationPolicyLightweightNonAuthenticatedEntity policyCode(@jakarta.annotation.Nullable String policyCode) {
    
    this.policyCode = policyCode;
    return this;
  }

  /**
   * Get policyCode
   * @return policyCode
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_POLICY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPolicyCode() {
    return policyCode;
  }


  @JsonProperty(JSON_PROPERTY_POLICY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPolicyCode(@jakarta.annotation.Nullable String policyCode) {
    this.policyCode = policyCode;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CancellationPolicyLightweightNonAuthenticatedEntity cancellationPolicyLightweightNonAuthenticatedEntity = (CancellationPolicyLightweightNonAuthenticatedEntity) o;
    return Objects.equals(this.identifier, cancellationPolicyLightweightNonAuthenticatedEntity.identifier) &&
        Objects.equals(this.hotelIdentifier, cancellationPolicyLightweightNonAuthenticatedEntity.hotelIdentifier) &&
        Objects.equals(this.refundable, cancellationPolicyLightweightNonAuthenticatedEntity.refundable) &&
        Objects.equals(this.advanceCancellationFreeOfCharge, cancellationPolicyLightweightNonAuthenticatedEntity.advanceCancellationFreeOfCharge) &&
        Objects.equals(this.refundableCancellationCharge, cancellationPolicyLightweightNonAuthenticatedEntity.refundableCancellationCharge) &&
        Objects.equals(this.noShowCharge, cancellationPolicyLightweightNonAuthenticatedEntity.noShowCharge) &&
        Objects.equals(this.nonRefundableCancellationCharge, cancellationPolicyLightweightNonAuthenticatedEntity.nonRefundableCancellationCharge) &&
        Objects.equals(this.nonRefundableDeadline, cancellationPolicyLightweightNonAuthenticatedEntity.nonRefundableDeadline) &&
        Objects.equals(this.nonRefundableAfterDeadlineCancellationCharge, cancellationPolicyLightweightNonAuthenticatedEntity.nonRefundableAfterDeadlineCancellationCharge) &&
        Objects.equals(this.policyCode, cancellationPolicyLightweightNonAuthenticatedEntity.policyCode);
  }

  @Override
  public int hashCode() {
    return Objects.hash(identifier, hotelIdentifier, refundable, advanceCancellationFreeOfCharge, refundableCancellationCharge, noShowCharge, nonRefundableCancellationCharge, nonRefundableDeadline, nonRefundableAfterDeadlineCancellationCharge, policyCode);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CancellationPolicyLightweightNonAuthenticatedEntity {\n");
    sb.append("    identifier: ").append(toIndentedString(identifier)).append("\n");
    sb.append("    hotelIdentifier: ").append(toIndentedString(hotelIdentifier)).append("\n");
    sb.append("    refundable: ").append(toIndentedString(refundable)).append("\n");
    sb.append("    advanceCancellationFreeOfCharge: ").append(toIndentedString(advanceCancellationFreeOfCharge)).append("\n");
    sb.append("    refundableCancellationCharge: ").append(toIndentedString(refundableCancellationCharge)).append("\n");
    sb.append("    noShowCharge: ").append(toIndentedString(noShowCharge)).append("\n");
    sb.append("    nonRefundableCancellationCharge: ").append(toIndentedString(nonRefundableCancellationCharge)).append("\n");
    sb.append("    nonRefundableDeadline: ").append(toIndentedString(nonRefundableDeadline)).append("\n");
    sb.append("    nonRefundableAfterDeadlineCancellationCharge: ").append(toIndentedString(nonRefundableAfterDeadlineCancellationCharge)).append("\n");
    sb.append("    policyCode: ").append(toIndentedString(policyCode)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

