/*
 * Wink API
 *  # Introduction  Welcome to the Wink API - A programmer-friendly way to manage, sell and book travel inventory on the Wink platform. The API gives you all the tools you need to ready your properties and inventory for sale across 1000s of our native sales channels.  Integrators, affiliates, travel agents and content creators have the ability search for your travel inventory and promote / sell it in a wide variety of ways.   # Integrations  We have already integrated with the most well-known channel managers so you don't have to. To see our current integrations, please go to https://extranet.wink.travel and scroll to Connectivity section. Once your properties are set up, you can finish the setup by mapping your property to Wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API.   # Intended Audience  Programmers are [most likely] a requirement to start integrating with Wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible.  - Hotel chains  - Hotel brands  - Travel tech companies  - Destination sites  - Integrators  - Aggregators  - Destination management companies  - Travel agencies  - OTAs   ## APIs  Not every integrator needs every API. For that reason, we have separated APIs into context.  ### Test API   - [Ping](/ping): The Ping API is a quick test endpoint to verify that your credentials work Wink.  ### Common APIs  - [Notifications](/notifications): The Notifications API is a way for us to stay in touch with your user, property or affiliate account. - [User Settings](/user-settings): The User Settings API exposes endpoints to allow 3rd party integrators to communicate with Wink.  ### Consume APIs Consume endpoints are for developers who want to find existing travel inventory and either book it or use it to advertise through one of their Wink affiliate accounts.   - [Configuration](/customization-client): A single endpoint to retrieve whitelabel + customization information for the booking customization.  - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags.  - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API..  - [Booking](/booking): All APIs related to creating bookings on the platform.  - [Travel Agent](/travel-agent): The Travel Agent API exposes endpoints to manage agent-facilitated bookings.   ### Produce APIs  Produce endpoints are for developers who want to create and manage travel inventory.   #### Property  - [Property registration](/extranet/property/register): As a producer, this is, oftentimes, where you start your journey. These endpoints let you create properties on Wink.  - [Property](/extranet/property): This collection of property endpoints are mostly management endpoints that let you display, change status and similar for your existing properties.  - [Facilities](/extranet/facilities): This collection of endpoints let you manage facilities; such as room types.  - [Experiences](/extranet/experiences): This collection of endpoints let you manage experiences, such as activities.  - [Monetize](/extranet/monetize): The Monetize API exposes endpoints for managing cancellation polies, rate plans, promotions and more on Wink.  - [Distribution](/extranet/distribution): The Distribution API exposes endpoints for sales channels, connecting with affiliates, managing rates and inventory calendars and more on Wink.  - [Property Booking](/extranet/booking): The Property Booking API exposes endpoints for managing bookings and reviews at the property-level.   #### Affiliate  - [Affiliate](/affiliate): This collection of affiliate endpoints are mostly management endpoints that let you display, change status and similar for your existing accounts.  - [Browse](/affiliate/browse): The Browse API exposes endpoints for affiliates to find suppliers and inventory to sell.  - [Inventory](/affiliate/inventory): The Inventory API exposes endpoints for affiliates to manage the inventory they want to sell and how they want to sell it.  - [Sales Channel](/affiliate/sales-channel): The Sales Channel API exposes endpoints for affiliates to manage existing sales channels as well as find new ones.  - [WinkLinks](/affiliate/winklinks): The WinkLinks API exposes endpoints for affiliates to manage their WinkLinks page.   #### Rate provider  - [Channel manager](/channel-manager): The Channel Manager API enables external channel manager partners to map, exchange rate / availability information with us as well as be informed of bookings that occur on the Wink platform for one of their properties.   ### Taxonomy APIs  Taxonomy endpoints are for developers who want to consume and produce travel inventory and need taxonomies of standard and non-standard codes for inventory types, classes, statuses etc.   - [Reference](/reactive): All APIs related to retrieving platform-supported taxonomies.   ### Insight APIs  Insight endpoints do exactly what the name implies - They offer platform-level insight into the activities of producers and consumers.   - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics.   ### Payment APIs  Payment endpoints are for developers who want to purchase travel inventory. This can be done via the API as a registered Travel Agent or using our API in conjunction with our PCI compliant reactive widget for all other entities.   - [TripPay](/reactive): All APIs related to TripPay account management, booking, mapping and integration features.   ## SDKs  We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).   - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)   ## Usage  These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.   ## Versioning  We chose to version our endpoints in a way that we hope affects your integration minimally. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.   ## Release history  - Follow updates on Github: https://github.com/wink-travel/wink-sdk-java/blob/master/CHANGELOG.md    # Inventory API The Inventory API exposes endpoints to retrieve inventory you already know about. This API lets you:  1. Consume shareable links. 2. Load up a known property with availability. 3. Load up all inventories that were created by our affiliates such as grids, maps, and individual items.  Browse the endpoints in the left navigation bar to get started.  
 *
 * The version of the OpenAPI document: 30.17.8
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.inventory.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import travel.wink.sdk.inventory.model.ItineraryNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.SellerMediaNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.SellerUrlPriceNonAuthenticatedEntity;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * ConsumableSellerUrlNonAuthenticatedEntity
 */
@JsonPropertyOrder({
  ConsumableSellerUrlNonAuthenticatedEntity.JSON_PROPERTY_LANGUAGE,
  ConsumableSellerUrlNonAuthenticatedEntity.JSON_PROPERTY_CURRENCY,
  ConsumableSellerUrlNonAuthenticatedEntity.JSON_PROPERTY_TITLE,
  ConsumableSellerUrlNonAuthenticatedEntity.JSON_PROPERTY_DESCRIPTION,
  ConsumableSellerUrlNonAuthenticatedEntity.JSON_PROPERTY_KEYWORDS,
  ConsumableSellerUrlNonAuthenticatedEntity.JSON_PROPERTY_UNIQUE_ID,
  ConsumableSellerUrlNonAuthenticatedEntity.JSON_PROPERTY_TWITTER_ACCOUNT,
  ConsumableSellerUrlNonAuthenticatedEntity.JSON_PROPERTY_FACEBOOK_APP_ID,
  ConsumableSellerUrlNonAuthenticatedEntity.JSON_PROPERTY_IMAGE,
  ConsumableSellerUrlNonAuthenticatedEntity.JSON_PROPERTY_VIDEO,
  ConsumableSellerUrlNonAuthenticatedEntity.JSON_PROPERTY_TRANSACT_URL,
  ConsumableSellerUrlNonAuthenticatedEntity.JSON_PROPERTY_SUPPLIER_IDENTIFIER,
  ConsumableSellerUrlNonAuthenticatedEntity.JSON_PROPERTY_SUPPLIER_NAME,
  ConsumableSellerUrlNonAuthenticatedEntity.JSON_PROPERTY_SUPPLIER_URL_NAME,
  ConsumableSellerUrlNonAuthenticatedEntity.JSON_PROPERTY_SUPPLIER_BRAND,
  ConsumableSellerUrlNonAuthenticatedEntity.JSON_PROPERTY_AVAILABLE,
  ConsumableSellerUrlNonAuthenticatedEntity.JSON_PROPERTY_PRICE,
  ConsumableSellerUrlNonAuthenticatedEntity.JSON_PROPERTY_CITY_NAME,
  ConsumableSellerUrlNonAuthenticatedEntity.JSON_PROPERTY_COUNTRY_NAME,
  ConsumableSellerUrlNonAuthenticatedEntity.JSON_PROPERTY_INVENTORY_TYPE,
  ConsumableSellerUrlNonAuthenticatedEntity.JSON_PROPERTY_ITINERARY
})
@JsonTypeName("ConsumableSellerUrl_Non_Authenticated_Entity")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-06-26T20:20:31.141212618+07:00[Asia/Bangkok]", comments = "Generator version: 7.13.0")
public class ConsumableSellerUrlNonAuthenticatedEntity {
  public static final String JSON_PROPERTY_LANGUAGE = "language";
  @jakarta.annotation.Nullable
  private String language = "en";

  public static final String JSON_PROPERTY_CURRENCY = "currency";
  @jakarta.annotation.Nullable
  private String currency = "USD";

  public static final String JSON_PROPERTY_TITLE = "title";
  @jakarta.annotation.Nullable
  private String title;

  public static final String JSON_PROPERTY_DESCRIPTION = "description";
  @jakarta.annotation.Nullable
  private String description;

  public static final String JSON_PROPERTY_KEYWORDS = "keywords";
  @jakarta.annotation.Nullable
  private String keywords;

  public static final String JSON_PROPERTY_UNIQUE_ID = "uniqueId";
  @jakarta.annotation.Nullable
  private String uniqueId;

  public static final String JSON_PROPERTY_TWITTER_ACCOUNT = "twitterAccount";
  @jakarta.annotation.Nullable
  private String twitterAccount;

  public static final String JSON_PROPERTY_FACEBOOK_APP_ID = "facebookAppId";
  @jakarta.annotation.Nullable
  private String facebookAppId;

  public static final String JSON_PROPERTY_IMAGE = "image";
  @jakarta.annotation.Nullable
  private SellerMediaNonAuthenticatedEntity image;

  public static final String JSON_PROPERTY_VIDEO = "video";
  @jakarta.annotation.Nullable
  private SellerMediaNonAuthenticatedEntity video;

  public static final String JSON_PROPERTY_TRANSACT_URL = "transactUrl";
  @jakarta.annotation.Nullable
  private String transactUrl;

  public static final String JSON_PROPERTY_SUPPLIER_IDENTIFIER = "supplierIdentifier";
  @jakarta.annotation.Nullable
  private String supplierIdentifier;

  public static final String JSON_PROPERTY_SUPPLIER_NAME = "supplierName";
  @jakarta.annotation.Nullable
  private String supplierName;

  public static final String JSON_PROPERTY_SUPPLIER_URL_NAME = "supplierUrlName";
  @jakarta.annotation.Nullable
  private String supplierUrlName;

  public static final String JSON_PROPERTY_SUPPLIER_BRAND = "supplierBrand";
  @jakarta.annotation.Nullable
  private String supplierBrand;

  public static final String JSON_PROPERTY_AVAILABLE = "available";
  @jakarta.annotation.Nullable
  private Boolean available;

  public static final String JSON_PROPERTY_PRICE = "price";
  @jakarta.annotation.Nullable
  private SellerUrlPriceNonAuthenticatedEntity price;

  public static final String JSON_PROPERTY_CITY_NAME = "cityName";
  @jakarta.annotation.Nullable
  private String cityName;

  public static final String JSON_PROPERTY_COUNTRY_NAME = "countryName";
  @jakarta.annotation.Nullable
  private String countryName;

  /**
   * Type of inventory
   */
  public enum InventoryTypeEnum {
    HOTEL(String.valueOf("HOTEL")),
    
    GUEST_ROOM(String.valueOf("GUEST_ROOM")),
    
    MEETING_ROOM(String.valueOf("MEETING_ROOM")),
    
    RESTAURANT(String.valueOf("RESTAURANT")),
    
    SPA(String.valueOf("SPA")),
    
    ADD_ON(String.valueOf("ADD_ON")),
    
    ATTRACTION(String.valueOf("ATTRACTION")),
    
    ACTIVITY(String.valueOf("ACTIVITY")),
    
    PLACE(String.valueOf("PLACE"));

    private String value;

    InventoryTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static InventoryTypeEnum fromValue(String value) {
      for (InventoryTypeEnum b : InventoryTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_INVENTORY_TYPE = "inventoryType";
  @jakarta.annotation.Nullable
  private InventoryTypeEnum inventoryType;

  public static final String JSON_PROPERTY_ITINERARY = "itinerary";
  @jakarta.annotation.Nonnull
  private ItineraryNonAuthenticatedEntity itinerary;

  public ConsumableSellerUrlNonAuthenticatedEntity() {
  }

  public ConsumableSellerUrlNonAuthenticatedEntity language(@jakarta.annotation.Nullable String language) {
    
    this.language = language;
    return this;
  }

  /**
   * Which language the seller wanted to use
   * @return language
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_LANGUAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getLanguage() {
    return language;
  }


  @JsonProperty(JSON_PROPERTY_LANGUAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLanguage(@jakarta.annotation.Nullable String language) {
    this.language = language;
  }

  public ConsumableSellerUrlNonAuthenticatedEntity currency(@jakarta.annotation.Nullable String currency) {
    
    this.currency = currency;
    return this;
  }

  /**
   * Which currency the seller is using
   * @return currency
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCurrency() {
    return currency;
  }


  @JsonProperty(JSON_PROPERTY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCurrency(@jakarta.annotation.Nullable String currency) {
    this.currency = currency;
  }

  public ConsumableSellerUrlNonAuthenticatedEntity title(@jakarta.annotation.Nullable String title) {
    
    this.title = title;
    return this;
  }

  /**
   * Link title
   * @return title
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TITLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTitle() {
    return title;
  }


  @JsonProperty(JSON_PROPERTY_TITLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTitle(@jakarta.annotation.Nullable String title) {
    this.title = title;
  }

  public ConsumableSellerUrlNonAuthenticatedEntity description(@jakarta.annotation.Nullable String description) {
    
    this.description = description;
    return this;
  }

  /**
   * Link description
   * @return description
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDescription() {
    return description;
  }


  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDescription(@jakarta.annotation.Nullable String description) {
    this.description = description;
  }

  public ConsumableSellerUrlNonAuthenticatedEntity keywords(@jakarta.annotation.Nullable String keywords) {
    
    this.keywords = keywords;
    return this;
  }

  /**
   * Comma-separated keyword values that can be used to populate HTML metadata
   * @return keywords
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_KEYWORDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getKeywords() {
    return keywords;
  }


  @JsonProperty(JSON_PROPERTY_KEYWORDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setKeywords(@jakarta.annotation.Nullable String keywords) {
    this.keywords = keywords;
  }

  public ConsumableSellerUrlNonAuthenticatedEntity uniqueId(@jakarta.annotation.Nullable String uniqueId) {
    
    this.uniqueId = uniqueId;
    return this;
  }

  /**
   * The URL ID that uniquely represents this link
   * @return uniqueId
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_UNIQUE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getUniqueId() {
    return uniqueId;
  }


  @JsonProperty(JSON_PROPERTY_UNIQUE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUniqueId(@jakarta.annotation.Nullable String uniqueId) {
    this.uniqueId = uniqueId;
  }

  public ConsumableSellerUrlNonAuthenticatedEntity twitterAccount(@jakarta.annotation.Nullable String twitterAccount) {
    
    this.twitterAccount = twitterAccount;
    return this;
  }

  /**
   * Optional X account ID
   * @return twitterAccount
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TWITTER_ACCOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTwitterAccount() {
    return twitterAccount;
  }


  @JsonProperty(JSON_PROPERTY_TWITTER_ACCOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTwitterAccount(@jakarta.annotation.Nullable String twitterAccount) {
    this.twitterAccount = twitterAccount;
  }

  public ConsumableSellerUrlNonAuthenticatedEntity facebookAppId(@jakarta.annotation.Nullable String facebookAppId) {
    
    this.facebookAppId = facebookAppId;
    return this;
  }

  /**
   * Optional Facebook app ID
   * @return facebookAppId
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_FACEBOOK_APP_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFacebookAppId() {
    return facebookAppId;
  }


  @JsonProperty(JSON_PROPERTY_FACEBOOK_APP_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFacebookAppId(@jakarta.annotation.Nullable String facebookAppId) {
    this.facebookAppId = facebookAppId;
  }

  public ConsumableSellerUrlNonAuthenticatedEntity image(@jakarta.annotation.Nullable SellerMediaNonAuthenticatedEntity image) {
    
    this.image = image;
    return this;
  }

  /**
   * The image you want to accompany this link
   * @return image
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_IMAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public SellerMediaNonAuthenticatedEntity getImage() {
    return image;
  }


  @JsonProperty(JSON_PROPERTY_IMAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setImage(@jakarta.annotation.Nullable SellerMediaNonAuthenticatedEntity image) {
    this.image = image;
  }

  public ConsumableSellerUrlNonAuthenticatedEntity video(@jakarta.annotation.Nullable SellerMediaNonAuthenticatedEntity video) {
    
    this.video = video;
    return this;
  }

  /**
   * The video you want to accompany this link
   * @return video
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_VIDEO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public SellerMediaNonAuthenticatedEntity getVideo() {
    return video;
  }


  @JsonProperty(JSON_PROPERTY_VIDEO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVideo(@jakarta.annotation.Nullable SellerMediaNonAuthenticatedEntity video) {
    this.video = video;
  }

  public ConsumableSellerUrlNonAuthenticatedEntity transactUrl(@jakarta.annotation.Nullable String transactUrl) {
    
    this.transactUrl = transactUrl;
    return this;
  }

  /**
   * The transation url, or where to redirect to when clicking the CTA button.
   * @return transactUrl
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TRANSACT_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTransactUrl() {
    return transactUrl;
  }


  @JsonProperty(JSON_PROPERTY_TRANSACT_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTransactUrl(@jakarta.annotation.Nullable String transactUrl) {
    this.transactUrl = transactUrl;
  }

  public ConsumableSellerUrlNonAuthenticatedEntity supplierIdentifier(@jakarta.annotation.Nullable String supplierIdentifier) {
    
    this.supplierIdentifier = supplierIdentifier;
    return this;
  }

  /**
   * The owner ID of the inventory you want to sell
   * @return supplierIdentifier
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SUPPLIER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSupplierIdentifier() {
    return supplierIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_SUPPLIER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSupplierIdentifier(@jakarta.annotation.Nullable String supplierIdentifier) {
    this.supplierIdentifier = supplierIdentifier;
  }

  public ConsumableSellerUrlNonAuthenticatedEntity supplierName(@jakarta.annotation.Nullable String supplierName) {
    
    this.supplierName = supplierName;
    return this;
  }

  /**
   * The owner name of the inventory you want to sell
   * @return supplierName
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SUPPLIER_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSupplierName() {
    return supplierName;
  }


  @JsonProperty(JSON_PROPERTY_SUPPLIER_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSupplierName(@jakarta.annotation.Nullable String supplierName) {
    this.supplierName = supplierName;
  }

  public ConsumableSellerUrlNonAuthenticatedEntity supplierUrlName(@jakarta.annotation.Nullable String supplierUrlName) {
    
    this.supplierUrlName = supplierUrlName;
    return this;
  }

  /**
   * The owner url name of the inventory you want to sell
   * @return supplierUrlName
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SUPPLIER_URL_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSupplierUrlName() {
    return supplierUrlName;
  }


  @JsonProperty(JSON_PROPERTY_SUPPLIER_URL_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSupplierUrlName(@jakarta.annotation.Nullable String supplierUrlName) {
    this.supplierUrlName = supplierUrlName;
  }

  public ConsumableSellerUrlNonAuthenticatedEntity supplierBrand(@jakarta.annotation.Nullable String supplierBrand) {
    
    this.supplierBrand = supplierBrand;
    return this;
  }

  /**
   * In case the property is part of a brand
   * @return supplierBrand
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SUPPLIER_BRAND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSupplierBrand() {
    return supplierBrand;
  }


  @JsonProperty(JSON_PROPERTY_SUPPLIER_BRAND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSupplierBrand(@jakarta.annotation.Nullable String supplierBrand) {
    this.supplierBrand = supplierBrand;
  }

  public ConsumableSellerUrlNonAuthenticatedEntity available(@jakarta.annotation.Nullable Boolean available) {
    
    this.available = available;
    return this;
  }

  /**
   * Whether inventory is available for sale
   * @return available
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_AVAILABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getAvailable() {
    return available;
  }


  @JsonProperty(JSON_PROPERTY_AVAILABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAvailable(@jakarta.annotation.Nullable Boolean available) {
    this.available = available;
  }

  public ConsumableSellerUrlNonAuthenticatedEntity price(@jakarta.annotation.Nullable SellerUrlPriceNonAuthenticatedEntity price) {
    
    this.price = price;
    return this;
  }

  /**
   * Get price
   * @return price
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public SellerUrlPriceNonAuthenticatedEntity getPrice() {
    return price;
  }


  @JsonProperty(JSON_PROPERTY_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPrice(@jakarta.annotation.Nullable SellerUrlPriceNonAuthenticatedEntity price) {
    this.price = price;
  }

  public ConsumableSellerUrlNonAuthenticatedEntity cityName(@jakarta.annotation.Nullable String cityName) {
    
    this.cityName = cityName;
    return this;
  }

  /**
   * City where inventory is located
   * @return cityName
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CITY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCityName() {
    return cityName;
  }


  @JsonProperty(JSON_PROPERTY_CITY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCityName(@jakarta.annotation.Nullable String cityName) {
    this.cityName = cityName;
  }

  public ConsumableSellerUrlNonAuthenticatedEntity countryName(@jakarta.annotation.Nullable String countryName) {
    
    this.countryName = countryName;
    return this;
  }

  /**
   * Country where inventory is located
   * @return countryName
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_COUNTRY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCountryName() {
    return countryName;
  }


  @JsonProperty(JSON_PROPERTY_COUNTRY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCountryName(@jakarta.annotation.Nullable String countryName) {
    this.countryName = countryName;
  }

  public ConsumableSellerUrlNonAuthenticatedEntity inventoryType(@jakarta.annotation.Nullable InventoryTypeEnum inventoryType) {
    
    this.inventoryType = inventoryType;
    return this;
  }

  /**
   * Type of inventory
   * @return inventoryType
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_INVENTORY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public InventoryTypeEnum getInventoryType() {
    return inventoryType;
  }


  @JsonProperty(JSON_PROPERTY_INVENTORY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInventoryType(@jakarta.annotation.Nullable InventoryTypeEnum inventoryType) {
    this.inventoryType = inventoryType;
  }

  public ConsumableSellerUrlNonAuthenticatedEntity itinerary(@jakarta.annotation.Nonnull ItineraryNonAuthenticatedEntity itinerary) {
    
    this.itinerary = itinerary;
    return this;
  }

  /**
   * Dates and travel info.
   * @return itinerary
   */
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_ITINERARY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public ItineraryNonAuthenticatedEntity getItinerary() {
    return itinerary;
  }


  @JsonProperty(JSON_PROPERTY_ITINERARY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setItinerary(@jakarta.annotation.Nonnull ItineraryNonAuthenticatedEntity itinerary) {
    this.itinerary = itinerary;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ConsumableSellerUrlNonAuthenticatedEntity consumableSellerUrlNonAuthenticatedEntity = (ConsumableSellerUrlNonAuthenticatedEntity) o;
    return Objects.equals(this.language, consumableSellerUrlNonAuthenticatedEntity.language) &&
        Objects.equals(this.currency, consumableSellerUrlNonAuthenticatedEntity.currency) &&
        Objects.equals(this.title, consumableSellerUrlNonAuthenticatedEntity.title) &&
        Objects.equals(this.description, consumableSellerUrlNonAuthenticatedEntity.description) &&
        Objects.equals(this.keywords, consumableSellerUrlNonAuthenticatedEntity.keywords) &&
        Objects.equals(this.uniqueId, consumableSellerUrlNonAuthenticatedEntity.uniqueId) &&
        Objects.equals(this.twitterAccount, consumableSellerUrlNonAuthenticatedEntity.twitterAccount) &&
        Objects.equals(this.facebookAppId, consumableSellerUrlNonAuthenticatedEntity.facebookAppId) &&
        Objects.equals(this.image, consumableSellerUrlNonAuthenticatedEntity.image) &&
        Objects.equals(this.video, consumableSellerUrlNonAuthenticatedEntity.video) &&
        Objects.equals(this.transactUrl, consumableSellerUrlNonAuthenticatedEntity.transactUrl) &&
        Objects.equals(this.supplierIdentifier, consumableSellerUrlNonAuthenticatedEntity.supplierIdentifier) &&
        Objects.equals(this.supplierName, consumableSellerUrlNonAuthenticatedEntity.supplierName) &&
        Objects.equals(this.supplierUrlName, consumableSellerUrlNonAuthenticatedEntity.supplierUrlName) &&
        Objects.equals(this.supplierBrand, consumableSellerUrlNonAuthenticatedEntity.supplierBrand) &&
        Objects.equals(this.available, consumableSellerUrlNonAuthenticatedEntity.available) &&
        Objects.equals(this.price, consumableSellerUrlNonAuthenticatedEntity.price) &&
        Objects.equals(this.cityName, consumableSellerUrlNonAuthenticatedEntity.cityName) &&
        Objects.equals(this.countryName, consumableSellerUrlNonAuthenticatedEntity.countryName) &&
        Objects.equals(this.inventoryType, consumableSellerUrlNonAuthenticatedEntity.inventoryType) &&
        Objects.equals(this.itinerary, consumableSellerUrlNonAuthenticatedEntity.itinerary);
  }

  @Override
  public int hashCode() {
    return Objects.hash(language, currency, title, description, keywords, uniqueId, twitterAccount, facebookAppId, image, video, transactUrl, supplierIdentifier, supplierName, supplierUrlName, supplierBrand, available, price, cityName, countryName, inventoryType, itinerary);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ConsumableSellerUrlNonAuthenticatedEntity {\n");
    sb.append("    language: ").append(toIndentedString(language)).append("\n");
    sb.append("    currency: ").append(toIndentedString(currency)).append("\n");
    sb.append("    title: ").append(toIndentedString(title)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    keywords: ").append(toIndentedString(keywords)).append("\n");
    sb.append("    uniqueId: ").append(toIndentedString(uniqueId)).append("\n");
    sb.append("    twitterAccount: ").append(toIndentedString(twitterAccount)).append("\n");
    sb.append("    facebookAppId: ").append(toIndentedString(facebookAppId)).append("\n");
    sb.append("    image: ").append(toIndentedString(image)).append("\n");
    sb.append("    video: ").append(toIndentedString(video)).append("\n");
    sb.append("    transactUrl: ").append(toIndentedString(transactUrl)).append("\n");
    sb.append("    supplierIdentifier: ").append(toIndentedString(supplierIdentifier)).append("\n");
    sb.append("    supplierName: ").append(toIndentedString(supplierName)).append("\n");
    sb.append("    supplierUrlName: ").append(toIndentedString(supplierUrlName)).append("\n");
    sb.append("    supplierBrand: ").append(toIndentedString(supplierBrand)).append("\n");
    sb.append("    available: ").append(toIndentedString(available)).append("\n");
    sb.append("    price: ").append(toIndentedString(price)).append("\n");
    sb.append("    cityName: ").append(toIndentedString(cityName)).append("\n");
    sb.append("    countryName: ").append(toIndentedString(countryName)).append("\n");
    sb.append("    inventoryType: ").append(toIndentedString(inventoryType)).append("\n");
    sb.append("    itinerary: ").append(toIndentedString(itinerary)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

