/*
 * Wink API
 *  # Introduction  Welcome to the Wink API - A programmer-friendly way to manage, sell and book travel inventory on the Wink platform. The API gives you all the tools you need to ready your properties and inventory for sale across 1000s of our native sales channels.  Integrators, affiliates, travel agents and content creators have the ability search for your travel inventory and promote / sell it in a wide variety of ways.   # Integrations  We have already integrated with the most well-known channel managers so you don't have to. To see our current integrations, please go to https://extranet.wink.travel and scroll to Connectivity section. Once your properties are set up, you can finish the setup by mapping your property to Wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API.   # Intended Audience  Programmers are [most likely] a requirement to start integrating with Wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible.  - Hotel chains  - Hotel brands  - Travel tech companies  - Destination sites  - Integrators  - Aggregators  - Destination management companies  - Travel agencies  - OTAs   ## APIs  Not every integrator needs every API. For that reason, we have separated APIs into context.  ### Test API   - [Ping](/ping): The Ping API is a quick test endpoint to verify that your credentials work Wink.  ### Common APIs  - [Notifications](/notifications): The Notifications API is a way for us to stay in touch with your user, property or affiliate account. - [User Settings](/user-settings): The User Settings API exposes endpoints to allow 3rd party integrators to communicate with Wink.  ### Consume APIs Consume endpoints are for developers who want to find existing travel inventory and either book it or use it to advertise through one of their Wink affiliate accounts.   - [Configuration](/customization-client): A single endpoint to retrieve whitelabel + customization information for the booking customization.  - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags.  - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API..  - [Booking](/booking): All APIs related to creating bookings on the platform.  - [Travel Agent](/travel-agent): The Travel Agent API exposes endpoints to manage agent-facilitated bookings.   ### Produce APIs  Produce endpoints are for developers who want to create and manage travel inventory.   #### Property  - [Property registration](/extranet/property/register): As a producer, this is, oftentimes, where you start your journey. These endpoints let you create properties on Wink.  - [Property](/extranet/property): This collection of property endpoints are mostly management endpoints that let you display, change status and similar for your existing properties.  - [Facilities](/extranet/facilities): This collection of endpoints let you manage facilities; such as room types.  - [Experiences](/extranet/experiences): This collection of endpoints let you manage experiences, such as activities.  - [Monetize](/extranet/monetize): The Monetize API exposes endpoints for managing cancellation polies, rate plans, promotions and more on Wink.  - [Distribution](/extranet/distribution): The Distribution API exposes endpoints for sales channels, connecting with affiliates, managing rates and inventory calendars and more on Wink.  - [Property Booking](/extranet/booking): The Property Booking API exposes endpoints for managing bookings and reviews at the property-level.   #### Affiliate  - [Affiliate](/affiliate): This collection of affiliate endpoints are mostly management endpoints that let you display, change status and similar for your existing accounts.  - [Browse](/affiliate/browse): The Browse API exposes endpoints for affiliates to find suppliers and inventory to sell.  - [Inventory](/affiliate/inventory): The Inventory API exposes endpoints for affiliates to manage the inventory they want to sell and how they want to sell it.  - [Sales Channel](/affiliate/sales-channel): The Sales Channel API exposes endpoints for affiliates to manage existing sales channels as well as find new ones.  - [WinkLinks](/affiliate/winklinks): The WinkLinks API exposes endpoints for affiliates to manage their WinkLinks page.   #### Rate provider  - [Channel manager](/channel-manager): The Channel Manager API enables external channel manager partners to map, exchange rate / availability information with us as well as be informed of bookings that occur on the Wink platform for one of their properties.   ### Taxonomy APIs  Taxonomy endpoints are for developers who want to consume and produce travel inventory and need taxonomies of standard and non-standard codes for inventory types, classes, statuses etc.   - [Reference](/reactive): All APIs related to retrieving platform-supported taxonomies.   ### Insight APIs  Insight endpoints do exactly what the name implies - They offer platform-level insight into the activities of producers and consumers.   - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics.   ### Payment APIs  Payment endpoints are for developers who want to purchase travel inventory. This can be done via the API as a registered Travel Agent or using our API in conjunction with our PCI compliant reactive widget for all other entities.   - [TripPay](/reactive): All APIs related to TripPay account management, booking, mapping and integration features.   ## SDKs  We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).   - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)   ## Usage  These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.   ## Versioning  We chose to version our endpoints in a way that we hope affects your integration minimally. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.   ## Release history  - Follow updates on Github: https://github.com/wink-travel/wink-sdk-java/blob/master/CHANGELOG.md    # Inventory API The Inventory API exposes endpoints to retrieve inventory you already know about. This API lets you:  1. Consume shareable links. 2. Load up a known property with availability. 3. Load up all inventories that were created by our affiliates such as grids, maps, and individual items.  Browse the endpoints in the left navigation bar to get started.  
 *
 * The version of the OpenAPI document: 30.17.8
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.inventory.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import travel.wink.sdk.inventory.model.CustomMonetaryAmount;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Outlines basic policies for the property.
 */
@JsonPropertyOrder({
  PropertyPolicyNonAuthenticatedEntity.JSON_PROPERTY_CHILDREN_ALLOWED,
  PropertyPolicyNonAuthenticatedEntity.JSON_PROPERTY_CHILDREN_MINIMUM_AGE,
  PropertyPolicyNonAuthenticatedEntity.JSON_PROPERTY_INTERNET_AVAILABILITY,
  PropertyPolicyNonAuthenticatedEntity.JSON_PROPERTY_INTERNET_CONNECTION_TYPE,
  PropertyPolicyNonAuthenticatedEntity.JSON_PROPERTY_INTERNET_CONNECTION_LOCATION,
  PropertyPolicyNonAuthenticatedEntity.JSON_PROPERTY_PARKING_AVAILABILITY,
  PropertyPolicyNonAuthenticatedEntity.JSON_PROPERTY_PARKING_ACCESS,
  PropertyPolicyNonAuthenticatedEntity.JSON_PROPERTY_PETS_ALLOWED,
  PropertyPolicyNonAuthenticatedEntity.JSON_PROPERTY_PET_MAX_WEIGHT_IN_KILOS,
  PropertyPolicyNonAuthenticatedEntity.JSON_PROPERTY_PET_CHARGE,
  PropertyPolicyNonAuthenticatedEntity.JSON_PROPERTY_CHECK_OUT_TIME,
  PropertyPolicyNonAuthenticatedEntity.JSON_PROPERTY_CHECK_IN_TIME
})
@JsonTypeName("PropertyPolicy_Non_Authenticated_Entity")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-06-26T20:20:31.141212618+07:00[Asia/Bangkok]", comments = "Generator version: 7.13.0")
public class PropertyPolicyNonAuthenticatedEntity {
  public static final String JSON_PROPERTY_CHILDREN_ALLOWED = "childrenAllowed";
  @jakarta.annotation.Nonnull
  private Boolean childrenAllowed = false;

  public static final String JSON_PROPERTY_CHILDREN_MINIMUM_AGE = "childrenMinimumAge";
  @jakarta.annotation.Nullable
  private Integer childrenMinimumAge;

  /**
   * Indicates the availability of internet on the property.
   */
  public enum InternetAvailabilityEnum {
    YES(String.valueOf("YES")),
    
    NO(String.valueOf("NO")),
    
    YES_PAID(String.valueOf("YES_PAID"));

    private String value;

    InternetAvailabilityEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static InternetAvailabilityEnum fromValue(String value) {
      for (InternetAvailabilityEnum b : InternetAvailabilityEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_INTERNET_AVAILABILITY = "internetAvailability";
  @jakarta.annotation.Nonnull
  private InternetAvailabilityEnum internetAvailability;

  /**
   * Indicates how guests can access the Internet on the property.
   */
  public enum InternetConnectionTypeEnum {
    WIFI(String.valueOf("WIFI")),
    
    CABLE(String.valueOf("CABLE"));

    private String value;

    InternetConnectionTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static InternetConnectionTypeEnum fromValue(String value) {
      for (InternetConnectionTypeEnum b : InternetConnectionTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_INTERNET_CONNECTION_TYPE = "internetConnectionType";
  @jakarta.annotation.Nonnull
  private InternetConnectionTypeEnum internetConnectionType;

  /**
   * Indicates where internet is available in and around the property.
   */
  public enum InternetConnectionLocationEnum {
    ENTIRE_PROPERTY(String.valueOf("ENTIRE_PROPERTY")),
    
    PUBLIC_AREAS(String.valueOf("PUBLIC_AREAS")),
    
    ALL_ROOMS(String.valueOf("ALL_ROOMS")),
    
    SOME_ROOMS(String.valueOf("SOME_ROOMS")),
    
    BUSINESS_CENTER(String.valueOf("BUSINESS_CENTER"));

    private String value;

    InternetConnectionLocationEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static InternetConnectionLocationEnum fromValue(String value) {
      for (InternetConnectionLocationEnum b : InternetConnectionLocationEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_INTERNET_CONNECTION_LOCATION = "internetConnectionLocation";
  @jakarta.annotation.Nonnull
  private InternetConnectionLocationEnum internetConnectionLocation;

  /**
   * Indicates whether parking is available at the property.
   */
  public enum ParkingAvailabilityEnum {
    YES(String.valueOf("YES")),
    
    NO(String.valueOf("NO")),
    
    YES_PAID(String.valueOf("YES_PAID"));

    private String value;

    ParkingAvailabilityEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ParkingAvailabilityEnum fromValue(String value) {
      for (ParkingAvailabilityEnum b : ParkingAvailabilityEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_PARKING_AVAILABILITY = "parkingAvailability";
  @jakarta.annotation.Nonnull
  private ParkingAvailabilityEnum parkingAvailability;

  /**
   * Indicates what type of parking is available at the property.
   */
  public enum ParkingAccessEnum {
    PRIVATE(String.valueOf("PRIVATE")),
    
    PUBLIC(String.valueOf("PUBLIC"));

    private String value;

    ParkingAccessEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ParkingAccessEnum fromValue(String value) {
      for (ParkingAccessEnum b : ParkingAccessEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_PARKING_ACCESS = "parkingAccess";
  @jakarta.annotation.Nonnull
  private ParkingAccessEnum parkingAccess;

  public static final String JSON_PROPERTY_PETS_ALLOWED = "petsAllowed";
  @jakarta.annotation.Nonnull
  private Boolean petsAllowed = false;

  public static final String JSON_PROPERTY_PET_MAX_WEIGHT_IN_KILOS = "petMaxWeightInKilos";
  @jakarta.annotation.Nullable
  private Integer petMaxWeightInKilos;

  public static final String JSON_PROPERTY_PET_CHARGE = "petCharge";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount petCharge;

  public static final String JSON_PROPERTY_CHECK_OUT_TIME = "checkOutTime";
  @jakarta.annotation.Nonnull
  private String checkOutTime;

  public static final String JSON_PROPERTY_CHECK_IN_TIME = "checkInTime";
  @jakarta.annotation.Nonnull
  private String checkInTime;

  public PropertyPolicyNonAuthenticatedEntity() {
  }

  public PropertyPolicyNonAuthenticatedEntity childrenAllowed(@jakarta.annotation.Nonnull Boolean childrenAllowed) {
    
    this.childrenAllowed = childrenAllowed;
    return this;
  }

  /**
   * Indicates whether property allows children
   * @return childrenAllowed
   */
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_CHILDREN_ALLOWED)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getChildrenAllowed() {
    return childrenAllowed;
  }


  @JsonProperty(JSON_PROPERTY_CHILDREN_ALLOWED)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setChildrenAllowed(@jakarta.annotation.Nonnull Boolean childrenAllowed) {
    this.childrenAllowed = childrenAllowed;
  }

  public PropertyPolicyNonAuthenticatedEntity childrenMinimumAge(@jakarta.annotation.Nullable Integer childrenMinimumAge) {
    
    this.childrenMinimumAge = childrenMinimumAge;
    return this;
  }

  /**
   * When a property allows children, it can also indicate what the minimum age is for children to be allowed.
   * @return childrenMinimumAge
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CHILDREN_MINIMUM_AGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getChildrenMinimumAge() {
    return childrenMinimumAge;
  }


  @JsonProperty(JSON_PROPERTY_CHILDREN_MINIMUM_AGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setChildrenMinimumAge(@jakarta.annotation.Nullable Integer childrenMinimumAge) {
    this.childrenMinimumAge = childrenMinimumAge;
  }

  public PropertyPolicyNonAuthenticatedEntity internetAvailability(@jakarta.annotation.Nonnull InternetAvailabilityEnum internetAvailability) {
    
    this.internetAvailability = internetAvailability;
    return this;
  }

  /**
   * Indicates the availability of internet on the property.
   * @return internetAvailability
   */
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_INTERNET_AVAILABILITY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public InternetAvailabilityEnum getInternetAvailability() {
    return internetAvailability;
  }


  @JsonProperty(JSON_PROPERTY_INTERNET_AVAILABILITY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setInternetAvailability(@jakarta.annotation.Nonnull InternetAvailabilityEnum internetAvailability) {
    this.internetAvailability = internetAvailability;
  }

  public PropertyPolicyNonAuthenticatedEntity internetConnectionType(@jakarta.annotation.Nonnull InternetConnectionTypeEnum internetConnectionType) {
    
    this.internetConnectionType = internetConnectionType;
    return this;
  }

  /**
   * Indicates how guests can access the Internet on the property.
   * @return internetConnectionType
   */
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_INTERNET_CONNECTION_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public InternetConnectionTypeEnum getInternetConnectionType() {
    return internetConnectionType;
  }


  @JsonProperty(JSON_PROPERTY_INTERNET_CONNECTION_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setInternetConnectionType(@jakarta.annotation.Nonnull InternetConnectionTypeEnum internetConnectionType) {
    this.internetConnectionType = internetConnectionType;
  }

  public PropertyPolicyNonAuthenticatedEntity internetConnectionLocation(@jakarta.annotation.Nonnull InternetConnectionLocationEnum internetConnectionLocation) {
    
    this.internetConnectionLocation = internetConnectionLocation;
    return this;
  }

  /**
   * Indicates where internet is available in and around the property.
   * @return internetConnectionLocation
   */
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_INTERNET_CONNECTION_LOCATION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public InternetConnectionLocationEnum getInternetConnectionLocation() {
    return internetConnectionLocation;
  }


  @JsonProperty(JSON_PROPERTY_INTERNET_CONNECTION_LOCATION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setInternetConnectionLocation(@jakarta.annotation.Nonnull InternetConnectionLocationEnum internetConnectionLocation) {
    this.internetConnectionLocation = internetConnectionLocation;
  }

  public PropertyPolicyNonAuthenticatedEntity parkingAvailability(@jakarta.annotation.Nonnull ParkingAvailabilityEnum parkingAvailability) {
    
    this.parkingAvailability = parkingAvailability;
    return this;
  }

  /**
   * Indicates whether parking is available at the property.
   * @return parkingAvailability
   */
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_PARKING_AVAILABILITY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public ParkingAvailabilityEnum getParkingAvailability() {
    return parkingAvailability;
  }


  @JsonProperty(JSON_PROPERTY_PARKING_AVAILABILITY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setParkingAvailability(@jakarta.annotation.Nonnull ParkingAvailabilityEnum parkingAvailability) {
    this.parkingAvailability = parkingAvailability;
  }

  public PropertyPolicyNonAuthenticatedEntity parkingAccess(@jakarta.annotation.Nonnull ParkingAccessEnum parkingAccess) {
    
    this.parkingAccess = parkingAccess;
    return this;
  }

  /**
   * Indicates what type of parking is available at the property.
   * @return parkingAccess
   */
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_PARKING_ACCESS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public ParkingAccessEnum getParkingAccess() {
    return parkingAccess;
  }


  @JsonProperty(JSON_PROPERTY_PARKING_ACCESS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setParkingAccess(@jakarta.annotation.Nonnull ParkingAccessEnum parkingAccess) {
    this.parkingAccess = parkingAccess;
  }

  public PropertyPolicyNonAuthenticatedEntity petsAllowed(@jakarta.annotation.Nonnull Boolean petsAllowed) {
    
    this.petsAllowed = petsAllowed;
    return this;
  }

  /**
   * Indicates whether pets are allowed on the property. Note: There are thousand different kinds of pets. Just because the property allows small dogs does not mean the guest can bring a python. Always best to check with property.
   * @return petsAllowed
   */
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_PETS_ALLOWED)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getPetsAllowed() {
    return petsAllowed;
  }


  @JsonProperty(JSON_PROPERTY_PETS_ALLOWED)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPetsAllowed(@jakarta.annotation.Nonnull Boolean petsAllowed) {
    this.petsAllowed = petsAllowed;
  }

  public PropertyPolicyNonAuthenticatedEntity petMaxWeightInKilos(@jakarta.annotation.Nullable Integer petMaxWeightInKilos) {
    
    this.petMaxWeightInKilos = petMaxWeightInKilos;
    return this;
  }

  /**
   * If pets are allowed, property can further limit on weight.
   * @return petMaxWeightInKilos
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PET_MAX_WEIGHT_IN_KILOS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getPetMaxWeightInKilos() {
    return petMaxWeightInKilos;
  }


  @JsonProperty(JSON_PROPERTY_PET_MAX_WEIGHT_IN_KILOS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPetMaxWeightInKilos(@jakarta.annotation.Nullable Integer petMaxWeightInKilos) {
    this.petMaxWeightInKilos = petMaxWeightInKilos;
  }

  public PropertyPolicyNonAuthenticatedEntity petCharge(@jakarta.annotation.Nullable CustomMonetaryAmount petCharge) {
    
    this.petCharge = petCharge;
    return this;
  }

  /**
   * If pets are allowed, property can tell travelers if there is a charge applicable for the pet.
   * @return petCharge
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_PET_CHARGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getPetCharge() {
    return petCharge;
  }


  @JsonProperty(JSON_PROPERTY_PET_CHARGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPetCharge(@jakarta.annotation.Nullable CustomMonetaryAmount petCharge) {
    this.petCharge = petCharge;
  }

  public PropertyPolicyNonAuthenticatedEntity checkOutTime(@jakarta.annotation.Nonnull String checkOutTime) {
    
    this.checkOutTime = checkOutTime;
    return this;
  }

  /**
   * When the guest has to check out.
   * @return checkOutTime
   */
  @jakarta.annotation.Nonnull
  @NotNull
 @Size(min=1)
  @JsonProperty(JSON_PROPERTY_CHECK_OUT_TIME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getCheckOutTime() {
    return checkOutTime;
  }


  @JsonProperty(JSON_PROPERTY_CHECK_OUT_TIME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCheckOutTime(@jakarta.annotation.Nonnull String checkOutTime) {
    this.checkOutTime = checkOutTime;
  }

  public PropertyPolicyNonAuthenticatedEntity checkInTime(@jakarta.annotation.Nonnull String checkInTime) {
    
    this.checkInTime = checkInTime;
    return this;
  }

  /**
   * When the guest can check in.
   * @return checkInTime
   */
  @jakarta.annotation.Nonnull
  @NotNull
 @Size(min=1)
  @JsonProperty(JSON_PROPERTY_CHECK_IN_TIME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getCheckInTime() {
    return checkInTime;
  }


  @JsonProperty(JSON_PROPERTY_CHECK_IN_TIME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCheckInTime(@jakarta.annotation.Nonnull String checkInTime) {
    this.checkInTime = checkInTime;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PropertyPolicyNonAuthenticatedEntity propertyPolicyNonAuthenticatedEntity = (PropertyPolicyNonAuthenticatedEntity) o;
    return Objects.equals(this.childrenAllowed, propertyPolicyNonAuthenticatedEntity.childrenAllowed) &&
        Objects.equals(this.childrenMinimumAge, propertyPolicyNonAuthenticatedEntity.childrenMinimumAge) &&
        Objects.equals(this.internetAvailability, propertyPolicyNonAuthenticatedEntity.internetAvailability) &&
        Objects.equals(this.internetConnectionType, propertyPolicyNonAuthenticatedEntity.internetConnectionType) &&
        Objects.equals(this.internetConnectionLocation, propertyPolicyNonAuthenticatedEntity.internetConnectionLocation) &&
        Objects.equals(this.parkingAvailability, propertyPolicyNonAuthenticatedEntity.parkingAvailability) &&
        Objects.equals(this.parkingAccess, propertyPolicyNonAuthenticatedEntity.parkingAccess) &&
        Objects.equals(this.petsAllowed, propertyPolicyNonAuthenticatedEntity.petsAllowed) &&
        Objects.equals(this.petMaxWeightInKilos, propertyPolicyNonAuthenticatedEntity.petMaxWeightInKilos) &&
        Objects.equals(this.petCharge, propertyPolicyNonAuthenticatedEntity.petCharge) &&
        Objects.equals(this.checkOutTime, propertyPolicyNonAuthenticatedEntity.checkOutTime) &&
        Objects.equals(this.checkInTime, propertyPolicyNonAuthenticatedEntity.checkInTime);
  }

  @Override
  public int hashCode() {
    return Objects.hash(childrenAllowed, childrenMinimumAge, internetAvailability, internetConnectionType, internetConnectionLocation, parkingAvailability, parkingAccess, petsAllowed, petMaxWeightInKilos, petCharge, checkOutTime, checkInTime);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PropertyPolicyNonAuthenticatedEntity {\n");
    sb.append("    childrenAllowed: ").append(toIndentedString(childrenAllowed)).append("\n");
    sb.append("    childrenMinimumAge: ").append(toIndentedString(childrenMinimumAge)).append("\n");
    sb.append("    internetAvailability: ").append(toIndentedString(internetAvailability)).append("\n");
    sb.append("    internetConnectionType: ").append(toIndentedString(internetConnectionType)).append("\n");
    sb.append("    internetConnectionLocation: ").append(toIndentedString(internetConnectionLocation)).append("\n");
    sb.append("    parkingAvailability: ").append(toIndentedString(parkingAvailability)).append("\n");
    sb.append("    parkingAccess: ").append(toIndentedString(parkingAccess)).append("\n");
    sb.append("    petsAllowed: ").append(toIndentedString(petsAllowed)).append("\n");
    sb.append("    petMaxWeightInKilos: ").append(toIndentedString(petMaxWeightInKilos)).append("\n");
    sb.append("    petCharge: ").append(toIndentedString(petCharge)).append("\n");
    sb.append("    checkOutTime: ").append(toIndentedString(checkOutTime)).append("\n");
    sb.append("    checkInTime: ").append(toIndentedString(checkInTime)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

