/*
 * Wink API
 *  # Introduction  Welcome to the Wink API - A programmer-friendly way to manage, sell and book travel inventory on the Wink platform. The API gives you all the tools you need to ready your properties and inventory for sale across 1000s of our native sales channels.  Integrators, affiliates, travel agents and content creators have the ability search for your travel inventory and promote / sell it in a wide variety of ways.   # Integrations  We have already integrated with the most well-known channel managers so you don't have to. To see our current integrations, please go to https://extranet.wink.travel and scroll to Connectivity section. Once your properties are set up, you can finish the setup by mapping your property to Wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API.   # Intended Audience  Programmers are [most likely] a requirement to start integrating with Wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible.  - Hotel chains  - Hotel brands  - Travel tech companies  - Destination sites  - Integrators  - Aggregators  - Destination management companies  - Travel agencies  - OTAs   ## APIs  Not every integrator needs every API. For that reason, we have separated APIs into context.  ### Test API   - [Ping](/ping): The Ping API is a quick test endpoint to verify that your credentials work Wink.  ### Common APIs  - [Notifications](/notifications): The Notifications API is a way for us to stay in touch with your user, property or affiliate account. - [User Settings](/user-settings): The User Settings API exposes endpoints to allow 3rd party integrators to communicate with Wink.  ### Consume APIs Consume endpoints are for developers who want to find existing travel inventory and either book it or use it to advertise through one of their Wink affiliate accounts.   - [Configuration](/customization-client): A single endpoint to retrieve whitelabel + customization information for the booking customization.  - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags.  - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API..  - [Booking](/booking): All APIs related to creating bookings on the platform.  - [Travel Agent](/travel-agent): The Travel Agent API exposes endpoints to manage agent-facilitated bookings.   ### Produce APIs  Produce endpoints are for developers who want to create and manage travel inventory.   #### Property  - [Property registration](/extranet/property/register): As a producer, this is, oftentimes, where you start your journey. These endpoints let you create properties on Wink.  - [Property](/extranet/property): This collection of property endpoints are mostly management endpoints that let you display, change status and similar for your existing properties.  - [Facilities](/extranet/facilities): This collection of endpoints let you manage facilities; such as room types.  - [Experiences](/extranet/experiences): This collection of endpoints let you manage experiences, such as activities.  - [Monetize](/extranet/monetize): The Monetize API exposes endpoints for managing cancellation polies, rate plans, promotions and more on Wink.  - [Distribution](/extranet/distribution): The Distribution API exposes endpoints for sales channels, connecting with affiliates, managing rates and inventory calendars and more on Wink.  - [Property Booking](/extranet/booking): The Property Booking API exposes endpoints for managing bookings and reviews at the property-level.   #### Affiliate  - [Affiliate](/affiliate): This collection of affiliate endpoints are mostly management endpoints that let you display, change status and similar for your existing accounts.  - [Browse](/affiliate/browse): The Browse API exposes endpoints for affiliates to find suppliers and inventory to sell.  - [Inventory](/affiliate/inventory): The Inventory API exposes endpoints for affiliates to manage the inventory they want to sell and how they want to sell it.  - [Sales Channel](/affiliate/sales-channel): The Sales Channel API exposes endpoints for affiliates to manage existing sales channels as well as find new ones.  - [WinkLinks](/affiliate/winklinks): The WinkLinks API exposes endpoints for affiliates to manage their WinkLinks page.   #### Rate provider  - [Channel manager](/channel-manager): The Channel Manager API enables external channel manager partners to map, exchange rate / availability information with us as well as be informed of bookings that occur on the Wink platform for one of their properties.   ### Taxonomy APIs  Taxonomy endpoints are for developers who want to consume and produce travel inventory and need taxonomies of standard and non-standard codes for inventory types, classes, statuses etc.   - [Reference](/reactive): All APIs related to retrieving platform-supported taxonomies.   ### Insight APIs  Insight endpoints do exactly what the name implies - They offer platform-level insight into the activities of producers and consumers.   - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics.   ### Payment APIs  Payment endpoints are for developers who want to purchase travel inventory. This can be done via the API as a registered Travel Agent or using our API in conjunction with our PCI compliant reactive widget for all other entities.   - [TripPay](/reactive): All APIs related to TripPay account management, booking, mapping and integration features.   ## SDKs  We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).   - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)   ## Usage  These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.   ## Versioning  We chose to version our endpoints in a way that we hope affects your integration minimally. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.   ## Release history  - Follow updates on Github: https://github.com/wink-travel/wink-sdk-java/blob/master/CHANGELOG.md    # Inventory API The Inventory API exposes endpoints to retrieve inventory you already know about. This API lets you:  1. Consume shareable links. 2. Load up a known property with availability. 3. Load up all inventories that were created by our affiliates such as grids, maps, and individual items.  Browse the endpoints in the left navigation bar to get started.  
 *
 * The version of the OpenAPI document: 30.17.8
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.inventory.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import travel.wink.sdk.inventory.model.ContactNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.DowPatternGroupNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.GeoJsonPointNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.SimpleAddressNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.SimpleDescriptionNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.SimpleMultimediaNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.SocialNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.TravelInventoryRecognitionNonAuthenticatedEntity;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * RestaurantLightweightNonAuthenticatedEntity
 */
@JsonPropertyOrder({
  RestaurantLightweightNonAuthenticatedEntity.JSON_PROPERTY_IDENTIFIER,
  RestaurantLightweightNonAuthenticatedEntity.JSON_PROPERTY_HOTEL_IDENTIFIER,
  RestaurantLightweightNonAuthenticatedEntity.JSON_PROPERTY_FEATURED_IND,
  RestaurantLightweightNonAuthenticatedEntity.JSON_PROPERTY_LIFESTYLE_TYPE,
  RestaurantLightweightNonAuthenticatedEntity.JSON_PROPERTY_LOCATION,
  RestaurantLightweightNonAuthenticatedEntity.JSON_PROPERTY_DESCRIPTIONS,
  RestaurantLightweightNonAuthenticatedEntity.JSON_PROPERTY_MULTIMEDIAS,
  RestaurantLightweightNonAuthenticatedEntity.JSON_PROPERTY_CONTACT,
  RestaurantLightweightNonAuthenticatedEntity.JSON_PROPERTY_ADDRESS,
  RestaurantLightweightNonAuthenticatedEntity.JSON_PROPERTY_COMMISSIONABLE,
  RestaurantLightweightNonAuthenticatedEntity.JSON_PROPERTY_NAME,
  RestaurantLightweightNonAuthenticatedEntity.JSON_PROPERTY_PROXIMITY_CODE,
  RestaurantLightweightNonAuthenticatedEntity.JSON_PROPERTY_SORT,
  RestaurantLightweightNonAuthenticatedEntity.JSON_PROPERTY_MIN_AGE_APPROPRIATE_CODE,
  RestaurantLightweightNonAuthenticatedEntity.JSON_PROPERTY_BOOKABLE,
  RestaurantLightweightNonAuthenticatedEntity.JSON_PROPERTY_ACTIVE,
  RestaurantLightweightNonAuthenticatedEntity.JSON_PROPERTY_DISABILITY_FEATURES,
  RestaurantLightweightNonAuthenticatedEntity.JSON_PROPERTY_SECURITY_FEATURES,
  RestaurantLightweightNonAuthenticatedEntity.JSON_PROPERTY_SOCIALS,
  RestaurantLightweightNonAuthenticatedEntity.JSON_PROPERTY_PRICE_POINT,
  RestaurantLightweightNonAuthenticatedEntity.JSON_PROPERTY_RECOGNITION_LIST,
  RestaurantLightweightNonAuthenticatedEntity.JSON_PROPERTY_APPLICABLE_START,
  RestaurantLightweightNonAuthenticatedEntity.JSON_PROPERTY_APPLICABLE_END,
  RestaurantLightweightNonAuthenticatedEntity.JSON_PROPERTY_RESERVATION_REQUIRED_IND,
  RestaurantLightweightNonAuthenticatedEntity.JSON_PROPERTY_OPENS,
  RestaurantLightweightNonAuthenticatedEntity.JSON_PROPERTY_CLOSES,
  RestaurantLightweightNonAuthenticatedEntity.JSON_PROPERTY_DAYS_OF_WEEK,
  RestaurantLightweightNonAuthenticatedEntity.JSON_PROPERTY_MAX_SEATING_CAPACITY,
  RestaurantLightweightNonAuthenticatedEntity.JSON_PROPERTY_MAX_SINGLE_PARTY,
  RestaurantLightweightNonAuthenticatedEntity.JSON_PROPERTY_OFFER_BREAKFAST,
  RestaurantLightweightNonAuthenticatedEntity.JSON_PROPERTY_OFFER_LUNCH,
  RestaurantLightweightNonAuthenticatedEntity.JSON_PROPERTY_OFFER_DINNER,
  RestaurantLightweightNonAuthenticatedEntity.JSON_PROPERTY_OFFER_BRUNCH,
  RestaurantLightweightNonAuthenticatedEntity.JSON_PROPERTY_AMENITIES,
  RestaurantLightweightNonAuthenticatedEntity.JSON_PROPERTY_INFO_CODES,
  RestaurantLightweightNonAuthenticatedEntity.JSON_PROPERTY_CUISINE_CODES
})
@JsonTypeName("RestaurantLightweight_Non_Authenticated_Entity")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-06-26T20:20:31.141212618+07:00[Asia/Bangkok]", comments = "Generator version: 7.13.0")
public class RestaurantLightweightNonAuthenticatedEntity {
  public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
  @jakarta.annotation.Nonnull
  private UUID identifier;

  public static final String JSON_PROPERTY_HOTEL_IDENTIFIER = "hotelIdentifier";
  @jakarta.annotation.Nonnull
  private UUID hotelIdentifier;

  public static final String JSON_PROPERTY_FEATURED_IND = "featuredInd";
  @jakarta.annotation.Nonnull
  private Boolean featuredInd;

  /**
   * Indicate the type of lifestyle this blocking should be associated with.
   */
  public enum LifestyleTypeEnum {
    LIFESTYLE_HEALTH_FITNESS(String.valueOf("LIFESTYLE_HEALTH_FITNESS")),
    
    LIFESTYLE_RELAX(String.valueOf("LIFESTYLE_RELAX")),
    
    LIFESTYLE_ADULT_ONLY(String.valueOf("LIFESTYLE_ADULT_ONLY")),
    
    LIFESTYLE_ADVENTURE(String.valueOf("LIFESTYLE_ADVENTURE")),
    
    LIFESTYLE_BUSINESS(String.valueOf("LIFESTYLE_BUSINESS")),
    
    LIFESTYLE_LGBT(String.valueOf("LIFESTYLE_LGBT")),
    
    LIFESTYLE_SINGLE_PARENT(String.valueOf("LIFESTYLE_SINGLE_PARENT")),
    
    LIFESTYLE_SOLO_FEMALE(String.valueOf("LIFESTYLE_SOLO_FEMALE")),
    
    LIFESTYLE_BEAUTY(String.valueOf("LIFESTYLE_BEAUTY")),
    
    LIFESTYLE_FOODIE(String.valueOf("LIFESTYLE_FOODIE")),
    
    LIFESTYLE_FAMILY(String.valueOf("LIFESTYLE_FAMILY")),
    
    LIFESTYLE_ROMANCE(String.valueOf("LIFESTYLE_ROMANCE")),
    
    LIFESTYLE_COUPLE(String.valueOf("LIFESTYLE_COUPLE")),
    
    LIFESTYLE_SOLO(String.valueOf("LIFESTYLE_SOLO")),
    
    LIFESTYLE_BACKPACKER(String.valueOf("LIFESTYLE_BACKPACKER")),
    
    LIFESTYLE_SHOPPING(String.valueOf("LIFESTYLE_SHOPPING")),
    
    LIFESTYLE_SPORTS(String.valueOf("LIFESTYLE_SPORTS")),
    
    LIFESTYLE_MOUNTAIN(String.valueOf("LIFESTYLE_MOUNTAIN")),
    
    LIFESTYLE_BEACH(String.valueOf("LIFESTYLE_BEACH")),
    
    LIFESTYLE_CITY(String.valueOf("LIFESTYLE_CITY")),
    
    LIFESTYLE_COUNTRY(String.valueOf("LIFESTYLE_COUNTRY")),
    
    LIFESTYLE_CULTURE(String.valueOf("LIFESTYLE_CULTURE")),
    
    LIFESTYLE_ECO(String.valueOf("LIFESTYLE_ECO"));

    private String value;

    LifestyleTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static LifestyleTypeEnum fromValue(String value) {
      for (LifestyleTypeEnum b : LifestyleTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_LIFESTYLE_TYPE = "lifestyleType";
  @jakarta.annotation.Nullable
  private LifestyleTypeEnum lifestyleType;

  public static final String JSON_PROPERTY_LOCATION = "location";
  @jakarta.annotation.Nonnull
  private GeoJsonPointNonAuthenticatedEntity location;

  public static final String JSON_PROPERTY_DESCRIPTIONS = "descriptions";
  @jakarta.annotation.Nonnull
  private List<@Valid SimpleDescriptionNonAuthenticatedEntity> descriptions = new ArrayList<>();

  public static final String JSON_PROPERTY_MULTIMEDIAS = "multimedias";
  @jakarta.annotation.Nonnull
  private List<@Valid SimpleMultimediaNonAuthenticatedEntity> multimedias = new ArrayList<>();

  public static final String JSON_PROPERTY_CONTACT = "contact";
  @jakarta.annotation.Nonnull
  private ContactNonAuthenticatedEntity contact;

  public static final String JSON_PROPERTY_ADDRESS = "address";
  @jakarta.annotation.Nonnull
  private SimpleAddressNonAuthenticatedEntity address;

  public static final String JSON_PROPERTY_COMMISSIONABLE = "commissionable";
  @jakarta.annotation.Nonnull
  private Boolean commissionable = true;

  public static final String JSON_PROPERTY_NAME = "name";
  @jakarta.annotation.Nonnull
  private String name;

  public static final String JSON_PROPERTY_PROXIMITY_CODE = "proximityCode";
  @jakarta.annotation.Nonnull
  private String proximityCode;

  public static final String JSON_PROPERTY_SORT = "sort";
  @jakarta.annotation.Nullable
  private Integer sort;

  public static final String JSON_PROPERTY_MIN_AGE_APPROPRIATE_CODE = "minAgeAppropriateCode";
  @jakarta.annotation.Nullable
  private String minAgeAppropriateCode;

  public static final String JSON_PROPERTY_BOOKABLE = "bookable";
  @jakarta.annotation.Nonnull
  private Boolean bookable = true;

  public static final String JSON_PROPERTY_ACTIVE = "active";
  @jakarta.annotation.Nonnull
  private Boolean active = true;

  public static final String JSON_PROPERTY_DISABILITY_FEATURES = "disabilityFeatures";
  @jakarta.annotation.Nullable
  private List<String> disabilityFeatures = new ArrayList<>();

  public static final String JSON_PROPERTY_SECURITY_FEATURES = "securityFeatures";
  @jakarta.annotation.Nullable
  private List<String> securityFeatures = new ArrayList<>();

  public static final String JSON_PROPERTY_SOCIALS = "socials";
  @jakarta.annotation.Nullable
  private List<@Valid SocialNonAuthenticatedEntity> socials = new ArrayList<>();

  /**
   * Level of expensiveness.
   */
  public enum PricePointEnum {
    HALF(String.valueOf("HALF")),
    
    ONE(String.valueOf("ONE")),
    
    ONE_HALF(String.valueOf("ONE_HALF")),
    
    TWO(String.valueOf("TWO")),
    
    TWO_HALF(String.valueOf("TWO_HALF")),
    
    THREE(String.valueOf("THREE")),
    
    THREE_HALF(String.valueOf("THREE_HALF")),
    
    FOUR(String.valueOf("FOUR")),
    
    FOUR_HALF(String.valueOf("FOUR_HALF")),
    
    FIVE(String.valueOf("FIVE"));

    private String value;

    PricePointEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static PricePointEnum fromValue(String value) {
      for (PricePointEnum b : PricePointEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_PRICE_POINT = "pricePoint";
  @jakarta.annotation.Nonnull
  private PricePointEnum pricePoint = PricePointEnum.THREE;

  public static final String JSON_PROPERTY_RECOGNITION_LIST = "recognitionList";
  @jakarta.annotation.Nullable
  private List<@Valid TravelInventoryRecognitionNonAuthenticatedEntity> recognitionList = new ArrayList<>();

  public static final String JSON_PROPERTY_APPLICABLE_START = "applicableStart";
  @jakarta.annotation.Nullable
  private LocalDate applicableStart;

  public static final String JSON_PROPERTY_APPLICABLE_END = "applicableEnd";
  @jakarta.annotation.Nullable
  private LocalDate applicableEnd;

  public static final String JSON_PROPERTY_RESERVATION_REQUIRED_IND = "reservationRequiredInd";
  @jakarta.annotation.Nullable
  private Boolean reservationRequiredInd;

  public static final String JSON_PROPERTY_OPENS = "opens";
  @jakarta.annotation.Nullable
  private String opens;

  public static final String JSON_PROPERTY_CLOSES = "closes";
  @jakarta.annotation.Nullable
  private String closes;

  public static final String JSON_PROPERTY_DAYS_OF_WEEK = "daysOfWeek";
  @jakarta.annotation.Nullable
  private DowPatternGroupNonAuthenticatedEntity daysOfWeek;

  public static final String JSON_PROPERTY_MAX_SEATING_CAPACITY = "maxSeatingCapacity";
  @jakarta.annotation.Nonnull
  private Integer maxSeatingCapacity;

  public static final String JSON_PROPERTY_MAX_SINGLE_PARTY = "maxSingleParty";
  @jakarta.annotation.Nonnull
  private Integer maxSingleParty;

  public static final String JSON_PROPERTY_OFFER_BREAKFAST = "offerBreakfast";
  @jakarta.annotation.Nonnull
  private Boolean offerBreakfast = false;

  public static final String JSON_PROPERTY_OFFER_LUNCH = "offerLunch";
  @jakarta.annotation.Nonnull
  private Boolean offerLunch = false;

  public static final String JSON_PROPERTY_OFFER_DINNER = "offerDinner";
  @jakarta.annotation.Nonnull
  private Boolean offerDinner = false;

  public static final String JSON_PROPERTY_OFFER_BRUNCH = "offerBrunch";
  @jakarta.annotation.Nonnull
  private Boolean offerBrunch = false;

  public static final String JSON_PROPERTY_AMENITIES = "amenities";
  @jakarta.annotation.Nullable
  private List<String> amenities = new ArrayList<>();

  public static final String JSON_PROPERTY_INFO_CODES = "infoCodes";
  @jakarta.annotation.Nullable
  private List<String> infoCodes = new ArrayList<>();

  public static final String JSON_PROPERTY_CUISINE_CODES = "cuisineCodes";
  @jakarta.annotation.Nullable
  private List<String> cuisineCodes = new ArrayList<>();

  public RestaurantLightweightNonAuthenticatedEntity() {
  }

  public RestaurantLightweightNonAuthenticatedEntity identifier(@jakarta.annotation.Nonnull UUID identifier) {
    
    this.identifier = identifier;
    return this;
  }

  /**
   * Unique record identifier
   * @return identifier
   */
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid
 @Size(min=1)
  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getIdentifier() {
    return identifier;
  }


  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setIdentifier(@jakarta.annotation.Nonnull UUID identifier) {
    this.identifier = identifier;
  }

  public RestaurantLightweightNonAuthenticatedEntity hotelIdentifier(@jakarta.annotation.Nonnull UUID hotelIdentifier) {
    
    this.hotelIdentifier = hotelIdentifier;
    return this;
  }

  /**
   * Hotel identifier.
   * @return hotelIdentifier
   */
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid
 @Size(min=1)
  @JsonProperty(JSON_PROPERTY_HOTEL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getHotelIdentifier() {
    return hotelIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_HOTEL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setHotelIdentifier(@jakarta.annotation.Nonnull UUID hotelIdentifier) {
    this.hotelIdentifier = hotelIdentifier;
  }

  public RestaurantLightweightNonAuthenticatedEntity featuredInd(@jakarta.annotation.Nonnull Boolean featuredInd) {
    
    this.featuredInd = featuredInd;
    return this;
  }

  /**
   * Indicates whether this inventory is featured. Use this flag as a way to signify that this inventory is special.
   * @return featuredInd
   */
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_FEATURED_IND)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getFeaturedInd() {
    return featuredInd;
  }


  @JsonProperty(JSON_PROPERTY_FEATURED_IND)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setFeaturedInd(@jakarta.annotation.Nonnull Boolean featuredInd) {
    this.featuredInd = featuredInd;
  }

  public RestaurantLightweightNonAuthenticatedEntity lifestyleType(@jakarta.annotation.Nullable LifestyleTypeEnum lifestyleType) {
    
    this.lifestyleType = lifestyleType;
    return this;
  }

  /**
   * Indicate the type of lifestyle this blocking should be associated with.
   * @return lifestyleType
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_LIFESTYLE_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LifestyleTypeEnum getLifestyleType() {
    return lifestyleType;
  }


  @JsonProperty(JSON_PROPERTY_LIFESTYLE_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLifestyleType(@jakarta.annotation.Nullable LifestyleTypeEnum lifestyleType) {
    this.lifestyleType = lifestyleType;
  }

  public RestaurantLightweightNonAuthenticatedEntity location(@jakarta.annotation.Nonnull GeoJsonPointNonAuthenticatedEntity location) {
    
    this.location = location;
    return this;
  }

  /**
   * Geo-location point where blocking takes place. Defaults to location of property.
   * @return location
   */
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_LOCATION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public GeoJsonPointNonAuthenticatedEntity getLocation() {
    return location;
  }


  @JsonProperty(JSON_PROPERTY_LOCATION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setLocation(@jakarta.annotation.Nonnull GeoJsonPointNonAuthenticatedEntity location) {
    this.location = location;
  }

  public RestaurantLightweightNonAuthenticatedEntity descriptions(@jakarta.annotation.Nonnull List<@Valid SimpleDescriptionNonAuthenticatedEntity> descriptions) {
    
    this.descriptions = descriptions;
    return this;
  }

  public RestaurantLightweightNonAuthenticatedEntity addDescriptionsItem(SimpleDescriptionNonAuthenticatedEntity descriptionsItem) {
    if (this.descriptions == null) {
      this.descriptions = new ArrayList<>();
    }
    this.descriptions.add(descriptionsItem);
    return this;
  }

  /**
   * Get descriptions
   * @return descriptions
   */
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid
 @Size(min=1)
  @JsonProperty(JSON_PROPERTY_DESCRIPTIONS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<@Valid SimpleDescriptionNonAuthenticatedEntity> getDescriptions() {
    return descriptions;
  }


  @JsonProperty(JSON_PROPERTY_DESCRIPTIONS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDescriptions(@jakarta.annotation.Nonnull List<@Valid SimpleDescriptionNonAuthenticatedEntity> descriptions) {
    this.descriptions = descriptions;
  }

  public RestaurantLightweightNonAuthenticatedEntity multimedias(@jakarta.annotation.Nonnull List<@Valid SimpleMultimediaNonAuthenticatedEntity> multimedias) {
    
    this.multimedias = multimedias;
    return this;
  }

  public RestaurantLightweightNonAuthenticatedEntity addMultimediasItem(SimpleMultimediaNonAuthenticatedEntity multimediasItem) {
    if (this.multimedias == null) {
      this.multimedias = new ArrayList<>();
    }
    this.multimedias.add(multimediasItem);
    return this;
  }

  /**
   * Get multimedias
   * @return multimedias
   */
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid
 @Size(min=1)
  @JsonProperty(JSON_PROPERTY_MULTIMEDIAS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<@Valid SimpleMultimediaNonAuthenticatedEntity> getMultimedias() {
    return multimedias;
  }


  @JsonProperty(JSON_PROPERTY_MULTIMEDIAS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setMultimedias(@jakarta.annotation.Nonnull List<@Valid SimpleMultimediaNonAuthenticatedEntity> multimedias) {
    this.multimedias = multimedias;
  }

  public RestaurantLightweightNonAuthenticatedEntity contact(@jakarta.annotation.Nonnull ContactNonAuthenticatedEntity contact) {
    
    this.contact = contact;
    return this;
  }

  /**
   * Associate a contact person for this blocking (if applicable).
   * @return contact
   */
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_CONTACT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public ContactNonAuthenticatedEntity getContact() {
    return contact;
  }


  @JsonProperty(JSON_PROPERTY_CONTACT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setContact(@jakarta.annotation.Nonnull ContactNonAuthenticatedEntity contact) {
    this.contact = contact;
  }

  public RestaurantLightweightNonAuthenticatedEntity address(@jakarta.annotation.Nonnull SimpleAddressNonAuthenticatedEntity address) {
    
    this.address = address;
    return this;
  }

  /**
   * Defaults to property address.
   * @return address
   */
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public SimpleAddressNonAuthenticatedEntity getAddress() {
    return address;
  }


  @JsonProperty(JSON_PROPERTY_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAddress(@jakarta.annotation.Nonnull SimpleAddressNonAuthenticatedEntity address) {
    this.address = address;
  }

  public RestaurantLightweightNonAuthenticatedEntity commissionable(@jakarta.annotation.Nonnull Boolean commissionable) {
    
    this.commissionable = commissionable;
    return this;
  }

  /**
   * Indicate whether sales channels receive commission for selling this blocking.
   * @return commissionable
   */
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_COMMISSIONABLE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getCommissionable() {
    return commissionable;
  }


  @JsonProperty(JSON_PROPERTY_COMMISSIONABLE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCommissionable(@jakarta.annotation.Nonnull Boolean commissionable) {
    this.commissionable = commissionable;
  }

  public RestaurantLightweightNonAuthenticatedEntity name(@jakarta.annotation.Nonnull String name) {
    
    this.name = name;
    return this;
  }

  /**
   * Internal name of blocking.
   * @return name
   */
  @jakarta.annotation.Nonnull
  @NotNull
 @Size(min=1)
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setName(@jakarta.annotation.Nonnull String name) {
    this.name = name;
  }

  public RestaurantLightweightNonAuthenticatedEntity proximityCode(@jakarta.annotation.Nonnull String proximityCode) {
    
    this.proximityCode = proximityCode;
    return this;
  }

  /**
   * Supported OTA specification &#x60;PRX&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory)
   * @return proximityCode
   */
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_PROXIMITY_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getProximityCode() {
    return proximityCode;
  }


  @JsonProperty(JSON_PROPERTY_PROXIMITY_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setProximityCode(@jakarta.annotation.Nonnull String proximityCode) {
    this.proximityCode = proximityCode;
  }

  public RestaurantLightweightNonAuthenticatedEntity sort(@jakarta.annotation.Nullable Integer sort) {
    
    this.sort = sort;
    return this;
  }

  /**
   * Use this property to sort an blocking in a list of activities.
   * @return sort
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getSort() {
    return sort;
  }


  @JsonProperty(JSON_PROPERTY_SORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSort(@jakarta.annotation.Nullable Integer sort) {
    this.sort = sort;
  }

  public RestaurantLightweightNonAuthenticatedEntity minAgeAppropriateCode(@jakarta.annotation.Nullable String minAgeAppropriateCode) {
    
    this.minAgeAppropriateCode = minAgeAppropriateCode;
    return this;
  }

  /**
   * Supported OTA specification &#x60;AQC&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory)
   * @return minAgeAppropriateCode
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_MIN_AGE_APPROPRIATE_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getMinAgeAppropriateCode() {
    return minAgeAppropriateCode;
  }


  @JsonProperty(JSON_PROPERTY_MIN_AGE_APPROPRIATE_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMinAgeAppropriateCode(@jakarta.annotation.Nullable String minAgeAppropriateCode) {
    this.minAgeAppropriateCode = minAgeAppropriateCode;
  }

  public RestaurantLightweightNonAuthenticatedEntity bookable(@jakarta.annotation.Nonnull Boolean bookable) {
    
    this.bookable = bookable;
    return this;
  }

  /**
   * Indicates if this blocking can be added to a booking or if it is read-only marketing material only.
   * @return bookable
   */
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_BOOKABLE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getBookable() {
    return bookable;
  }


  @JsonProperty(JSON_PROPERTY_BOOKABLE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setBookable(@jakarta.annotation.Nonnull Boolean bookable) {
    this.bookable = bookable;
  }

  public RestaurantLightweightNonAuthenticatedEntity active(@jakarta.annotation.Nonnull Boolean active) {
    
    this.active = active;
    return this;
  }

  /**
   * Modify blocking availability with this flag.
   * @return active
   */
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_ACTIVE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getActive() {
    return active;
  }


  @JsonProperty(JSON_PROPERTY_ACTIVE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setActive(@jakarta.annotation.Nonnull Boolean active) {
    this.active = active;
  }

  public RestaurantLightweightNonAuthenticatedEntity disabilityFeatures(@jakarta.annotation.Nullable List<String> disabilityFeatures) {
    
    this.disabilityFeatures = disabilityFeatures;
    return this;
  }

  public RestaurantLightweightNonAuthenticatedEntity addDisabilityFeaturesItem(String disabilityFeaturesItem) {
    if (this.disabilityFeatures == null) {
      this.disabilityFeatures = new ArrayList<>();
    }
    this.disabilityFeatures.add(disabilityFeaturesItem);
    return this;
  }

  /**
   * Get disabilityFeatures
   * @return disabilityFeatures
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_DISABILITY_FEATURES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getDisabilityFeatures() {
    return disabilityFeatures;
  }


  @JsonProperty(JSON_PROPERTY_DISABILITY_FEATURES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDisabilityFeatures(@jakarta.annotation.Nullable List<String> disabilityFeatures) {
    this.disabilityFeatures = disabilityFeatures;
  }

  public RestaurantLightweightNonAuthenticatedEntity securityFeatures(@jakarta.annotation.Nullable List<String> securityFeatures) {
    
    this.securityFeatures = securityFeatures;
    return this;
  }

  public RestaurantLightweightNonAuthenticatedEntity addSecurityFeaturesItem(String securityFeaturesItem) {
    if (this.securityFeatures == null) {
      this.securityFeatures = new ArrayList<>();
    }
    this.securityFeatures.add(securityFeaturesItem);
    return this;
  }

  /**
   * Get securityFeatures
   * @return securityFeatures
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SECURITY_FEATURES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getSecurityFeatures() {
    return securityFeatures;
  }


  @JsonProperty(JSON_PROPERTY_SECURITY_FEATURES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSecurityFeatures(@jakarta.annotation.Nullable List<String> securityFeatures) {
    this.securityFeatures = securityFeatures;
  }

  public RestaurantLightweightNonAuthenticatedEntity socials(@jakarta.annotation.Nullable List<@Valid SocialNonAuthenticatedEntity> socials) {
    
    this.socials = socials;
    return this;
  }

  public RestaurantLightweightNonAuthenticatedEntity addSocialsItem(SocialNonAuthenticatedEntity socialsItem) {
    if (this.socials == null) {
      this.socials = new ArrayList<>();
    }
    this.socials.add(socialsItem);
    return this;
  }

  /**
   * Get socials
   * @return socials
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SOCIALS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<@Valid SocialNonAuthenticatedEntity> getSocials() {
    return socials;
  }


  @JsonProperty(JSON_PROPERTY_SOCIALS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSocials(@jakarta.annotation.Nullable List<@Valid SocialNonAuthenticatedEntity> socials) {
    this.socials = socials;
  }

  public RestaurantLightweightNonAuthenticatedEntity pricePoint(@jakarta.annotation.Nonnull PricePointEnum pricePoint) {
    
    this.pricePoint = pricePoint;
    return this;
  }

  /**
   * Level of expensiveness.
   * @return pricePoint
   */
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_PRICE_POINT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public PricePointEnum getPricePoint() {
    return pricePoint;
  }


  @JsonProperty(JSON_PROPERTY_PRICE_POINT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPricePoint(@jakarta.annotation.Nonnull PricePointEnum pricePoint) {
    this.pricePoint = pricePoint;
  }

  public RestaurantLightweightNonAuthenticatedEntity recognitionList(@jakarta.annotation.Nullable List<@Valid TravelInventoryRecognitionNonAuthenticatedEntity> recognitionList) {
    
    this.recognitionList = recognitionList;
    return this;
  }

  public RestaurantLightweightNonAuthenticatedEntity addRecognitionListItem(TravelInventoryRecognitionNonAuthenticatedEntity recognitionListItem) {
    if (this.recognitionList == null) {
      this.recognitionList = new ArrayList<>();
    }
    this.recognitionList.add(recognitionListItem);
    return this;
  }

  /**
   * Get recognitionList
   * @return recognitionList
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_RECOGNITION_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<@Valid TravelInventoryRecognitionNonAuthenticatedEntity> getRecognitionList() {
    return recognitionList;
  }


  @JsonProperty(JSON_PROPERTY_RECOGNITION_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRecognitionList(@jakarta.annotation.Nullable List<@Valid TravelInventoryRecognitionNonAuthenticatedEntity> recognitionList) {
    this.recognitionList = recognitionList;
  }

  public RestaurantLightweightNonAuthenticatedEntity applicableStart(@jakarta.annotation.Nullable LocalDate applicableStart) {
    
    this.applicableStart = applicableStart;
    return this;
  }

  /**
   * Start month and day or date for which the attraction (e.g. the start of a season) is available. This date property signifies that the blocking is recurring and / or seasonal. If the date is in the past, only day and month will be used to infer seasonality. If the date is a future date, it will be interpreted as a starting date.
   * @return applicableStart
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_APPLICABLE_START)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LocalDate getApplicableStart() {
    return applicableStart;
  }


  @JsonProperty(JSON_PROPERTY_APPLICABLE_START)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setApplicableStart(@jakarta.annotation.Nullable LocalDate applicableStart) {
    this.applicableStart = applicableStart;
  }

  public RestaurantLightweightNonAuthenticatedEntity applicableEnd(@jakarta.annotation.Nullable LocalDate applicableEnd) {
    
    this.applicableEnd = applicableEnd;
    return this;
  }

  /**
   * End month and day or date for which the attraction (e.g. the start of a season) is available. This date property signifies that the blocking is recurring and / or seasonal. If the date is in the past, only day and month will be used to infer seasonality. If the date is a future date, it will be interpreted as a ending date.
   * @return applicableEnd
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_APPLICABLE_END)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LocalDate getApplicableEnd() {
    return applicableEnd;
  }


  @JsonProperty(JSON_PROPERTY_APPLICABLE_END)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setApplicableEnd(@jakarta.annotation.Nullable LocalDate applicableEnd) {
    this.applicableEnd = applicableEnd;
  }

  public RestaurantLightweightNonAuthenticatedEntity reservationRequiredInd(@jakarta.annotation.Nullable Boolean reservationRequiredInd) {
    
    this.reservationRequiredInd = reservationRequiredInd;
    return this;
  }

  /**
   * Indicates whether a reservation is required to participate in this blocking.
   * @return reservationRequiredInd
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_RESERVATION_REQUIRED_IND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getReservationRequiredInd() {
    return reservationRequiredInd;
  }


  @JsonProperty(JSON_PROPERTY_RESERVATION_REQUIRED_IND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReservationRequiredInd(@jakarta.annotation.Nullable Boolean reservationRequiredInd) {
    this.reservationRequiredInd = reservationRequiredInd;
  }

  public RestaurantLightweightNonAuthenticatedEntity opens(@jakarta.annotation.Nullable String opens) {
    
    this.opens = opens;
    return this;
  }

  /**
   * Opening time of blocking (if applicable). Leave empty if blocking is always available.
   * @return opens
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_OPENS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getOpens() {
    return opens;
  }


  @JsonProperty(JSON_PROPERTY_OPENS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOpens(@jakarta.annotation.Nullable String opens) {
    this.opens = opens;
  }

  public RestaurantLightweightNonAuthenticatedEntity closes(@jakarta.annotation.Nullable String closes) {
    
    this.closes = closes;
    return this;
  }

  /**
   * Closing time of blocking (if applicable). Leave empty if blocking is always available.
   * @return closes
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CLOSES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCloses() {
    return closes;
  }


  @JsonProperty(JSON_PROPERTY_CLOSES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCloses(@jakarta.annotation.Nullable String closes) {
    this.closes = closes;
  }

  public RestaurantLightweightNonAuthenticatedEntity daysOfWeek(@jakarta.annotation.Nullable DowPatternGroupNonAuthenticatedEntity daysOfWeek) {
    
    this.daysOfWeek = daysOfWeek;
    return this;
  }

  /**
   * Indicate which days this blocking is open.
   * @return daysOfWeek
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_DAYS_OF_WEEK)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public DowPatternGroupNonAuthenticatedEntity getDaysOfWeek() {
    return daysOfWeek;
  }


  @JsonProperty(JSON_PROPERTY_DAYS_OF_WEEK)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDaysOfWeek(@jakarta.annotation.Nullable DowPatternGroupNonAuthenticatedEntity daysOfWeek) {
    this.daysOfWeek = daysOfWeek;
  }

  public RestaurantLightweightNonAuthenticatedEntity maxSeatingCapacity(@jakarta.annotation.Nonnull Integer maxSeatingCapacity) {
    
    this.maxSeatingCapacity = maxSeatingCapacity;
    return this;
  }

  /**
   * Restaurant supports these many people.
   * minimum: 1
   * @return maxSeatingCapacity
   */
  @jakarta.annotation.Nonnull
  @NotNull
 @Min(1)
  @JsonProperty(JSON_PROPERTY_MAX_SEATING_CAPACITY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getMaxSeatingCapacity() {
    return maxSeatingCapacity;
  }


  @JsonProperty(JSON_PROPERTY_MAX_SEATING_CAPACITY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setMaxSeatingCapacity(@jakarta.annotation.Nonnull Integer maxSeatingCapacity) {
    this.maxSeatingCapacity = maxSeatingCapacity;
  }

  public RestaurantLightweightNonAuthenticatedEntity maxSingleParty(@jakarta.annotation.Nonnull Integer maxSingleParty) {
    
    this.maxSingleParty = maxSingleParty;
    return this;
  }

  /**
   * Largest table at restaurant.
   * minimum: 1
   * @return maxSingleParty
   */
  @jakarta.annotation.Nonnull
  @NotNull
 @Min(1)
  @JsonProperty(JSON_PROPERTY_MAX_SINGLE_PARTY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getMaxSingleParty() {
    return maxSingleParty;
  }


  @JsonProperty(JSON_PROPERTY_MAX_SINGLE_PARTY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setMaxSingleParty(@jakarta.annotation.Nonnull Integer maxSingleParty) {
    this.maxSingleParty = maxSingleParty;
  }

  public RestaurantLightweightNonAuthenticatedEntity offerBreakfast(@jakarta.annotation.Nonnull Boolean offerBreakfast) {
    
    this.offerBreakfast = offerBreakfast;
    return this;
  }

  /**
   * Restaurant offers breakfast.
   * @return offerBreakfast
   */
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_OFFER_BREAKFAST)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getOfferBreakfast() {
    return offerBreakfast;
  }


  @JsonProperty(JSON_PROPERTY_OFFER_BREAKFAST)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setOfferBreakfast(@jakarta.annotation.Nonnull Boolean offerBreakfast) {
    this.offerBreakfast = offerBreakfast;
  }

  public RestaurantLightweightNonAuthenticatedEntity offerLunch(@jakarta.annotation.Nonnull Boolean offerLunch) {
    
    this.offerLunch = offerLunch;
    return this;
  }

  /**
   * Restaurant offers lunch.
   * @return offerLunch
   */
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_OFFER_LUNCH)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getOfferLunch() {
    return offerLunch;
  }


  @JsonProperty(JSON_PROPERTY_OFFER_LUNCH)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setOfferLunch(@jakarta.annotation.Nonnull Boolean offerLunch) {
    this.offerLunch = offerLunch;
  }

  public RestaurantLightweightNonAuthenticatedEntity offerDinner(@jakarta.annotation.Nonnull Boolean offerDinner) {
    
    this.offerDinner = offerDinner;
    return this;
  }

  /**
   * Restaurant offers dinner.
   * @return offerDinner
   */
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_OFFER_DINNER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getOfferDinner() {
    return offerDinner;
  }


  @JsonProperty(JSON_PROPERTY_OFFER_DINNER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setOfferDinner(@jakarta.annotation.Nonnull Boolean offerDinner) {
    this.offerDinner = offerDinner;
  }

  public RestaurantLightweightNonAuthenticatedEntity offerBrunch(@jakarta.annotation.Nonnull Boolean offerBrunch) {
    
    this.offerBrunch = offerBrunch;
    return this;
  }

  /**
   * Restaurant offers brunch.
   * @return offerBrunch
   */
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_OFFER_BRUNCH)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getOfferBrunch() {
    return offerBrunch;
  }


  @JsonProperty(JSON_PROPERTY_OFFER_BRUNCH)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setOfferBrunch(@jakarta.annotation.Nonnull Boolean offerBrunch) {
    this.offerBrunch = offerBrunch;
  }

  public RestaurantLightweightNonAuthenticatedEntity amenities(@jakarta.annotation.Nullable List<String> amenities) {
    
    this.amenities = amenities;
    return this;
  }

  public RestaurantLightweightNonAuthenticatedEntity addAmenitiesItem(String amenitiesItem) {
    if (this.amenities == null) {
      this.amenities = new ArrayList<>();
    }
    this.amenities.add(amenitiesItem);
    return this;
  }

  /**
   * Get amenities
   * @return amenities
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_AMENITIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getAmenities() {
    return amenities;
  }


  @JsonProperty(JSON_PROPERTY_AMENITIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAmenities(@jakarta.annotation.Nullable List<String> amenities) {
    this.amenities = amenities;
  }

  public RestaurantLightweightNonAuthenticatedEntity infoCodes(@jakarta.annotation.Nullable List<String> infoCodes) {
    
    this.infoCodes = infoCodes;
    return this;
  }

  public RestaurantLightweightNonAuthenticatedEntity addInfoCodesItem(String infoCodesItem) {
    if (this.infoCodes == null) {
      this.infoCodes = new ArrayList<>();
    }
    this.infoCodes.add(infoCodesItem);
    return this;
  }

  /**
   * Get infoCodes
   * @return infoCodes
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_INFO_CODES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getInfoCodes() {
    return infoCodes;
  }


  @JsonProperty(JSON_PROPERTY_INFO_CODES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInfoCodes(@jakarta.annotation.Nullable List<String> infoCodes) {
    this.infoCodes = infoCodes;
  }

  public RestaurantLightweightNonAuthenticatedEntity cuisineCodes(@jakarta.annotation.Nullable List<String> cuisineCodes) {
    
    this.cuisineCodes = cuisineCodes;
    return this;
  }

  public RestaurantLightweightNonAuthenticatedEntity addCuisineCodesItem(String cuisineCodesItem) {
    if (this.cuisineCodes == null) {
      this.cuisineCodes = new ArrayList<>();
    }
    this.cuisineCodes.add(cuisineCodesItem);
    return this;
  }

  /**
   * Get cuisineCodes
   * @return cuisineCodes
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CUISINE_CODES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getCuisineCodes() {
    return cuisineCodes;
  }


  @JsonProperty(JSON_PROPERTY_CUISINE_CODES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCuisineCodes(@jakarta.annotation.Nullable List<String> cuisineCodes) {
    this.cuisineCodes = cuisineCodes;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RestaurantLightweightNonAuthenticatedEntity restaurantLightweightNonAuthenticatedEntity = (RestaurantLightweightNonAuthenticatedEntity) o;
    return Objects.equals(this.identifier, restaurantLightweightNonAuthenticatedEntity.identifier) &&
        Objects.equals(this.hotelIdentifier, restaurantLightweightNonAuthenticatedEntity.hotelIdentifier) &&
        Objects.equals(this.featuredInd, restaurantLightweightNonAuthenticatedEntity.featuredInd) &&
        Objects.equals(this.lifestyleType, restaurantLightweightNonAuthenticatedEntity.lifestyleType) &&
        Objects.equals(this.location, restaurantLightweightNonAuthenticatedEntity.location) &&
        Objects.equals(this.descriptions, restaurantLightweightNonAuthenticatedEntity.descriptions) &&
        Objects.equals(this.multimedias, restaurantLightweightNonAuthenticatedEntity.multimedias) &&
        Objects.equals(this.contact, restaurantLightweightNonAuthenticatedEntity.contact) &&
        Objects.equals(this.address, restaurantLightweightNonAuthenticatedEntity.address) &&
        Objects.equals(this.commissionable, restaurantLightweightNonAuthenticatedEntity.commissionable) &&
        Objects.equals(this.name, restaurantLightweightNonAuthenticatedEntity.name) &&
        Objects.equals(this.proximityCode, restaurantLightweightNonAuthenticatedEntity.proximityCode) &&
        Objects.equals(this.sort, restaurantLightweightNonAuthenticatedEntity.sort) &&
        Objects.equals(this.minAgeAppropriateCode, restaurantLightweightNonAuthenticatedEntity.minAgeAppropriateCode) &&
        Objects.equals(this.bookable, restaurantLightweightNonAuthenticatedEntity.bookable) &&
        Objects.equals(this.active, restaurantLightweightNonAuthenticatedEntity.active) &&
        Objects.equals(this.disabilityFeatures, restaurantLightweightNonAuthenticatedEntity.disabilityFeatures) &&
        Objects.equals(this.securityFeatures, restaurantLightweightNonAuthenticatedEntity.securityFeatures) &&
        Objects.equals(this.socials, restaurantLightweightNonAuthenticatedEntity.socials) &&
        Objects.equals(this.pricePoint, restaurantLightweightNonAuthenticatedEntity.pricePoint) &&
        Objects.equals(this.recognitionList, restaurantLightweightNonAuthenticatedEntity.recognitionList) &&
        Objects.equals(this.applicableStart, restaurantLightweightNonAuthenticatedEntity.applicableStart) &&
        Objects.equals(this.applicableEnd, restaurantLightweightNonAuthenticatedEntity.applicableEnd) &&
        Objects.equals(this.reservationRequiredInd, restaurantLightweightNonAuthenticatedEntity.reservationRequiredInd) &&
        Objects.equals(this.opens, restaurantLightweightNonAuthenticatedEntity.opens) &&
        Objects.equals(this.closes, restaurantLightweightNonAuthenticatedEntity.closes) &&
        Objects.equals(this.daysOfWeek, restaurantLightweightNonAuthenticatedEntity.daysOfWeek) &&
        Objects.equals(this.maxSeatingCapacity, restaurantLightweightNonAuthenticatedEntity.maxSeatingCapacity) &&
        Objects.equals(this.maxSingleParty, restaurantLightweightNonAuthenticatedEntity.maxSingleParty) &&
        Objects.equals(this.offerBreakfast, restaurantLightweightNonAuthenticatedEntity.offerBreakfast) &&
        Objects.equals(this.offerLunch, restaurantLightweightNonAuthenticatedEntity.offerLunch) &&
        Objects.equals(this.offerDinner, restaurantLightweightNonAuthenticatedEntity.offerDinner) &&
        Objects.equals(this.offerBrunch, restaurantLightweightNonAuthenticatedEntity.offerBrunch) &&
        Objects.equals(this.amenities, restaurantLightweightNonAuthenticatedEntity.amenities) &&
        Objects.equals(this.infoCodes, restaurantLightweightNonAuthenticatedEntity.infoCodes) &&
        Objects.equals(this.cuisineCodes, restaurantLightweightNonAuthenticatedEntity.cuisineCodes);
  }

  @Override
  public int hashCode() {
    return Objects.hash(identifier, hotelIdentifier, featuredInd, lifestyleType, location, descriptions, multimedias, contact, address, commissionable, name, proximityCode, sort, minAgeAppropriateCode, bookable, active, disabilityFeatures, securityFeatures, socials, pricePoint, recognitionList, applicableStart, applicableEnd, reservationRequiredInd, opens, closes, daysOfWeek, maxSeatingCapacity, maxSingleParty, offerBreakfast, offerLunch, offerDinner, offerBrunch, amenities, infoCodes, cuisineCodes);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RestaurantLightweightNonAuthenticatedEntity {\n");
    sb.append("    identifier: ").append(toIndentedString(identifier)).append("\n");
    sb.append("    hotelIdentifier: ").append(toIndentedString(hotelIdentifier)).append("\n");
    sb.append("    featuredInd: ").append(toIndentedString(featuredInd)).append("\n");
    sb.append("    lifestyleType: ").append(toIndentedString(lifestyleType)).append("\n");
    sb.append("    location: ").append(toIndentedString(location)).append("\n");
    sb.append("    descriptions: ").append(toIndentedString(descriptions)).append("\n");
    sb.append("    multimedias: ").append(toIndentedString(multimedias)).append("\n");
    sb.append("    contact: ").append(toIndentedString(contact)).append("\n");
    sb.append("    address: ").append(toIndentedString(address)).append("\n");
    sb.append("    commissionable: ").append(toIndentedString(commissionable)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    proximityCode: ").append(toIndentedString(proximityCode)).append("\n");
    sb.append("    sort: ").append(toIndentedString(sort)).append("\n");
    sb.append("    minAgeAppropriateCode: ").append(toIndentedString(minAgeAppropriateCode)).append("\n");
    sb.append("    bookable: ").append(toIndentedString(bookable)).append("\n");
    sb.append("    active: ").append(toIndentedString(active)).append("\n");
    sb.append("    disabilityFeatures: ").append(toIndentedString(disabilityFeatures)).append("\n");
    sb.append("    securityFeatures: ").append(toIndentedString(securityFeatures)).append("\n");
    sb.append("    socials: ").append(toIndentedString(socials)).append("\n");
    sb.append("    pricePoint: ").append(toIndentedString(pricePoint)).append("\n");
    sb.append("    recognitionList: ").append(toIndentedString(recognitionList)).append("\n");
    sb.append("    applicableStart: ").append(toIndentedString(applicableStart)).append("\n");
    sb.append("    applicableEnd: ").append(toIndentedString(applicableEnd)).append("\n");
    sb.append("    reservationRequiredInd: ").append(toIndentedString(reservationRequiredInd)).append("\n");
    sb.append("    opens: ").append(toIndentedString(opens)).append("\n");
    sb.append("    closes: ").append(toIndentedString(closes)).append("\n");
    sb.append("    daysOfWeek: ").append(toIndentedString(daysOfWeek)).append("\n");
    sb.append("    maxSeatingCapacity: ").append(toIndentedString(maxSeatingCapacity)).append("\n");
    sb.append("    maxSingleParty: ").append(toIndentedString(maxSingleParty)).append("\n");
    sb.append("    offerBreakfast: ").append(toIndentedString(offerBreakfast)).append("\n");
    sb.append("    offerLunch: ").append(toIndentedString(offerLunch)).append("\n");
    sb.append("    offerDinner: ").append(toIndentedString(offerDinner)).append("\n");
    sb.append("    offerBrunch: ").append(toIndentedString(offerBrunch)).append("\n");
    sb.append("    amenities: ").append(toIndentedString(amenities)).append("\n");
    sb.append("    infoCodes: ").append(toIndentedString(infoCodes)).append("\n");
    sb.append("    cuisineCodes: ").append(toIndentedString(cuisineCodes)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

