/*
 * Wink API
 *  # Introduction  Welcome to the Wink API - A programmer-friendly way to manage, sell and book travel inventory on the Wink platform. The API gives you all the tools you need to ready your properties and inventory for sale across 1000s of our native sales channels.  Integrators, affiliates, travel agents and content creators have the ability search for your travel inventory and promote / sell it in a wide variety of ways.   # Integrations  We have already integrated with the most well-known channel managers so you don't have to. To see our current integrations, please go to https://extranet.wink.travel and scroll to Connectivity section. Once your properties are set up, you can finish the setup by mapping your property to Wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API.   # Intended Audience  Programmers are [most likely] a requirement to start integrating with Wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible.  - Hotel chains  - Hotel brands  - Travel tech companies  - Destination sites  - Integrators  - Aggregators  - Destination management companies  - Travel agencies  - OTAs   ## APIs  Not every integrator needs every API. For that reason, we have separated APIs into context.  ### Test API   - [Ping](/ping): The Ping API is a quick test endpoint to verify that your credentials work Wink.  ### Common APIs  - [Notifications](/notifications): The Notifications API is a way for us to stay in touch with your user, property or affiliate account. - [User Settings](/user-settings): The User Settings API exposes endpoints to allow 3rd party integrators to communicate with Wink.  ### Consume APIs Consume endpoints are for developers who want to find existing travel inventory and either book it or use it to advertise through one of their Wink affiliate accounts.   - [Configuration](/customization-client): A single endpoint to retrieve whitelabel + customization information for the booking customization.  - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags.  - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API..  - [Booking](/booking): All APIs related to creating bookings on the platform.  - [Travel Agent](/travel-agent): The Travel Agent API exposes endpoints to manage agent-facilitated bookings.   ### Produce APIs  Produce endpoints are for developers who want to create and manage travel inventory.   #### Property  - [Property registration](/extranet/property/register): As a producer, this is, oftentimes, where you start your journey. These endpoints let you create properties on Wink.  - [Property](/extranet/property): This collection of property endpoints are mostly management endpoints that let you display, change status and similar for your existing properties.  - [Facilities](/extranet/facilities): This collection of endpoints let you manage facilities; such as room types.  - [Experiences](/extranet/experiences): This collection of endpoints let you manage experiences, such as activities.  - [Monetize](/extranet/monetize): The Monetize API exposes endpoints for managing cancellation polies, rate plans, promotions and more on Wink.  - [Distribution](/extranet/distribution): The Distribution API exposes endpoints for sales channels, connecting with affiliates, managing rates and inventory calendars and more on Wink.  - [Property Booking](/extranet/booking): The Property Booking API exposes endpoints for managing bookings and reviews at the property-level.   #### Affiliate  - [Affiliate](/affiliate): This collection of affiliate endpoints are mostly management endpoints that let you display, change status and similar for your existing accounts.  - [Browse](/affiliate/browse): The Browse API exposes endpoints for affiliates to find suppliers and inventory to sell.  - [Inventory](/affiliate/inventory): The Inventory API exposes endpoints for affiliates to manage the inventory they want to sell and how they want to sell it.  - [Sales Channel](/affiliate/sales-channel): The Sales Channel API exposes endpoints for affiliates to manage existing sales channels as well as find new ones.  - [WinkLinks](/affiliate/winklinks): The WinkLinks API exposes endpoints for affiliates to manage their WinkLinks page.   #### Rate provider  - [Channel manager](/channel-manager): The Channel Manager API enables external channel manager partners to map, exchange rate / availability information with us as well as be informed of bookings that occur on the Wink platform for one of their properties.   ### Taxonomy APIs  Taxonomy endpoints are for developers who want to consume and produce travel inventory and need taxonomies of standard and non-standard codes for inventory types, classes, statuses etc.   - [Reference](/reactive): All APIs related to retrieving platform-supported taxonomies.   ### Insight APIs  Insight endpoints do exactly what the name implies - They offer platform-level insight into the activities of producers and consumers.   - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics.   ### Payment APIs  Payment endpoints are for developers who want to purchase travel inventory. This can be done via the API as a registered Travel Agent or using our API in conjunction with our PCI compliant reactive widget for all other entities.   - [TripPay](/reactive): All APIs related to TripPay account management, booking, mapping and integration features.   ## SDKs  We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).   - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)   ## Usage  These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.   ## Versioning  We chose to version our endpoints in a way that we hope affects your integration minimally. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.   ## Release history  - Follow updates on Github: https://github.com/wink-travel/wink-sdk-java/blob/master/CHANGELOG.md    # Inventory API The Inventory API exposes endpoints to retrieve inventory you already know about. This API lets you:  1. Consume shareable links. 2. Load up a known property with availability. 3. Load up all inventories that were created by our affiliates such as grids, maps, and individual items.  Browse the endpoints in the left navigation bar to get started.  
 *
 * The version of the OpenAPI document: 30.17.8
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.inventory.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import travel.wink.sdk.inventory.model.CancellationPolicyLightweightNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.CustomMonetaryAmount;
import travel.wink.sdk.inventory.model.ExtraChargesNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.LocalizedTransactionalTravelInventoryNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.RoomConfigurationNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.RoomConfigurationPriceRatePlanNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.StayRateNonAuthenticatedEntity;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * RoomConfigurationPriceNonAuthenticatedEntity
 */
@JsonPropertyOrder({
  RoomConfigurationPriceNonAuthenticatedEntity.JSON_PROPERTY_ADULTS,
  RoomConfigurationPriceNonAuthenticatedEntity.JSON_PROPERTY_CHILDREN,
  RoomConfigurationPriceNonAuthenticatedEntity.JSON_PROPERTY_START_DATE,
  RoomConfigurationPriceNonAuthenticatedEntity.JSON_PROPERTY_END_DATE,
  RoomConfigurationPriceNonAuthenticatedEntity.JSON_PROPERTY_ROOM_RATE_IDENTIFIER,
  RoomConfigurationPriceNonAuthenticatedEntity.JSON_PROPERTY_ROOM_RATE_INTERNAL_NAME,
  RoomConfigurationPriceNonAuthenticatedEntity.JSON_PROPERTY_RATE_PLAN,
  RoomConfigurationPriceNonAuthenticatedEntity.JSON_PROPERTY_PERK_TYPES,
  RoomConfigurationPriceNonAuthenticatedEntity.JSON_PROPERTY_PRICE,
  RoomConfigurationPriceNonAuthenticatedEntity.JSON_PROPERTY_EXTRA_CHARGES,
  RoomConfigurationPriceNonAuthenticatedEntity.JSON_PROPERTY_CONFIGURATION,
  RoomConfigurationPriceNonAuthenticatedEntity.JSON_PROPERTY_ADD_ON_OFFERS,
  RoomConfigurationPriceNonAuthenticatedEntity.JSON_PROPERTY_PERK_VALUE,
  RoomConfigurationPriceNonAuthenticatedEntity.JSON_PROPERTY_ACTIVE_CANCELLATION_POLICY,
  RoomConfigurationPriceNonAuthenticatedEntity.JSON_PROPERTY_ROOM_NIGHTS,
  RoomConfigurationPriceNonAuthenticatedEntity.JSON_PROPERTY_LIST,
  RoomConfigurationPriceNonAuthenticatedEntity.JSON_PROPERTY_CHANNEL_INVENTORY_IDENTIFIER,
  RoomConfigurationPriceNonAuthenticatedEntity.JSON_PROPERTY_COMMISSIONABLE,
  RoomConfigurationPriceNonAuthenticatedEntity.JSON_PROPERTY_COMMISSION,
  RoomConfigurationPriceNonAuthenticatedEntity.JSON_PROPERTY_DIRECT,
  RoomConfigurationPriceNonAuthenticatedEntity.JSON_PROPERTY_PRICE_LIST,
  RoomConfigurationPriceNonAuthenticatedEntity.JSON_PROPERTY_AVAILABLE,
  RoomConfigurationPriceNonAuthenticatedEntity.JSON_PROPERTY_RATE_SOURCE,
  RoomConfigurationPriceNonAuthenticatedEntity.JSON_PROPERTY_SOURCE_TOTAL,
  RoomConfigurationPriceNonAuthenticatedEntity.JSON_PROPERTY_USER_SPECIFIED_CURRENCY_TOTAL,
  RoomConfigurationPriceNonAuthenticatedEntity.JSON_PROPERTY_INTERNAL_TOTAL
})
@JsonTypeName("RoomConfigurationPrice_Non_Authenticated_Entity")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-06-26T20:20:31.141212618+07:00[Asia/Bangkok]", comments = "Generator version: 7.13.0")
public class RoomConfigurationPriceNonAuthenticatedEntity {
  public static final String JSON_PROPERTY_ADULTS = "adults";
  @jakarta.annotation.Nonnull
  private Integer adults;

  public static final String JSON_PROPERTY_CHILDREN = "children";
  @jakarta.annotation.Nullable
  private Integer children;

  public static final String JSON_PROPERTY_START_DATE = "startDate";
  @jakarta.annotation.Nonnull
  private LocalDate startDate;

  public static final String JSON_PROPERTY_END_DATE = "endDate";
  @jakarta.annotation.Nonnull
  private LocalDate endDate;

  public static final String JSON_PROPERTY_ROOM_RATE_IDENTIFIER = "roomRateIdentifier";
  @jakarta.annotation.Nonnull
  private String roomRateIdentifier;

  public static final String JSON_PROPERTY_ROOM_RATE_INTERNAL_NAME = "roomRateInternalName";
  @jakarta.annotation.Nonnull
  private String roomRateInternalName;

  public static final String JSON_PROPERTY_RATE_PLAN = "ratePlan";
  @jakarta.annotation.Nonnull
  private RoomConfigurationPriceRatePlanNonAuthenticatedEntity ratePlan;

  public static final String JSON_PROPERTY_PERK_TYPES = "perkTypes";
  @jakarta.annotation.Nullable
  private List<Object> perkTypes = new ArrayList<>();

  public static final String JSON_PROPERTY_PRICE = "price";
  @jakarta.annotation.Nonnull
  private StayRateNonAuthenticatedEntity price;

  public static final String JSON_PROPERTY_EXTRA_CHARGES = "extraCharges";
  @jakarta.annotation.Nullable
  private ExtraChargesNonAuthenticatedEntity extraCharges;

  public static final String JSON_PROPERTY_CONFIGURATION = "configuration";
  @jakarta.annotation.Nonnull
  private RoomConfigurationNonAuthenticatedEntity _configuration;

  public static final String JSON_PROPERTY_ADD_ON_OFFERS = "addOnOffers";
  @jakarta.annotation.Nullable
  private List<Object> addOnOffers = new ArrayList<>();

  public static final String JSON_PROPERTY_PERK_VALUE = "perkValue";
  @jakarta.annotation.Nullable
  private Integer perkValue;

  public static final String JSON_PROPERTY_ACTIVE_CANCELLATION_POLICY = "activeCancellationPolicy";
  @jakarta.annotation.Nonnull
  private CancellationPolicyLightweightNonAuthenticatedEntity activeCancellationPolicy;

  public static final String JSON_PROPERTY_ROOM_NIGHTS = "roomNights";
  @jakarta.annotation.Nonnull
  private Integer roomNights;

  public static final String JSON_PROPERTY_LIST = "list";
  @jakarta.annotation.Nullable
  private List<@Valid LocalizedTransactionalTravelInventoryNonAuthenticatedEntity> _list = new ArrayList<>();

  public static final String JSON_PROPERTY_CHANNEL_INVENTORY_IDENTIFIER = "channelInventoryIdentifier";
  @jakarta.annotation.Nonnull
  private String channelInventoryIdentifier;

  public static final String JSON_PROPERTY_COMMISSIONABLE = "commissionable";
  @jakarta.annotation.Nonnull
  private Boolean commissionable;

  public static final String JSON_PROPERTY_COMMISSION = "commission";
  @jakarta.annotation.Nonnull
  private Float commission;

  public static final String JSON_PROPERTY_DIRECT = "direct";
  @jakarta.annotation.Nonnull
  private Boolean direct = false;

  public static final String JSON_PROPERTY_PRICE_LIST = "priceList";
  @jakarta.annotation.Nullable
  private List<Object> priceList = new ArrayList<>();

  public static final String JSON_PROPERTY_AVAILABLE = "available";
  @jakarta.annotation.Nullable
  private Boolean available;

  public static final String JSON_PROPERTY_RATE_SOURCE = "rateSource";
  @jakarta.annotation.Nullable
  private String rateSource;

  public static final String JSON_PROPERTY_SOURCE_TOTAL = "sourceTotal";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount sourceTotal;

  public static final String JSON_PROPERTY_USER_SPECIFIED_CURRENCY_TOTAL = "userSpecifiedCurrencyTotal";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount userSpecifiedCurrencyTotal;

  public static final String JSON_PROPERTY_INTERNAL_TOTAL = "internalTotal";
  @jakarta.annotation.Nullable
  private CustomMonetaryAmount internalTotal;

  public RoomConfigurationPriceNonAuthenticatedEntity() {
  }

  public RoomConfigurationPriceNonAuthenticatedEntity adults(@jakarta.annotation.Nonnull Integer adults) {
    
    this.adults = adults;
    return this;
  }

  /**
   * The actual amount of adults as determined by the hotel&#39;s policy
   * @return adults
   */
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_ADULTS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getAdults() {
    return adults;
  }


  @JsonProperty(JSON_PROPERTY_ADULTS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAdults(@jakarta.annotation.Nonnull Integer adults) {
    this.adults = adults;
  }

  public RoomConfigurationPriceNonAuthenticatedEntity children(@jakarta.annotation.Nullable Integer children) {
    
    this.children = children;
    return this;
  }

  /**
   * The actual amount of children as determined by the hotel&#39;s policy
   * @return children
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CHILDREN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getChildren() {
    return children;
  }


  @JsonProperty(JSON_PROPERTY_CHILDREN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setChildren(@jakarta.annotation.Nullable Integer children) {
    this.children = children;
  }

  public RoomConfigurationPriceNonAuthenticatedEntity startDate(@jakarta.annotation.Nonnull LocalDate startDate) {
    
    this.startDate = startDate;
    return this;
  }

  /**
   * SimpleDateTimeItinerary startDate
   * @return startDate
   */
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_START_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public LocalDate getStartDate() {
    return startDate;
  }


  @JsonProperty(JSON_PROPERTY_START_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setStartDate(@jakarta.annotation.Nonnull LocalDate startDate) {
    this.startDate = startDate;
  }

  public RoomConfigurationPriceNonAuthenticatedEntity endDate(@jakarta.annotation.Nonnull LocalDate endDate) {
    
    this.endDate = endDate;
    return this;
  }

  /**
   * SimpleDateTimeItinerary endDate
   * @return endDate
   */
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_END_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public LocalDate getEndDate() {
    return endDate;
  }


  @JsonProperty(JSON_PROPERTY_END_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setEndDate(@jakarta.annotation.Nonnull LocalDate endDate) {
    this.endDate = endDate;
  }

  public RoomConfigurationPriceNonAuthenticatedEntity roomRateIdentifier(@jakarta.annotation.Nonnull String roomRateIdentifier) {
    
    this.roomRateIdentifier = roomRateIdentifier;
    return this;
  }

  /**
   * Specified master rate identifier
   * @return roomRateIdentifier
   */
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_ROOM_RATE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getRoomRateIdentifier() {
    return roomRateIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_ROOM_RATE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRoomRateIdentifier(@jakarta.annotation.Nonnull String roomRateIdentifier) {
    this.roomRateIdentifier = roomRateIdentifier;
  }

  public RoomConfigurationPriceNonAuthenticatedEntity roomRateInternalName(@jakarta.annotation.Nonnull String roomRateInternalName) {
    
    this.roomRateInternalName = roomRateInternalName;
    return this;
  }

  /**
   * Specified master rate internal name
   * @return roomRateInternalName
   */
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_ROOM_RATE_INTERNAL_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getRoomRateInternalName() {
    return roomRateInternalName;
  }


  @JsonProperty(JSON_PROPERTY_ROOM_RATE_INTERNAL_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRoomRateInternalName(@jakarta.annotation.Nonnull String roomRateInternalName) {
    this.roomRateInternalName = roomRateInternalName;
  }

  public RoomConfigurationPriceNonAuthenticatedEntity ratePlan(@jakarta.annotation.Nonnull RoomConfigurationPriceRatePlanNonAuthenticatedEntity ratePlan) {
    
    this.ratePlan = ratePlan;
    return this;
  }

  /**
   * Specified rate plan
   * @return ratePlan
   */
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_RATE_PLAN)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public RoomConfigurationPriceRatePlanNonAuthenticatedEntity getRatePlan() {
    return ratePlan;
  }


  @JsonProperty(JSON_PROPERTY_RATE_PLAN)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRatePlan(@jakarta.annotation.Nonnull RoomConfigurationPriceRatePlanNonAuthenticatedEntity ratePlan) {
    this.ratePlan = ratePlan;
  }

  public RoomConfigurationPriceNonAuthenticatedEntity perkTypes(@jakarta.annotation.Nullable List<Object> perkTypes) {
    
    this.perkTypes = perkTypes;
    return this;
  }

  public RoomConfigurationPriceNonAuthenticatedEntity addPerkTypesItem(Object perkTypesItem) {
    if (this.perkTypes == null) {
      this.perkTypes = new ArrayList<>();
    }
    this.perkTypes.add(perkTypesItem);
    return this;
  }

  /**
   * Get perkTypes
   * @return perkTypes
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PERK_TYPES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Object> getPerkTypes() {
    return perkTypes;
  }


  @JsonProperty(JSON_PROPERTY_PERK_TYPES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPerkTypes(@jakarta.annotation.Nullable List<Object> perkTypes) {
    this.perkTypes = perkTypes;
  }

  public RoomConfigurationPriceNonAuthenticatedEntity price(@jakarta.annotation.Nonnull StayRateNonAuthenticatedEntity price) {
    
    this.price = price;
    return this;
  }

  /**
   * Calculated price
   * @return price
   */
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_PRICE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public StayRateNonAuthenticatedEntity getPrice() {
    return price;
  }


  @JsonProperty(JSON_PROPERTY_PRICE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPrice(@jakarta.annotation.Nonnull StayRateNonAuthenticatedEntity price) {
    this.price = price;
  }

  public RoomConfigurationPriceNonAuthenticatedEntity extraCharges(@jakarta.annotation.Nullable ExtraChargesNonAuthenticatedEntity extraCharges) {
    
    this.extraCharges = extraCharges;
    return this;
  }

  /**
   * Per rate plan level extra charges with localized prices
   * @return extraCharges
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_EXTRA_CHARGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ExtraChargesNonAuthenticatedEntity getExtraCharges() {
    return extraCharges;
  }


  @JsonProperty(JSON_PROPERTY_EXTRA_CHARGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExtraCharges(@jakarta.annotation.Nullable ExtraChargesNonAuthenticatedEntity extraCharges) {
    this.extraCharges = extraCharges;
  }

  public RoomConfigurationPriceNonAuthenticatedEntity _configuration(@jakarta.annotation.Nonnull RoomConfigurationNonAuthenticatedEntity _configuration) {
    
    this._configuration = _configuration;
    return this;
  }

  /**
   * The selected room configuration that created this record
   * @return _configuration
   */
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_CONFIGURATION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public RoomConfigurationNonAuthenticatedEntity getConfiguration() {
    return _configuration;
  }


  @JsonProperty(JSON_PROPERTY_CONFIGURATION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setConfiguration(@jakarta.annotation.Nonnull RoomConfigurationNonAuthenticatedEntity _configuration) {
    this._configuration = _configuration;
  }

  public RoomConfigurationPriceNonAuthenticatedEntity addOnOffers(@jakarta.annotation.Nullable List<Object> addOnOffers) {
    
    this.addOnOffers = addOnOffers;
    return this;
  }

  public RoomConfigurationPriceNonAuthenticatedEntity addAddOnOffersItem(Object addOnOffersItem) {
    if (this.addOnOffers == null) {
      this.addOnOffers = new ArrayList<>();
    }
    this.addOnOffers.add(addOnOffersItem);
    return this;
  }

  /**
   * Get addOnOffers
   * @return addOnOffers
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ADD_ON_OFFERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Object> getAddOnOffers() {
    return addOnOffers;
  }


  @JsonProperty(JSON_PROPERTY_ADD_ON_OFFERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAddOnOffers(@jakarta.annotation.Nullable List<Object> addOnOffers) {
    this.addOnOffers = addOnOffers;
  }

  public RoomConfigurationPriceNonAuthenticatedEntity perkValue(@jakarta.annotation.Nullable Integer perkValue) {
    
    this.perkValue = perkValue;
    return this;
  }

  /**
   * The combined value of these perkTypes
   * @return perkValue
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PERK_VALUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getPerkValue() {
    return perkValue;
  }


  @JsonProperty(JSON_PROPERTY_PERK_VALUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPerkValue(@jakarta.annotation.Nullable Integer perkValue) {
    this.perkValue = perkValue;
  }

  public RoomConfigurationPriceNonAuthenticatedEntity activeCancellationPolicy(@jakarta.annotation.Nonnull CancellationPolicyLightweightNonAuthenticatedEntity activeCancellationPolicy) {
    
    this.activeCancellationPolicy = activeCancellationPolicy;
    return this;
  }

  /**
   * The active / selected cancellation policy for this room configuration
   * @return activeCancellationPolicy
   */
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_ACTIVE_CANCELLATION_POLICY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public CancellationPolicyLightweightNonAuthenticatedEntity getActiveCancellationPolicy() {
    return activeCancellationPolicy;
  }


  @JsonProperty(JSON_PROPERTY_ACTIVE_CANCELLATION_POLICY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setActiveCancellationPolicy(@jakarta.annotation.Nonnull CancellationPolicyLightweightNonAuthenticatedEntity activeCancellationPolicy) {
    this.activeCancellationPolicy = activeCancellationPolicy;
  }

  public RoomConfigurationPriceNonAuthenticatedEntity roomNights(@jakarta.annotation.Nonnull Integer roomNights) {
    
    this.roomNights = roomNights;
    return this;
  }

  /**
   * Number of nights the guests will be staying
   * @return roomNights
   */
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_ROOM_NIGHTS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getRoomNights() {
    return roomNights;
  }


  @JsonProperty(JSON_PROPERTY_ROOM_NIGHTS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRoomNights(@jakarta.annotation.Nonnull Integer roomNights) {
    this.roomNights = roomNights;
  }

  public RoomConfigurationPriceNonAuthenticatedEntity _list(@jakarta.annotation.Nullable List<@Valid LocalizedTransactionalTravelInventoryNonAuthenticatedEntity> _list) {
    
    this._list = _list;
    return this;
  }

  public RoomConfigurationPriceNonAuthenticatedEntity addListItem(LocalizedTransactionalTravelInventoryNonAuthenticatedEntity _listItem) {
    if (this._list == null) {
      this._list = new ArrayList<>();
    }
    this._list.add(_listItem);
    return this;
  }

  /**
   * Get _list
   * @return _list
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<@Valid LocalizedTransactionalTravelInventoryNonAuthenticatedEntity> getList() {
    return _list;
  }


  @JsonProperty(JSON_PROPERTY_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setList(@jakarta.annotation.Nullable List<@Valid LocalizedTransactionalTravelInventoryNonAuthenticatedEntity> _list) {
    this._list = _list;
  }

  public RoomConfigurationPriceNonAuthenticatedEntity channelInventoryIdentifier(@jakarta.annotation.Nonnull String channelInventoryIdentifier) {
    
    this.channelInventoryIdentifier = channelInventoryIdentifier;
    return this;
  }

  /**
   * Sales channel inventory identifier
   * @return channelInventoryIdentifier
   */
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_CHANNEL_INVENTORY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getChannelInventoryIdentifier() {
    return channelInventoryIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_CHANNEL_INVENTORY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setChannelInventoryIdentifier(@jakarta.annotation.Nonnull String channelInventoryIdentifier) {
    this.channelInventoryIdentifier = channelInventoryIdentifier;
  }

  public RoomConfigurationPriceNonAuthenticatedEntity commissionable(@jakarta.annotation.Nonnull Boolean commissionable) {
    
    this.commissionable = commissionable;
    return this;
  }

  /**
   * Whether this package is commissionable based on the incoming sales channel.
   * @return commissionable
   */
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_COMMISSIONABLE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getCommissionable() {
    return commissionable;
  }


  @JsonProperty(JSON_PROPERTY_COMMISSIONABLE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCommissionable(@jakarta.annotation.Nonnull Boolean commissionable) {
    this.commissionable = commissionable;
  }

  public RoomConfigurationPriceNonAuthenticatedEntity commission(@jakarta.annotation.Nonnull Float commission) {
    
    this.commission = commission;
    return this;
  }

  /**
   * The commission percentage.
   * @return commission
   */
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_COMMISSION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Float getCommission() {
    return commission;
  }


  @JsonProperty(JSON_PROPERTY_COMMISSION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCommission(@jakarta.annotation.Nonnull Float commission) {
    this.commission = commission;
  }

  public RoomConfigurationPriceNonAuthenticatedEntity direct(@jakarta.annotation.Nonnull Boolean direct) {
    
    this.direct = direct;
    return this;
  }

  /**
   * Indicates whether the blocking from sales channel is direct or not. If you are a travel agent doing your own acquiring, this flag has to be true to make a booking.
   * @return direct
   */
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_DIRECT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getDirect() {
    return direct;
  }


  @JsonProperty(JSON_PROPERTY_DIRECT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDirect(@jakarta.annotation.Nonnull Boolean direct) {
    this.direct = direct;
  }

  public RoomConfigurationPriceNonAuthenticatedEntity priceList(@jakarta.annotation.Nullable List<Object> priceList) {
    
    this.priceList = priceList;
    return this;
  }

  public RoomConfigurationPriceNonAuthenticatedEntity addPriceListItem(Object priceListItem) {
    if (this.priceList == null) {
      this.priceList = new ArrayList<>();
    }
    this.priceList.add(priceListItem);
    return this;
  }

  /**
   * Get priceList
   * @return priceList
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PRICE_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Object> getPriceList() {
    return priceList;
  }


  @JsonProperty(JSON_PROPERTY_PRICE_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPriceList(@jakarta.annotation.Nullable List<Object> priceList) {
    this.priceList = priceList;
  }

  public RoomConfigurationPriceNonAuthenticatedEntity available(@jakarta.annotation.Nullable Boolean available) {
    
    this.available = available;
    return this;
  }

  /**
   * Get available
   * @return available
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_AVAILABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getAvailable() {
    return available;
  }


  @JsonProperty(JSON_PROPERTY_AVAILABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAvailable(@jakarta.annotation.Nullable Boolean available) {
    this.available = available;
  }

  public RoomConfigurationPriceNonAuthenticatedEntity rateSource(@jakarta.annotation.Nullable String rateSource) {
    
    this.rateSource = rateSource;
    return this;
  }

  /**
   * Get rateSource
   * @return rateSource
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_RATE_SOURCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRateSource() {
    return rateSource;
  }


  @JsonProperty(JSON_PROPERTY_RATE_SOURCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRateSource(@jakarta.annotation.Nullable String rateSource) {
    this.rateSource = rateSource;
  }

  public RoomConfigurationPriceNonAuthenticatedEntity sourceTotal(@jakarta.annotation.Nullable CustomMonetaryAmount sourceTotal) {
    
    this.sourceTotal = sourceTotal;
    return this;
  }

  /**
   * Get sourceTotal
   * @return sourceTotal
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SOURCE_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getSourceTotal() {
    return sourceTotal;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourceTotal(@jakarta.annotation.Nullable CustomMonetaryAmount sourceTotal) {
    this.sourceTotal = sourceTotal;
  }

  public RoomConfigurationPriceNonAuthenticatedEntity userSpecifiedCurrencyTotal(@jakarta.annotation.Nullable CustomMonetaryAmount userSpecifiedCurrencyTotal) {
    
    this.userSpecifiedCurrencyTotal = userSpecifiedCurrencyTotal;
    return this;
  }

  /**
   * Get userSpecifiedCurrencyTotal
   * @return userSpecifiedCurrencyTotal
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getUserSpecifiedCurrencyTotal() {
    return userSpecifiedCurrencyTotal;
  }


  @JsonProperty(JSON_PROPERTY_USER_SPECIFIED_CURRENCY_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUserSpecifiedCurrencyTotal(@jakarta.annotation.Nullable CustomMonetaryAmount userSpecifiedCurrencyTotal) {
    this.userSpecifiedCurrencyTotal = userSpecifiedCurrencyTotal;
  }

  public RoomConfigurationPriceNonAuthenticatedEntity internalTotal(@jakarta.annotation.Nullable CustomMonetaryAmount internalTotal) {
    
    this.internalTotal = internalTotal;
    return this;
  }

  /**
   * Get internalTotal
   * @return internalTotal
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_INTERNAL_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getInternalTotal() {
    return internalTotal;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInternalTotal(@jakarta.annotation.Nullable CustomMonetaryAmount internalTotal) {
    this.internalTotal = internalTotal;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RoomConfigurationPriceNonAuthenticatedEntity roomConfigurationPriceNonAuthenticatedEntity = (RoomConfigurationPriceNonAuthenticatedEntity) o;
    return Objects.equals(this.adults, roomConfigurationPriceNonAuthenticatedEntity.adults) &&
        Objects.equals(this.children, roomConfigurationPriceNonAuthenticatedEntity.children) &&
        Objects.equals(this.startDate, roomConfigurationPriceNonAuthenticatedEntity.startDate) &&
        Objects.equals(this.endDate, roomConfigurationPriceNonAuthenticatedEntity.endDate) &&
        Objects.equals(this.roomRateIdentifier, roomConfigurationPriceNonAuthenticatedEntity.roomRateIdentifier) &&
        Objects.equals(this.roomRateInternalName, roomConfigurationPriceNonAuthenticatedEntity.roomRateInternalName) &&
        Objects.equals(this.ratePlan, roomConfigurationPriceNonAuthenticatedEntity.ratePlan) &&
        Objects.equals(this.perkTypes, roomConfigurationPriceNonAuthenticatedEntity.perkTypes) &&
        Objects.equals(this.price, roomConfigurationPriceNonAuthenticatedEntity.price) &&
        Objects.equals(this.extraCharges, roomConfigurationPriceNonAuthenticatedEntity.extraCharges) &&
        Objects.equals(this._configuration, roomConfigurationPriceNonAuthenticatedEntity._configuration) &&
        Objects.equals(this.addOnOffers, roomConfigurationPriceNonAuthenticatedEntity.addOnOffers) &&
        Objects.equals(this.perkValue, roomConfigurationPriceNonAuthenticatedEntity.perkValue) &&
        Objects.equals(this.activeCancellationPolicy, roomConfigurationPriceNonAuthenticatedEntity.activeCancellationPolicy) &&
        Objects.equals(this.roomNights, roomConfigurationPriceNonAuthenticatedEntity.roomNights) &&
        Objects.equals(this._list, roomConfigurationPriceNonAuthenticatedEntity._list) &&
        Objects.equals(this.channelInventoryIdentifier, roomConfigurationPriceNonAuthenticatedEntity.channelInventoryIdentifier) &&
        Objects.equals(this.commissionable, roomConfigurationPriceNonAuthenticatedEntity.commissionable) &&
        Objects.equals(this.commission, roomConfigurationPriceNonAuthenticatedEntity.commission) &&
        Objects.equals(this.direct, roomConfigurationPriceNonAuthenticatedEntity.direct) &&
        Objects.equals(this.priceList, roomConfigurationPriceNonAuthenticatedEntity.priceList) &&
        Objects.equals(this.available, roomConfigurationPriceNonAuthenticatedEntity.available) &&
        Objects.equals(this.rateSource, roomConfigurationPriceNonAuthenticatedEntity.rateSource) &&
        Objects.equals(this.sourceTotal, roomConfigurationPriceNonAuthenticatedEntity.sourceTotal) &&
        Objects.equals(this.userSpecifiedCurrencyTotal, roomConfigurationPriceNonAuthenticatedEntity.userSpecifiedCurrencyTotal) &&
        Objects.equals(this.internalTotal, roomConfigurationPriceNonAuthenticatedEntity.internalTotal);
  }

  @Override
  public int hashCode() {
    return Objects.hash(adults, children, startDate, endDate, roomRateIdentifier, roomRateInternalName, ratePlan, perkTypes, price, extraCharges, _configuration, addOnOffers, perkValue, activeCancellationPolicy, roomNights, _list, channelInventoryIdentifier, commissionable, commission, direct, priceList, available, rateSource, sourceTotal, userSpecifiedCurrencyTotal, internalTotal);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RoomConfigurationPriceNonAuthenticatedEntity {\n");
    sb.append("    adults: ").append(toIndentedString(adults)).append("\n");
    sb.append("    children: ").append(toIndentedString(children)).append("\n");
    sb.append("    startDate: ").append(toIndentedString(startDate)).append("\n");
    sb.append("    endDate: ").append(toIndentedString(endDate)).append("\n");
    sb.append("    roomRateIdentifier: ").append(toIndentedString(roomRateIdentifier)).append("\n");
    sb.append("    roomRateInternalName: ").append(toIndentedString(roomRateInternalName)).append("\n");
    sb.append("    ratePlan: ").append(toIndentedString(ratePlan)).append("\n");
    sb.append("    perkTypes: ").append(toIndentedString(perkTypes)).append("\n");
    sb.append("    price: ").append(toIndentedString(price)).append("\n");
    sb.append("    extraCharges: ").append(toIndentedString(extraCharges)).append("\n");
    sb.append("    _configuration: ").append(toIndentedString(_configuration)).append("\n");
    sb.append("    addOnOffers: ").append(toIndentedString(addOnOffers)).append("\n");
    sb.append("    perkValue: ").append(toIndentedString(perkValue)).append("\n");
    sb.append("    activeCancellationPolicy: ").append(toIndentedString(activeCancellationPolicy)).append("\n");
    sb.append("    roomNights: ").append(toIndentedString(roomNights)).append("\n");
    sb.append("    _list: ").append(toIndentedString(_list)).append("\n");
    sb.append("    channelInventoryIdentifier: ").append(toIndentedString(channelInventoryIdentifier)).append("\n");
    sb.append("    commissionable: ").append(toIndentedString(commissionable)).append("\n");
    sb.append("    commission: ").append(toIndentedString(commission)).append("\n");
    sb.append("    direct: ").append(toIndentedString(direct)).append("\n");
    sb.append("    priceList: ").append(toIndentedString(priceList)).append("\n");
    sb.append("    available: ").append(toIndentedString(available)).append("\n");
    sb.append("    rateSource: ").append(toIndentedString(rateSource)).append("\n");
    sb.append("    sourceTotal: ").append(toIndentedString(sourceTotal)).append("\n");
    sb.append("    userSpecifiedCurrencyTotal: ").append(toIndentedString(userSpecifiedCurrencyTotal)).append("\n");
    sb.append("    internalTotal: ").append(toIndentedString(internalTotal)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

