/*
 * Wink API
 *  # Introduction  Welcome to the Wink API - A programmer-friendly way to manage, sell and book travel inventory on the Wink platform. The API gives you all the tools you need to ready your properties and inventory for sale across 1000s of our native sales channels.  Integrators, affiliates, travel agents and content creators have the ability search for your travel inventory and promote / sell it in a wide variety of ways.   # Integrations  We have already integrated with the most well-known channel managers so you don't have to. To see our current integrations, please go to https://extranet.wink.travel and scroll to Connectivity section. Once your properties are set up, you can finish the setup by mapping your property to Wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API.   # Intended Audience  Programmers are [most likely] a requirement to start integrating with Wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible.  - Hotel chains  - Hotel brands  - Travel tech companies  - Destination sites  - Integrators  - Aggregators  - Destination management companies  - Travel agencies  - OTAs   ## APIs  Not every integrator needs every API. For that reason, we have separated APIs into context.  ### Test API   - [Ping](/ping): The Ping API is a quick test endpoint to verify that your credentials work Wink.  ### Common APIs  - [Notifications](/notifications): The Notifications API is a way for us to stay in touch with your user, property or affiliate account. - [User Settings](/user-settings): The User Settings API exposes endpoints to allow 3rd party integrators to communicate with Wink.  ### Consume APIs Consume endpoints are for developers who want to find existing travel inventory and either book it or use it to advertise through one of their Wink affiliate accounts.   - [Configuration](/customization-client): A single endpoint to retrieve whitelabel + customization information for the booking customization.  - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags.  - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API..  - [Booking](/booking): All APIs related to creating bookings on the platform.  - [Travel Agent](/travel-agent): The Travel Agent API exposes endpoints to manage agent-facilitated bookings.   ### Produce APIs  Produce endpoints are for developers who want to create and manage travel inventory.   #### Property  - [Property registration](/extranet/property/register): As a producer, this is, oftentimes, where you start your journey. These endpoints let you create properties on Wink.  - [Property](/extranet/property): This collection of property endpoints are mostly management endpoints that let you display, change status and similar for your existing properties.  - [Facilities](/extranet/facilities): This collection of endpoints let you manage facilities; such as room types.  - [Experiences](/extranet/experiences): This collection of endpoints let you manage experiences, such as activities.  - [Monetize](/extranet/monetize): The Monetize API exposes endpoints for managing cancellation polies, rate plans, promotions and more on Wink.  - [Distribution](/extranet/distribution): The Distribution API exposes endpoints for sales channels, connecting with affiliates, managing rates and inventory calendars and more on Wink.  - [Property Booking](/extranet/booking): The Property Booking API exposes endpoints for managing bookings and reviews at the property-level.   #### Affiliate  - [Affiliate](/affiliate): This collection of affiliate endpoints are mostly management endpoints that let you display, change status and similar for your existing accounts.  - [Browse](/affiliate/browse): The Browse API exposes endpoints for affiliates to find suppliers and inventory to sell.  - [Inventory](/affiliate/inventory): The Inventory API exposes endpoints for affiliates to manage the inventory they want to sell and how they want to sell it.  - [Sales Channel](/affiliate/sales-channel): The Sales Channel API exposes endpoints for affiliates to manage existing sales channels as well as find new ones.  - [WinkLinks](/affiliate/winklinks): The WinkLinks API exposes endpoints for affiliates to manage their WinkLinks page.   #### Rate provider  - [Channel manager](/channel-manager): The Channel Manager API enables external channel manager partners to map, exchange rate / availability information with us as well as be informed of bookings that occur on the Wink platform for one of their properties.   ### Taxonomy APIs  Taxonomy endpoints are for developers who want to consume and produce travel inventory and need taxonomies of standard and non-standard codes for inventory types, classes, statuses etc.   - [Reference](/reactive): All APIs related to retrieving platform-supported taxonomies.   ### Insight APIs  Insight endpoints do exactly what the name implies - They offer platform-level insight into the activities of producers and consumers.   - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics.   ### Payment APIs  Payment endpoints are for developers who want to purchase travel inventory. This can be done via the API as a registered Travel Agent or using our API in conjunction with our PCI compliant reactive widget for all other entities.   - [TripPay](/reactive): All APIs related to TripPay account management, booking, mapping and integration features.   ## SDKs  We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).   - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)   ## Usage  These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.   ## Versioning  We chose to version our endpoints in a way that we hope affects your integration minimally. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.   ## Release history  - Follow updates on Github: https://github.com/wink-travel/wink-sdk-java/blob/master/CHANGELOG.md    # Inventory API The Inventory API exposes endpoints to retrieve inventory you already know about. This API lets you:  1. Consume shareable links. 2. Load up a known property with availability. 3. Load up all inventories that were created by our affiliates such as grids, maps, and individual items.  Browse the endpoints in the left navigation bar to get started.  
 *
 * The version of the OpenAPI document: 30.17.8
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.inventory.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import travel.wink.sdk.inventory.model.SimpleDescriptionNonAuthenticatedEntity;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * SellableItemLightweightNonAuthenticatedEntity
 */
@JsonPropertyOrder({
  SellableItemLightweightNonAuthenticatedEntity.JSON_PROPERTY_IDENTIFIER,
  SellableItemLightweightNonAuthenticatedEntity.JSON_PROPERTY_OWNER_IDENTIFIER,
  SellableItemLightweightNonAuthenticatedEntity.JSON_PROPERTY_NAME,
  SellableItemLightweightNonAuthenticatedEntity.JSON_PROPERTY_CUSTOMIZATION_IDENTIFIER,
  SellableItemLightweightNonAuthenticatedEntity.JSON_PROPERTY_DESCRIPTIONS,
  SellableItemLightweightNonAuthenticatedEntity.JSON_PROPERTY_KEYWORDS,
  SellableItemLightweightNonAuthenticatedEntity.JSON_PROPERTY_STATUS,
  SellableItemLightweightNonAuthenticatedEntity.JSON_PROPERTY_INVENTORY_STATUS,
  SellableItemLightweightNonAuthenticatedEntity.JSON_PROPERTY_INVENTORY_TYPE,
  SellableItemLightweightNonAuthenticatedEntity.JSON_PROPERTY_CHANNEL_INVENTORY_TYPE,
  SellableItemLightweightNonAuthenticatedEntity.JSON_PROPERTY_SUPPLIER_IDENTIFIER,
  SellableItemLightweightNonAuthenticatedEntity.JSON_PROPERTY_CHANNEL_INVENTORY_IDENTIFIER,
  SellableItemLightweightNonAuthenticatedEntity.JSON_PROPERTY_MULTIMEDIA_IDENTIFIERS,
  SellableItemLightweightNonAuthenticatedEntity.JSON_PROPERTY_ANIMATE,
  SellableItemLightweightNonAuthenticatedEntity.JSON_PROPERTY_ANIMATE_DELAY,
  SellableItemLightweightNonAuthenticatedEntity.JSON_PROPERTY_SORT,
  SellableItemLightweightNonAuthenticatedEntity.JSON_PROPERTY_DISPLAY_TYPE
})
@JsonTypeName("SellableItemLightweight_Non_Authenticated_Entity")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-06-26T20:20:31.141212618+07:00[Asia/Bangkok]", comments = "Generator version: 7.13.0")
public class SellableItemLightweightNonAuthenticatedEntity {
  public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
  @jakarta.annotation.Nonnull
  private UUID identifier;

  public static final String JSON_PROPERTY_OWNER_IDENTIFIER = "ownerIdentifier";
  @jakarta.annotation.Nonnull
  private UUID ownerIdentifier;

  public static final String JSON_PROPERTY_NAME = "name";
  @jakarta.annotation.Nonnull
  private String name;

  public static final String JSON_PROPERTY_CUSTOMIZATION_IDENTIFIER = "customizationIdentifier";
  @jakarta.annotation.Nonnull
  private UUID customizationIdentifier;

  public static final String JSON_PROPERTY_DESCRIPTIONS = "descriptions";
  @jakarta.annotation.Nonnull
  private List<@Valid SimpleDescriptionNonAuthenticatedEntity> descriptions = new ArrayList<>();

  public static final String JSON_PROPERTY_KEYWORDS = "keywords";
  @jakarta.annotation.Nonnull
  private List<Object> keywords = new ArrayList<>();

  /**
   * Availability status
   */
  public enum StatusEnum {
    ACTIVE(String.valueOf("ACTIVE")),
    
    INACTIVE(String.valueOf("INACTIVE")),
    
    REMOVED(String.valueOf("REMOVED"));

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static StatusEnum fromValue(String value) {
      for (StatusEnum b : StatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_STATUS = "status";
  @jakarta.annotation.Nonnull
  private StatusEnum status = StatusEnum.ACTIVE;

  /**
   * Url sell status
   */
  public enum InventoryStatusEnum {
    ACTIVE(String.valueOf("ACTIVE")),
    
    INACTIVE(String.valueOf("INACTIVE")),
    
    REMOVED(String.valueOf("REMOVED"));

    private String value;

    InventoryStatusEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static InventoryStatusEnum fromValue(String value) {
      for (InventoryStatusEnum b : InventoryStatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_INVENTORY_STATUS = "inventoryStatus";
  @jakarta.annotation.Nonnull
  private InventoryStatusEnum inventoryStatus;

  /**
   * The type of blocking being offer up for sale
   */
  public enum InventoryTypeEnum {
    HOTEL(String.valueOf("HOTEL")),
    
    GUEST_ROOM(String.valueOf("GUEST_ROOM")),
    
    MEETING_ROOM(String.valueOf("MEETING_ROOM")),
    
    RESTAURANT(String.valueOf("RESTAURANT")),
    
    SPA(String.valueOf("SPA")),
    
    ADD_ON(String.valueOf("ADD_ON")),
    
    ATTRACTION(String.valueOf("ATTRACTION")),
    
    ACTIVITY(String.valueOf("ACTIVITY")),
    
    PLACE(String.valueOf("PLACE"));

    private String value;

    InventoryTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static InventoryTypeEnum fromValue(String value) {
      for (InventoryTypeEnum b : InventoryTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_INVENTORY_TYPE = "inventoryType";
  @jakarta.annotation.Nonnull
  private InventoryTypeEnum inventoryType;

  /**
   * Channel inventory type is a subset of blocking type in that it does not include the &#x60;HOTEL&#x60; type. THe way it works is, as a seller you might want to sell a guest room but instead of showing the price of that guest room, you would like to display the best room type price for the property.
   */
  public enum ChannelInventoryTypeEnum {
    GUEST_ROOM(String.valueOf("GUEST_ROOM")),
    
    ADD_ON(String.valueOf("ADD_ON")),
    
    MEETING_ROOM(String.valueOf("MEETING_ROOM")),
    
    RESTAURANT(String.valueOf("RESTAURANT")),
    
    SPA(String.valueOf("SPA")),
    
    ATTRACTION(String.valueOf("ATTRACTION")),
    
    PLACE(String.valueOf("PLACE")),
    
    ACTIVITY(String.valueOf("ACTIVITY"));

    private String value;

    ChannelInventoryTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ChannelInventoryTypeEnum fromValue(String value) {
      for (ChannelInventoryTypeEnum b : ChannelInventoryTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_CHANNEL_INVENTORY_TYPE = "channelInventoryType";
  @jakarta.annotation.Nonnull
  private ChannelInventoryTypeEnum channelInventoryType;

  public static final String JSON_PROPERTY_SUPPLIER_IDENTIFIER = "supplierIdentifier";
  @jakarta.annotation.Nonnull
  private UUID supplierIdentifier;

  public static final String JSON_PROPERTY_CHANNEL_INVENTORY_IDENTIFIER = "channelInventoryIdentifier";
  @jakarta.annotation.Nonnull
  private UUID channelInventoryIdentifier;

  public static final String JSON_PROPERTY_MULTIMEDIA_IDENTIFIERS = "multimediaIdentifiers";
  @jakarta.annotation.Nonnull
  private List<String> multimediaIdentifiers = new ArrayList<>();

  public static final String JSON_PROPERTY_ANIMATE = "animate";
  @jakarta.annotation.Nullable
  private Boolean animate = false;

  public static final String JSON_PROPERTY_ANIMATE_DELAY = "animateDelay";
  @jakarta.annotation.Nullable
  private Integer animateDelay;

  /**
   * The specific badge to display over the image on the Web Component.
   */
  public enum SortEnum {
    MEMBER(String.valueOf("MEMBER")),
    
    PRICE_LOW_TO_HIGH(String.valueOf("PRICE_LOW_TO_HIGH")),
    
    PRICE_HIGH_TO_LOW(String.valueOf("PRICE_HIGH_TO_LOW")),
    
    PRICE(String.valueOf("PRICE")),
    
    POPULARITY(String.valueOf("POPULARITY")),
    
    ECO(String.valueOf("ECO")),
    
    EXPERIENCE(String.valueOf("EXPERIENCE")),
    
    PERK(String.valueOf("PERK")),
    
    LOYALTY(String.valueOf("LOYALTY")),
    
    ADD_ON(String.valueOf("ADD_ON"));

    private String value;

    SortEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static SortEnum fromValue(String value) {
      for (SortEnum b : SortEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_SORT = "sort";
  @jakarta.annotation.Nullable
  private SortEnum sort;

  /**
   * Indicate which initial values to display first on the front-facing card
   */
  public enum DisplayTypeEnum {
    NATIVE(String.valueOf("NATIVE")),
    
    HOTEL(String.valueOf("HOTEL")),
    
    ROOM(String.valueOf("ROOM"));

    private String value;

    DisplayTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static DisplayTypeEnum fromValue(String value) {
      for (DisplayTypeEnum b : DisplayTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_DISPLAY_TYPE = "displayType";
  @jakarta.annotation.Nonnull
  private DisplayTypeEnum displayType = DisplayTypeEnum.NATIVE;

  public SellableItemLightweightNonAuthenticatedEntity() {
  }

  public SellableItemLightweightNonAuthenticatedEntity identifier(@jakarta.annotation.Nonnull UUID identifier) {
    
    this.identifier = identifier;
    return this;
  }

  /**
   * Unique identifier
   * @return identifier
   */
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid
 @Size(min=1)
  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getIdentifier() {
    return identifier;
  }


  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setIdentifier(@jakarta.annotation.Nonnull UUID identifier) {
    this.identifier = identifier;
  }

  public SellableItemLightweightNonAuthenticatedEntity ownerIdentifier(@jakarta.annotation.Nonnull UUID ownerIdentifier) {
    
    this.ownerIdentifier = ownerIdentifier;
    return this;
  }

  /**
   * AffiliateAccountLightweight / Owner identifier
   * @return ownerIdentifier
   */
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid
 @Size(min=1)
  @JsonProperty(JSON_PROPERTY_OWNER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getOwnerIdentifier() {
    return ownerIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_OWNER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setOwnerIdentifier(@jakarta.annotation.Nonnull UUID ownerIdentifier) {
    this.ownerIdentifier = ownerIdentifier;
  }

  public SellableItemLightweightNonAuthenticatedEntity name(@jakarta.annotation.Nonnull String name) {
    
    this.name = name;
    return this;
  }

  /**
   * Descriptive name of this item for seller use
   * @return name
   */
  @jakarta.annotation.Nonnull
  @NotNull
 @Size(min=1)
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setName(@jakarta.annotation.Nonnull String name) {
    this.name = name;
  }

  public SellableItemLightweightNonAuthenticatedEntity customizationIdentifier(@jakarta.annotation.Nonnull UUID customizationIdentifier) {
    
    this.customizationIdentifier = customizationIdentifier;
    return this;
  }

  /**
   * Which configuration to use with this item
   * @return customizationIdentifier
   */
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid
 @Size(min=1)
  @JsonProperty(JSON_PROPERTY_CUSTOMIZATION_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getCustomizationIdentifier() {
    return customizationIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_CUSTOMIZATION_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCustomizationIdentifier(@jakarta.annotation.Nonnull UUID customizationIdentifier) {
    this.customizationIdentifier = customizationIdentifier;
  }

  public SellableItemLightweightNonAuthenticatedEntity descriptions(@jakarta.annotation.Nonnull List<@Valid SimpleDescriptionNonAuthenticatedEntity> descriptions) {
    
    this.descriptions = descriptions;
    return this;
  }

  public SellableItemLightweightNonAuthenticatedEntity addDescriptionsItem(SimpleDescriptionNonAuthenticatedEntity descriptionsItem) {
    if (this.descriptions == null) {
      this.descriptions = new ArrayList<>();
    }
    this.descriptions.add(descriptionsItem);
    return this;
  }

  /**
   * Title and description of blocking.
   * @return descriptions
   */
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid
 @Size(min=1,max=2147483647)
  @JsonProperty(JSON_PROPERTY_DESCRIPTIONS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<@Valid SimpleDescriptionNonAuthenticatedEntity> getDescriptions() {
    return descriptions;
  }


  @JsonProperty(JSON_PROPERTY_DESCRIPTIONS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDescriptions(@jakarta.annotation.Nonnull List<@Valid SimpleDescriptionNonAuthenticatedEntity> descriptions) {
    this.descriptions = descriptions;
  }

  public SellableItemLightweightNonAuthenticatedEntity keywords(@jakarta.annotation.Nonnull List<Object> keywords) {
    
    this.keywords = keywords;
    return this;
  }

  public SellableItemLightweightNonAuthenticatedEntity addKeywordsItem(Object keywordsItem) {
    if (this.keywords == null) {
      this.keywords = new ArrayList<>();
    }
    this.keywords.add(keywordsItem);
    return this;
  }

  /**
   * Get keywords
   * @return keywords
   */
  @jakarta.annotation.Nonnull
  @NotNull
 @Size(min=1,max=2147483647)
  @JsonProperty(JSON_PROPERTY_KEYWORDS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<Object> getKeywords() {
    return keywords;
  }


  @JsonProperty(JSON_PROPERTY_KEYWORDS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setKeywords(@jakarta.annotation.Nonnull List<Object> keywords) {
    this.keywords = keywords;
  }

  public SellableItemLightweightNonAuthenticatedEntity status(@jakarta.annotation.Nonnull StatusEnum status) {
    
    this.status = status;
    return this;
  }

  /**
   * Availability status
   * @return status
   */
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public StatusEnum getStatus() {
    return status;
  }


  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setStatus(@jakarta.annotation.Nonnull StatusEnum status) {
    this.status = status;
  }

  public SellableItemLightweightNonAuthenticatedEntity inventoryStatus(@jakarta.annotation.Nonnull InventoryStatusEnum inventoryStatus) {
    
    this.inventoryStatus = inventoryStatus;
    return this;
  }

  /**
   * Url sell status
   * @return inventoryStatus
   */
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_INVENTORY_STATUS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public InventoryStatusEnum getInventoryStatus() {
    return inventoryStatus;
  }


  @JsonProperty(JSON_PROPERTY_INVENTORY_STATUS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setInventoryStatus(@jakarta.annotation.Nonnull InventoryStatusEnum inventoryStatus) {
    this.inventoryStatus = inventoryStatus;
  }

  public SellableItemLightweightNonAuthenticatedEntity inventoryType(@jakarta.annotation.Nonnull InventoryTypeEnum inventoryType) {
    
    this.inventoryType = inventoryType;
    return this;
  }

  /**
   * The type of blocking being offer up for sale
   * @return inventoryType
   */
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_INVENTORY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public InventoryTypeEnum getInventoryType() {
    return inventoryType;
  }


  @JsonProperty(JSON_PROPERTY_INVENTORY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setInventoryType(@jakarta.annotation.Nonnull InventoryTypeEnum inventoryType) {
    this.inventoryType = inventoryType;
  }

  public SellableItemLightweightNonAuthenticatedEntity channelInventoryType(@jakarta.annotation.Nonnull ChannelInventoryTypeEnum channelInventoryType) {
    
    this.channelInventoryType = channelInventoryType;
    return this;
  }

  /**
   * Channel inventory type is a subset of blocking type in that it does not include the &#x60;HOTEL&#x60; type. THe way it works is, as a seller you might want to sell a guest room but instead of showing the price of that guest room, you would like to display the best room type price for the property.
   * @return channelInventoryType
   */
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_CHANNEL_INVENTORY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public ChannelInventoryTypeEnum getChannelInventoryType() {
    return channelInventoryType;
  }


  @JsonProperty(JSON_PROPERTY_CHANNEL_INVENTORY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setChannelInventoryType(@jakarta.annotation.Nonnull ChannelInventoryTypeEnum channelInventoryType) {
    this.channelInventoryType = channelInventoryType;
  }

  public SellableItemLightweightNonAuthenticatedEntity supplierIdentifier(@jakarta.annotation.Nonnull UUID supplierIdentifier) {
    
    this.supplierIdentifier = supplierIdentifier;
    return this;
  }

  /**
   * Supplier / Hotel identifier that owns this blocking.
   * @return supplierIdentifier
   */
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid
 @Size(min=1)
  @JsonProperty(JSON_PROPERTY_SUPPLIER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getSupplierIdentifier() {
    return supplierIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_SUPPLIER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSupplierIdentifier(@jakarta.annotation.Nonnull UUID supplierIdentifier) {
    this.supplierIdentifier = supplierIdentifier;
  }

  public SellableItemLightweightNonAuthenticatedEntity channelInventoryIdentifier(@jakarta.annotation.Nonnull UUID channelInventoryIdentifier) {
    
    this.channelInventoryIdentifier = channelInventoryIdentifier;
    return this;
  }

  /**
   * The channel inventory record identifier describing the relationship between supplier and seller.
   * @return channelInventoryIdentifier
   */
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid
 @Size(min=1)
  @JsonProperty(JSON_PROPERTY_CHANNEL_INVENTORY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getChannelInventoryIdentifier() {
    return channelInventoryIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_CHANNEL_INVENTORY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setChannelInventoryIdentifier(@jakarta.annotation.Nonnull UUID channelInventoryIdentifier) {
    this.channelInventoryIdentifier = channelInventoryIdentifier;
  }

  public SellableItemLightweightNonAuthenticatedEntity multimediaIdentifiers(@jakarta.annotation.Nonnull List<String> multimediaIdentifiers) {
    
    this.multimediaIdentifiers = multimediaIdentifiers;
    return this;
  }

  public SellableItemLightweightNonAuthenticatedEntity addMultimediaIdentifiersItem(String multimediaIdentifiersItem) {
    if (this.multimediaIdentifiers == null) {
      this.multimediaIdentifiers = new ArrayList<>();
    }
    this.multimediaIdentifiers.add(multimediaIdentifiersItem);
    return this;
  }

  /**
   * Reference identifiers to Cloudinary media assets
   * @return multimediaIdentifiers
   */
  @jakarta.annotation.Nonnull
  @NotNull
 @Size(min=1,max=2147483647)
  @JsonProperty(JSON_PROPERTY_MULTIMEDIA_IDENTIFIERS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<String> getMultimediaIdentifiers() {
    return multimediaIdentifiers;
  }


  @JsonProperty(JSON_PROPERTY_MULTIMEDIA_IDENTIFIERS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setMultimediaIdentifiers(@jakarta.annotation.Nonnull List<String> multimediaIdentifiers) {
    this.multimediaIdentifiers = multimediaIdentifiers;
  }

  public SellableItemLightweightNonAuthenticatedEntity animate(@jakarta.annotation.Nullable Boolean animate) {
    
    this.animate = animate;
    return this;
  }

  /**
   * Create an animated gif instead of a list of images. Feature currently not available. Feel free to enable and it will become available at a later date.
   * @return animate
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ANIMATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getAnimate() {
    return animate;
  }


  @JsonProperty(JSON_PROPERTY_ANIMATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAnimate(@jakarta.annotation.Nullable Boolean animate) {
    this.animate = animate;
  }

  public SellableItemLightweightNonAuthenticatedEntity animateDelay(@jakarta.annotation.Nullable Integer animateDelay) {
    
    this.animateDelay = animateDelay;
    return this;
  }

  /**
   * Controls animation delay in milliseconds.
   * @return animateDelay
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ANIMATE_DELAY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getAnimateDelay() {
    return animateDelay;
  }


  @JsonProperty(JSON_PROPERTY_ANIMATE_DELAY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAnimateDelay(@jakarta.annotation.Nullable Integer animateDelay) {
    this.animateDelay = animateDelay;
  }

  public SellableItemLightweightNonAuthenticatedEntity sort(@jakarta.annotation.Nullable SortEnum sort) {
    
    this.sort = sort;
    return this;
  }

  /**
   * The specific badge to display over the image on the Web Component.
   * @return sort
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public SortEnum getSort() {
    return sort;
  }


  @JsonProperty(JSON_PROPERTY_SORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSort(@jakarta.annotation.Nullable SortEnum sort) {
    this.sort = sort;
  }

  public SellableItemLightweightNonAuthenticatedEntity displayType(@jakarta.annotation.Nonnull DisplayTypeEnum displayType) {
    
    this.displayType = displayType;
    return this;
  }

  /**
   * Indicate which initial values to display first on the front-facing card
   * @return displayType
   */
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_DISPLAY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public DisplayTypeEnum getDisplayType() {
    return displayType;
  }


  @JsonProperty(JSON_PROPERTY_DISPLAY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDisplayType(@jakarta.annotation.Nonnull DisplayTypeEnum displayType) {
    this.displayType = displayType;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SellableItemLightweightNonAuthenticatedEntity sellableItemLightweightNonAuthenticatedEntity = (SellableItemLightweightNonAuthenticatedEntity) o;
    return Objects.equals(this.identifier, sellableItemLightweightNonAuthenticatedEntity.identifier) &&
        Objects.equals(this.ownerIdentifier, sellableItemLightweightNonAuthenticatedEntity.ownerIdentifier) &&
        Objects.equals(this.name, sellableItemLightweightNonAuthenticatedEntity.name) &&
        Objects.equals(this.customizationIdentifier, sellableItemLightweightNonAuthenticatedEntity.customizationIdentifier) &&
        Objects.equals(this.descriptions, sellableItemLightweightNonAuthenticatedEntity.descriptions) &&
        Objects.equals(this.keywords, sellableItemLightweightNonAuthenticatedEntity.keywords) &&
        Objects.equals(this.status, sellableItemLightweightNonAuthenticatedEntity.status) &&
        Objects.equals(this.inventoryStatus, sellableItemLightweightNonAuthenticatedEntity.inventoryStatus) &&
        Objects.equals(this.inventoryType, sellableItemLightweightNonAuthenticatedEntity.inventoryType) &&
        Objects.equals(this.channelInventoryType, sellableItemLightweightNonAuthenticatedEntity.channelInventoryType) &&
        Objects.equals(this.supplierIdentifier, sellableItemLightweightNonAuthenticatedEntity.supplierIdentifier) &&
        Objects.equals(this.channelInventoryIdentifier, sellableItemLightweightNonAuthenticatedEntity.channelInventoryIdentifier) &&
        Objects.equals(this.multimediaIdentifiers, sellableItemLightweightNonAuthenticatedEntity.multimediaIdentifiers) &&
        Objects.equals(this.animate, sellableItemLightweightNonAuthenticatedEntity.animate) &&
        Objects.equals(this.animateDelay, sellableItemLightweightNonAuthenticatedEntity.animateDelay) &&
        Objects.equals(this.sort, sellableItemLightweightNonAuthenticatedEntity.sort) &&
        Objects.equals(this.displayType, sellableItemLightweightNonAuthenticatedEntity.displayType);
  }

  @Override
  public int hashCode() {
    return Objects.hash(identifier, ownerIdentifier, name, customizationIdentifier, descriptions, keywords, status, inventoryStatus, inventoryType, channelInventoryType, supplierIdentifier, channelInventoryIdentifier, multimediaIdentifiers, animate, animateDelay, sort, displayType);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SellableItemLightweightNonAuthenticatedEntity {\n");
    sb.append("    identifier: ").append(toIndentedString(identifier)).append("\n");
    sb.append("    ownerIdentifier: ").append(toIndentedString(ownerIdentifier)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    customizationIdentifier: ").append(toIndentedString(customizationIdentifier)).append("\n");
    sb.append("    descriptions: ").append(toIndentedString(descriptions)).append("\n");
    sb.append("    keywords: ").append(toIndentedString(keywords)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    inventoryStatus: ").append(toIndentedString(inventoryStatus)).append("\n");
    sb.append("    inventoryType: ").append(toIndentedString(inventoryType)).append("\n");
    sb.append("    channelInventoryType: ").append(toIndentedString(channelInventoryType)).append("\n");
    sb.append("    supplierIdentifier: ").append(toIndentedString(supplierIdentifier)).append("\n");
    sb.append("    channelInventoryIdentifier: ").append(toIndentedString(channelInventoryIdentifier)).append("\n");
    sb.append("    multimediaIdentifiers: ").append(toIndentedString(multimediaIdentifiers)).append("\n");
    sb.append("    animate: ").append(toIndentedString(animate)).append("\n");
    sb.append("    animateDelay: ").append(toIndentedString(animateDelay)).append("\n");
    sb.append("    sort: ").append(toIndentedString(sort)).append("\n");
    sb.append("    displayType: ").append(toIndentedString(displayType)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

