/*
 * Wink API
 *  # Introduction  Welcome to the Wink API - A programmer-friendly way to manage, sell and book travel inventory on the Wink platform. The API gives you all the tools you need to ready your properties and inventory for sale across 1000s of our native sales channels.  Integrators, affiliates, travel agents and content creators have the ability search for your travel inventory and promote / sell it in a wide variety of ways.   # Integrations  We have already integrated with the most well-known channel managers so you don't have to. To see our current integrations, please go to https://extranet.wink.travel and scroll to Connectivity section. Once your properties are set up, you can finish the setup by mapping your property to Wink using your channel manager partner portal. If your properties don't have a channel manager, you can easily manage rates and availability with this API.   # Intended Audience  Programmers are [most likely] a requirement to start integrating with Wink. Companies and organizations that would most benefit from integrating with us are new and existing travel companies that have relationships with suppliers and that need an advanced system from which to manage their travel inventory and get that same inventory out to as many eyeballs as possible at the lowest price possible.  - Hotel chains  - Hotel brands  - Travel tech companies  - Destination sites  - Integrators  - Aggregators  - Destination management companies  - Travel agencies  - OTAs   ## APIs  Not every integrator needs every API. For that reason, we have separated APIs into context.  ### Test API   - [Ping](/ping): The Ping API is a quick test endpoint to verify that your credentials work Wink.  ### Common APIs  - [Notifications](/notifications): The Notifications API is a way for us to stay in touch with your user, property or affiliate account. - [User Settings](/user-settings): The User Settings API exposes endpoints to allow 3rd party integrators to communicate with Wink.  ### Consume APIs Consume endpoints are for developers who want to find existing travel inventory and either book it or use it to advertise through one of their Wink affiliate accounts.   - [Configuration](/customization-client): A single endpoint to retrieve whitelabel + customization information for the booking customization.  - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags.  - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API..  - [Booking](/booking): All APIs related to creating bookings on the platform.  - [Travel Agent](/travel-agent): The Travel Agent API exposes endpoints to manage agent-facilitated bookings.   ### Produce APIs  Produce endpoints are for developers who want to create and manage travel inventory.   #### Property  - [Property registration](/extranet/property/register): As a producer, this is, oftentimes, where you start your journey. These endpoints let you create properties on Wink.  - [Property](/extranet/property): This collection of property endpoints are mostly management endpoints that let you display, change status and similar for your existing properties.  - [Facilities](/extranet/facilities): This collection of endpoints let you manage facilities; such as room types.  - [Experiences](/extranet/experiences): This collection of endpoints let you manage experiences, such as activities.  - [Monetize](/extranet/monetize): The Monetize API exposes endpoints for managing cancellation polies, rate plans, promotions and more on Wink.  - [Distribution](/extranet/distribution): The Distribution API exposes endpoints for sales channels, connecting with affiliates, managing rates and inventory calendars and more on Wink.  - [Property Booking](/extranet/booking): The Property Booking API exposes endpoints for managing bookings and reviews at the property-level.   #### Affiliate  - [Affiliate](/affiliate): This collection of affiliate endpoints are mostly management endpoints that let you display, change status and similar for your existing accounts.  - [Browse](/affiliate/browse): The Browse API exposes endpoints for affiliates to find suppliers and inventory to sell.  - [Inventory](/affiliate/inventory): The Inventory API exposes endpoints for affiliates to manage the inventory they want to sell and how they want to sell it.  - [Sales Channel](/affiliate/sales-channel): The Sales Channel API exposes endpoints for affiliates to manage existing sales channels as well as find new ones.  - [WinkLinks](/affiliate/winklinks): The WinkLinks API exposes endpoints for affiliates to manage their WinkLinks page.   #### Rate provider  - [Channel manager](/channel-manager): The Channel Manager API enables external channel manager partners to map, exchange rate / availability information with us as well as be informed of bookings that occur on the Wink platform for one of their properties.   ### Taxonomy APIs  Taxonomy endpoints are for developers who want to consume and produce travel inventory and need taxonomies of standard and non-standard codes for inventory types, classes, statuses etc.   - [Reference](/reactive): All APIs related to retrieving platform-supported taxonomies.   ### Insight APIs  Insight endpoints do exactly what the name implies - They offer platform-level insight into the activities of producers and consumers.   - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics.   ### Payment APIs  Payment endpoints are for developers who want to purchase travel inventory. This can be done via the API as a registered Travel Agent or using our API in conjunction with our PCI compliant reactive widget for all other entities.   - [TripPay](/reactive): All APIs related to TripPay account management, booking, mapping and integration features.   ## SDKs  We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).   - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)   ## Usage  These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.   ## Versioning  We chose to version our endpoints in a way that we hope affects your integration minimally. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.   ## Release history  - Follow updates on Github: https://github.com/wink-travel/wink-sdk-java/blob/master/CHANGELOG.md    # Inventory API The Inventory API exposes endpoints to retrieve inventory you already know about. This API lets you:  1. Consume shareable links. 2. Load up a known property with availability. 3. Load up all inventories that were created by our affiliates such as grids, maps, and individual items.  Browse the endpoints in the left navigation bar to get started.  
 *
 * The version of the OpenAPI document: 30.17.8
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.inventory.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.LocalDate;
import java.util.UUID;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Recognition for the ancillary blocking.
 */
@JsonPropertyOrder({
  TravelInventoryRecognitionNonAuthenticatedEntity.JSON_PROPERTY_IDENTIFIER,
  TravelInventoryRecognitionNonAuthenticatedEntity.JSON_PROPERTY_CATEGORY,
  TravelInventoryRecognitionNonAuthenticatedEntity.JSON_PROPERTY_TYPE,
  TravelInventoryRecognitionNonAuthenticatedEntity.JSON_PROPERTY_PROVIDER,
  TravelInventoryRecognitionNonAuthenticatedEntity.JSON_PROPERTY_RATING,
  TravelInventoryRecognitionNonAuthenticatedEntity.JSON_PROPERTY_MAX_RATING,
  TravelInventoryRecognitionNonAuthenticatedEntity.JSON_PROPERTY_DATE,
  TravelInventoryRecognitionNonAuthenticatedEntity.JSON_PROPERTY_OFFICIAL_APPOINTMENT_IND,
  TravelInventoryRecognitionNonAuthenticatedEntity.JSON_PROPERTY_RATING_SYMBOL
})
@JsonTypeName("TravelInventoryRecognition_Non_Authenticated_Entity")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-06-26T20:20:31.141212618+07:00[Asia/Bangkok]", comments = "Generator version: 7.13.0")
public class TravelInventoryRecognitionNonAuthenticatedEntity {
  public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
  @jakarta.annotation.Nonnull
  private UUID identifier;

  /**
   * Recognition category.
   */
  public enum CategoryEnum {
    THIRD_PARTY_REVIEW(String.valueOf("THIRD_PARTY_REVIEW")),
    
    PUBLICATION(String.valueOf("PUBLICATION")),
    
    AWARD(String.valueOf("AWARD"));

    private String value;

    CategoryEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static CategoryEnum fromValue(String value) {
      for (CategoryEnum b : CategoryEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_CATEGORY = "category";
  @jakarta.annotation.Nonnull
  private CategoryEnum category;

  /**
   * Type of rating system the recognition operated on. This allows us to display the score properly.
   */
  public enum TypeEnum {
    STAR_RATING(String.valueOf("STAR_RATING")),
    
    NUMERIC_RATING(String.valueOf("NUMERIC_RATING")),
    
    PERCENT_RATING(String.valueOf("PERCENT_RATING"));

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  @jakarta.annotation.Nonnull
  private TypeEnum type;

  public static final String JSON_PROPERTY_PROVIDER = "provider";
  @jakarta.annotation.Nonnull
  private String provider;

  public static final String JSON_PROPERTY_RATING = "rating";
  @jakarta.annotation.Nonnull
  private Float rating;

  public static final String JSON_PROPERTY_MAX_RATING = "maxRating";
  @jakarta.annotation.Nonnull
  private Float maxRating;

  public static final String JSON_PROPERTY_DATE = "date";
  @jakarta.annotation.Nullable
  private LocalDate date;

  public static final String JSON_PROPERTY_OFFICIAL_APPOINTMENT_IND = "officialAppointmentInd";
  @jakarta.annotation.Nullable
  private Boolean officialAppointmentInd;

  public static final String JSON_PROPERTY_RATING_SYMBOL = "ratingSymbol";
  @jakarta.annotation.Nullable
  private String ratingSymbol;

  public TravelInventoryRecognitionNonAuthenticatedEntity() {
  }

  public TravelInventoryRecognitionNonAuthenticatedEntity identifier(@jakarta.annotation.Nonnull UUID identifier) {
    
    this.identifier = identifier;
    return this;
  }

  /**
   * Recognition identifier.
   * @return identifier
   */
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid
 @Size(min=1)
  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getIdentifier() {
    return identifier;
  }


  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setIdentifier(@jakarta.annotation.Nonnull UUID identifier) {
    this.identifier = identifier;
  }

  public TravelInventoryRecognitionNonAuthenticatedEntity category(@jakarta.annotation.Nonnull CategoryEnum category) {
    
    this.category = category;
    return this;
  }

  /**
   * Recognition category.
   * @return category
   */
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_CATEGORY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public CategoryEnum getCategory() {
    return category;
  }


  @JsonProperty(JSON_PROPERTY_CATEGORY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCategory(@jakarta.annotation.Nonnull CategoryEnum category) {
    this.category = category;
  }

  public TravelInventoryRecognitionNonAuthenticatedEntity type(@jakarta.annotation.Nonnull TypeEnum type) {
    
    this.type = type;
    return this;
  }

  /**
   * Type of rating system the recognition operated on. This allows us to display the score properly.
   * @return type
   */
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public TypeEnum getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setType(@jakarta.annotation.Nonnull TypeEnum type) {
    this.type = type;
  }

  public TravelInventoryRecognitionNonAuthenticatedEntity provider(@jakarta.annotation.Nonnull String provider) {
    
    this.provider = provider;
    return this;
  }

  /**
   * The name of the entity that administers this recognition.
   * @return provider
   */
  @jakarta.annotation.Nonnull
  @NotNull
 @Size(min=1)
  @JsonProperty(JSON_PROPERTY_PROVIDER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getProvider() {
    return provider;
  }


  @JsonProperty(JSON_PROPERTY_PROVIDER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setProvider(@jakarta.annotation.Nonnull String provider) {
    this.provider = provider;
  }

  public TravelInventoryRecognitionNonAuthenticatedEntity rating(@jakarta.annotation.Nonnull Float rating) {
    
    this.rating = rating;
    return this;
  }

  /**
   * The actual award or rating received by the hotel facility.
   * minimum: 0.0
   * @return rating
   */
  @jakarta.annotation.Nonnull
  @NotNull
 @DecimalMin("0.0")
  @JsonProperty(JSON_PROPERTY_RATING)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Float getRating() {
    return rating;
  }


  @JsonProperty(JSON_PROPERTY_RATING)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRating(@jakarta.annotation.Nonnull Float rating) {
    this.rating = rating;
  }

  public TravelInventoryRecognitionNonAuthenticatedEntity maxRating(@jakarta.annotation.Nonnull Float maxRating) {
    
    this.maxRating = maxRating;
    return this;
  }

  /**
   * Use this to let hotels indicate what the total score for this award is.
   * @return maxRating
   */
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_MAX_RATING)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Float getMaxRating() {
    return maxRating;
  }


  @JsonProperty(JSON_PROPERTY_MAX_RATING)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setMaxRating(@jakarta.annotation.Nonnull Float maxRating) {
    this.maxRating = maxRating;
  }

  public TravelInventoryRecognitionNonAuthenticatedEntity date(@jakarta.annotation.Nullable LocalDate date) {
    
    this.date = date;
    return this;
  }

  /**
   * The date the award was received
   * @return date
   */
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LocalDate getDate() {
    return date;
  }


  @JsonProperty(JSON_PROPERTY_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDate(@jakarta.annotation.Nullable LocalDate date) {
    this.date = date;
  }

  public TravelInventoryRecognitionNonAuthenticatedEntity officialAppointmentInd(@jakarta.annotation.Nullable Boolean officialAppointmentInd) {
    
    this.officialAppointmentInd = officialAppointmentInd;
    return this;
  }

  /**
   * When true, this indicates the property has received official permission from the award provider to use the rating in publications and marketing materials; when false this permission has not been granted.
   * @return officialAppointmentInd
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_OFFICIAL_APPOINTMENT_IND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getOfficialAppointmentInd() {
    return officialAppointmentInd;
  }


  @JsonProperty(JSON_PROPERTY_OFFICIAL_APPOINTMENT_IND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOfficialAppointmentInd(@jakarta.annotation.Nullable Boolean officialAppointmentInd) {
    this.officialAppointmentInd = officialAppointmentInd;
  }

  public TravelInventoryRecognitionNonAuthenticatedEntity ratingSymbol(@jakarta.annotation.Nullable String ratingSymbol) {
    
    this.ratingSymbol = ratingSymbol;
    return this;
  }

  /**
   * Provides the symbol used in the rating. Used in conjunction with the Rating.
   * @return ratingSymbol
   */
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_RATING_SYMBOL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRatingSymbol() {
    return ratingSymbol;
  }


  @JsonProperty(JSON_PROPERTY_RATING_SYMBOL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRatingSymbol(@jakarta.annotation.Nullable String ratingSymbol) {
    this.ratingSymbol = ratingSymbol;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TravelInventoryRecognitionNonAuthenticatedEntity travelInventoryRecognitionNonAuthenticatedEntity = (TravelInventoryRecognitionNonAuthenticatedEntity) o;
    return Objects.equals(this.identifier, travelInventoryRecognitionNonAuthenticatedEntity.identifier) &&
        Objects.equals(this.category, travelInventoryRecognitionNonAuthenticatedEntity.category) &&
        Objects.equals(this.type, travelInventoryRecognitionNonAuthenticatedEntity.type) &&
        Objects.equals(this.provider, travelInventoryRecognitionNonAuthenticatedEntity.provider) &&
        Objects.equals(this.rating, travelInventoryRecognitionNonAuthenticatedEntity.rating) &&
        Objects.equals(this.maxRating, travelInventoryRecognitionNonAuthenticatedEntity.maxRating) &&
        Objects.equals(this.date, travelInventoryRecognitionNonAuthenticatedEntity.date) &&
        Objects.equals(this.officialAppointmentInd, travelInventoryRecognitionNonAuthenticatedEntity.officialAppointmentInd) &&
        Objects.equals(this.ratingSymbol, travelInventoryRecognitionNonAuthenticatedEntity.ratingSymbol);
  }

  @Override
  public int hashCode() {
    return Objects.hash(identifier, category, type, provider, rating, maxRating, date, officialAppointmentInd, ratingSymbol);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TravelInventoryRecognitionNonAuthenticatedEntity {\n");
    sb.append("    identifier: ").append(toIndentedString(identifier)).append("\n");
    sb.append("    category: ").append(toIndentedString(category)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    provider: ").append(toIndentedString(provider)).append("\n");
    sb.append("    rating: ").append(toIndentedString(rating)).append("\n");
    sb.append("    maxRating: ").append(toIndentedString(maxRating)).append("\n");
    sb.append("    date: ").append(toIndentedString(date)).append("\n");
    sb.append("    officialAppointmentInd: ").append(toIndentedString(officialAppointmentInd)).append("\n");
    sb.append("    ratingSymbol: ").append(toIndentedString(ratingSymbol)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

