/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.inventory.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.DecimalMin;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import travel.wink.sdk.inventory.model.BedroomConfigurationNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.ContactNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.GeoJsonPointNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.SimpleAddressNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.SimpleDescriptionNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.SimpleMultimediaNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.SocialNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.TravelInventoryRecognitionNonAuthenticatedEntity;

@JsonPropertyOrder(value={"identifier", "hotelIdentifier", "featuredInd", "lifestyleType", "location", "descriptions", "multimedias", "contact", "address", "commissionable", "name", "proximityCode", "sort", "minAgeAppropriateCode", "bookable", "active", "disabilityFeatures", "securityFeatures", "socials", "pricePoint", "recognitionList", "maxOccupancy", "minOccupancy", "quantity", "nonSmoking", "bedroomConfigurationList", "size", "maxAdultOccupancy", "maxChildOccupancy", "bathroomCount", "livingRoomCount", "maxRollaways", "roomCategory", "floor", "roomLocationCode", "roomViewCode", "composite", "compositeCount", "roomClassificationCode", "roomArchitectureCode", "roomGender", "sharedRoomInd", "maxCribs", "amenities", "includedAdultOccupancy", "includedChildOccupancy"})
@JsonTypeName(value="GuestRoomLightweight_Non_Authenticated_Entity")
public class GuestRoomLightweightNonAuthenticatedEntity {
    public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
    @Nonnull
    private UUID identifier;
    public static final String JSON_PROPERTY_HOTEL_IDENTIFIER = "hotelIdentifier";
    @Nonnull
    private UUID hotelIdentifier;
    public static final String JSON_PROPERTY_FEATURED_IND = "featuredInd";
    @Nonnull
    private Boolean featuredInd;
    public static final String JSON_PROPERTY_LIFESTYLE_TYPE = "lifestyleType";
    @Nullable
    private LifestyleTypeEnum lifestyleType;
    public static final String JSON_PROPERTY_LOCATION = "location";
    @Nonnull
    private GeoJsonPointNonAuthenticatedEntity location;
    public static final String JSON_PROPERTY_DESCRIPTIONS = "descriptions";
    @Nonnull
    private List<@Valid SimpleDescriptionNonAuthenticatedEntity> descriptions = new ArrayList<SimpleDescriptionNonAuthenticatedEntity>();
    public static final String JSON_PROPERTY_MULTIMEDIAS = "multimedias";
    @Nonnull
    private List<@Valid SimpleMultimediaNonAuthenticatedEntity> multimedias = new ArrayList<SimpleMultimediaNonAuthenticatedEntity>();
    public static final String JSON_PROPERTY_CONTACT = "contact";
    @Nonnull
    private ContactNonAuthenticatedEntity contact;
    public static final String JSON_PROPERTY_ADDRESS = "address";
    @Nonnull
    private SimpleAddressNonAuthenticatedEntity address;
    public static final String JSON_PROPERTY_COMMISSIONABLE = "commissionable";
    @Nonnull
    private Boolean commissionable = true;
    public static final String JSON_PROPERTY_NAME = "name";
    @Nonnull
    private String name;
    public static final String JSON_PROPERTY_PROXIMITY_CODE = "proximityCode";
    @Nonnull
    private String proximityCode;
    public static final String JSON_PROPERTY_SORT = "sort";
    @Nullable
    private Integer sort;
    public static final String JSON_PROPERTY_MIN_AGE_APPROPRIATE_CODE = "minAgeAppropriateCode";
    @Nullable
    private String minAgeAppropriateCode;
    public static final String JSON_PROPERTY_BOOKABLE = "bookable";
    @Nonnull
    private Boolean bookable = true;
    public static final String JSON_PROPERTY_ACTIVE = "active";
    @Nonnull
    private Boolean active = true;
    public static final String JSON_PROPERTY_DISABILITY_FEATURES = "disabilityFeatures";
    @Nullable
    private List<String> disabilityFeatures = new ArrayList<String>();
    public static final String JSON_PROPERTY_SECURITY_FEATURES = "securityFeatures";
    @Nullable
    private List<String> securityFeatures = new ArrayList<String>();
    public static final String JSON_PROPERTY_SOCIALS = "socials";
    @Nullable
    private List<@Valid SocialNonAuthenticatedEntity> socials = new ArrayList<SocialNonAuthenticatedEntity>();
    public static final String JSON_PROPERTY_PRICE_POINT = "pricePoint";
    @Nonnull
    private PricePointEnum pricePoint = PricePointEnum.THREE;
    public static final String JSON_PROPERTY_RECOGNITION_LIST = "recognitionList";
    @Nullable
    private List<@Valid TravelInventoryRecognitionNonAuthenticatedEntity> recognitionList = new ArrayList<TravelInventoryRecognitionNonAuthenticatedEntity>();
    public static final String JSON_PROPERTY_MAX_OCCUPANCY = "maxOccupancy";
    @Nonnull
    private Integer maxOccupancy = 2;
    public static final String JSON_PROPERTY_MIN_OCCUPANCY = "minOccupancy";
    @Nonnull
    private Integer minOccupancy = 1;
    public static final String JSON_PROPERTY_QUANTITY = "quantity";
    @Nonnull
    private Integer quantity;
    public static final String JSON_PROPERTY_NON_SMOKING = "nonSmoking";
    @Nonnull
    private Boolean nonSmoking;
    public static final String JSON_PROPERTY_BEDROOM_CONFIGURATION_LIST = "bedroomConfigurationList";
    @Nonnull
    private List<@Valid BedroomConfigurationNonAuthenticatedEntity> bedroomConfigurationList = new ArrayList<BedroomConfigurationNonAuthenticatedEntity>();
    public static final String JSON_PROPERTY_SIZE = "size";
    @Nonnull
    private Float size;
    public static final String JSON_PROPERTY_MAX_ADULT_OCCUPANCY = "maxAdultOccupancy";
    @Nonnull
    private Integer maxAdultOccupancy = 2;
    public static final String JSON_PROPERTY_MAX_CHILD_OCCUPANCY = "maxChildOccupancy";
    @Nonnull
    private Integer maxChildOccupancy = 0;
    public static final String JSON_PROPERTY_BATHROOM_COUNT = "bathroomCount";
    @Nonnull
    private Integer bathroomCount = 1;
    public static final String JSON_PROPERTY_LIVING_ROOM_COUNT = "livingRoomCount";
    @Nonnull
    private Integer livingRoomCount = 1;
    public static final String JSON_PROPERTY_MAX_ROLLAWAYS = "maxRollaways";
    @Nonnull
    private Integer maxRollaways = 0;
    public static final String JSON_PROPERTY_ROOM_CATEGORY = "roomCategory";
    @Nonnull
    private String roomCategory;
    public static final String JSON_PROPERTY_FLOOR = "floor";
    @Nullable
    private String floor;
    public static final String JSON_PROPERTY_ROOM_LOCATION_CODE = "roomLocationCode";
    @Nonnull
    private String roomLocationCode;
    public static final String JSON_PROPERTY_ROOM_VIEW_CODE = "roomViewCode";
    @Nonnull
    private String roomViewCode;
    public static final String JSON_PROPERTY_COMPOSITE = "composite";
    @Nonnull
    private Boolean composite = false;
    public static final String JSON_PROPERTY_COMPOSITE_COUNT = "compositeCount";
    @Nonnull
    private Integer compositeCount = 0;
    public static final String JSON_PROPERTY_ROOM_CLASSIFICATION_CODE = "roomClassificationCode";
    @Nonnull
    private String roomClassificationCode;
    public static final String JSON_PROPERTY_ROOM_ARCHITECTURE_CODE = "roomArchitectureCode";
    @Nonnull
    private String roomArchitectureCode;
    public static final String JSON_PROPERTY_ROOM_GENDER = "roomGender";
    @Nullable
    private RoomGenderEnum roomGender = RoomGenderEnum.UNKNOWN;
    public static final String JSON_PROPERTY_SHARED_ROOM_IND = "sharedRoomInd";
    @Nonnull
    private Boolean sharedRoomInd = false;
    public static final String JSON_PROPERTY_MAX_CRIBS = "maxCribs";
    @Nonnull
    private Integer maxCribs = 0;
    public static final String JSON_PROPERTY_AMENITIES = "amenities";
    @Nullable
    private List<String> amenities = new ArrayList<String>();
    public static final String JSON_PROPERTY_INCLUDED_ADULT_OCCUPANCY = "includedAdultOccupancy";
    @Nonnull
    private Integer includedAdultOccupancy = 2;
    public static final String JSON_PROPERTY_INCLUDED_CHILD_OCCUPANCY = "includedChildOccupancy";
    @Nonnull
    private Integer includedChildOccupancy = 0;

    public GuestRoomLightweightNonAuthenticatedEntity identifier(@Nonnull UUID identifier) {
        this.identifier = identifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @Size(min=1)
    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @Size(min=1) UUID getIdentifier() {
        return this.identifier;
    }

    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setIdentifier(@Nonnull UUID identifier) {
        this.identifier = identifier;
    }

    public GuestRoomLightweightNonAuthenticatedEntity hotelIdentifier(@Nonnull UUID hotelIdentifier) {
        this.hotelIdentifier = hotelIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @Size(min=1)
    @JsonProperty(value="hotelIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @Size(min=1) UUID getHotelIdentifier() {
        return this.hotelIdentifier;
    }

    @JsonProperty(value="hotelIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setHotelIdentifier(@Nonnull UUID hotelIdentifier) {
        this.hotelIdentifier = hotelIdentifier;
    }

    public GuestRoomLightweightNonAuthenticatedEntity featuredInd(@Nonnull Boolean featuredInd) {
        this.featuredInd = featuredInd;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="featuredInd")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getFeaturedInd() {
        return this.featuredInd;
    }

    @JsonProperty(value="featuredInd")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setFeaturedInd(@Nonnull Boolean featuredInd) {
        this.featuredInd = featuredInd;
    }

    public GuestRoomLightweightNonAuthenticatedEntity lifestyleType(@Nullable LifestyleTypeEnum lifestyleType) {
        this.lifestyleType = lifestyleType;
        return this;
    }

    @Nullable
    @JsonProperty(value="lifestyleType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LifestyleTypeEnum getLifestyleType() {
        return this.lifestyleType;
    }

    @JsonProperty(value="lifestyleType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLifestyleType(@Nullable LifestyleTypeEnum lifestyleType) {
        this.lifestyleType = lifestyleType;
    }

    public GuestRoomLightweightNonAuthenticatedEntity location(@Nonnull GeoJsonPointNonAuthenticatedEntity location) {
        this.location = location;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="location")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public GeoJsonPointNonAuthenticatedEntity getLocation() {
        return this.location;
    }

    @JsonProperty(value="location")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setLocation(@Nonnull GeoJsonPointNonAuthenticatedEntity location) {
        this.location = location;
    }

    public GuestRoomLightweightNonAuthenticatedEntity descriptions(@Nonnull List<@Valid SimpleDescriptionNonAuthenticatedEntity> descriptions) {
        this.descriptions = descriptions;
        return this;
    }

    public GuestRoomLightweightNonAuthenticatedEntity addDescriptionsItem(SimpleDescriptionNonAuthenticatedEntity descriptionsItem) {
        if (this.descriptions == null) {
            this.descriptions = new ArrayList<SimpleDescriptionNonAuthenticatedEntity>();
        }
        this.descriptions.add(descriptionsItem);
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @Size(min=1)
    @JsonProperty(value="descriptions")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @Size(min=1) List<@Valid SimpleDescriptionNonAuthenticatedEntity> getDescriptions() {
        return this.descriptions;
    }

    @JsonProperty(value="descriptions")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDescriptions(@Nonnull List<@Valid SimpleDescriptionNonAuthenticatedEntity> descriptions) {
        this.descriptions = descriptions;
    }

    public GuestRoomLightweightNonAuthenticatedEntity multimedias(@Nonnull List<@Valid SimpleMultimediaNonAuthenticatedEntity> multimedias) {
        this.multimedias = multimedias;
        return this;
    }

    public GuestRoomLightweightNonAuthenticatedEntity addMultimediasItem(SimpleMultimediaNonAuthenticatedEntity multimediasItem) {
        if (this.multimedias == null) {
            this.multimedias = new ArrayList<SimpleMultimediaNonAuthenticatedEntity>();
        }
        this.multimedias.add(multimediasItem);
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @Size(min=1)
    @JsonProperty(value="multimedias")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @Size(min=1) List<@Valid SimpleMultimediaNonAuthenticatedEntity> getMultimedias() {
        return this.multimedias;
    }

    @JsonProperty(value="multimedias")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setMultimedias(@Nonnull List<@Valid SimpleMultimediaNonAuthenticatedEntity> multimedias) {
        this.multimedias = multimedias;
    }

    public GuestRoomLightweightNonAuthenticatedEntity contact(@Nonnull ContactNonAuthenticatedEntity contact) {
        this.contact = contact;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="contact")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ContactNonAuthenticatedEntity getContact() {
        return this.contact;
    }

    @JsonProperty(value="contact")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setContact(@Nonnull ContactNonAuthenticatedEntity contact) {
        this.contact = contact;
    }

    public GuestRoomLightweightNonAuthenticatedEntity address(@Nonnull SimpleAddressNonAuthenticatedEntity address) {
        this.address = address;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public SimpleAddressNonAuthenticatedEntity getAddress() {
        return this.address;
    }

    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAddress(@Nonnull SimpleAddressNonAuthenticatedEntity address) {
        this.address = address;
    }

    public GuestRoomLightweightNonAuthenticatedEntity commissionable(@Nonnull Boolean commissionable) {
        this.commissionable = commissionable;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="commissionable")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getCommissionable() {
        return this.commissionable;
    }

    @JsonProperty(value="commissionable")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCommissionable(@Nonnull Boolean commissionable) {
        this.commissionable = commissionable;
    }

    public GuestRoomLightweightNonAuthenticatedEntity name(@Nonnull String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @NotNull
    @Size(min=1)
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=1) String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(@Nonnull String name) {
        this.name = name;
    }

    public GuestRoomLightweightNonAuthenticatedEntity proximityCode(@Nonnull String proximityCode) {
        this.proximityCode = proximityCode;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="proximityCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getProximityCode() {
        return this.proximityCode;
    }

    @JsonProperty(value="proximityCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setProximityCode(@Nonnull String proximityCode) {
        this.proximityCode = proximityCode;
    }

    public GuestRoomLightweightNonAuthenticatedEntity sort(@Nullable Integer sort) {
        this.sort = sort;
        return this;
    }

    @Nullable
    @JsonProperty(value="sort")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getSort() {
        return this.sort;
    }

    @JsonProperty(value="sort")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSort(@Nullable Integer sort) {
        this.sort = sort;
    }

    public GuestRoomLightweightNonAuthenticatedEntity minAgeAppropriateCode(@Nullable String minAgeAppropriateCode) {
        this.minAgeAppropriateCode = minAgeAppropriateCode;
        return this;
    }

    @Nullable
    @JsonProperty(value="minAgeAppropriateCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMinAgeAppropriateCode() {
        return this.minAgeAppropriateCode;
    }

    @JsonProperty(value="minAgeAppropriateCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMinAgeAppropriateCode(@Nullable String minAgeAppropriateCode) {
        this.minAgeAppropriateCode = minAgeAppropriateCode;
    }

    public GuestRoomLightweightNonAuthenticatedEntity bookable(@Nonnull Boolean bookable) {
        this.bookable = bookable;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="bookable")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getBookable() {
        return this.bookable;
    }

    @JsonProperty(value="bookable")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setBookable(@Nonnull Boolean bookable) {
        this.bookable = bookable;
    }

    public GuestRoomLightweightNonAuthenticatedEntity active(@Nonnull Boolean active) {
        this.active = active;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="active")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getActive() {
        return this.active;
    }

    @JsonProperty(value="active")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setActive(@Nonnull Boolean active) {
        this.active = active;
    }

    public GuestRoomLightweightNonAuthenticatedEntity disabilityFeatures(@Nullable List<String> disabilityFeatures) {
        this.disabilityFeatures = disabilityFeatures;
        return this;
    }

    public GuestRoomLightweightNonAuthenticatedEntity addDisabilityFeaturesItem(String disabilityFeaturesItem) {
        if (this.disabilityFeatures == null) {
            this.disabilityFeatures = new ArrayList<String>();
        }
        this.disabilityFeatures.add(disabilityFeaturesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="disabilityFeatures")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getDisabilityFeatures() {
        return this.disabilityFeatures;
    }

    @JsonProperty(value="disabilityFeatures")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDisabilityFeatures(@Nullable List<String> disabilityFeatures) {
        this.disabilityFeatures = disabilityFeatures;
    }

    public GuestRoomLightweightNonAuthenticatedEntity securityFeatures(@Nullable List<String> securityFeatures) {
        this.securityFeatures = securityFeatures;
        return this;
    }

    public GuestRoomLightweightNonAuthenticatedEntity addSecurityFeaturesItem(String securityFeaturesItem) {
        if (this.securityFeatures == null) {
            this.securityFeatures = new ArrayList<String>();
        }
        this.securityFeatures.add(securityFeaturesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="securityFeatures")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getSecurityFeatures() {
        return this.securityFeatures;
    }

    @JsonProperty(value="securityFeatures")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSecurityFeatures(@Nullable List<String> securityFeatures) {
        this.securityFeatures = securityFeatures;
    }

    public GuestRoomLightweightNonAuthenticatedEntity socials(@Nullable List<@Valid SocialNonAuthenticatedEntity> socials) {
        this.socials = socials;
        return this;
    }

    public GuestRoomLightweightNonAuthenticatedEntity addSocialsItem(SocialNonAuthenticatedEntity socialsItem) {
        if (this.socials == null) {
            this.socials = new ArrayList<SocialNonAuthenticatedEntity>();
        }
        this.socials.add(socialsItem);
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="socials")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public @Valid List<@Valid SocialNonAuthenticatedEntity> getSocials() {
        return this.socials;
    }

    @JsonProperty(value="socials")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSocials(@Nullable List<@Valid SocialNonAuthenticatedEntity> socials) {
        this.socials = socials;
    }

    public GuestRoomLightweightNonAuthenticatedEntity pricePoint(@Nonnull PricePointEnum pricePoint) {
        this.pricePoint = pricePoint;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="pricePoint")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public PricePointEnum getPricePoint() {
        return this.pricePoint;
    }

    @JsonProperty(value="pricePoint")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPricePoint(@Nonnull PricePointEnum pricePoint) {
        this.pricePoint = pricePoint;
    }

    public GuestRoomLightweightNonAuthenticatedEntity recognitionList(@Nullable List<@Valid TravelInventoryRecognitionNonAuthenticatedEntity> recognitionList) {
        this.recognitionList = recognitionList;
        return this;
    }

    public GuestRoomLightweightNonAuthenticatedEntity addRecognitionListItem(TravelInventoryRecognitionNonAuthenticatedEntity recognitionListItem) {
        if (this.recognitionList == null) {
            this.recognitionList = new ArrayList<TravelInventoryRecognitionNonAuthenticatedEntity>();
        }
        this.recognitionList.add(recognitionListItem);
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="recognitionList")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public @Valid List<@Valid TravelInventoryRecognitionNonAuthenticatedEntity> getRecognitionList() {
        return this.recognitionList;
    }

    @JsonProperty(value="recognitionList")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRecognitionList(@Nullable List<@Valid TravelInventoryRecognitionNonAuthenticatedEntity> recognitionList) {
        this.recognitionList = recognitionList;
    }

    public GuestRoomLightweightNonAuthenticatedEntity maxOccupancy(@Nonnull Integer maxOccupancy) {
        this.maxOccupancy = maxOccupancy;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=1L)
    @JsonProperty(value="maxOccupancy")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=1L) Integer getMaxOccupancy() {
        return this.maxOccupancy;
    }

    @JsonProperty(value="maxOccupancy")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setMaxOccupancy(@Nonnull Integer maxOccupancy) {
        this.maxOccupancy = maxOccupancy;
    }

    public GuestRoomLightweightNonAuthenticatedEntity minOccupancy(@Nonnull Integer minOccupancy) {
        this.minOccupancy = minOccupancy;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=1L)
    @JsonProperty(value="minOccupancy")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=1L) Integer getMinOccupancy() {
        return this.minOccupancy;
    }

    @JsonProperty(value="minOccupancy")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setMinOccupancy(@Nonnull Integer minOccupancy) {
        this.minOccupancy = minOccupancy;
    }

    public GuestRoomLightweightNonAuthenticatedEntity quantity(@Nonnull Integer quantity) {
        this.quantity = quantity;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=1L)
    @JsonProperty(value="quantity")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=1L) Integer getQuantity() {
        return this.quantity;
    }

    @JsonProperty(value="quantity")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setQuantity(@Nonnull Integer quantity) {
        this.quantity = quantity;
    }

    public GuestRoomLightweightNonAuthenticatedEntity nonSmoking(@Nonnull Boolean nonSmoking) {
        this.nonSmoking = nonSmoking;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="nonSmoking")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getNonSmoking() {
        return this.nonSmoking;
    }

    @JsonProperty(value="nonSmoking")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setNonSmoking(@Nonnull Boolean nonSmoking) {
        this.nonSmoking = nonSmoking;
    }

    public GuestRoomLightweightNonAuthenticatedEntity bedroomConfigurationList(@Nonnull List<@Valid BedroomConfigurationNonAuthenticatedEntity> bedroomConfigurationList) {
        this.bedroomConfigurationList = bedroomConfigurationList;
        return this;
    }

    public GuestRoomLightweightNonAuthenticatedEntity addBedroomConfigurationListItem(BedroomConfigurationNonAuthenticatedEntity bedroomConfigurationListItem) {
        if (this.bedroomConfigurationList == null) {
            this.bedroomConfigurationList = new ArrayList<BedroomConfigurationNonAuthenticatedEntity>();
        }
        this.bedroomConfigurationList.add(bedroomConfigurationListItem);
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @Size(min=1)
    @JsonProperty(value="bedroomConfigurationList")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @Size(min=1) List<@Valid BedroomConfigurationNonAuthenticatedEntity> getBedroomConfigurationList() {
        return this.bedroomConfigurationList;
    }

    @JsonProperty(value="bedroomConfigurationList")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setBedroomConfigurationList(@Nonnull List<@Valid BedroomConfigurationNonAuthenticatedEntity> bedroomConfigurationList) {
        this.bedroomConfigurationList = bedroomConfigurationList;
    }

    public GuestRoomLightweightNonAuthenticatedEntity size(@Nonnull Float size) {
        this.size = size;
        return this;
    }

    @Nonnull
    @NotNull
    @DecimalMin(value="1")
    @JsonProperty(value="size")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @DecimalMin(value="1") Float getSize() {
        return this.size;
    }

    @JsonProperty(value="size")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSize(@Nonnull Float size) {
        this.size = size;
    }

    public GuestRoomLightweightNonAuthenticatedEntity maxAdultOccupancy(@Nonnull Integer maxAdultOccupancy) {
        this.maxAdultOccupancy = maxAdultOccupancy;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=1L)
    @JsonProperty(value="maxAdultOccupancy")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=1L) Integer getMaxAdultOccupancy() {
        return this.maxAdultOccupancy;
    }

    @JsonProperty(value="maxAdultOccupancy")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setMaxAdultOccupancy(@Nonnull Integer maxAdultOccupancy) {
        this.maxAdultOccupancy = maxAdultOccupancy;
    }

    public GuestRoomLightweightNonAuthenticatedEntity maxChildOccupancy(@Nonnull Integer maxChildOccupancy) {
        this.maxChildOccupancy = maxChildOccupancy;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=0L)
    @JsonProperty(value="maxChildOccupancy")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=0L) Integer getMaxChildOccupancy() {
        return this.maxChildOccupancy;
    }

    @JsonProperty(value="maxChildOccupancy")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setMaxChildOccupancy(@Nonnull Integer maxChildOccupancy) {
        this.maxChildOccupancy = maxChildOccupancy;
    }

    public GuestRoomLightweightNonAuthenticatedEntity bathroomCount(@Nonnull Integer bathroomCount) {
        this.bathroomCount = bathroomCount;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=0L)
    @JsonProperty(value="bathroomCount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=0L) Integer getBathroomCount() {
        return this.bathroomCount;
    }

    @JsonProperty(value="bathroomCount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setBathroomCount(@Nonnull Integer bathroomCount) {
        this.bathroomCount = bathroomCount;
    }

    public GuestRoomLightweightNonAuthenticatedEntity livingRoomCount(@Nonnull Integer livingRoomCount) {
        this.livingRoomCount = livingRoomCount;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=0L)
    @JsonProperty(value="livingRoomCount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=0L) Integer getLivingRoomCount() {
        return this.livingRoomCount;
    }

    @JsonProperty(value="livingRoomCount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setLivingRoomCount(@Nonnull Integer livingRoomCount) {
        this.livingRoomCount = livingRoomCount;
    }

    public GuestRoomLightweightNonAuthenticatedEntity maxRollaways(@Nonnull Integer maxRollaways) {
        this.maxRollaways = maxRollaways;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=0L)
    @JsonProperty(value="maxRollaways")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=0L) Integer getMaxRollaways() {
        return this.maxRollaways;
    }

    @JsonProperty(value="maxRollaways")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setMaxRollaways(@Nonnull Integer maxRollaways) {
        this.maxRollaways = maxRollaways;
    }

    public GuestRoomLightweightNonAuthenticatedEntity roomCategory(@Nonnull String roomCategory) {
        this.roomCategory = roomCategory;
        return this;
    }

    @Nonnull
    @NotNull
    @Size(min=1)
    @JsonProperty(value="roomCategory")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=1) String getRoomCategory() {
        return this.roomCategory;
    }

    @JsonProperty(value="roomCategory")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRoomCategory(@Nonnull String roomCategory) {
        this.roomCategory = roomCategory;
    }

    public GuestRoomLightweightNonAuthenticatedEntity floor(@Nullable String floor) {
        this.floor = floor;
        return this;
    }

    @Nullable
    @JsonProperty(value="floor")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFloor() {
        return this.floor;
    }

    @JsonProperty(value="floor")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFloor(@Nullable String floor) {
        this.floor = floor;
    }

    public GuestRoomLightweightNonAuthenticatedEntity roomLocationCode(@Nonnull String roomLocationCode) {
        this.roomLocationCode = roomLocationCode;
        return this;
    }

    @Nonnull
    @NotNull
    @Size(min=1)
    @JsonProperty(value="roomLocationCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=1) String getRoomLocationCode() {
        return this.roomLocationCode;
    }

    @JsonProperty(value="roomLocationCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRoomLocationCode(@Nonnull String roomLocationCode) {
        this.roomLocationCode = roomLocationCode;
    }

    public GuestRoomLightweightNonAuthenticatedEntity roomViewCode(@Nonnull String roomViewCode) {
        this.roomViewCode = roomViewCode;
        return this;
    }

    @Nonnull
    @NotNull
    @Size(min=1)
    @JsonProperty(value="roomViewCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=1) String getRoomViewCode() {
        return this.roomViewCode;
    }

    @JsonProperty(value="roomViewCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRoomViewCode(@Nonnull String roomViewCode) {
        this.roomViewCode = roomViewCode;
    }

    public GuestRoomLightweightNonAuthenticatedEntity composite(@Nonnull Boolean composite) {
        this.composite = composite;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="composite")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getComposite() {
        return this.composite;
    }

    @JsonProperty(value="composite")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setComposite(@Nonnull Boolean composite) {
        this.composite = composite;
    }

    public GuestRoomLightweightNonAuthenticatedEntity compositeCount(@Nonnull Integer compositeCount) {
        this.compositeCount = compositeCount;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=0L)
    @JsonProperty(value="compositeCount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=0L) Integer getCompositeCount() {
        return this.compositeCount;
    }

    @JsonProperty(value="compositeCount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCompositeCount(@Nonnull Integer compositeCount) {
        this.compositeCount = compositeCount;
    }

    public GuestRoomLightweightNonAuthenticatedEntity roomClassificationCode(@Nonnull String roomClassificationCode) {
        this.roomClassificationCode = roomClassificationCode;
        return this;
    }

    @Nonnull
    @NotNull
    @Size(min=1)
    @JsonProperty(value="roomClassificationCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=1) String getRoomClassificationCode() {
        return this.roomClassificationCode;
    }

    @JsonProperty(value="roomClassificationCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRoomClassificationCode(@Nonnull String roomClassificationCode) {
        this.roomClassificationCode = roomClassificationCode;
    }

    public GuestRoomLightweightNonAuthenticatedEntity roomArchitectureCode(@Nonnull String roomArchitectureCode) {
        this.roomArchitectureCode = roomArchitectureCode;
        return this;
    }

    @Nonnull
    @NotNull
    @Size(min=1)
    @JsonProperty(value="roomArchitectureCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=1) String getRoomArchitectureCode() {
        return this.roomArchitectureCode;
    }

    @JsonProperty(value="roomArchitectureCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRoomArchitectureCode(@Nonnull String roomArchitectureCode) {
        this.roomArchitectureCode = roomArchitectureCode;
    }

    public GuestRoomLightweightNonAuthenticatedEntity roomGender(@Nullable RoomGenderEnum roomGender) {
        this.roomGender = roomGender;
        return this;
    }

    @Nullable
    @JsonProperty(value="roomGender")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public RoomGenderEnum getRoomGender() {
        return this.roomGender;
    }

    @JsonProperty(value="roomGender")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRoomGender(@Nullable RoomGenderEnum roomGender) {
        this.roomGender = roomGender;
    }

    public GuestRoomLightweightNonAuthenticatedEntity sharedRoomInd(@Nonnull Boolean sharedRoomInd) {
        this.sharedRoomInd = sharedRoomInd;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="sharedRoomInd")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getSharedRoomInd() {
        return this.sharedRoomInd;
    }

    @JsonProperty(value="sharedRoomInd")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSharedRoomInd(@Nonnull Boolean sharedRoomInd) {
        this.sharedRoomInd = sharedRoomInd;
    }

    public GuestRoomLightweightNonAuthenticatedEntity maxCribs(@Nonnull Integer maxCribs) {
        this.maxCribs = maxCribs;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=0L)
    @JsonProperty(value="maxCribs")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=0L) Integer getMaxCribs() {
        return this.maxCribs;
    }

    @JsonProperty(value="maxCribs")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setMaxCribs(@Nonnull Integer maxCribs) {
        this.maxCribs = maxCribs;
    }

    public GuestRoomLightweightNonAuthenticatedEntity amenities(@Nullable List<String> amenities) {
        this.amenities = amenities;
        return this;
    }

    public GuestRoomLightweightNonAuthenticatedEntity addAmenitiesItem(String amenitiesItem) {
        if (this.amenities == null) {
            this.amenities = new ArrayList<String>();
        }
        this.amenities.add(amenitiesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="amenities")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getAmenities() {
        return this.amenities;
    }

    @JsonProperty(value="amenities")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAmenities(@Nullable List<String> amenities) {
        this.amenities = amenities;
    }

    public GuestRoomLightweightNonAuthenticatedEntity includedAdultOccupancy(@Nonnull Integer includedAdultOccupancy) {
        this.includedAdultOccupancy = includedAdultOccupancy;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=0L)
    @JsonProperty(value="includedAdultOccupancy")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=0L) Integer getIncludedAdultOccupancy() {
        return this.includedAdultOccupancy;
    }

    @JsonProperty(value="includedAdultOccupancy")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setIncludedAdultOccupancy(@Nonnull Integer includedAdultOccupancy) {
        this.includedAdultOccupancy = includedAdultOccupancy;
    }

    public GuestRoomLightweightNonAuthenticatedEntity includedChildOccupancy(@Nonnull Integer includedChildOccupancy) {
        this.includedChildOccupancy = includedChildOccupancy;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=0L)
    @JsonProperty(value="includedChildOccupancy")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=0L) Integer getIncludedChildOccupancy() {
        return this.includedChildOccupancy;
    }

    @JsonProperty(value="includedChildOccupancy")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setIncludedChildOccupancy(@Nonnull Integer includedChildOccupancy) {
        this.includedChildOccupancy = includedChildOccupancy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GuestRoomLightweightNonAuthenticatedEntity guestRoomLightweightNonAuthenticatedEntity = (GuestRoomLightweightNonAuthenticatedEntity)o;
        return Objects.equals(this.identifier, guestRoomLightweightNonAuthenticatedEntity.identifier) && Objects.equals(this.hotelIdentifier, guestRoomLightweightNonAuthenticatedEntity.hotelIdentifier) && Objects.equals(this.featuredInd, guestRoomLightweightNonAuthenticatedEntity.featuredInd) && Objects.equals((Object)this.lifestyleType, (Object)guestRoomLightweightNonAuthenticatedEntity.lifestyleType) && Objects.equals(this.location, guestRoomLightweightNonAuthenticatedEntity.location) && Objects.equals(this.descriptions, guestRoomLightweightNonAuthenticatedEntity.descriptions) && Objects.equals(this.multimedias, guestRoomLightweightNonAuthenticatedEntity.multimedias) && Objects.equals(this.contact, guestRoomLightweightNonAuthenticatedEntity.contact) && Objects.equals(this.address, guestRoomLightweightNonAuthenticatedEntity.address) && Objects.equals(this.commissionable, guestRoomLightweightNonAuthenticatedEntity.commissionable) && Objects.equals(this.name, guestRoomLightweightNonAuthenticatedEntity.name) && Objects.equals(this.proximityCode, guestRoomLightweightNonAuthenticatedEntity.proximityCode) && Objects.equals(this.sort, guestRoomLightweightNonAuthenticatedEntity.sort) && Objects.equals(this.minAgeAppropriateCode, guestRoomLightweightNonAuthenticatedEntity.minAgeAppropriateCode) && Objects.equals(this.bookable, guestRoomLightweightNonAuthenticatedEntity.bookable) && Objects.equals(this.active, guestRoomLightweightNonAuthenticatedEntity.active) && Objects.equals(this.disabilityFeatures, guestRoomLightweightNonAuthenticatedEntity.disabilityFeatures) && Objects.equals(this.securityFeatures, guestRoomLightweightNonAuthenticatedEntity.securityFeatures) && Objects.equals(this.socials, guestRoomLightweightNonAuthenticatedEntity.socials) && Objects.equals((Object)this.pricePoint, (Object)guestRoomLightweightNonAuthenticatedEntity.pricePoint) && Objects.equals(this.recognitionList, guestRoomLightweightNonAuthenticatedEntity.recognitionList) && Objects.equals(this.maxOccupancy, guestRoomLightweightNonAuthenticatedEntity.maxOccupancy) && Objects.equals(this.minOccupancy, guestRoomLightweightNonAuthenticatedEntity.minOccupancy) && Objects.equals(this.quantity, guestRoomLightweightNonAuthenticatedEntity.quantity) && Objects.equals(this.nonSmoking, guestRoomLightweightNonAuthenticatedEntity.nonSmoking) && Objects.equals(this.bedroomConfigurationList, guestRoomLightweightNonAuthenticatedEntity.bedroomConfigurationList) && Objects.equals(this.size, guestRoomLightweightNonAuthenticatedEntity.size) && Objects.equals(this.maxAdultOccupancy, guestRoomLightweightNonAuthenticatedEntity.maxAdultOccupancy) && Objects.equals(this.maxChildOccupancy, guestRoomLightweightNonAuthenticatedEntity.maxChildOccupancy) && Objects.equals(this.bathroomCount, guestRoomLightweightNonAuthenticatedEntity.bathroomCount) && Objects.equals(this.livingRoomCount, guestRoomLightweightNonAuthenticatedEntity.livingRoomCount) && Objects.equals(this.maxRollaways, guestRoomLightweightNonAuthenticatedEntity.maxRollaways) && Objects.equals(this.roomCategory, guestRoomLightweightNonAuthenticatedEntity.roomCategory) && Objects.equals(this.floor, guestRoomLightweightNonAuthenticatedEntity.floor) && Objects.equals(this.roomLocationCode, guestRoomLightweightNonAuthenticatedEntity.roomLocationCode) && Objects.equals(this.roomViewCode, guestRoomLightweightNonAuthenticatedEntity.roomViewCode) && Objects.equals(this.composite, guestRoomLightweightNonAuthenticatedEntity.composite) && Objects.equals(this.compositeCount, guestRoomLightweightNonAuthenticatedEntity.compositeCount) && Objects.equals(this.roomClassificationCode, guestRoomLightweightNonAuthenticatedEntity.roomClassificationCode) && Objects.equals(this.roomArchitectureCode, guestRoomLightweightNonAuthenticatedEntity.roomArchitectureCode) && Objects.equals((Object)this.roomGender, (Object)guestRoomLightweightNonAuthenticatedEntity.roomGender) && Objects.equals(this.sharedRoomInd, guestRoomLightweightNonAuthenticatedEntity.sharedRoomInd) && Objects.equals(this.maxCribs, guestRoomLightweightNonAuthenticatedEntity.maxCribs) && Objects.equals(this.amenities, guestRoomLightweightNonAuthenticatedEntity.amenities) && Objects.equals(this.includedAdultOccupancy, guestRoomLightweightNonAuthenticatedEntity.includedAdultOccupancy) && Objects.equals(this.includedChildOccupancy, guestRoomLightweightNonAuthenticatedEntity.includedChildOccupancy);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.identifier, this.hotelIdentifier, this.featuredInd, this.lifestyleType, this.location, this.descriptions, this.multimedias, this.contact, this.address, this.commissionable, this.name, this.proximityCode, this.sort, this.minAgeAppropriateCode, this.bookable, this.active, this.disabilityFeatures, this.securityFeatures, this.socials, this.pricePoint, this.recognitionList, this.maxOccupancy, this.minOccupancy, this.quantity, this.nonSmoking, this.bedroomConfigurationList, this.size, this.maxAdultOccupancy, this.maxChildOccupancy, this.bathroomCount, this.livingRoomCount, this.maxRollaways, this.roomCategory, this.floor, this.roomLocationCode, this.roomViewCode, this.composite, this.compositeCount, this.roomClassificationCode, this.roomArchitectureCode, this.roomGender, this.sharedRoomInd, this.maxCribs, this.amenities, this.includedAdultOccupancy, this.includedChildOccupancy});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GuestRoomLightweightNonAuthenticatedEntity {\n");
        sb.append("    identifier: ").append(this.toIndentedString(this.identifier)).append("\n");
        sb.append("    hotelIdentifier: ").append(this.toIndentedString(this.hotelIdentifier)).append("\n");
        sb.append("    featuredInd: ").append(this.toIndentedString(this.featuredInd)).append("\n");
        sb.append("    lifestyleType: ").append(this.toIndentedString((Object)this.lifestyleType)).append("\n");
        sb.append("    location: ").append(this.toIndentedString(this.location)).append("\n");
        sb.append("    descriptions: ").append(this.toIndentedString(this.descriptions)).append("\n");
        sb.append("    multimedias: ").append(this.toIndentedString(this.multimedias)).append("\n");
        sb.append("    contact: ").append(this.toIndentedString(this.contact)).append("\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    commissionable: ").append(this.toIndentedString(this.commissionable)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    proximityCode: ").append(this.toIndentedString(this.proximityCode)).append("\n");
        sb.append("    sort: ").append(this.toIndentedString(this.sort)).append("\n");
        sb.append("    minAgeAppropriateCode: ").append(this.toIndentedString(this.minAgeAppropriateCode)).append("\n");
        sb.append("    bookable: ").append(this.toIndentedString(this.bookable)).append("\n");
        sb.append("    active: ").append(this.toIndentedString(this.active)).append("\n");
        sb.append("    disabilityFeatures: ").append(this.toIndentedString(this.disabilityFeatures)).append("\n");
        sb.append("    securityFeatures: ").append(this.toIndentedString(this.securityFeatures)).append("\n");
        sb.append("    socials: ").append(this.toIndentedString(this.socials)).append("\n");
        sb.append("    pricePoint: ").append(this.toIndentedString((Object)this.pricePoint)).append("\n");
        sb.append("    recognitionList: ").append(this.toIndentedString(this.recognitionList)).append("\n");
        sb.append("    maxOccupancy: ").append(this.toIndentedString(this.maxOccupancy)).append("\n");
        sb.append("    minOccupancy: ").append(this.toIndentedString(this.minOccupancy)).append("\n");
        sb.append("    quantity: ").append(this.toIndentedString(this.quantity)).append("\n");
        sb.append("    nonSmoking: ").append(this.toIndentedString(this.nonSmoking)).append("\n");
        sb.append("    bedroomConfigurationList: ").append(this.toIndentedString(this.bedroomConfigurationList)).append("\n");
        sb.append("    size: ").append(this.toIndentedString(this.size)).append("\n");
        sb.append("    maxAdultOccupancy: ").append(this.toIndentedString(this.maxAdultOccupancy)).append("\n");
        sb.append("    maxChildOccupancy: ").append(this.toIndentedString(this.maxChildOccupancy)).append("\n");
        sb.append("    bathroomCount: ").append(this.toIndentedString(this.bathroomCount)).append("\n");
        sb.append("    livingRoomCount: ").append(this.toIndentedString(this.livingRoomCount)).append("\n");
        sb.append("    maxRollaways: ").append(this.toIndentedString(this.maxRollaways)).append("\n");
        sb.append("    roomCategory: ").append(this.toIndentedString(this.roomCategory)).append("\n");
        sb.append("    floor: ").append(this.toIndentedString(this.floor)).append("\n");
        sb.append("    roomLocationCode: ").append(this.toIndentedString(this.roomLocationCode)).append("\n");
        sb.append("    roomViewCode: ").append(this.toIndentedString(this.roomViewCode)).append("\n");
        sb.append("    composite: ").append(this.toIndentedString(this.composite)).append("\n");
        sb.append("    compositeCount: ").append(this.toIndentedString(this.compositeCount)).append("\n");
        sb.append("    roomClassificationCode: ").append(this.toIndentedString(this.roomClassificationCode)).append("\n");
        sb.append("    roomArchitectureCode: ").append(this.toIndentedString(this.roomArchitectureCode)).append("\n");
        sb.append("    roomGender: ").append(this.toIndentedString((Object)this.roomGender)).append("\n");
        sb.append("    sharedRoomInd: ").append(this.toIndentedString(this.sharedRoomInd)).append("\n");
        sb.append("    maxCribs: ").append(this.toIndentedString(this.maxCribs)).append("\n");
        sb.append("    amenities: ").append(this.toIndentedString(this.amenities)).append("\n");
        sb.append("    includedAdultOccupancy: ").append(this.toIndentedString(this.includedAdultOccupancy)).append("\n");
        sb.append("    includedChildOccupancy: ").append(this.toIndentedString(this.includedChildOccupancy)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum PricePointEnum {
        HALF(String.valueOf("HALF")),
        ONE(String.valueOf("ONE")),
        ONE_HALF(String.valueOf("ONE_HALF")),
        TWO(String.valueOf("TWO")),
        TWO_HALF(String.valueOf("TWO_HALF")),
        THREE(String.valueOf("THREE")),
        THREE_HALF(String.valueOf("THREE_HALF")),
        FOUR(String.valueOf("FOUR")),
        FOUR_HALF(String.valueOf("FOUR_HALF")),
        FIVE(String.valueOf("FIVE"));

        private String value;

        private PricePointEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PricePointEnum fromValue(String value) {
            for (PricePointEnum b : PricePointEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum RoomGenderEnum {
        MALE(String.valueOf("Male")),
        FEMALE(String.valueOf("Female")),
        MALE_AND_FEMALE(String.valueOf("MaleAndFemale")),
        UNKNOWN(String.valueOf("Unknown"));

        private String value;

        private RoomGenderEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static RoomGenderEnum fromValue(String value) {
            for (RoomGenderEnum b : RoomGenderEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum LifestyleTypeEnum {
        LIFESTYLE_HEALTH_FITNESS(String.valueOf("LIFESTYLE_HEALTH_FITNESS")),
        LIFESTYLE_RELAX(String.valueOf("LIFESTYLE_RELAX")),
        LIFESTYLE_ADULT_ONLY(String.valueOf("LIFESTYLE_ADULT_ONLY")),
        LIFESTYLE_ADVENTURE(String.valueOf("LIFESTYLE_ADVENTURE")),
        LIFESTYLE_BUSINESS(String.valueOf("LIFESTYLE_BUSINESS")),
        LIFESTYLE_LGBT(String.valueOf("LIFESTYLE_LGBT")),
        LIFESTYLE_SINGLE_PARENT(String.valueOf("LIFESTYLE_SINGLE_PARENT")),
        LIFESTYLE_SOLO_FEMALE(String.valueOf("LIFESTYLE_SOLO_FEMALE")),
        LIFESTYLE_BEAUTY(String.valueOf("LIFESTYLE_BEAUTY")),
        LIFESTYLE_FOODIE(String.valueOf("LIFESTYLE_FOODIE")),
        LIFESTYLE_FAMILY(String.valueOf("LIFESTYLE_FAMILY")),
        LIFESTYLE_ROMANCE(String.valueOf("LIFESTYLE_ROMANCE")),
        LIFESTYLE_COUPLE(String.valueOf("LIFESTYLE_COUPLE")),
        LIFESTYLE_SOLO(String.valueOf("LIFESTYLE_SOLO")),
        LIFESTYLE_BACKPACKER(String.valueOf("LIFESTYLE_BACKPACKER")),
        LIFESTYLE_SHOPPING(String.valueOf("LIFESTYLE_SHOPPING")),
        LIFESTYLE_SPORTS(String.valueOf("LIFESTYLE_SPORTS")),
        LIFESTYLE_MOUNTAIN(String.valueOf("LIFESTYLE_MOUNTAIN")),
        LIFESTYLE_BEACH(String.valueOf("LIFESTYLE_BEACH")),
        LIFESTYLE_CITY(String.valueOf("LIFESTYLE_CITY")),
        LIFESTYLE_COUNTRY(String.valueOf("LIFESTYLE_COUNTRY")),
        LIFESTYLE_CULTURE(String.valueOf("LIFESTYLE_CULTURE")),
        LIFESTYLE_ECO(String.valueOf("LIFESTYLE_ECO"));

        private String value;

        private LifestyleTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static LifestyleTypeEnum fromValue(String value) {
            for (LifestyleTypeEnum b : LifestyleTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

