/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.inventory.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import travel.wink.sdk.inventory.model.RoomConfigurationNonAuthenticatedEntity;

@JsonPropertyOrder(value={"startDate", "endDate", "nights", "items", "hours", "children", "rooms", "guests"})
@JsonTypeName(value="Itinerary_Non_Authenticated_Entity")
public class ItineraryNonAuthenticatedEntity {
    public static final String JSON_PROPERTY_START_DATE = "startDate";
    @Nonnull
    private LocalDate startDate;
    public static final String JSON_PROPERTY_END_DATE = "endDate";
    @Nullable
    private LocalDate endDate;
    public static final String JSON_PROPERTY_NIGHTS = "nights";
    @Nullable
    private Integer nights;
    public static final String JSON_PROPERTY_ITEMS = "items";
    @Nonnull
    private List<@Valid RoomConfigurationNonAuthenticatedEntity> items = new ArrayList<RoomConfigurationNonAuthenticatedEntity>();
    public static final String JSON_PROPERTY_HOURS = "hours";
    @Nullable
    private Long hours;
    public static final String JSON_PROPERTY_CHILDREN = "children";
    @Nullable
    private Integer children;
    public static final String JSON_PROPERTY_ROOMS = "rooms";
    @Nullable
    private Integer rooms;
    public static final String JSON_PROPERTY_GUESTS = "guests";
    @Nullable
    private Integer guests;

    public ItineraryNonAuthenticatedEntity() {
    }

    @JsonCreator
    public ItineraryNonAuthenticatedEntity(@JsonProperty(value="hours") Long hours) {
        this();
        this.hours = hours;
    }

    public ItineraryNonAuthenticatedEntity startDate(@Nonnull LocalDate startDate) {
        this.startDate = startDate;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="startDate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public LocalDate getStartDate() {
        return this.startDate;
    }

    @JsonProperty(value="startDate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setStartDate(@Nonnull LocalDate startDate) {
        this.startDate = startDate;
    }

    public ItineraryNonAuthenticatedEntity endDate(@Nullable LocalDate endDate) {
        this.endDate = endDate;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="endDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDate getEndDate() {
        return this.endDate;
    }

    @JsonProperty(value="endDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEndDate(@Nullable LocalDate endDate) {
        this.endDate = endDate;
    }

    public ItineraryNonAuthenticatedEntity nights(@Nullable Integer nights) {
        this.nights = nights;
        return this;
    }

    @Nullable
    @JsonProperty(value="nights")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getNights() {
        return this.nights;
    }

    @JsonProperty(value="nights")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNights(@Nullable Integer nights) {
        this.nights = nights;
    }

    public ItineraryNonAuthenticatedEntity items(@Nonnull List<@Valid RoomConfigurationNonAuthenticatedEntity> items) {
        this.items = items;
        return this;
    }

    public ItineraryNonAuthenticatedEntity addItemsItem(RoomConfigurationNonAuthenticatedEntity itemsItem) {
        if (this.items == null) {
            this.items = new ArrayList<RoomConfigurationNonAuthenticatedEntity>();
        }
        this.items.add(itemsItem);
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @Size(min=1, max=0x7FFFFFFF)
    @JsonProperty(value="items")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @Size(min=1, max=0x7FFFFFFF) List<@Valid RoomConfigurationNonAuthenticatedEntity> getItems() {
        return this.items;
    }

    @JsonProperty(value="items")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setItems(@Nonnull List<@Valid RoomConfigurationNonAuthenticatedEntity> items) {
        this.items = items;
    }

    @Nullable
    @JsonProperty(value="hours")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getHours() {
        return this.hours;
    }

    public ItineraryNonAuthenticatedEntity children(@Nullable Integer children) {
        this.children = children;
        return this;
    }

    @Nullable
    @JsonProperty(value="children")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getChildren() {
        return this.children;
    }

    @JsonProperty(value="children")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setChildren(@Nullable Integer children) {
        this.children = children;
    }

    public ItineraryNonAuthenticatedEntity rooms(@Nullable Integer rooms) {
        this.rooms = rooms;
        return this;
    }

    @Nullable
    @JsonProperty(value="rooms")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getRooms() {
        return this.rooms;
    }

    @JsonProperty(value="rooms")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRooms(@Nullable Integer rooms) {
        this.rooms = rooms;
    }

    public ItineraryNonAuthenticatedEntity guests(@Nullable Integer guests) {
        this.guests = guests;
        return this;
    }

    @Nullable
    @JsonProperty(value="guests")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getGuests() {
        return this.guests;
    }

    @JsonProperty(value="guests")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setGuests(@Nullable Integer guests) {
        this.guests = guests;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItineraryNonAuthenticatedEntity itineraryNonAuthenticatedEntity = (ItineraryNonAuthenticatedEntity)o;
        return Objects.equals(this.startDate, itineraryNonAuthenticatedEntity.startDate) && Objects.equals(this.endDate, itineraryNonAuthenticatedEntity.endDate) && Objects.equals(this.nights, itineraryNonAuthenticatedEntity.nights) && Objects.equals(this.items, itineraryNonAuthenticatedEntity.items) && Objects.equals(this.hours, itineraryNonAuthenticatedEntity.hours) && Objects.equals(this.children, itineraryNonAuthenticatedEntity.children) && Objects.equals(this.rooms, itineraryNonAuthenticatedEntity.rooms) && Objects.equals(this.guests, itineraryNonAuthenticatedEntity.guests);
    }

    public int hashCode() {
        return Objects.hash(this.startDate, this.endDate, this.nights, this.items, this.hours, this.children, this.rooms, this.guests);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ItineraryNonAuthenticatedEntity {\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("    nights: ").append(this.toIndentedString(this.nights)).append("\n");
        sb.append("    items: ").append(this.toIndentedString(this.items)).append("\n");
        sb.append("    hours: ").append(this.toIndentedString(this.hours)).append("\n");
        sb.append("    children: ").append(this.toIndentedString(this.children)).append("\n");
        sb.append("    rooms: ").append(this.toIndentedString(this.rooms)).append("\n");
        sb.append("    guests: ").append(this.toIndentedString(this.guests)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

