/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.inventory.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import travel.wink.sdk.inventory.model.ContactNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.DowPatternGroupNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.GeoJsonPointNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.SimpleAddressNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.SimpleDescriptionNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.SimpleMultimediaNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.SocialNonAuthenticatedEntity;
import travel.wink.sdk.inventory.model.TravelInventoryRecognitionNonAuthenticatedEntity;

@JsonPropertyOrder(value={"identifier", "hotelIdentifier", "featuredInd", "lifestyleType", "location", "descriptions", "multimedias", "contact", "address", "commissionable", "name", "proximityCode", "sort", "minAgeAppropriateCode", "bookable", "active", "disabilityFeatures", "securityFeatures", "socials", "pricePoint", "recognitionList", "applicableStart", "applicableEnd", "reservationRequiredInd", "opens", "closes", "daysOfWeek", "maxSeatingCapacity", "maxSingleParty", "offerBreakfast", "offerLunch", "offerDinner", "offerBrunch", "amenities", "infoCodes", "cuisineCodes"})
@JsonTypeName(value="RestaurantLightweight_Non_Authenticated_Entity")
public class RestaurantLightweightNonAuthenticatedEntity {
    public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
    @Nonnull
    private UUID identifier;
    public static final String JSON_PROPERTY_HOTEL_IDENTIFIER = "hotelIdentifier";
    @Nonnull
    private UUID hotelIdentifier;
    public static final String JSON_PROPERTY_FEATURED_IND = "featuredInd";
    @Nonnull
    private Boolean featuredInd;
    public static final String JSON_PROPERTY_LIFESTYLE_TYPE = "lifestyleType";
    @Nullable
    private LifestyleTypeEnum lifestyleType;
    public static final String JSON_PROPERTY_LOCATION = "location";
    @Nonnull
    private GeoJsonPointNonAuthenticatedEntity location;
    public static final String JSON_PROPERTY_DESCRIPTIONS = "descriptions";
    @Nonnull
    private List<@Valid SimpleDescriptionNonAuthenticatedEntity> descriptions = new ArrayList<SimpleDescriptionNonAuthenticatedEntity>();
    public static final String JSON_PROPERTY_MULTIMEDIAS = "multimedias";
    @Nonnull
    private List<@Valid SimpleMultimediaNonAuthenticatedEntity> multimedias = new ArrayList<SimpleMultimediaNonAuthenticatedEntity>();
    public static final String JSON_PROPERTY_CONTACT = "contact";
    @Nonnull
    private ContactNonAuthenticatedEntity contact;
    public static final String JSON_PROPERTY_ADDRESS = "address";
    @Nonnull
    private SimpleAddressNonAuthenticatedEntity address;
    public static final String JSON_PROPERTY_COMMISSIONABLE = "commissionable";
    @Nonnull
    private Boolean commissionable = true;
    public static final String JSON_PROPERTY_NAME = "name";
    @Nonnull
    private String name;
    public static final String JSON_PROPERTY_PROXIMITY_CODE = "proximityCode";
    @Nonnull
    private String proximityCode;
    public static final String JSON_PROPERTY_SORT = "sort";
    @Nullable
    private Integer sort;
    public static final String JSON_PROPERTY_MIN_AGE_APPROPRIATE_CODE = "minAgeAppropriateCode";
    @Nullable
    private String minAgeAppropriateCode;
    public static final String JSON_PROPERTY_BOOKABLE = "bookable";
    @Nonnull
    private Boolean bookable = true;
    public static final String JSON_PROPERTY_ACTIVE = "active";
    @Nonnull
    private Boolean active = true;
    public static final String JSON_PROPERTY_DISABILITY_FEATURES = "disabilityFeatures";
    @Nullable
    private List<String> disabilityFeatures = new ArrayList<String>();
    public static final String JSON_PROPERTY_SECURITY_FEATURES = "securityFeatures";
    @Nullable
    private List<String> securityFeatures = new ArrayList<String>();
    public static final String JSON_PROPERTY_SOCIALS = "socials";
    @Nullable
    private List<@Valid SocialNonAuthenticatedEntity> socials = new ArrayList<SocialNonAuthenticatedEntity>();
    public static final String JSON_PROPERTY_PRICE_POINT = "pricePoint";
    @Nonnull
    private PricePointEnum pricePoint = PricePointEnum.THREE;
    public static final String JSON_PROPERTY_RECOGNITION_LIST = "recognitionList";
    @Nullable
    private List<@Valid TravelInventoryRecognitionNonAuthenticatedEntity> recognitionList = new ArrayList<TravelInventoryRecognitionNonAuthenticatedEntity>();
    public static final String JSON_PROPERTY_APPLICABLE_START = "applicableStart";
    @Nullable
    private LocalDate applicableStart;
    public static final String JSON_PROPERTY_APPLICABLE_END = "applicableEnd";
    @Nullable
    private LocalDate applicableEnd;
    public static final String JSON_PROPERTY_RESERVATION_REQUIRED_IND = "reservationRequiredInd";
    @Nullable
    private Boolean reservationRequiredInd;
    public static final String JSON_PROPERTY_OPENS = "opens";
    @Nullable
    private String opens;
    public static final String JSON_PROPERTY_CLOSES = "closes";
    @Nullable
    private String closes;
    public static final String JSON_PROPERTY_DAYS_OF_WEEK = "daysOfWeek";
    @Nullable
    private DowPatternGroupNonAuthenticatedEntity daysOfWeek;
    public static final String JSON_PROPERTY_MAX_SEATING_CAPACITY = "maxSeatingCapacity";
    @Nonnull
    private Integer maxSeatingCapacity;
    public static final String JSON_PROPERTY_MAX_SINGLE_PARTY = "maxSingleParty";
    @Nonnull
    private Integer maxSingleParty;
    public static final String JSON_PROPERTY_OFFER_BREAKFAST = "offerBreakfast";
    @Nonnull
    private Boolean offerBreakfast = false;
    public static final String JSON_PROPERTY_OFFER_LUNCH = "offerLunch";
    @Nonnull
    private Boolean offerLunch = false;
    public static final String JSON_PROPERTY_OFFER_DINNER = "offerDinner";
    @Nonnull
    private Boolean offerDinner = false;
    public static final String JSON_PROPERTY_OFFER_BRUNCH = "offerBrunch";
    @Nonnull
    private Boolean offerBrunch = false;
    public static final String JSON_PROPERTY_AMENITIES = "amenities";
    @Nullable
    private List<String> amenities = new ArrayList<String>();
    public static final String JSON_PROPERTY_INFO_CODES = "infoCodes";
    @Nullable
    private List<String> infoCodes = new ArrayList<String>();
    public static final String JSON_PROPERTY_CUISINE_CODES = "cuisineCodes";
    @Nullable
    private List<String> cuisineCodes = new ArrayList<String>();

    public RestaurantLightweightNonAuthenticatedEntity identifier(@Nonnull UUID identifier) {
        this.identifier = identifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @Size(min=1)
    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @Size(min=1) UUID getIdentifier() {
        return this.identifier;
    }

    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setIdentifier(@Nonnull UUID identifier) {
        this.identifier = identifier;
    }

    public RestaurantLightweightNonAuthenticatedEntity hotelIdentifier(@Nonnull UUID hotelIdentifier) {
        this.hotelIdentifier = hotelIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @Size(min=1)
    @JsonProperty(value="hotelIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @Size(min=1) UUID getHotelIdentifier() {
        return this.hotelIdentifier;
    }

    @JsonProperty(value="hotelIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setHotelIdentifier(@Nonnull UUID hotelIdentifier) {
        this.hotelIdentifier = hotelIdentifier;
    }

    public RestaurantLightweightNonAuthenticatedEntity featuredInd(@Nonnull Boolean featuredInd) {
        this.featuredInd = featuredInd;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="featuredInd")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getFeaturedInd() {
        return this.featuredInd;
    }

    @JsonProperty(value="featuredInd")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setFeaturedInd(@Nonnull Boolean featuredInd) {
        this.featuredInd = featuredInd;
    }

    public RestaurantLightweightNonAuthenticatedEntity lifestyleType(@Nullable LifestyleTypeEnum lifestyleType) {
        this.lifestyleType = lifestyleType;
        return this;
    }

    @Nullable
    @JsonProperty(value="lifestyleType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LifestyleTypeEnum getLifestyleType() {
        return this.lifestyleType;
    }

    @JsonProperty(value="lifestyleType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLifestyleType(@Nullable LifestyleTypeEnum lifestyleType) {
        this.lifestyleType = lifestyleType;
    }

    public RestaurantLightweightNonAuthenticatedEntity location(@Nonnull GeoJsonPointNonAuthenticatedEntity location) {
        this.location = location;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="location")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public GeoJsonPointNonAuthenticatedEntity getLocation() {
        return this.location;
    }

    @JsonProperty(value="location")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setLocation(@Nonnull GeoJsonPointNonAuthenticatedEntity location) {
        this.location = location;
    }

    public RestaurantLightweightNonAuthenticatedEntity descriptions(@Nonnull List<@Valid SimpleDescriptionNonAuthenticatedEntity> descriptions) {
        this.descriptions = descriptions;
        return this;
    }

    public RestaurantLightweightNonAuthenticatedEntity addDescriptionsItem(SimpleDescriptionNonAuthenticatedEntity descriptionsItem) {
        if (this.descriptions == null) {
            this.descriptions = new ArrayList<SimpleDescriptionNonAuthenticatedEntity>();
        }
        this.descriptions.add(descriptionsItem);
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @Size(min=1)
    @JsonProperty(value="descriptions")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @Size(min=1) List<@Valid SimpleDescriptionNonAuthenticatedEntity> getDescriptions() {
        return this.descriptions;
    }

    @JsonProperty(value="descriptions")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDescriptions(@Nonnull List<@Valid SimpleDescriptionNonAuthenticatedEntity> descriptions) {
        this.descriptions = descriptions;
    }

    public RestaurantLightweightNonAuthenticatedEntity multimedias(@Nonnull List<@Valid SimpleMultimediaNonAuthenticatedEntity> multimedias) {
        this.multimedias = multimedias;
        return this;
    }

    public RestaurantLightweightNonAuthenticatedEntity addMultimediasItem(SimpleMultimediaNonAuthenticatedEntity multimediasItem) {
        if (this.multimedias == null) {
            this.multimedias = new ArrayList<SimpleMultimediaNonAuthenticatedEntity>();
        }
        this.multimedias.add(multimediasItem);
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @Size(min=1)
    @JsonProperty(value="multimedias")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @Size(min=1) List<@Valid SimpleMultimediaNonAuthenticatedEntity> getMultimedias() {
        return this.multimedias;
    }

    @JsonProperty(value="multimedias")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setMultimedias(@Nonnull List<@Valid SimpleMultimediaNonAuthenticatedEntity> multimedias) {
        this.multimedias = multimedias;
    }

    public RestaurantLightweightNonAuthenticatedEntity contact(@Nonnull ContactNonAuthenticatedEntity contact) {
        this.contact = contact;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="contact")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ContactNonAuthenticatedEntity getContact() {
        return this.contact;
    }

    @JsonProperty(value="contact")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setContact(@Nonnull ContactNonAuthenticatedEntity contact) {
        this.contact = contact;
    }

    public RestaurantLightweightNonAuthenticatedEntity address(@Nonnull SimpleAddressNonAuthenticatedEntity address) {
        this.address = address;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public SimpleAddressNonAuthenticatedEntity getAddress() {
        return this.address;
    }

    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAddress(@Nonnull SimpleAddressNonAuthenticatedEntity address) {
        this.address = address;
    }

    public RestaurantLightweightNonAuthenticatedEntity commissionable(@Nonnull Boolean commissionable) {
        this.commissionable = commissionable;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="commissionable")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getCommissionable() {
        return this.commissionable;
    }

    @JsonProperty(value="commissionable")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCommissionable(@Nonnull Boolean commissionable) {
        this.commissionable = commissionable;
    }

    public RestaurantLightweightNonAuthenticatedEntity name(@Nonnull String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @NotNull
    @Size(min=1)
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=1) String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(@Nonnull String name) {
        this.name = name;
    }

    public RestaurantLightweightNonAuthenticatedEntity proximityCode(@Nonnull String proximityCode) {
        this.proximityCode = proximityCode;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="proximityCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getProximityCode() {
        return this.proximityCode;
    }

    @JsonProperty(value="proximityCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setProximityCode(@Nonnull String proximityCode) {
        this.proximityCode = proximityCode;
    }

    public RestaurantLightweightNonAuthenticatedEntity sort(@Nullable Integer sort) {
        this.sort = sort;
        return this;
    }

    @Nullable
    @JsonProperty(value="sort")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getSort() {
        return this.sort;
    }

    @JsonProperty(value="sort")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSort(@Nullable Integer sort) {
        this.sort = sort;
    }

    public RestaurantLightweightNonAuthenticatedEntity minAgeAppropriateCode(@Nullable String minAgeAppropriateCode) {
        this.minAgeAppropriateCode = minAgeAppropriateCode;
        return this;
    }

    @Nullable
    @JsonProperty(value="minAgeAppropriateCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMinAgeAppropriateCode() {
        return this.minAgeAppropriateCode;
    }

    @JsonProperty(value="minAgeAppropriateCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMinAgeAppropriateCode(@Nullable String minAgeAppropriateCode) {
        this.minAgeAppropriateCode = minAgeAppropriateCode;
    }

    public RestaurantLightweightNonAuthenticatedEntity bookable(@Nonnull Boolean bookable) {
        this.bookable = bookable;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="bookable")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getBookable() {
        return this.bookable;
    }

    @JsonProperty(value="bookable")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setBookable(@Nonnull Boolean bookable) {
        this.bookable = bookable;
    }

    public RestaurantLightweightNonAuthenticatedEntity active(@Nonnull Boolean active) {
        this.active = active;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="active")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getActive() {
        return this.active;
    }

    @JsonProperty(value="active")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setActive(@Nonnull Boolean active) {
        this.active = active;
    }

    public RestaurantLightweightNonAuthenticatedEntity disabilityFeatures(@Nullable List<String> disabilityFeatures) {
        this.disabilityFeatures = disabilityFeatures;
        return this;
    }

    public RestaurantLightweightNonAuthenticatedEntity addDisabilityFeaturesItem(String disabilityFeaturesItem) {
        if (this.disabilityFeatures == null) {
            this.disabilityFeatures = new ArrayList<String>();
        }
        this.disabilityFeatures.add(disabilityFeaturesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="disabilityFeatures")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getDisabilityFeatures() {
        return this.disabilityFeatures;
    }

    @JsonProperty(value="disabilityFeatures")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDisabilityFeatures(@Nullable List<String> disabilityFeatures) {
        this.disabilityFeatures = disabilityFeatures;
    }

    public RestaurantLightweightNonAuthenticatedEntity securityFeatures(@Nullable List<String> securityFeatures) {
        this.securityFeatures = securityFeatures;
        return this;
    }

    public RestaurantLightweightNonAuthenticatedEntity addSecurityFeaturesItem(String securityFeaturesItem) {
        if (this.securityFeatures == null) {
            this.securityFeatures = new ArrayList<String>();
        }
        this.securityFeatures.add(securityFeaturesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="securityFeatures")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getSecurityFeatures() {
        return this.securityFeatures;
    }

    @JsonProperty(value="securityFeatures")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSecurityFeatures(@Nullable List<String> securityFeatures) {
        this.securityFeatures = securityFeatures;
    }

    public RestaurantLightweightNonAuthenticatedEntity socials(@Nullable List<@Valid SocialNonAuthenticatedEntity> socials) {
        this.socials = socials;
        return this;
    }

    public RestaurantLightweightNonAuthenticatedEntity addSocialsItem(SocialNonAuthenticatedEntity socialsItem) {
        if (this.socials == null) {
            this.socials = new ArrayList<SocialNonAuthenticatedEntity>();
        }
        this.socials.add(socialsItem);
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="socials")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public @Valid List<@Valid SocialNonAuthenticatedEntity> getSocials() {
        return this.socials;
    }

    @JsonProperty(value="socials")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSocials(@Nullable List<@Valid SocialNonAuthenticatedEntity> socials) {
        this.socials = socials;
    }

    public RestaurantLightweightNonAuthenticatedEntity pricePoint(@Nonnull PricePointEnum pricePoint) {
        this.pricePoint = pricePoint;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="pricePoint")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public PricePointEnum getPricePoint() {
        return this.pricePoint;
    }

    @JsonProperty(value="pricePoint")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPricePoint(@Nonnull PricePointEnum pricePoint) {
        this.pricePoint = pricePoint;
    }

    public RestaurantLightweightNonAuthenticatedEntity recognitionList(@Nullable List<@Valid TravelInventoryRecognitionNonAuthenticatedEntity> recognitionList) {
        this.recognitionList = recognitionList;
        return this;
    }

    public RestaurantLightweightNonAuthenticatedEntity addRecognitionListItem(TravelInventoryRecognitionNonAuthenticatedEntity recognitionListItem) {
        if (this.recognitionList == null) {
            this.recognitionList = new ArrayList<TravelInventoryRecognitionNonAuthenticatedEntity>();
        }
        this.recognitionList.add(recognitionListItem);
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="recognitionList")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public @Valid List<@Valid TravelInventoryRecognitionNonAuthenticatedEntity> getRecognitionList() {
        return this.recognitionList;
    }

    @JsonProperty(value="recognitionList")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRecognitionList(@Nullable List<@Valid TravelInventoryRecognitionNonAuthenticatedEntity> recognitionList) {
        this.recognitionList = recognitionList;
    }

    public RestaurantLightweightNonAuthenticatedEntity applicableStart(@Nullable LocalDate applicableStart) {
        this.applicableStart = applicableStart;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="applicableStart")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDate getApplicableStart() {
        return this.applicableStart;
    }

    @JsonProperty(value="applicableStart")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setApplicableStart(@Nullable LocalDate applicableStart) {
        this.applicableStart = applicableStart;
    }

    public RestaurantLightweightNonAuthenticatedEntity applicableEnd(@Nullable LocalDate applicableEnd) {
        this.applicableEnd = applicableEnd;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="applicableEnd")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDate getApplicableEnd() {
        return this.applicableEnd;
    }

    @JsonProperty(value="applicableEnd")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setApplicableEnd(@Nullable LocalDate applicableEnd) {
        this.applicableEnd = applicableEnd;
    }

    public RestaurantLightweightNonAuthenticatedEntity reservationRequiredInd(@Nullable Boolean reservationRequiredInd) {
        this.reservationRequiredInd = reservationRequiredInd;
        return this;
    }

    @Nullable
    @JsonProperty(value="reservationRequiredInd")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getReservationRequiredInd() {
        return this.reservationRequiredInd;
    }

    @JsonProperty(value="reservationRequiredInd")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReservationRequiredInd(@Nullable Boolean reservationRequiredInd) {
        this.reservationRequiredInd = reservationRequiredInd;
    }

    public RestaurantLightweightNonAuthenticatedEntity opens(@Nullable String opens) {
        this.opens = opens;
        return this;
    }

    @Nullable
    @JsonProperty(value="opens")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getOpens() {
        return this.opens;
    }

    @JsonProperty(value="opens")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOpens(@Nullable String opens) {
        this.opens = opens;
    }

    public RestaurantLightweightNonAuthenticatedEntity closes(@Nullable String closes) {
        this.closes = closes;
        return this;
    }

    @Nullable
    @JsonProperty(value="closes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCloses() {
        return this.closes;
    }

    @JsonProperty(value="closes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCloses(@Nullable String closes) {
        this.closes = closes;
    }

    public RestaurantLightweightNonAuthenticatedEntity daysOfWeek(@Nullable DowPatternGroupNonAuthenticatedEntity daysOfWeek) {
        this.daysOfWeek = daysOfWeek;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="daysOfWeek")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public DowPatternGroupNonAuthenticatedEntity getDaysOfWeek() {
        return this.daysOfWeek;
    }

    @JsonProperty(value="daysOfWeek")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDaysOfWeek(@Nullable DowPatternGroupNonAuthenticatedEntity daysOfWeek) {
        this.daysOfWeek = daysOfWeek;
    }

    public RestaurantLightweightNonAuthenticatedEntity maxSeatingCapacity(@Nonnull Integer maxSeatingCapacity) {
        this.maxSeatingCapacity = maxSeatingCapacity;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=1L)
    @JsonProperty(value="maxSeatingCapacity")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=1L) Integer getMaxSeatingCapacity() {
        return this.maxSeatingCapacity;
    }

    @JsonProperty(value="maxSeatingCapacity")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setMaxSeatingCapacity(@Nonnull Integer maxSeatingCapacity) {
        this.maxSeatingCapacity = maxSeatingCapacity;
    }

    public RestaurantLightweightNonAuthenticatedEntity maxSingleParty(@Nonnull Integer maxSingleParty) {
        this.maxSingleParty = maxSingleParty;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=1L)
    @JsonProperty(value="maxSingleParty")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=1L) Integer getMaxSingleParty() {
        return this.maxSingleParty;
    }

    @JsonProperty(value="maxSingleParty")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setMaxSingleParty(@Nonnull Integer maxSingleParty) {
        this.maxSingleParty = maxSingleParty;
    }

    public RestaurantLightweightNonAuthenticatedEntity offerBreakfast(@Nonnull Boolean offerBreakfast) {
        this.offerBreakfast = offerBreakfast;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="offerBreakfast")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getOfferBreakfast() {
        return this.offerBreakfast;
    }

    @JsonProperty(value="offerBreakfast")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setOfferBreakfast(@Nonnull Boolean offerBreakfast) {
        this.offerBreakfast = offerBreakfast;
    }

    public RestaurantLightweightNonAuthenticatedEntity offerLunch(@Nonnull Boolean offerLunch) {
        this.offerLunch = offerLunch;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="offerLunch")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getOfferLunch() {
        return this.offerLunch;
    }

    @JsonProperty(value="offerLunch")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setOfferLunch(@Nonnull Boolean offerLunch) {
        this.offerLunch = offerLunch;
    }

    public RestaurantLightweightNonAuthenticatedEntity offerDinner(@Nonnull Boolean offerDinner) {
        this.offerDinner = offerDinner;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="offerDinner")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getOfferDinner() {
        return this.offerDinner;
    }

    @JsonProperty(value="offerDinner")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setOfferDinner(@Nonnull Boolean offerDinner) {
        this.offerDinner = offerDinner;
    }

    public RestaurantLightweightNonAuthenticatedEntity offerBrunch(@Nonnull Boolean offerBrunch) {
        this.offerBrunch = offerBrunch;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="offerBrunch")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getOfferBrunch() {
        return this.offerBrunch;
    }

    @JsonProperty(value="offerBrunch")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setOfferBrunch(@Nonnull Boolean offerBrunch) {
        this.offerBrunch = offerBrunch;
    }

    public RestaurantLightweightNonAuthenticatedEntity amenities(@Nullable List<String> amenities) {
        this.amenities = amenities;
        return this;
    }

    public RestaurantLightweightNonAuthenticatedEntity addAmenitiesItem(String amenitiesItem) {
        if (this.amenities == null) {
            this.amenities = new ArrayList<String>();
        }
        this.amenities.add(amenitiesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="amenities")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getAmenities() {
        return this.amenities;
    }

    @JsonProperty(value="amenities")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAmenities(@Nullable List<String> amenities) {
        this.amenities = amenities;
    }

    public RestaurantLightweightNonAuthenticatedEntity infoCodes(@Nullable List<String> infoCodes) {
        this.infoCodes = infoCodes;
        return this;
    }

    public RestaurantLightweightNonAuthenticatedEntity addInfoCodesItem(String infoCodesItem) {
        if (this.infoCodes == null) {
            this.infoCodes = new ArrayList<String>();
        }
        this.infoCodes.add(infoCodesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="infoCodes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getInfoCodes() {
        return this.infoCodes;
    }

    @JsonProperty(value="infoCodes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInfoCodes(@Nullable List<String> infoCodes) {
        this.infoCodes = infoCodes;
    }

    public RestaurantLightweightNonAuthenticatedEntity cuisineCodes(@Nullable List<String> cuisineCodes) {
        this.cuisineCodes = cuisineCodes;
        return this;
    }

    public RestaurantLightweightNonAuthenticatedEntity addCuisineCodesItem(String cuisineCodesItem) {
        if (this.cuisineCodes == null) {
            this.cuisineCodes = new ArrayList<String>();
        }
        this.cuisineCodes.add(cuisineCodesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="cuisineCodes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getCuisineCodes() {
        return this.cuisineCodes;
    }

    @JsonProperty(value="cuisineCodes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCuisineCodes(@Nullable List<String> cuisineCodes) {
        this.cuisineCodes = cuisineCodes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RestaurantLightweightNonAuthenticatedEntity restaurantLightweightNonAuthenticatedEntity = (RestaurantLightweightNonAuthenticatedEntity)o;
        return Objects.equals(this.identifier, restaurantLightweightNonAuthenticatedEntity.identifier) && Objects.equals(this.hotelIdentifier, restaurantLightweightNonAuthenticatedEntity.hotelIdentifier) && Objects.equals(this.featuredInd, restaurantLightweightNonAuthenticatedEntity.featuredInd) && Objects.equals((Object)this.lifestyleType, (Object)restaurantLightweightNonAuthenticatedEntity.lifestyleType) && Objects.equals(this.location, restaurantLightweightNonAuthenticatedEntity.location) && Objects.equals(this.descriptions, restaurantLightweightNonAuthenticatedEntity.descriptions) && Objects.equals(this.multimedias, restaurantLightweightNonAuthenticatedEntity.multimedias) && Objects.equals(this.contact, restaurantLightweightNonAuthenticatedEntity.contact) && Objects.equals(this.address, restaurantLightweightNonAuthenticatedEntity.address) && Objects.equals(this.commissionable, restaurantLightweightNonAuthenticatedEntity.commissionable) && Objects.equals(this.name, restaurantLightweightNonAuthenticatedEntity.name) && Objects.equals(this.proximityCode, restaurantLightweightNonAuthenticatedEntity.proximityCode) && Objects.equals(this.sort, restaurantLightweightNonAuthenticatedEntity.sort) && Objects.equals(this.minAgeAppropriateCode, restaurantLightweightNonAuthenticatedEntity.minAgeAppropriateCode) && Objects.equals(this.bookable, restaurantLightweightNonAuthenticatedEntity.bookable) && Objects.equals(this.active, restaurantLightweightNonAuthenticatedEntity.active) && Objects.equals(this.disabilityFeatures, restaurantLightweightNonAuthenticatedEntity.disabilityFeatures) && Objects.equals(this.securityFeatures, restaurantLightweightNonAuthenticatedEntity.securityFeatures) && Objects.equals(this.socials, restaurantLightweightNonAuthenticatedEntity.socials) && Objects.equals((Object)this.pricePoint, (Object)restaurantLightweightNonAuthenticatedEntity.pricePoint) && Objects.equals(this.recognitionList, restaurantLightweightNonAuthenticatedEntity.recognitionList) && Objects.equals(this.applicableStart, restaurantLightweightNonAuthenticatedEntity.applicableStart) && Objects.equals(this.applicableEnd, restaurantLightweightNonAuthenticatedEntity.applicableEnd) && Objects.equals(this.reservationRequiredInd, restaurantLightweightNonAuthenticatedEntity.reservationRequiredInd) && Objects.equals(this.opens, restaurantLightweightNonAuthenticatedEntity.opens) && Objects.equals(this.closes, restaurantLightweightNonAuthenticatedEntity.closes) && Objects.equals(this.daysOfWeek, restaurantLightweightNonAuthenticatedEntity.daysOfWeek) && Objects.equals(this.maxSeatingCapacity, restaurantLightweightNonAuthenticatedEntity.maxSeatingCapacity) && Objects.equals(this.maxSingleParty, restaurantLightweightNonAuthenticatedEntity.maxSingleParty) && Objects.equals(this.offerBreakfast, restaurantLightweightNonAuthenticatedEntity.offerBreakfast) && Objects.equals(this.offerLunch, restaurantLightweightNonAuthenticatedEntity.offerLunch) && Objects.equals(this.offerDinner, restaurantLightweightNonAuthenticatedEntity.offerDinner) && Objects.equals(this.offerBrunch, restaurantLightweightNonAuthenticatedEntity.offerBrunch) && Objects.equals(this.amenities, restaurantLightweightNonAuthenticatedEntity.amenities) && Objects.equals(this.infoCodes, restaurantLightweightNonAuthenticatedEntity.infoCodes) && Objects.equals(this.cuisineCodes, restaurantLightweightNonAuthenticatedEntity.cuisineCodes);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.identifier, this.hotelIdentifier, this.featuredInd, this.lifestyleType, this.location, this.descriptions, this.multimedias, this.contact, this.address, this.commissionable, this.name, this.proximityCode, this.sort, this.minAgeAppropriateCode, this.bookable, this.active, this.disabilityFeatures, this.securityFeatures, this.socials, this.pricePoint, this.recognitionList, this.applicableStart, this.applicableEnd, this.reservationRequiredInd, this.opens, this.closes, this.daysOfWeek, this.maxSeatingCapacity, this.maxSingleParty, this.offerBreakfast, this.offerLunch, this.offerDinner, this.offerBrunch, this.amenities, this.infoCodes, this.cuisineCodes});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RestaurantLightweightNonAuthenticatedEntity {\n");
        sb.append("    identifier: ").append(this.toIndentedString(this.identifier)).append("\n");
        sb.append("    hotelIdentifier: ").append(this.toIndentedString(this.hotelIdentifier)).append("\n");
        sb.append("    featuredInd: ").append(this.toIndentedString(this.featuredInd)).append("\n");
        sb.append("    lifestyleType: ").append(this.toIndentedString((Object)this.lifestyleType)).append("\n");
        sb.append("    location: ").append(this.toIndentedString(this.location)).append("\n");
        sb.append("    descriptions: ").append(this.toIndentedString(this.descriptions)).append("\n");
        sb.append("    multimedias: ").append(this.toIndentedString(this.multimedias)).append("\n");
        sb.append("    contact: ").append(this.toIndentedString(this.contact)).append("\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    commissionable: ").append(this.toIndentedString(this.commissionable)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    proximityCode: ").append(this.toIndentedString(this.proximityCode)).append("\n");
        sb.append("    sort: ").append(this.toIndentedString(this.sort)).append("\n");
        sb.append("    minAgeAppropriateCode: ").append(this.toIndentedString(this.minAgeAppropriateCode)).append("\n");
        sb.append("    bookable: ").append(this.toIndentedString(this.bookable)).append("\n");
        sb.append("    active: ").append(this.toIndentedString(this.active)).append("\n");
        sb.append("    disabilityFeatures: ").append(this.toIndentedString(this.disabilityFeatures)).append("\n");
        sb.append("    securityFeatures: ").append(this.toIndentedString(this.securityFeatures)).append("\n");
        sb.append("    socials: ").append(this.toIndentedString(this.socials)).append("\n");
        sb.append("    pricePoint: ").append(this.toIndentedString((Object)this.pricePoint)).append("\n");
        sb.append("    recognitionList: ").append(this.toIndentedString(this.recognitionList)).append("\n");
        sb.append("    applicableStart: ").append(this.toIndentedString(this.applicableStart)).append("\n");
        sb.append("    applicableEnd: ").append(this.toIndentedString(this.applicableEnd)).append("\n");
        sb.append("    reservationRequiredInd: ").append(this.toIndentedString(this.reservationRequiredInd)).append("\n");
        sb.append("    opens: ").append(this.toIndentedString(this.opens)).append("\n");
        sb.append("    closes: ").append(this.toIndentedString(this.closes)).append("\n");
        sb.append("    daysOfWeek: ").append(this.toIndentedString(this.daysOfWeek)).append("\n");
        sb.append("    maxSeatingCapacity: ").append(this.toIndentedString(this.maxSeatingCapacity)).append("\n");
        sb.append("    maxSingleParty: ").append(this.toIndentedString(this.maxSingleParty)).append("\n");
        sb.append("    offerBreakfast: ").append(this.toIndentedString(this.offerBreakfast)).append("\n");
        sb.append("    offerLunch: ").append(this.toIndentedString(this.offerLunch)).append("\n");
        sb.append("    offerDinner: ").append(this.toIndentedString(this.offerDinner)).append("\n");
        sb.append("    offerBrunch: ").append(this.toIndentedString(this.offerBrunch)).append("\n");
        sb.append("    amenities: ").append(this.toIndentedString(this.amenities)).append("\n");
        sb.append("    infoCodes: ").append(this.toIndentedString(this.infoCodes)).append("\n");
        sb.append("    cuisineCodes: ").append(this.toIndentedString(this.cuisineCodes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum PricePointEnum {
        HALF(String.valueOf("HALF")),
        ONE(String.valueOf("ONE")),
        ONE_HALF(String.valueOf("ONE_HALF")),
        TWO(String.valueOf("TWO")),
        TWO_HALF(String.valueOf("TWO_HALF")),
        THREE(String.valueOf("THREE")),
        THREE_HALF(String.valueOf("THREE_HALF")),
        FOUR(String.valueOf("FOUR")),
        FOUR_HALF(String.valueOf("FOUR_HALF")),
        FIVE(String.valueOf("FIVE"));

        private String value;

        private PricePointEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PricePointEnum fromValue(String value) {
            for (PricePointEnum b : PricePointEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum LifestyleTypeEnum {
        LIFESTYLE_HEALTH_FITNESS(String.valueOf("LIFESTYLE_HEALTH_FITNESS")),
        LIFESTYLE_RELAX(String.valueOf("LIFESTYLE_RELAX")),
        LIFESTYLE_ADULT_ONLY(String.valueOf("LIFESTYLE_ADULT_ONLY")),
        LIFESTYLE_ADVENTURE(String.valueOf("LIFESTYLE_ADVENTURE")),
        LIFESTYLE_BUSINESS(String.valueOf("LIFESTYLE_BUSINESS")),
        LIFESTYLE_LGBT(String.valueOf("LIFESTYLE_LGBT")),
        LIFESTYLE_SINGLE_PARENT(String.valueOf("LIFESTYLE_SINGLE_PARENT")),
        LIFESTYLE_SOLO_FEMALE(String.valueOf("LIFESTYLE_SOLO_FEMALE")),
        LIFESTYLE_BEAUTY(String.valueOf("LIFESTYLE_BEAUTY")),
        LIFESTYLE_FOODIE(String.valueOf("LIFESTYLE_FOODIE")),
        LIFESTYLE_FAMILY(String.valueOf("LIFESTYLE_FAMILY")),
        LIFESTYLE_ROMANCE(String.valueOf("LIFESTYLE_ROMANCE")),
        LIFESTYLE_COUPLE(String.valueOf("LIFESTYLE_COUPLE")),
        LIFESTYLE_SOLO(String.valueOf("LIFESTYLE_SOLO")),
        LIFESTYLE_BACKPACKER(String.valueOf("LIFESTYLE_BACKPACKER")),
        LIFESTYLE_SHOPPING(String.valueOf("LIFESTYLE_SHOPPING")),
        LIFESTYLE_SPORTS(String.valueOf("LIFESTYLE_SPORTS")),
        LIFESTYLE_MOUNTAIN(String.valueOf("LIFESTYLE_MOUNTAIN")),
        LIFESTYLE_BEACH(String.valueOf("LIFESTYLE_BEACH")),
        LIFESTYLE_CITY(String.valueOf("LIFESTYLE_CITY")),
        LIFESTYLE_COUNTRY(String.valueOf("LIFESTYLE_COUNTRY")),
        LIFESTYLE_CULTURE(String.valueOf("LIFESTYLE_CULTURE")),
        LIFESTYLE_ECO(String.valueOf("LIFESTYLE_ECO"));

        private String value;

        private LifestyleTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static LifestyleTypeEnum fromValue(String value) {
            for (LifestyleTypeEnum b : LifestyleTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

