/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.inventory.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import travel.wink.sdk.inventory.model.SimpleDescriptionNonAuthenticatedEntity;

@JsonPropertyOrder(value={"identifier", "ownerIdentifier", "name", "customizationIdentifier", "descriptions", "keywords", "status", "inventoryStatus", "inventoryType", "channelInventoryType", "supplierIdentifier", "channelInventoryIdentifier", "multimediaIdentifiers", "animate", "animateDelay", "sort", "displayType"})
@JsonTypeName(value="SellableItemLightweight_Non_Authenticated_Entity")
public class SellableItemLightweightNonAuthenticatedEntity {
    public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
    @Nonnull
    private UUID identifier;
    public static final String JSON_PROPERTY_OWNER_IDENTIFIER = "ownerIdentifier";
    @Nonnull
    private UUID ownerIdentifier;
    public static final String JSON_PROPERTY_NAME = "name";
    @Nonnull
    private String name;
    public static final String JSON_PROPERTY_CUSTOMIZATION_IDENTIFIER = "customizationIdentifier";
    @Nonnull
    private UUID customizationIdentifier;
    public static final String JSON_PROPERTY_DESCRIPTIONS = "descriptions";
    @Nonnull
    private List<@Valid SimpleDescriptionNonAuthenticatedEntity> descriptions = new ArrayList<SimpleDescriptionNonAuthenticatedEntity>();
    public static final String JSON_PROPERTY_KEYWORDS = "keywords";
    @Nonnull
    private List<Object> keywords = new ArrayList<Object>();
    public static final String JSON_PROPERTY_STATUS = "status";
    @Nonnull
    private StatusEnum status = StatusEnum.ACTIVE;
    public static final String JSON_PROPERTY_INVENTORY_STATUS = "inventoryStatus";
    @Nonnull
    private InventoryStatusEnum inventoryStatus;
    public static final String JSON_PROPERTY_INVENTORY_TYPE = "inventoryType";
    @Nonnull
    private InventoryTypeEnum inventoryType;
    public static final String JSON_PROPERTY_CHANNEL_INVENTORY_TYPE = "channelInventoryType";
    @Nonnull
    private ChannelInventoryTypeEnum channelInventoryType;
    public static final String JSON_PROPERTY_SUPPLIER_IDENTIFIER = "supplierIdentifier";
    @Nonnull
    private UUID supplierIdentifier;
    public static final String JSON_PROPERTY_CHANNEL_INVENTORY_IDENTIFIER = "channelInventoryIdentifier";
    @Nonnull
    private UUID channelInventoryIdentifier;
    public static final String JSON_PROPERTY_MULTIMEDIA_IDENTIFIERS = "multimediaIdentifiers";
    @Nonnull
    private List<String> multimediaIdentifiers = new ArrayList<String>();
    public static final String JSON_PROPERTY_ANIMATE = "animate";
    @Nullable
    private Boolean animate = false;
    public static final String JSON_PROPERTY_ANIMATE_DELAY = "animateDelay";
    @Nullable
    private Integer animateDelay;
    public static final String JSON_PROPERTY_SORT = "sort";
    @Nullable
    private SortEnum sort;
    public static final String JSON_PROPERTY_DISPLAY_TYPE = "displayType";
    @Nonnull
    private DisplayTypeEnum displayType = DisplayTypeEnum.NATIVE;

    public SellableItemLightweightNonAuthenticatedEntity identifier(@Nonnull UUID identifier) {
        this.identifier = identifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @Size(min=1)
    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @Size(min=1) UUID getIdentifier() {
        return this.identifier;
    }

    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setIdentifier(@Nonnull UUID identifier) {
        this.identifier = identifier;
    }

    public SellableItemLightweightNonAuthenticatedEntity ownerIdentifier(@Nonnull UUID ownerIdentifier) {
        this.ownerIdentifier = ownerIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @Size(min=1)
    @JsonProperty(value="ownerIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @Size(min=1) UUID getOwnerIdentifier() {
        return this.ownerIdentifier;
    }

    @JsonProperty(value="ownerIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setOwnerIdentifier(@Nonnull UUID ownerIdentifier) {
        this.ownerIdentifier = ownerIdentifier;
    }

    public SellableItemLightweightNonAuthenticatedEntity name(@Nonnull String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @NotNull
    @Size(min=1)
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=1) String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(@Nonnull String name) {
        this.name = name;
    }

    public SellableItemLightweightNonAuthenticatedEntity customizationIdentifier(@Nonnull UUID customizationIdentifier) {
        this.customizationIdentifier = customizationIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @Size(min=1)
    @JsonProperty(value="customizationIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @Size(min=1) UUID getCustomizationIdentifier() {
        return this.customizationIdentifier;
    }

    @JsonProperty(value="customizationIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCustomizationIdentifier(@Nonnull UUID customizationIdentifier) {
        this.customizationIdentifier = customizationIdentifier;
    }

    public SellableItemLightweightNonAuthenticatedEntity descriptions(@Nonnull List<@Valid SimpleDescriptionNonAuthenticatedEntity> descriptions) {
        this.descriptions = descriptions;
        return this;
    }

    public SellableItemLightweightNonAuthenticatedEntity addDescriptionsItem(SimpleDescriptionNonAuthenticatedEntity descriptionsItem) {
        if (this.descriptions == null) {
            this.descriptions = new ArrayList<SimpleDescriptionNonAuthenticatedEntity>();
        }
        this.descriptions.add(descriptionsItem);
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @Size(min=1, max=0x7FFFFFFF)
    @JsonProperty(value="descriptions")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @Size(min=1, max=0x7FFFFFFF) List<@Valid SimpleDescriptionNonAuthenticatedEntity> getDescriptions() {
        return this.descriptions;
    }

    @JsonProperty(value="descriptions")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDescriptions(@Nonnull List<@Valid SimpleDescriptionNonAuthenticatedEntity> descriptions) {
        this.descriptions = descriptions;
    }

    public SellableItemLightweightNonAuthenticatedEntity keywords(@Nonnull List<Object> keywords) {
        this.keywords = keywords;
        return this;
    }

    public SellableItemLightweightNonAuthenticatedEntity addKeywordsItem(Object keywordsItem) {
        if (this.keywords == null) {
            this.keywords = new ArrayList<Object>();
        }
        this.keywords.add(keywordsItem);
        return this;
    }

    @Nonnull
    @NotNull
    @Size(min=1, max=0x7FFFFFFF)
    @JsonProperty(value="keywords")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=1, max=0x7FFFFFFF) List<Object> getKeywords() {
        return this.keywords;
    }

    @JsonProperty(value="keywords")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setKeywords(@Nonnull List<Object> keywords) {
        this.keywords = keywords;
    }

    public SellableItemLightweightNonAuthenticatedEntity status(@Nonnull StatusEnum status) {
        this.status = status;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public StatusEnum getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setStatus(@Nonnull StatusEnum status) {
        this.status = status;
    }

    public SellableItemLightweightNonAuthenticatedEntity inventoryStatus(@Nonnull InventoryStatusEnum inventoryStatus) {
        this.inventoryStatus = inventoryStatus;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="inventoryStatus")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public InventoryStatusEnum getInventoryStatus() {
        return this.inventoryStatus;
    }

    @JsonProperty(value="inventoryStatus")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setInventoryStatus(@Nonnull InventoryStatusEnum inventoryStatus) {
        this.inventoryStatus = inventoryStatus;
    }

    public SellableItemLightweightNonAuthenticatedEntity inventoryType(@Nonnull InventoryTypeEnum inventoryType) {
        this.inventoryType = inventoryType;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="inventoryType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public InventoryTypeEnum getInventoryType() {
        return this.inventoryType;
    }

    @JsonProperty(value="inventoryType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setInventoryType(@Nonnull InventoryTypeEnum inventoryType) {
        this.inventoryType = inventoryType;
    }

    public SellableItemLightweightNonAuthenticatedEntity channelInventoryType(@Nonnull ChannelInventoryTypeEnum channelInventoryType) {
        this.channelInventoryType = channelInventoryType;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="channelInventoryType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ChannelInventoryTypeEnum getChannelInventoryType() {
        return this.channelInventoryType;
    }

    @JsonProperty(value="channelInventoryType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setChannelInventoryType(@Nonnull ChannelInventoryTypeEnum channelInventoryType) {
        this.channelInventoryType = channelInventoryType;
    }

    public SellableItemLightweightNonAuthenticatedEntity supplierIdentifier(@Nonnull UUID supplierIdentifier) {
        this.supplierIdentifier = supplierIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @Size(min=1)
    @JsonProperty(value="supplierIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @Size(min=1) UUID getSupplierIdentifier() {
        return this.supplierIdentifier;
    }

    @JsonProperty(value="supplierIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSupplierIdentifier(@Nonnull UUID supplierIdentifier) {
        this.supplierIdentifier = supplierIdentifier;
    }

    public SellableItemLightweightNonAuthenticatedEntity channelInventoryIdentifier(@Nonnull UUID channelInventoryIdentifier) {
        this.channelInventoryIdentifier = channelInventoryIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @Size(min=1)
    @JsonProperty(value="channelInventoryIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @Size(min=1) UUID getChannelInventoryIdentifier() {
        return this.channelInventoryIdentifier;
    }

    @JsonProperty(value="channelInventoryIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setChannelInventoryIdentifier(@Nonnull UUID channelInventoryIdentifier) {
        this.channelInventoryIdentifier = channelInventoryIdentifier;
    }

    public SellableItemLightweightNonAuthenticatedEntity multimediaIdentifiers(@Nonnull List<String> multimediaIdentifiers) {
        this.multimediaIdentifiers = multimediaIdentifiers;
        return this;
    }

    public SellableItemLightweightNonAuthenticatedEntity addMultimediaIdentifiersItem(String multimediaIdentifiersItem) {
        if (this.multimediaIdentifiers == null) {
            this.multimediaIdentifiers = new ArrayList<String>();
        }
        this.multimediaIdentifiers.add(multimediaIdentifiersItem);
        return this;
    }

    @Nonnull
    @NotNull
    @Size(min=1, max=0x7FFFFFFF)
    @JsonProperty(value="multimediaIdentifiers")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=1, max=0x7FFFFFFF) List<String> getMultimediaIdentifiers() {
        return this.multimediaIdentifiers;
    }

    @JsonProperty(value="multimediaIdentifiers")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setMultimediaIdentifiers(@Nonnull List<String> multimediaIdentifiers) {
        this.multimediaIdentifiers = multimediaIdentifiers;
    }

    public SellableItemLightweightNonAuthenticatedEntity animate(@Nullable Boolean animate) {
        this.animate = animate;
        return this;
    }

    @Nullable
    @JsonProperty(value="animate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getAnimate() {
        return this.animate;
    }

    @JsonProperty(value="animate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAnimate(@Nullable Boolean animate) {
        this.animate = animate;
    }

    public SellableItemLightweightNonAuthenticatedEntity animateDelay(@Nullable Integer animateDelay) {
        this.animateDelay = animateDelay;
        return this;
    }

    @Nullable
    @JsonProperty(value="animateDelay")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getAnimateDelay() {
        return this.animateDelay;
    }

    @JsonProperty(value="animateDelay")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAnimateDelay(@Nullable Integer animateDelay) {
        this.animateDelay = animateDelay;
    }

    public SellableItemLightweightNonAuthenticatedEntity sort(@Nullable SortEnum sort) {
        this.sort = sort;
        return this;
    }

    @Nullable
    @JsonProperty(value="sort")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SortEnum getSort() {
        return this.sort;
    }

    @JsonProperty(value="sort")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSort(@Nullable SortEnum sort) {
        this.sort = sort;
    }

    public SellableItemLightweightNonAuthenticatedEntity displayType(@Nonnull DisplayTypeEnum displayType) {
        this.displayType = displayType;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="displayType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public DisplayTypeEnum getDisplayType() {
        return this.displayType;
    }

    @JsonProperty(value="displayType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDisplayType(@Nonnull DisplayTypeEnum displayType) {
        this.displayType = displayType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SellableItemLightweightNonAuthenticatedEntity sellableItemLightweightNonAuthenticatedEntity = (SellableItemLightweightNonAuthenticatedEntity)o;
        return Objects.equals(this.identifier, sellableItemLightweightNonAuthenticatedEntity.identifier) && Objects.equals(this.ownerIdentifier, sellableItemLightweightNonAuthenticatedEntity.ownerIdentifier) && Objects.equals(this.name, sellableItemLightweightNonAuthenticatedEntity.name) && Objects.equals(this.customizationIdentifier, sellableItemLightweightNonAuthenticatedEntity.customizationIdentifier) && Objects.equals(this.descriptions, sellableItemLightweightNonAuthenticatedEntity.descriptions) && Objects.equals(this.keywords, sellableItemLightweightNonAuthenticatedEntity.keywords) && Objects.equals((Object)this.status, (Object)sellableItemLightweightNonAuthenticatedEntity.status) && Objects.equals((Object)this.inventoryStatus, (Object)sellableItemLightweightNonAuthenticatedEntity.inventoryStatus) && Objects.equals((Object)this.inventoryType, (Object)sellableItemLightweightNonAuthenticatedEntity.inventoryType) && Objects.equals((Object)this.channelInventoryType, (Object)sellableItemLightweightNonAuthenticatedEntity.channelInventoryType) && Objects.equals(this.supplierIdentifier, sellableItemLightweightNonAuthenticatedEntity.supplierIdentifier) && Objects.equals(this.channelInventoryIdentifier, sellableItemLightweightNonAuthenticatedEntity.channelInventoryIdentifier) && Objects.equals(this.multimediaIdentifiers, sellableItemLightweightNonAuthenticatedEntity.multimediaIdentifiers) && Objects.equals(this.animate, sellableItemLightweightNonAuthenticatedEntity.animate) && Objects.equals(this.animateDelay, sellableItemLightweightNonAuthenticatedEntity.animateDelay) && Objects.equals((Object)this.sort, (Object)sellableItemLightweightNonAuthenticatedEntity.sort) && Objects.equals((Object)this.displayType, (Object)sellableItemLightweightNonAuthenticatedEntity.displayType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.identifier, this.ownerIdentifier, this.name, this.customizationIdentifier, this.descriptions, this.keywords, this.status, this.inventoryStatus, this.inventoryType, this.channelInventoryType, this.supplierIdentifier, this.channelInventoryIdentifier, this.multimediaIdentifiers, this.animate, this.animateDelay, this.sort, this.displayType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SellableItemLightweightNonAuthenticatedEntity {\n");
        sb.append("    identifier: ").append(this.toIndentedString(this.identifier)).append("\n");
        sb.append("    ownerIdentifier: ").append(this.toIndentedString(this.ownerIdentifier)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    customizationIdentifier: ").append(this.toIndentedString(this.customizationIdentifier)).append("\n");
        sb.append("    descriptions: ").append(this.toIndentedString(this.descriptions)).append("\n");
        sb.append("    keywords: ").append(this.toIndentedString(this.keywords)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    inventoryStatus: ").append(this.toIndentedString((Object)this.inventoryStatus)).append("\n");
        sb.append("    inventoryType: ").append(this.toIndentedString((Object)this.inventoryType)).append("\n");
        sb.append("    channelInventoryType: ").append(this.toIndentedString((Object)this.channelInventoryType)).append("\n");
        sb.append("    supplierIdentifier: ").append(this.toIndentedString(this.supplierIdentifier)).append("\n");
        sb.append("    channelInventoryIdentifier: ").append(this.toIndentedString(this.channelInventoryIdentifier)).append("\n");
        sb.append("    multimediaIdentifiers: ").append(this.toIndentedString(this.multimediaIdentifiers)).append("\n");
        sb.append("    animate: ").append(this.toIndentedString(this.animate)).append("\n");
        sb.append("    animateDelay: ").append(this.toIndentedString(this.animateDelay)).append("\n");
        sb.append("    sort: ").append(this.toIndentedString((Object)this.sort)).append("\n");
        sb.append("    displayType: ").append(this.toIndentedString((Object)this.displayType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatusEnum {
        ACTIVE(String.valueOf("ACTIVE")),
        INACTIVE(String.valueOf("INACTIVE")),
        REMOVED(String.valueOf("REMOVED"));

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum DisplayTypeEnum {
        NATIVE(String.valueOf("NATIVE")),
        HOTEL(String.valueOf("HOTEL")),
        ROOM(String.valueOf("ROOM"));

        private String value;

        private DisplayTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static DisplayTypeEnum fromValue(String value) {
            for (DisplayTypeEnum b : DisplayTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum InventoryStatusEnum {
        ACTIVE(String.valueOf("ACTIVE")),
        INACTIVE(String.valueOf("INACTIVE")),
        REMOVED(String.valueOf("REMOVED"));

        private String value;

        private InventoryStatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static InventoryStatusEnum fromValue(String value) {
            for (InventoryStatusEnum b : InventoryStatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum InventoryTypeEnum {
        HOTEL(String.valueOf("HOTEL")),
        GUEST_ROOM(String.valueOf("GUEST_ROOM")),
        MEETING_ROOM(String.valueOf("MEETING_ROOM")),
        RESTAURANT(String.valueOf("RESTAURANT")),
        SPA(String.valueOf("SPA")),
        ADD_ON(String.valueOf("ADD_ON")),
        ATTRACTION(String.valueOf("ATTRACTION")),
        ACTIVITY(String.valueOf("ACTIVITY")),
        PLACE(String.valueOf("PLACE"));

        private String value;

        private InventoryTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static InventoryTypeEnum fromValue(String value) {
            for (InventoryTypeEnum b : InventoryTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum ChannelInventoryTypeEnum {
        GUEST_ROOM(String.valueOf("GUEST_ROOM")),
        ADD_ON(String.valueOf("ADD_ON")),
        MEETING_ROOM(String.valueOf("MEETING_ROOM")),
        RESTAURANT(String.valueOf("RESTAURANT")),
        SPA(String.valueOf("SPA")),
        ATTRACTION(String.valueOf("ATTRACTION")),
        PLACE(String.valueOf("PLACE")),
        ACTIVITY(String.valueOf("ACTIVITY"));

        private String value;

        private ChannelInventoryTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ChannelInventoryTypeEnum fromValue(String value) {
            for (ChannelInventoryTypeEnum b : ChannelInventoryTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum SortEnum {
        MEMBER(String.valueOf("MEMBER")),
        PRICE_LOW_TO_HIGH(String.valueOf("PRICE_LOW_TO_HIGH")),
        PRICE_HIGH_TO_LOW(String.valueOf("PRICE_HIGH_TO_LOW")),
        PRICE(String.valueOf("PRICE")),
        POPULARITY(String.valueOf("POPULARITY")),
        ECO(String.valueOf("ECO")),
        EXPERIENCE(String.valueOf("EXPERIENCE")),
        PERK(String.valueOf("PERK")),
        LOYALTY(String.valueOf("LOYALTY")),
        ADD_ON(String.valueOf("ADD_ON"));

        private String value;

        private SortEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static SortEnum fromValue(String value) {
            for (SortEnum b : SortEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

