/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.inventory.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import travel.wink.sdk.inventory.model.SimpleDescriptionNonAuthenticatedEntity;

@JsonPropertyOrder(value={"identifier", "sellerIdentifier", "name", "customizationIdentifier", "descriptions", "keywords", "status", "listType", "listIdentifier", "animate", "animateDelay", "sort", "displayType"})
@JsonTypeName(value="SellableListLightweight_Non_Authenticated_Entity")
public class SellableListLightweightNonAuthenticatedEntity {
    public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
    @Nonnull
    private UUID identifier;
    public static final String JSON_PROPERTY_SELLER_IDENTIFIER = "sellerIdentifier";
    @Nonnull
    private UUID sellerIdentifier;
    public static final String JSON_PROPERTY_NAME = "name";
    @Nonnull
    private String name;
    public static final String JSON_PROPERTY_CUSTOMIZATION_IDENTIFIER = "customizationIdentifier";
    @Nonnull
    private UUID customizationIdentifier;
    public static final String JSON_PROPERTY_DESCRIPTIONS = "descriptions";
    @Nonnull
    private List<@Valid SimpleDescriptionNonAuthenticatedEntity> descriptions = new ArrayList<SimpleDescriptionNonAuthenticatedEntity>();
    public static final String JSON_PROPERTY_KEYWORDS = "keywords";
    @Nonnull
    private List<String> keywords = new ArrayList<String>();
    public static final String JSON_PROPERTY_STATUS = "status";
    @Nonnull
    private StatusEnum status = StatusEnum.ACTIVE;
    public static final String JSON_PROPERTY_LIST_TYPE = "listType";
    @Nonnull
    private ListTypeEnum listType;
    public static final String JSON_PROPERTY_LIST_IDENTIFIER = "listIdentifier";
    @Nonnull
    private UUID listIdentifier;
    public static final String JSON_PROPERTY_ANIMATE = "animate";
    @Nullable
    private Boolean animate = false;
    public static final String JSON_PROPERTY_ANIMATE_DELAY = "animateDelay";
    @Nullable
    private Integer animateDelay = -1;
    public static final String JSON_PROPERTY_SORT = "sort";
    @Nullable
    private SortEnum sort;
    public static final String JSON_PROPERTY_DISPLAY_TYPE = "displayType";
    @Nonnull
    private DisplayTypeEnum displayType = DisplayTypeEnum.NATIVE;

    public SellableListLightweightNonAuthenticatedEntity identifier(@Nonnull UUID identifier) {
        this.identifier = identifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @Size(min=1)
    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @Size(min=1) UUID getIdentifier() {
        return this.identifier;
    }

    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setIdentifier(@Nonnull UUID identifier) {
        this.identifier = identifier;
    }

    public SellableListLightweightNonAuthenticatedEntity sellerIdentifier(@Nonnull UUID sellerIdentifier) {
        this.sellerIdentifier = sellerIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @Size(min=1)
    @JsonProperty(value="sellerIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @Size(min=1) UUID getSellerIdentifier() {
        return this.sellerIdentifier;
    }

    @JsonProperty(value="sellerIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSellerIdentifier(@Nonnull UUID sellerIdentifier) {
        this.sellerIdentifier = sellerIdentifier;
    }

    public SellableListLightweightNonAuthenticatedEntity name(@Nonnull String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @NotNull
    @Size(min=1)
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=1) String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(@Nonnull String name) {
        this.name = name;
    }

    public SellableListLightweightNonAuthenticatedEntity customizationIdentifier(@Nonnull UUID customizationIdentifier) {
        this.customizationIdentifier = customizationIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @Size(min=1)
    @JsonProperty(value="customizationIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @Size(min=1) UUID getCustomizationIdentifier() {
        return this.customizationIdentifier;
    }

    @JsonProperty(value="customizationIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCustomizationIdentifier(@Nonnull UUID customizationIdentifier) {
        this.customizationIdentifier = customizationIdentifier;
    }

    public SellableListLightweightNonAuthenticatedEntity descriptions(@Nonnull List<@Valid SimpleDescriptionNonAuthenticatedEntity> descriptions) {
        this.descriptions = descriptions;
        return this;
    }

    public SellableListLightweightNonAuthenticatedEntity addDescriptionsItem(SimpleDescriptionNonAuthenticatedEntity descriptionsItem) {
        if (this.descriptions == null) {
            this.descriptions = new ArrayList<SimpleDescriptionNonAuthenticatedEntity>();
        }
        this.descriptions.add(descriptionsItem);
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @Size(min=1, max=0x7FFFFFFF)
    @JsonProperty(value="descriptions")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @Size(min=1, max=0x7FFFFFFF) List<@Valid SimpleDescriptionNonAuthenticatedEntity> getDescriptions() {
        return this.descriptions;
    }

    @JsonProperty(value="descriptions")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDescriptions(@Nonnull List<@Valid SimpleDescriptionNonAuthenticatedEntity> descriptions) {
        this.descriptions = descriptions;
    }

    public SellableListLightweightNonAuthenticatedEntity keywords(@Nonnull List<String> keywords) {
        this.keywords = keywords;
        return this;
    }

    public SellableListLightweightNonAuthenticatedEntity addKeywordsItem(String keywordsItem) {
        if (this.keywords == null) {
            this.keywords = new ArrayList<String>();
        }
        this.keywords.add(keywordsItem);
        return this;
    }

    @Nonnull
    @NotNull
    @Size(min=1, max=0x7FFFFFFF)
    @JsonProperty(value="keywords")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=1, max=0x7FFFFFFF) List<String> getKeywords() {
        return this.keywords;
    }

    @JsonProperty(value="keywords")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setKeywords(@Nonnull List<String> keywords) {
        this.keywords = keywords;
    }

    public SellableListLightweightNonAuthenticatedEntity status(@Nonnull StatusEnum status) {
        this.status = status;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public StatusEnum getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setStatus(@Nonnull StatusEnum status) {
        this.status = status;
    }

    public SellableListLightweightNonAuthenticatedEntity listType(@Nonnull ListTypeEnum listType) {
        this.listType = listType;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="listType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ListTypeEnum getListType() {
        return this.listType;
    }

    @JsonProperty(value="listType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setListType(@Nonnull ListTypeEnum listType) {
        this.listType = listType;
    }

    public SellableListLightweightNonAuthenticatedEntity listIdentifier(@Nonnull UUID listIdentifier) {
        this.listIdentifier = listIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @Size(min=1)
    @JsonProperty(value="listIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @Size(min=1) UUID getListIdentifier() {
        return this.listIdentifier;
    }

    @JsonProperty(value="listIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setListIdentifier(@Nonnull UUID listIdentifier) {
        this.listIdentifier = listIdentifier;
    }

    public SellableListLightweightNonAuthenticatedEntity animate(@Nullable Boolean animate) {
        this.animate = animate;
        return this;
    }

    @Nullable
    @JsonProperty(value="animate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getAnimate() {
        return this.animate;
    }

    @JsonProperty(value="animate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAnimate(@Nullable Boolean animate) {
        this.animate = animate;
    }

    public SellableListLightweightNonAuthenticatedEntity animateDelay(@Nullable Integer animateDelay) {
        this.animateDelay = animateDelay;
        return this;
    }

    @Nullable
    @JsonProperty(value="animateDelay")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getAnimateDelay() {
        return this.animateDelay;
    }

    @JsonProperty(value="animateDelay")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAnimateDelay(@Nullable Integer animateDelay) {
        this.animateDelay = animateDelay;
    }

    public SellableListLightweightNonAuthenticatedEntity sort(@Nullable SortEnum sort) {
        this.sort = sort;
        return this;
    }

    @Nullable
    @JsonProperty(value="sort")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SortEnum getSort() {
        return this.sort;
    }

    @JsonProperty(value="sort")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSort(@Nullable SortEnum sort) {
        this.sort = sort;
    }

    public SellableListLightweightNonAuthenticatedEntity displayType(@Nonnull DisplayTypeEnum displayType) {
        this.displayType = displayType;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="displayType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public DisplayTypeEnum getDisplayType() {
        return this.displayType;
    }

    @JsonProperty(value="displayType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDisplayType(@Nonnull DisplayTypeEnum displayType) {
        this.displayType = displayType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SellableListLightweightNonAuthenticatedEntity sellableListLightweightNonAuthenticatedEntity = (SellableListLightweightNonAuthenticatedEntity)o;
        return Objects.equals(this.identifier, sellableListLightweightNonAuthenticatedEntity.identifier) && Objects.equals(this.sellerIdentifier, sellableListLightweightNonAuthenticatedEntity.sellerIdentifier) && Objects.equals(this.name, sellableListLightweightNonAuthenticatedEntity.name) && Objects.equals(this.customizationIdentifier, sellableListLightweightNonAuthenticatedEntity.customizationIdentifier) && Objects.equals(this.descriptions, sellableListLightweightNonAuthenticatedEntity.descriptions) && Objects.equals(this.keywords, sellableListLightweightNonAuthenticatedEntity.keywords) && Objects.equals((Object)this.status, (Object)sellableListLightweightNonAuthenticatedEntity.status) && Objects.equals((Object)this.listType, (Object)sellableListLightweightNonAuthenticatedEntity.listType) && Objects.equals(this.listIdentifier, sellableListLightweightNonAuthenticatedEntity.listIdentifier) && Objects.equals(this.animate, sellableListLightweightNonAuthenticatedEntity.animate) && Objects.equals(this.animateDelay, sellableListLightweightNonAuthenticatedEntity.animateDelay) && Objects.equals((Object)this.sort, (Object)sellableListLightweightNonAuthenticatedEntity.sort) && Objects.equals((Object)this.displayType, (Object)sellableListLightweightNonAuthenticatedEntity.displayType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.identifier, this.sellerIdentifier, this.name, this.customizationIdentifier, this.descriptions, this.keywords, this.status, this.listType, this.listIdentifier, this.animate, this.animateDelay, this.sort, this.displayType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SellableListLightweightNonAuthenticatedEntity {\n");
        sb.append("    identifier: ").append(this.toIndentedString(this.identifier)).append("\n");
        sb.append("    sellerIdentifier: ").append(this.toIndentedString(this.sellerIdentifier)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    customizationIdentifier: ").append(this.toIndentedString(this.customizationIdentifier)).append("\n");
        sb.append("    descriptions: ").append(this.toIndentedString(this.descriptions)).append("\n");
        sb.append("    keywords: ").append(this.toIndentedString(this.keywords)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    listType: ").append(this.toIndentedString((Object)this.listType)).append("\n");
        sb.append("    listIdentifier: ").append(this.toIndentedString(this.listIdentifier)).append("\n");
        sb.append("    animate: ").append(this.toIndentedString(this.animate)).append("\n");
        sb.append("    animateDelay: ").append(this.toIndentedString(this.animateDelay)).append("\n");
        sb.append("    sort: ").append(this.toIndentedString((Object)this.sort)).append("\n");
        sb.append("    displayType: ").append(this.toIndentedString((Object)this.displayType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatusEnum {
        ACTIVE(String.valueOf("ACTIVE")),
        INACTIVE(String.valueOf("INACTIVE")),
        REMOVED(String.valueOf("REMOVED"));

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum DisplayTypeEnum {
        NATIVE(String.valueOf("NATIVE")),
        HOTEL(String.valueOf("HOTEL")),
        ROOM(String.valueOf("ROOM"));

        private String value;

        private DisplayTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static DisplayTypeEnum fromValue(String value) {
            for (DisplayTypeEnum b : DisplayTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum ListTypeEnum {
        SINGLE(String.valueOf("SINGLE")),
        LIST(String.valueOf("LIST")),
        SEARCH(String.valueOf("SEARCH"));

        private String value;

        private ListTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ListTypeEnum fromValue(String value) {
            for (ListTypeEnum b : ListTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum SortEnum {
        MEMBER(String.valueOf("MEMBER")),
        PRICE_LOW_TO_HIGH(String.valueOf("PRICE_LOW_TO_HIGH")),
        PRICE_HIGH_TO_LOW(String.valueOf("PRICE_HIGH_TO_LOW")),
        PRICE(String.valueOf("PRICE")),
        POPULARITY(String.valueOf("POPULARITY")),
        ECO(String.valueOf("ECO")),
        EXPERIENCE(String.valueOf("EXPERIENCE")),
        PERK(String.valueOf("PERK")),
        LOYALTY(String.valueOf("LOYALTY")),
        ADD_ON(String.valueOf("ADD_ON"));

        private String value;

        private SortEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static SortEnum fromValue(String value) {
            for (SortEnum b : SortEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

