/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.inventory.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import travel.wink.sdk.inventory.model.UserSession;

@JsonPropertyOrder(value={"identifier", "engineConfigurationIdentifier", "userSession", "type"})
public class AggregateInventoryGridItemRequest {
    public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
    private UUID identifier;
    public static final String JSON_PROPERTY_ENGINE_CONFIGURATION_IDENTIFIER = "engineConfigurationIdentifier";
    private UUID engineConfigurationIdentifier;
    public static final String JSON_PROPERTY_USER_SESSION = "userSession";
    private UserSession userSession;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;

    public AggregateInventoryGridItemRequest identifier(UUID identifier) {
        this.identifier = identifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="Record identifier")
    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getIdentifier() {
        return this.identifier;
    }

    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setIdentifier(UUID identifier) {
        this.identifier = identifier;
    }

    public AggregateInventoryGridItemRequest engineConfigurationIdentifier(UUID engineConfigurationIdentifier) {
        this.engineConfigurationIdentifier = engineConfigurationIdentifier;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="The configuration identifier that was used during this call.")
    @JsonProperty(value="engineConfigurationIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UUID getEngineConfigurationIdentifier() {
        return this.engineConfigurationIdentifier;
    }

    @JsonProperty(value="engineConfigurationIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEngineConfigurationIdentifier(UUID engineConfigurationIdentifier) {
        this.engineConfigurationIdentifier = engineConfigurationIdentifier;
    }

    public AggregateInventoryGridItemRequest userSession(UserSession userSession) {
        this.userSession = userSession;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="userSession")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UserSession getUserSession() {
        return this.userSession;
    }

    @JsonProperty(value="userSession")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setUserSession(UserSession userSession) {
        this.userSession = userSession;
    }

    public AggregateInventoryGridItemRequest type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AggregateInventoryGridItemRequest aggregateInventoryGridItemRequest = (AggregateInventoryGridItemRequest)o;
        return Objects.equals(this.identifier, aggregateInventoryGridItemRequest.identifier) && Objects.equals(this.engineConfigurationIdentifier, aggregateInventoryGridItemRequest.engineConfigurationIdentifier) && Objects.equals(this.userSession, aggregateInventoryGridItemRequest.userSession) && Objects.equals((Object)this.type, (Object)aggregateInventoryGridItemRequest.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.identifier, this.engineConfigurationIdentifier, this.userSession, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AggregateInventoryGridItemRequest {\n");
        sb.append("    identifier: ").append(this.toIndentedString(this.identifier)).append("\n");
        sb.append("    engineConfigurationIdentifier: ").append(this.toIndentedString(this.engineConfigurationIdentifier)).append("\n");
        sb.append("    userSession: ").append(this.toIndentedString(this.userSession)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        HOTEL("HOTEL"),
        GUEST_ROOM("GUEST_ROOM"),
        MEETING_ROOM("MEETING_ROOM"),
        RESTAURANT("RESTAURANT"),
        SPA("SPA"),
        PACKAGE("PACKAGE"),
        ADD_ON("ADD_ON"),
        ATTRACTION("ATTRACTION"),
        ACTIVITY("ACTIVITY"),
        PLACE("PLACE");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

