/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.inventory.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.validation.Valid;
import travel.wink.sdk.inventory.model.GuestRoom;
import travel.wink.sdk.inventory.model.RoomConfigurationPrice;

@ApiModel(description="List of room types with price configurations based on the itinerary that was passed on the user session.")
@JsonPropertyOrder(value={"room", "priceConfigurations", "channelInventoryIdentifier", "bestPrice", "available"})
public class RoomTypeWithPriceConfigurations {
    public static final String JSON_PROPERTY_ROOM = "room";
    private GuestRoom room;
    public static final String JSON_PROPERTY_PRICE_CONFIGURATIONS = "priceConfigurations";
    private List<RoomConfigurationPrice> priceConfigurations = null;
    public static final String JSON_PROPERTY_CHANNEL_INVENTORY_IDENTIFIER = "channelInventoryIdentifier";
    private String channelInventoryIdentifier;
    public static final String JSON_PROPERTY_BEST_PRICE = "bestPrice";
    private RoomConfigurationPrice bestPrice;
    public static final String JSON_PROPERTY_AVAILABLE = "available";
    private Boolean available;

    public RoomTypeWithPriceConfigurations room(GuestRoom room) {
        this.room = room;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="room")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public GuestRoom getRoom() {
        return this.room;
    }

    @JsonProperty(value="room")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRoom(GuestRoom room) {
        this.room = room;
    }

    public RoomTypeWithPriceConfigurations priceConfigurations(List<RoomConfigurationPrice> priceConfigurations) {
        this.priceConfigurations = priceConfigurations;
        return this;
    }

    public RoomTypeWithPriceConfigurations addPriceConfigurationsItem(RoomConfigurationPrice priceConfigurationsItem) {
        if (this.priceConfigurations == null) {
            this.priceConfigurations = new ArrayList<RoomConfigurationPrice>();
        }
        this.priceConfigurations.add(priceConfigurationsItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="priceConfigurations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<RoomConfigurationPrice> getPriceConfigurations() {
        return this.priceConfigurations;
    }

    @JsonProperty(value="priceConfigurations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPriceConfigurations(List<RoomConfigurationPrice> priceConfigurations) {
        this.priceConfigurations = priceConfigurations;
    }

    public RoomTypeWithPriceConfigurations channelInventoryIdentifier(String channelInventoryIdentifier) {
        this.channelInventoryIdentifier = channelInventoryIdentifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="channelInventoryIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getChannelInventoryIdentifier() {
        return this.channelInventoryIdentifier;
    }

    @JsonProperty(value="channelInventoryIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setChannelInventoryIdentifier(String channelInventoryIdentifier) {
        this.channelInventoryIdentifier = channelInventoryIdentifier;
    }

    public RoomTypeWithPriceConfigurations bestPrice(RoomConfigurationPrice bestPrice) {
        this.bestPrice = bestPrice;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="bestPrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public RoomConfigurationPrice getBestPrice() {
        return this.bestPrice;
    }

    @JsonProperty(value="bestPrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBestPrice(RoomConfigurationPrice bestPrice) {
        this.bestPrice = bestPrice;
    }

    public RoomTypeWithPriceConfigurations available(Boolean available) {
        this.available = available;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="available")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getAvailable() {
        return this.available;
    }

    @JsonProperty(value="available")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAvailable(Boolean available) {
        this.available = available;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RoomTypeWithPriceConfigurations roomTypeWithPriceConfigurations = (RoomTypeWithPriceConfigurations)o;
        return Objects.equals(this.room, roomTypeWithPriceConfigurations.room) && Objects.equals(this.priceConfigurations, roomTypeWithPriceConfigurations.priceConfigurations) && Objects.equals(this.channelInventoryIdentifier, roomTypeWithPriceConfigurations.channelInventoryIdentifier) && Objects.equals(this.bestPrice, roomTypeWithPriceConfigurations.bestPrice) && Objects.equals(this.available, roomTypeWithPriceConfigurations.available);
    }

    public int hashCode() {
        return Objects.hash(this.room, this.priceConfigurations, this.channelInventoryIdentifier, this.bestPrice, this.available);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RoomTypeWithPriceConfigurations {\n");
        sb.append("    room: ").append(this.toIndentedString(this.room)).append("\n");
        sb.append("    priceConfigurations: ").append(this.toIndentedString(this.priceConfigurations)).append("\n");
        sb.append("    channelInventoryIdentifier: ").append(this.toIndentedString(this.channelInventoryIdentifier)).append("\n");
        sb.append("    bestPrice: ").append(this.toIndentedString(this.bestPrice)).append("\n");
        sb.append("    available: ").append(this.toIndentedString(this.available)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

