/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.inventory.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Social network")
@JsonPropertyOrder(value={"type", "location", "enabled"})
public class Social {
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_LOCATION = "location";
    private String location;
    public static final String JSON_PROPERTY_ENABLED = "enabled";
    private Boolean enabled;

    public Social type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Type of social network.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public Social location(String location) {
        this.location = location;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="URL or social network identifier to social network profile")
    @JsonProperty(value="location")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLocation() {
        return this.location;
    }

    @JsonProperty(value="location")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLocation(String location) {
        this.location = location;
    }

    public Social enabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether social network is available for use.")
    @JsonProperty(value="enabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getEnabled() {
        return this.enabled;
    }

    @JsonProperty(value="enabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Social social = (Social)o;
        return Objects.equals((Object)this.type, (Object)social.type) && Objects.equals(this.location, social.location) && Objects.equals(this.enabled, social.enabled);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.location, this.enabled});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Social {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    location: ").append(this.toIndentedString(this.location)).append("\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        FACEBOOK("FACEBOOK"),
        INSTAGRAM("INSTAGRAM"),
        SKYPE("SKYPE"),
        TRIP_ADVISOR("TRIP_ADVISOR"),
        TWITTER("TWITTER"),
        GOOGLE_PLUS("GOOGLE_PLUS"),
        WHATSAPP("WHATSAPP"),
        LINE("LINE"),
        WECHAT("WECHAT"),
        VIBER("VIBER"),
        SNAPCHAT("SNAPCHAT"),
        WEIBO("WEIBO"),
        RENREN("RENREN"),
        WEBSITE("WEBSITE"),
        QQ("QQ"),
        TIKTOK("TIKTOK");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

