/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.inventory.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import travel.wink.sdk.inventory.model.Moneys;
import travel.wink.sdk.inventory.model.SimpleDescription;

@ApiModel(description="What the guest is paying extra for")
@JsonPropertyOrder(value={"descriptions", "fixedAmount", "type", "valid"})
public class RatePlanLevelFee {
    public static final String JSON_PROPERTY_DESCRIPTIONS = "descriptions";
    private List<SimpleDescription> descriptions = new ArrayList<SimpleDescription>();
    public static final String JSON_PROPERTY_FIXED_AMOUNT = "fixedAmount";
    private Moneys fixedAmount;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_VALID = "valid";
    private Boolean valid;

    public RatePlanLevelFee descriptions(List<SimpleDescription> descriptions) {
        this.descriptions = descriptions;
        return this;
    }

    public RatePlanLevelFee addDescriptionsItem(SimpleDescription descriptionsItem) {
        this.descriptions.add(descriptionsItem);
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="List of localized descriptions for this fee.")
    @JsonProperty(value="descriptions")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<SimpleDescription> getDescriptions() {
        return this.descriptions;
    }

    @JsonProperty(value="descriptions")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDescriptions(List<SimpleDescription> descriptions) {
        this.descriptions = descriptions;
    }

    public RatePlanLevelFee fixedAmount(Moneys fixedAmount) {
        this.fixedAmount = fixedAmount;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="fixedAmount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Moneys getFixedAmount() {
        return this.fixedAmount;
    }

    @JsonProperty(value="fixedAmount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setFixedAmount(Moneys fixedAmount) {
        this.fixedAmount = fixedAmount;
    }

    public RatePlanLevelFee type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="PER_DAY", required=true, value="Rate plan fee type")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public RatePlanLevelFee valid(Boolean valid) {
        this.valid = valid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="valid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getValid() {
        return this.valid;
    }

    @JsonProperty(value="valid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setValid(Boolean valid) {
        this.valid = valid;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RatePlanLevelFee ratePlanLevelFee = (RatePlanLevelFee)o;
        return Objects.equals(this.descriptions, ratePlanLevelFee.descriptions) && Objects.equals(this.fixedAmount, ratePlanLevelFee.fixedAmount) && Objects.equals((Object)this.type, (Object)ratePlanLevelFee.type) && Objects.equals(this.valid, ratePlanLevelFee.valid);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.descriptions, this.fixedAmount, this.type, this.valid});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RatePlanLevelFee {\n");
        sb.append("    descriptions: ").append(this.toIndentedString(this.descriptions)).append("\n");
        sb.append("    fixedAmount: ").append(this.toIndentedString(this.fixedAmount)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    valid: ").append(this.toIndentedString(this.valid)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        DAY("PER_DAY"),
        STAY("PER_STAY"),
        PERSON_PER_DAY("PER_PERSON_PER_DAY"),
        PERSON_PER_STAY("PER_PERSON_PER_STAY");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

