/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.inventory.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.validation.constraints.NotNull;

@ApiModel(description="Multimedia that contains less information than Multimedia object")
@JsonPropertyOrder(value={"identifier", "type", "source", "sort", "angle", "width", "height"})
public class SimpleMultimedia {
    public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
    private String identifier;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_SOURCE = "source";
    private SourceEnum source = SourceEnum.CLOUDINARY;
    public static final String JSON_PROPERTY_SORT = "sort";
    private Integer sort = 999;
    public static final String JSON_PROPERTY_ANGLE = "angle";
    private String angle;
    public static final String JSON_PROPERTY_WIDTH = "width";
    private Integer width;
    public static final String JSON_PROPERTY_HEIGHT = "height";
    private Integer height;

    public SimpleMultimedia identifier(String identifier) {
        this.identifier = identifier;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="cloudinary-image-1", required=true, value="Use this identifier to communicate with Cloudinary.")
    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getIdentifier() {
        return this.identifier;
    }

    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public SimpleMultimedia type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="IMAGE", required=true, value="Whether Cloudinary media is a VIDEO or IMAGE.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public SimpleMultimedia source(SourceEnum source) {
        this.source = source;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="CLOUDINARY", required=true, value="Currently ONLY using Cloudinary to store all image / video assets.")
    @JsonProperty(value="source")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public SourceEnum getSource() {
        return this.source;
    }

    @JsonProperty(value="source")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSource(SourceEnum source) {
        this.source = source;
    }

    public SimpleMultimedia sort(Integer sort) {
        this.sort = sort;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="10", required=true, value="Sort allows you to control how you want to sort this record in a list of media records.")
    @JsonProperty(value="sort")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Integer getSort() {
        return this.sort;
    }

    @JsonProperty(value="sort")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSort(Integer sort) {
        this.sort = sort;
    }

    public SimpleMultimedia angle(String angle) {
        this.angle = angle;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="-90", required=true, value="Media angle")
    @JsonProperty(value="angle")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getAngle() {
        return this.angle;
    }

    @JsonProperty(value="angle")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAngle(String angle) {
        this.angle = angle;
    }

    public SimpleMultimedia width(Integer width) {
        this.width = width;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="2560", required=true, value="Media width in pixels.")
    @JsonProperty(value="width")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Integer getWidth() {
        return this.width;
    }

    @JsonProperty(value="width")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setWidth(Integer width) {
        this.width = width;
    }

    public SimpleMultimedia height(Integer height) {
        this.height = height;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="1600", required=true, value="Media height in pixels.")
    @JsonProperty(value="height")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Integer getHeight() {
        return this.height;
    }

    @JsonProperty(value="height")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setHeight(Integer height) {
        this.height = height;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleMultimedia simpleMultimedia = (SimpleMultimedia)o;
        return Objects.equals(this.identifier, simpleMultimedia.identifier) && Objects.equals((Object)this.type, (Object)simpleMultimedia.type) && Objects.equals((Object)this.source, (Object)simpleMultimedia.source) && Objects.equals(this.sort, simpleMultimedia.sort) && Objects.equals(this.angle, simpleMultimedia.angle) && Objects.equals(this.width, simpleMultimedia.width) && Objects.equals(this.height, simpleMultimedia.height);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.identifier, this.type, this.source, this.sort, this.angle, this.width, this.height});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SimpleMultimedia {\n");
        sb.append("    identifier: ").append(this.toIndentedString(this.identifier)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    source: ").append(this.toIndentedString((Object)this.source)).append("\n");
        sb.append("    sort: ").append(this.toIndentedString(this.sort)).append("\n");
        sb.append("    angle: ").append(this.toIndentedString(this.angle)).append("\n");
        sb.append("    width: ").append(this.toIndentedString(this.width)).append("\n");
        sb.append("    height: ").append(this.toIndentedString(this.height)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum SourceEnum {
        YOUTUBE("YOUTUBE"),
        CLOUDINARY("CLOUDINARY");

        private String value;

        private SourceEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static SourceEnum fromValue(String value) {
            for (SourceEnum b : SourceEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum TypeEnum {
        IMAGE("IMAGE"),
        VIDEO("VIDEO");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

