/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.inventory.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import travel.wink.sdk.inventory.model.MasterRateRate;
import travel.wink.sdk.inventory.model.RateExtraChildRateModifier;
import travel.wink.sdk.inventory.model.RateExtraPaxRateModifier;
import travel.wink.sdk.inventory.model.RateSingleOccupancyRateModifier;

@JsonPropertyOrder(value={"identifier", "hotelIdentifier", "rateSource", "rate", "master", "closedOnArrival", "closedOnDeparture", "date", "quantity", "minOccupancy", "maxOccupancy", "maxChildOccupancy", "maxAdultOccupancy", "includedAdultOccupancy", "includedChildOccupancy", "minLengthOfStay", "maxLengthOfStay", "singleOccupancyRateModifier", "extraPaxRateModifier", "extraChildRateModifier", "available", "masterRateIdentifier", "ratePlanIdentifier", "guestRoomIdentifier"})
public class Rate {
    public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
    private UUID identifier;
    public static final String JSON_PROPERTY_HOTEL_IDENTIFIER = "hotelIdentifier";
    private UUID hotelIdentifier;
    public static final String JSON_PROPERTY_RATE_SOURCE = "rateSource";
    private String rateSource = "TRAVELIKO";
    public static final String JSON_PROPERTY_RATE = "rate";
    private MasterRateRate rate;
    public static final String JSON_PROPERTY_MASTER = "master";
    private Boolean master = true;
    public static final String JSON_PROPERTY_CLOSED_ON_ARRIVAL = "closedOnArrival";
    private Boolean closedOnArrival = false;
    public static final String JSON_PROPERTY_CLOSED_ON_DEPARTURE = "closedOnDeparture";
    private Boolean closedOnDeparture = false;
    public static final String JSON_PROPERTY_DATE = "date";
    private LocalDate date;
    public static final String JSON_PROPERTY_QUANTITY = "quantity";
    private Integer quantity = 0;
    public static final String JSON_PROPERTY_MIN_OCCUPANCY = "minOccupancy";
    private Integer minOccupancy = 1;
    public static final String JSON_PROPERTY_MAX_OCCUPANCY = "maxOccupancy";
    private Integer maxOccupancy = 2;
    public static final String JSON_PROPERTY_MAX_CHILD_OCCUPANCY = "maxChildOccupancy";
    private Integer maxChildOccupancy = 0;
    public static final String JSON_PROPERTY_MAX_ADULT_OCCUPANCY = "maxAdultOccupancy";
    private Integer maxAdultOccupancy = 2;
    public static final String JSON_PROPERTY_INCLUDED_ADULT_OCCUPANCY = "includedAdultOccupancy";
    private Integer includedAdultOccupancy = 2;
    public static final String JSON_PROPERTY_INCLUDED_CHILD_OCCUPANCY = "includedChildOccupancy";
    private Integer includedChildOccupancy = 0;
    public static final String JSON_PROPERTY_MIN_LENGTH_OF_STAY = "minLengthOfStay";
    private Integer minLengthOfStay;
    public static final String JSON_PROPERTY_MAX_LENGTH_OF_STAY = "maxLengthOfStay";
    private Integer maxLengthOfStay;
    public static final String JSON_PROPERTY_SINGLE_OCCUPANCY_RATE_MODIFIER = "singleOccupancyRateModifier";
    private RateSingleOccupancyRateModifier singleOccupancyRateModifier;
    public static final String JSON_PROPERTY_EXTRA_PAX_RATE_MODIFIER = "extraPaxRateModifier";
    private RateExtraPaxRateModifier extraPaxRateModifier;
    public static final String JSON_PROPERTY_EXTRA_CHILD_RATE_MODIFIER = "extraChildRateModifier";
    private RateExtraChildRateModifier extraChildRateModifier;
    public static final String JSON_PROPERTY_AVAILABLE = "available";
    private Boolean available;
    public static final String JSON_PROPERTY_MASTER_RATE_IDENTIFIER = "masterRateIdentifier";
    private UUID masterRateIdentifier;
    public static final String JSON_PROPERTY_RATE_PLAN_IDENTIFIER = "ratePlanIdentifier";
    private UUID ratePlanIdentifier;
    public static final String JSON_PROPERTY_GUEST_ROOM_IDENTIFIER = "guestRoomIdentifier";
    private UUID guestRoomIdentifier;

    public Rate identifier(UUID identifier) {
        this.identifier = identifier;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Unique record identifier.")
    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UUID getIdentifier() {
        return this.identifier;
    }

    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIdentifier(UUID identifier) {
        this.identifier = identifier;
    }

    public Rate hotelIdentifier(UUID hotelIdentifier) {
        this.hotelIdentifier = hotelIdentifier;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Owner of daily rate.")
    @JsonProperty(value="hotelIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UUID getHotelIdentifier() {
        return this.hotelIdentifier;
    }

    @JsonProperty(value="hotelIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHotelIdentifier(UUID hotelIdentifier) {
        this.hotelIdentifier = hotelIdentifier;
    }

    public Rate rateSource(String rateSource) {
        this.rateSource = rateSource;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="TRAVELIKO", required=true, value="Indicate where this rate originated from. Leave as TRAVELIKO unless you are a channel manager and responsible for the property's rates externally of this payment.")
    @JsonProperty(value="rateSource")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getRateSource() {
        return this.rateSource;
    }

    @JsonProperty(value="rateSource")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRateSource(String rateSource) {
        this.rateSource = rateSource;
    }

    public Rate rate(MasterRateRate rate) {
        this.rate = rate;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="rate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MasterRateRate getRate() {
        return this.rate;
    }

    @JsonProperty(value="rate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRate(MasterRateRate rate) {
        this.rate = rate;
    }

    public Rate master(Boolean master) {
        this.master = master;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="true", required=true, value="This flag indicates whether this rate is available for this date.")
    @JsonProperty(value="master")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getMaster() {
        return this.master;
    }

    @JsonProperty(value="master")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setMaster(Boolean master) {
        this.master = master;
    }

    public Rate closedOnArrival(Boolean closedOnArrival) {
        this.closedOnArrival = closedOnArrival;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="false", required=true, value="This flag indicates whether a guest can arrive at the property on this date.")
    @JsonProperty(value="closedOnArrival")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getClosedOnArrival() {
        return this.closedOnArrival;
    }

    @JsonProperty(value="closedOnArrival")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setClosedOnArrival(Boolean closedOnArrival) {
        this.closedOnArrival = closedOnArrival;
    }

    public Rate closedOnDeparture(Boolean closedOnDeparture) {
        this.closedOnDeparture = closedOnDeparture;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="false", required=true, value="This flag indicates whether a guest can leave the property on this date.")
    @JsonProperty(value="closedOnDeparture")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getClosedOnDeparture() {
        return this.closedOnDeparture;
    }

    @JsonProperty(value="closedOnDeparture")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setClosedOnDeparture(Boolean closedOnDeparture) {
        this.closedOnDeparture = closedOnDeparture;
    }

    public Rate date(LocalDate date) {
        this.date = date;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(example="Mon Aug 24 07:00:00 ICT 2020", required=true, value="The date this rate is applicable for.")
    @JsonProperty(value="date")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public LocalDate getDate() {
        return this.date;
    }

    @JsonProperty(value="date")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDate(LocalDate date) {
        this.date = date;
    }

    public Rate quantity(Integer quantity) {
        this.quantity = quantity;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="9", required=true, value="Amount of rooms available for this date.")
    @JsonProperty(value="quantity")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Integer getQuantity() {
        return this.quantity;
    }

    @JsonProperty(value="quantity")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    public Rate minOccupancy(Integer minOccupancy) {
        this.minOccupancy = minOccupancy;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=1L)
    @ApiModelProperty(example="1", required=true, value="Minimum number of guests allowed in a room type.")
    @JsonProperty(value="minOccupancy")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=1L) Integer getMinOccupancy() {
        return this.minOccupancy;
    }

    @JsonProperty(value="minOccupancy")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setMinOccupancy(Integer minOccupancy) {
        this.minOccupancy = minOccupancy;
    }

    public Rate maxOccupancy(Integer maxOccupancy) {
        this.maxOccupancy = maxOccupancy;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=1L)
    @ApiModelProperty(example="2", required=true, value="Maximum number of guest allowed in a room type.")
    @JsonProperty(value="maxOccupancy")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=1L) Integer getMaxOccupancy() {
        return this.maxOccupancy;
    }

    @JsonProperty(value="maxOccupancy")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setMaxOccupancy(Integer maxOccupancy) {
        this.maxOccupancy = maxOccupancy;
    }

    public Rate maxChildOccupancy(Integer maxChildOccupancy) {
        this.maxChildOccupancy = maxChildOccupancy;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=0L)
    @ApiModelProperty(example="0", required=true, value="Maximum number of children allowed in a room type.")
    @JsonProperty(value="maxChildOccupancy")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=0L) Integer getMaxChildOccupancy() {
        return this.maxChildOccupancy;
    }

    @JsonProperty(value="maxChildOccupancy")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setMaxChildOccupancy(Integer maxChildOccupancy) {
        this.maxChildOccupancy = maxChildOccupancy;
    }

    public Rate maxAdultOccupancy(Integer maxAdultOccupancy) {
        this.maxAdultOccupancy = maxAdultOccupancy;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=1L)
    @ApiModelProperty(example="1", required=true, value="Maximum number of adults allowed in a room type.")
    @JsonProperty(value="maxAdultOccupancy")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=1L) Integer getMaxAdultOccupancy() {
        return this.maxAdultOccupancy;
    }

    @JsonProperty(value="maxAdultOccupancy")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setMaxAdultOccupancy(Integer maxAdultOccupancy) {
        this.maxAdultOccupancy = maxAdultOccupancy;
    }

    public Rate includedAdultOccupancy(Integer includedAdultOccupancy) {
        this.includedAdultOccupancy = includedAdultOccupancy;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=0L)
    @ApiModelProperty(example="2", required=true, value="The number of pax the room price was meant for")
    @JsonProperty(value="includedAdultOccupancy")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=0L) Integer getIncludedAdultOccupancy() {
        return this.includedAdultOccupancy;
    }

    @JsonProperty(value="includedAdultOccupancy")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setIncludedAdultOccupancy(Integer includedAdultOccupancy) {
        this.includedAdultOccupancy = includedAdultOccupancy;
    }

    public Rate includedChildOccupancy(Integer includedChildOccupancy) {
        this.includedChildOccupancy = includedChildOccupancy;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=0L)
    @ApiModelProperty(example="0", required=true, value="The number of children the room price was meant for")
    @JsonProperty(value="includedChildOccupancy")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=0L) Integer getIncludedChildOccupancy() {
        return this.includedChildOccupancy;
    }

    @JsonProperty(value="includedChildOccupancy")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setIncludedChildOccupancy(Integer includedChildOccupancy) {
        this.includedChildOccupancy = includedChildOccupancy;
    }

    public Rate minLengthOfStay(Integer minLengthOfStay) {
        this.minLengthOfStay = minLengthOfStay;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="4", value="Control the minimum length of stay at the day-level. This means that a guest arriving within this date range is required to stay at least these number of days in order to get this rate. Leave empty if you don't want to update this property.")
    @JsonProperty(value="minLengthOfStay")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getMinLengthOfStay() {
        return this.minLengthOfStay;
    }

    @JsonProperty(value="minLengthOfStay")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMinLengthOfStay(Integer minLengthOfStay) {
        this.minLengthOfStay = minLengthOfStay;
    }

    public Rate maxLengthOfStay(Integer maxLengthOfStay) {
        this.maxLengthOfStay = maxLengthOfStay;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="8", value="Control the maximum length of stay at the day-level. This means that a guest arriving within this date range is required to stay no longer than these number of days in order to get this rate. Leave empty if you don't want to update this property.")
    @JsonProperty(value="maxLengthOfStay")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getMaxLengthOfStay() {
        return this.maxLengthOfStay;
    }

    @JsonProperty(value="maxLengthOfStay")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMaxLengthOfStay(Integer maxLengthOfStay) {
        this.maxLengthOfStay = maxLengthOfStay;
    }

    public Rate singleOccupancyRateModifier(RateSingleOccupancyRateModifier singleOccupancyRateModifier) {
        this.singleOccupancyRateModifier = singleOccupancyRateModifier;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="singleOccupancyRateModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public RateSingleOccupancyRateModifier getSingleOccupancyRateModifier() {
        return this.singleOccupancyRateModifier;
    }

    @JsonProperty(value="singleOccupancyRateModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSingleOccupancyRateModifier(RateSingleOccupancyRateModifier singleOccupancyRateModifier) {
        this.singleOccupancyRateModifier = singleOccupancyRateModifier;
    }

    public Rate extraPaxRateModifier(RateExtraPaxRateModifier extraPaxRateModifier) {
        this.extraPaxRateModifier = extraPaxRateModifier;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="extraPaxRateModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public RateExtraPaxRateModifier getExtraPaxRateModifier() {
        return this.extraPaxRateModifier;
    }

    @JsonProperty(value="extraPaxRateModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExtraPaxRateModifier(RateExtraPaxRateModifier extraPaxRateModifier) {
        this.extraPaxRateModifier = extraPaxRateModifier;
    }

    public Rate extraChildRateModifier(RateExtraChildRateModifier extraChildRateModifier) {
        this.extraChildRateModifier = extraChildRateModifier;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="extraChildRateModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public RateExtraChildRateModifier getExtraChildRateModifier() {
        return this.extraChildRateModifier;
    }

    @JsonProperty(value="extraChildRateModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExtraChildRateModifier(RateExtraChildRateModifier extraChildRateModifier) {
        this.extraChildRateModifier = extraChildRateModifier;
    }

    public Rate available(Boolean available) {
        this.available = available;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Convenience data point that tells you if there is availability on this day. It tests that quantity is greater than 0, rate amount is valid and master flag is true.")
    @JsonProperty(value="available")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getAvailable() {
        return this.available;
    }

    @JsonProperty(value="available")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAvailable(Boolean available) {
        this.available = available;
    }

    public Rate masterRateIdentifier(UUID masterRateIdentifier) {
        this.masterRateIdentifier = masterRateIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="Master rate associated with this daily rate.")
    @JsonProperty(value="masterRateIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getMasterRateIdentifier() {
        return this.masterRateIdentifier;
    }

    @JsonProperty(value="masterRateIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setMasterRateIdentifier(UUID masterRateIdentifier) {
        this.masterRateIdentifier = masterRateIdentifier;
    }

    public Rate ratePlanIdentifier(UUID ratePlanIdentifier) {
        this.ratePlanIdentifier = ratePlanIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="Rate plan associated with this daily rate.")
    @JsonProperty(value="ratePlanIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getRatePlanIdentifier() {
        return this.ratePlanIdentifier;
    }

    @JsonProperty(value="ratePlanIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRatePlanIdentifier(UUID ratePlanIdentifier) {
        this.ratePlanIdentifier = ratePlanIdentifier;
    }

    public Rate guestRoomIdentifier(UUID guestRoomIdentifier) {
        this.guestRoomIdentifier = guestRoomIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="Guest room associated with this daily rate.")
    @JsonProperty(value="guestRoomIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getGuestRoomIdentifier() {
        return this.guestRoomIdentifier;
    }

    @JsonProperty(value="guestRoomIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setGuestRoomIdentifier(UUID guestRoomIdentifier) {
        this.guestRoomIdentifier = guestRoomIdentifier;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Rate rate = (Rate)o;
        return Objects.equals(this.identifier, rate.identifier) && Objects.equals(this.hotelIdentifier, rate.hotelIdentifier) && Objects.equals(this.rateSource, rate.rateSource) && Objects.equals(this.rate, rate.rate) && Objects.equals(this.master, rate.master) && Objects.equals(this.closedOnArrival, rate.closedOnArrival) && Objects.equals(this.closedOnDeparture, rate.closedOnDeparture) && Objects.equals(this.date, rate.date) && Objects.equals(this.quantity, rate.quantity) && Objects.equals(this.minOccupancy, rate.minOccupancy) && Objects.equals(this.maxOccupancy, rate.maxOccupancy) && Objects.equals(this.maxChildOccupancy, rate.maxChildOccupancy) && Objects.equals(this.maxAdultOccupancy, rate.maxAdultOccupancy) && Objects.equals(this.includedAdultOccupancy, rate.includedAdultOccupancy) && Objects.equals(this.includedChildOccupancy, rate.includedChildOccupancy) && Objects.equals(this.minLengthOfStay, rate.minLengthOfStay) && Objects.equals(this.maxLengthOfStay, rate.maxLengthOfStay) && Objects.equals(this.singleOccupancyRateModifier, rate.singleOccupancyRateModifier) && Objects.equals(this.extraPaxRateModifier, rate.extraPaxRateModifier) && Objects.equals(this.extraChildRateModifier, rate.extraChildRateModifier) && Objects.equals(this.available, rate.available) && Objects.equals(this.masterRateIdentifier, rate.masterRateIdentifier) && Objects.equals(this.ratePlanIdentifier, rate.ratePlanIdentifier) && Objects.equals(this.guestRoomIdentifier, rate.guestRoomIdentifier);
    }

    public int hashCode() {
        return Objects.hash(this.identifier, this.hotelIdentifier, this.rateSource, this.rate, this.master, this.closedOnArrival, this.closedOnDeparture, this.date, this.quantity, this.minOccupancy, this.maxOccupancy, this.maxChildOccupancy, this.maxAdultOccupancy, this.includedAdultOccupancy, this.includedChildOccupancy, this.minLengthOfStay, this.maxLengthOfStay, this.singleOccupancyRateModifier, this.extraPaxRateModifier, this.extraChildRateModifier, this.available, this.masterRateIdentifier, this.ratePlanIdentifier, this.guestRoomIdentifier);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Rate {\n");
        sb.append("    identifier: ").append(this.toIndentedString(this.identifier)).append("\n");
        sb.append("    hotelIdentifier: ").append(this.toIndentedString(this.hotelIdentifier)).append("\n");
        sb.append("    rateSource: ").append(this.toIndentedString(this.rateSource)).append("\n");
        sb.append("    rate: ").append(this.toIndentedString(this.rate)).append("\n");
        sb.append("    master: ").append(this.toIndentedString(this.master)).append("\n");
        sb.append("    closedOnArrival: ").append(this.toIndentedString(this.closedOnArrival)).append("\n");
        sb.append("    closedOnDeparture: ").append(this.toIndentedString(this.closedOnDeparture)).append("\n");
        sb.append("    date: ").append(this.toIndentedString(this.date)).append("\n");
        sb.append("    quantity: ").append(this.toIndentedString(this.quantity)).append("\n");
        sb.append("    minOccupancy: ").append(this.toIndentedString(this.minOccupancy)).append("\n");
        sb.append("    maxOccupancy: ").append(this.toIndentedString(this.maxOccupancy)).append("\n");
        sb.append("    maxChildOccupancy: ").append(this.toIndentedString(this.maxChildOccupancy)).append("\n");
        sb.append("    maxAdultOccupancy: ").append(this.toIndentedString(this.maxAdultOccupancy)).append("\n");
        sb.append("    includedAdultOccupancy: ").append(this.toIndentedString(this.includedAdultOccupancy)).append("\n");
        sb.append("    includedChildOccupancy: ").append(this.toIndentedString(this.includedChildOccupancy)).append("\n");
        sb.append("    minLengthOfStay: ").append(this.toIndentedString(this.minLengthOfStay)).append("\n");
        sb.append("    maxLengthOfStay: ").append(this.toIndentedString(this.maxLengthOfStay)).append("\n");
        sb.append("    singleOccupancyRateModifier: ").append(this.toIndentedString(this.singleOccupancyRateModifier)).append("\n");
        sb.append("    extraPaxRateModifier: ").append(this.toIndentedString(this.extraPaxRateModifier)).append("\n");
        sb.append("    extraChildRateModifier: ").append(this.toIndentedString(this.extraChildRateModifier)).append("\n");
        sb.append("    available: ").append(this.toIndentedString(this.available)).append("\n");
        sb.append("    masterRateIdentifier: ").append(this.toIndentedString(this.masterRateIdentifier)).append("\n");
        sb.append("    ratePlanIdentifier: ").append(this.toIndentedString(this.ratePlanIdentifier)).append("\n");
        sb.append("    guestRoomIdentifier: ").append(this.toIndentedString(this.guestRoomIdentifier)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

