/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.inventory.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import travel.wink.sdk.inventory.model.SimpleDescriptionConsumer;

@ApiModel(description="List of property videos")
@JsonPropertyOrder(value={"multimediaIdentifier", "identifier", "type", "source", "sort", "angle", "width", "height", "published", "category", "descriptions", "lifestyleType", "isLandscape"})
@JsonTypeName(value="AbstractSimpleMultimedia_Consumer")
public class AbstractSimpleMultimediaConsumer {
    public static final String JSON_PROPERTY_MULTIMEDIA_IDENTIFIER = "multimediaIdentifier";
    private UUID multimediaIdentifier;
    public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
    private String identifier;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_SOURCE = "source";
    private SourceEnum source = SourceEnum.CLOUDINARY;
    public static final String JSON_PROPERTY_SORT = "sort";
    private Integer sort = 999;
    public static final String JSON_PROPERTY_ANGLE = "angle";
    private String angle;
    public static final String JSON_PROPERTY_WIDTH = "width";
    private Integer width;
    public static final String JSON_PROPERTY_HEIGHT = "height";
    private Integer height;
    public static final String JSON_PROPERTY_PUBLISHED = "published";
    private Boolean published = false;
    public static final String JSON_PROPERTY_CATEGORY = "category";
    private String category;
    public static final String JSON_PROPERTY_DESCRIPTIONS = "descriptions";
    private List<SimpleDescriptionConsumer> descriptions = null;
    public static final String JSON_PROPERTY_LIFESTYLE_TYPE = "lifestyleType";
    private LifestyleTypeEnum lifestyleType;
    public static final String JSON_PROPERTY_IS_LANDSCAPE = "isLandscape";
    private Boolean isLandscape;

    public AbstractSimpleMultimediaConsumer multimediaIdentifier(UUID multimediaIdentifier) {
        this.multimediaIdentifier = multimediaIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="Document identifier")
    @JsonProperty(value="multimediaIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getMultimediaIdentifier() {
        return this.multimediaIdentifier;
    }

    @JsonProperty(value="multimediaIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setMultimediaIdentifier(UUID multimediaIdentifier) {
        this.multimediaIdentifier = multimediaIdentifier;
    }

    public AbstractSimpleMultimediaConsumer identifier(String identifier) {
        this.identifier = identifier;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="cloudinary-image-1", required=true, value="Use this identifier to communicate with Cloudinary.")
    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getIdentifier() {
        return this.identifier;
    }

    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public AbstractSimpleMultimediaConsumer type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="IMAGE", required=true, value="Whether Cloudinary media is a VIDEO or IMAGE.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public AbstractSimpleMultimediaConsumer source(SourceEnum source) {
        this.source = source;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="CLOUDINARY", required=true, value="Currently ONLY using Cloudinary to store all image / video assets.")
    @JsonProperty(value="source")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public SourceEnum getSource() {
        return this.source;
    }

    @JsonProperty(value="source")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSource(SourceEnum source) {
        this.source = source;
    }

    public AbstractSimpleMultimediaConsumer sort(Integer sort) {
        this.sort = sort;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="10", value="Sort allows you to control how you want to sort this record in a list of media records.")
    @JsonProperty(value="sort")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getSort() {
        return this.sort;
    }

    @JsonProperty(value="sort")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSort(Integer sort) {
        this.sort = sort;
    }

    public AbstractSimpleMultimediaConsumer angle(String angle) {
        this.angle = angle;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="-90", value="Media angle")
    @JsonProperty(value="angle")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAngle() {
        return this.angle;
    }

    @JsonProperty(value="angle")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAngle(String angle) {
        this.angle = angle;
    }

    public AbstractSimpleMultimediaConsumer width(Integer width) {
        this.width = width;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2560", value="Media width in pixels.")
    @JsonProperty(value="width")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getWidth() {
        return this.width;
    }

    @JsonProperty(value="width")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setWidth(Integer width) {
        this.width = width;
    }

    public AbstractSimpleMultimediaConsumer height(Integer height) {
        this.height = height;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="1600", value="Media height in pixels.")
    @JsonProperty(value="height")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getHeight() {
        return this.height;
    }

    @JsonProperty(value="height")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHeight(Integer height) {
        this.height = height;
    }

    public AbstractSimpleMultimediaConsumer published(Boolean published) {
        this.published = published;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="Instead of deleting the media, choose to un-publish it instead for later re-use. Could be you keep seasonal images of the property.")
    @JsonProperty(value="published")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getPublished() {
        return this.published;
    }

    @JsonProperty(value="published")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPublished(Boolean published) {
        this.published = published;
    }

    public AbstractSimpleMultimediaConsumer category(String category) {
        this.category = category;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="1", value="Supported OTA specification `PIC` code. See [OTA geoname data](#operation/showAvailableCodesForCategory)")
    @JsonProperty(value="category")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCategory() {
        return this.category;
    }

    @JsonProperty(value="category")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCategory(String category) {
        this.category = category;
    }

    public AbstractSimpleMultimediaConsumer descriptions(List<SimpleDescriptionConsumer> descriptions) {
        this.descriptions = descriptions;
        return this;
    }

    public AbstractSimpleMultimediaConsumer addDescriptionsItem(SimpleDescriptionConsumer descriptionsItem) {
        if (this.descriptions == null) {
            this.descriptions = new ArrayList<SimpleDescriptionConsumer>();
        }
        this.descriptions.add(descriptionsItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Localized media captions to give user some context about where this media was taken.")
    @JsonProperty(value="descriptions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SimpleDescriptionConsumer> getDescriptions() {
        return this.descriptions;
    }

    @JsonProperty(value="descriptions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescriptions(List<SimpleDescriptionConsumer> descriptions) {
        this.descriptions = descriptions;
    }

    public AbstractSimpleMultimediaConsumer lifestyleType(LifestyleTypeEnum lifestyleType) {
        this.lifestyleType = lifestyleType;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="LIFESTYLE_HEALTH_FITNESS", value="Associate this media with a specific lifestyle type. A user searching and filtering inventory based on lifestyles can be shown relevant media first.")
    @JsonProperty(value="lifestyleType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LifestyleTypeEnum getLifestyleType() {
        return this.lifestyleType;
    }

    @JsonProperty(value="lifestyleType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLifestyleType(LifestyleTypeEnum lifestyleType) {
        this.lifestyleType = lifestyleType;
    }

    public AbstractSimpleMultimediaConsumer isLandscape(Boolean isLandscape) {
        this.isLandscape = isLandscape;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="True if media width is greater or equal to height")
    @JsonProperty(value="isLandscape")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIsLandscape() {
        return this.isLandscape;
    }

    @JsonProperty(value="isLandscape")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIsLandscape(Boolean isLandscape) {
        this.isLandscape = isLandscape;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractSimpleMultimediaConsumer abstractSimpleMultimediaConsumer = (AbstractSimpleMultimediaConsumer)o;
        return Objects.equals(this.multimediaIdentifier, abstractSimpleMultimediaConsumer.multimediaIdentifier) && Objects.equals(this.identifier, abstractSimpleMultimediaConsumer.identifier) && Objects.equals((Object)this.type, (Object)abstractSimpleMultimediaConsumer.type) && Objects.equals((Object)this.source, (Object)abstractSimpleMultimediaConsumer.source) && Objects.equals(this.sort, abstractSimpleMultimediaConsumer.sort) && Objects.equals(this.angle, abstractSimpleMultimediaConsumer.angle) && Objects.equals(this.width, abstractSimpleMultimediaConsumer.width) && Objects.equals(this.height, abstractSimpleMultimediaConsumer.height) && Objects.equals(this.published, abstractSimpleMultimediaConsumer.published) && Objects.equals(this.category, abstractSimpleMultimediaConsumer.category) && Objects.equals(this.descriptions, abstractSimpleMultimediaConsumer.descriptions) && Objects.equals((Object)this.lifestyleType, (Object)abstractSimpleMultimediaConsumer.lifestyleType) && Objects.equals(this.isLandscape, abstractSimpleMultimediaConsumer.isLandscape);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.multimediaIdentifier, this.identifier, this.type, this.source, this.sort, this.angle, this.width, this.height, this.published, this.category, this.descriptions, this.lifestyleType, this.isLandscape});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AbstractSimpleMultimediaConsumer {\n");
        sb.append("    multimediaIdentifier: ").append(this.toIndentedString(this.multimediaIdentifier)).append("\n");
        sb.append("    identifier: ").append(this.toIndentedString(this.identifier)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    source: ").append(this.toIndentedString((Object)this.source)).append("\n");
        sb.append("    sort: ").append(this.toIndentedString(this.sort)).append("\n");
        sb.append("    angle: ").append(this.toIndentedString(this.angle)).append("\n");
        sb.append("    width: ").append(this.toIndentedString(this.width)).append("\n");
        sb.append("    height: ").append(this.toIndentedString(this.height)).append("\n");
        sb.append("    published: ").append(this.toIndentedString(this.published)).append("\n");
        sb.append("    category: ").append(this.toIndentedString(this.category)).append("\n");
        sb.append("    descriptions: ").append(this.toIndentedString(this.descriptions)).append("\n");
        sb.append("    lifestyleType: ").append(this.toIndentedString((Object)this.lifestyleType)).append("\n");
        sb.append("    isLandscape: ").append(this.toIndentedString(this.isLandscape)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum SourceEnum {
        YOUTUBE("YOUTUBE"),
        CLOUDINARY("CLOUDINARY");

        private String value;

        private SourceEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static SourceEnum fromValue(String value) {
            for (SourceEnum b : SourceEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum TypeEnum {
        IMAGE("IMAGE"),
        VIDEO("VIDEO");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum LifestyleTypeEnum {
        HEALTH_FITNESS("LIFESTYLE_HEALTH_FITNESS"),
        RELAX("LIFESTYLE_RELAX"),
        ADULT_ONLY("LIFESTYLE_ADULT_ONLY"),
        ADVENTURE("LIFESTYLE_ADVENTURE"),
        BUSINESS("LIFESTYLE_BUSINESS"),
        LGBT("LIFESTYLE_LGBT"),
        SINGLE_PARENT("LIFESTYLE_SINGLE_PARENT"),
        SOLO_FEMALE("LIFESTYLE_SOLO_FEMALE"),
        BEAUTY("LIFESTYLE_BEAUTY"),
        FOODIE("LIFESTYLE_FOODIE"),
        FAMILY("LIFESTYLE_FAMILY"),
        ROMANCE("LIFESTYLE_ROMANCE"),
        COUPLE("LIFESTYLE_COUPLE"),
        SOLO("LIFESTYLE_SOLO"),
        BACKPACKER("LIFESTYLE_BACKPACKER"),
        SHOPPING("LIFESTYLE_SHOPPING"),
        SPORTS("LIFESTYLE_SPORTS"),
        MOUNTAIN("LIFESTYLE_MOUNTAIN"),
        BEACH("LIFESTYLE_BEACH"),
        CITY("LIFESTYLE_CITY"),
        COUNTRY("LIFESTYLE_COUNTRY"),
        CULTURE("LIFESTYLE_CULTURE"),
        ECO("LIFESTYLE_ECO");

        private String value;

        private LifestyleTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static LifestyleTypeEnum fromValue(String value) {
            for (LifestyleTypeEnum b : LifestyleTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

