/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.inventory.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;

@JsonPropertyOrder(value={"category", "highScore", "totalScore", "aggregateScore"})
@JsonTypeName(value="AggregateGreendexScoreByCategory_Consumer")
public class AggregateGreendexScoreByCategoryConsumer {
    public static final String JSON_PROPERTY_CATEGORY = "category";
    private CategoryEnum category;
    public static final String JSON_PROPERTY_HIGH_SCORE = "highScore";
    private Integer highScore;
    public static final String JSON_PROPERTY_TOTAL_SCORE = "totalScore";
    private Integer totalScore;
    public static final String JSON_PROPERTY_AGGREGATE_SCORE = "aggregateScore";
    private Float aggregateScore;

    public AggregateGreendexScoreByCategoryConsumer category(CategoryEnum category) {
        this.category = category;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="GENERAL", value="Green Index category")
    @JsonProperty(value="category")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CategoryEnum getCategory() {
        return this.category;
    }

    @JsonProperty(value="category")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCategory(CategoryEnum category) {
        this.category = category;
    }

    public AggregateGreendexScoreByCategoryConsumer highScore(Integer highScore) {
        this.highScore = highScore;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="100", value="The highest possible score from all questions within this category")
    @JsonProperty(value="highScore")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getHighScore() {
        return this.highScore;
    }

    @JsonProperty(value="highScore")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHighScore(Integer highScore) {
        this.highScore = highScore;
    }

    public AggregateGreendexScoreByCategoryConsumer totalScore(Integer totalScore) {
        this.totalScore = totalScore;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="50", value="The total score from all questions answered within this category")
    @JsonProperty(value="totalScore")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getTotalScore() {
        return this.totalScore;
    }

    @JsonProperty(value="totalScore")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalScore(Integer totalScore) {
        this.totalScore = totalScore;
    }

    public AggregateGreendexScoreByCategoryConsumer aggregateScore(Float aggregateScore) {
        this.aggregateScore = aggregateScore;
        return this;
    }

    @Nullable
    @DecimalMin(value="0")
    @DecimalMax(value="1")
    @ApiModelProperty(value="Total score divided by high score within this category")
    @JsonProperty(value="aggregateScore")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public @DecimalMin(value="0") @DecimalMax(value="1") Float getAggregateScore() {
        return this.aggregateScore;
    }

    @JsonProperty(value="aggregateScore")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAggregateScore(Float aggregateScore) {
        this.aggregateScore = aggregateScore;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AggregateGreendexScoreByCategoryConsumer aggregateGreendexScoreByCategoryConsumer = (AggregateGreendexScoreByCategoryConsumer)o;
        return Objects.equals((Object)this.category, (Object)aggregateGreendexScoreByCategoryConsumer.category) && Objects.equals(this.highScore, aggregateGreendexScoreByCategoryConsumer.highScore) && Objects.equals(this.totalScore, aggregateGreendexScoreByCategoryConsumer.totalScore) && Objects.equals(this.aggregateScore, aggregateGreendexScoreByCategoryConsumer.aggregateScore);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.category, this.highScore, this.totalScore, this.aggregateScore});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AggregateGreendexScoreByCategoryConsumer {\n");
        sb.append("    category: ").append(this.toIndentedString((Object)this.category)).append("\n");
        sb.append("    highScore: ").append(this.toIndentedString(this.highScore)).append("\n");
        sb.append("    totalScore: ").append(this.toIndentedString(this.totalScore)).append("\n");
        sb.append("    aggregateScore: ").append(this.toIndentedString(this.aggregateScore)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum CategoryEnum {
        GENERAL("GENERAL"),
        ENERGY("ENERGY"),
        WATER("WATER"),
        PURCHASING("PURCHASING"),
        WASTE("WASTE"),
        SITE("SITE");

        private String value;

        private CategoryEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static CategoryEnum fromValue(String value) {
            for (CategoryEnum b : CategoryEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

