/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.inventory.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.validation.Valid;
import travel.wink.sdk.inventory.model.LocalizedTransactionalTravelInventoryConsumer;
import travel.wink.sdk.inventory.model.MeetingRoomConsumer;

@ApiModel(description="List of property meeting rooms on and off the premises.")
@JsonPropertyOrder(value={"channelInventoryIdentifier", "priceList", "commissionable", "commission", "meetingRoom"})
@JsonTypeName(value="MeetingRoomLocalizedInventory_Consumer")
public class MeetingRoomLocalizedInventoryConsumer {
    public static final String JSON_PROPERTY_CHANNEL_INVENTORY_IDENTIFIER = "channelInventoryIdentifier";
    private UUID channelInventoryIdentifier;
    public static final String JSON_PROPERTY_PRICE_LIST = "priceList";
    private List<LocalizedTransactionalTravelInventoryConsumer> priceList = null;
    public static final String JSON_PROPERTY_COMMISSIONABLE = "commissionable";
    private Boolean commissionable;
    public static final String JSON_PROPERTY_COMMISSION = "commission";
    private Float commission;
    public static final String JSON_PROPERTY_MEETING_ROOM = "meetingRoom";
    private MeetingRoomConsumer meetingRoom;

    public MeetingRoomLocalizedInventoryConsumer channelInventoryIdentifier(UUID channelInventoryIdentifier) {
        this.channelInventoryIdentifier = channelInventoryIdentifier;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Channel inventory identifier referencing this record.")
    @JsonProperty(value="channelInventoryIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UUID getChannelInventoryIdentifier() {
        return this.channelInventoryIdentifier;
    }

    @JsonProperty(value="channelInventoryIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setChannelInventoryIdentifier(UUID channelInventoryIdentifier) {
        this.channelInventoryIdentifier = channelInventoryIdentifier;
    }

    public MeetingRoomLocalizedInventoryConsumer priceList(List<LocalizedTransactionalTravelInventoryConsumer> priceList) {
        this.priceList = priceList;
        return this;
    }

    public MeetingRoomLocalizedInventoryConsumer addPriceListItem(LocalizedTransactionalTravelInventoryConsumer priceListItem) {
        if (this.priceList == null) {
            this.priceList = new ArrayList<LocalizedTransactionalTravelInventoryConsumer>();
        }
        this.priceList.add(priceListItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="priceList")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<LocalizedTransactionalTravelInventoryConsumer> getPriceList() {
        return this.priceList;
    }

    @JsonProperty(value="priceList")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPriceList(List<LocalizedTransactionalTravelInventoryConsumer> priceList) {
        this.priceList = priceList;
    }

    public MeetingRoomLocalizedInventoryConsumer commissionable(Boolean commissionable) {
        this.commissionable = commissionable;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether this package is commissionable based on the incoming sales channel.")
    @JsonProperty(value="commissionable")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getCommissionable() {
        return this.commissionable;
    }

    @JsonProperty(value="commissionable")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCommissionable(Boolean commissionable) {
        this.commissionable = commissionable;
    }

    public MeetingRoomLocalizedInventoryConsumer commission(Float commission) {
        this.commission = commission;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="0.1", value="The commission percentage.")
    @JsonProperty(value="commission")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Float getCommission() {
        return this.commission;
    }

    @JsonProperty(value="commission")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCommission(Float commission) {
        this.commission = commission;
    }

    public MeetingRoomLocalizedInventoryConsumer meetingRoom(MeetingRoomConsumer meetingRoom) {
        this.meetingRoom = meetingRoom;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="meetingRoom")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MeetingRoomConsumer getMeetingRoom() {
        return this.meetingRoom;
    }

    @JsonProperty(value="meetingRoom")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMeetingRoom(MeetingRoomConsumer meetingRoom) {
        this.meetingRoom = meetingRoom;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MeetingRoomLocalizedInventoryConsumer meetingRoomLocalizedInventoryConsumer = (MeetingRoomLocalizedInventoryConsumer)o;
        return Objects.equals(this.channelInventoryIdentifier, meetingRoomLocalizedInventoryConsumer.channelInventoryIdentifier) && Objects.equals(this.priceList, meetingRoomLocalizedInventoryConsumer.priceList) && Objects.equals(this.commissionable, meetingRoomLocalizedInventoryConsumer.commissionable) && Objects.equals(this.commission, meetingRoomLocalizedInventoryConsumer.commission) && Objects.equals(this.meetingRoom, meetingRoomLocalizedInventoryConsumer.meetingRoom);
    }

    public int hashCode() {
        return Objects.hash(this.channelInventoryIdentifier, this.priceList, this.commissionable, this.commission, this.meetingRoom);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MeetingRoomLocalizedInventoryConsumer {\n");
        sb.append("    channelInventoryIdentifier: ").append(this.toIndentedString(this.channelInventoryIdentifier)).append("\n");
        sb.append("    priceList: ").append(this.toIndentedString(this.priceList)).append("\n");
        sb.append("    commissionable: ").append(this.toIndentedString(this.commissionable)).append("\n");
        sb.append("    commission: ").append(this.toIndentedString(this.commission)).append("\n");
        sb.append("    meetingRoom: ").append(this.toIndentedString(this.meetingRoom)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

