/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.inventory.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import travel.wink.sdk.inventory.model.GuestRoomConsumer;
import travel.wink.sdk.inventory.model.LocalizedTransactionalTravelInventoryConsumer;
import travel.wink.sdk.inventory.model.RoomConfigurationPriceConsumer;

@ApiModel(description="List of room types with price configurations based on the itinerary that was passed on the user session.")
@JsonPropertyOrder(value={"room", "priceConfigurations", "list", "channelInventoryIdentifier", "commissionable", "commission", "priceList", "bestPrice", "available"})
@JsonTypeName(value="RoomTypeWithPriceConfigurations_Consumer")
public class RoomTypeWithPriceConfigurationsConsumer {
    public static final String JSON_PROPERTY_ROOM = "room";
    private GuestRoomConsumer room;
    public static final String JSON_PROPERTY_PRICE_CONFIGURATIONS = "priceConfigurations";
    private List<RoomConfigurationPriceConsumer> priceConfigurations = new ArrayList<RoomConfigurationPriceConsumer>();
    public static final String JSON_PROPERTY_LIST = "list";
    private List<LocalizedTransactionalTravelInventoryConsumer> _list = null;
    public static final String JSON_PROPERTY_CHANNEL_INVENTORY_IDENTIFIER = "channelInventoryIdentifier";
    private UUID channelInventoryIdentifier;
    public static final String JSON_PROPERTY_COMMISSIONABLE = "commissionable";
    private Boolean commissionable;
    public static final String JSON_PROPERTY_COMMISSION = "commission";
    private Float commission;
    public static final String JSON_PROPERTY_PRICE_LIST = "priceList";
    private List<LocalizedTransactionalTravelInventoryConsumer> priceList = null;
    public static final String JSON_PROPERTY_BEST_PRICE = "bestPrice";
    private RoomConfigurationPriceConsumer bestPrice;
    public static final String JSON_PROPERTY_AVAILABLE = "available";
    private Boolean available;

    public RoomTypeWithPriceConfigurationsConsumer room(GuestRoomConsumer room) {
        this.room = room;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="room")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public GuestRoomConsumer getRoom() {
        return this.room;
    }

    @JsonProperty(value="room")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRoom(GuestRoomConsumer room) {
        this.room = room;
    }

    public RoomTypeWithPriceConfigurationsConsumer priceConfigurations(List<RoomConfigurationPriceConsumer> priceConfigurations) {
        this.priceConfigurations = priceConfigurations;
        return this;
    }

    public RoomTypeWithPriceConfigurationsConsumer addPriceConfigurationsItem(RoomConfigurationPriceConsumer priceConfigurationsItem) {
        this.priceConfigurations.add(priceConfigurationsItem);
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="priceConfigurations")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<RoomConfigurationPriceConsumer> getPriceConfigurations() {
        return this.priceConfigurations;
    }

    @JsonProperty(value="priceConfigurations")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPriceConfigurations(List<RoomConfigurationPriceConsumer> priceConfigurations) {
        this.priceConfigurations = priceConfigurations;
    }

    public RoomTypeWithPriceConfigurationsConsumer _list(List<LocalizedTransactionalTravelInventoryConsumer> _list) {
        this._list = _list;
        return this;
    }

    public RoomTypeWithPriceConfigurationsConsumer addListItem(LocalizedTransactionalTravelInventoryConsumer _listItem) {
        if (this._list == null) {
            this._list = new ArrayList<LocalizedTransactionalTravelInventoryConsumer>();
        }
        this._list.add(_listItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="list")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<LocalizedTransactionalTravelInventoryConsumer> getList() {
        return this._list;
    }

    @JsonProperty(value="list")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setList(List<LocalizedTransactionalTravelInventoryConsumer> _list) {
        this._list = _list;
    }

    public RoomTypeWithPriceConfigurationsConsumer channelInventoryIdentifier(UUID channelInventoryIdentifier) {
        this.channelInventoryIdentifier = channelInventoryIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="Channel inventory identifier referencing this record.")
    @JsonProperty(value="channelInventoryIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getChannelInventoryIdentifier() {
        return this.channelInventoryIdentifier;
    }

    @JsonProperty(value="channelInventoryIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setChannelInventoryIdentifier(UUID channelInventoryIdentifier) {
        this.channelInventoryIdentifier = channelInventoryIdentifier;
    }

    public RoomTypeWithPriceConfigurationsConsumer commissionable(Boolean commissionable) {
        this.commissionable = commissionable;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether this package is commissionable based on the incoming sales channel.")
    @JsonProperty(value="commissionable")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getCommissionable() {
        return this.commissionable;
    }

    @JsonProperty(value="commissionable")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCommissionable(Boolean commissionable) {
        this.commissionable = commissionable;
    }

    public RoomTypeWithPriceConfigurationsConsumer commission(Float commission) {
        this.commission = commission;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="0.1", value="The commission percentage.")
    @JsonProperty(value="commission")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Float getCommission() {
        return this.commission;
    }

    @JsonProperty(value="commission")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCommission(Float commission) {
        this.commission = commission;
    }

    public RoomTypeWithPriceConfigurationsConsumer priceList(List<LocalizedTransactionalTravelInventoryConsumer> priceList) {
        this.priceList = priceList;
        return this;
    }

    public RoomTypeWithPriceConfigurationsConsumer addPriceListItem(LocalizedTransactionalTravelInventoryConsumer priceListItem) {
        if (this.priceList == null) {
            this.priceList = new ArrayList<LocalizedTransactionalTravelInventoryConsumer>();
        }
        this.priceList.add(priceListItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="priceList")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<LocalizedTransactionalTravelInventoryConsumer> getPriceList() {
        return this.priceList;
    }

    @JsonProperty(value="priceList")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPriceList(List<LocalizedTransactionalTravelInventoryConsumer> priceList) {
        this.priceList = priceList;
    }

    public RoomTypeWithPriceConfigurationsConsumer bestPrice(RoomConfigurationPriceConsumer bestPrice) {
        this.bestPrice = bestPrice;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="bestPrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public RoomConfigurationPriceConsumer getBestPrice() {
        return this.bestPrice;
    }

    @JsonProperty(value="bestPrice")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBestPrice(RoomConfigurationPriceConsumer bestPrice) {
        this.bestPrice = bestPrice;
    }

    public RoomTypeWithPriceConfigurationsConsumer available(Boolean available) {
        this.available = available;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="available")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getAvailable() {
        return this.available;
    }

    @JsonProperty(value="available")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAvailable(Boolean available) {
        this.available = available;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RoomTypeWithPriceConfigurationsConsumer roomTypeWithPriceConfigurationsConsumer = (RoomTypeWithPriceConfigurationsConsumer)o;
        return Objects.equals(this.room, roomTypeWithPriceConfigurationsConsumer.room) && Objects.equals(this.priceConfigurations, roomTypeWithPriceConfigurationsConsumer.priceConfigurations) && Objects.equals(this._list, roomTypeWithPriceConfigurationsConsumer._list) && Objects.equals(this.channelInventoryIdentifier, roomTypeWithPriceConfigurationsConsumer.channelInventoryIdentifier) && Objects.equals(this.commissionable, roomTypeWithPriceConfigurationsConsumer.commissionable) && Objects.equals(this.commission, roomTypeWithPriceConfigurationsConsumer.commission) && Objects.equals(this.priceList, roomTypeWithPriceConfigurationsConsumer.priceList) && Objects.equals(this.bestPrice, roomTypeWithPriceConfigurationsConsumer.bestPrice) && Objects.equals(this.available, roomTypeWithPriceConfigurationsConsumer.available);
    }

    public int hashCode() {
        return Objects.hash(this.room, this.priceConfigurations, this._list, this.channelInventoryIdentifier, this.commissionable, this.commission, this.priceList, this.bestPrice, this.available);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RoomTypeWithPriceConfigurationsConsumer {\n");
        sb.append("    room: ").append(this.toIndentedString(this.room)).append("\n");
        sb.append("    priceConfigurations: ").append(this.toIndentedString(this.priceConfigurations)).append("\n");
        sb.append("    _list: ").append(this.toIndentedString(this._list)).append("\n");
        sb.append("    channelInventoryIdentifier: ").append(this.toIndentedString(this.channelInventoryIdentifier)).append("\n");
        sb.append("    commissionable: ").append(this.toIndentedString(this.commissionable)).append("\n");
        sb.append("    commission: ").append(this.toIndentedString(this.commission)).append("\n");
        sb.append("    priceList: ").append(this.toIndentedString(this.priceList)).append("\n");
        sb.append("    bestPrice: ").append(this.toIndentedString(this.bestPrice)).append("\n");
        sb.append("    available: ").append(this.toIndentedString(this.available)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

