/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.inventory.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import travel.wink.sdk.inventory.model.GuestRoomConsumer;
import travel.wink.sdk.inventory.model.HotelOnMapConsumer;
import travel.wink.sdk.inventory.model.QuoteConsumer;
import travel.wink.sdk.inventory.model.RoomTypeBestPriceConsumer;
import travel.wink.sdk.inventory.model.RoomTypeWithBestPriceConsumer;

@ApiModel(description="Property details along with the best room type price this property has to offer.")
@JsonPropertyOrder(value={"hotel", "price", "roomTypeList", "priceList", "potentialChannelDiscountPercent", "distance", "sourceToUserCurrencyQuote", "sourceToInternalCurrencyQuote", "available"})
@JsonTypeName(value="HotelWithBestPrice_Consumer")
public class HotelWithBestPriceConsumer {
    public static final String JSON_PROPERTY_HOTEL = "hotel";
    private HotelOnMapConsumer hotel;
    public static final String JSON_PROPERTY_PRICE = "price";
    private RoomTypeWithBestPriceConsumer price;
    public static final String JSON_PROPERTY_ROOM_TYPE_LIST = "roomTypeList";
    private List<GuestRoomConsumer> roomTypeList = new ArrayList<GuestRoomConsumer>();
    public static final String JSON_PROPERTY_PRICE_LIST = "priceList";
    private List<RoomTypeBestPriceConsumer> priceList = new ArrayList<RoomTypeBestPriceConsumer>();
    public static final String JSON_PROPERTY_POTENTIAL_CHANNEL_DISCOUNT_PERCENT = "potentialChannelDiscountPercent";
    private Float potentialChannelDiscountPercent;
    public static final String JSON_PROPERTY_DISTANCE = "distance";
    private Double distance;
    public static final String JSON_PROPERTY_SOURCE_TO_USER_CURRENCY_QUOTE = "sourceToUserCurrencyQuote";
    private QuoteConsumer sourceToUserCurrencyQuote;
    public static final String JSON_PROPERTY_SOURCE_TO_INTERNAL_CURRENCY_QUOTE = "sourceToInternalCurrencyQuote";
    private QuoteConsumer sourceToInternalCurrencyQuote;
    public static final String JSON_PROPERTY_AVAILABLE = "available";
    private Boolean available;

    public HotelWithBestPriceConsumer hotel(HotelOnMapConsumer hotel) {
        this.hotel = hotel;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="hotel")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public HotelOnMapConsumer getHotel() {
        return this.hotel;
    }

    @JsonProperty(value="hotel")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setHotel(HotelOnMapConsumer hotel) {
        this.hotel = hotel;
    }

    public HotelWithBestPriceConsumer price(RoomTypeWithBestPriceConsumer price) {
        this.price = price;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="price")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public RoomTypeWithBestPriceConsumer getPrice() {
        return this.price;
    }

    @JsonProperty(value="price")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPrice(RoomTypeWithBestPriceConsumer price) {
        this.price = price;
    }

    public HotelWithBestPriceConsumer roomTypeList(List<GuestRoomConsumer> roomTypeList) {
        this.roomTypeList = roomTypeList;
        return this;
    }

    public HotelWithBestPriceConsumer addRoomTypeListItem(GuestRoomConsumer roomTypeListItem) {
        this.roomTypeList.add(roomTypeListItem);
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="Unique property room types")
    @JsonProperty(value="roomTypeList")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<GuestRoomConsumer> getRoomTypeList() {
        return this.roomTypeList;
    }

    @JsonProperty(value="roomTypeList")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRoomTypeList(List<GuestRoomConsumer> roomTypeList) {
        this.roomTypeList = roomTypeList;
    }

    public HotelWithBestPriceConsumer priceList(List<RoomTypeBestPriceConsumer> priceList) {
        this.priceList = priceList;
        return this;
    }

    public HotelWithBestPriceConsumer addPriceListItem(RoomTypeBestPriceConsumer priceListItem) {
        this.priceList.add(priceListItem);
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="Best-priced room types")
    @JsonProperty(value="priceList")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<RoomTypeBestPriceConsumer> getPriceList() {
        return this.priceList;
    }

    @JsonProperty(value="priceList")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPriceList(List<RoomTypeBestPriceConsumer> priceList) {
        this.priceList = priceList;
    }

    public HotelWithBestPriceConsumer potentialChannelDiscountPercent(Float potentialChannelDiscountPercent) {
        this.potentialChannelDiscountPercent = potentialChannelDiscountPercent;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(required=true, value="The potential discount the user is entitled to if user is a member / authenticated.")
    @JsonProperty(value="potentialChannelDiscountPercent")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Float getPotentialChannelDiscountPercent() {
        return this.potentialChannelDiscountPercent;
    }

    @JsonProperty(value="potentialChannelDiscountPercent")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPotentialChannelDiscountPercent(Float potentialChannelDiscountPercent) {
        this.potentialChannelDiscountPercent = potentialChannelDiscountPercent;
    }

    public HotelWithBestPriceConsumer distance(Double distance) {
        this.distance = distance;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If property is within certain geo data result set, distance will be included here to signify the distance the property is from a specific geo-location.")
    @JsonProperty(value="distance")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getDistance() {
        return this.distance;
    }

    @JsonProperty(value="distance")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDistance(Double distance) {
        this.distance = distance;
    }

    public HotelWithBestPriceConsumer sourceToUserCurrencyQuote(QuoteConsumer sourceToUserCurrencyQuote) {
        this.sourceToUserCurrencyQuote = sourceToUserCurrencyQuote;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="sourceToUserCurrencyQuote")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public QuoteConsumer getSourceToUserCurrencyQuote() {
        return this.sourceToUserCurrencyQuote;
    }

    @JsonProperty(value="sourceToUserCurrencyQuote")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSourceToUserCurrencyQuote(QuoteConsumer sourceToUserCurrencyQuote) {
        this.sourceToUserCurrencyQuote = sourceToUserCurrencyQuote;
    }

    public HotelWithBestPriceConsumer sourceToInternalCurrencyQuote(QuoteConsumer sourceToInternalCurrencyQuote) {
        this.sourceToInternalCurrencyQuote = sourceToInternalCurrencyQuote;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="sourceToInternalCurrencyQuote")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public QuoteConsumer getSourceToInternalCurrencyQuote() {
        return this.sourceToInternalCurrencyQuote;
    }

    @JsonProperty(value="sourceToInternalCurrencyQuote")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSourceToInternalCurrencyQuote(QuoteConsumer sourceToInternalCurrencyQuote) {
        this.sourceToInternalCurrencyQuote = sourceToInternalCurrencyQuote;
    }

    public HotelWithBestPriceConsumer available(Boolean available) {
        this.available = available;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Flag to indicate whether this inventory is available or not. This data point is identifier to the available flag on the `price` child data point.")
    @JsonProperty(value="available")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getAvailable() {
        return this.available;
    }

    @JsonProperty(value="available")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAvailable(Boolean available) {
        this.available = available;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HotelWithBestPriceConsumer hotelWithBestPriceConsumer = (HotelWithBestPriceConsumer)o;
        return Objects.equals(this.hotel, hotelWithBestPriceConsumer.hotel) && Objects.equals(this.price, hotelWithBestPriceConsumer.price) && Objects.equals(this.roomTypeList, hotelWithBestPriceConsumer.roomTypeList) && Objects.equals(this.priceList, hotelWithBestPriceConsumer.priceList) && Objects.equals(this.potentialChannelDiscountPercent, hotelWithBestPriceConsumer.potentialChannelDiscountPercent) && Objects.equals(this.distance, hotelWithBestPriceConsumer.distance) && Objects.equals(this.sourceToUserCurrencyQuote, hotelWithBestPriceConsumer.sourceToUserCurrencyQuote) && Objects.equals(this.sourceToInternalCurrencyQuote, hotelWithBestPriceConsumer.sourceToInternalCurrencyQuote) && Objects.equals(this.available, hotelWithBestPriceConsumer.available);
    }

    public int hashCode() {
        return Objects.hash(this.hotel, this.price, this.roomTypeList, this.priceList, this.potentialChannelDiscountPercent, this.distance, this.sourceToUserCurrencyQuote, this.sourceToInternalCurrencyQuote, this.available);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class HotelWithBestPriceConsumer {\n");
        sb.append("    hotel: ").append(this.toIndentedString(this.hotel)).append("\n");
        sb.append("    price: ").append(this.toIndentedString(this.price)).append("\n");
        sb.append("    roomTypeList: ").append(this.toIndentedString(this.roomTypeList)).append("\n");
        sb.append("    priceList: ").append(this.toIndentedString(this.priceList)).append("\n");
        sb.append("    potentialChannelDiscountPercent: ").append(this.toIndentedString(this.potentialChannelDiscountPercent)).append("\n");
        sb.append("    distance: ").append(this.toIndentedString(this.distance)).append("\n");
        sb.append("    sourceToUserCurrencyQuote: ").append(this.toIndentedString(this.sourceToUserCurrencyQuote)).append("\n");
        sb.append("    sourceToInternalCurrencyQuote: ").append(this.toIndentedString(this.sourceToInternalCurrencyQuote)).append("\n");
        sb.append("    available: ").append(this.toIndentedString(this.available)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

