/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.inventory.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import travel.wink.sdk.inventory.model.SimpleDescriptionConsumer;

@ApiModel(description="Identifier inventory record")
@JsonPropertyOrder(value={"identifier", "sellerIdentifier", "sellerInventoryListName", "engineConfigurationIdentifier", "descriptions", "keywords", "status", "listType", "listIdentifier", "animate", "animateDelay", "sort", "displayType"})
@JsonTypeName(value="SellerInventoryList_Consumer")
public class SellerInventoryListConsumer {
    public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
    private UUID identifier;
    public static final String JSON_PROPERTY_SELLER_IDENTIFIER = "sellerIdentifier";
    private UUID sellerIdentifier;
    public static final String JSON_PROPERTY_SELLER_INVENTORY_LIST_NAME = "sellerInventoryListName";
    private String sellerInventoryListName;
    public static final String JSON_PROPERTY_ENGINE_CONFIGURATION_IDENTIFIER = "engineConfigurationIdentifier";
    private UUID engineConfigurationIdentifier;
    public static final String JSON_PROPERTY_DESCRIPTIONS = "descriptions";
    private List<SimpleDescriptionConsumer> descriptions = new ArrayList<SimpleDescriptionConsumer>();
    public static final String JSON_PROPERTY_KEYWORDS = "keywords";
    private List<String> keywords = new ArrayList<String>();
    public static final String JSON_PROPERTY_STATUS = "status";
    private StatusEnum status = StatusEnum.ACTIVE;
    public static final String JSON_PROPERTY_LIST_TYPE = "listType";
    private ListTypeEnum listType;
    public static final String JSON_PROPERTY_LIST_IDENTIFIER = "listIdentifier";
    private UUID listIdentifier;
    public static final String JSON_PROPERTY_ANIMATE = "animate";
    private Boolean animate = false;
    public static final String JSON_PROPERTY_ANIMATE_DELAY = "animateDelay";
    private Integer animateDelay = -1;
    public static final String JSON_PROPERTY_SORT = "sort";
    private SortEnum sort;
    public static final String JSON_PROPERTY_DISPLAY_TYPE = "displayType";
    private DisplayTypeEnum displayType = DisplayTypeEnum.NATIVE;

    public SellerInventoryListConsumer identifier(UUID identifier) {
        this.identifier = identifier;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Unique identifier")
    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UUID getIdentifier() {
        return this.identifier;
    }

    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIdentifier(UUID identifier) {
        this.identifier = identifier;
    }

    public SellerInventoryListConsumer sellerIdentifier(UUID sellerIdentifier) {
        this.sellerIdentifier = sellerIdentifier;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Company identifier")
    @JsonProperty(value="sellerIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UUID getSellerIdentifier() {
        return this.sellerIdentifier;
    }

    @JsonProperty(value="sellerIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSellerIdentifier(UUID sellerIdentifier) {
        this.sellerIdentifier = sellerIdentifier;
    }

    public SellerInventoryListConsumer sellerInventoryListName(String sellerInventoryListName) {
        this.sellerInventoryListName = sellerInventoryListName;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="My list", required=true, value="Descriptive name of this list for seller use only")
    @JsonProperty(value="sellerInventoryListName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getSellerInventoryListName() {
        return this.sellerInventoryListName;
    }

    @JsonProperty(value="sellerInventoryListName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSellerInventoryListName(String sellerInventoryListName) {
        this.sellerInventoryListName = sellerInventoryListName;
    }

    public SellerInventoryListConsumer engineConfigurationIdentifier(UUID engineConfigurationIdentifier) {
        this.engineConfigurationIdentifier = engineConfigurationIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="Customization identifier")
    @JsonProperty(value="engineConfigurationIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getEngineConfigurationIdentifier() {
        return this.engineConfigurationIdentifier;
    }

    @JsonProperty(value="engineConfigurationIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEngineConfigurationIdentifier(UUID engineConfigurationIdentifier) {
        this.engineConfigurationIdentifier = engineConfigurationIdentifier;
    }

    public SellerInventoryListConsumer descriptions(List<SimpleDescriptionConsumer> descriptions) {
        this.descriptions = descriptions;
        return this;
    }

    public SellerInventoryListConsumer addDescriptionsItem(SimpleDescriptionConsumer descriptionsItem) {
        this.descriptions.add(descriptionsItem);
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @Size(min=1, max=0x7FFFFFFF)
    @ApiModelProperty(required=true, value="Contains custom title and description of grid")
    @JsonProperty(value="descriptions")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Valid @Size(min=1, max=0x7FFFFFFF) List<SimpleDescriptionConsumer> getDescriptions() {
        return this.descriptions;
    }

    @JsonProperty(value="descriptions")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDescriptions(List<SimpleDescriptionConsumer> descriptions) {
        this.descriptions = descriptions;
    }

    public SellerInventoryListConsumer keywords(List<String> keywords) {
        this.keywords = keywords;
        return this;
    }

    public SellerInventoryListConsumer addKeywordsItem(String keywordsItem) {
        this.keywords.add(keywordsItem);
        return this;
    }

    @Nonnull
    @NotNull
    @Size(min=1, max=0x7FFFFFFF)
    @ApiModelProperty(example="[\"bali\"]", required=true, value="Keywords is meta data for the grid you created that can be used for SEO purposes.")
    @JsonProperty(value="keywords")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=1, max=0x7FFFFFFF) List<String> getKeywords() {
        return this.keywords;
    }

    @JsonProperty(value="keywords")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setKeywords(List<String> keywords) {
        this.keywords = keywords;
    }

    public SellerInventoryListConsumer status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="ACTIVE", required=true, value="Status")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public StatusEnum getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public SellerInventoryListConsumer listType(ListTypeEnum listType) {
        this.listType = listType;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="LIST", required=true, value="List type")
    @JsonProperty(value="listType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ListTypeEnum getListType() {
        return this.listType;
    }

    @JsonProperty(value="listType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setListType(ListTypeEnum listType) {
        this.listType = listType;
    }

    public SellerInventoryListConsumer listIdentifier(UUID listIdentifier) {
        this.listIdentifier = listIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="Depending on the `listType`, this is either the list / search / channel inventory identifier.")
    @JsonProperty(value="listIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getListIdentifier() {
        return this.listIdentifier;
    }

    @JsonProperty(value="listIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setListIdentifier(UUID listIdentifier) {
        this.listIdentifier = listIdentifier;
    }

    public SellerInventoryListConsumer animate(Boolean animate) {
        this.animate = animate;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Create an animated gif instead of a list of images")
    @JsonProperty(value="animate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getAnimate() {
        return this.animate;
    }

    @JsonProperty(value="animate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAnimate(Boolean animate) {
        this.animate = animate;
    }

    public SellerInventoryListConsumer animateDelay(Integer animateDelay) {
        this.animateDelay = animateDelay;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Controls animation delay in milliseconds. -1 is disabled")
    @JsonProperty(value="animateDelay")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getAnimateDelay() {
        return this.animateDelay;
    }

    @JsonProperty(value="animateDelay")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAnimateDelay(Integer animateDelay) {
        this.animateDelay = animateDelay;
    }

    public SellerInventoryListConsumer sort(SortEnum sort) {
        this.sort = sort;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="MEMBER", value="Determines which badge to show on the Web Component. Is also used to sort properties for search grids.")
    @JsonProperty(value="sort")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SortEnum getSort() {
        return this.sort;
    }

    @JsonProperty(value="sort")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSort(SortEnum sort) {
        this.sort = sort;
    }

    public SellerInventoryListConsumer displayType(DisplayTypeEnum displayType) {
        this.displayType = displayType;
        return this;
    }

    @Nonnull
    @NotNull
    @ApiModelProperty(example="NATIVE", required=true, value="Indicate which initial values to display first on the front-facing card")
    @JsonProperty(value="displayType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public DisplayTypeEnum getDisplayType() {
        return this.displayType;
    }

    @JsonProperty(value="displayType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDisplayType(DisplayTypeEnum displayType) {
        this.displayType = displayType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SellerInventoryListConsumer sellerInventoryListConsumer = (SellerInventoryListConsumer)o;
        return Objects.equals(this.identifier, sellerInventoryListConsumer.identifier) && Objects.equals(this.sellerIdentifier, sellerInventoryListConsumer.sellerIdentifier) && Objects.equals(this.sellerInventoryListName, sellerInventoryListConsumer.sellerInventoryListName) && Objects.equals(this.engineConfigurationIdentifier, sellerInventoryListConsumer.engineConfigurationIdentifier) && Objects.equals(this.descriptions, sellerInventoryListConsumer.descriptions) && Objects.equals(this.keywords, sellerInventoryListConsumer.keywords) && Objects.equals((Object)this.status, (Object)sellerInventoryListConsumer.status) && Objects.equals((Object)this.listType, (Object)sellerInventoryListConsumer.listType) && Objects.equals(this.listIdentifier, sellerInventoryListConsumer.listIdentifier) && Objects.equals(this.animate, sellerInventoryListConsumer.animate) && Objects.equals(this.animateDelay, sellerInventoryListConsumer.animateDelay) && Objects.equals((Object)this.sort, (Object)sellerInventoryListConsumer.sort) && Objects.equals((Object)this.displayType, (Object)sellerInventoryListConsumer.displayType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.identifier, this.sellerIdentifier, this.sellerInventoryListName, this.engineConfigurationIdentifier, this.descriptions, this.keywords, this.status, this.listType, this.listIdentifier, this.animate, this.animateDelay, this.sort, this.displayType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SellerInventoryListConsumer {\n");
        sb.append("    identifier: ").append(this.toIndentedString(this.identifier)).append("\n");
        sb.append("    sellerIdentifier: ").append(this.toIndentedString(this.sellerIdentifier)).append("\n");
        sb.append("    sellerInventoryListName: ").append(this.toIndentedString(this.sellerInventoryListName)).append("\n");
        sb.append("    engineConfigurationIdentifier: ").append(this.toIndentedString(this.engineConfigurationIdentifier)).append("\n");
        sb.append("    descriptions: ").append(this.toIndentedString(this.descriptions)).append("\n");
        sb.append("    keywords: ").append(this.toIndentedString(this.keywords)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    listType: ").append(this.toIndentedString((Object)this.listType)).append("\n");
        sb.append("    listIdentifier: ").append(this.toIndentedString(this.listIdentifier)).append("\n");
        sb.append("    animate: ").append(this.toIndentedString(this.animate)).append("\n");
        sb.append("    animateDelay: ").append(this.toIndentedString(this.animateDelay)).append("\n");
        sb.append("    sort: ").append(this.toIndentedString((Object)this.sort)).append("\n");
        sb.append("    displayType: ").append(this.toIndentedString((Object)this.displayType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatusEnum {
        ACTIVE("ACTIVE"),
        INACTIVE("INACTIVE"),
        REMOVED("REMOVED");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum DisplayTypeEnum {
        NATIVE("NATIVE"),
        HOTEL("HOTEL"),
        ROOM("ROOM");

        private String value;

        private DisplayTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static DisplayTypeEnum fromValue(String value) {
            for (DisplayTypeEnum b : DisplayTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum ListTypeEnum {
        SINGLE("SINGLE"),
        LIST("LIST"),
        SEARCH("SEARCH");

        private String value;

        private ListTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ListTypeEnum fromValue(String value) {
            for (ListTypeEnum b : ListTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum SortEnum {
        MEMBER("MEMBER"),
        PRICE_LOW_TO_HIGH("PRICE_LOW_TO_HIGH"),
        PRICE_HIGH_TO_LOW("PRICE_HIGH_TO_LOW"),
        PRICE("PRICE"),
        POPULARITY("POPULARITY"),
        ECO("ECO"),
        EXPERIENCE("EXPERIENCE"),
        PERK("PERK"),
        LOYALTY("LOYALTY"),
        PACKAGE("PACKAGE");

        private String value;

        private SortEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static SortEnum fromValue(String value) {
            for (SortEnum b : SortEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

