/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release   # Inventory API Welcome to the Inventory API - A programmer-friendly way to retrieve known travel inventory as it was officially located using the Lookup API. We take great care in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Suppliers have the ability to make their inventory look great and be searchable in a wide variety of ways. You can work with suppliers directly or receive payment-level pricing available to all our integration partners.  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory. Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - OTAs that want access direct relationships with suppliers and better quality hotel inventory 
 *
 * The version of the OpenAPI document: 25.0.3
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.inventory.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import travel.wink.sdk.inventory.model.GuestRoomConsumer;
import travel.wink.sdk.inventory.model.RoomConfigurationPriceConsumer;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * List of room types with price configurations based on the itinerary that was passed on the user session.
 */
@ApiModel(description = "List of room types with price configurations based on the itinerary that was passed on the user session.")
@JsonPropertyOrder({
  RoomTypeWithPriceConfigurationsConsumer.JSON_PROPERTY_ROOM,
  RoomTypeWithPriceConfigurationsConsumer.JSON_PROPERTY_PRICE_CONFIGURATIONS,
  RoomTypeWithPriceConfigurationsConsumer.JSON_PROPERTY_BEST_PRICE,
  RoomTypeWithPriceConfigurationsConsumer.JSON_PROPERTY_AVAILABLE
})
@JsonTypeName("RoomTypeWithPriceConfigurations_Consumer")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-03-24T11:14:19.738875093+07:00[Asia/Bangkok]")
public class RoomTypeWithPriceConfigurationsConsumer {
  public static final String JSON_PROPERTY_ROOM = "room";
  private GuestRoomConsumer room;

  public static final String JSON_PROPERTY_PRICE_CONFIGURATIONS = "priceConfigurations";
  private List<RoomConfigurationPriceConsumer> priceConfigurations = new ArrayList<>();

  public static final String JSON_PROPERTY_BEST_PRICE = "bestPrice";
  private RoomConfigurationPriceConsumer bestPrice;

  public static final String JSON_PROPERTY_AVAILABLE = "available";
  private Boolean available;

  public RoomTypeWithPriceConfigurationsConsumer() { 
  }

  public RoomTypeWithPriceConfigurationsConsumer room(GuestRoomConsumer room) {
    
    this.room = room;
    return this;
  }

   /**
   * Get room
   * @return room
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_ROOM)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public GuestRoomConsumer getRoom() {
    return room;
  }


  @JsonProperty(JSON_PROPERTY_ROOM)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRoom(GuestRoomConsumer room) {
    this.room = room;
  }


  public RoomTypeWithPriceConfigurationsConsumer priceConfigurations(List<RoomConfigurationPriceConsumer> priceConfigurations) {
    
    this.priceConfigurations = priceConfigurations;
    return this;
  }

  public RoomTypeWithPriceConfigurationsConsumer addPriceConfigurationsItem(RoomConfigurationPriceConsumer priceConfigurationsItem) {
    this.priceConfigurations.add(priceConfigurationsItem);
    return this;
  }

   /**
   * Get priceConfigurations
   * @return priceConfigurations
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_PRICE_CONFIGURATIONS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<RoomConfigurationPriceConsumer> getPriceConfigurations() {
    return priceConfigurations;
  }


  @JsonProperty(JSON_PROPERTY_PRICE_CONFIGURATIONS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPriceConfigurations(List<RoomConfigurationPriceConsumer> priceConfigurations) {
    this.priceConfigurations = priceConfigurations;
  }


  public RoomTypeWithPriceConfigurationsConsumer bestPrice(RoomConfigurationPriceConsumer bestPrice) {
    
    this.bestPrice = bestPrice;
    return this;
  }

   /**
   * Get bestPrice
   * @return bestPrice
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_BEST_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public RoomConfigurationPriceConsumer getBestPrice() {
    return bestPrice;
  }


  @JsonProperty(JSON_PROPERTY_BEST_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBestPrice(RoomConfigurationPriceConsumer bestPrice) {
    this.bestPrice = bestPrice;
  }


  public RoomTypeWithPriceConfigurationsConsumer available(Boolean available) {
    
    this.available = available;
    return this;
  }

   /**
   * Get available
   * @return available
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_AVAILABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getAvailable() {
    return available;
  }


  @JsonProperty(JSON_PROPERTY_AVAILABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAvailable(Boolean available) {
    this.available = available;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RoomTypeWithPriceConfigurationsConsumer roomTypeWithPriceConfigurationsConsumer = (RoomTypeWithPriceConfigurationsConsumer) o;
    return Objects.equals(this.room, roomTypeWithPriceConfigurationsConsumer.room) &&
        Objects.equals(this.priceConfigurations, roomTypeWithPriceConfigurationsConsumer.priceConfigurations) &&
        Objects.equals(this.bestPrice, roomTypeWithPriceConfigurationsConsumer.bestPrice) &&
        Objects.equals(this.available, roomTypeWithPriceConfigurationsConsumer.available);
  }

  @Override
  public int hashCode() {
    return Objects.hash(room, priceConfigurations, bestPrice, available);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RoomTypeWithPriceConfigurationsConsumer {\n");
    sb.append("    room: ").append(toIndentedString(room)).append("\n");
    sb.append("    priceConfigurations: ").append(toIndentedString(priceConfigurations)).append("\n");
    sb.append("    bestPrice: ").append(toIndentedString(bestPrice)).append("\n");
    sb.append("    available: ").append(toIndentedString(available)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

