/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release   # Inventory API Welcome to the Inventory API - A programmer-friendly way to retrieve known travel inventory as it was officially located using the Lookup API. We take great care in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Suppliers have the ability to make their inventory look great and be searchable in a wide variety of ways. You can work with suppliers directly or receive payment-level pricing available to all our integration partners.  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory. Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - OTAs that want access direct relationships with suppliers and better quality hotel inventory 
 *
 * The version of the OpenAPI document: 25.0.3
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.inventory.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import travel.wink.sdk.inventory.model.AddressConsumer;
import travel.wink.sdk.inventory.model.ContactConsumer;
import travel.wink.sdk.inventory.model.DowPatternGroupConsumer;
import travel.wink.sdk.inventory.model.GeoJsonPointConsumer;
import travel.wink.sdk.inventory.model.SimpleDescriptionConsumer;
import travel.wink.sdk.inventory.model.SimpleMultimediaConsumer;
import travel.wink.sdk.inventory.model.SocialConsumer;
import travel.wink.sdk.inventory.model.TravelInventoryRecognitionConsumer;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import javax.validation.constraints.*;
import javax.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Inventory data object
 */
@ApiModel(description = "Inventory data object")
@JsonPropertyOrder({
  SpaConsumer.JSON_PROPERTY_IDENTIFIER,
  SpaConsumer.JSON_PROPERTY_HOTEL_IDENTIFIER,
  SpaConsumer.JSON_PROPERTY_FEATURED_IND,
  SpaConsumer.JSON_PROPERTY_LIFESTYLE_TYPE,
  SpaConsumer.JSON_PROPERTY_LOCATION,
  SpaConsumer.JSON_PROPERTY_DESCRIPTIONS,
  SpaConsumer.JSON_PROPERTY_MULTIMEDIAS,
  SpaConsumer.JSON_PROPERTY_CONTACT,
  SpaConsumer.JSON_PROPERTY_ADDRESS,
  SpaConsumer.JSON_PROPERTY_COMMISSIONABLE,
  SpaConsumer.JSON_PROPERTY_NAME,
  SpaConsumer.JSON_PROPERTY_PROXIMITY_CODE,
  SpaConsumer.JSON_PROPERTY_SORT,
  SpaConsumer.JSON_PROPERTY_MIN_AGE_APPROPRIATE_CODE,
  SpaConsumer.JSON_PROPERTY_BOOKABLE,
  SpaConsumer.JSON_PROPERTY_ACTIVE,
  SpaConsumer.JSON_PROPERTY_DISABILITY_FEATURES,
  SpaConsumer.JSON_PROPERTY_SECURITY_FEATURES,
  SpaConsumer.JSON_PROPERTY_SOCIALS,
  SpaConsumer.JSON_PROPERTY_PRICE_POINT,
  SpaConsumer.JSON_PROPERTY_RECOGNITION_LIST,
  SpaConsumer.JSON_PROPERTY_APPLICABLE_START,
  SpaConsumer.JSON_PROPERTY_APPLICABLE_END,
  SpaConsumer.JSON_PROPERTY_RESERVATION_REQUIRED_IND,
  SpaConsumer.JSON_PROPERTY_OPENS,
  SpaConsumer.JSON_PROPERTY_CLOSES,
  SpaConsumer.JSON_PROPERTY_DAYS_OF_WEEK,
  SpaConsumer.JSON_PROPERTY_AMENITIES
})
@JsonTypeName("Spa_Consumer")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-03-24T11:14:19.738875093+07:00[Asia/Bangkok]")
public class SpaConsumer {
  public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
  private UUID identifier;

  public static final String JSON_PROPERTY_HOTEL_IDENTIFIER = "hotelIdentifier";
  private UUID hotelIdentifier;

  public static final String JSON_PROPERTY_FEATURED_IND = "featuredInd";
  private Boolean featuredInd;

  /**
   * Indicate the type of lifestyle this inventory should be associated with.
   */
  public enum LifestyleTypeEnum {
    HEALTH_FITNESS("LIFESTYLE_HEALTH_FITNESS"),
    
    RELAX("LIFESTYLE_RELAX"),
    
    ADULT_ONLY("LIFESTYLE_ADULT_ONLY"),
    
    ADVENTURE("LIFESTYLE_ADVENTURE"),
    
    BUSINESS("LIFESTYLE_BUSINESS"),
    
    LGBT("LIFESTYLE_LGBT"),
    
    SINGLE_PARENT("LIFESTYLE_SINGLE_PARENT"),
    
    SOLO_FEMALE("LIFESTYLE_SOLO_FEMALE"),
    
    BEAUTY("LIFESTYLE_BEAUTY"),
    
    FOODIE("LIFESTYLE_FOODIE"),
    
    FAMILY("LIFESTYLE_FAMILY"),
    
    ROMANCE("LIFESTYLE_ROMANCE"),
    
    COUPLE("LIFESTYLE_COUPLE"),
    
    SOLO("LIFESTYLE_SOLO"),
    
    BACKPACKER("LIFESTYLE_BACKPACKER"),
    
    SHOPPING("LIFESTYLE_SHOPPING"),
    
    SPORTS("LIFESTYLE_SPORTS"),
    
    MOUNTAIN("LIFESTYLE_MOUNTAIN"),
    
    BEACH("LIFESTYLE_BEACH"),
    
    CITY("LIFESTYLE_CITY"),
    
    COUNTRY("LIFESTYLE_COUNTRY"),
    
    CULTURE("LIFESTYLE_CULTURE"),
    
    ECO("LIFESTYLE_ECO");

    private String value;

    LifestyleTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static LifestyleTypeEnum fromValue(String value) {
      for (LifestyleTypeEnum b : LifestyleTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_LIFESTYLE_TYPE = "lifestyleType";
  private LifestyleTypeEnum lifestyleType;

  public static final String JSON_PROPERTY_LOCATION = "location";
  private GeoJsonPointConsumer location;

  public static final String JSON_PROPERTY_DESCRIPTIONS = "descriptions";
  private List<SimpleDescriptionConsumer> descriptions = new ArrayList<>();

  public static final String JSON_PROPERTY_MULTIMEDIAS = "multimedias";
  private List<SimpleMultimediaConsumer> multimedias = new ArrayList<>();

  public static final String JSON_PROPERTY_CONTACT = "contact";
  private ContactConsumer contact;

  public static final String JSON_PROPERTY_ADDRESS = "address";
  private AddressConsumer address;

  public static final String JSON_PROPERTY_COMMISSIONABLE = "commissionable";
  private Boolean commissionable = true;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_PROXIMITY_CODE = "proximityCode";
  private String proximityCode;

  public static final String JSON_PROPERTY_SORT = "sort";
  private Integer sort;

  public static final String JSON_PROPERTY_MIN_AGE_APPROPRIATE_CODE = "minAgeAppropriateCode";
  private String minAgeAppropriateCode;

  public static final String JSON_PROPERTY_BOOKABLE = "bookable";
  private Boolean bookable = true;

  public static final String JSON_PROPERTY_ACTIVE = "active";
  private Boolean active = true;

  public static final String JSON_PROPERTY_DISABILITY_FEATURES = "disabilityFeatures";
  private List<String> disabilityFeatures = null;

  public static final String JSON_PROPERTY_SECURITY_FEATURES = "securityFeatures";
  private List<String> securityFeatures = null;

  public static final String JSON_PROPERTY_SOCIALS = "socials";
  private List<SocialConsumer> socials = null;

  /**
   * Level of expensiveness.
   */
  public enum PricePointEnum {
    HALF("HALF"),
    
    ONE("ONE"),
    
    ONE_HALF("ONE_HALF"),
    
    TWO("TWO"),
    
    TWO_HALF("TWO_HALF"),
    
    THREE("THREE"),
    
    THREE_HALF("THREE_HALF"),
    
    FOUR("FOUR"),
    
    FOUR_HALF("FOUR_HALF"),
    
    FIVE("FIVE");

    private String value;

    PricePointEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static PricePointEnum fromValue(String value) {
      for (PricePointEnum b : PricePointEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_PRICE_POINT = "pricePoint";
  private PricePointEnum pricePoint = PricePointEnum.THREE;

  public static final String JSON_PROPERTY_RECOGNITION_LIST = "recognitionList";
  private List<TravelInventoryRecognitionConsumer> recognitionList = null;

  public static final String JSON_PROPERTY_APPLICABLE_START = "applicableStart";
  private LocalDate applicableStart;

  public static final String JSON_PROPERTY_APPLICABLE_END = "applicableEnd";
  private LocalDate applicableEnd;

  public static final String JSON_PROPERTY_RESERVATION_REQUIRED_IND = "reservationRequiredInd";
  private Boolean reservationRequiredInd;

  public static final String JSON_PROPERTY_OPENS = "opens";
  private String opens;

  public static final String JSON_PROPERTY_CLOSES = "closes";
  private String closes;

  public static final String JSON_PROPERTY_DAYS_OF_WEEK = "daysOfWeek";
  private DowPatternGroupConsumer daysOfWeek;

  public static final String JSON_PROPERTY_AMENITIES = "amenities";
  private List<String> amenities = null;

  public SpaConsumer() { 
  }

  public SpaConsumer identifier(UUID identifier) {
    
    this.identifier = identifier;
    return this;
  }

   /**
   * Unique record identifier
   * @return identifier
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "Unique record identifier")
  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getIdentifier() {
    return identifier;
  }


  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setIdentifier(UUID identifier) {
    this.identifier = identifier;
  }


  public SpaConsumer hotelIdentifier(UUID hotelIdentifier) {
    
    this.hotelIdentifier = hotelIdentifier;
    return this;
  }

   /**
   * Hotel identifier.
   * @return hotelIdentifier
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "Hotel identifier.")
  @JsonProperty(JSON_PROPERTY_HOTEL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getHotelIdentifier() {
    return hotelIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_HOTEL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setHotelIdentifier(UUID hotelIdentifier) {
    this.hotelIdentifier = hotelIdentifier;
  }


  public SpaConsumer featuredInd(Boolean featuredInd) {
    
    this.featuredInd = featuredInd;
    return this;
  }

   /**
   * Indicates whether this inventory is featured. Use this flag as a way to signify that this inventory is special.
   * @return featuredInd
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "false", required = true, value = "Indicates whether this inventory is featured. Use this flag as a way to signify that this inventory is special.")
  @JsonProperty(JSON_PROPERTY_FEATURED_IND)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getFeaturedInd() {
    return featuredInd;
  }


  @JsonProperty(JSON_PROPERTY_FEATURED_IND)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setFeaturedInd(Boolean featuredInd) {
    this.featuredInd = featuredInd;
  }


  public SpaConsumer lifestyleType(LifestyleTypeEnum lifestyleType) {
    
    this.lifestyleType = lifestyleType;
    return this;
  }

   /**
   * Indicate the type of lifestyle this inventory should be associated with.
   * @return lifestyleType
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "LIFESTYLE_HEALTH_FITNESS", value = "Indicate the type of lifestyle this inventory should be associated with.")
  @JsonProperty(JSON_PROPERTY_LIFESTYLE_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LifestyleTypeEnum getLifestyleType() {
    return lifestyleType;
  }


  @JsonProperty(JSON_PROPERTY_LIFESTYLE_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLifestyleType(LifestyleTypeEnum lifestyleType) {
    this.lifestyleType = lifestyleType;
  }


  public SpaConsumer location(GeoJsonPointConsumer location) {
    
    this.location = location;
    return this;
  }

   /**
   * Get location
   * @return location
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_LOCATION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public GeoJsonPointConsumer getLocation() {
    return location;
  }


  @JsonProperty(JSON_PROPERTY_LOCATION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setLocation(GeoJsonPointConsumer location) {
    this.location = location;
  }


  public SpaConsumer descriptions(List<SimpleDescriptionConsumer> descriptions) {
    
    this.descriptions = descriptions;
    return this;
  }

  public SpaConsumer addDescriptionsItem(SimpleDescriptionConsumer descriptionsItem) {
    this.descriptions.add(descriptionsItem);
    return this;
  }

   /**
   * Localized descriptions describing inventory.
   * @return descriptions
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "Localized descriptions describing inventory.")
  @JsonProperty(JSON_PROPERTY_DESCRIPTIONS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<SimpleDescriptionConsumer> getDescriptions() {
    return descriptions;
  }


  @JsonProperty(JSON_PROPERTY_DESCRIPTIONS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDescriptions(List<SimpleDescriptionConsumer> descriptions) {
    this.descriptions = descriptions;
  }


  public SpaConsumer multimedias(List<SimpleMultimediaConsumer> multimedias) {
    
    this.multimedias = multimedias;
    return this;
  }

  public SpaConsumer addMultimediasItem(SimpleMultimediaConsumer multimediasItem) {
    this.multimedias.add(multimediasItem);
    return this;
  }

   /**
   * List of images / videos of inventory.
   * @return multimedias
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "List of images / videos of inventory.")
  @JsonProperty(JSON_PROPERTY_MULTIMEDIAS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<SimpleMultimediaConsumer> getMultimedias() {
    return multimedias;
  }


  @JsonProperty(JSON_PROPERTY_MULTIMEDIAS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setMultimedias(List<SimpleMultimediaConsumer> multimedias) {
    this.multimedias = multimedias;
  }


  public SpaConsumer contact(ContactConsumer contact) {
    
    this.contact = contact;
    return this;
  }

   /**
   * Get contact
   * @return contact
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_CONTACT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public ContactConsumer getContact() {
    return contact;
  }


  @JsonProperty(JSON_PROPERTY_CONTACT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setContact(ContactConsumer contact) {
    this.contact = contact;
  }


  public SpaConsumer address(AddressConsumer address) {
    
    this.address = address;
    return this;
  }

   /**
   * Get address
   * @return address
  **/
  @javax.annotation.Nonnull
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public AddressConsumer getAddress() {
    return address;
  }


  @JsonProperty(JSON_PROPERTY_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAddress(AddressConsumer address) {
    this.address = address;
  }


  public SpaConsumer commissionable(Boolean commissionable) {
    
    this.commissionable = commissionable;
    return this;
  }

   /**
   * Indicate whether sales channels receive commission for selling this inventory.
   * @return commissionable
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "true", required = true, value = "Indicate whether sales channels receive commission for selling this inventory.")
  @JsonProperty(JSON_PROPERTY_COMMISSIONABLE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getCommissionable() {
    return commissionable;
  }


  @JsonProperty(JSON_PROPERTY_COMMISSIONABLE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCommissionable(Boolean commissionable) {
    this.commissionable = commissionable;
  }


  public SpaConsumer name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * Internal name of inventory.
   * @return name
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "Archery lesson", required = true, value = "Internal name of inventory.")
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setName(String name) {
    this.name = name;
  }


  public SpaConsumer proximityCode(String proximityCode) {
    
    this.proximityCode = proximityCode;
    return this;
  }

   /**
   * Supported OTA specification &#x60;PRX&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory)
   * @return proximityCode
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "1", required = true, value = "Supported OTA specification `PRX` code. See [OTA geoname data](#operation/showAvailableCodesForCategory)")
  @JsonProperty(JSON_PROPERTY_PROXIMITY_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getProximityCode() {
    return proximityCode;
  }


  @JsonProperty(JSON_PROPERTY_PROXIMITY_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setProximityCode(String proximityCode) {
    this.proximityCode = proximityCode;
  }


  public SpaConsumer sort(Integer sort) {
    
    this.sort = sort;
    return this;
  }

   /**
   * Use this property to sort an inventory in a list of activities.
   * @return sort
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "1", value = "Use this property to sort an inventory in a list of activities.")
  @JsonProperty(JSON_PROPERTY_SORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getSort() {
    return sort;
  }


  @JsonProperty(JSON_PROPERTY_SORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSort(Integer sort) {
    this.sort = sort;
  }


  public SpaConsumer minAgeAppropriateCode(String minAgeAppropriateCode) {
    
    this.minAgeAppropriateCode = minAgeAppropriateCode;
    return this;
  }

   /**
   * Supported OTA specification &#x60;AQC&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory)
   * @return minAgeAppropriateCode
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "1", value = "Supported OTA specification `AQC` code. See [OTA geoname data](#operation/showAvailableCodesForCategory)")
  @JsonProperty(JSON_PROPERTY_MIN_AGE_APPROPRIATE_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getMinAgeAppropriateCode() {
    return minAgeAppropriateCode;
  }


  @JsonProperty(JSON_PROPERTY_MIN_AGE_APPROPRIATE_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMinAgeAppropriateCode(String minAgeAppropriateCode) {
    this.minAgeAppropriateCode = minAgeAppropriateCode;
  }


  public SpaConsumer bookable(Boolean bookable) {
    
    this.bookable = bookable;
    return this;
  }

   /**
   * Indicates if this inventory can be added to a booking or if it is read-only marketing material only.
   * @return bookable
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "true", required = true, value = "Indicates if this inventory can be added to a booking or if it is read-only marketing material only.")
  @JsonProperty(JSON_PROPERTY_BOOKABLE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getBookable() {
    return bookable;
  }


  @JsonProperty(JSON_PROPERTY_BOOKABLE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setBookable(Boolean bookable) {
    this.bookable = bookable;
  }


  public SpaConsumer active(Boolean active) {
    
    this.active = active;
    return this;
  }

   /**
   * Modify inventory availability with this flag.
   * @return active
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "true", required = true, value = "Modify inventory availability with this flag.")
  @JsonProperty(JSON_PROPERTY_ACTIVE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getActive() {
    return active;
  }


  @JsonProperty(JSON_PROPERTY_ACTIVE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setActive(Boolean active) {
    this.active = active;
  }


  public SpaConsumer disabilityFeatures(List<String> disabilityFeatures) {
    
    this.disabilityFeatures = disabilityFeatures;
    return this;
  }

  public SpaConsumer addDisabilityFeaturesItem(String disabilityFeaturesItem) {
    if (this.disabilityFeatures == null) {
      this.disabilityFeatures = new ArrayList<>();
    }
    this.disabilityFeatures.add(disabilityFeaturesItem);
    return this;
  }

   /**
   * Supported OTA specification &#x60;PHY&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory)
   * @return disabilityFeatures
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "[\"1\"]", value = "Supported OTA specification `PHY` code. See [OTA geoname data](#operation/showAvailableCodesForCategory)")
  @JsonProperty(JSON_PROPERTY_DISABILITY_FEATURES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getDisabilityFeatures() {
    return disabilityFeatures;
  }


  @JsonProperty(JSON_PROPERTY_DISABILITY_FEATURES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDisabilityFeatures(List<String> disabilityFeatures) {
    this.disabilityFeatures = disabilityFeatures;
  }


  public SpaConsumer securityFeatures(List<String> securityFeatures) {
    
    this.securityFeatures = securityFeatures;
    return this;
  }

  public SpaConsumer addSecurityFeaturesItem(String securityFeaturesItem) {
    if (this.securityFeatures == null) {
      this.securityFeatures = new ArrayList<>();
    }
    this.securityFeatures.add(securityFeaturesItem);
    return this;
  }

   /**
   * Supported OTA specification &#x60;SEC&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory)
   * @return securityFeatures
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "[\"1\"]", value = "Supported OTA specification `SEC` code. See [OTA geoname data](#operation/showAvailableCodesForCategory)")
  @JsonProperty(JSON_PROPERTY_SECURITY_FEATURES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getSecurityFeatures() {
    return securityFeatures;
  }


  @JsonProperty(JSON_PROPERTY_SECURITY_FEATURES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSecurityFeatures(List<String> securityFeatures) {
    this.securityFeatures = securityFeatures;
  }


  public SpaConsumer socials(List<SocialConsumer> socials) {
    
    this.socials = socials;
    return this;
  }

  public SpaConsumer addSocialsItem(SocialConsumer socialsItem) {
    if (this.socials == null) {
      this.socials = new ArrayList<>();
    }
    this.socials.add(socialsItem);
    return this;
  }

   /**
   * Social network accounts for inventory (if applicable).
   * @return socials
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Social network accounts for inventory (if applicable).")
  @JsonProperty(JSON_PROPERTY_SOCIALS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<SocialConsumer> getSocials() {
    return socials;
  }


  @JsonProperty(JSON_PROPERTY_SOCIALS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSocials(List<SocialConsumer> socials) {
    this.socials = socials;
  }


  public SpaConsumer pricePoint(PricePointEnum pricePoint) {
    
    this.pricePoint = pricePoint;
    return this;
  }

   /**
   * Level of expensiveness.
   * @return pricePoint
  **/
  @javax.annotation.Nonnull
  @NotNull
  @ApiModelProperty(example = "THREE", required = true, value = "Level of expensiveness.")
  @JsonProperty(JSON_PROPERTY_PRICE_POINT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public PricePointEnum getPricePoint() {
    return pricePoint;
  }


  @JsonProperty(JSON_PROPERTY_PRICE_POINT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPricePoint(PricePointEnum pricePoint) {
    this.pricePoint = pricePoint;
  }


  public SpaConsumer recognitionList(List<TravelInventoryRecognitionConsumer> recognitionList) {
    
    this.recognitionList = recognitionList;
    return this;
  }

  public SpaConsumer addRecognitionListItem(TravelInventoryRecognitionConsumer recognitionListItem) {
    if (this.recognitionList == null) {
      this.recognitionList = new ArrayList<>();
    }
    this.recognitionList.add(recognitionListItem);
    return this;
  }

   /**
   * Inventory-level recognition.
   * @return recognitionList
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Inventory-level recognition.")
  @JsonProperty(JSON_PROPERTY_RECOGNITION_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<TravelInventoryRecognitionConsumer> getRecognitionList() {
    return recognitionList;
  }


  @JsonProperty(JSON_PROPERTY_RECOGNITION_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRecognitionList(List<TravelInventoryRecognitionConsumer> recognitionList) {
    this.recognitionList = recognitionList;
  }


  public SpaConsumer applicableStart(LocalDate applicableStart) {
    
    this.applicableStart = applicableStart;
    return this;
  }

   /**
   * Start month and day or date for which the attraction (e.g. the start of a season) is available. This date property signifies that the inventory is recurring and / or seasonal. If the date is in the past, only day and month will be used to infer seasonality. If the date is a future date, it will be interpreted as a starting date.
   * @return applicableStart
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(example = "Thu Jan 01 07:00:00 ICT 1970", value = "Start month and day or date for which the attraction (e.g. the start of a season) is available. This date property signifies that the inventory is recurring and / or seasonal. If the date is in the past, only day and month will be used to infer seasonality. If the date is a future date, it will be interpreted as a starting date.")
  @JsonProperty(JSON_PROPERTY_APPLICABLE_START)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LocalDate getApplicableStart() {
    return applicableStart;
  }


  @JsonProperty(JSON_PROPERTY_APPLICABLE_START)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setApplicableStart(LocalDate applicableStart) {
    this.applicableStart = applicableStart;
  }


  public SpaConsumer applicableEnd(LocalDate applicableEnd) {
    
    this.applicableEnd = applicableEnd;
    return this;
  }

   /**
   * End month and day or date for which the attraction (e.g. the start of a season) is available. This date property signifies that the inventory is recurring and / or seasonal. If the date is in the past, only day and month will be used to infer seasonality. If the date is a future date, it will be interpreted as a ending date.
   * @return applicableEnd
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(example = "Tue Dec 01 07:00:00 ICT 1970", value = "End month and day or date for which the attraction (e.g. the start of a season) is available. This date property signifies that the inventory is recurring and / or seasonal. If the date is in the past, only day and month will be used to infer seasonality. If the date is a future date, it will be interpreted as a ending date.")
  @JsonProperty(JSON_PROPERTY_APPLICABLE_END)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LocalDate getApplicableEnd() {
    return applicableEnd;
  }


  @JsonProperty(JSON_PROPERTY_APPLICABLE_END)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setApplicableEnd(LocalDate applicableEnd) {
    this.applicableEnd = applicableEnd;
  }


  public SpaConsumer reservationRequiredInd(Boolean reservationRequiredInd) {
    
    this.reservationRequiredInd = reservationRequiredInd;
    return this;
  }

   /**
   * Indicates whether a reservation is required to participate in this inventory.
   * @return reservationRequiredInd
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Indicates whether a reservation is required to participate in this inventory.")
  @JsonProperty(JSON_PROPERTY_RESERVATION_REQUIRED_IND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getReservationRequiredInd() {
    return reservationRequiredInd;
  }


  @JsonProperty(JSON_PROPERTY_RESERVATION_REQUIRED_IND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReservationRequiredInd(Boolean reservationRequiredInd) {
    this.reservationRequiredInd = reservationRequiredInd;
  }


  public SpaConsumer opens(String opens) {
    
    this.opens = opens;
    return this;
  }

   /**
   * Opening time of inventory (if applicable). Leave empty if inventory is always available.
   * @return opens
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "09:00", value = "Opening time of inventory (if applicable). Leave empty if inventory is always available.")
  @JsonProperty(JSON_PROPERTY_OPENS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getOpens() {
    return opens;
  }


  @JsonProperty(JSON_PROPERTY_OPENS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOpens(String opens) {
    this.opens = opens;
  }


  public SpaConsumer closes(String closes) {
    
    this.closes = closes;
    return this;
  }

   /**
   * Closing time of inventory (if applicable). Leave empty if inventory is always available.
   * @return closes
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "17:30", value = "Closing time of inventory (if applicable). Leave empty if inventory is always available.")
  @JsonProperty(JSON_PROPERTY_CLOSES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCloses() {
    return closes;
  }


  @JsonProperty(JSON_PROPERTY_CLOSES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCloses(String closes) {
    this.closes = closes;
  }


  public SpaConsumer daysOfWeek(DowPatternGroupConsumer daysOfWeek) {
    
    this.daysOfWeek = daysOfWeek;
    return this;
  }

   /**
   * Get daysOfWeek
   * @return daysOfWeek
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DAYS_OF_WEEK)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public DowPatternGroupConsumer getDaysOfWeek() {
    return daysOfWeek;
  }


  @JsonProperty(JSON_PROPERTY_DAYS_OF_WEEK)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDaysOfWeek(DowPatternGroupConsumer daysOfWeek) {
    this.daysOfWeek = daysOfWeek;
  }


  public SpaConsumer amenities(List<String> amenities) {
    
    this.amenities = amenities;
    return this;
  }

  public SpaConsumer addAmenitiesItem(String amenitiesItem) {
    if (this.amenities == null) {
      this.amenities = new ArrayList<>();
    }
    this.amenities.add(amenitiesItem);
    return this;
  }

   /**
   * UnSupported OTA specification &#x60;SPA&#x60; code. See [OTA geoname data](#operation/showAvailableCodesForCategory).
   * @return amenities
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "[\"1\"]", value = "UnSupported OTA specification `SPA` code. See [OTA geoname data](#operation/showAvailableCodesForCategory).")
  @JsonProperty(JSON_PROPERTY_AMENITIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getAmenities() {
    return amenities;
  }


  @JsonProperty(JSON_PROPERTY_AMENITIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAmenities(List<String> amenities) {
    this.amenities = amenities;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SpaConsumer spaConsumer = (SpaConsumer) o;
    return Objects.equals(this.identifier, spaConsumer.identifier) &&
        Objects.equals(this.hotelIdentifier, spaConsumer.hotelIdentifier) &&
        Objects.equals(this.featuredInd, spaConsumer.featuredInd) &&
        Objects.equals(this.lifestyleType, spaConsumer.lifestyleType) &&
        Objects.equals(this.location, spaConsumer.location) &&
        Objects.equals(this.descriptions, spaConsumer.descriptions) &&
        Objects.equals(this.multimedias, spaConsumer.multimedias) &&
        Objects.equals(this.contact, spaConsumer.contact) &&
        Objects.equals(this.address, spaConsumer.address) &&
        Objects.equals(this.commissionable, spaConsumer.commissionable) &&
        Objects.equals(this.name, spaConsumer.name) &&
        Objects.equals(this.proximityCode, spaConsumer.proximityCode) &&
        Objects.equals(this.sort, spaConsumer.sort) &&
        Objects.equals(this.minAgeAppropriateCode, spaConsumer.minAgeAppropriateCode) &&
        Objects.equals(this.bookable, spaConsumer.bookable) &&
        Objects.equals(this.active, spaConsumer.active) &&
        Objects.equals(this.disabilityFeatures, spaConsumer.disabilityFeatures) &&
        Objects.equals(this.securityFeatures, spaConsumer.securityFeatures) &&
        Objects.equals(this.socials, spaConsumer.socials) &&
        Objects.equals(this.pricePoint, spaConsumer.pricePoint) &&
        Objects.equals(this.recognitionList, spaConsumer.recognitionList) &&
        Objects.equals(this.applicableStart, spaConsumer.applicableStart) &&
        Objects.equals(this.applicableEnd, spaConsumer.applicableEnd) &&
        Objects.equals(this.reservationRequiredInd, spaConsumer.reservationRequiredInd) &&
        Objects.equals(this.opens, spaConsumer.opens) &&
        Objects.equals(this.closes, spaConsumer.closes) &&
        Objects.equals(this.daysOfWeek, spaConsumer.daysOfWeek) &&
        Objects.equals(this.amenities, spaConsumer.amenities);
  }

  @Override
  public int hashCode() {
    return Objects.hash(identifier, hotelIdentifier, featuredInd, lifestyleType, location, descriptions, multimedias, contact, address, commissionable, name, proximityCode, sort, minAgeAppropriateCode, bookable, active, disabilityFeatures, securityFeatures, socials, pricePoint, recognitionList, applicableStart, applicableEnd, reservationRequiredInd, opens, closes, daysOfWeek, amenities);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SpaConsumer {\n");
    sb.append("    identifier: ").append(toIndentedString(identifier)).append("\n");
    sb.append("    hotelIdentifier: ").append(toIndentedString(hotelIdentifier)).append("\n");
    sb.append("    featuredInd: ").append(toIndentedString(featuredInd)).append("\n");
    sb.append("    lifestyleType: ").append(toIndentedString(lifestyleType)).append("\n");
    sb.append("    location: ").append(toIndentedString(location)).append("\n");
    sb.append("    descriptions: ").append(toIndentedString(descriptions)).append("\n");
    sb.append("    multimedias: ").append(toIndentedString(multimedias)).append("\n");
    sb.append("    contact: ").append(toIndentedString(contact)).append("\n");
    sb.append("    address: ").append(toIndentedString(address)).append("\n");
    sb.append("    commissionable: ").append(toIndentedString(commissionable)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    proximityCode: ").append(toIndentedString(proximityCode)).append("\n");
    sb.append("    sort: ").append(toIndentedString(sort)).append("\n");
    sb.append("    minAgeAppropriateCode: ").append(toIndentedString(minAgeAppropriateCode)).append("\n");
    sb.append("    bookable: ").append(toIndentedString(bookable)).append("\n");
    sb.append("    active: ").append(toIndentedString(active)).append("\n");
    sb.append("    disabilityFeatures: ").append(toIndentedString(disabilityFeatures)).append("\n");
    sb.append("    securityFeatures: ").append(toIndentedString(securityFeatures)).append("\n");
    sb.append("    socials: ").append(toIndentedString(socials)).append("\n");
    sb.append("    pricePoint: ").append(toIndentedString(pricePoint)).append("\n");
    sb.append("    recognitionList: ").append(toIndentedString(recognitionList)).append("\n");
    sb.append("    applicableStart: ").append(toIndentedString(applicableStart)).append("\n");
    sb.append("    applicableEnd: ").append(toIndentedString(applicableEnd)).append("\n");
    sb.append("    reservationRequiredInd: ").append(toIndentedString(reservationRequiredInd)).append("\n");
    sb.append("    opens: ").append(toIndentedString(opens)).append("\n");
    sb.append("    closes: ").append(toIndentedString(closes)).append("\n");
    sb.append("    daysOfWeek: ").append(toIndentedString(daysOfWeek)).append("\n");
    sb.append("    amenities: ").append(toIndentedString(amenities)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

