/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.inventory.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.validation.Valid;
import travel.wink.sdk.inventory.model.LocalizedTransactionalTravelInventoryConsumer;
import travel.wink.sdk.inventory.model.RestaurantConsumer;

@ApiModel(description="List of property restaurants on and off the premises.")
@JsonPropertyOrder(value={"restaurant", "list", "channelInventoryIdentifier", "commissionable", "commission", "priceList"})
@JsonTypeName(value="RestaurantLocalizedInventory_Consumer")
public class RestaurantLocalizedInventoryConsumer {
    public static final String JSON_PROPERTY_RESTAURANT = "restaurant";
    private RestaurantConsumer restaurant;
    public static final String JSON_PROPERTY_LIST = "list";
    private List<LocalizedTransactionalTravelInventoryConsumer> _list = null;
    public static final String JSON_PROPERTY_CHANNEL_INVENTORY_IDENTIFIER = "channelInventoryIdentifier";
    private UUID channelInventoryIdentifier;
    public static final String JSON_PROPERTY_COMMISSIONABLE = "commissionable";
    private Boolean commissionable;
    public static final String JSON_PROPERTY_COMMISSION = "commission";
    private Float commission;
    public static final String JSON_PROPERTY_PRICE_LIST = "priceList";
    private List<LocalizedTransactionalTravelInventoryConsumer> priceList = null;

    public RestaurantLocalizedInventoryConsumer restaurant(RestaurantConsumer restaurant) {
        this.restaurant = restaurant;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="restaurant")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public RestaurantConsumer getRestaurant() {
        return this.restaurant;
    }

    @JsonProperty(value="restaurant")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRestaurant(RestaurantConsumer restaurant) {
        this.restaurant = restaurant;
    }

    public RestaurantLocalizedInventoryConsumer _list(List<LocalizedTransactionalTravelInventoryConsumer> _list) {
        this._list = _list;
        return this;
    }

    public RestaurantLocalizedInventoryConsumer addListItem(LocalizedTransactionalTravelInventoryConsumer _listItem) {
        if (this._list == null) {
            this._list = new ArrayList<LocalizedTransactionalTravelInventoryConsumer>();
        }
        this._list.add(_listItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="list")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<LocalizedTransactionalTravelInventoryConsumer> getList() {
        return this._list;
    }

    @JsonProperty(value="list")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setList(List<LocalizedTransactionalTravelInventoryConsumer> _list) {
        this._list = _list;
    }

    public RestaurantLocalizedInventoryConsumer channelInventoryIdentifier(UUID channelInventoryIdentifier) {
        this.channelInventoryIdentifier = channelInventoryIdentifier;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Channel inventory identifier referencing this record.")
    @JsonProperty(value="channelInventoryIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UUID getChannelInventoryIdentifier() {
        return this.channelInventoryIdentifier;
    }

    @JsonProperty(value="channelInventoryIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setChannelInventoryIdentifier(UUID channelInventoryIdentifier) {
        this.channelInventoryIdentifier = channelInventoryIdentifier;
    }

    public RestaurantLocalizedInventoryConsumer commissionable(Boolean commissionable) {
        this.commissionable = commissionable;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether this package is commissionable based on the incoming sales channel.")
    @JsonProperty(value="commissionable")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getCommissionable() {
        return this.commissionable;
    }

    @JsonProperty(value="commissionable")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCommissionable(Boolean commissionable) {
        this.commissionable = commissionable;
    }

    public RestaurantLocalizedInventoryConsumer commission(Float commission) {
        this.commission = commission;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="0.1", value="The commission percentage.")
    @JsonProperty(value="commission")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Float getCommission() {
        return this.commission;
    }

    @JsonProperty(value="commission")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCommission(Float commission) {
        this.commission = commission;
    }

    public RestaurantLocalizedInventoryConsumer priceList(List<LocalizedTransactionalTravelInventoryConsumer> priceList) {
        this.priceList = priceList;
        return this;
    }

    public RestaurantLocalizedInventoryConsumer addPriceListItem(LocalizedTransactionalTravelInventoryConsumer priceListItem) {
        if (this.priceList == null) {
            this.priceList = new ArrayList<LocalizedTransactionalTravelInventoryConsumer>();
        }
        this.priceList.add(priceListItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="priceList")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<LocalizedTransactionalTravelInventoryConsumer> getPriceList() {
        return this.priceList;
    }

    @JsonProperty(value="priceList")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPriceList(List<LocalizedTransactionalTravelInventoryConsumer> priceList) {
        this.priceList = priceList;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RestaurantLocalizedInventoryConsumer restaurantLocalizedInventoryConsumer = (RestaurantLocalizedInventoryConsumer)o;
        return Objects.equals(this.restaurant, restaurantLocalizedInventoryConsumer.restaurant) && Objects.equals(this._list, restaurantLocalizedInventoryConsumer._list) && Objects.equals(this.channelInventoryIdentifier, restaurantLocalizedInventoryConsumer.channelInventoryIdentifier) && Objects.equals(this.commissionable, restaurantLocalizedInventoryConsumer.commissionable) && Objects.equals(this.commission, restaurantLocalizedInventoryConsumer.commission) && Objects.equals(this.priceList, restaurantLocalizedInventoryConsumer.priceList);
    }

    public int hashCode() {
        return Objects.hash(this.restaurant, this._list, this.channelInventoryIdentifier, this.commissionable, this.commission, this.priceList);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RestaurantLocalizedInventoryConsumer {\n");
        sb.append("    restaurant: ").append(this.toIndentedString(this.restaurant)).append("\n");
        sb.append("    _list: ").append(this.toIndentedString(this._list)).append("\n");
        sb.append("    channelInventoryIdentifier: ").append(this.toIndentedString(this.channelInventoryIdentifier)).append("\n");
        sb.append("    commissionable: ").append(this.toIndentedString(this.commissionable)).append("\n");
        sb.append("    commission: ").append(this.toIndentedString(this.commission)).append("\n");
        sb.append("    priceList: ").append(this.toIndentedString(this.priceList)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

