/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.inventory.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.validation.Valid;
import travel.wink.sdk.inventory.model.MoneysConsumer;
import travel.wink.sdk.inventory.model.QuoteConsumer;
import travel.wink.sdk.inventory.model.SimpleDescriptionConsumer;

@ApiModel(description="Calculated price")
@JsonPropertyOrder(value={"userSpecifiedCurrencyBaseTotal", "sourceBaseTotal", "internalBaseTotal", "sourceExtraPaxModifier", "internalExtraPaxModifier", "userSpecifiedCurrencyExtraPaxModifier", "sourceExtraChildModifier", "internalExtraChildModifier", "userSpecifiedCurrencyExtraChildModifier", "sourceSingleOccupantModifier", "internalSingleOccupantModifier", "userSpecifiedCurrencySingleOccupantModifier", "sourcePromotionalModifier", "internalPromotionalModifier", "userSpecifiedCurrencyPromotionalModifier", "sourcePremiumModifier", "internalPremiumModifier", "userSpecifiedCurrencyPremiumModifier", "sourceChannelModifier", "internalChannelModifier", "userSpecifiedCurrencyChannelModifier", "quantity", "minOccupancy", "maxOccupancy", "rateSource", "promotionalDiscountPercent", "channelDiscountPercent", "premiumPercent", "available", "sourceToUserCurrencyQuote", "sourceToInternalCurrencyQuote", "offerDetails", "promotionalCodes", "userSpecifiedCurrencyAveragePricePerNight", "internalAveragePricePerNight", "sourceAveragePricePerNight", "totalDiscountPercent", "sourceTotal", "userSpecifiedCurrencyTotal", "internalTotal"})
@JsonTypeName(value="StayRate_Consumer")
public class StayRateConsumer {
    public static final String JSON_PROPERTY_USER_SPECIFIED_CURRENCY_BASE_TOTAL = "userSpecifiedCurrencyBaseTotal";
    private MoneysConsumer userSpecifiedCurrencyBaseTotal;
    public static final String JSON_PROPERTY_SOURCE_BASE_TOTAL = "sourceBaseTotal";
    private MoneysConsumer sourceBaseTotal;
    public static final String JSON_PROPERTY_INTERNAL_BASE_TOTAL = "internalBaseTotal";
    private MoneysConsumer internalBaseTotal;
    public static final String JSON_PROPERTY_SOURCE_EXTRA_PAX_MODIFIER = "sourceExtraPaxModifier";
    private Double sourceExtraPaxModifier;
    public static final String JSON_PROPERTY_INTERNAL_EXTRA_PAX_MODIFIER = "internalExtraPaxModifier";
    private Double internalExtraPaxModifier;
    public static final String JSON_PROPERTY_USER_SPECIFIED_CURRENCY_EXTRA_PAX_MODIFIER = "userSpecifiedCurrencyExtraPaxModifier";
    private Double userSpecifiedCurrencyExtraPaxModifier;
    public static final String JSON_PROPERTY_SOURCE_EXTRA_CHILD_MODIFIER = "sourceExtraChildModifier";
    private Double sourceExtraChildModifier;
    public static final String JSON_PROPERTY_INTERNAL_EXTRA_CHILD_MODIFIER = "internalExtraChildModifier";
    private Double internalExtraChildModifier;
    public static final String JSON_PROPERTY_USER_SPECIFIED_CURRENCY_EXTRA_CHILD_MODIFIER = "userSpecifiedCurrencyExtraChildModifier";
    private Double userSpecifiedCurrencyExtraChildModifier;
    public static final String JSON_PROPERTY_SOURCE_SINGLE_OCCUPANT_MODIFIER = "sourceSingleOccupantModifier";
    private Double sourceSingleOccupantModifier;
    public static final String JSON_PROPERTY_INTERNAL_SINGLE_OCCUPANT_MODIFIER = "internalSingleOccupantModifier";
    private Double internalSingleOccupantModifier;
    public static final String JSON_PROPERTY_USER_SPECIFIED_CURRENCY_SINGLE_OCCUPANT_MODIFIER = "userSpecifiedCurrencySingleOccupantModifier";
    private Double userSpecifiedCurrencySingleOccupantModifier;
    public static final String JSON_PROPERTY_SOURCE_PROMOTIONAL_MODIFIER = "sourcePromotionalModifier";
    private Double sourcePromotionalModifier;
    public static final String JSON_PROPERTY_INTERNAL_PROMOTIONAL_MODIFIER = "internalPromotionalModifier";
    private Double internalPromotionalModifier;
    public static final String JSON_PROPERTY_USER_SPECIFIED_CURRENCY_PROMOTIONAL_MODIFIER = "userSpecifiedCurrencyPromotionalModifier";
    private Double userSpecifiedCurrencyPromotionalModifier;
    public static final String JSON_PROPERTY_SOURCE_PREMIUM_MODIFIER = "sourcePremiumModifier";
    private Double sourcePremiumModifier;
    public static final String JSON_PROPERTY_INTERNAL_PREMIUM_MODIFIER = "internalPremiumModifier";
    private Double internalPremiumModifier;
    public static final String JSON_PROPERTY_USER_SPECIFIED_CURRENCY_PREMIUM_MODIFIER = "userSpecifiedCurrencyPremiumModifier";
    private Double userSpecifiedCurrencyPremiumModifier;
    public static final String JSON_PROPERTY_SOURCE_CHANNEL_MODIFIER = "sourceChannelModifier";
    private Double sourceChannelModifier;
    public static final String JSON_PROPERTY_INTERNAL_CHANNEL_MODIFIER = "internalChannelModifier";
    private Double internalChannelModifier;
    public static final String JSON_PROPERTY_USER_SPECIFIED_CURRENCY_CHANNEL_MODIFIER = "userSpecifiedCurrencyChannelModifier";
    private Double userSpecifiedCurrencyChannelModifier;
    public static final String JSON_PROPERTY_QUANTITY = "quantity";
    private Integer quantity;
    public static final String JSON_PROPERTY_MIN_OCCUPANCY = "minOccupancy";
    private Integer minOccupancy;
    public static final String JSON_PROPERTY_MAX_OCCUPANCY = "maxOccupancy";
    private Integer maxOccupancy;
    public static final String JSON_PROPERTY_RATE_SOURCE = "rateSource";
    private String rateSource;
    public static final String JSON_PROPERTY_PROMOTIONAL_DISCOUNT_PERCENT = "promotionalDiscountPercent";
    private Float promotionalDiscountPercent;
    public static final String JSON_PROPERTY_CHANNEL_DISCOUNT_PERCENT = "channelDiscountPercent";
    private Float channelDiscountPercent;
    public static final String JSON_PROPERTY_PREMIUM_PERCENT = "premiumPercent";
    private Float premiumPercent;
    public static final String JSON_PROPERTY_AVAILABLE = "available";
    private Boolean available;
    public static final String JSON_PROPERTY_SOURCE_TO_USER_CURRENCY_QUOTE = "sourceToUserCurrencyQuote";
    private QuoteConsumer sourceToUserCurrencyQuote;
    public static final String JSON_PROPERTY_SOURCE_TO_INTERNAL_CURRENCY_QUOTE = "sourceToInternalCurrencyQuote";
    private QuoteConsumer sourceToInternalCurrencyQuote;
    public static final String JSON_PROPERTY_OFFER_DETAILS = "offerDetails";
    private List<SimpleDescriptionConsumer> offerDetails = null;
    public static final String JSON_PROPERTY_PROMOTIONAL_CODES = "promotionalCodes";
    private List<String> promotionalCodes = null;
    public static final String JSON_PROPERTY_USER_SPECIFIED_CURRENCY_AVERAGE_PRICE_PER_NIGHT = "userSpecifiedCurrencyAveragePricePerNight";
    private MoneysConsumer userSpecifiedCurrencyAveragePricePerNight;
    public static final String JSON_PROPERTY_INTERNAL_AVERAGE_PRICE_PER_NIGHT = "internalAveragePricePerNight";
    private MoneysConsumer internalAveragePricePerNight;
    public static final String JSON_PROPERTY_SOURCE_AVERAGE_PRICE_PER_NIGHT = "sourceAveragePricePerNight";
    private MoneysConsumer sourceAveragePricePerNight;
    public static final String JSON_PROPERTY_TOTAL_DISCOUNT_PERCENT = "totalDiscountPercent";
    private Float totalDiscountPercent;
    public static final String JSON_PROPERTY_SOURCE_TOTAL = "sourceTotal";
    private MoneysConsumer sourceTotal;
    public static final String JSON_PROPERTY_USER_SPECIFIED_CURRENCY_TOTAL = "userSpecifiedCurrencyTotal";
    private MoneysConsumer userSpecifiedCurrencyTotal;
    public static final String JSON_PROPERTY_INTERNAL_TOTAL = "internalTotal";
    private MoneysConsumer internalTotal;

    public StayRateConsumer userSpecifiedCurrencyBaseTotal(MoneysConsumer userSpecifiedCurrencyBaseTotal) {
        this.userSpecifiedCurrencyBaseTotal = userSpecifiedCurrencyBaseTotal;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="userSpecifiedCurrencyBaseTotal")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MoneysConsumer getUserSpecifiedCurrencyBaseTotal() {
        return this.userSpecifiedCurrencyBaseTotal;
    }

    @JsonProperty(value="userSpecifiedCurrencyBaseTotal")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUserSpecifiedCurrencyBaseTotal(MoneysConsumer userSpecifiedCurrencyBaseTotal) {
        this.userSpecifiedCurrencyBaseTotal = userSpecifiedCurrencyBaseTotal;
    }

    public StayRateConsumer sourceBaseTotal(MoneysConsumer sourceBaseTotal) {
        this.sourceBaseTotal = sourceBaseTotal;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="sourceBaseTotal")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MoneysConsumer getSourceBaseTotal() {
        return this.sourceBaseTotal;
    }

    @JsonProperty(value="sourceBaseTotal")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSourceBaseTotal(MoneysConsumer sourceBaseTotal) {
        this.sourceBaseTotal = sourceBaseTotal;
    }

    public StayRateConsumer internalBaseTotal(MoneysConsumer internalBaseTotal) {
        this.internalBaseTotal = internalBaseTotal;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="internalBaseTotal")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MoneysConsumer getInternalBaseTotal() {
        return this.internalBaseTotal;
    }

    @JsonProperty(value="internalBaseTotal")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInternalBaseTotal(MoneysConsumer internalBaseTotal) {
        this.internalBaseTotal = internalBaseTotal;
    }

    public StayRateConsumer sourceExtraPaxModifier(Double sourceExtraPaxModifier) {
        this.sourceExtraPaxModifier = sourceExtraPaxModifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="15", value="Extra person modifier in hotel currency.")
    @JsonProperty(value="sourceExtraPaxModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getSourceExtraPaxModifier() {
        return this.sourceExtraPaxModifier;
    }

    @JsonProperty(value="sourceExtraPaxModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSourceExtraPaxModifier(Double sourceExtraPaxModifier) {
        this.sourceExtraPaxModifier = sourceExtraPaxModifier;
    }

    public StayRateConsumer internalExtraPaxModifier(Double internalExtraPaxModifier) {
        this.internalExtraPaxModifier = internalExtraPaxModifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="15", value="Extra person modifier in wink currency")
    @JsonProperty(value="internalExtraPaxModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getInternalExtraPaxModifier() {
        return this.internalExtraPaxModifier;
    }

    @JsonProperty(value="internalExtraPaxModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInternalExtraPaxModifier(Double internalExtraPaxModifier) {
        this.internalExtraPaxModifier = internalExtraPaxModifier;
    }

    public StayRateConsumer userSpecifiedCurrencyExtraPaxModifier(Double userSpecifiedCurrencyExtraPaxModifier) {
        this.userSpecifiedCurrencyExtraPaxModifier = userSpecifiedCurrencyExtraPaxModifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="15", value="Extra person modifier in user specified currency")
    @JsonProperty(value="userSpecifiedCurrencyExtraPaxModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getUserSpecifiedCurrencyExtraPaxModifier() {
        return this.userSpecifiedCurrencyExtraPaxModifier;
    }

    @JsonProperty(value="userSpecifiedCurrencyExtraPaxModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUserSpecifiedCurrencyExtraPaxModifier(Double userSpecifiedCurrencyExtraPaxModifier) {
        this.userSpecifiedCurrencyExtraPaxModifier = userSpecifiedCurrencyExtraPaxModifier;
    }

    public StayRateConsumer sourceExtraChildModifier(Double sourceExtraChildModifier) {
        this.sourceExtraChildModifier = sourceExtraChildModifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="15", value="Extra child modifier in hotel currency")
    @JsonProperty(value="sourceExtraChildModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getSourceExtraChildModifier() {
        return this.sourceExtraChildModifier;
    }

    @JsonProperty(value="sourceExtraChildModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSourceExtraChildModifier(Double sourceExtraChildModifier) {
        this.sourceExtraChildModifier = sourceExtraChildModifier;
    }

    public StayRateConsumer internalExtraChildModifier(Double internalExtraChildModifier) {
        this.internalExtraChildModifier = internalExtraChildModifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="15", value="Extra child modifier in wink currency")
    @JsonProperty(value="internalExtraChildModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getInternalExtraChildModifier() {
        return this.internalExtraChildModifier;
    }

    @JsonProperty(value="internalExtraChildModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInternalExtraChildModifier(Double internalExtraChildModifier) {
        this.internalExtraChildModifier = internalExtraChildModifier;
    }

    public StayRateConsumer userSpecifiedCurrencyExtraChildModifier(Double userSpecifiedCurrencyExtraChildModifier) {
        this.userSpecifiedCurrencyExtraChildModifier = userSpecifiedCurrencyExtraChildModifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="15", value="Extra child modifier in user specified currcency")
    @JsonProperty(value="userSpecifiedCurrencyExtraChildModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getUserSpecifiedCurrencyExtraChildModifier() {
        return this.userSpecifiedCurrencyExtraChildModifier;
    }

    @JsonProperty(value="userSpecifiedCurrencyExtraChildModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUserSpecifiedCurrencyExtraChildModifier(Double userSpecifiedCurrencyExtraChildModifier) {
        this.userSpecifiedCurrencyExtraChildModifier = userSpecifiedCurrencyExtraChildModifier;
    }

    public StayRateConsumer sourceSingleOccupantModifier(Double sourceSingleOccupantModifier) {
        this.sourceSingleOccupantModifier = sourceSingleOccupantModifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="-15", value="Single occupant modifier in hotel currency")
    @JsonProperty(value="sourceSingleOccupantModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getSourceSingleOccupantModifier() {
        return this.sourceSingleOccupantModifier;
    }

    @JsonProperty(value="sourceSingleOccupantModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSourceSingleOccupantModifier(Double sourceSingleOccupantModifier) {
        this.sourceSingleOccupantModifier = sourceSingleOccupantModifier;
    }

    public StayRateConsumer internalSingleOccupantModifier(Double internalSingleOccupantModifier) {
        this.internalSingleOccupantModifier = internalSingleOccupantModifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="-15", value="Singe occupant modifier in wink currency")
    @JsonProperty(value="internalSingleOccupantModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getInternalSingleOccupantModifier() {
        return this.internalSingleOccupantModifier;
    }

    @JsonProperty(value="internalSingleOccupantModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInternalSingleOccupantModifier(Double internalSingleOccupantModifier) {
        this.internalSingleOccupantModifier = internalSingleOccupantModifier;
    }

    public StayRateConsumer userSpecifiedCurrencySingleOccupantModifier(Double userSpecifiedCurrencySingleOccupantModifier) {
        this.userSpecifiedCurrencySingleOccupantModifier = userSpecifiedCurrencySingleOccupantModifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="-15", value="Single occupant modifier in user specified currency")
    @JsonProperty(value="userSpecifiedCurrencySingleOccupantModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getUserSpecifiedCurrencySingleOccupantModifier() {
        return this.userSpecifiedCurrencySingleOccupantModifier;
    }

    @JsonProperty(value="userSpecifiedCurrencySingleOccupantModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUserSpecifiedCurrencySingleOccupantModifier(Double userSpecifiedCurrencySingleOccupantModifier) {
        this.userSpecifiedCurrencySingleOccupantModifier = userSpecifiedCurrencySingleOccupantModifier;
    }

    public StayRateConsumer sourcePromotionalModifier(Double sourcePromotionalModifier) {
        this.sourcePromotionalModifier = sourcePromotionalModifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="-40", value="Rate discount modifiers in hotel currency")
    @JsonProperty(value="sourcePromotionalModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getSourcePromotionalModifier() {
        return this.sourcePromotionalModifier;
    }

    @JsonProperty(value="sourcePromotionalModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSourcePromotionalModifier(Double sourcePromotionalModifier) {
        this.sourcePromotionalModifier = sourcePromotionalModifier;
    }

    public StayRateConsumer internalPromotionalModifier(Double internalPromotionalModifier) {
        this.internalPromotionalModifier = internalPromotionalModifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="-40", value="Rate discount modifiers in wink currency")
    @JsonProperty(value="internalPromotionalModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getInternalPromotionalModifier() {
        return this.internalPromotionalModifier;
    }

    @JsonProperty(value="internalPromotionalModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInternalPromotionalModifier(Double internalPromotionalModifier) {
        this.internalPromotionalModifier = internalPromotionalModifier;
    }

    public StayRateConsumer userSpecifiedCurrencyPromotionalModifier(Double userSpecifiedCurrencyPromotionalModifier) {
        this.userSpecifiedCurrencyPromotionalModifier = userSpecifiedCurrencyPromotionalModifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="-40", value="Rate discount modifiers in user specified currency")
    @JsonProperty(value="userSpecifiedCurrencyPromotionalModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getUserSpecifiedCurrencyPromotionalModifier() {
        return this.userSpecifiedCurrencyPromotionalModifier;
    }

    @JsonProperty(value="userSpecifiedCurrencyPromotionalModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUserSpecifiedCurrencyPromotionalModifier(Double userSpecifiedCurrencyPromotionalModifier) {
        this.userSpecifiedCurrencyPromotionalModifier = userSpecifiedCurrencyPromotionalModifier;
    }

    public StayRateConsumer sourcePremiumModifier(Double sourcePremiumModifier) {
        this.sourcePremiumModifier = sourcePremiumModifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="40", value="Rate premiums modifiers in hotel currency")
    @JsonProperty(value="sourcePremiumModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getSourcePremiumModifier() {
        return this.sourcePremiumModifier;
    }

    @JsonProperty(value="sourcePremiumModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSourcePremiumModifier(Double sourcePremiumModifier) {
        this.sourcePremiumModifier = sourcePremiumModifier;
    }

    public StayRateConsumer internalPremiumModifier(Double internalPremiumModifier) {
        this.internalPremiumModifier = internalPremiumModifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="40", value="Rate premiums modifiers in wink currency")
    @JsonProperty(value="internalPremiumModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getInternalPremiumModifier() {
        return this.internalPremiumModifier;
    }

    @JsonProperty(value="internalPremiumModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInternalPremiumModifier(Double internalPremiumModifier) {
        this.internalPremiumModifier = internalPremiumModifier;
    }

    public StayRateConsumer userSpecifiedCurrencyPremiumModifier(Double userSpecifiedCurrencyPremiumModifier) {
        this.userSpecifiedCurrencyPremiumModifier = userSpecifiedCurrencyPremiumModifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="40", value="Rate premiums modifiers in user specified currency")
    @JsonProperty(value="userSpecifiedCurrencyPremiumModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getUserSpecifiedCurrencyPremiumModifier() {
        return this.userSpecifiedCurrencyPremiumModifier;
    }

    @JsonProperty(value="userSpecifiedCurrencyPremiumModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUserSpecifiedCurrencyPremiumModifier(Double userSpecifiedCurrencyPremiumModifier) {
        this.userSpecifiedCurrencyPremiumModifier = userSpecifiedCurrencyPremiumModifier;
    }

    public StayRateConsumer sourceChannelModifier(Double sourceChannelModifier) {
        this.sourceChannelModifier = sourceChannelModifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="-10", value="Channel / Membership modifier in hotel currency")
    @JsonProperty(value="sourceChannelModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getSourceChannelModifier() {
        return this.sourceChannelModifier;
    }

    @JsonProperty(value="sourceChannelModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSourceChannelModifier(Double sourceChannelModifier) {
        this.sourceChannelModifier = sourceChannelModifier;
    }

    public StayRateConsumer internalChannelModifier(Double internalChannelModifier) {
        this.internalChannelModifier = internalChannelModifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="-10", value="Channel / Membership modifier in wink currency")
    @JsonProperty(value="internalChannelModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getInternalChannelModifier() {
        return this.internalChannelModifier;
    }

    @JsonProperty(value="internalChannelModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInternalChannelModifier(Double internalChannelModifier) {
        this.internalChannelModifier = internalChannelModifier;
    }

    public StayRateConsumer userSpecifiedCurrencyChannelModifier(Double userSpecifiedCurrencyChannelModifier) {
        this.userSpecifiedCurrencyChannelModifier = userSpecifiedCurrencyChannelModifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="-10", value="Channel / Membership modifier in user specified currency")
    @JsonProperty(value="userSpecifiedCurrencyChannelModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getUserSpecifiedCurrencyChannelModifier() {
        return this.userSpecifiedCurrencyChannelModifier;
    }

    @JsonProperty(value="userSpecifiedCurrencyChannelModifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUserSpecifiedCurrencyChannelModifier(Double userSpecifiedCurrencyChannelModifier) {
        this.userSpecifiedCurrencyChannelModifier = userSpecifiedCurrencyChannelModifier;
    }

    public StayRateConsumer quantity(Integer quantity) {
        this.quantity = quantity;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Quantity")
    @JsonProperty(value="quantity")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getQuantity() {
        return this.quantity;
    }

    @JsonProperty(value="quantity")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    public StayRateConsumer minOccupancy(Integer minOccupancy) {
        this.minOccupancy = minOccupancy;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Minimum occupancy")
    @JsonProperty(value="minOccupancy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getMinOccupancy() {
        return this.minOccupancy;
    }

    @JsonProperty(value="minOccupancy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMinOccupancy(Integer minOccupancy) {
        this.minOccupancy = minOccupancy;
    }

    public StayRateConsumer maxOccupancy(Integer maxOccupancy) {
        this.maxOccupancy = maxOccupancy;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Maximum occupancy")
    @JsonProperty(value="maxOccupancy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getMaxOccupancy() {
        return this.maxOccupancy;
    }

    @JsonProperty(value="maxOccupancy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMaxOccupancy(Integer maxOccupancy) {
        this.maxOccupancy = maxOccupancy;
    }

    public StayRateConsumer rateSource(String rateSource) {
        this.rateSource = rateSource;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Source")
    @JsonProperty(value="rateSource")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRateSource() {
        return this.rateSource;
    }

    @JsonProperty(value="rateSource")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRateSource(String rateSource) {
        this.rateSource = rateSource;
    }

    public StayRateConsumer promotionalDiscountPercent(Float promotionalDiscountPercent) {
        this.promotionalDiscountPercent = promotionalDiscountPercent;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Promotional discount percent")
    @JsonProperty(value="promotionalDiscountPercent")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Float getPromotionalDiscountPercent() {
        return this.promotionalDiscountPercent;
    }

    @JsonProperty(value="promotionalDiscountPercent")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPromotionalDiscountPercent(Float promotionalDiscountPercent) {
        this.promotionalDiscountPercent = promotionalDiscountPercent;
    }

    public StayRateConsumer channelDiscountPercent(Float channelDiscountPercent) {
        this.channelDiscountPercent = channelDiscountPercent;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Chanel discount percent")
    @JsonProperty(value="channelDiscountPercent")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Float getChannelDiscountPercent() {
        return this.channelDiscountPercent;
    }

    @JsonProperty(value="channelDiscountPercent")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setChannelDiscountPercent(Float channelDiscountPercent) {
        this.channelDiscountPercent = channelDiscountPercent;
    }

    public StayRateConsumer premiumPercent(Float premiumPercent) {
        this.premiumPercent = premiumPercent;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Premium percent")
    @JsonProperty(value="premiumPercent")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Float getPremiumPercent() {
        return this.premiumPercent;
    }

    @JsonProperty(value="premiumPercent")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPremiumPercent(Float premiumPercent) {
        this.premiumPercent = premiumPercent;
    }

    public StayRateConsumer available(Boolean available) {
        this.available = available;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Available")
    @JsonProperty(value="available")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getAvailable() {
        return this.available;
    }

    @JsonProperty(value="available")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAvailable(Boolean available) {
        this.available = available;
    }

    public StayRateConsumer sourceToUserCurrencyQuote(QuoteConsumer sourceToUserCurrencyQuote) {
        this.sourceToUserCurrencyQuote = sourceToUserCurrencyQuote;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="sourceToUserCurrencyQuote")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public QuoteConsumer getSourceToUserCurrencyQuote() {
        return this.sourceToUserCurrencyQuote;
    }

    @JsonProperty(value="sourceToUserCurrencyQuote")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSourceToUserCurrencyQuote(QuoteConsumer sourceToUserCurrencyQuote) {
        this.sourceToUserCurrencyQuote = sourceToUserCurrencyQuote;
    }

    public StayRateConsumer sourceToInternalCurrencyQuote(QuoteConsumer sourceToInternalCurrencyQuote) {
        this.sourceToInternalCurrencyQuote = sourceToInternalCurrencyQuote;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="sourceToInternalCurrencyQuote")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public QuoteConsumer getSourceToInternalCurrencyQuote() {
        return this.sourceToInternalCurrencyQuote;
    }

    @JsonProperty(value="sourceToInternalCurrencyQuote")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSourceToInternalCurrencyQuote(QuoteConsumer sourceToInternalCurrencyQuote) {
        this.sourceToInternalCurrencyQuote = sourceToInternalCurrencyQuote;
    }

    public StayRateConsumer offerDetails(List<SimpleDescriptionConsumer> offerDetails) {
        this.offerDetails = offerDetails;
        return this;
    }

    public StayRateConsumer addOfferDetailsItem(SimpleDescriptionConsumer offerDetailsItem) {
        if (this.offerDetails == null) {
            this.offerDetails = new ArrayList<SimpleDescriptionConsumer>();
        }
        this.offerDetails.add(offerDetailsItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Localized text of the discount")
    @JsonProperty(value="offerDetails")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SimpleDescriptionConsumer> getOfferDetails() {
        return this.offerDetails;
    }

    @JsonProperty(value="offerDetails")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOfferDetails(List<SimpleDescriptionConsumer> offerDetails) {
        this.offerDetails = offerDetails;
    }

    public StayRateConsumer promotionalCodes(List<String> promotionalCodes) {
        this.promotionalCodes = promotionalCodes;
        return this;
    }

    public StayRateConsumer addPromotionalCodesItem(String promotionalCodesItem) {
        if (this.promotionalCodes == null) {
            this.promotionalCodes = new ArrayList<String>();
        }
        this.promotionalCodes.add(promotionalCodesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Promotional codes")
    @JsonProperty(value="promotionalCodes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getPromotionalCodes() {
        return this.promotionalCodes;
    }

    @JsonProperty(value="promotionalCodes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPromotionalCodes(List<String> promotionalCodes) {
        this.promotionalCodes = promotionalCodes;
    }

    public StayRateConsumer userSpecifiedCurrencyAveragePricePerNight(MoneysConsumer userSpecifiedCurrencyAveragePricePerNight) {
        this.userSpecifiedCurrencyAveragePricePerNight = userSpecifiedCurrencyAveragePricePerNight;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="userSpecifiedCurrencyAveragePricePerNight")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MoneysConsumer getUserSpecifiedCurrencyAveragePricePerNight() {
        return this.userSpecifiedCurrencyAveragePricePerNight;
    }

    @JsonProperty(value="userSpecifiedCurrencyAveragePricePerNight")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUserSpecifiedCurrencyAveragePricePerNight(MoneysConsumer userSpecifiedCurrencyAveragePricePerNight) {
        this.userSpecifiedCurrencyAveragePricePerNight = userSpecifiedCurrencyAveragePricePerNight;
    }

    public StayRateConsumer internalAveragePricePerNight(MoneysConsumer internalAveragePricePerNight) {
        this.internalAveragePricePerNight = internalAveragePricePerNight;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="internalAveragePricePerNight")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MoneysConsumer getInternalAveragePricePerNight() {
        return this.internalAveragePricePerNight;
    }

    @JsonProperty(value="internalAveragePricePerNight")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInternalAveragePricePerNight(MoneysConsumer internalAveragePricePerNight) {
        this.internalAveragePricePerNight = internalAveragePricePerNight;
    }

    public StayRateConsumer sourceAveragePricePerNight(MoneysConsumer sourceAveragePricePerNight) {
        this.sourceAveragePricePerNight = sourceAveragePricePerNight;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="sourceAveragePricePerNight")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MoneysConsumer getSourceAveragePricePerNight() {
        return this.sourceAveragePricePerNight;
    }

    @JsonProperty(value="sourceAveragePricePerNight")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSourceAveragePricePerNight(MoneysConsumer sourceAveragePricePerNight) {
        this.sourceAveragePricePerNight = sourceAveragePricePerNight;
    }

    public StayRateConsumer totalDiscountPercent(Float totalDiscountPercent) {
        this.totalDiscountPercent = totalDiscountPercent;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="totalDiscountPercent")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Float getTotalDiscountPercent() {
        return this.totalDiscountPercent;
    }

    @JsonProperty(value="totalDiscountPercent")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalDiscountPercent(Float totalDiscountPercent) {
        this.totalDiscountPercent = totalDiscountPercent;
    }

    public StayRateConsumer sourceTotal(MoneysConsumer sourceTotal) {
        this.sourceTotal = sourceTotal;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="sourceTotal")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MoneysConsumer getSourceTotal() {
        return this.sourceTotal;
    }

    @JsonProperty(value="sourceTotal")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSourceTotal(MoneysConsumer sourceTotal) {
        this.sourceTotal = sourceTotal;
    }

    public StayRateConsumer userSpecifiedCurrencyTotal(MoneysConsumer userSpecifiedCurrencyTotal) {
        this.userSpecifiedCurrencyTotal = userSpecifiedCurrencyTotal;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="userSpecifiedCurrencyTotal")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MoneysConsumer getUserSpecifiedCurrencyTotal() {
        return this.userSpecifiedCurrencyTotal;
    }

    @JsonProperty(value="userSpecifiedCurrencyTotal")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUserSpecifiedCurrencyTotal(MoneysConsumer userSpecifiedCurrencyTotal) {
        this.userSpecifiedCurrencyTotal = userSpecifiedCurrencyTotal;
    }

    public StayRateConsumer internalTotal(MoneysConsumer internalTotal) {
        this.internalTotal = internalTotal;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="internalTotal")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MoneysConsumer getInternalTotal() {
        return this.internalTotal;
    }

    @JsonProperty(value="internalTotal")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInternalTotal(MoneysConsumer internalTotal) {
        this.internalTotal = internalTotal;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StayRateConsumer stayRateConsumer = (StayRateConsumer)o;
        return Objects.equals(this.userSpecifiedCurrencyBaseTotal, stayRateConsumer.userSpecifiedCurrencyBaseTotal) && Objects.equals(this.sourceBaseTotal, stayRateConsumer.sourceBaseTotal) && Objects.equals(this.internalBaseTotal, stayRateConsumer.internalBaseTotal) && Objects.equals(this.sourceExtraPaxModifier, stayRateConsumer.sourceExtraPaxModifier) && Objects.equals(this.internalExtraPaxModifier, stayRateConsumer.internalExtraPaxModifier) && Objects.equals(this.userSpecifiedCurrencyExtraPaxModifier, stayRateConsumer.userSpecifiedCurrencyExtraPaxModifier) && Objects.equals(this.sourceExtraChildModifier, stayRateConsumer.sourceExtraChildModifier) && Objects.equals(this.internalExtraChildModifier, stayRateConsumer.internalExtraChildModifier) && Objects.equals(this.userSpecifiedCurrencyExtraChildModifier, stayRateConsumer.userSpecifiedCurrencyExtraChildModifier) && Objects.equals(this.sourceSingleOccupantModifier, stayRateConsumer.sourceSingleOccupantModifier) && Objects.equals(this.internalSingleOccupantModifier, stayRateConsumer.internalSingleOccupantModifier) && Objects.equals(this.userSpecifiedCurrencySingleOccupantModifier, stayRateConsumer.userSpecifiedCurrencySingleOccupantModifier) && Objects.equals(this.sourcePromotionalModifier, stayRateConsumer.sourcePromotionalModifier) && Objects.equals(this.internalPromotionalModifier, stayRateConsumer.internalPromotionalModifier) && Objects.equals(this.userSpecifiedCurrencyPromotionalModifier, stayRateConsumer.userSpecifiedCurrencyPromotionalModifier) && Objects.equals(this.sourcePremiumModifier, stayRateConsumer.sourcePremiumModifier) && Objects.equals(this.internalPremiumModifier, stayRateConsumer.internalPremiumModifier) && Objects.equals(this.userSpecifiedCurrencyPremiumModifier, stayRateConsumer.userSpecifiedCurrencyPremiumModifier) && Objects.equals(this.sourceChannelModifier, stayRateConsumer.sourceChannelModifier) && Objects.equals(this.internalChannelModifier, stayRateConsumer.internalChannelModifier) && Objects.equals(this.userSpecifiedCurrencyChannelModifier, stayRateConsumer.userSpecifiedCurrencyChannelModifier) && Objects.equals(this.quantity, stayRateConsumer.quantity) && Objects.equals(this.minOccupancy, stayRateConsumer.minOccupancy) && Objects.equals(this.maxOccupancy, stayRateConsumer.maxOccupancy) && Objects.equals(this.rateSource, stayRateConsumer.rateSource) && Objects.equals(this.promotionalDiscountPercent, stayRateConsumer.promotionalDiscountPercent) && Objects.equals(this.channelDiscountPercent, stayRateConsumer.channelDiscountPercent) && Objects.equals(this.premiumPercent, stayRateConsumer.premiumPercent) && Objects.equals(this.available, stayRateConsumer.available) && Objects.equals(this.sourceToUserCurrencyQuote, stayRateConsumer.sourceToUserCurrencyQuote) && Objects.equals(this.sourceToInternalCurrencyQuote, stayRateConsumer.sourceToInternalCurrencyQuote) && Objects.equals(this.offerDetails, stayRateConsumer.offerDetails) && Objects.equals(this.promotionalCodes, stayRateConsumer.promotionalCodes) && Objects.equals(this.userSpecifiedCurrencyAveragePricePerNight, stayRateConsumer.userSpecifiedCurrencyAveragePricePerNight) && Objects.equals(this.internalAveragePricePerNight, stayRateConsumer.internalAveragePricePerNight) && Objects.equals(this.sourceAveragePricePerNight, stayRateConsumer.sourceAveragePricePerNight) && Objects.equals(this.totalDiscountPercent, stayRateConsumer.totalDiscountPercent) && Objects.equals(this.sourceTotal, stayRateConsumer.sourceTotal) && Objects.equals(this.userSpecifiedCurrencyTotal, stayRateConsumer.userSpecifiedCurrencyTotal) && Objects.equals(this.internalTotal, stayRateConsumer.internalTotal);
    }

    public int hashCode() {
        return Objects.hash(this.userSpecifiedCurrencyBaseTotal, this.sourceBaseTotal, this.internalBaseTotal, this.sourceExtraPaxModifier, this.internalExtraPaxModifier, this.userSpecifiedCurrencyExtraPaxModifier, this.sourceExtraChildModifier, this.internalExtraChildModifier, this.userSpecifiedCurrencyExtraChildModifier, this.sourceSingleOccupantModifier, this.internalSingleOccupantModifier, this.userSpecifiedCurrencySingleOccupantModifier, this.sourcePromotionalModifier, this.internalPromotionalModifier, this.userSpecifiedCurrencyPromotionalModifier, this.sourcePremiumModifier, this.internalPremiumModifier, this.userSpecifiedCurrencyPremiumModifier, this.sourceChannelModifier, this.internalChannelModifier, this.userSpecifiedCurrencyChannelModifier, this.quantity, this.minOccupancy, this.maxOccupancy, this.rateSource, this.promotionalDiscountPercent, this.channelDiscountPercent, this.premiumPercent, this.available, this.sourceToUserCurrencyQuote, this.sourceToInternalCurrencyQuote, this.offerDetails, this.promotionalCodes, this.userSpecifiedCurrencyAveragePricePerNight, this.internalAveragePricePerNight, this.sourceAveragePricePerNight, this.totalDiscountPercent, this.sourceTotal, this.userSpecifiedCurrencyTotal, this.internalTotal);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class StayRateConsumer {\n");
        sb.append("    userSpecifiedCurrencyBaseTotal: ").append(this.toIndentedString(this.userSpecifiedCurrencyBaseTotal)).append("\n");
        sb.append("    sourceBaseTotal: ").append(this.toIndentedString(this.sourceBaseTotal)).append("\n");
        sb.append("    internalBaseTotal: ").append(this.toIndentedString(this.internalBaseTotal)).append("\n");
        sb.append("    sourceExtraPaxModifier: ").append(this.toIndentedString(this.sourceExtraPaxModifier)).append("\n");
        sb.append("    internalExtraPaxModifier: ").append(this.toIndentedString(this.internalExtraPaxModifier)).append("\n");
        sb.append("    userSpecifiedCurrencyExtraPaxModifier: ").append(this.toIndentedString(this.userSpecifiedCurrencyExtraPaxModifier)).append("\n");
        sb.append("    sourceExtraChildModifier: ").append(this.toIndentedString(this.sourceExtraChildModifier)).append("\n");
        sb.append("    internalExtraChildModifier: ").append(this.toIndentedString(this.internalExtraChildModifier)).append("\n");
        sb.append("    userSpecifiedCurrencyExtraChildModifier: ").append(this.toIndentedString(this.userSpecifiedCurrencyExtraChildModifier)).append("\n");
        sb.append("    sourceSingleOccupantModifier: ").append(this.toIndentedString(this.sourceSingleOccupantModifier)).append("\n");
        sb.append("    internalSingleOccupantModifier: ").append(this.toIndentedString(this.internalSingleOccupantModifier)).append("\n");
        sb.append("    userSpecifiedCurrencySingleOccupantModifier: ").append(this.toIndentedString(this.userSpecifiedCurrencySingleOccupantModifier)).append("\n");
        sb.append("    sourcePromotionalModifier: ").append(this.toIndentedString(this.sourcePromotionalModifier)).append("\n");
        sb.append("    internalPromotionalModifier: ").append(this.toIndentedString(this.internalPromotionalModifier)).append("\n");
        sb.append("    userSpecifiedCurrencyPromotionalModifier: ").append(this.toIndentedString(this.userSpecifiedCurrencyPromotionalModifier)).append("\n");
        sb.append("    sourcePremiumModifier: ").append(this.toIndentedString(this.sourcePremiumModifier)).append("\n");
        sb.append("    internalPremiumModifier: ").append(this.toIndentedString(this.internalPremiumModifier)).append("\n");
        sb.append("    userSpecifiedCurrencyPremiumModifier: ").append(this.toIndentedString(this.userSpecifiedCurrencyPremiumModifier)).append("\n");
        sb.append("    sourceChannelModifier: ").append(this.toIndentedString(this.sourceChannelModifier)).append("\n");
        sb.append("    internalChannelModifier: ").append(this.toIndentedString(this.internalChannelModifier)).append("\n");
        sb.append("    userSpecifiedCurrencyChannelModifier: ").append(this.toIndentedString(this.userSpecifiedCurrencyChannelModifier)).append("\n");
        sb.append("    quantity: ").append(this.toIndentedString(this.quantity)).append("\n");
        sb.append("    minOccupancy: ").append(this.toIndentedString(this.minOccupancy)).append("\n");
        sb.append("    maxOccupancy: ").append(this.toIndentedString(this.maxOccupancy)).append("\n");
        sb.append("    rateSource: ").append(this.toIndentedString(this.rateSource)).append("\n");
        sb.append("    promotionalDiscountPercent: ").append(this.toIndentedString(this.promotionalDiscountPercent)).append("\n");
        sb.append("    channelDiscountPercent: ").append(this.toIndentedString(this.channelDiscountPercent)).append("\n");
        sb.append("    premiumPercent: ").append(this.toIndentedString(this.premiumPercent)).append("\n");
        sb.append("    available: ").append(this.toIndentedString(this.available)).append("\n");
        sb.append("    sourceToUserCurrencyQuote: ").append(this.toIndentedString(this.sourceToUserCurrencyQuote)).append("\n");
        sb.append("    sourceToInternalCurrencyQuote: ").append(this.toIndentedString(this.sourceToInternalCurrencyQuote)).append("\n");
        sb.append("    offerDetails: ").append(this.toIndentedString(this.offerDetails)).append("\n");
        sb.append("    promotionalCodes: ").append(this.toIndentedString(this.promotionalCodes)).append("\n");
        sb.append("    userSpecifiedCurrencyAveragePricePerNight: ").append(this.toIndentedString(this.userSpecifiedCurrencyAveragePricePerNight)).append("\n");
        sb.append("    internalAveragePricePerNight: ").append(this.toIndentedString(this.internalAveragePricePerNight)).append("\n");
        sb.append("    sourceAveragePricePerNight: ").append(this.toIndentedString(this.sourceAveragePricePerNight)).append("\n");
        sb.append("    totalDiscountPercent: ").append(this.toIndentedString(this.totalDiscountPercent)).append("\n");
        sb.append("    sourceTotal: ").append(this.toIndentedString(this.sourceTotal)).append("\n");
        sb.append("    userSpecifiedCurrencyTotal: ").append(this.toIndentedString(this.userSpecifiedCurrencyTotal)).append("\n");
        sb.append("    internalTotal: ").append(this.toIndentedString(this.internalTotal)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

