/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release   # Inventory API Welcome to the Inventory API - A programmer-friendly way to retrieve known travel inventory as it was officially located using the Lookup API. We take great care in only working with properties that have quality, curated content and ways to bundle and cross sell customers with ancillary products and experiences. Suppliers have the ability to make their inventory look great and be searchable in a wide variety of ways. You can work with suppliers directly or receive payment-level pricing available to all our integration partners.  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory. Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - OTAs that want access direct relationships with suppliers and better quality hotel inventory 
 *
 * The version of the OpenAPI document: 25.2.3
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.inventory.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import travel.wink.sdk.inventory.model.LocalizedTransactionalTravelInventoryConsumer;
import travel.wink.sdk.inventory.model.SpaConsumer;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * List of property spas on and off the premises.
 */
@JsonPropertyOrder({
  SpaLocalizedInventoryConsumer.JSON_PROPERTY_CHANNEL_INVENTORY_IDENTIFIER,
  SpaLocalizedInventoryConsumer.JSON_PROPERTY_PRICE_LIST,
  SpaLocalizedInventoryConsumer.JSON_PROPERTY_COMMISSIONABLE,
  SpaLocalizedInventoryConsumer.JSON_PROPERTY_COMMISSION,
  SpaLocalizedInventoryConsumer.JSON_PROPERTY_SPA
})
@JsonTypeName("SpaLocalizedInventory_Consumer")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-04-12T17:37:39.240503524+07:00[Asia/Bangkok]")
public class SpaLocalizedInventoryConsumer {
  public static final String JSON_PROPERTY_CHANNEL_INVENTORY_IDENTIFIER = "channelInventoryIdentifier";
  private UUID channelInventoryIdentifier;

  public static final String JSON_PROPERTY_PRICE_LIST = "priceList";
  private List<LocalizedTransactionalTravelInventoryConsumer> priceList = new ArrayList<>();

  public static final String JSON_PROPERTY_COMMISSIONABLE = "commissionable";
  private Boolean commissionable;

  public static final String JSON_PROPERTY_COMMISSION = "commission";
  private Float commission;

  public static final String JSON_PROPERTY_SPA = "spa";
  private SpaConsumer spa;

  public SpaLocalizedInventoryConsumer() {
  }

  public SpaLocalizedInventoryConsumer channelInventoryIdentifier(UUID channelInventoryIdentifier) {
    
    this.channelInventoryIdentifier = channelInventoryIdentifier;
    return this;
  }

   /**
   * Channel inventory identifier referencing this record.
   * @return channelInventoryIdentifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_CHANNEL_INVENTORY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public UUID getChannelInventoryIdentifier() {
    return channelInventoryIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_CHANNEL_INVENTORY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setChannelInventoryIdentifier(UUID channelInventoryIdentifier) {
    this.channelInventoryIdentifier = channelInventoryIdentifier;
  }


  public SpaLocalizedInventoryConsumer priceList(List<LocalizedTransactionalTravelInventoryConsumer> priceList) {
    
    this.priceList = priceList;
    return this;
  }

  public SpaLocalizedInventoryConsumer addPriceListItem(LocalizedTransactionalTravelInventoryConsumer priceListItem) {
    if (this.priceList == null) {
      this.priceList = new ArrayList<>();
    }
    this.priceList.add(priceListItem);
    return this;
  }

   /**
   * Get priceList
   * @return priceList
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_PRICE_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<LocalizedTransactionalTravelInventoryConsumer> getPriceList() {
    return priceList;
  }


  @JsonProperty(JSON_PROPERTY_PRICE_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPriceList(List<LocalizedTransactionalTravelInventoryConsumer> priceList) {
    this.priceList = priceList;
  }


  public SpaLocalizedInventoryConsumer commissionable(Boolean commissionable) {
    
    this.commissionable = commissionable;
    return this;
  }

   /**
   * Whether this package is commissionable based on the incoming sales channel.
   * @return commissionable
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_COMMISSIONABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getCommissionable() {
    return commissionable;
  }


  @JsonProperty(JSON_PROPERTY_COMMISSIONABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCommissionable(Boolean commissionable) {
    this.commissionable = commissionable;
  }


  public SpaLocalizedInventoryConsumer commission(Float commission) {
    
    this.commission = commission;
    return this;
  }

   /**
   * The commission percentage.
   * @return commission
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_COMMISSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getCommission() {
    return commission;
  }


  @JsonProperty(JSON_PROPERTY_COMMISSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCommission(Float commission) {
    this.commission = commission;
  }


  public SpaLocalizedInventoryConsumer spa(SpaConsumer spa) {
    
    this.spa = spa;
    return this;
  }

   /**
   * Get spa
   * @return spa
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SPA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public SpaConsumer getSpa() {
    return spa;
  }


  @JsonProperty(JSON_PROPERTY_SPA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSpa(SpaConsumer spa) {
    this.spa = spa;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SpaLocalizedInventoryConsumer spaLocalizedInventoryConsumer = (SpaLocalizedInventoryConsumer) o;
    return Objects.equals(this.channelInventoryIdentifier, spaLocalizedInventoryConsumer.channelInventoryIdentifier) &&
        Objects.equals(this.priceList, spaLocalizedInventoryConsumer.priceList) &&
        Objects.equals(this.commissionable, spaLocalizedInventoryConsumer.commissionable) &&
        Objects.equals(this.commission, spaLocalizedInventoryConsumer.commission) &&
        Objects.equals(this.spa, spaLocalizedInventoryConsumer.spa);
  }

  @Override
  public int hashCode() {
    return Objects.hash(channelInventoryIdentifier, priceList, commissionable, commission, spa);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SpaLocalizedInventoryConsumer {\n");
    sb.append("    channelInventoryIdentifier: ").append(toIndentedString(channelInventoryIdentifier)).append("\n");
    sb.append("    priceList: ").append(toIndentedString(priceList)).append("\n");
    sb.append("    commissionable: ").append(toIndentedString(commissionable)).append("\n");
    sb.append("    commission: ").append(toIndentedString(commission)).append("\n");
    sb.append("    spa: ").append(toIndentedString(spa)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

