package travel.wink.sdk.inventory.api;

import travel.wink.sdk.inventory.invoker.ApiClient;

import travel.wink.sdk.inventory.model.AggregateActivityRequestConsumer;
import travel.wink.sdk.inventory.model.AggregateAddOnRequestConsumer;
import travel.wink.sdk.inventory.model.AggregateAttractionRequestConsumer;
import travel.wink.sdk.inventory.model.AggregateGuestRoomRequestConsumer;
import travel.wink.sdk.inventory.model.AggregateHotelRequestConsumer;
import travel.wink.sdk.inventory.model.AggregateInventoryGridItemRequestConsumer;
import travel.wink.sdk.inventory.model.AggregateMeetingRoomRequestConsumer;
import travel.wink.sdk.inventory.model.AggregatePlaceRequestConsumer;
import travel.wink.sdk.inventory.model.AggregateRestaurantRequestConsumer;
import travel.wink.sdk.inventory.model.AggregateSellerInventoryListRequestConsumer;
import travel.wink.sdk.inventory.model.AggregateSpaRequestConsumer;
import travel.wink.sdk.inventory.model.GenericErrorMessage;
import travel.wink.sdk.inventory.model.HotelInventoryListRequestConsumer;
import travel.wink.sdk.inventory.model.HotelInventoryListResponseConsumer;
import travel.wink.sdk.inventory.model.HotelInventoryRequestConsumer;
import travel.wink.sdk.inventory.model.HotelInventoryResponseConsumer;
import travel.wink.sdk.inventory.model.InventoryGridItemConsumer;
import travel.wink.sdk.inventory.model.Oauth2ShowPropertyInventory400Response;
import travel.wink.sdk.inventory.model.SellerInventoryActivityConsumer;
import travel.wink.sdk.inventory.model.SellerInventoryAddOnConsumer;
import travel.wink.sdk.inventory.model.SellerInventoryAttractionConsumer;
import travel.wink.sdk.inventory.model.SellerInventoryGuestRoomConsumer;
import travel.wink.sdk.inventory.model.SellerInventoryHotelConsumer;
import travel.wink.sdk.inventory.model.SellerInventoryListResponseConsumer;
import travel.wink.sdk.inventory.model.SellerInventoryMeetingRoomConsumer;
import travel.wink.sdk.inventory.model.SellerInventoryPlaceConsumer;
import travel.wink.sdk.inventory.model.SellerInventoryRankedListResponseConsumer;
import travel.wink.sdk.inventory.model.SellerInventoryRestaurantConsumer;
import travel.wink.sdk.inventory.model.SellerInventorySpaConsumer;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-04-26T14:37:25.342074502+07:00[Asia/Bangkok]")
public class InventoryApi {
    private ApiClient apiClient;

    public InventoryApi() {
        this(new ApiClient());
    }

    @Autowired
    public InventoryApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Show Inventory
     * Shows single grid based on channel inventory identifier 
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param aggregateInventoryGridItemRequestConsumer The aggregateInventoryGridItemRequestConsumer parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return InventoryGridItemConsumer
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec oauth2ShowInventoryGridItemRequestCreation(AggregateInventoryGridItemRequestConsumer aggregateInventoryGridItemRequestConsumer, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = aggregateInventoryGridItemRequestConsumer;
        // verify the required parameter 'aggregateInventoryGridItemRequestConsumer' is set
        if (aggregateInventoryGridItemRequestConsumer == null) {
            throw new WebClientResponseException("Missing the required parameter 'aggregateInventoryGridItemRequestConsumer' when calling oauth2ShowInventoryGridItem", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "engineConfigurationIdentifier", engineConfigurationIdentifier));

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<InventoryGridItemConsumer> localVarReturnType = new ParameterizedTypeReference<InventoryGridItemConsumer>() {};
        return apiClient.invokeAPI("/api/inventory/grid/item", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Inventory
     * Shows single grid based on channel inventory identifier 
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param aggregateInventoryGridItemRequestConsumer The aggregateInventoryGridItemRequestConsumer parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return InventoryGridItemConsumer
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<InventoryGridItemConsumer> oauth2ShowInventoryGridItem(AggregateInventoryGridItemRequestConsumer aggregateInventoryGridItemRequestConsumer, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<InventoryGridItemConsumer> localVarReturnType = new ParameterizedTypeReference<InventoryGridItemConsumer>() {};
        return oauth2ShowInventoryGridItemRequestCreation(aggregateInventoryGridItemRequestConsumer, engineConfigurationIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Show Inventory
     * Shows single grid based on channel inventory identifier 
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param aggregateInventoryGridItemRequestConsumer The aggregateInventoryGridItemRequestConsumer parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;InventoryGridItemConsumer&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<InventoryGridItemConsumer>> oauth2ShowInventoryGridItemWithHttpInfo(AggregateInventoryGridItemRequestConsumer aggregateInventoryGridItemRequestConsumer, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<InventoryGridItemConsumer> localVarReturnType = new ParameterizedTypeReference<InventoryGridItemConsumer>() {};
        return oauth2ShowInventoryGridItemRequestCreation(aggregateInventoryGridItemRequestConsumer, engineConfigurationIdentifier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Show Inventory
     * Shows single grid based on channel inventory identifier 
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param aggregateInventoryGridItemRequestConsumer The aggregateInventoryGridItemRequestConsumer parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec oauth2ShowInventoryGridItemWithResponseSpec(AggregateInventoryGridItemRequestConsumer aggregateInventoryGridItemRequestConsumer, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        return oauth2ShowInventoryGridItemRequestCreation(aggregateInventoryGridItemRequestConsumer, engineConfigurationIdentifier, winkVersion);
    }
    /**
     * Show Add-On
     * Show single add-on based on a channel inventory identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param aggregateAddOnRequestConsumer The aggregateAddOnRequestConsumer parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return SellerInventoryAddOnConsumer
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec oauth2ShowPropertyAddOnRequestCreation(AggregateAddOnRequestConsumer aggregateAddOnRequestConsumer, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = aggregateAddOnRequestConsumer;
        // verify the required parameter 'aggregateAddOnRequestConsumer' is set
        if (aggregateAddOnRequestConsumer == null) {
            throw new WebClientResponseException("Missing the required parameter 'aggregateAddOnRequestConsumer' when calling oauth2ShowPropertyAddOn", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "engineConfigurationIdentifier", engineConfigurationIdentifier));

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<SellerInventoryAddOnConsumer> localVarReturnType = new ParameterizedTypeReference<SellerInventoryAddOnConsumer>() {};
        return apiClient.invokeAPI("/api/inventory/upgrade", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Add-On
     * Show single add-on based on a channel inventory identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param aggregateAddOnRequestConsumer The aggregateAddOnRequestConsumer parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return SellerInventoryAddOnConsumer
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<SellerInventoryAddOnConsumer> oauth2ShowPropertyAddOn(AggregateAddOnRequestConsumer aggregateAddOnRequestConsumer, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryAddOnConsumer> localVarReturnType = new ParameterizedTypeReference<SellerInventoryAddOnConsumer>() {};
        return oauth2ShowPropertyAddOnRequestCreation(aggregateAddOnRequestConsumer, engineConfigurationIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Show Add-On
     * Show single add-on based on a channel inventory identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param aggregateAddOnRequestConsumer The aggregateAddOnRequestConsumer parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;SellerInventoryAddOnConsumer&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<SellerInventoryAddOnConsumer>> oauth2ShowPropertyAddOnWithHttpInfo(AggregateAddOnRequestConsumer aggregateAddOnRequestConsumer, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryAddOnConsumer> localVarReturnType = new ParameterizedTypeReference<SellerInventoryAddOnConsumer>() {};
        return oauth2ShowPropertyAddOnRequestCreation(aggregateAddOnRequestConsumer, engineConfigurationIdentifier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Show Add-On
     * Show single add-on based on a channel inventory identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param aggregateAddOnRequestConsumer The aggregateAddOnRequestConsumer parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec oauth2ShowPropertyAddOnWithResponseSpec(AggregateAddOnRequestConsumer aggregateAddOnRequestConsumer, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        return oauth2ShowPropertyAddOnRequestCreation(aggregateAddOnRequestConsumer, engineConfigurationIdentifier, winkVersion);
    }
    /**
     * Show Property
     * Show single hotel card with price based on a given record identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param aggregateHotelRequestConsumer The aggregateHotelRequestConsumer parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return SellerInventoryHotelConsumer
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec oauth2ShowPropertyAggregateRequestCreation(AggregateHotelRequestConsumer aggregateHotelRequestConsumer, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = aggregateHotelRequestConsumer;
        // verify the required parameter 'aggregateHotelRequestConsumer' is set
        if (aggregateHotelRequestConsumer == null) {
            throw new WebClientResponseException("Missing the required parameter 'aggregateHotelRequestConsumer' when calling oauth2ShowPropertyAggregate", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "engineConfigurationIdentifier", engineConfigurationIdentifier));

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<SellerInventoryHotelConsumer> localVarReturnType = new ParameterizedTypeReference<SellerInventoryHotelConsumer>() {};
        return apiClient.invokeAPI("/api/inventory/property", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Property
     * Show single hotel card with price based on a given record identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param aggregateHotelRequestConsumer The aggregateHotelRequestConsumer parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return SellerInventoryHotelConsumer
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<SellerInventoryHotelConsumer> oauth2ShowPropertyAggregate(AggregateHotelRequestConsumer aggregateHotelRequestConsumer, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryHotelConsumer> localVarReturnType = new ParameterizedTypeReference<SellerInventoryHotelConsumer>() {};
        return oauth2ShowPropertyAggregateRequestCreation(aggregateHotelRequestConsumer, engineConfigurationIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Show Property
     * Show single hotel card with price based on a given record identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param aggregateHotelRequestConsumer The aggregateHotelRequestConsumer parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;SellerInventoryHotelConsumer&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<SellerInventoryHotelConsumer>> oauth2ShowPropertyAggregateWithHttpInfo(AggregateHotelRequestConsumer aggregateHotelRequestConsumer, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryHotelConsumer> localVarReturnType = new ParameterizedTypeReference<SellerInventoryHotelConsumer>() {};
        return oauth2ShowPropertyAggregateRequestCreation(aggregateHotelRequestConsumer, engineConfigurationIdentifier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Show Property
     * Show single hotel card with price based on a given record identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param aggregateHotelRequestConsumer The aggregateHotelRequestConsumer parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec oauth2ShowPropertyAggregateWithResponseSpec(AggregateHotelRequestConsumer aggregateHotelRequestConsumer, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        return oauth2ShowPropertyAggregateRequestCreation(aggregateHotelRequestConsumer, engineConfigurationIdentifier, winkVersion);
    }
    /**
     * Show Attraction
     * Show single attraction based on a channel inventory identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param aggregateAttractionRequestConsumer The aggregateAttractionRequestConsumer parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return SellerInventoryAttractionConsumer
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec oauth2ShowPropertyAttractionRequestCreation(AggregateAttractionRequestConsumer aggregateAttractionRequestConsumer, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = aggregateAttractionRequestConsumer;
        // verify the required parameter 'aggregateAttractionRequestConsumer' is set
        if (aggregateAttractionRequestConsumer == null) {
            throw new WebClientResponseException("Missing the required parameter 'aggregateAttractionRequestConsumer' when calling oauth2ShowPropertyAttraction", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "engineConfigurationIdentifier", engineConfigurationIdentifier));

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<SellerInventoryAttractionConsumer> localVarReturnType = new ParameterizedTypeReference<SellerInventoryAttractionConsumer>() {};
        return apiClient.invokeAPI("/api/inventory/attraction", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Attraction
     * Show single attraction based on a channel inventory identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param aggregateAttractionRequestConsumer The aggregateAttractionRequestConsumer parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return SellerInventoryAttractionConsumer
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<SellerInventoryAttractionConsumer> oauth2ShowPropertyAttraction(AggregateAttractionRequestConsumer aggregateAttractionRequestConsumer, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryAttractionConsumer> localVarReturnType = new ParameterizedTypeReference<SellerInventoryAttractionConsumer>() {};
        return oauth2ShowPropertyAttractionRequestCreation(aggregateAttractionRequestConsumer, engineConfigurationIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Show Attraction
     * Show single attraction based on a channel inventory identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param aggregateAttractionRequestConsumer The aggregateAttractionRequestConsumer parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;SellerInventoryAttractionConsumer&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<SellerInventoryAttractionConsumer>> oauth2ShowPropertyAttractionWithHttpInfo(AggregateAttractionRequestConsumer aggregateAttractionRequestConsumer, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryAttractionConsumer> localVarReturnType = new ParameterizedTypeReference<SellerInventoryAttractionConsumer>() {};
        return oauth2ShowPropertyAttractionRequestCreation(aggregateAttractionRequestConsumer, engineConfigurationIdentifier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Show Attraction
     * Show single attraction based on a channel inventory identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param aggregateAttractionRequestConsumer The aggregateAttractionRequestConsumer parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec oauth2ShowPropertyAttractionWithResponseSpec(AggregateAttractionRequestConsumer aggregateAttractionRequestConsumer, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        return oauth2ShowPropertyAttractionRequestCreation(aggregateAttractionRequestConsumer, engineConfigurationIdentifier, winkVersion);
    }
    /**
     * Show property
     * Show property content / availability / rate details.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelInventoryRequestConsumer The hotelInventoryRequestConsumer parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return HotelInventoryResponseConsumer
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec oauth2ShowPropertyInventoryRequestCreation(HotelInventoryRequestConsumer hotelInventoryRequestConsumer, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = hotelInventoryRequestConsumer;
        // verify the required parameter 'hotelInventoryRequestConsumer' is set
        if (hotelInventoryRequestConsumer == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelInventoryRequestConsumer' when calling oauth2ShowPropertyInventory", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "engineConfigurationIdentifier", engineConfigurationIdentifier));

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<HotelInventoryResponseConsumer> localVarReturnType = new ParameterizedTypeReference<HotelInventoryResponseConsumer>() {};
        return apiClient.invokeAPI("/api/inventory", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show property
     * Show property content / availability / rate details.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelInventoryRequestConsumer The hotelInventoryRequestConsumer parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return HotelInventoryResponseConsumer
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<HotelInventoryResponseConsumer> oauth2ShowPropertyInventory(HotelInventoryRequestConsumer hotelInventoryRequestConsumer, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<HotelInventoryResponseConsumer> localVarReturnType = new ParameterizedTypeReference<HotelInventoryResponseConsumer>() {};
        return oauth2ShowPropertyInventoryRequestCreation(hotelInventoryRequestConsumer, engineConfigurationIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Show property
     * Show property content / availability / rate details.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelInventoryRequestConsumer The hotelInventoryRequestConsumer parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;HotelInventoryResponseConsumer&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<HotelInventoryResponseConsumer>> oauth2ShowPropertyInventoryWithHttpInfo(HotelInventoryRequestConsumer hotelInventoryRequestConsumer, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<HotelInventoryResponseConsumer> localVarReturnType = new ParameterizedTypeReference<HotelInventoryResponseConsumer>() {};
        return oauth2ShowPropertyInventoryRequestCreation(hotelInventoryRequestConsumer, engineConfigurationIdentifier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Show property
     * Show property content / availability / rate details.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelInventoryRequestConsumer The hotelInventoryRequestConsumer parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec oauth2ShowPropertyInventoryWithResponseSpec(HotelInventoryRequestConsumer hotelInventoryRequestConsumer, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        return oauth2ShowPropertyInventoryRequestCreation(hotelInventoryRequestConsumer, engineConfigurationIdentifier, winkVersion);
    }
    /**
     * Show Property List
     * Show property content / availability / rate details.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelInventoryListRequestConsumer The hotelInventoryListRequestConsumer parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return HotelInventoryListResponseConsumer
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec oauth2ShowPropertyListRequestCreation(HotelInventoryListRequestConsumer hotelInventoryListRequestConsumer, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = hotelInventoryListRequestConsumer;
        // verify the required parameter 'hotelInventoryListRequestConsumer' is set
        if (hotelInventoryListRequestConsumer == null) {
            throw new WebClientResponseException("Missing the required parameter 'hotelInventoryListRequestConsumer' when calling oauth2ShowPropertyList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "engineConfigurationIdentifier", engineConfigurationIdentifier));

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<HotelInventoryListResponseConsumer> localVarReturnType = new ParameterizedTypeReference<HotelInventoryListResponseConsumer>() {};
        return apiClient.invokeAPI("/api/inventory/list", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Property List
     * Show property content / availability / rate details.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelInventoryListRequestConsumer The hotelInventoryListRequestConsumer parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return HotelInventoryListResponseConsumer
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<HotelInventoryListResponseConsumer> oauth2ShowPropertyList(HotelInventoryListRequestConsumer hotelInventoryListRequestConsumer, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<HotelInventoryListResponseConsumer> localVarReturnType = new ParameterizedTypeReference<HotelInventoryListResponseConsumer>() {};
        return oauth2ShowPropertyListRequestCreation(hotelInventoryListRequestConsumer, engineConfigurationIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Show Property List
     * Show property content / availability / rate details.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelInventoryListRequestConsumer The hotelInventoryListRequestConsumer parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;HotelInventoryListResponseConsumer&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<HotelInventoryListResponseConsumer>> oauth2ShowPropertyListWithHttpInfo(HotelInventoryListRequestConsumer hotelInventoryListRequestConsumer, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<HotelInventoryListResponseConsumer> localVarReturnType = new ParameterizedTypeReference<HotelInventoryListResponseConsumer>() {};
        return oauth2ShowPropertyListRequestCreation(hotelInventoryListRequestConsumer, engineConfigurationIdentifier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Show Property List
     * Show property content / availability / rate details.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param hotelInventoryListRequestConsumer The hotelInventoryListRequestConsumer parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec oauth2ShowPropertyListWithResponseSpec(HotelInventoryListRequestConsumer hotelInventoryListRequestConsumer, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        return oauth2ShowPropertyListRequestCreation(hotelInventoryListRequestConsumer, engineConfigurationIdentifier, winkVersion);
    }
    /**
     * Show Meeting Room
     * Show single meeting room based on a channel inventory identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param aggregateMeetingRoomRequestConsumer The aggregateMeetingRoomRequestConsumer parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return SellerInventoryMeetingRoomConsumer
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec oauth2ShowPropertyMeetingRoomRequestCreation(AggregateMeetingRoomRequestConsumer aggregateMeetingRoomRequestConsumer, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = aggregateMeetingRoomRequestConsumer;
        // verify the required parameter 'aggregateMeetingRoomRequestConsumer' is set
        if (aggregateMeetingRoomRequestConsumer == null) {
            throw new WebClientResponseException("Missing the required parameter 'aggregateMeetingRoomRequestConsumer' when calling oauth2ShowPropertyMeetingRoom", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "engineConfigurationIdentifier", engineConfigurationIdentifier));

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<SellerInventoryMeetingRoomConsumer> localVarReturnType = new ParameterizedTypeReference<SellerInventoryMeetingRoomConsumer>() {};
        return apiClient.invokeAPI("/api/inventory/meetingroom", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Meeting Room
     * Show single meeting room based on a channel inventory identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param aggregateMeetingRoomRequestConsumer The aggregateMeetingRoomRequestConsumer parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return SellerInventoryMeetingRoomConsumer
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<SellerInventoryMeetingRoomConsumer> oauth2ShowPropertyMeetingRoom(AggregateMeetingRoomRequestConsumer aggregateMeetingRoomRequestConsumer, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryMeetingRoomConsumer> localVarReturnType = new ParameterizedTypeReference<SellerInventoryMeetingRoomConsumer>() {};
        return oauth2ShowPropertyMeetingRoomRequestCreation(aggregateMeetingRoomRequestConsumer, engineConfigurationIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Show Meeting Room
     * Show single meeting room based on a channel inventory identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param aggregateMeetingRoomRequestConsumer The aggregateMeetingRoomRequestConsumer parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;SellerInventoryMeetingRoomConsumer&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<SellerInventoryMeetingRoomConsumer>> oauth2ShowPropertyMeetingRoomWithHttpInfo(AggregateMeetingRoomRequestConsumer aggregateMeetingRoomRequestConsumer, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryMeetingRoomConsumer> localVarReturnType = new ParameterizedTypeReference<SellerInventoryMeetingRoomConsumer>() {};
        return oauth2ShowPropertyMeetingRoomRequestCreation(aggregateMeetingRoomRequestConsumer, engineConfigurationIdentifier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Show Meeting Room
     * Show single meeting room based on a channel inventory identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param aggregateMeetingRoomRequestConsumer The aggregateMeetingRoomRequestConsumer parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec oauth2ShowPropertyMeetingRoomWithResponseSpec(AggregateMeetingRoomRequestConsumer aggregateMeetingRoomRequestConsumer, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        return oauth2ShowPropertyMeetingRoomRequestCreation(aggregateMeetingRoomRequestConsumer, engineConfigurationIdentifier, winkVersion);
    }
    /**
     * Show Place
     * Show single place based on a channel inventory identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param aggregatePlaceRequestConsumer The aggregatePlaceRequestConsumer parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return SellerInventoryPlaceConsumer
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec oauth2ShowPropertyPlaceRequestCreation(AggregatePlaceRequestConsumer aggregatePlaceRequestConsumer, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = aggregatePlaceRequestConsumer;
        // verify the required parameter 'aggregatePlaceRequestConsumer' is set
        if (aggregatePlaceRequestConsumer == null) {
            throw new WebClientResponseException("Missing the required parameter 'aggregatePlaceRequestConsumer' when calling oauth2ShowPropertyPlace", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "engineConfigurationIdentifier", engineConfigurationIdentifier));

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<SellerInventoryPlaceConsumer> localVarReturnType = new ParameterizedTypeReference<SellerInventoryPlaceConsumer>() {};
        return apiClient.invokeAPI("/api/inventory/place", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Place
     * Show single place based on a channel inventory identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param aggregatePlaceRequestConsumer The aggregatePlaceRequestConsumer parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return SellerInventoryPlaceConsumer
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<SellerInventoryPlaceConsumer> oauth2ShowPropertyPlace(AggregatePlaceRequestConsumer aggregatePlaceRequestConsumer, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryPlaceConsumer> localVarReturnType = new ParameterizedTypeReference<SellerInventoryPlaceConsumer>() {};
        return oauth2ShowPropertyPlaceRequestCreation(aggregatePlaceRequestConsumer, engineConfigurationIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Show Place
     * Show single place based on a channel inventory identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param aggregatePlaceRequestConsumer The aggregatePlaceRequestConsumer parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;SellerInventoryPlaceConsumer&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<SellerInventoryPlaceConsumer>> oauth2ShowPropertyPlaceWithHttpInfo(AggregatePlaceRequestConsumer aggregatePlaceRequestConsumer, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryPlaceConsumer> localVarReturnType = new ParameterizedTypeReference<SellerInventoryPlaceConsumer>() {};
        return oauth2ShowPropertyPlaceRequestCreation(aggregatePlaceRequestConsumer, engineConfigurationIdentifier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Show Place
     * Show single place based on a channel inventory identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param aggregatePlaceRequestConsumer The aggregatePlaceRequestConsumer parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec oauth2ShowPropertyPlaceWithResponseSpec(AggregatePlaceRequestConsumer aggregatePlaceRequestConsumer, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        return oauth2ShowPropertyPlaceRequestCreation(aggregatePlaceRequestConsumer, engineConfigurationIdentifier, winkVersion);
    }
    /**
     * Show Activity
     * Show single activity based on a channel inventory identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param aggregateActivityRequestConsumer The aggregateActivityRequestConsumer parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return SellerInventoryActivityConsumer
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec oauth2ShowPropertyRecreationRequestCreation(AggregateActivityRequestConsumer aggregateActivityRequestConsumer, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = aggregateActivityRequestConsumer;
        // verify the required parameter 'aggregateActivityRequestConsumer' is set
        if (aggregateActivityRequestConsumer == null) {
            throw new WebClientResponseException("Missing the required parameter 'aggregateActivityRequestConsumer' when calling oauth2ShowPropertyRecreation", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "engineConfigurationIdentifier", engineConfigurationIdentifier));

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<SellerInventoryActivityConsumer> localVarReturnType = new ParameterizedTypeReference<SellerInventoryActivityConsumer>() {};
        return apiClient.invokeAPI("/api/inventory/activity", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Activity
     * Show single activity based on a channel inventory identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param aggregateActivityRequestConsumer The aggregateActivityRequestConsumer parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return SellerInventoryActivityConsumer
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<SellerInventoryActivityConsumer> oauth2ShowPropertyRecreation(AggregateActivityRequestConsumer aggregateActivityRequestConsumer, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryActivityConsumer> localVarReturnType = new ParameterizedTypeReference<SellerInventoryActivityConsumer>() {};
        return oauth2ShowPropertyRecreationRequestCreation(aggregateActivityRequestConsumer, engineConfigurationIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Show Activity
     * Show single activity based on a channel inventory identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param aggregateActivityRequestConsumer The aggregateActivityRequestConsumer parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;SellerInventoryActivityConsumer&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<SellerInventoryActivityConsumer>> oauth2ShowPropertyRecreationWithHttpInfo(AggregateActivityRequestConsumer aggregateActivityRequestConsumer, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryActivityConsumer> localVarReturnType = new ParameterizedTypeReference<SellerInventoryActivityConsumer>() {};
        return oauth2ShowPropertyRecreationRequestCreation(aggregateActivityRequestConsumer, engineConfigurationIdentifier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Show Activity
     * Show single activity based on a channel inventory identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param aggregateActivityRequestConsumer The aggregateActivityRequestConsumer parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec oauth2ShowPropertyRecreationWithResponseSpec(AggregateActivityRequestConsumer aggregateActivityRequestConsumer, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        return oauth2ShowPropertyRecreationRequestCreation(aggregateActivityRequestConsumer, engineConfigurationIdentifier, winkVersion);
    }
    /**
     * Show Restaurant
     * Show single restaurant based on a channel inventory identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param aggregateRestaurantRequestConsumer The aggregateRestaurantRequestConsumer parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return SellerInventoryRestaurantConsumer
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec oauth2ShowPropertyRestaurantRequestCreation(AggregateRestaurantRequestConsumer aggregateRestaurantRequestConsumer, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = aggregateRestaurantRequestConsumer;
        // verify the required parameter 'aggregateRestaurantRequestConsumer' is set
        if (aggregateRestaurantRequestConsumer == null) {
            throw new WebClientResponseException("Missing the required parameter 'aggregateRestaurantRequestConsumer' when calling oauth2ShowPropertyRestaurant", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "engineConfigurationIdentifier", engineConfigurationIdentifier));

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<SellerInventoryRestaurantConsumer> localVarReturnType = new ParameterizedTypeReference<SellerInventoryRestaurantConsumer>() {};
        return apiClient.invokeAPI("/api/inventory/restaurant", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Restaurant
     * Show single restaurant based on a channel inventory identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param aggregateRestaurantRequestConsumer The aggregateRestaurantRequestConsumer parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return SellerInventoryRestaurantConsumer
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<SellerInventoryRestaurantConsumer> oauth2ShowPropertyRestaurant(AggregateRestaurantRequestConsumer aggregateRestaurantRequestConsumer, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryRestaurantConsumer> localVarReturnType = new ParameterizedTypeReference<SellerInventoryRestaurantConsumer>() {};
        return oauth2ShowPropertyRestaurantRequestCreation(aggregateRestaurantRequestConsumer, engineConfigurationIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Show Restaurant
     * Show single restaurant based on a channel inventory identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param aggregateRestaurantRequestConsumer The aggregateRestaurantRequestConsumer parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;SellerInventoryRestaurantConsumer&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<SellerInventoryRestaurantConsumer>> oauth2ShowPropertyRestaurantWithHttpInfo(AggregateRestaurantRequestConsumer aggregateRestaurantRequestConsumer, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryRestaurantConsumer> localVarReturnType = new ParameterizedTypeReference<SellerInventoryRestaurantConsumer>() {};
        return oauth2ShowPropertyRestaurantRequestCreation(aggregateRestaurantRequestConsumer, engineConfigurationIdentifier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Show Restaurant
     * Show single restaurant based on a channel inventory identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param aggregateRestaurantRequestConsumer The aggregateRestaurantRequestConsumer parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec oauth2ShowPropertyRestaurantWithResponseSpec(AggregateRestaurantRequestConsumer aggregateRestaurantRequestConsumer, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        return oauth2ShowPropertyRestaurantRequestCreation(aggregateRestaurantRequestConsumer, engineConfigurationIdentifier, winkVersion);
    }
    /**
     * Show Guest Room
     * Show single guest room based on a channel inventory identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param aggregateGuestRoomRequestConsumer The aggregateGuestRoomRequestConsumer parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return SellerInventoryGuestRoomConsumer
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec oauth2ShowPropertyRoomTypeRequestCreation(AggregateGuestRoomRequestConsumer aggregateGuestRoomRequestConsumer, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = aggregateGuestRoomRequestConsumer;
        // verify the required parameter 'aggregateGuestRoomRequestConsumer' is set
        if (aggregateGuestRoomRequestConsumer == null) {
            throw new WebClientResponseException("Missing the required parameter 'aggregateGuestRoomRequestConsumer' when calling oauth2ShowPropertyRoomType", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "engineConfigurationIdentifier", engineConfigurationIdentifier));

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<SellerInventoryGuestRoomConsumer> localVarReturnType = new ParameterizedTypeReference<SellerInventoryGuestRoomConsumer>() {};
        return apiClient.invokeAPI("/api/inventory/guestroom", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Guest Room
     * Show single guest room based on a channel inventory identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param aggregateGuestRoomRequestConsumer The aggregateGuestRoomRequestConsumer parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return SellerInventoryGuestRoomConsumer
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<SellerInventoryGuestRoomConsumer> oauth2ShowPropertyRoomType(AggregateGuestRoomRequestConsumer aggregateGuestRoomRequestConsumer, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryGuestRoomConsumer> localVarReturnType = new ParameterizedTypeReference<SellerInventoryGuestRoomConsumer>() {};
        return oauth2ShowPropertyRoomTypeRequestCreation(aggregateGuestRoomRequestConsumer, engineConfigurationIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Show Guest Room
     * Show single guest room based on a channel inventory identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param aggregateGuestRoomRequestConsumer The aggregateGuestRoomRequestConsumer parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;SellerInventoryGuestRoomConsumer&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<SellerInventoryGuestRoomConsumer>> oauth2ShowPropertyRoomTypeWithHttpInfo(AggregateGuestRoomRequestConsumer aggregateGuestRoomRequestConsumer, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryGuestRoomConsumer> localVarReturnType = new ParameterizedTypeReference<SellerInventoryGuestRoomConsumer>() {};
        return oauth2ShowPropertyRoomTypeRequestCreation(aggregateGuestRoomRequestConsumer, engineConfigurationIdentifier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Show Guest Room
     * Show single guest room based on a channel inventory identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param aggregateGuestRoomRequestConsumer The aggregateGuestRoomRequestConsumer parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec oauth2ShowPropertyRoomTypeWithResponseSpec(AggregateGuestRoomRequestConsumer aggregateGuestRoomRequestConsumer, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        return oauth2ShowPropertyRoomTypeRequestCreation(aggregateGuestRoomRequestConsumer, engineConfigurationIdentifier, winkVersion);
    }
    /**
     * Show Spa
     * Show single spa based on a channel inventory identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param aggregateSpaRequestConsumer The aggregateSpaRequestConsumer parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return SellerInventorySpaConsumer
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec oauth2ShowPropertySpaRequestCreation(AggregateSpaRequestConsumer aggregateSpaRequestConsumer, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = aggregateSpaRequestConsumer;
        // verify the required parameter 'aggregateSpaRequestConsumer' is set
        if (aggregateSpaRequestConsumer == null) {
            throw new WebClientResponseException("Missing the required parameter 'aggregateSpaRequestConsumer' when calling oauth2ShowPropertySpa", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "engineConfigurationIdentifier", engineConfigurationIdentifier));

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<SellerInventorySpaConsumer> localVarReturnType = new ParameterizedTypeReference<SellerInventorySpaConsumer>() {};
        return apiClient.invokeAPI("/api/inventory/spa", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Spa
     * Show single spa based on a channel inventory identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param aggregateSpaRequestConsumer The aggregateSpaRequestConsumer parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return SellerInventorySpaConsumer
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<SellerInventorySpaConsumer> oauth2ShowPropertySpa(AggregateSpaRequestConsumer aggregateSpaRequestConsumer, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventorySpaConsumer> localVarReturnType = new ParameterizedTypeReference<SellerInventorySpaConsumer>() {};
        return oauth2ShowPropertySpaRequestCreation(aggregateSpaRequestConsumer, engineConfigurationIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Show Spa
     * Show single spa based on a channel inventory identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param aggregateSpaRequestConsumer The aggregateSpaRequestConsumer parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;SellerInventorySpaConsumer&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<SellerInventorySpaConsumer>> oauth2ShowPropertySpaWithHttpInfo(AggregateSpaRequestConsumer aggregateSpaRequestConsumer, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventorySpaConsumer> localVarReturnType = new ParameterizedTypeReference<SellerInventorySpaConsumer>() {};
        return oauth2ShowPropertySpaRequestCreation(aggregateSpaRequestConsumer, engineConfigurationIdentifier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Show Spa
     * Show single spa based on a channel inventory identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param aggregateSpaRequestConsumer The aggregateSpaRequestConsumer parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec oauth2ShowPropertySpaWithResponseSpec(AggregateSpaRequestConsumer aggregateSpaRequestConsumer, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        return oauth2ShowPropertySpaRequestCreation(aggregateSpaRequestConsumer, engineConfigurationIdentifier, winkVersion);
    }
    /**
     * Show Inventories
     * Shows page of inventory items
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param aggregateSellerInventoryListRequestConsumer The aggregateSellerInventoryListRequestConsumer parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return SellerInventoryListResponseConsumer
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec oauth2ShowSellerInventoryListRequestCreation(AggregateSellerInventoryListRequestConsumer aggregateSellerInventoryListRequestConsumer, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = aggregateSellerInventoryListRequestConsumer;
        // verify the required parameter 'aggregateSellerInventoryListRequestConsumer' is set
        if (aggregateSellerInventoryListRequestConsumer == null) {
            throw new WebClientResponseException("Missing the required parameter 'aggregateSellerInventoryListRequestConsumer' when calling oauth2ShowSellerInventoryList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "engineConfigurationIdentifier", engineConfigurationIdentifier));

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<SellerInventoryListResponseConsumer> localVarReturnType = new ParameterizedTypeReference<SellerInventoryListResponseConsumer>() {};
        return apiClient.invokeAPI("/api/inventory/grid", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Inventories
     * Shows page of inventory items
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param aggregateSellerInventoryListRequestConsumer The aggregateSellerInventoryListRequestConsumer parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return SellerInventoryListResponseConsumer
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<SellerInventoryListResponseConsumer> oauth2ShowSellerInventoryList(AggregateSellerInventoryListRequestConsumer aggregateSellerInventoryListRequestConsumer, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryListResponseConsumer> localVarReturnType = new ParameterizedTypeReference<SellerInventoryListResponseConsumer>() {};
        return oauth2ShowSellerInventoryListRequestCreation(aggregateSellerInventoryListRequestConsumer, engineConfigurationIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Show Inventories
     * Shows page of inventory items
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param aggregateSellerInventoryListRequestConsumer The aggregateSellerInventoryListRequestConsumer parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;SellerInventoryListResponseConsumer&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<SellerInventoryListResponseConsumer>> oauth2ShowSellerInventoryListWithHttpInfo(AggregateSellerInventoryListRequestConsumer aggregateSellerInventoryListRequestConsumer, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryListResponseConsumer> localVarReturnType = new ParameterizedTypeReference<SellerInventoryListResponseConsumer>() {};
        return oauth2ShowSellerInventoryListRequestCreation(aggregateSellerInventoryListRequestConsumer, engineConfigurationIdentifier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Show Inventories
     * Shows page of inventory items
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param aggregateSellerInventoryListRequestConsumer The aggregateSellerInventoryListRequestConsumer parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec oauth2ShowSellerInventoryListWithResponseSpec(AggregateSellerInventoryListRequestConsumer aggregateSellerInventoryListRequestConsumer, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        return oauth2ShowSellerInventoryListRequestCreation(aggregateSellerInventoryListRequestConsumer, engineConfigurationIdentifier, winkVersion);
    }
    /**
     * Show Ranked Inventories
     * Shows a paginated list of ranked inventory.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param aggregateSellerInventoryListRequestConsumer The aggregateSellerInventoryListRequestConsumer parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return SellerInventoryRankedListResponseConsumer
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec oauth2ShowSellerInventoryRankedListRequestCreation(AggregateSellerInventoryListRequestConsumer aggregateSellerInventoryListRequestConsumer, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = aggregateSellerInventoryListRequestConsumer;
        // verify the required parameter 'aggregateSellerInventoryListRequestConsumer' is set
        if (aggregateSellerInventoryListRequestConsumer == null) {
            throw new WebClientResponseException("Missing the required parameter 'aggregateSellerInventoryListRequestConsumer' when calling oauth2ShowSellerInventoryRankedList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "engineConfigurationIdentifier", engineConfigurationIdentifier));

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<SellerInventoryRankedListResponseConsumer> localVarReturnType = new ParameterizedTypeReference<SellerInventoryRankedListResponseConsumer>() {};
        return apiClient.invokeAPI("/api/inventory/ranked/grid", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Ranked Inventories
     * Shows a paginated list of ranked inventory.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param aggregateSellerInventoryListRequestConsumer The aggregateSellerInventoryListRequestConsumer parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return SellerInventoryRankedListResponseConsumer
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<SellerInventoryRankedListResponseConsumer> oauth2ShowSellerInventoryRankedList(AggregateSellerInventoryListRequestConsumer aggregateSellerInventoryListRequestConsumer, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryRankedListResponseConsumer> localVarReturnType = new ParameterizedTypeReference<SellerInventoryRankedListResponseConsumer>() {};
        return oauth2ShowSellerInventoryRankedListRequestCreation(aggregateSellerInventoryListRequestConsumer, engineConfigurationIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Show Ranked Inventories
     * Shows a paginated list of ranked inventory.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param aggregateSellerInventoryListRequestConsumer The aggregateSellerInventoryListRequestConsumer parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;SellerInventoryRankedListResponseConsumer&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<SellerInventoryRankedListResponseConsumer>> oauth2ShowSellerInventoryRankedListWithHttpInfo(AggregateSellerInventoryListRequestConsumer aggregateSellerInventoryListRequestConsumer, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryRankedListResponseConsumer> localVarReturnType = new ParameterizedTypeReference<SellerInventoryRankedListResponseConsumer>() {};
        return oauth2ShowSellerInventoryRankedListRequestCreation(aggregateSellerInventoryListRequestConsumer, engineConfigurationIdentifier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Show Ranked Inventories
     * Shows a paginated list of ranked inventory.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>404</b> - Not Found
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param aggregateSellerInventoryListRequestConsumer The aggregateSellerInventoryListRequestConsumer parameter
     * @param engineConfigurationIdentifier Engine configuration identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec oauth2ShowSellerInventoryRankedListWithResponseSpec(AggregateSellerInventoryListRequestConsumer aggregateSellerInventoryListRequestConsumer, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        return oauth2ShowSellerInventoryRankedListRequestCreation(aggregateSellerInventoryListRequestConsumer, engineConfigurationIdentifier, winkVersion);
    }
}
