/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.inventory.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.DecimalMax;
import jakarta.validation.constraints.DecimalMin;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import travel.wink.sdk.inventory.model.AggregateGreendexScoreByCategoryConsumer;

@JsonPropertyOrder(value={"highScore", "totalScore", "aggregateScore", "scoresByCategory"})
@JsonTypeName(value="AggregateGreendexAnswers_Consumer")
public class AggregateGreendexAnswersConsumer {
    public static final String JSON_PROPERTY_HIGH_SCORE = "highScore";
    private Integer highScore;
    public static final String JSON_PROPERTY_TOTAL_SCORE = "totalScore";
    private Integer totalScore;
    public static final String JSON_PROPERTY_AGGREGATE_SCORE = "aggregateScore";
    private Float aggregateScore;
    public static final String JSON_PROPERTY_SCORES_BY_CATEGORY = "scoresByCategory";
    private List<AggregateGreendexScoreByCategoryConsumer> scoresByCategory = new ArrayList<AggregateGreendexScoreByCategoryConsumer>();

    public AggregateGreendexAnswersConsumer highScore(Integer highScore) {
        this.highScore = highScore;
        return this;
    }

    @Nullable
    @JsonProperty(value="highScore")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getHighScore() {
        return this.highScore;
    }

    @JsonProperty(value="highScore")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHighScore(Integer highScore) {
        this.highScore = highScore;
    }

    public AggregateGreendexAnswersConsumer totalScore(Integer totalScore) {
        this.totalScore = totalScore;
        return this;
    }

    @Nullable
    @JsonProperty(value="totalScore")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getTotalScore() {
        return this.totalScore;
    }

    @JsonProperty(value="totalScore")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalScore(Integer totalScore) {
        this.totalScore = totalScore;
    }

    public AggregateGreendexAnswersConsumer aggregateScore(Float aggregateScore) {
        this.aggregateScore = aggregateScore;
        return this;
    }

    @Nullable
    @DecimalMin(value="0")
    @DecimalMax(value="1")
    @JsonProperty(value="aggregateScore")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public @DecimalMin(value="0") @DecimalMax(value="1") Float getAggregateScore() {
        return this.aggregateScore;
    }

    @JsonProperty(value="aggregateScore")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAggregateScore(Float aggregateScore) {
        this.aggregateScore = aggregateScore;
    }

    public AggregateGreendexAnswersConsumer scoresByCategory(List<AggregateGreendexScoreByCategoryConsumer> scoresByCategory) {
        this.scoresByCategory = scoresByCategory;
        return this;
    }

    public AggregateGreendexAnswersConsumer addScoresByCategoryItem(AggregateGreendexScoreByCategoryConsumer scoresByCategoryItem) {
        if (this.scoresByCategory == null) {
            this.scoresByCategory = new ArrayList<AggregateGreendexScoreByCategoryConsumer>();
        }
        this.scoresByCategory.add(scoresByCategoryItem);
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="scoresByCategory")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<AggregateGreendexScoreByCategoryConsumer> getScoresByCategory() {
        return this.scoresByCategory;
    }

    @JsonProperty(value="scoresByCategory")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setScoresByCategory(List<AggregateGreendexScoreByCategoryConsumer> scoresByCategory) {
        this.scoresByCategory = scoresByCategory;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AggregateGreendexAnswersConsumer aggregateGreendexAnswersConsumer = (AggregateGreendexAnswersConsumer)o;
        return Objects.equals(this.highScore, aggregateGreendexAnswersConsumer.highScore) && Objects.equals(this.totalScore, aggregateGreendexAnswersConsumer.totalScore) && Objects.equals(this.aggregateScore, aggregateGreendexAnswersConsumer.aggregateScore) && Objects.equals(this.scoresByCategory, aggregateGreendexAnswersConsumer.scoresByCategory);
    }

    public int hashCode() {
        return Objects.hash(this.highScore, this.totalScore, this.aggregateScore, this.scoresByCategory);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AggregateGreendexAnswersConsumer {\n");
        sb.append("    highScore: ").append(this.toIndentedString(this.highScore)).append("\n");
        sb.append("    totalScore: ").append(this.toIndentedString(this.totalScore)).append("\n");
        sb.append("    aggregateScore: ").append(this.toIndentedString(this.aggregateScore)).append("\n");
        sb.append("    scoresByCategory: ").append(this.toIndentedString(this.scoresByCategory)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

