/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.inventory.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import travel.wink.sdk.inventory.model.AddressConsumer;
import travel.wink.sdk.inventory.model.ContactConsumer;
import travel.wink.sdk.inventory.model.DowPatternGroupConsumer;
import travel.wink.sdk.inventory.model.GeoJsonPointConsumer;
import travel.wink.sdk.inventory.model.SimpleDescriptionConsumer;
import travel.wink.sdk.inventory.model.SimpleMultimediaConsumer;
import travel.wink.sdk.inventory.model.SocialConsumer;
import travel.wink.sdk.inventory.model.TravelInventoryRecognitionConsumer;

@JsonPropertyOrder(value={"identifier", "hotelIdentifier", "featuredInd", "lifestyleType", "location", "descriptions", "multimedias", "contact", "address", "commissionable", "name", "proximityCode", "sort", "minAgeAppropriateCode", "bookable", "active", "disabilityFeatures", "securityFeatures", "socials", "pricePoint", "recognitionList", "applicableStart", "applicableEnd", "reservationRequiredInd", "opens", "closes", "daysOfWeek", "maxSeatingCapacity", "maxSingleParty", "offerBreakfast", "offerLunch", "offerDinner", "offerBrunch", "amenities", "infoCodes", "cuisineCodes"})
@JsonTypeName(value="Restaurant_Consumer")
public class RestaurantConsumer {
    public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
    private UUID identifier;
    public static final String JSON_PROPERTY_HOTEL_IDENTIFIER = "hotelIdentifier";
    private UUID hotelIdentifier;
    public static final String JSON_PROPERTY_FEATURED_IND = "featuredInd";
    private Boolean featuredInd;
    public static final String JSON_PROPERTY_LIFESTYLE_TYPE = "lifestyleType";
    private LifestyleTypeEnum lifestyleType;
    public static final String JSON_PROPERTY_LOCATION = "location";
    private GeoJsonPointConsumer location;
    public static final String JSON_PROPERTY_DESCRIPTIONS = "descriptions";
    private List<SimpleDescriptionConsumer> descriptions = new ArrayList<SimpleDescriptionConsumer>();
    public static final String JSON_PROPERTY_MULTIMEDIAS = "multimedias";
    private List<SimpleMultimediaConsumer> multimedias = new ArrayList<SimpleMultimediaConsumer>();
    public static final String JSON_PROPERTY_CONTACT = "contact";
    private ContactConsumer contact;
    public static final String JSON_PROPERTY_ADDRESS = "address";
    private AddressConsumer address;
    public static final String JSON_PROPERTY_COMMISSIONABLE = "commissionable";
    private Boolean commissionable = true;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_PROXIMITY_CODE = "proximityCode";
    private String proximityCode;
    public static final String JSON_PROPERTY_SORT = "sort";
    private Integer sort;
    public static final String JSON_PROPERTY_MIN_AGE_APPROPRIATE_CODE = "minAgeAppropriateCode";
    private String minAgeAppropriateCode;
    public static final String JSON_PROPERTY_BOOKABLE = "bookable";
    private Boolean bookable = true;
    public static final String JSON_PROPERTY_ACTIVE = "active";
    private Boolean active = true;
    public static final String JSON_PROPERTY_DISABILITY_FEATURES = "disabilityFeatures";
    private List<String> disabilityFeatures = new ArrayList<String>();
    public static final String JSON_PROPERTY_SECURITY_FEATURES = "securityFeatures";
    private List<String> securityFeatures = new ArrayList<String>();
    public static final String JSON_PROPERTY_SOCIALS = "socials";
    private List<SocialConsumer> socials = new ArrayList<SocialConsumer>();
    public static final String JSON_PROPERTY_PRICE_POINT = "pricePoint";
    private PricePointEnum pricePoint = PricePointEnum.THREE;
    public static final String JSON_PROPERTY_RECOGNITION_LIST = "recognitionList";
    private List<TravelInventoryRecognitionConsumer> recognitionList = new ArrayList<TravelInventoryRecognitionConsumer>();
    public static final String JSON_PROPERTY_APPLICABLE_START = "applicableStart";
    private LocalDate applicableStart;
    public static final String JSON_PROPERTY_APPLICABLE_END = "applicableEnd";
    private LocalDate applicableEnd;
    public static final String JSON_PROPERTY_RESERVATION_REQUIRED_IND = "reservationRequiredInd";
    private Boolean reservationRequiredInd;
    public static final String JSON_PROPERTY_OPENS = "opens";
    private String opens;
    public static final String JSON_PROPERTY_CLOSES = "closes";
    private String closes;
    public static final String JSON_PROPERTY_DAYS_OF_WEEK = "daysOfWeek";
    private DowPatternGroupConsumer daysOfWeek;
    public static final String JSON_PROPERTY_MAX_SEATING_CAPACITY = "maxSeatingCapacity";
    private Integer maxSeatingCapacity;
    public static final String JSON_PROPERTY_MAX_SINGLE_PARTY = "maxSingleParty";
    private Integer maxSingleParty;
    public static final String JSON_PROPERTY_OFFER_BREAKFAST = "offerBreakfast";
    private Boolean offerBreakfast = false;
    public static final String JSON_PROPERTY_OFFER_LUNCH = "offerLunch";
    private Boolean offerLunch = false;
    public static final String JSON_PROPERTY_OFFER_DINNER = "offerDinner";
    private Boolean offerDinner = false;
    public static final String JSON_PROPERTY_OFFER_BRUNCH = "offerBrunch";
    private Boolean offerBrunch = false;
    public static final String JSON_PROPERTY_AMENITIES = "amenities";
    private List<String> amenities = new ArrayList<String>();
    public static final String JSON_PROPERTY_INFO_CODES = "infoCodes";
    private List<String> infoCodes = new ArrayList<String>();
    public static final String JSON_PROPERTY_CUISINE_CODES = "cuisineCodes";
    private List<String> cuisineCodes = new ArrayList<String>();

    public RestaurantConsumer identifier(UUID identifier) {
        this.identifier = identifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getIdentifier() {
        return this.identifier;
    }

    @JsonProperty(value="identifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setIdentifier(UUID identifier) {
        this.identifier = identifier;
    }

    public RestaurantConsumer hotelIdentifier(UUID hotelIdentifier) {
        this.hotelIdentifier = hotelIdentifier;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="hotelIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getHotelIdentifier() {
        return this.hotelIdentifier;
    }

    @JsonProperty(value="hotelIdentifier")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setHotelIdentifier(UUID hotelIdentifier) {
        this.hotelIdentifier = hotelIdentifier;
    }

    public RestaurantConsumer featuredInd(Boolean featuredInd) {
        this.featuredInd = featuredInd;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="featuredInd")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getFeaturedInd() {
        return this.featuredInd;
    }

    @JsonProperty(value="featuredInd")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setFeaturedInd(Boolean featuredInd) {
        this.featuredInd = featuredInd;
    }

    public RestaurantConsumer lifestyleType(LifestyleTypeEnum lifestyleType) {
        this.lifestyleType = lifestyleType;
        return this;
    }

    @Nullable
    @JsonProperty(value="lifestyleType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LifestyleTypeEnum getLifestyleType() {
        return this.lifestyleType;
    }

    @JsonProperty(value="lifestyleType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLifestyleType(LifestyleTypeEnum lifestyleType) {
        this.lifestyleType = lifestyleType;
    }

    public RestaurantConsumer location(GeoJsonPointConsumer location) {
        this.location = location;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="location")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public GeoJsonPointConsumer getLocation() {
        return this.location;
    }

    @JsonProperty(value="location")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setLocation(GeoJsonPointConsumer location) {
        this.location = location;
    }

    public RestaurantConsumer descriptions(List<SimpleDescriptionConsumer> descriptions) {
        this.descriptions = descriptions;
        return this;
    }

    public RestaurantConsumer addDescriptionsItem(SimpleDescriptionConsumer descriptionsItem) {
        this.descriptions.add(descriptionsItem);
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="descriptions")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<SimpleDescriptionConsumer> getDescriptions() {
        return this.descriptions;
    }

    @JsonProperty(value="descriptions")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDescriptions(List<SimpleDescriptionConsumer> descriptions) {
        this.descriptions = descriptions;
    }

    public RestaurantConsumer multimedias(List<SimpleMultimediaConsumer> multimedias) {
        this.multimedias = multimedias;
        return this;
    }

    public RestaurantConsumer addMultimediasItem(SimpleMultimediaConsumer multimediasItem) {
        this.multimedias.add(multimediasItem);
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="multimedias")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<SimpleMultimediaConsumer> getMultimedias() {
        return this.multimedias;
    }

    @JsonProperty(value="multimedias")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setMultimedias(List<SimpleMultimediaConsumer> multimedias) {
        this.multimedias = multimedias;
    }

    public RestaurantConsumer contact(ContactConsumer contact) {
        this.contact = contact;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="contact")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ContactConsumer getContact() {
        return this.contact;
    }

    @JsonProperty(value="contact")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setContact(ContactConsumer contact) {
        this.contact = contact;
    }

    public RestaurantConsumer address(AddressConsumer address) {
        this.address = address;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public AddressConsumer getAddress() {
        return this.address;
    }

    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAddress(AddressConsumer address) {
        this.address = address;
    }

    public RestaurantConsumer commissionable(Boolean commissionable) {
        this.commissionable = commissionable;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="commissionable")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getCommissionable() {
        return this.commissionable;
    }

    @JsonProperty(value="commissionable")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCommissionable(Boolean commissionable) {
        this.commissionable = commissionable;
    }

    public RestaurantConsumer name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public RestaurantConsumer proximityCode(String proximityCode) {
        this.proximityCode = proximityCode;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="proximityCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getProximityCode() {
        return this.proximityCode;
    }

    @JsonProperty(value="proximityCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setProximityCode(String proximityCode) {
        this.proximityCode = proximityCode;
    }

    public RestaurantConsumer sort(Integer sort) {
        this.sort = sort;
        return this;
    }

    @Nullable
    @JsonProperty(value="sort")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getSort() {
        return this.sort;
    }

    @JsonProperty(value="sort")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSort(Integer sort) {
        this.sort = sort;
    }

    public RestaurantConsumer minAgeAppropriateCode(String minAgeAppropriateCode) {
        this.minAgeAppropriateCode = minAgeAppropriateCode;
        return this;
    }

    @Nullable
    @JsonProperty(value="minAgeAppropriateCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMinAgeAppropriateCode() {
        return this.minAgeAppropriateCode;
    }

    @JsonProperty(value="minAgeAppropriateCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMinAgeAppropriateCode(String minAgeAppropriateCode) {
        this.minAgeAppropriateCode = minAgeAppropriateCode;
    }

    public RestaurantConsumer bookable(Boolean bookable) {
        this.bookable = bookable;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="bookable")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getBookable() {
        return this.bookable;
    }

    @JsonProperty(value="bookable")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setBookable(Boolean bookable) {
        this.bookable = bookable;
    }

    public RestaurantConsumer active(Boolean active) {
        this.active = active;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="active")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getActive() {
        return this.active;
    }

    @JsonProperty(value="active")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setActive(Boolean active) {
        this.active = active;
    }

    public RestaurantConsumer disabilityFeatures(List<String> disabilityFeatures) {
        this.disabilityFeatures = disabilityFeatures;
        return this;
    }

    public RestaurantConsumer addDisabilityFeaturesItem(String disabilityFeaturesItem) {
        if (this.disabilityFeatures == null) {
            this.disabilityFeatures = new ArrayList<String>();
        }
        this.disabilityFeatures.add(disabilityFeaturesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="disabilityFeatures")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getDisabilityFeatures() {
        return this.disabilityFeatures;
    }

    @JsonProperty(value="disabilityFeatures")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDisabilityFeatures(List<String> disabilityFeatures) {
        this.disabilityFeatures = disabilityFeatures;
    }

    public RestaurantConsumer securityFeatures(List<String> securityFeatures) {
        this.securityFeatures = securityFeatures;
        return this;
    }

    public RestaurantConsumer addSecurityFeaturesItem(String securityFeaturesItem) {
        if (this.securityFeatures == null) {
            this.securityFeatures = new ArrayList<String>();
        }
        this.securityFeatures.add(securityFeaturesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="securityFeatures")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getSecurityFeatures() {
        return this.securityFeatures;
    }

    @JsonProperty(value="securityFeatures")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSecurityFeatures(List<String> securityFeatures) {
        this.securityFeatures = securityFeatures;
    }

    public RestaurantConsumer socials(List<SocialConsumer> socials) {
        this.socials = socials;
        return this;
    }

    public RestaurantConsumer addSocialsItem(SocialConsumer socialsItem) {
        if (this.socials == null) {
            this.socials = new ArrayList<SocialConsumer>();
        }
        this.socials.add(socialsItem);
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="socials")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SocialConsumer> getSocials() {
        return this.socials;
    }

    @JsonProperty(value="socials")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSocials(List<SocialConsumer> socials) {
        this.socials = socials;
    }

    public RestaurantConsumer pricePoint(PricePointEnum pricePoint) {
        this.pricePoint = pricePoint;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="pricePoint")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public PricePointEnum getPricePoint() {
        return this.pricePoint;
    }

    @JsonProperty(value="pricePoint")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPricePoint(PricePointEnum pricePoint) {
        this.pricePoint = pricePoint;
    }

    public RestaurantConsumer recognitionList(List<TravelInventoryRecognitionConsumer> recognitionList) {
        this.recognitionList = recognitionList;
        return this;
    }

    public RestaurantConsumer addRecognitionListItem(TravelInventoryRecognitionConsumer recognitionListItem) {
        if (this.recognitionList == null) {
            this.recognitionList = new ArrayList<TravelInventoryRecognitionConsumer>();
        }
        this.recognitionList.add(recognitionListItem);
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="recognitionList")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<TravelInventoryRecognitionConsumer> getRecognitionList() {
        return this.recognitionList;
    }

    @JsonProperty(value="recognitionList")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRecognitionList(List<TravelInventoryRecognitionConsumer> recognitionList) {
        this.recognitionList = recognitionList;
    }

    public RestaurantConsumer applicableStart(LocalDate applicableStart) {
        this.applicableStart = applicableStart;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="applicableStart")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDate getApplicableStart() {
        return this.applicableStart;
    }

    @JsonProperty(value="applicableStart")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setApplicableStart(LocalDate applicableStart) {
        this.applicableStart = applicableStart;
    }

    public RestaurantConsumer applicableEnd(LocalDate applicableEnd) {
        this.applicableEnd = applicableEnd;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="applicableEnd")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDate getApplicableEnd() {
        return this.applicableEnd;
    }

    @JsonProperty(value="applicableEnd")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setApplicableEnd(LocalDate applicableEnd) {
        this.applicableEnd = applicableEnd;
    }

    public RestaurantConsumer reservationRequiredInd(Boolean reservationRequiredInd) {
        this.reservationRequiredInd = reservationRequiredInd;
        return this;
    }

    @Nullable
    @JsonProperty(value="reservationRequiredInd")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getReservationRequiredInd() {
        return this.reservationRequiredInd;
    }

    @JsonProperty(value="reservationRequiredInd")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReservationRequiredInd(Boolean reservationRequiredInd) {
        this.reservationRequiredInd = reservationRequiredInd;
    }

    public RestaurantConsumer opens(String opens) {
        this.opens = opens;
        return this;
    }

    @Nullable
    @JsonProperty(value="opens")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getOpens() {
        return this.opens;
    }

    @JsonProperty(value="opens")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOpens(String opens) {
        this.opens = opens;
    }

    public RestaurantConsumer closes(String closes) {
        this.closes = closes;
        return this;
    }

    @Nullable
    @JsonProperty(value="closes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCloses() {
        return this.closes;
    }

    @JsonProperty(value="closes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCloses(String closes) {
        this.closes = closes;
    }

    public RestaurantConsumer daysOfWeek(DowPatternGroupConsumer daysOfWeek) {
        this.daysOfWeek = daysOfWeek;
        return this;
    }

    @Nullable
    @Valid
    @JsonProperty(value="daysOfWeek")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public DowPatternGroupConsumer getDaysOfWeek() {
        return this.daysOfWeek;
    }

    @JsonProperty(value="daysOfWeek")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDaysOfWeek(DowPatternGroupConsumer daysOfWeek) {
        this.daysOfWeek = daysOfWeek;
    }

    public RestaurantConsumer maxSeatingCapacity(Integer maxSeatingCapacity) {
        this.maxSeatingCapacity = maxSeatingCapacity;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=1L)
    @JsonProperty(value="maxSeatingCapacity")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=1L) Integer getMaxSeatingCapacity() {
        return this.maxSeatingCapacity;
    }

    @JsonProperty(value="maxSeatingCapacity")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setMaxSeatingCapacity(Integer maxSeatingCapacity) {
        this.maxSeatingCapacity = maxSeatingCapacity;
    }

    public RestaurantConsumer maxSingleParty(Integer maxSingleParty) {
        this.maxSingleParty = maxSingleParty;
        return this;
    }

    @Nonnull
    @NotNull
    @Min(value=1L)
    @JsonProperty(value="maxSingleParty")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Min(value=1L) Integer getMaxSingleParty() {
        return this.maxSingleParty;
    }

    @JsonProperty(value="maxSingleParty")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setMaxSingleParty(Integer maxSingleParty) {
        this.maxSingleParty = maxSingleParty;
    }

    public RestaurantConsumer offerBreakfast(Boolean offerBreakfast) {
        this.offerBreakfast = offerBreakfast;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="offerBreakfast")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getOfferBreakfast() {
        return this.offerBreakfast;
    }

    @JsonProperty(value="offerBreakfast")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setOfferBreakfast(Boolean offerBreakfast) {
        this.offerBreakfast = offerBreakfast;
    }

    public RestaurantConsumer offerLunch(Boolean offerLunch) {
        this.offerLunch = offerLunch;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="offerLunch")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getOfferLunch() {
        return this.offerLunch;
    }

    @JsonProperty(value="offerLunch")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setOfferLunch(Boolean offerLunch) {
        this.offerLunch = offerLunch;
    }

    public RestaurantConsumer offerDinner(Boolean offerDinner) {
        this.offerDinner = offerDinner;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="offerDinner")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getOfferDinner() {
        return this.offerDinner;
    }

    @JsonProperty(value="offerDinner")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setOfferDinner(Boolean offerDinner) {
        this.offerDinner = offerDinner;
    }

    public RestaurantConsumer offerBrunch(Boolean offerBrunch) {
        this.offerBrunch = offerBrunch;
        return this;
    }

    @Nonnull
    @NotNull
    @JsonProperty(value="offerBrunch")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getOfferBrunch() {
        return this.offerBrunch;
    }

    @JsonProperty(value="offerBrunch")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setOfferBrunch(Boolean offerBrunch) {
        this.offerBrunch = offerBrunch;
    }

    public RestaurantConsumer amenities(List<String> amenities) {
        this.amenities = amenities;
        return this;
    }

    public RestaurantConsumer addAmenitiesItem(String amenitiesItem) {
        if (this.amenities == null) {
            this.amenities = new ArrayList<String>();
        }
        this.amenities.add(amenitiesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="amenities")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getAmenities() {
        return this.amenities;
    }

    @JsonProperty(value="amenities")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAmenities(List<String> amenities) {
        this.amenities = amenities;
    }

    public RestaurantConsumer infoCodes(List<String> infoCodes) {
        this.infoCodes = infoCodes;
        return this;
    }

    public RestaurantConsumer addInfoCodesItem(String infoCodesItem) {
        if (this.infoCodes == null) {
            this.infoCodes = new ArrayList<String>();
        }
        this.infoCodes.add(infoCodesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="infoCodes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getInfoCodes() {
        return this.infoCodes;
    }

    @JsonProperty(value="infoCodes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInfoCodes(List<String> infoCodes) {
        this.infoCodes = infoCodes;
    }

    public RestaurantConsumer cuisineCodes(List<String> cuisineCodes) {
        this.cuisineCodes = cuisineCodes;
        return this;
    }

    public RestaurantConsumer addCuisineCodesItem(String cuisineCodesItem) {
        if (this.cuisineCodes == null) {
            this.cuisineCodes = new ArrayList<String>();
        }
        this.cuisineCodes.add(cuisineCodesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="cuisineCodes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getCuisineCodes() {
        return this.cuisineCodes;
    }

    @JsonProperty(value="cuisineCodes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCuisineCodes(List<String> cuisineCodes) {
        this.cuisineCodes = cuisineCodes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RestaurantConsumer restaurantConsumer = (RestaurantConsumer)o;
        return Objects.equals(this.identifier, restaurantConsumer.identifier) && Objects.equals(this.hotelIdentifier, restaurantConsumer.hotelIdentifier) && Objects.equals(this.featuredInd, restaurantConsumer.featuredInd) && Objects.equals((Object)this.lifestyleType, (Object)restaurantConsumer.lifestyleType) && Objects.equals(this.location, restaurantConsumer.location) && Objects.equals(this.descriptions, restaurantConsumer.descriptions) && Objects.equals(this.multimedias, restaurantConsumer.multimedias) && Objects.equals(this.contact, restaurantConsumer.contact) && Objects.equals(this.address, restaurantConsumer.address) && Objects.equals(this.commissionable, restaurantConsumer.commissionable) && Objects.equals(this.name, restaurantConsumer.name) && Objects.equals(this.proximityCode, restaurantConsumer.proximityCode) && Objects.equals(this.sort, restaurantConsumer.sort) && Objects.equals(this.minAgeAppropriateCode, restaurantConsumer.minAgeAppropriateCode) && Objects.equals(this.bookable, restaurantConsumer.bookable) && Objects.equals(this.active, restaurantConsumer.active) && Objects.equals(this.disabilityFeatures, restaurantConsumer.disabilityFeatures) && Objects.equals(this.securityFeatures, restaurantConsumer.securityFeatures) && Objects.equals(this.socials, restaurantConsumer.socials) && Objects.equals((Object)this.pricePoint, (Object)restaurantConsumer.pricePoint) && Objects.equals(this.recognitionList, restaurantConsumer.recognitionList) && Objects.equals(this.applicableStart, restaurantConsumer.applicableStart) && Objects.equals(this.applicableEnd, restaurantConsumer.applicableEnd) && Objects.equals(this.reservationRequiredInd, restaurantConsumer.reservationRequiredInd) && Objects.equals(this.opens, restaurantConsumer.opens) && Objects.equals(this.closes, restaurantConsumer.closes) && Objects.equals(this.daysOfWeek, restaurantConsumer.daysOfWeek) && Objects.equals(this.maxSeatingCapacity, restaurantConsumer.maxSeatingCapacity) && Objects.equals(this.maxSingleParty, restaurantConsumer.maxSingleParty) && Objects.equals(this.offerBreakfast, restaurantConsumer.offerBreakfast) && Objects.equals(this.offerLunch, restaurantConsumer.offerLunch) && Objects.equals(this.offerDinner, restaurantConsumer.offerDinner) && Objects.equals(this.offerBrunch, restaurantConsumer.offerBrunch) && Objects.equals(this.amenities, restaurantConsumer.amenities) && Objects.equals(this.infoCodes, restaurantConsumer.infoCodes) && Objects.equals(this.cuisineCodes, restaurantConsumer.cuisineCodes);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.identifier, this.hotelIdentifier, this.featuredInd, this.lifestyleType, this.location, this.descriptions, this.multimedias, this.contact, this.address, this.commissionable, this.name, this.proximityCode, this.sort, this.minAgeAppropriateCode, this.bookable, this.active, this.disabilityFeatures, this.securityFeatures, this.socials, this.pricePoint, this.recognitionList, this.applicableStart, this.applicableEnd, this.reservationRequiredInd, this.opens, this.closes, this.daysOfWeek, this.maxSeatingCapacity, this.maxSingleParty, this.offerBreakfast, this.offerLunch, this.offerDinner, this.offerBrunch, this.amenities, this.infoCodes, this.cuisineCodes});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RestaurantConsumer {\n");
        sb.append("    identifier: ").append(this.toIndentedString(this.identifier)).append("\n");
        sb.append("    hotelIdentifier: ").append(this.toIndentedString(this.hotelIdentifier)).append("\n");
        sb.append("    featuredInd: ").append(this.toIndentedString(this.featuredInd)).append("\n");
        sb.append("    lifestyleType: ").append(this.toIndentedString((Object)this.lifestyleType)).append("\n");
        sb.append("    location: ").append(this.toIndentedString(this.location)).append("\n");
        sb.append("    descriptions: ").append(this.toIndentedString(this.descriptions)).append("\n");
        sb.append("    multimedias: ").append(this.toIndentedString(this.multimedias)).append("\n");
        sb.append("    contact: ").append(this.toIndentedString(this.contact)).append("\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    commissionable: ").append(this.toIndentedString(this.commissionable)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    proximityCode: ").append(this.toIndentedString(this.proximityCode)).append("\n");
        sb.append("    sort: ").append(this.toIndentedString(this.sort)).append("\n");
        sb.append("    minAgeAppropriateCode: ").append(this.toIndentedString(this.minAgeAppropriateCode)).append("\n");
        sb.append("    bookable: ").append(this.toIndentedString(this.bookable)).append("\n");
        sb.append("    active: ").append(this.toIndentedString(this.active)).append("\n");
        sb.append("    disabilityFeatures: ").append(this.toIndentedString(this.disabilityFeatures)).append("\n");
        sb.append("    securityFeatures: ").append(this.toIndentedString(this.securityFeatures)).append("\n");
        sb.append("    socials: ").append(this.toIndentedString(this.socials)).append("\n");
        sb.append("    pricePoint: ").append(this.toIndentedString((Object)this.pricePoint)).append("\n");
        sb.append("    recognitionList: ").append(this.toIndentedString(this.recognitionList)).append("\n");
        sb.append("    applicableStart: ").append(this.toIndentedString(this.applicableStart)).append("\n");
        sb.append("    applicableEnd: ").append(this.toIndentedString(this.applicableEnd)).append("\n");
        sb.append("    reservationRequiredInd: ").append(this.toIndentedString(this.reservationRequiredInd)).append("\n");
        sb.append("    opens: ").append(this.toIndentedString(this.opens)).append("\n");
        sb.append("    closes: ").append(this.toIndentedString(this.closes)).append("\n");
        sb.append("    daysOfWeek: ").append(this.toIndentedString(this.daysOfWeek)).append("\n");
        sb.append("    maxSeatingCapacity: ").append(this.toIndentedString(this.maxSeatingCapacity)).append("\n");
        sb.append("    maxSingleParty: ").append(this.toIndentedString(this.maxSingleParty)).append("\n");
        sb.append("    offerBreakfast: ").append(this.toIndentedString(this.offerBreakfast)).append("\n");
        sb.append("    offerLunch: ").append(this.toIndentedString(this.offerLunch)).append("\n");
        sb.append("    offerDinner: ").append(this.toIndentedString(this.offerDinner)).append("\n");
        sb.append("    offerBrunch: ").append(this.toIndentedString(this.offerBrunch)).append("\n");
        sb.append("    amenities: ").append(this.toIndentedString(this.amenities)).append("\n");
        sb.append("    infoCodes: ").append(this.toIndentedString(this.infoCodes)).append("\n");
        sb.append("    cuisineCodes: ").append(this.toIndentedString(this.cuisineCodes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum PricePointEnum {
        HALF("HALF"),
        ONE("ONE"),
        ONE_HALF("ONE_HALF"),
        TWO("TWO"),
        TWO_HALF("TWO_HALF"),
        THREE("THREE"),
        THREE_HALF("THREE_HALF"),
        FOUR("FOUR"),
        FOUR_HALF("FOUR_HALF"),
        FIVE("FIVE");

        private String value;

        private PricePointEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PricePointEnum fromValue(String value) {
            for (PricePointEnum b : PricePointEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum LifestyleTypeEnum {
        HEALTH_FITNESS("LIFESTYLE_HEALTH_FITNESS"),
        RELAX("LIFESTYLE_RELAX"),
        ADULT_ONLY("LIFESTYLE_ADULT_ONLY"),
        ADVENTURE("LIFESTYLE_ADVENTURE"),
        BUSINESS("LIFESTYLE_BUSINESS"),
        LGBT("LIFESTYLE_LGBT"),
        SINGLE_PARENT("LIFESTYLE_SINGLE_PARENT"),
        SOLO_FEMALE("LIFESTYLE_SOLO_FEMALE"),
        BEAUTY("LIFESTYLE_BEAUTY"),
        FOODIE("LIFESTYLE_FOODIE"),
        FAMILY("LIFESTYLE_FAMILY"),
        ROMANCE("LIFESTYLE_ROMANCE"),
        COUPLE("LIFESTYLE_COUPLE"),
        SOLO("LIFESTYLE_SOLO"),
        BACKPACKER("LIFESTYLE_BACKPACKER"),
        SHOPPING("LIFESTYLE_SHOPPING"),
        SPORTS("LIFESTYLE_SPORTS"),
        MOUNTAIN("LIFESTYLE_MOUNTAIN"),
        BEACH("LIFESTYLE_BEACH"),
        CITY("LIFESTYLE_CITY"),
        COUNTRY("LIFESTYLE_COUNTRY"),
        CULTURE("LIFESTYLE_CULTURE"),
        ECO("LIFESTYLE_ECO");

        private String value;

        private LifestyleTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static LifestyleTypeEnum fromValue(String value) {
            for (LifestyleTypeEnum b : LifestyleTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

